/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.FailedPartitions;
import kafka.server.FetcherMetrics$;
import kafka.server.FetcherThreadTestUtils$;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.MockFetcherThread;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockLeaderEndPoint$;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionState;
import kafka.server.PartitionState$;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004E\u0001\u0001\u0006I!\u0011\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019\u0001\u0007\u0001)A\u0005\u000f\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\r1\u0004\u0001\u0015!\u0003j\u0011\u001di\u0007A1A\u0005\n!DaA\u001c\u0001!\u0002\u0013I\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B9\t\u000bU\u0004A\u0011\u0001<\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!1\u0011\u0011\u0006\u0001\u0005\u0002YDa!a\r\u0001\t\u00031\bBBA\u001c\u0001\u0011\u0005a\u000f\u0003\u0004\u0002<\u0001!\tA\u001e\u0005\u0007\u0003\u007f\u0001A\u0011\u0001<\t\r\u0005\r\u0003\u0001\"\u0001w\u0011\u0019\t9\u0005\u0001C\u0001m\"1\u00111\n\u0001\u0005\u0002YDa!a\u0014\u0001\t\u00031\bBBA*\u0001\u0011\u0005a\u000f\u0003\u0004\u0002X\u0001!\tA\u001e\u0005\u0007\u00037\u0002A\u0011\u0001<\t\r\u0005}\u0003\u0001\"\u0001w\u0011\u0019\t\u0019\u0007\u0001C\u0001m\"1\u0011q\r\u0001\u0005\u0002YDa!a\u001b\u0001\t\u00031\bBBA8\u0001\u0011\u0005a\u000f\u0003\u0004\u0002t\u0001!\tA\u001e\u0005\u0007\u0003o\u0002A\u0011\u0001<\t\r\u0005m\u0004\u0001\"\u0001w\u0011\u0019\ty\b\u0001C\u0001m\"9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005BBAI\u0001\u0011\u0005a\u000f\u0003\u0004\u0002\u0016\u0002!\tA\u001e\u0005\u0007\u00033\u0003A\u0011\u0001<\t\r\u0005u\u0005\u0001\"\u0001w\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCa!a,\u0001\t\u00031\bBBAZ\u0001\u0011\u0005a\u000f\u0003\u0004\u00028\u0002!\tA\u001e\u0002\u001a\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e)\u0016\u001cHO\u0003\u00021c\u000511/\u001a:wKJT\u0011AM\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0002\"A\u0010\u0001\u000e\u0003=\nq\u0002\u001e:v]\u000e\fG/Z(o\r\u0016$8\r[\u000b\u0002\u0003B\u0011aGQ\u0005\u0003\u0007^\u0012qAQ8pY\u0016\fg.\u0001\tueVt7-\u0019;f\u001f:4U\r^2iA\u0005AAo\u001c9jG&#7/F\u0001H!\u0011A5*T+\u000e\u0003%S!AS\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002M\u0013\n\u0019Q*\u00199\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016\u0001\u00027b]\u001eT\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\n11\u000b\u001e:j]\u001e\u0004\"A\u00160\u000e\u0003]S!\u0001W-\u0002\r\r|W.\\8o\u0015\t\u0011$L\u0003\u0002\\9\u00061\u0011\r]1dQ\u0016T\u0011!X\u0001\u0004_J<\u0017BA0X\u0005\u0011)V/\u001b3\u0002\u0013Q|\u0007/[2JIN\u0004\u0013a\u0002<feNLwN\\\u000b\u0002GB\u0011a\u0007Z\u0005\u0003K^\u0012Qa\u00155peR\f\u0001B^3sg&|g\u000eI\u0001\u000ba\u0006\u0014H/\u001b;j_:\fT#A5\u0011\u0005YS\u0017BA6X\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0002]1si&$\u0018n\u001c82A\u0005Q\u0001/\u0019:uSRLwN\u001c\u001a\u0002\u0017A\f'\u000f^5uS>t'\u0007I\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N,\u0012!\u001d\t\u0003}IL!a]\u0018\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00054bS2,G\rU1si&$\u0018n\u001c8tA\u0005\u00192\r\\3b]6+GO]5d%\u0016<\u0017n\u001d;ssR\tq\u000f\u0005\u00027q&\u0011\u0011p\u000e\u0002\u0005+:LG\u000f\u000b\u0002\u000fwB\u0019A0a\u0002\u000e\u0003uT!A`@\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0002\u0005\r\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003\u000ba\u0016!\u00026v]&$\u0018bAA\u0005{\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001f\u0005dG.T3ue&\u001c7OT1nKN,\"!a\u0004\u0011\u000b!\u000b\t\"!\u0006\n\u0007\u0005M\u0011JA\u0002TKR\u0004B!a\u0006\u0002&9!\u0011\u0011DA\u0011!\r\tYbN\u0007\u0003\u0003;Q1!a\b4\u0003\u0019a$o\\8u}%\u0019\u00111E\u001c\u0002\rA\u0013X\rZ3g\u0013\r!\u0016q\u0005\u0006\u0004\u0003G9\u0014\u0001\b;fgRlU\r\u001e:jGN\u0014V-\\8wK\u0012|en\u00155vi\u0012|wO\u001c\u0015\u0004!\u00055\u0002c\u0001?\u00020%\u0019\u0011\u0011G?\u0003\tQ+7\u000f^\u0001$i\u0016\u001cHoQ8ogVlWM\u001d'bOJ+Wn\u001c<fI^KG\u000f\u001b)beRLG/[8oQ\r\t\u0012QF\u0001\u0010i\u0016\u001cHoU5na2,g)\u001a;dQ\"\u001a!#!\f\u0002\u0013Q,7\u000f\u001e#fY\u0006L\bfA\n\u0002.\u0005)B/Z:u!\u0006\u0014H/\u001b;j_:\u001c\u0018J\\#se>\u0014\bf\u0001\u000b\u0002.\u0005!B/Z:u\r\u0016t7-\u001a3UeVt7-\u0019;j_:D3!FA\u0017\u0003=!Xm\u001d;GK:\u001cW\r\u001a$fi\u000eD\u0007f\u0001\f\u0002.\u0005\u0011C/Z:u+:\\gn\\<o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00138UeVt7-\u0019;j_:D3aFA\u0017\u0003\r\"Xm\u001d;V].twn\u001e8MK\u0006$WM]#q_\u000eDw\u000b[5mK\u001a+Go\u00195j]\u001eD3\u0001GA\u0017\u00039!Xm\u001d;UeVt7-\u0019;j_:D3!GA\u0017\u0003a\"Xm\u001d;UeVt7-\u0019;f)>D\u0015n\u001a5XCR,'/\\1sW&3G*Z1eKJ,\u0005o\\2i\u0013:4wNT8u\u0003Z\f\u0017\u000e\\1cY\u0016D3AGA\u0017\u0003E\"Xm\u001d;UeVt7-\u0019;f)>D\u0015n\u001a5XCR,'/\\1sW\u0012+(/\u001b8h%\u0016lwN^3QCJ$\u0018\u000e^5p]ND3aGA\u0017\u0003\u0011\"Xm\u001d;UeVt7-\u0019;j_:\u001c6.\u001b9qK\u0012LeMT8Fa>\u001c\u0007n\u00115b]\u001e,\u0007f\u0001\u000f\u0002.\u0005qC/Z:u)J,hnY1uS>twJ\u001c$fi\u000eD7k[5qa\u0016$\u0017J\u001a)beRLG/[8o%\u0016lwN^3eQ\ri\u0012QF\u0001 i\u0016\u001cHOR8mY><XM\u001d$fi\u000eDw*\u001e;PMJ\u000bgnZ3IS\u001eD\u0007f\u0001\u0010\u0002.\u0005!C/Z:u\r\u0016t7-\u001a3PM\u001a\u001cX\r\u001e*fg\u0016$\u0018I\u001a;fe>+Ho\u00144SC:<W\rK\u0002 \u0003[\ta\u0004^3ti\u001a{G\u000e\\8xKJ4U\r^2i\u001fV$xJ\u001a*b]\u001e,Gj\\<)\u0007\u0001\ni#A\u001auKN$(+\u001a;ss\u00063G/\u001a:V].twn\u001e8MK\u0006$WM]#q_\u000eD\u0017J\u001c'bi\u0016\u001cHo\u00144gg\u0016$h)\u001a;dQ\"\u001a\u0011%!\f\u0002%Q,7\u000f^\"peJ,\b\u000f^'fgN\fw-\u001a\u0015\u0004E\u00055\u0012A\u000e;fgRdU-\u00193fe\u0016\u0003xn\u00195DQ\u0006tw-\u001a#ve&twMR3oG\u0016$g)\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014\bfA\u0012\u0002.\u0005QD/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e\u001cVoY2fgN4W\u000f\u001c$fi\u000eDW\t]8dQN4%o\\7MK\u0006$WM\u001d\u0015\u0004I\u00055\u0012\u0001\r;fgRdU-\u00193fe\u0016\u0003xn\u00195DQ\u0006tw-\u001a#ve&twMR3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'\u000fF\u0002x\u0003\u000fCq!!#&\u0001\u0004\tY)A\nmK\u0006$WM]#q_\u000eDwJ\u001c'fC\u0012,'\u000fE\u00027\u0003\u001bK1!a$8\u0005\rIe\u000e^\u00014i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+p\u000bB|7\r[#oI>3gm]3ug\u0012+(/\u001b8h%\u0016lwN^3QCJ$\u0018\u000e^5p]ND3AJA\u0017\u0003=#Xm\u001d;UeVt7-\u0019;j_:$\u0006N]8xg\u0016C8-\u001a9uS>t\u0017J\u001a'fC\u0012,'OU3ukJt7\u000fU1si&$\u0018n\u001c8t\u001d>$(+Z9vKN$X\rZ%o\r\u0016$8\r[#q_\u000eD7\u000fK\u0002(\u0003[\t\u0001\b^3ti\u001a+Go\u00195feRC'/Z1e\u0011\u0006tG\r\\5oOB\u000b'\u000f^5uS>tg)Y5mkJ,G)\u001e:j]\u001e\f\u0005\u000f]3oI&tw\rK\u0002)\u0003[\t\u0011\b^3ti\u001a+Go\u00195feRC'/Z1e\u0011\u0006tG\r\\5oOB\u000b'\u000f^5uS>tg)Y5mkJ,G)\u001e:j]\u001e$&/\u001e8dCRLwN\u001c\u0015\u0004S\u00055\u0012a\u000b<fe&4\u0017PR3uG\",'\u000f\u00165sK\u0006$\u0007*\u00198eY&tw\rU1si&$\u0018n\u001c8GC&dWO]3\u0015\u0007]\f)\u000bC\u0004\u0002(*\u0002\r!!+\u0002\u000f\u0019,Go\u00195feB\u0019a(a+\n\u0007\u00055vFA\tN_\u000e\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f1\u0003^3ti\u0012Kg/\u001a:hS:<W\t]8dQND3aKA\u0017\u00039\"Xm\u001d;UeVt7-\u0019;f\u001f:4U\r^2i\t>,7OT8u!J|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1)\u00071\ni#A\fuKN$X*Y=cKV\u0003H-\u0019;f)>\u0004\u0018nY%eg\"\u001aQ&!\f")
public class AbstractFetcherThreadTest {
    private final boolean truncateOnFetch;
    private final Map<String, Uuid> topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)Uuid.randomUuid())}));
    private final short version = ApiKeys.FETCH.latestVersion();
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic2", 0);
    private final FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions = new FailedPartitions();

    public boolean truncateOnFetch() {
        return this.truncateOnFetch;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public short version() {
        return this.version;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    public FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$AbstractFetcherThreadTest$$failedPartitions;
    }

    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Set<String> allMetricsNames() {
        return (Set)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().map((Function1 & Serializable)x$1 -> x$1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$22 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$22);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.start();
        scala.collection.mutable.Set brokerTopicStatsMetrics = CollectionConverters$.MODULE$.SetHasAsScala(fetcher.brokerTopicStats().allTopicsStats().metricMapKeySet()).asScala();
        Set fetcherMetrics = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$2(this, brokerTopicStatsMetrics, fetcherMetrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed waiting for all fetcher metrics to be registered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.shutdown();
        scala.collection.immutable.Set metricNames = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().map((Function1 & Serializable)x$2 -> x$2.getName())).toSet();
        Assertions.assertTrue((boolean)metricNames.intersect(fetcherMetrics).isEmpty());
        Assertions.assertEquals((Object)brokerTopicStatsMetrics, (Object)metricNames.intersect((Set)brokerTopicStatsMetrics));
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()), (String)"Failed waiting for consumer lag metric");
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testDelay() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                throw new UnknownTopicIdException("Topic ID was unknown as expected for this test");
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        int x$4 = 0;
        int x$5 = 1;
        FailedPartitions x$6 = new FailedPartitions();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$4, x$5, fetchBackOffMs, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        long timeBeforeFirst = System.currentTimeMillis();
        fetcher.doWork();
        long firstWorkDuration = System.currentTimeMillis() - timeBeforeFirst;
        long timeBeforeSecond = System.currentTimeMillis();
        fetcher.doWork();
        long secondWorkDuration = System.currentTimeMillis() - timeBeforeSecond;
        Assertions.assertTrue((firstWorkDuration < secondWorkDuration ? 1 : 0) != 0);
        Assertions.assertTrue(((long)fetchBackOffMs <= secondWorkDuration ? 1 : 0) != 0, (String)("secondWorkDuration: " + secondWorkDuration + " was not greater than or equal to fetchBackOffMs: " + fetchBackOffMs));
    }

    @Test
    public void testPartitionsInError() {
        TopicPartition partition1 = new TopicPartition("topic1", 0);
        TopicPartition partition2 = new TopicPartition("topic2", 0);
        TopicPartition partition3 = new TopicPartition("topic3", 0);
        int fetchBackOffMs = 250;
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this, partition1, partition2, partition3){
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final TopicPartition partition3$1;

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                return (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition1$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition3$1), (Object)new FetchResponseData.PartitionData().setErrorCode(Errors.NONE.code()))}));
            }
            {
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.partition3$1 = partition3$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        int x$4 = 0;
        int x$5 = 1;
        FailedPartitions x$6 = new FailedPartitions();
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, x$4, x$5, fetchBackOffMs, x$6);
        fetcher.setReplicaState(partition1, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition2, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        fetcher.setReplicaState(partition3, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition1, leaderState);
        fetcher.mockLeader().setLeaderState(partition2, leaderState);
        fetcher.mockLeader().setLeaderState(partition3, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Option partition1FetchState = fetcher.fetchState(partition1);
        Option partition2FetchState = fetcher.fetchState(partition2);
        Option partition3FetchState = fetcher.fetchState(partition3);
        Assertions.assertTrue((boolean)partition1FetchState.isDefined());
        Assertions.assertTrue((boolean)partition2FetchState.isDefined());
        Assertions.assertTrue((boolean)partition3FetchState.isDefined());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition1FetchState.get()).isDelayed());
        Assertions.assertTrue((boolean)((PartitionFetchState)partition2FetchState.get()).isDelayed());
        Assertions.assertFalse((boolean)((PartitionFetchState)partition3FetchState.get()).isDelayed());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 1, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$32 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$32, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$9 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$9, x$6);
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))}))), true);
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$3 -> x$3.state()));
        PartitionState partitionState = fetcher.mockLeader().leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        PartitionState replicaState = PartitionState$.MODULE$.apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 1))})));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)Nil$.MODULE$)), 1, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$5 -> x$5.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$6 -> x$6.state()));
        fetcher.mockLeader().leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$7 -> x$7.state()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 3, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncation$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                throw new UnsupportedOperationException();
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndPoint, mockTierStateMachine, highWatermark){
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assertions.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assertions.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super(mockLeaderEndPoint$1, mockTierStateMachine$1, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assertions.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super(mockLeaderEndpoint$1, mockTierStateMachine$2, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, highWatermark, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), highWatermark, 5))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super(mockLeaderEndpoint$2, mockTierStateMachine$3, 0, 1, 0, new FailedPartitions());
            }
        };
        PartitionState replicaState = PartitionState$.MODULE$.apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 5))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 1, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 3, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((int)1, (int)truncations.elem);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testTruncationOnFetchSkippedIfPartitionRemoved() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, truncations){
            private final IntRef truncations$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$2.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$2 = truncations$2;
                super(mockLeaderEndpoint$3, mockTierStateMachine$4, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 2L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)new Some((Object)Uuid.randomUuid()), 6L, 4))})));
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(3L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)endOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
        Map offsets = fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)offsets.keySet());
        Assertions.assertEquals((long)3L, (long)((PartitionFetchState)offsets.apply((Object)partition)).fetchOffset());
        OffsetForLeaderEpochResponseData.EpochEndOffset newEndOffset = new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(2L);
        fetcher.truncateOnFetchResponse((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)newEndOffset)})));
        Assertions.assertEquals((int)1, (int)truncations.elem);
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$8 -> x$8.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException("Epoch " + leaderEpoch + " is fenced");
            }

            public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException("Epoch " + leaderEpoch + " is fenced");
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        FailedPartitions x$3 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$4 = 0;
        int x$5 = 1;
        int x$6 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, x$4, x$5, x$6, x$3);
        Nil$ replicaLog = Nil$.MODULE$;
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 4, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 4))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 4, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assertions.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assertions.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        FailedPartitions x$6 = this.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
        int x$7 = 0;
        int x$8 = 1;
        int x$92 = 0;
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, x$7, x$8, x$92, x$6);
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 0, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        if (this.truncateOnFetch()) {
            fetcher.doWork();
        }
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$9 -> x$9.state()));
        Assertions.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private final AtomicInteger tries;

            public AtomicInteger tries() {
                return this.tries;
            }

            public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffset(topicPartition, leaderEpoch);
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.tries = new AtomicInteger(0);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)Nil$.MODULE$);
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 0, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 0))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$10 -> x$10.state()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assertions.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
                Map<TopicPartition, FetchResponseData.PartitionData> fetchedData = super.fetch(fetchRequest);
                if (!this.fetchedOnce()) {
                    ByteBuffer buffer = ((MemoryRecords)((FetchResponseData.PartitionData)((Tuple2)fetchedData.head())._2()).records()).buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return fetchedData;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchedOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))})));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        RecordBatch batch = FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)new .colon.colon((Object)batch, (List)Nil$.MODULE$), 0, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assertions.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 1);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){
            private boolean fetchEpochsFromLeaderOnce;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                if (!this.fetchEpochsFromLeaderOnce()) {
                    this.responseCallback().apply$mcV$sp();
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))}))), true);
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.changeLeaderEpochWhileFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$11 -> x$11.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, false));
        }
        fetcher.doWork();
        Assertions.assertEquals(fetcher.mockLeader().leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.responseCallback().apply$mcV$sp();
                return fetchedEpochs;
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, initialLeaderEpochOnFollower))})));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$);
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setResponseCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AbstractFetcherThreadTest.changeLeaderEpochDuringFetchEpoch$1(fetcher, partition, nextLeaderEpochOnFollower));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$13 -> x$13.state()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.currentLeaderEpoch())));
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L, false));
        fetcher.doWork();
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockLeaderEndPoint mockLeaderEndPoint = new MockLeaderEndPoint(this){

            public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return (Map)super.fetchEpochEndOffsets(partitions).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(unrequestedTp.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(0L)));
            }
            {
                boolean x$1 = $outer.truncateOnFetch();
                short x$2 = $outer.version();
                BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
                super(x$3, x$1, x$2);
            }
        };
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndPoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndPoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        Assertions.assertThrows(IllegalStateException.class, () -> fetcher.doWork());
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringAppending() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcherForAppend = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new KafkaException();
                }
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = 0;
                int x$5 = 1;
                int x$6 = 0;
                super(mockLeaderEndpoint$4, mockTierStateMachine$5, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForAppend);
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringTruncation() {
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcherForTruncation = new MockFetcherThread(this, mockLeaderEndpoint, mockTierStateMachine){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new Exception();
                }
                super.truncate(topicPartition, truncationState);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                FailedPartitions x$3 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
                int x$4 = 0;
                int x$5 = 1;
                int x$6 = 0;
                super(mockLeaderEndpoint$5, mockTierStateMachine$6, x$4, x$5, x$6, x$3);
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForTruncation);
    }

    private void verifyFetcherThreadHandlingPartitionFailure(MockFetcherThread fetcher) {
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), PartitionState$.MODULE$.apply(0));
        fetcher.setReplicaState(this.partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition2()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.partition2().topic()), 0L, 0))}))), true);
        fetcher.mockLeader().setLeaderState(this.partition2(), PartitionState$.MODULE$.apply(0));
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        fetcher.doWork();
        Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(this.partition2()).map((Function1 & Serializable)x$15 -> x$15.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.partition2()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().removeAll((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        fetcher.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1()), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1().topic()), 0L, 1))}))), true);
        Assertions.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()).map((Function1 & Serializable)x$16 -> x$16.state()));
        Assertions.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDivergingEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 0L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)Nil$.MODULE$)));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 2L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testDivergingEpochs$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateOnFetchDoesNotProcessPartitionData() {
        Assumptions.assumeTrue((boolean)this.truncateOnFetch());
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncateCalls = IntRef.create((int)0);
        IntRef processPartitionDataCalls = IntRef.create((int)0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(null, mockLeaderEndpoint, mockTierStateMachine, processPartitionDataCalls, truncateCalls){
            private final IntRef processPartitionDataCalls$1;
            private final IntRef truncateCalls$1;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                ++this.processPartitionDataCalls$1.elem;
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncateCalls$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.processPartitionDataCalls$1 = processPartitionDataCalls$1;
                this.truncateCalls$1 = truncateCalls$1;
                super(mockLeaderEndpoint$6, mockTierStateMachine$7, 0, 1, 0, new FailedPartitions());
            }
        };
        .colon.colon replicaLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(3L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(4L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("e".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(5L, 4, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("f".getBytes())})), (List)Nil$.MODULE$))))));
        PartitionState replicaState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)replicaLog, 5, 1L, false);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition.topic()), 3L, 5))})));
        Assertions.assertEquals((long)6L, (long)replicaState.logEndOffset());
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)4)));
        .colon.colon leaderLog = new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(0L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(1L, 0, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(2L, 2, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(3L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("g".getBytes())})), (List)new .colon.colon((Object)FetcherThreadTestUtils$.MODULE$.mkBatch(4L, 5, (Seq<SimpleRecord>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("h".getBytes())})), (List)Nil$.MODULE$)))));
        PartitionState leaderState = PartitionState$.MODULE$.apply((Seq<RecordBatch>)leaderLog, 5, 4L, false);
        fetcher.mockLeader().setLeaderState(partition, leaderState);
        fetcher.mockLeader().setReplicaPartitionStateCallback((Function1<TopicPartition, PartitionState>)(Function1 & Serializable)topicPartition -> fetcher.replicaPartitionState((TopicPartition)topicPartition));
        fetcher.doWork();
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertEquals((int)0, (int)processPartitionDataCalls.elem);
        Assertions.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)1L, (long)replicaState.highWatermark());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to reconcile leader and follower logs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.verifyLastFetchedEpoch(partition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Assertions.assertEquals((int)1, (int)truncateCalls.elem);
        Assertions.assertTrue((processPartitionDataCalls.elem >= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((long)5L, (long)replicaState.logEndOffset());
        Assertions.assertEquals((long)4L, (long)replicaState.highWatermark());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        TopicPartition partition = new TopicPartition("topic1", 0);
        boolean x$1 = this.truncateOnFetch();
        short x$2 = this.version();
        BrokerEndPoint x$3 = MockLeaderEndPoint$.MODULE$.$lessinit$greater$default$1();
        MockLeaderEndPoint mockLeaderEndpoint = new MockLeaderEndPoint(x$3, x$1, x$2);
        MockTierStateMachine mockTierStateMachine = new MockTierStateMachine(mockLeaderEndpoint);
        MockFetcherThread fetcher = new MockFetcherThread(mockLeaderEndpoint, mockTierStateMachine, 0, 1, 0, new FailedPartitions());
        fetcher.setReplicaState(partition, PartitionState$.MODULE$.apply(0));
        fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)None$.MODULE$, 0L, 0))})));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), (Option)None$.MODULE$);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Function1 & Serializable)topicName -> this.topicIds().get(topicName));
        AbstractFetcherThreadTest.verifyFetchState$1(fetcher.fetchState(partition), this.topicIds().get((Object)partition.topic()));
        TopicPartition unknownPartition = new TopicPartition("unknown", 0);
        fetcher.maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition})), (Function1 & Serializable)topicName -> this.topicIds().get(topicName));
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownPartition).isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsRemovedOnShutdown$2(AbstractFetcherThreadTest $this, scala.collection.mutable.Set brokerTopicStatsMetrics$1, Set fetcherMetrics$1) {
        Set<String> set = $this.allMetricsNames();
        SetOps setOps = brokerTopicStatsMetrics$1.$plus$plus((IterableOnce)fetcherMetrics$1);
        return !(set != null ? !set.equals((Object)setOps) : setOps != null);
    }

    public static final /* synthetic */ String $anonfun$testMetricsRemovedOnShutdown$3() {
        return "Failed waiting for all fetcher metrics to be registered";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncation$2(MockFetcherThread fetcher$10, TopicPartition partition$1) {
        fetcher$10.doWork();
        Buffer<RecordBatch> buffer = fetcher$10.replicaPartitionState(partition$1).log();
        Buffer<RecordBatch> buffer2 = fetcher$10.mockLeader().leaderPartitionState(partition$1).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncation$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerFetchOutOfRangeLow$3(MockFetcherThread fetcher$16, TopicPartition partition$3) {
        fetcher$16.doWork();
        Buffer<RecordBatch> buffer = fetcher$16.replicaPartitionState(partition$3).log();
        Buffer<RecordBatch> buffer2 = fetcher$16.mockLeader().leaderPartitionState(partition$3).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFollowerFetchOutOfRangeLow$4() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(MockFetcherThread fetcher$17, TopicPartition partition$4) {
        fetcher$17.doWork();
        Buffer<RecordBatch> buffer = fetcher$17.replicaPartitionState(partition$4).log();
        Buffer<RecordBatch> buffer2 = fetcher$17.mockLeader().leaderPartitionState(partition$4).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$4() {
        return "Failed to reconcile leader and follower logs";
    }

    private final void changeLeaderEpochWhileFetchEpoch$1(MockFetcherThread fetcher$19, TopicPartition partition$5, int nextLeaderEpochOnFollower$1) {
        fetcher$19.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$5})));
        fetcher$19.setReplicaState(partition$5, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$1));
        fetcher$19.addPartitions((Map<TopicPartition, InitialFetchState>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition$5), (Object)FetcherThreadTestUtils$.MODULE$.initialFetchState((Option<Uuid>)this.topicIds().get((Object)partition$5.topic()), 0L, nextLeaderEpochOnFollower$1))}))), true);
    }

    private static final void changeLeaderEpochDuringFetchEpoch$1(MockFetcherThread fetcher$20, TopicPartition partition$6, int nextLeaderEpochOnFollower$2) {
        fetcher$20.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$6})));
        fetcher$20.setReplicaState(partition$6, PartitionState$.MODULE$.apply(nextLeaderEpochOnFollower$2));
    }

    public static final /* synthetic */ boolean $anonfun$testDivergingEpochs$2(MockFetcherThread fetcher$23, TopicPartition partition$7) {
        fetcher$23.doWork();
        Buffer<RecordBatch> buffer = fetcher$23.replicaPartitionState(partition$7).log();
        Buffer<RecordBatch> buffer2 = fetcher$23.mockLeader().leaderPartitionState(partition$7).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDivergingEpochs$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$2(MockFetcherThread fetcher$24, TopicPartition partition$8) {
        fetcher$24.doWork();
        Buffer<RecordBatch> buffer = fetcher$24.replicaPartitionState(partition$8).log();
        Buffer<RecordBatch> buffer2 = fetcher$24.mockLeader().leaderPartitionState(partition$8).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncateOnFetchDoesNotProcessPartitionData$3() {
        return "Failed to reconcile leader and follower logs";
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public AbstractFetcherThreadTest() {
        this.truncateOnFetch = true;
    }
}

