/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.TierStateMachine;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=h\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\u0002yBQa\u0014\u0001\u0005\nACQ!\u0019\u0001\u0005\u0002yBQA\u001a\u0001\u0005\u0002yBQ\u0001\u001b\u0001\u0005\u0002yBQA\u001b\u0001\u0005\u0002yBQ\u0001\u001c\u0001\u0005\u0002yBQA\u001c\u0001\u0005\u0002yBQ\u0001\u001d\u0001\u0005\nEDqa\u001f\u0001\u0012\u0002\u0013%A\u0010C\u0004\u0002\u0010\u0001!I!!\u0005\t\u0013\u0005u\u0002!%A\u0005\n\u0005}\u0002bBA\"\u0001\u0011%\u0011Q\t\u0004\u0007\u0003\u001b\u0002A!a\u0014\t\u0015\u0005]sB!A!\u0002\u0013\tI\u0006\u0003\u0004:\u001f\u0011\u0005\u0011q\r\u0005\u0007\u0003_zA\u0011\t \t\r\u0005Et\u0002\"\u0011?\u0011\u001d\t\u0019h\u0004C!\u0003kBq!a\u001e\u0010\t\u0003\nI\bC\u0004\u0002\">!\t%a)\t\u000f\u0005]v\u0002\"\u0011\u0002:\"9\u0011qX\b\u0005B\u0005\u0005\u0007bBA|\u001f\u0011\u0005\u0013\u0011 \u0005\n\u0005Sy!\u0019!C!\u0005WA\u0001Ba\r\u0010A\u0003%!Q\u0006\u0005\b\u0005kyA\u0011\tB\u001c\r\u0019\u0011i\u0004\u0001\u0003\u0003@!1\u0011(\bC\u0001\u0005\u000fBqAa\u0013\u001e\t\u0003\u0012iE\u0002\u0004\u0003h\u0001!!\u0011\u000e\u0005\u000b\u0003/\u0002#\u0011!Q\u0001\n\u0005e\u0003B\u0003B9A\t\u0005\t\u0015!\u0003\u0003t!Q!\u0011\u0010\u0011\u0003\u0002\u0003\u0006IA!\u0011\t\re\u0002C\u0011\u0001B>\u0011\u001d\u0011)\t\tC)\u0005\u000fCqA!.!\t#\u00129\fC\u0004\u0003F\u0002\"\tFa2\t\u000f\t=\u0007\u0005\"\u0015\u0003R\"9!q\u001b\u0011\u0005R\te\u0007b\u0002BoA\u0011E#q\u001c\u0005\b\u0005G\u0004C\u0011\u000bBs\u0005i\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014H+Z:u\u0015\tqs&\u0001\u0004tKJ4XM\u001d\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003y\u0001i\u0011!L\u0001\u0014G2,\u0017M\\'fiJL7MU3hSN$(/\u001f\u000b\u0002\u007fA\u0011A\u0007Q\u0005\u0003\u0003V\u0012A!\u00168ji\"\u0012!a\u0011\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\tA\u0015*A\u0004kkBLG/\u001a:\u000b\u0005)[\u0015!\u00026v]&$(\"\u0001'\u0002\u0007=\u0014x-\u0003\u0002O\u000b\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001d\u001d,G/T3ue&\u001cg+\u00197vKR\u0011\u0011\u000b\u0016\t\u0003iIK!aU\u001b\u0003\u0007\u0005s\u0017\u0010C\u0003V\u0007\u0001\u0007a+\u0001\u0003oC6,\u0007CA,_\u001d\tAF\f\u0005\u0002Zk5\t!L\u0003\u0002\\c\u00051AH]8pizJ!!X\u001b\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;V\n\u0011\u0004^3ti\u0006#G-\u00118e%\u0016lwN^3QCJ$\u0018\u000e^5p]\"\u0012Aa\u0019\t\u0003\t\u0012L!!Z#\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cH/T3ue&\u001cg)Y5mK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD#!B2\u00023Q,7\u000f\u001e#fC\u0012$\u0006N]3bI\u000e{WO\u001c;NKR\u0014\u0018n\u0019\u0015\u0003\r\r\fq\u0003^3ti6\u000b\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:)\u0005\u001d\u0019\u0017\u0001\u0006;fgR,\u0005\u0010]1oIRC'/Z1e!>|G\u000e\u000b\u0002\tG\u0006!B/Z:u'\"\u0014\u0018N\\6UQJ,\u0017\r\u001a)p_2D#!C2\u0002)Q,7\u000f\u001e*fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011y$o^=\t\u000bMT\u0001\u0019\u0001;\u0002%\r,(O]3oi\u001a+Go\u00195feNK'0\u001a\t\u0003iUL!A^\u001b\u0003\u0007%sG\u000fC\u0003y\u0015\u0001\u0007A/\u0001\boK^4U\r^2iKJ\u001c\u0016N_3\t\u000fiT\u0001\u0013!a\u0001i\u0006I!M]8lKJtU/\\\u0001\u001fi\u0016\u001cHOU3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7%I\u00164\u0017-\u001e7uIM*\u0012! \u0016\u0003iz\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\nU\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nnC.,Gk\u001c9jGB\u000b'\u000f^5uS>tG\u0003CA\n\u0003c\t)$!\u000f\u0011\r\u0005U\u00111DA\u0010\u001b\t\t9BC\u0002\u0002\u001aU\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti\"a\u0006\u0003\u0007M+G\u000f\u0005\u0003\u0002\"\u00055RBAA\u0012\u0015\u0011\t)#a\n\u0002\r\r|W.\\8o\u0015\r\u0001\u0014\u0011\u0006\u0006\u0004\u0003WY\u0015AB1qC\u000eDW-\u0003\u0003\u00020\u0005\r\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003ga\u0001\u0019\u0001;\u0002\u0011Q|\u0007/[2Ok6Da!a\u000e\r\u0001\u0004!\u0018\u0001\u00049beRLG/[8o\u001dVl\u0007\u0002CA\u001e\u0019A\u0005\t\u0019\u0001,\u0002\u0017Q|\u0007/[2Qe\u00164\u0017\u000e_\u0001\u001d[\u0006\\W\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tE\u000b\u0002W}\u0006Yq-\u001a;Ce>\\WM]%e)\u0015!\u0018qIA&\u0011\u001d\tIE\u0004a\u0001\u0003?\t!\u0001\u001e9\t\u000bit\u0001\u0019\u0001;\u0003%5{7m\u001b'fC\u0012,'/\u00128e!>Lg\u000e^\n\u0005\u001fM\n\t\u0006E\u0002=\u0003'J1!!\u0016.\u00059aU-\u00193fe\u0016sG\rU8j]R\fAb]8ve\u000e,'I]8lKJ\u0004B!a\u0017\u0002d5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0004oKR<xN]6\u000b\u00079\n9#\u0003\u0003\u0002f\u0005u#A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0005\u0003S\ni\u0007E\u0002\u0002l=i\u0011\u0001\u0001\u0005\b\u0003/\n\u0002\u0019AA-\u00035Ig.\u001b;jCR,7\t\\8tK\u0006)1\r\\8tK\u0006q!M]8lKJ,e\u000e\u001a)pS:$HCAA-\u0003\u00151W\r^2i)\u0011\tY(!#\u0011\u0011\u0005U\u0011QPA\u0010\u0003\u0003KA!a \u0002\u0018\t\u0019Q*\u00199\u0011\t\u0005\r\u0015QQ\u0007\u0002\u001f%!\u0011qQA*\u0005%1U\r^2i\t\u0006$\u0018\rC\u0004\u0002\fV\u0001\r!!$\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005=\u00151\u0014\b\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*!\u0011QSA\u0012\u0003!\u0011X-];fgR\u001c\u0018\u0002BAM\u0003'\u000bABR3uG\"\u0014V-];fgRLA!!(\u0002 \n9!)^5mI\u0016\u0014(\u0002BAM\u0003'\u000b1CZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR$b!!*\u00020\u0006M\u0006\u0003BAT\u0003Wk!!!+\u000b\t\u0005\u0015\u0012\u0011M\u0005\u0005\u0003[\u000bIK\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000f\u0005Ef\u00031\u0001\u0002 \u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007BBA[-\u0001\u0007A/\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0017!\u00054fi\u000eDG*\u0019;fgR|eMZ:fiR1\u0011QUA^\u0003{Cq!!-\u0018\u0001\u0004\ty\u0002\u0003\u0004\u00026^\u0001\r\u0001^\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\u0005\r\u00171\u001e\t\t\u0003+\ti(a\b\u0002FB!\u0011qYAs\u001d\u0011\tI-a8\u000f\t\u0005-\u00171\u001c\b\u0005\u0003\u001b\fIN\u0004\u0003\u0002P\u0006]g\u0002BAi\u0003+t1!WAj\u0013\u0005a\u0015bAA\u0016\u0017&\u0019\u0001'!\u000b\n\t\u0005\u0015\u0012qE\u0005\u0005\u0003;\f\u0019#A\u0004nKN\u001c\u0018mZ3\n\t\u0005\u0005\u00181]\u0001!\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002^\u0006\r\u0012\u0002BAt\u0003S\u0014a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0002b\u0006\r\bbBAw1\u0001\u0007\u0011q^\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003CA\u000b\u0003{\ny\"!=\u0011\t\u0005\r\u00151_\u0005\u0005\u0003k\f\u0019FA\u0005Fa>\u001c\u0007\u000eR1uC\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\u0005m(Q\u0004\t\u0007\u0003{\u0014YA!\u0005\u000f\t\u0005}(q\u0001\b\u0005\u0005\u0003\u0011)AD\u0002Z\u0005\u0007I\u0011\u0001M\u0005\u0003]=J1A!\u0003.\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012LAA!\u0004\u0003\u0010\t!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NT1A!\u0003.!\u0015!$1\u0003B\f\u0013\r\u0011)\"\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005u(\u0011D\u0005\u0005\u00057\u0011yA\u0001\u0007SKBd\u0017nY1GKR\u001c\u0007\u000eC\u0004\u0003 e\u0001\rA!\t\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\u0011\u0005U\u0011QPA\u0010\u0005G\u00012\u0001\u0010B\u0013\u0013\r\u00119#\f\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e+\t\u0011i\u0003E\u00025\u0005_I1A!\r6\u0005\u001d\u0011un\u001c7fC:\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u0019M\u0016$8\r[#be2LWm\u001d;M_\u000e\fGn\u00144gg\u0016$HCBAS\u0005s\u0011Y\u0004C\u0004\u00022r\u0001\r!a\b\t\r\u0005UF\u00041\u0001u\u0005\u0005junY6SKNL'0\u001a$fi\u000eDWM\u001d+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f'\ri\"\u0011\t\t\u0004y\t\r\u0013b\u0001B#[\t\u0001B+[3s'R\fG/Z'bG\"Lg.\u001a\u000b\u0003\u0005\u0013\u00022!a\u001b\u001e\u0003\u0015\u0019H/\u0019:u)!\u0011\u0019Ca\u0014\u0003R\tU\u0003bBAY?\u0001\u0007\u0011q\u0004\u0005\b\u0005'z\u0002\u0019\u0001B\u0012\u0003E\u0019WO\u001d:f]R4U\r^2i'R\fG/\u001a\u0005\b\u0005/z\u0002\u0019\u0001B-\u0003I1W\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\tm#\u0011\r\b\u0005\u0003\u0013\u0014i&\u0003\u0003\u0003`\u0005\r\u0018!\u0005$fi\u000eD'+Z:q_:\u001cX\rR1uC&!!1\rB3\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!!qLAr\u0005]!Vm\u001d;SKNL'0\u001a$fi\u000eDWM\u001d+ie\u0016\fGmE\u0002!\u0005W\u00022\u0001\u0010B7\u0013\r\u0011y'\f\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002=\u0005kJ1Aa\u001e.\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\u000bgKR\u001c\u0007\u000eV5feN#\u0018\r^3NC\u000eD\u0017N\\3\u0015\u0011\tu$q\u0010BA\u0005\u0007\u00032!a\u001b!\u0011\u001d\t9\u0006\na\u0001\u00033BqA!\u001d%\u0001\u0004\u0011\u0019\bC\u0004\u0003z\u0011\u0002\rA!\u0011\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\u0011IIa(\u0003\"\n-\u0006#\u0002\u001b\u0003\u0014\t-\u0005\u0003\u0002BG\u00057k!Aa$\u000b\t\tE%1S\u0001\u0004Y><'\u0002\u0002BK\u0005/\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\te\u0015qE\u0001\bgR|'/Y4f\u0013\u0011\u0011iJa$\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t\t,\na\u0001\u0003?AqAa)&\u0001\u0004\u0011)+A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bc\u0001\u001b\u0003(&\u0019!\u0011V\u001b\u0003\t1{gn\u001a\u0005\b\u0005[+\u0003\u0019\u0001BX\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!\u0011\u0017BZ\u001b\u0005\u0001\u0013\u0002BAD\u0005[\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0006\u007f\te&1\u0018\u0005\b\u0003c3\u0003\u0019AA\u0010\u0011\u001d\u0011iL\na\u0001\u0005\u007f\u000bq\u0002\u001e:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004y\t\u0005\u0017b\u0001Bb[\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0015y$\u0011\u001aBf\u0011\u001d\t\tl\na\u0001\u0003?AqA!4(\u0001\u0004\u0011)+\u0001\u0004pM\u001a\u001cX\r^\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0003T\nU\u0007\u0003\u0002\u001b\u0003\u0014QDq!!-)\u0001\u0004\ty\"\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\t\t\u0015&1\u001c\u0005\b\u0003cK\u0003\u0019AA\u0010\u00031awnZ#oI>3gm]3u)\u0011\u0011)K!9\t\u000f\u0005E&\u00061\u0001\u0002 \u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\t\u001d(\u0011\u001eBv!\u0015!$1CAS\u0011\u001d\t\tl\u000ba\u0001\u0003?AaA!<,\u0001\u0004!\u0018!B3q_\u000eD\u0007")
public class AbstractFetcherManagerTest {
    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_lastFetchedEpoch;
        void apply_state;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ apply_lag = None$.MODULE$;
        Object var9_10 = null;
        truncating$ = null;
        none$ = null;
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateTopicIds() {
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_lastFetchedEpoch4;
        void apply_state4;
        void apply_lag2;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$2 = None$.MODULE$;
        None$ apply_topicId = None$.MODULE$;
        Object var16_15 = null;
        none$2 = null;
        truncating$ = null;
        none$ = null;
        None$ none$3 = None$.MODULE$;
        Truncating$ truncating$2 = Truncating$.MODULE$;
        None$ apply_lag3 = None$.MODULE$;
        Object var20_18 = null;
        truncating$2 = null;
        none$3 = null;
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId, fetchOffset, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state4, (Option)apply_lastFetchedEpoch4))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId1, fetchOffset, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3)));
        None$ none$4 = None$.MODULE$;
        Truncating$ truncating$3 = Truncating$.MODULE$;
        None$ none$5 = None$.MODULE$;
        None$ apply_topicId2 = None$.MODULE$;
        Object var23_22 = null;
        none$5 = null;
        truncating$3 = null;
        none$4 = null;
        None$ none$6 = None$.MODULE$;
        Truncating$ truncating$4 = Truncating$.MODULE$;
        None$ apply_lag4 = None$.MODULE$;
        Object var27_25 = null;
        truncating$4 = null;
        none$6 = null;
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId2, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId2, fetchOffset, (Option)apply_lag4, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions(), this.$outer.new MockResizeFetcherTierStateMachine());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1);
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, "kafka-host-" + brokerId, 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = topicPrefix + i;
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return (Map)Map$.MODULE$.empty();
        }

        public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return (Map)Map$.MODULE$.empty();
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Set)Set$.MODULE$.empty());
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class MockResizeFetcherTierStateMachine
    extends TierStateMachine {
        public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
            throw new UnsupportedOperationException("Materializing tier state is not supported in this test.");
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherTierStateMachine$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public MockResizeFetcherTierStateMachine() {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            super(null, null, false);
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, TierStateMachine fetchTierStateMachine) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            MockLeaderEndPoint x$3 = new MockLeaderEndPoint(AbstractFetcherManagerTest.this, sourceBroker);
            BrokerTopicStats x$7 = new BrokerTopicStats();
            boolean x$8 = true;
            super("test-resize-fetcher", "mock-fetcher", (LeaderEndPoint)x$3, failedPartitions, fetchTierStateMachine, 0, x$8, x$7);
        }
    }
}

