/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.UUID;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Efa\u0002\u000e\u001c!\u0003\r\tA\t\u0005\u0006S\u0001!\tA\u000b\u0005\u00069\u00011\tA\f\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u001d)\u0005A1A\u0005\u0002qBqA\u0012\u0001C\u0002\u0013\u0005q\tC\u0004R\u0001\t\u0007I\u0011\u0001*\t\u000fe\u0003!\u0019!C\u0001y!I!\f\u0001a\u0001\u0002\u0004%\ta\u0017\u0005\nC\u0002\u0001\r\u00111A\u0005\u0002\tD\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00014\t\u00131\u0004\u0001\u0019!a\u0001\n\u0003i\u0007\"B8\u0001\t\u0003Q\u0003\"B>\u0001\t\u0003Q\u0003\"B?\u0001\t\u0003Q\u0003\"B@\u0001\t\u0003Q\u0003BBA\u0002\u0001\u0011\u0005!\u0006\u0003\u0004\u0002\b\u0001!\tA\u000b\u0005\u0007\u0003\u0017\u0001A\u0011\u0001\u0016\t\r\u0005=\u0001\u0001\"\u0001+\u0011\u0019\t\u0019\u0002\u0001C\u0001U!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001\"CA\u001f\u0001E\u0005I\u0011AA \u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!! \u0001\t\u0003\ty\bC\u0004\u0002(\u0002!\t!!+\u0003%\t\u000b7/Z!vi\"|'/\u001b>feR+7\u000f\u001e\u0006\u00039u\t!\"Y;uQ>\u0014\u0018N_3s\u0015\tqr$\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001,!\t!C&\u0003\u0002.K\t!QK\\5u+\u0005y\u0003C\u0001\u0019:\u001b\u0005\t$B\u0001\u000f3\u0015\t\u0019D'\u0001\u0004tKJ4XM\u001d\u0006\u0003AUR!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO&\u0011!(\r\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018AC:va\u0016\u0014Xk]3sgV\tQ\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!A.\u00198h\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R \u0003\rM#(/\u001b8h\u0003!)8/\u001a:oC6,\u0017!\u00039sS:\u001c\u0017\u000e]1m+\u0005A\u0005CA%P\u001b\u0005Q%BA&M\u0003\u0011\tW\u000f\u001e5\u000b\u0005yi%B\u0001(5\u0003\u0019\u0019w.\\7p]&\u0011\u0001K\u0013\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u00039\u0011X-];fgR\u001cuN\u001c;fqR,\u0012a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-6\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u00031V\u0013aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\u0007tkB,'/V:fe:\u000bW.Z\u0001\u0007G>tg-[4\u0016\u0003q\u0003\"!X0\u000e\u0003yS!aM\u0010\n\u0005\u0001t&aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\tY3\rC\u0004e\u0013\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'\u0001\u0005sKN|WO]2f+\u00059\u0007C\u00015k\u001b\u0005I'BA3N\u0013\tY\u0017NA\bSKN|WO]2f!\u0006$H/\u001a:o\u00031\u0011Xm]8ve\u000e,w\fJ3r)\tYc\u000eC\u0004e\u0017\u0005\u0005\t\u0019A4\u0002_Q,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f\u001bVdG/\u001b9mK\u0006#G-\u00118e%\u0016lwN^3)\u00051\t\bC\u0001:z\u001b\u0005\u0019(B\u0001;v\u0003\r\t\u0007/\u001b\u0006\u0003m^\fqA[;qSR,'O\u0003\u0002yo\u0005)!.\u001e8ji&\u0011!p\u001d\u0002\u0005)\u0016\u001cH/\u0001\"uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/Z%t_2\fG/[8o+:\u0014X\r\\1uK\u0012$UM\\=X_:$Hi\\7j]\u0006$X-\u00117m_^D#!D9\u0002]Q,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f\t\u0016t\u0017\u0010V1lKN\u0004&/Z2fI\u0016t7-\u001a\u0015\u0003\u001dE\fq\u0007^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,\u0007K]3gSb,GMU3t_V\u00148-\u001a#f]f$u.\\5oCR,\u0007FA\br\u0003]\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qK^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,G)\u001a8z\t>l\u0017N\\1uK\"\u0012\u0001#]\u0001/i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3XSRD\u0017\t\u001c7Pa\u0016\u0014\u0018\r^5p]\u0006\u001bW\r\u000b\u0002\u0012c\u0006IC/Z:u\u0003V$\bn\u001c:ju\u0016\u0014\u0015PU3t_V\u00148-\u001a+za\u0016<\u0016\u000e\u001e5BY2Dun\u001d;BG\u0016D#AE9\u0002]Q,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f/&$\b.\u00117m!JLgnY5qC2\f5-\u001a\u0015\u0003'E\fQ\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,7+\u001e9feV\u001bXM\u001d%bg\u0006\u001b7-Z:tQ\t!\u0012/A\toK^\u0014V-];fgR\u001cuN\u001c;fqR$raUA\u000e\u0003;\ti\u0003C\u0003G+\u0001\u0007\u0001\nC\u0004\u0002 U\u0001\r!!\t\u0002\u001b\rd\u0017.\u001a8u\u0003\u0012$'/Z:t!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\u0003\u0006\u0019a.\u001a;\n\t\u0005-\u0012Q\u0005\u0002\f\u0013:,G/\u00113ee\u0016\u001c8\u000fC\u0005\u00020U\u0001\n\u00111\u0001\u00022\u00051\u0011\r]5LKf\u0004B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003oi\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005m\u0012Q\u0007\u0002\b\u0003BL7*Z=t\u0003mqWm\u001e*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\t\u0016\u0005\u0003c\t\u0019e\u000b\u0002\u0002FA!\u0011qIA)\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!C;oG\",7m[3e\u0015\r\ty%J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA*\u0003\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\tW\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004X\r\u0006\u0006\u0002Z\u0005}\u0013\u0011MA2\u0003g\u00022\u0001JA.\u0013\r\ti&\n\u0002\b\u0005>|G.Z1o\u0011\u0015ar\u00031\u00010\u0011\u0015\tv\u00031\u0001T\u0011\u001d\t)g\u0006a\u0001\u0003O\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001cN\u0003\r\t7\r\\\u0005\u0005\u0003c\nYG\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0002v]\u0001\r!a\u001e\u0002\u0019I,7o\\;sG\u0016$\u0016\u0010]3\u0011\u0007!\fI(C\u0002\u0002|%\u0014ABU3t_V\u00148-\u001a+za\u0016\fq!\u00193e\u0003\u000ed7\u000fF\u0004,\u0003\u0003\u000b\u0019)a)\t\u000bqA\u0002\u0019A\u0018\t\u000f\u0005\u0015\u0005\u00041\u0001\u0002\b\u0006!\u0011mY3t!\u0019\tI)a&\u0002\u001e:!\u00111RAJ!\r\ti)J\u0007\u0003\u0003\u001fS1!!%\"\u0003\u0019a$o\\8u}%\u0019\u0011QS\u0013\u0002\rA\u0013X\rZ3g\u0013\u0011\tI*a'\u0003\u0007M+GOC\u0002\u0002\u0016\u0016\u0002B!!\u001b\u0002 &!\u0011\u0011UA6\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\r\u0005\u0015\u0006\u00041\u0001h\u0003=\u0011Xm]8ve\u000e,\u0007+\u0019;uKJt\u0017A\u0003:f[>4X-Q2mgRA\u0011\u0011LAV\u0003[\u000by\u000bC\u0003\u001d3\u0001\u0007q\u0006C\u0004\u0002\u0006f\u0001\r!a\"\t\r\u0005\u0015\u0016\u00041\u0001h\u0001")
public interface BaseAuthorizerTest {
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String var1);

    public Authorizer authorizer();

    public String superUsers();

    public String username();

    public KafkaPrincipal principal();

    public RequestContext requestContext();

    public String superUserName();

    public KafkaConfig config();

    public void config_$eq(KafkaConfig var1);

    public ResourcePattern resource();

    public void resource_$eq(ResourcePattern var1);

    public static /* synthetic */ void testAuthorizeByResourceTypeMultipleAddAndRemove$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeMultipleAddAndRemove();
    }

    @Test
    default public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "sb1" + UUID.randomUUID(), PatternType.LITERAL);
        AccessControlEntry denyRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
            this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
                this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
                Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            });
            this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
        });
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow();
    }

    @Test
    default public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "sb1" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, "sb2" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.GROUP, "s", PatternType.PREFIXED);
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl7 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl6, acl7}))), resource1);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl4}))), resource2);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), resource3);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host2 should not have READ access to any consumer group");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.CLUSTER), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should have READ access to at least one topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeDenyTakesPrecedence$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeDenyTakesPrecedence();
    }

    @Test
    default public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "sb1" + UUID.randomUUID(), PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should have WRITE access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should not have WRITE access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypePrefixedResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypePrefixedResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern a = new ResourcePattern(ResourceType.GROUP, "a", PatternType.PREFIXED);
        ResourcePattern ab = new ResourcePattern(ResourceType.GROUP, "ab", PatternType.PREFIXED);
        ResourcePattern abc = new ResourcePattern(ResourceType.GROUP, "abc", PatternType.PREFIXED);
        ResourcePattern abcd = new ResourcePattern(ResourceType.GROUP, "abcd", PatternType.PREFIXED);
        ResourcePattern abcde = new ResourcePattern(ResourceType.GROUP, "abcde", PatternType.PREFIXED);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abcde);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 should have READ access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), abcd);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abc);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), a);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), ab);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 still should not have READ access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWildcardResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWildcardResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern wildcard = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern prefixed = new ResourcePattern(ResourceType.GROUP, "hello", PatternType.PREFIXED);
        ResourcePattern literal = new ResourcePattern(ResourceType.GROUP, "aloha", PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), prefixed);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 should have WRITE access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 now should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), literal);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllOperationAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllOperationAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllOperationAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "sb1" + UUID.randomUUID(), PatternType.LITERAL);
        AccessControlEntry denyAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        AccessControlEntry allowAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyWrite = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWrite, allowAll}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllHostAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllHostAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllHostAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        String allHost = "*";
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "sb1" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, "sb2" + UUID.randomUUID(), PatternType.LITERAL);
        AccessControlEntry allowHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowHost1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyHost1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllHost}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllPrincipalAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllPrincipalAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        String allUser = AclEntry.WILDCARD_PRINCIPAL_STRING;
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "sb1" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, "sb2" + UUID.randomUUID(), PatternType.LITERAL);
        AccessControlEntry allowUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u2h1Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowUser1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyUser1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllUser}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeSuperUserHasAccess$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeSuperUserHasAccess();
    }

    @Test
    default public void testAuthorizeByResourceTypeSuperUserHasAccess() {
        AccessControlEntry denyAllAce = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.DENY);
        KafkaPrincipal superUser1 = new KafkaPrincipal("User", this.superUserName());
        InetAddress host1 = InetAddress.getByName("192.0.4.4");
        ResourcePattern allTopicsResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        ResourcePattern groupResource = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern transactionIdResource = new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "*", PatternType.LITERAL);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), allTopicsResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), clusterResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), groupResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), transactionIdResource);
        RequestContext superUserContext = this.newRequestContext(superUser1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TOPIC), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.CLUSTER), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.GROUP), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"superuser always has access, no matter what acls.");
    }

    public static /* synthetic */ RequestContext newRequestContext$(BaseAuthorizerTest $this, KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return $this.newRequestContext(principal, clientAddress, apiKey);
    }

    default public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, false);
    }

    public static /* synthetic */ ApiKeys newRequestContext$default$3$(BaseAuthorizerTest $this) {
        return $this.newRequestContext$default$3();
    }

    default public ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static /* synthetic */ boolean authorizeByResourceType$(BaseAuthorizerTest $this, Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return $this.authorizeByResourceType(authorizer, requestContext, operation, resourceType);
    }

    default public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        AuthorizationResult authorizationResult = authorizer.authorizeByResourceType((AuthorizableRequestContext)requestContext, operation, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        return !(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null);
    }

    public static /* synthetic */ void addAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        $this.addAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace));
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$5 -> (AclCreateResult)x$5.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            BaseAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean removeAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        return $this.removeAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bindings.toList()).asJava())).asScala().map((Function1 & Serializable)x$6 -> (AclDeleteResult)x$6.toCompletableFuture().get())).forall((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)BaseAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    public static /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static void $init$(BaseAuthorizerTest $this) {
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq("User:superuser1; User:superuser2");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq("alice");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(new KafkaPrincipal("User", $this.username()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq($this.newRequestContext($this.principal(), InetAddress.getByName("192.168.0.1"), $this.newRequestContext$default$3()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq("superuser1");
    }
}

