/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiFunction;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.controller.MockAclMutator;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTest;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Ec\u0001\u0002*T\u0001iCQ!\u001a\u0001\u0005\u0002\u0019Dq\u0001\u001b\u0001C\u0002\u00135\u0011\u000e\u0003\u0004v\u0001\u0001\u0006iA\u001b\u0005\bm\u0002\u0011\r\u0011\"\u0004x\u0011\u0019Y\b\u0001)A\u0007q\"9A\u0010\u0001b\u0001\n\u0013i\bbBA\u0005\u0001\u0001\u0006IA \u0005\t\u0003\u0017\u0001!\u0019!C\u0005{\"9\u0011Q\u0002\u0001!\u0002\u0013q\b\u0002CA\b\u0001\t\u0007I\u0011B?\t\u000f\u0005E\u0001\u0001)A\u0005}\"I\u00111\u0003\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u0011Q\u0003\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011Q\u0006\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u00022!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%I!a\u0015\t\u0017\u0005\u0015\u0004\u00011A\u0001B\u0003&\u0011Q\t\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0005C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\n\u0005-\u0004bCA8\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bB1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002t!Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011BAF\u0011-\ty\t\u0001a\u0001\u0002\u0003\u0006K!!\u001e\u0007\r\u0005E\u0005\u0001AAJ\u0011)\t)*\bB\u0001B\u0003%\u0011q\u0013\u0005\u000b\u0003[k\"\u0011!Q\u0001\n\u0005]\u0005BB3\u001e\t\u0003\ty\u000bC\u0004\u0002:v!\t%a/\t\rQ\u0003A\u0011IA\"\u0011\u001d\ti\r\u0001C\u0001\u0003gBq!a4\u0001\t\u0003\n\t\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005E\b\u0001\"\u0011\u0002t\"9\u0011Q \u0001\u0005\u0002\u0005}\bb\u0002B\u0013\u0001\u0011\u0005!q\u0005\u0005\b\u0005c\u0001A\u0011\u0001B\u001a\u0011\u001d\u0011i\u0004\u0001C\u0001\u0005\u007fAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003V\u0001!\tAa\u0016\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!9!Q\u000e\u0001\u0005\u0002\t=\u0004b\u0002B=\u0001\u0011\u0005!1\u0010\u0005\b\u0005\u000b\u0003A\u0011\u0001BD\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'CqA!(\u0001\t\u0003\u0011y\nC\u0004\u0003*\u0002!\tAa+\t\u000f\tU\u0006\u0001\"\u0001\u00038\"9!\u0011\u0019\u0001\u0005\u0002\u0005M\bb\u0002Bf\u0001\u0011\u0005!Q\u001a\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqA!?\u0001\t\u0003\u0011Y\u0010C\u0004\u0004\u0006\u0001!\taa\u0002\t\u000f\rE\u0001\u0001\"\u0001\u0004\u0014!91Q\u0004\u0001\u0005\u0002\r}\u0001bBB\u0015\u0001\u0011\u000511\u0006\u0005\b\u0007k\u0001A\u0011AB\u001c\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0007\u0007Bqa!\u0014\u0001\t\u0003\u0019y\u0005C\u0004\u0004Z\u0001!\taa\u0017\t\u000f\r\u0015\u0004\u0001\"\u0001\u0004h!91\u0011\u000f\u0001\u0005\u0002\rM\u0004bBB?\u0001\u0011\u00051q\u0010\u0005\b\u0007\u0013\u0003A\u0011ABF\u0011\u001d\u0019)\n\u0001C\u0001\u0007/Cqa!)\u0001\t\u0013\u0019\u0019\u000bC\u0005\u00046\u0002\t\n\u0011\"\u0003\u00048\"91Q\u001a\u0001\u0005\n\r=\u0007bBBu\u0001\u0011%11\u001e\u0005\b\u0007S\u0004A\u0011BBz\u0011\u001d\u0019I\u000f\u0001C\u0005\t\u0007Aq\u0001b\u0002\u0001\t\u0013!I\u0001C\u0004\u0005\u0010\u0001!\t\u0001\"\u0005\t\u000f\u0011M\u0001\u0001\"\u0001\u0005\u0016!9A\u0011\u0006\u0001\u0005\u0002\u0011-\u0002b\u0002C!\u0001\u0011\u0005A1\t\u0002\u000f\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\t!V+\u0001\u0006bkRDwN]5{KJT!AV,\u0002\u0011M,7-\u001e:jifT\u0011\u0001W\u0001\u0006W\u000647.Y\u0002\u0001'\r\u00011,\u0019\t\u00039~k\u0011!\u0018\u0006\u0003=^\u000baa]3sm\u0016\u0014\u0018B\u00011^\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\t\u0003E\u000el\u0011aU\u0005\u0003IN\u0013!CQ1tK\u0006+H\u000f[8sSj,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u001a\t\u0003E\u0002\t\u0011\u0002\u0015'B\u0013:#V\t\u0017+\u0016\u0003)\u0004\"a[:\u000e\u00031T!!\u001c8\u0002\r\r|W.\\8o\u0015\tAvN\u0003\u0002qc\u00061\u0011\r]1dQ\u0016T\u0011A]\u0001\u0004_J<\u0017B\u0001;m\u0005!)e\u000e\u001a9pS:$\u0018A\u0003)M\u0003&sE+\u0012-UA\u0005)1JU!G)V\t\u0001pD\u0001zC\u0005Q\u0018!B6sC\u001a$\u0018AB&S\u0003\u001a#\u0006%\u0001\u0007bY2|wOU3bI\u0006\u001bG.F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001m\u0003\r\t7\r\\\u0005\u0005\u0003\u000f\t\tA\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\u0018!D1mY><(+Z1e\u0003\u000ed\u0007%A\u0007bY2|wo\u0016:ji\u0016\f5\r\\\u0001\u000fC2dwn^,sSR,\u0017i\u00197!\u0003-!WM\\=SK\u0006$\u0017i\u00197\u0002\u0019\u0011,g.\u001f*fC\u0012\f5\r\u001c\u0011\u0002!]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,WCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fY\u0006A!/Z:pkJ\u001cW-\u0003\u0003\u0002\"\u0005m!a\u0004*fg>,(oY3QCR$XM\u001d8\u0002#]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,\u0007%\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0006\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002#]LG\u000eZ2be\u0012\u0004&/\u001b8dSB\fG.\u0006\u0002\u00022A!\u00111GA\u001e\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012\u0001B1vi\"T!A\u00167\n\t\u0005u\u0012Q\u0007\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003I9\u0018\u000e\u001c3dCJ$\u0007K]5oG&\u0004\u0018\r\u001c\u0011\u0002\u0017\u0005,H\u000f[8sSj,'/M\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004)\u0006-#B\u00010o\u0013\u0011\ty%!\u0013\u0003\u0015\u0005+H\u000f[8sSj,'/A\bbkRDwN]5{KJ\ft\fJ3r)\u0011\t)&!\u0019\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R!!a\u0017\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005}\u0013\u0011\f\u0002\u0005+:LG\u000fC\u0005\u0002dU\t\t\u00111\u0001\u0002F\u0005\u0019\u0001\u0010J\u0019\u0002\u0019\u0005,H\u000f[8sSj,'/\r\u0011\u0002\u0017\u0005,H\u000f[8sSj,'OM\u0001\u0010CV$\bn\u001c:ju\u0016\u0014(g\u0018\u0013fcR!\u0011QKA7\u0011%\t\u0019\u0007GA\u0001\u0002\u0004\t)%\u0001\u0007bkRDwN]5{KJ\u0014\u0004%A\u0005`i\u0016\u001cH/\u00138g_V\u0011\u0011Q\u000f\t\u0005\u0003o\n))\u0004\u0002\u0002z)!\u00111PA?\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u007f\n\t)A\u0004kkBLG/\u001a:\u000b\u0007\u0005\r\u0015/A\u0003kk:LG/\u0003\u0003\u0002\b\u0006e$\u0001\u0003+fgRLeNZ8\u0002\u001b}#Xm\u001d;J]\u001a|w\fJ3r)\u0011\t)&!$\t\u0013\u0005\r4$!AA\u0002\u0005U\u0014AC0uKN$\u0018J\u001c4pA\ty1)^:u_6\u0004&/\u001b8dSB\fGnE\u0002\u001e\u0003c\tQ\u0002\u001d:j]\u000eL\u0007/\u00197UsB,\u0007\u0003BAM\u0003OsA!a'\u0002$B!\u0011QTA-\u001b\t\tyJC\u0002\u0002\"f\u000ba\u0001\u0010:p_Rt\u0014\u0002BAS\u00033\na\u0001\u0015:fI\u00164\u0017\u0002BAU\u0003W\u0013aa\u0015;sS:<'\u0002BAS\u00033\nAA\\1nKR1\u0011\u0011WA[\u0003o\u00032!a-\u001e\u001b\u0005\u0001\u0001bBAKA\u0001\u0007\u0011q\u0013\u0005\b\u0003[\u0003\u0003\u0019AAL\u0003\u0019)\u0017/^1mgR!\u0011QXAb!\u0011\t9&a0\n\t\u0005\u0005\u0017\u0011\f\u0002\b\u0005>|G.Z1o\u0011\u001d\t)-\ta\u0001\u0003\u000f\f\u0011a\u001c\t\u0005\u0003/\nI-\u0003\u0003\u0002L\u0006e#aA!os\u0006AA/Z:u\u0013:4w.A\u0003tKR,\u0006\u000f\u0006\u0003\u0002V\u0005M\u0007bBAgI\u0001\u0007\u0011Q\u000f\u0015\u0004I\u0005]\u0007\u0003BA<\u00033LA!a7\u0002z\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0015A\u0014x\u000e]3si&,7/\u0006\u0002\u0002bB!\u00111]Aw\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018\u0001B;uS2T!!a;\u0002\t)\fg/Y\u0005\u0005\u0003_\f)O\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003+B3AJA|!\u0011\t9(!?\n\t\u0005m\u0018\u0011\u0010\u0002\n\u0003\u001a$XM]#bG\"\fq\u0005^3ti\u0006+H\u000f[8sSj,G\u000b\u001b:poN|eNT8o\u0019&$XM]1m%\u0016\u001cx.\u001e:dKR!\u0011Q\u000bB\u0001\u0011\u001d\u0011\u0019a\na\u0001\u0003/\u000ba!];peVl\u0007fA\u0014\u0003\bA!!\u0011\u0002B\b\u001b\t\u0011YA\u0003\u0003\u0003\u000e\u0005u\u0014A\u00029be\u0006l7/\u0003\u0003\u0003\u0012\t-!!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":qE!\u0006\u0003\"\t\r\u0002\u0003\u0002B\f\u0005;i!A!\u0007\u000b\t\tm!1B\u0001\taJ|g/\u001b3fe&!!q\u0004B\r\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\n\u00110\u0001\u0012uKN$\u0018)\u001e;i_JL'0Z,ji\",U\u000e\u001d;z%\u0016\u001cx.\u001e:dK:\u000bW.\u001a\u000b\u0005\u0003+\u0012I\u0003C\u0004\u0003\u0004!\u0002\r!a&)\u0007!\u00129\u0001K\u0004)\u0005+\u0011\tCa\f-\u0003e\f1\u0004^3ti\u0016k\u0007\u000f^=BG2$\u0006N]8xg\u0016C8-\u001a9uS>tG\u0003BA+\u0005kAqAa\u0001*\u0001\u0004\t9\nK\u0002*\u0005\u000fAs!\u000bB\u000b\u0005C\u0011Y\u0004L\u0001z\u00031!Xm\u001d;U_BL7-Q2m)\u0011\t)F!\u0011\t\u000f\t\r!\u00061\u0001\u0002\u0018\"\u001a!Fa\u0002)\u000f)\u0012)B!\t\u0003H1\n\u00110\u0001\u0012uKN$\u0018\t\u001c7po\u0006\u001b7-Z:t/&$\bnQ;ti>l\u0007K]5oG&\u0004\u0018\r\u001c\u000b\u0005\u0003+\u0012i\u0005C\u0004\u0003\u0004-\u0002\r!a&)\u0007-\u00129\u0001K\u0004,\u0005+\u0011\tCa\u0015-\u0003e\fq\u0003^3ti\u0012+g.\u001f+bW\u0016\u001c\bK]3dK\u0012,gnY3\u0015\t\u0005U#\u0011\f\u0005\b\u0005\u0007a\u0003\u0019AALQ\ra#q\u0001\u0015\bY\tU!\u0011\u0005B0Y\u0005I\u0018A\u0005;fgR\fE\u000e\\8x\u00032d\u0017iY2fgN$B!!\u0016\u0003f!9!1A\u0017A\u0002\u0005]\u0005fA\u0017\u0003\b!:QF!\u0006\u0003\"\t-D&A=\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgN$B!!\u0016\u0003r!9!1\u0001\u0018A\u0002\u0005]\u0005f\u0001\u0018\u0003\b!:aF!\u0006\u0003\"\t]D&A=\u0002SQ,7\u000f^*va\u0016\u0014Xk]3s/&$\bnQ;ti>l\u0007K]5oG&\u0004\u0018\r\u001c%bg\u0006\u001b7-Z:t)\u0011\t)F! \t\u000f\t\rq\u00061\u0001\u0002\u0018\"\u001aqFa\u0002)\u000f=\u0012)B!\t\u0003\u00042\n\u00110\u0001\tuKN$x+\u001b7e\u0007\u0006\u0014H-Q2mgR!\u0011Q\u000bBE\u0011\u001d\u0011\u0019\u0001\ra\u0001\u0003/C3\u0001\rB\u0004Q\u001d\u0001$Q\u0003B\u0011\u0005\u001fc\u0013!_\u0001\u000fi\u0016\u001cHOT8BG24u.\u001e8e)\u0011\t)F!&\t\u000f\t\r\u0011\u00071\u0001\u0002\u0018\"\u001a\u0011Ga\u0002)\u000fE\u0012)B!\t\u0003\u001c2\n\u00110\u0001\fuKN$hj\\!dY\u001a{WO\u001c3Pm\u0016\u0014(/\u001b3f)\u0011\t)F!)\t\u000f\t\r!\u00071\u0001\u0002\u0018\"\u001a!Ga\u0002)\u000fI\u0012)B!\t\u0003(2\n\u00110A\u000euKN$\u0018i\u00197D_:4\u0017nZ,ji\"<\u0006.\u001b;fgB\f7-\u001a\u000b\u0005\u0003+\u0012i\u000bC\u0004\u0003\u0004M\u0002\r!a&)\u0007M\u00129\u0001K\u00044\u0005+\u0011\tCa--\u0003e\fQ\u0003^3ti\u0006\u001bG.T1oC\u001e,W.\u001a8u\u0003BK5\u000f\u0006\u0003\u0002V\te\u0006b\u0002B\u0002i\u0001\u0007\u0011q\u0013\u0015\u0004i\t\u001d\u0001f\u0002\u001b\u0003\u0016\t\u0005\"q\u0018\u0017\u0002s\u0006iC/Z:u\u0019>\u001c\u0017\r\\\"p]\u000e,(O]3oi6{G-\u001b4jG\u0006$\u0018n\u001c8PMJ+7o\\;sG\u0016\f5\r\\:)\u0007U\u0012)\r\u0005\u0003\u0002x\t\u001d\u0017\u0002\u0002Be\u0003s\u0012A\u0001V3ti\u0006\u0011B/Z:u\u0003\u000ed\u0017J\u001c5fe&$\u0018M\\2f)\u0011\t)Fa4\t\u000f\t\ra\u00071\u0001\u0002\u0018\"\u001aaGa\u0002)\u000fY\u0012)B!\t\u0003V2\n\u00110A\fuKN$\u0018*\u001c9mS\u000e\fG/[8og>3\u0017\t\u001c7poR1\u0011Q\u000bBn\u0005KDqA!88\u0001\u0004\u0011y.\u0001\u0005qCJ,g\u000e^(q!\ry(\u0011]\u0005\u0005\u0005G\f\tA\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0003h^\u0002\rA!;\u0002\u0015\u0005dGn\\<fI>\u00038\u000f\u0005\u0004\u0002\u001a\n-(q\\\u0005\u0005\u0005[\fYKA\u0002TKR\fa\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0012+g.\u001f\u000b\u0007\u0003+\u0012\u0019P!>\t\u000f\tu\u0007\b1\u0001\u0003`\"9!q\u001f\u001dA\u0002\t%\u0018!\u00033f]&,Gm\u00149t\u0003M\"Xm\u001d;BG\u000e,7o]!mY><X\rZ%g\u00032dwn^!dY\u0016C\u0018n\u001d;t\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\r\u0006\u0003\u0002V\tu\bb\u0002B\u0002s\u0001\u0007\u0011q\u0013\u0015\u0004s\t\u001d\u0001fB\u001d\u0003\u0016\t\u000521\u0001\u0017\u0002s\u0006yB/Z:u\t\u0016dW\r^3BG2|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3\u0015\t\u0005U3\u0011\u0002\u0005\b\u0005\u0007Q\u0004\u0019AALQ\rQ$q\u0001\u0015\bu\tU!\u0011EB\bY\u0005I\u0018A\t;fgR$U\r\\3uK\u0006cG.Q2m\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\r\u0006\u0003\u0002V\rU\u0001b\u0002B\u0002w\u0001\u0007\u0011q\u0013\u0015\u0004w\t\u001d\u0001fB\u001e\u0003\u0016\t\u000521\u0004\u0017\u0002s\u0006\u0019D/Z:u\u0003\u000e\u001cWm]:BY2|w/\u001a3JM\u0006cGn\\<BG2,\u00050[:ug>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u000b\u0005\u0003+\u001a\t\u0003C\u0004\u0003\u0004q\u0002\r!a&)\u0007q\u00129\u0001K\u0004=\u0005+\u0011\tca\n-\u0003e\fq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2f)\u0011\t)f!\f\t\u000f\t\rQ\b1\u0001\u0002\u0018\"\u001aQHa\u0002)\u000fu\u0012)B!\t\u000441\n\u00110\u0001\u0012uKN$H)\u001a7fi\u0016\fE\u000e\\!dY>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u000b\u0005\u0003+\u001aI\u0004C\u0004\u0003\u0004y\u0002\r!a&)\u0007y\u00129\u0001K\u0004?\u0005+\u0011\tca\u0010-\u0003e\fA\u0004^3ti\u0006#G-Q2mg>sG*\u001b;fe\u0006d'+Z:pkJ\u001cW\r\u0006\u0003\u0002V\r\u0015\u0003b\u0002B\u0002\u007f\u0001\u0007\u0011q\u0013\u0015\u0004\u007f\t\u001d\u0001fB \u0003\u0016\t\u000521\n\u0017\u0002s\u0006iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\r\u0006\u0003\u0002V\rE\u0003b\u0002B\u0002\u0001\u0002\u0007\u0011q\u0013\u0015\u0004\u0001\n\u001d\u0001f\u0002!\u0003\u0016\t\u00052q\u000b\u0017\u0002s\u0006iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\r\u0006\u0003\u0002V\ru\u0003b\u0002B\u0002\u0003\u0002\u0007\u0011q\u0013\u0015\u0004\u0003\n\u001d\u0001fB!\u0003\u0016\t\u000521\r\u0017\u0002s\u0006\tC/Z:u\u0003V$\bn\u001c:ju\u0016<\u0016\u000e\u001e5Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dKR!\u0011QKB5\u0011\u001d\u0011\u0019A\u0011a\u0001\u0003/C3A\u0011B\u0004Q\u001d\u0011%Q\u0003B\u0011\u0007_b\u0013!_\u0001 i\u0016\u001cHoU5oO2,7\t[1sC\u000e$XM\u001d*fg>,(oY3BG2\u001cH\u0003BA+\u0007kBqAa\u0001D\u0001\u0004\t9\nK\u0002D\u0005\u000fAsa\u0011B\u000b\u0005C\u0019Y\bL\u0001z\u0003Q!Xm\u001d;HKR\f5\r\\:Qe&t7-\u001b9bYR!\u0011QKBA\u0011\u001d\u0011\u0019\u0001\u0012a\u0001\u0003/C3\u0001\u0012B\u0004Q\u001d!%Q\u0003B\u0011\u0007\u000fc\u0013!_\u0001\u000fi\u0016\u001cH/Q2mg\u001aKG\u000e^3s)\u0011\t)f!$\t\u000f\t\rQ\t1\u0001\u0002\u0018\"\u001aQIa\u0002)\u000f\u0015\u0013)B!\t\u0004\u00142\n\u00110A\u0017uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/\u001a(p\u0003\u000edgi\\;oI>3XM\u001d:jI\u0016$B!!\u0016\u0004\u001a\"9!1\u0001$A\u0002\u0005]\u0005f\u0001$\u0003\b!:aI!\u0006\u0003\"\r}E&A=\u0002%\rD\u0017M\\4f\u0003\u000ed\u0017I\u001c3WKJLg-\u001f\u000b\u000b\u0007K\u001b9ka+\u00040\u000eM\u0006#BAM\u0005Wt\bbBBU\u000f\u0002\u00071QU\u0001\r_JLw-\u001b8bY\u0006\u001bGn\u001d\u0005\b\u0007[;\u0005\u0019ABS\u0003%\tG\rZ3e\u0003\u000ed7\u000fC\u0004\u00042\u001e\u0003\ra!*\u0002\u0017I,Wn\u001c<fI\u0006\u001bGn\u001d\u0005\n\u0003;9\u0005\u0013!a\u0001\u0003/\tAd\u00195b]\u001e,\u0017i\u00197B]\u00124VM]5gs\u0012\"WMZ1vYR$C'\u0006\u0002\u0004:*\"\u0011qCB^W\t\u0019i\f\u0005\u0003\u0004@\u000e%WBABa\u0015\u0011\u0019\u0019m!2\u0002\u0013Ut7\r[3dW\u0016$'\u0002BBd\u00033\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Ym!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005bkRDwN]5{KRQ\u0011QXBi\u0007'\u001c\u0019oa:\t\rQK\u0005\u0019AA#\u0011\u001d\u0019).\u0013a\u0001\u0007/\faB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0004Z\u000e}WBABn\u0015\r\u0019i\u000e\\\u0001\te\u0016\fX/Z:ug&!1\u0011]Bn\u00059\u0011V-];fgR\u001cuN\u001c;fqRDqa!:J\u0001\u0004\u0011y.A\u0005pa\u0016\u0014\u0018\r^5p]\"9\u0011QD%A\u0002\u0005]\u0011aB4fi\u0006\u001bGn\u001d\u000b\u0007\u0007K\u001bioa<\t\rQS\u0005\u0019AA#\u0011\u001d\u0019\tP\u0013a\u0001\u0003/\tqB]3t_V\u00148-\u001a)biR,'O\u001c\u000b\u0007\u0007k\u001cipa@\u0011\r\u0005e%1^B|!\ry8\u0011`\u0005\u0005\u0007w\f\tA\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDa\u0001V&A\u0002\u0005\u0015\u0003b\u0002C\u0001\u0017\u0002\u0007\u0011\u0011G\u0001\naJLgnY5qC2$Ba!>\u0005\u0006!1A\u000b\u0014a\u0001\u0003\u000b\nqA^1mS\u0012|\u0005\u000f\u0006\u0003\u0002>\u0012-\u0001b\u0002C\u0007\u001b\u0002\u0007!q\\\u0001\u0003_B\f\u0001c\u0019:fCR,\u0017)\u001e;i_JL'0\u001a:\u0015\u0005\u0005\u0015\u0013aE2p]\u001aLw-\u001e:f\u0003V$\bn\u001c:ju\u0016\u0014HCBA+\t/!I\u0002\u0003\u0004U\u001f\u0002\u0007\u0011Q\t\u0005\b\t7y\u0005\u0019\u0001C\u000f\u0003\u001d\u0019wN\u001c4jON\u0004\u0002\"a9\u0005 \u0005]E1E\u0005\u0005\tC\t)OA\u0002NCB\u0004B!a\u0016\u0005&%!AqEA-\u0005\u0019\te.\u001f*fM\u0006Y2m\u001c8gS\u001e,(/Z*uC:$\u0017M\u001d3BkRDwN]5{KJ$b!!\u0016\u0005.\u0011}\u0002b\u0002C\u0018!\u0002\u0007A\u0011G\u0001\u0013gR\fg\u000eZ1sI\u0006+H\u000f[8sSj,'\u000f\u0005\u0003\u00054\u0011mRB\u0001C\u001b\u0015\r!Fq\u0007\u0006\u0004\tsq\u0017\u0001C7fi\u0006$\u0017\r^1\n\t\u0011uBQ\u0007\u0002\u0013'R\fg\u000eZ1sI\u0006+H\u000f[8sSj,'\u000fC\u0004\u0005\u001cA\u0003\r\u0001\"\b\u00029%t\u0017\u000e^5bY&TXm\u0015;b]\u0012\f'\u000fZ!vi\"|'/\u001b>feR1\u0011Q\u000bC#\t\u000fBq\u0001b\fR\u0001\u0004!\t\u0004C\u0004\u0005JE\u0003\r\u0001b\u0013\u0002\u0015M,'O^3s\u0013:4w\u000e\u0005\u0003\u0002H\u00115\u0013\u0002\u0002C(\u0003\u0013\u0012A#Q;uQ>\u0014\u0018N_3s'\u0016\u0014h/\u001a:J]\u001a|\u0007")
public class AuthorizerTest
extends QuorumTestHarness
implements BaseAuthorizerTest {
    private final Endpoint PLAINTEXT;
    private final AccessControlEntry allowReadAcl;
    private final AccessControlEntry allowWriteAcl;
    private final AccessControlEntry denyReadAcl;
    private final ResourcePattern wildCardResource;
    private final ResourcePattern prefixedResource;
    private final ResourcePattern clusterResource;
    private final KafkaPrincipal wildcardPrincipal;
    private Authorizer authorizer1;
    private Authorizer authorizer2;
    private TestInfo _testInfo;
    private String superUsers;
    private String username;
    private KafkaPrincipal principal;
    private RequestContext requestContext;
    private String superUserName;
    private KafkaConfig config;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private final Endpoint PLAINTEXT() {
        return this.PLAINTEXT;
    }

    private final String KRAFT() {
        return "kraft";
    }

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private Authorizer authorizer1() {
        return this.authorizer1;
    }

    private void authorizer1_$eq(Authorizer x$1) {
        this.authorizer1 = x$1;
    }

    private Authorizer authorizer2() {
        return this.authorizer2;
    }

    private void authorizer2_$eq(Authorizer x$1) {
        this.authorizer2 = x$1;
    }

    private TestInfo _testInfo() {
        return this._testInfo;
    }

    private void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    @Override
    public Authorizer authorizer() {
        return this.authorizer1();
    }

    public TestInfo testInfo() {
        return this._testInfo();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this._testInfo_$eq(testInfo);
        Properties props = this.properties();
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.authorizer1_$eq(this.createAuthorizer());
        this.configureAuthorizer(this.authorizer1(), this.config().originals());
        this.authorizer2_$eq(this.createAuthorizer());
        this.configureAuthorizer(this.authorizer2(), this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.LITERAL));
    }

    public Properties properties() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("super.users", this.superUsers());
        return props;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.authorizer1().close();
        this.authorizer2().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAuthorizeThrowsOnNonLiteralResource(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAuthorizeWithEmptyResourceName(String quorum) {
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testEmptyAclThrowsException(String quorum) {
        Assertions.assertThrows(ApiException.class, () -> this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testTopicAcl(String quorum) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host2");
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user2Context, AclOperation.DESCRIBE, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user3Context, AclOperation.DESCRIBE, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user2Context, AclOperation.READ, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user3Context, AclOperation.WRITE, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAllowAccessWithCustomPrincipal(String quorum) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDenyTakesPrecedence(String quorum) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), session, AclOperation.READ, this.resource()), (String)"deny should take precedence over allow.");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAllowAllAccess(String quorum) {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), context, AclOperation.READ, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSuperUserHasAccess(String quorum) {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), session1, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), session2, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSuperUserWithCustomPrincipalHasAccess(String quorum) {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), session, AclOperation.READ, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testWildCardAcls(String quorum) {
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host1");
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host1");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testNoAclFound(String quorum) {
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should deny op.");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testNoAclFoundOverride(String quorum) {
        Properties props = this.properties();
        props.put("allow.everyone.if.no.acl.found", "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (Authorizer testAuthorizer = this.createAuthorizer();){
            this.configureAuthorizer(testAuthorizer, cfg.originals());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclConfigWithWhitespace(String quorum) {
        Properties props = this.properties();
        props.put("allow.everyone.if.no.acl.found", " true");
        props.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, String>)(x$4, v) -> " " + v + " "));
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (Authorizer testAuthorizer = this.createAuthorizer();){
            this.configureAuthorizer(testAuthorizer, cfg.originals());
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclManagementAPIs(String quorum) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ResourcePattern key = (ResourcePattern)x0$1._1();
                Set value = (Set)x0$1._2();
                return this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            }
            throw new MatchError(null);
        });
        Set expectedAcls = ((IterableOnceOps)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ResourcePattern res = (ResourcePattern)x0$2._1();
                return (Set)((Set)x0$2._2()).map((Function1 & Serializable)acl -> new AclBinding(res, acl));
            }
            throw new MatchError(null);
        })).toSet();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"changes not propagated in timeout period.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.resource());
        acls = null;
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.authorizer1(), this.resource(), AccessControlEntryFilter.ANY);
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.resource());
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), this.authorizer1(), commonResource, AccessControlEntryFilter.ANY);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclInheritance(String quorum) {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), "*", parentOp, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "*", parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)acls, this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteAclOnWildcardResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.authorizer1(), this.wildCardResource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteAllAclOnWildcardResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteAclOnPrefixedResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.authorizer1(), this.prefixedResource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDeleteAllAclOnPrefixedResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAddAclsOnLiteralResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.authorizer1(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.prefixedResource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAddAclsOnWildcardResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.authorizer1(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.prefixedResource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAddAclsOnPrefixedResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.authorizer1(), this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.resource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAuthorizeWithPrefixedResource(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID() + "-zzz", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fooo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fop-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSingleCharacterResourceAcls(String quorum) {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testGetAclsPrincipal(String quorum) {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.authorizer1(), this.wildcardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.authorizer1(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.authorizer1(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.authorizer1(), this.wildcardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.authorizer1(), this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAclsFilter(String quorum) {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, "bar-" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.authorizer1().createAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(AclBindingFilter.ANY)).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(matchingFilter)).asScala().toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.authorizer1().deleteAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)filters).asJava())).asScala().map((Function1 & Serializable)x$5 -> (AclDeleteResult)x$5.toCompletableFuture().get());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)deleteResults.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerTest.$anonfun$testAclsFilter$2(x$6))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala().toSet().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerTest.$anonfun$testAclsFilter$4(x$7)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$8 -> x$8.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$9 -> x$9.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$10 -> x$10.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$11 -> x$11.aclBinding())).toSet());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAuthorizeByResourceTypeNoAclFoundOverride(String quorum) {
        Properties props = this.properties();
        props.put("allow.everyone.if.no.acl.found", "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (Authorizer authorizer = this.createAuthorizer();){
            this.configureAuthorizer(authorizer, cfg.originals());
            Assertions.assertTrue((boolean)this.authorizeByResourceType(authorizer, this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
            Assertions.assertTrue((boolean)this.authorizeByResourceType(authorizer, this.requestContext(), AclOperation.WRITE, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have write access to at least one topic");
        }
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls(this.authorizer1(), addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls(this.authorizer1(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls, this.authorizer1(), resource, AccessControlEntryFilter.ANY);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private boolean authorize(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(authorizer.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private Set<AccessControlEntry> getAcls(Authorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet().map((Function1 & Serializable)x$12 -> x$12.entry());
    }

    private Set<AclBinding> getAcls(Authorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(filter)).asScala().toSet();
    }

    private Set<AclBinding> getAcls(Authorizer authorizer) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(AclBindingFilter.ANY)).asScala().toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    public Authorizer createAuthorizer() {
        return new StandardAuthorizer();
    }

    public void configureAuthorizer(Authorizer authorizer, Map<String, Object> configs) {
        this.configureStandardAuthorizer((StandardAuthorizer)authorizer, configs);
    }

    public void configureStandardAuthorizer(StandardAuthorizer standardAuthorizer, Map<String, Object> configs) {
        standardAuthorizer.configure(configs);
        this.initializeStandardAuthorizer(standardAuthorizer, (AuthorizerServerInfo)new StandardAuthorizerTest.AuthorizerTestServerInfo(Collections.singletonList(this.PLAINTEXT())));
    }

    public void initializeStandardAuthorizer(StandardAuthorizer standardAuthorizer, AuthorizerServerInfo serverInfo) {
        MockAclMutator aclMutator = new MockAclMutator(standardAuthorizer);
        standardAuthorizer.start(serverInfo);
        standardAuthorizer.setAclMutator((AclMutator)aclMutator);
        standardAuthorizer.completeInitialLoad();
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.authorizer1(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.authorizer1(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.authorizer1());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.authorizer1(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)("ALLOW " + parentOp$1 + " should imply ALLOW " + op));
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)("ALLOW " + parentOp$1 + " should not imply ALLOW " + op));
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.authorizer1(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)("DENY " + parentOp$2 + " should imply DENY " + op));
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)("DENY " + parentOp$2 + " should not imply DENY " + op));
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$6) {
        return x$6.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$7) {
        return x$7.exception().isPresent();
    }

    public AuthorizerTest() {
        BaseAuthorizerTest.$init$(this);
        this.PLAINTEXT = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "127.0.0.1", 9020);
        this.allowReadAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.READ, AclPermissionType.ALLOW);
        this.allowWriteAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        this.denyReadAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.READ, AclPermissionType.DENY);
        this.wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        this.prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry.WILDCARD_PRINCIPAL_STRING);
        Statics.releaseFence();
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AuthorizerTest kafka$security$authorizer$AuthorizerTest$CustomPrincipal$$$outer() {
            return AuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

