/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.UnifiedLog;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.SegmentPosition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\r%b\u0001\u0002$H\u00051CQa\u0015\u0001\u0005\u0002QC\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001-\t\u0013\u0005\u0004\u0001\u0019!a\u0001\n\u0003\u0011\u0007\"\u00035\u0001\u0001\u0004\u0005\t\u0015)\u0003Z\u0011\u001dI\u0007A1A\u0005\u0002)Da\u0001\u001f\u0001!\u0002\u0013Y\u0007\"B=\u0001\t\u0003Q\bBBA\u0007\u0001\u0011\u0005!\u0010\u0003\u0004\u0002\u0018\u0001!\tA\u001f\u0005\u0007\u0003C\u0001A\u0011\u0001>\t\r\u0005\u0015\u0002\u0001\"\u0001{\u0011\u0019\tI\u0003\u0001C\u0001u\"1\u0011Q\u0006\u0001\u0005\u0002iDa!!\r\u0001\t\u0003Q\bBBA\u001b\u0001\u0011\u0005!\u0010\u0003\u0004\u0002:\u0001!\tA\u001f\u0005\u0007\u0003{\u0001A\u0011\u0001>\t\r\u0005\u0005\u0003\u0001\"\u0001{\u0011\u0019\t)\u0005\u0001C\u0001u\"1\u0011\u0011\n\u0001\u0005\u0002iDa!!\u0014\u0001\t\u0003Q\bBBA)\u0001\u0011\u0005!\u0010\u0003\u0004\u0002V\u0001!\tA\u001f\u0005\u0007\u00033\u0002A\u0011\u0001>\t\r\u0005u\u0003\u0001\"\u0001{\u0011\u0019\t\t\u0007\u0001C\u0001u\"1\u0011Q\r\u0001\u0005\u0002iDa!!\u001b\u0001\t\u0003Q\bbBA7\u0001\u0011%\u0011q\u000e\u0005\b\u0003k\u0002A\u0011BA<\u0011\u0019\tY\t\u0001C\u0001u\"1\u0011q\u0012\u0001\u0005\u0002iDa!a%\u0001\t\u0003Q\bBBAL\u0001\u0011\u0005!\u0010\u0003\u0004\u0002\u001c\u0002!\tA\u001f\u0005\u0007\u0003?\u0003A\u0011\u0001>\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"1\u0011\u0011\u001a\u0001\u0005\u0002iDa!!4\u0001\t\u0003Q\bBBAi\u0001\u0011\u0005!\u0010\u0003\u0004\u0002V\u0002!\tA\u001f\u0005\u0007\u00033\u0004A\u0011\u0001>\t\r\u0005u\u0007\u0001\"\u0001{\u0011\u0019\t\t\u000f\u0001C\u0001u\"1\u0011Q\u001d\u0001\u0005\u0002iDa!!;\u0001\t\u0003Q\bBBAw\u0001\u0011\u0005!\u0010\u0003\u0004\u0002r\u0002!\tA\u001f\u0005\u0007\u0003k\u0004A\u0011\u0001>\t\r\u0005e\b\u0001\"\u0001{\u000f\u001d\tip\u0012E\u0001\u0003\u007f4aAR$\t\u0002\t\u0005\u0001BB*5\t\u0003\u0011\u0019A\u0002\u0004\u0003\u0006Q\u0002!q\u0001\u0005\u0007'Z\"\tAa\f\t\u000f\u0005\rg\u0007\"\u0011\u00036!9!1\n\u001c\u0005B\t5\u0003b\u0002B/m\u0011\u0005#q\f\u0005\n\u0005_\"$\u0019!C\u0001\u0005cB\u0001B!\u001f5A\u0003%!1\u000f\u0005\b\u0005w\"D\u0011\u0001B?\u0011%\u0011)\u000bNI\u0001\n\u0003\u00119\u000bC\u0004\u0003>R\"\tAa0\t\u0013\t\u001dG'%A\u0005\u0002\t\u001d\u0006b\u0002Bei\u0011\u0005!1\u001a\u0005\b\u0005'$D\u0011\u0001Bk\u0011\u001d\u0011Y\u000e\u000eC\u0001\u0005;DqAa75\t\u0003\u0011)\u0010C\u0004\u0004\nQ\"Iaa\u0003\u0003)-\u000bgm[1NKR\fG-\u0019;b\u0019><G+Z:u\u0015\tA\u0015*\u0001\u0003sC\u001a$(\"\u0001&\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0006C\u0001,\u0001\u001b\u00059\u0015a\u0002;f[B$\u0015N]\u000b\u00023B\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0003S>T\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u0002a7\n!a)\u001b7f\u0003-!X-\u001c9ESJ|F%Z9\u0015\u0005\r4\u0007C\u0001(e\u0013\t)wJ\u0001\u0003V]&$\bbB4\u0004\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0014\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\u00115|7m\u001b+j[\u0016,\u0012a\u001b\t\u0003YZl\u0011!\u001c\u0006\u0003]>\fA!\u001e;jY*\u0011\u0001/]\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005)\u0013(BA:u\u0003\u0019\t\u0007/Y2iK*\tQ/A\u0002pe\u001eL!a^7\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0003\rD#a\u0002?\u0011\u0007u\fI!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0004CBL'\u0002BA\u0002\u0003\u000b\tqA[;qSR,'OC\u0002\u0002\bQ\fQA[;oSRL1!a\u0003\u007f\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0001\"!\u0005\u0011\u0007u\f\u0019\"C\u0002\u0002\u0016y\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0015Q,7\u000f^\"p]\u001aLw\rK\u0002\n\u00037\u00012!`A\u000f\u0013\r\tyB \u0002\u0005)\u0016\u001cH/\u0001\u000euKN$XK\\3ya\u0016\u001cG/\u001a3BaB,g\u000eZ(gMN,G\u000fK\u0002\u000b\u00037\t!\u0003^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi\"\u001a1\"a\u0007\u0002?Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e$s_6,e\u000eZ(gMN,G\u000fK\u0002\r\u00037\t\u0011\u0005^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi&sW*\u001b3eY\u0016|eMQ1uG\"D3!DA\u000e\u0003!\"Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;MCR,'\u000f\u00165b]\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\rq\u00111D\u0001!i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|G/T;dQ2\u000bG/\u001a:Fa>\u001c\u0007\u000eK\u0002\u0010\u00037\tq\u0004^3ti\"Kw\r[,bi\u0016\u0014X.\u0019:l\u001f\u001a47/\u001a;NKR\fG-\u0019;bQ\r\u0001\u00121D\u0001'i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GOQ3g_J,Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\t\u0002\u001c\u0005\u0001C/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\t&4XM]4j]\u001e,\u0005o\\2iQ\r\u0011\u00121D\u0001\u001di\u0016\u001cHo\u0011:fCR,7K\\1qg\"|Go\u00147eKJ,\u0005o\\2iQ\r\u0019\u00121D\u0001#i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GoV5uQ6K7o]5oO\u0016\u0003xn\u00195)\u0007Q\tY\"\u0001\u000euKN$8I]3bi\u0016,\u00050[:uS:<7K\\1qg\"|G\u000fK\u0002\u0016\u00037\t1\u0002^3tiR{\u0007/[2JI\"\u001aa#a\u0007\u0002/Q,7\u000f\u001e*fC\u0012l\u0015n]:j]\u001e\u001cf.\u00199tQ>$\bfA\f\u0002\u001c\u0005iB/Z:u\t\u0016dW\r^3O_:,\u00050[:uK:$8K\\1qg\"|G\u000fK\u0002\u0019\u00037\t\u0011\u0005^3tiR\u0013XO\\2bi\u00164U\u000f\u001c7z)>d\u0015\r^3tiNs\u0017\r]:i_RD3!GA\u000e\u0003\r\"Xm\u001d;UeVt7-\u0019;f/&dGNU3n_Z,w\n\u001c3feNs\u0017\r]:i_RD3AGA\u000e\u0003\r\"Xm\u001d;Ti\u0006\u0014H/\u001e9XSRD\u0017J\u001c<bY&$7K\\1qg\"|Go\u0015;bi\u0016D3aGA\u000e\u00031\"Xm\u001d;T]\u0006\u00048\u000f[8u\t\u0016dW\r^5p]^KG\u000f[%om\u0006d\u0017\u000eZ*oCB\u001c\bn\u001c;Ti\u0006$X\rK\u0002\u001d\u00037\ta\"\\3uC\u0012\fG/\u0019'pO\u0012K'\u000fF\u0002Z\u0003cBa!a\u001d\u001e\u0001\u0004I\u0016A\u00027pO\u0012K'/\u0001\nxe&$X-R7qif\u001cf.\u00199tQ>$H#B2\u0002z\u0005u\u0004BBA>=\u0001\u0007\u0011,A\u0006nKR\fG-\u0019;b\t&\u0014\bbBA@=\u0001\u0007\u0011\u0011Q\u0001\u000bg:\f\u0007o\u001d5pi&#\u0007\u0003BAB\u0003\u000fk!!!\"\u000b\u0005!\u000b\u0018\u0002BAE\u0003\u000b\u0013ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007.A\fuKN$Hi\\3t]R$&/\u001e8dCR,g)\u001e7ms\"\u001aq$a\u0007\u00027Q,7\u000f^\"mK\u0006tW\u000f\u001d)beRL\u0017\r\\*oCB\u001c\bn\u001c;tQ\r\u0001\u00131D\u0001\u001ai\u0016\u001cHo\u00117fC:,\bo\u00147eKJ\u001cf.\u00199tQ>$8\u000fK\u0002\"\u00037\tQ\u0005^3ti\u000e\u0013X-\u0019;f%\u0016\u0004H.[2bi\u0016$Gj\\4UeVt7-\u0019;fg\u001a+H\u000e\\=)\u0007\t\nY\"\u0001\tuKN$X*\u0019=CCR\u001c\u0007nU5{K\"\u001a1%a\u0007\u0002=Q,7\u000f\u001e+sk:\u001c\u0017\r^3CK2|w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007f\u0001\u0013\u0002\u001c\u0005q!-^5mI\u001a+H\u000e\u001c\"bi\u000eDG\u0003CAT\u0003o\u000b\t-!2\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u00061!/Z2pe\u0012T1!!-r\u0003\u0019\u0019w.\\7p]&!\u0011QWAV\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011\u0011X\u0013A\u0002\u0005m\u0016a\u00037fC\u0012,'/\u00129pG\"\u00042ATA_\u0013\r\tyl\u0014\u0002\u0004\u0013:$\bbBAbK\u0001\u0007\u00111X\u0001\u000be\u0016\u001cwN\u001d3TSj,\u0007bBAdK\u0001\u0007\u00111X\u0001\u0014[\u0006D()\u0019;dQNK'0Z%o\u0005f$Xm]\u0001+i\u0016\u001cHOV1mS\u0012\fG/Z#q_\u000eDwI]3bi\u0016\u0014H\u000b[1o\u0019\u0006\u001cHo\u00138po:,\u0005o\\2iQ\r1\u00131D\u0001-i\u0016\u001cHOV1mS\u0012\fG/Z#q_\u000eDG*Z:t)\"\fgn\u00147eKN$8K\\1qg\"|G/\u00129pG\"D3aJA\u000e\u00039\"Xm\u001d;WC2LG-\u0019;f\u001f\u001a47/\u001a;MKN\u001cH\u000b[1o\u001f2$Wm\u001d;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;)\u0007!\nY\"A\u0017uKN$h+\u00197jI\u0006$Xm\u00144gg\u0016$X)];bYR{w\n\u001c3fgR\u001cf.\u00199tQ>$xJ\u001a4tKRD3!KA\u000e\u0003\t#Xm\u001d;WC2LG-\u0019;f+:\\gn\\<o\u000bB|7\r\u001b'fgN$\u0006.\u00198MCN$8J\\8x]\u001e\u0013X-\u0019;feRC\u0017M\\(mI\u0016\u001cHo\u00158baNDw\u000e\u001e\u0015\u0004U\u0005m\u0011\u0001\u000b;fgR4\u0016\r\\5eCR,W\t]8dQ2+7o\u001d+iC:4\u0015N]:u\u000bB|7\r[%o\u0019><\u0007fA\u0016\u0002\u001c\u0005!C/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u000fJ,\u0017\r\u001e+iC:,e\u000eZ(gMN,G\u000fK\u0002-\u00037\tQ\u0004^3tiZ\u000bG.\u001b3bi\u0016|eMZ:fi2+7o\u001d+iC:dUi\u0014\u0015\u0004[\u0005m\u0011a\b;fgR4\u0016\r\\5eCR,g+\u00197jI\u0016\u0003xn\u00195B]\u0012|eMZ:fi\"\u001aa&a\u0007\u0002MQ,7\u000f^!em\u0006t7-\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r^!gi\u0016\u00148\t\\3b]&tw\rK\u00020\u00037\t1\u0003^3ti\u0012+G.\u001a;f':\f\u0007o\u001d5piND3\u0001MA\u000e\u0003Y!Xm\u001d;T_\u001a$(+\u001a;f]RLwN\u001c'j[&$\bfA\u0019\u0002\u001c\u0005\u0011C/Z:u'\u0016<W.\u001a8ug2+7o\u001d+iC:d\u0015\r^3tiNs\u0017\r]:i_RD3AMA\u000e\u0003QY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w\rV3tiB\u0011a\u000bN\n\u0003i5#\"!a@\u0003\u001d\tKH/Z!se\u0006L8+\u001a:eKN)aG!\u0003\u0003\u0016A!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010u\u000bA\u0001\\1oO&!!1\u0003B\u0007\u0005\u0019y%M[3diB1!q\u0003B\u0010\u0005Gi!A!\u0007\u000b\t\tm!QD\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0007\u0005Ev.\u0003\u0003\u0003\"\te!a\u0003*fG>\u0014HmU3sI\u0016\u0004RA\u0014B\u0013\u0005SI1Aa\nP\u0005\u0015\t%O]1z!\rq%1F\u0005\u0004\u0005[y%\u0001\u0002\"zi\u0016$\"A!\r\u0011\u0007\tMb'D\u00015)\u0019\tYLa\u000e\u0003<!9!\u0011\b\u001dA\u0002\t\r\u0012\u0001\u00023bi\u0006DqA!\u00109\u0001\u0004\u0011y$\u0001\ntKJL\u0017\r\\5{CRLwN\\\"bG\",\u0007\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\t\t\u0015\u0013qV\u0001\taJ|Go\\2pY&!!\u0011\nB\"\u0005ay%M[3diN+'/[1mSj\fG/[8o\u0007\u0006\u001c\u0007.Z\u0001\u0006oJLG/\u001a\u000b\bG\n=#\u0011\u000bB*\u0011\u001d\u0011I$\u000fa\u0001\u0005GAqA!\u0010:\u0001\u0004\u0011y\u0004C\u0004\u0003Ve\u0002\rAa\u0016\u0002\u0007=,H\u000f\u0005\u0003\u0003B\te\u0013\u0002\u0002B.\u0005\u0007\u0012\u0001b\u0016:ji\u0006\u0014G.Z\u0001\u0005e\u0016\fG\r\u0006\u0004\u0003$\t\u0005$1\u000e\u0005\b\u0005GR\u0004\u0019\u0001B3\u0003\u0015Ig\u000e];u!\u0011\u0011\tEa\u001a\n\t\t%$1\t\u0002\t%\u0016\fG-\u00192mK\"9!Q\u000e\u001eA\u0002\u0005m\u0016\u0001B:ju\u0016\f\u0001\u0004R3gCVdG/T3uC\u0012\fG/\u0019'pO\u000e{gNZ5h+\t\u0011\u0019\bE\u0002W\u0005kJ1Aa\u001eH\u0005EiU\r^1eCR\fGj\\4D_:4\u0017nZ\u0001\u001a\t\u00164\u0017-\u001e7u\u001b\u0016$\u0018\rZ1uC2{wmQ8oM&<\u0007%\u0001\fck&dG-T3uC\u0012\fG/\u0019'pO\u0006sG\rR5s)!\u0011yHa'\u0003\u001e\n\u0005\u0006#\u0003(\u0003\u0002\n\u0015%Q\u0013B:\u0013\r\u0011\u0019i\u0014\u0002\u0007)V\u0004H.Z\u001a\u0011\t\t\u001d%\u0011S\u0007\u0003\u0005\u0013SAAa#\u0003\u000e\u0006!a-\u001b7f\u0015\r\u0011y)X\u0001\u0004]&|\u0017\u0002\u0002BJ\u0005\u0013\u0013A\u0001U1uQB\u0019aKa&\n\u0007\teuI\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO\")q+\u0010a\u00013\"1!qT\u001fA\u0002-\fA\u0001^5nK\"I!1U\u001f\u0011\u0002\u0003\u0007!1O\u0001\u0012[\u0016$\u0018\rZ1uC2{wmQ8oM&<\u0017\u0001\t2vS2$W*\u001a;bI\u0006$\u0018\rT8h\u0003:$G)\u001b:%I\u00164\u0017-\u001e7uIM*\"A!++\t\tM$1V\u0016\u0003\u0005[\u0003BAa,\u0003:6\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013),A\u0005v]\u000eDWmY6fI*\u0019!qW(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\nE&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\t\u0005+\u0013\tMa1\u0003F\")qk\u0010a\u00013\"1!qT A\u0002-D\u0011Ba)@!\u0003\u0005\rAa\u001d\u00025\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0002#\r\u0014X-\u0019;f\u001d\u0016<8K\\1qg\"|G\u000fF\u0003d\u0005\u001b\u0014\t\u000eC\u0004\u0003P\u0006\u0003\rA!&\u0002\u00071|w\rC\u0004\u0002\u0000\u0005\u0003\r!!!\u00025\r\u0014X-\u0019;f\u001d\u0016<8K\\1qg\"|G/\u00168dW\u0016\u001c7.\u001a3\u0015\u000b\r\u00149N!7\t\u000f\t='\t1\u0001\u0003\u0016\"9\u0011q\u0010\"A\u0002\u0005\u0005\u0015AB1qa\u0016tG\r\u0006\u0005\u0003`\n\u0015(Q\u001eBy!\u0011\t\u0019I!9\n\t\t\r\u0018Q\u0011\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\t=7\t1\u0001\u0003hB!\u00111\u0011Bu\u0013\u0011\u0011Y/!\"\u0003\u001bI+\u0007\u000f\\5dCR,G\rT8h\u0011\u001d\u0011yo\u0011a\u0001\u0003w\u000bqB\\;nE\u0016\u0014xJ\u001a*fG>\u0014Hm\u001d\u0005\b\u0005g\u001c\u0005\u0019AA^\u0003\u0015)\u0007o\\2i)\u0015\u0019'q_B\u0004\u0011\u001d\u0011I\u0010\u0012a\u0001\u0005w\fab\u001d8baNDw\u000e^,sSR,'\u000f\u0005\u0003\u0003~\u000e\rQB\u0001B\u0000\u0015\r\u0019\t!]\u0001\tg:\f\u0007o\u001d5pi&!1Q\u0001B\u0000\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;Xe&$XM\u001d\u0005\b\u0005_$\u0005\u0019AA^\u0003I\u0019'/Z1uK2{w\rR5sK\u000e$xN]=\u0015\u000be\u001biaa\u0004\t\r\u0005MT\t1\u0001Z\u0011\u001d\u0019\t\"\u0012a\u0001\u0007'\t!\u0002\\8h\t&\u0014h*Y7f!\u0011\u0019)ba\t\u000f\t\r]1q\u0004\t\u0004\u00073yUBAB\u000e\u0015\r\u0019ibS\u0001\u0007yI|w\u000e\u001e \n\u0007\r\u0005r*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007K\u00199C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007Cy\u0005")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        KafkaMetadataLogTest$.MODULE$.append(snapshotWriter, numberOfRecords);
    }

    public static LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        return KafkaMetadataLogTest$.MODULE$.append(log, numberOfRecords, epoch);
    }

    public static void createNewSnapshotUnckecked(KafkaMetadataLog log, OffsetAndEpoch snapshotId) {
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
    }

    public static void createNewSnapshot(KafkaMetadataLog log, OffsetAndEpoch snapshotId) {
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put("process.roles", Arrays.asList("broker"));
        props.put("controller.quorum.voters", "1@localhost:9093");
        props.put("node.id", BoxesRunTime.boxToInteger((int)2));
        props.put("controller.listener.names", "SSL");
        props.put("metadata.log.segment.bytes", BoxesRunTime.boxToInteger((int)10240));
        props.put("metadata.log.segment.ms", BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply(kafkaConfig, 0x800000, 0x800000);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put("metadata.log.segment.min.bytes", BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply(kafkaConfig, 0x800000, 0x800000);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnexpectedAppendOffset() {
        void withRecords_records;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
        NoCompression withRecords_compression = Compression.NONE;
        Object var6_6 = null;
        simpleRecordArray = null;
        log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            NoCompression withRecords_compression = Compression.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            NoCompression withRecords_compression = Compression.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsFollower((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        });
    }

    @Test
    public void testCreateSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotInMiddleOfBatch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), epoch)));
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    @Test
    public void testHighWatermarkOffsetMetadata() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        LogOffsetMetadata highWatermarkMetadata = log.highWatermark();
        Assertions.assertEquals((long)numberOfRecords, (long)highWatermarkMetadata.offset());
        Assertions.assertTrue((boolean)highWatermarkMetadata.metadata().isPresent());
        SegmentPosition segmentPosition = (SegmentPosition)highWatermarkMetadata.metadata().get();
        Assertions.assertEquals((long)0L, (long)segmentPosition.baseOffset());
        Assertions.assertTrue((segmentPosition.relativePosition() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numberOfRecords).foreach((Function1 & Serializable)x$2 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, epoch));
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, LogStartOffsetIncrementReason.SegmentDeletion);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotOlderEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    @Test
    public void testCreateExistingSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset());
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset());
    }

    @Test
    public void testTruncateFullyToLatestSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, sameEpochSnapshotId);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset());
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, greaterEpochSnapshotId);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId3);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, greaterSnapshotId);
        Assertions.assertNotEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        Assertions.assertTrue((boolean)var3_3.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        var3_3.close();
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$4 -> x$4.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$3((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        UnifiedLog qual$1 = log.log();
        Option x$2 = qual$1.truncateFullyAndStartAt$default$2();
        qual$1.truncateFullyAndStartAt(100L, x$2);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        UnifiedLog qual$2 = log.log();
        Option x$4 = qual$2.truncateFullyAndStartAt$default$2();
        qual$2.truncateFullyAndStartAt(200L, x$4);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.log().truncateFullyAndStartAt(100L, log.log().truncateFullyAndStartAt$default$2());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        return new File(logDir.getAbsolutePath(), LocalLog.logDirName((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition()));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        Using$.MODULE$.resource((Object)FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId), (Function1 & Serializable)x$5 -> {
            x$5.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDoesntTruncateFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, olderEpochSnapshotId);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, olderOffsetSnapshotId);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void var2_2;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, snapshotId);
        var3_3.close();
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)var3_3.startOffset());
        Assertions.assertEquals((int)epoch, (int)var3_3.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)var3_3.endOffset().offset());
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$7 -> x$7.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId3);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, greaterSnapshotId);
        var3_3.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$9 -> x$9.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$3((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset());
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig copy$default$1_this = metadataLogConfig;
        Object var20_4 = null;
        int x$2 = copy$default$1_this.logSegmentBytes();
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$2_this = metadataLogConfig2;
        Object var21_6 = null;
        int x$3 = copy$default$2_this.logSegmentMinBytes();
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$3_this = metadataLogConfig3;
        Object var22_8 = null;
        long x$4 = copy$default$3_this.logSegmentMillis();
        MetadataLogConfig metadataLogConfig4 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig4 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$4_this = metadataLogConfig4;
        Object var23_10 = null;
        long x$5 = copy$default$4_this.retentionMaxBytes();
        MetadataLogConfig metadataLogConfig5 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig5 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$5_this = metadataLogConfig5;
        Object var24_12 = null;
        long x$6 = copy$default$5_this.retentionMillis();
        MetadataLogConfig metadataLogConfig6 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig6 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$7_this = metadataLogConfig6;
        Object var25_14 = null;
        int x$7 = copy$default$7_this.maxFetchSizeInBytes();
        MetadataLogConfig metadataLogConfig7 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig7 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$8_this = metadataLogConfig7;
        Object var26_16 = null;
        long x$8 = copy$default$8_this.fileDeleteDelayMs();
        MetadataLogConfig metadataLogConfig8 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig8 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig8;
        Object var27_18 = null;
        int x$9 = copy$default$9_this.nodeId();
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), new MetadataLogConfig(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9));
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset());
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset());
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset());
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), (Compression)Compression.NONE, 0L, this.mockTime().milliseconds(), leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset(), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        log.log().maybeIncrementLogStartOffset((long)offset, LogStartOffsetIncrementReason.SegmentDeletion);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset(), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().maxFetchSizeInBytes(), 60000L, 1);
        int n = config.nodeId();
        long l = config.fileDeleteDelayMs();
        int n2 = config.maxFetchSizeInBytes();
        int n3 = config.maxBatchSizeInBytes();
        long l2 = config.retentionMillis();
        long l3 = config.retentionMaxBytes();
        long l4 = config.logSegmentMillis();
        int n4 = config.logSegmentMinBytes();
        int copy_logSegmentBytes = config.logSegmentBytes();
        new MetadataLogConfig(copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$10 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId1);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId2);
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteSnapshots() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        void copy_logSegmentBytes;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig3;
        Object var17_1 = null;
        int n = copy$default$9_this.nodeId();
        long l = metadataLogConfig2.fileDeleteDelayMs();
        int n2 = metadataLogConfig.maxFetchSizeInBytes();
        int n3 = 100;
        long l2 = 60000L;
        long l3 = 1024L;
        long l4 = 10000L;
        int n4 = 1024;
        int n5 = 1024;
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        MetadataLogConfig config = new MetadataLogConfig((int)copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable)x$11 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Object var3_13 = null;
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSoftRetentionLimit() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        void copy_logSegmentBytes;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig3;
        Object var19_1 = null;
        int n = copy$default$9_this.nodeId();
        long l = metadataLogConfig2.fileDeleteDelayMs();
        int n2 = metadataLogConfig.maxFetchSizeInBytes();
        int n3 = 100;
        long l2 = 60000L;
        long l3 = 10240L;
        long l4 = 10000L;
        int n4 = 10240;
        int n5 = 10240;
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        MetadataLogConfig config = new MetadataLogConfig((int)copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$12 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        Using$.MODULE$.resource(log.createNewSnapshotUnchecked(snapshotId1).get(), (Function1 & Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        Using$.MODULE$.resource(log.createNewSnapshotUnchecked(snapshotId2).get(), (Function1 & Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        void copy_logSegmentBytes;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig3;
        Object var22_1 = null;
        int n = copy$default$9_this.nodeId();
        long l = metadataLogConfig2.fileDeleteDelayMs();
        int n2 = metadataLogConfig.maxFetchSizeInBytes();
        int n3 = 200;
        long l2 = 60000L;
        long l3 = 10240L;
        long l4 = 10000L;
        int n4 = 10240;
        int n5 = 10240;
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        MetadataLogConfig config = new MetadataLogConfig((int)copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$13 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset()));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.log().logSegments()).asScala().drop(1)).head()).baseOffset(), 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId1);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.log().logSegments()).asScala().drop(2)).head()).baseOffset(), 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId2);
        long defaultLogRetentionMs = 1209600000L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)(log.startOffset() + " must be greater than 0"));
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)("latest snapshot offset (" + latestSnapshotOffset + ") must be >= log start offset (" + log.startOffset() + ")"));
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$3(KafkaMetadataLog log$9, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$9.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$3(KafkaMetadataLog log$10, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$10.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$15, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$15.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$15, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$15.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$15, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

