/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005B\u0015Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u0001.\u0011\u0019A\u0004\u0001)A\u0005]!I\u0011\b\u0001a\u0001\u0002\u0004%\tA\u000f\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002!C\u0011B\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B\u001e\t\u000b=\u0003A\u0011\t)\t\u000be\u0003A\u0011\t.\t\u000b-\u0004A\u0011\t7\t\u000bE\u0004A\u0011\u0001:\t\r}\u0004A\u0011AA\u0001\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u0013\u0005]\u0003!%A\u0005\n\u0005e#\u0001\b#z]\u0006l\u0017n\u0019(v[:+Go^8sWRC'/Z1egR+7\u000f\u001e\u0006\u0003+Y\tqA\\3uo>\u00148NC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0012AB:feZ,'/\u0003\u0002 9\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\u0006A\u0011N\u001c;fe:\fG.F\u0001/!\tyC'D\u00011\u0015\t\t$'\u0001\u0003mC:<'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012aa\u0015;sS:<\u0017!C5oi\u0016\u0014h.\u00197!\u0003!)\u0007\u0010^3s]\u0006d\u0017!C3yi\u0016\u0014h.\u00197!\u0003\u0015\tG-\\5o+\u0005Y\u0004C\u0001\u001fF\u001b\u0005i$BA\u001d?\u0015\ty\u0004)A\u0004dY&,g\u000e^:\u000b\u0005]\t%B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001eL!AR\u001f\u0003\u000b\u0005#W.\u001b8\u0002\u0013\u0005$W.\u001b8`I\u0015\fHCA%M!\t9#*\u0003\u0002LQ\t!QK\\5u\u0011\u001di\u0005\"!AA\u0002m\n1\u0001\u001f\u00132\u0003\u0019\tG-\\5oA\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u0003\u0013FCQA\u0015\u0006A\u0002M\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\t!v+D\u0001V\u0015\t1&'\u0001\u0003vi&d\u0017B\u0001-V\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0013nCQ\u0001X\u0006A\u0002u\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003=\u0016l\u0011a\u0018\u0006\u0003A\u0006\f1!\u00199j\u0015\t\u00117-A\u0004kkBLG/\u001a:\u000b\u0005\u0011\u001c\u0015!\u00026v]&$\u0018B\u00014`\u0005!!Vm\u001d;J]\u001a|\u0007FA\u0006i!\tq\u0016.\u0003\u0002k?\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u0013\u0015\u0003\u00199\u0004\"AX8\n\u0005A|&!C!gi\u0016\u0014X)Y2i\u0003Q9W\r\u001e(v[:+Go^8sWRC'/Z1egR\u0011ae\u001d\u0005\u0006i6\u0001\r!^\u0001\tY&\u001cH/\u001a8feB\u0011a/ \b\u0003on\u0004\"\u0001\u001f\u0015\u000e\u0003eT!A\u001f\r\u0002\rq\u0012xn\u001c;?\u0013\ta\b&\u0001\u0004Qe\u0016$WMZ\u0005\u0003kyT!\u0001 \u0015\u00029Q,7\u000f\u001e#z]\u0006l\u0017n\u0019(v[:+Go^8sWRC'/Z1egR\u0019\u0011*a\u0001\t\r\u0005\u0015a\u00021\u0001v\u0003\u0019\tXo\u001c:v[\"\u001aa\"!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004b\u0003\u0019\u0001\u0018M]1ng&!\u00111CA\u0007\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\b\u001d\u0005]\u00111EA\u0013!\u0011\tI\"a\b\u000e\u0005\u0005m!\u0002BA\u000f\u0003\u001b\t\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u0003C\tYBA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0003\u0003O\t#!!\u000b\u0002\u000b-\u0014\u0018M\u001a;\u0002%I,7m\u001c8gS\u001e,(/Z*feZ,'o\u001d\u000b\u0006\u0013\u0006=\u00121\u0007\u0005\u0007\u0003cy\u0001\u0019A*\u0002\u00119,w\u000f\u0015:paNDq!!\u000e\u0010\u0001\u0004\t9$A\u0007b!J|\u0007\u000fV8WKJLg-\u001f\t\u0006O\u0005eR/^\u0005\u0004\u0003wA#A\u0002+va2,''A\tde\u0016\fG/Z!e[&t7\t\\5f]R$\u0012aO\u0001\u0016o\u0006LGOR8s\u0007>tg-[4P]N+'O^3s)\u001dI\u0015QIA%\u0003\u001bBa!a\u0012\u0012\u0001\u0004)\u0018\u0001\u00039s_Bt\u0015-\\3\t\r\u0005-\u0013\u00031\u0001v\u0003%\u0001(o\u001c9WC2,X\rC\u0005\u0002PE\u0001\n\u00111\u0001\u0002R\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004O\u0005M\u0013bAA+Q\t!Aj\u001c8h\u0003}9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$C-\u001a4bk2$HeM\u000b\u0003\u00037RC!!\u0015\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GMC\u0002\u0002j!\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti'a\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DynamicNumNetworkThreadsTest
extends BaseRequestTest {
    private final String internal;
    private final String external;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String internal() {
        return this.internal;
    }

    public String external() {
        return this.external;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("listeners", this.internal() + "://localhost:0, " + this.external() + "://localhost:0");
        properties.put("listener.security.protocol.map", this.internal() + ":PLAINTEXT, " + this.external() + ":PLAINTEXT");
        properties.put("listener.name." + this.internal().toLowerCase() + ".num.network.threads", "2");
        properties.put("num.network.threads", Integer.toString(3));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), new Properties()));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), "test", this.brokers(), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        Assertions.assertEquals((int)3, (int)this.getNumNetworkThreads(this.external()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        super.tearDown();
    }

    public int getNumNetworkThreads(String listener) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(((KafkaBroker)this.brokers().head()).metrics().metrics().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$1(x$2)))).count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DynamicNumNetworkThreadsTest.$anonfun$getNumNetworkThreads$2(listener, x$3)));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicNumNetworkThreads(String quorum) {
        int newBaseNetworkThreadsCount = 4;
        Properties props = new Properties();
        props.put("num.network.threads", Integer.toString(newBaseNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)"num.network.threads", (Object)Integer.toString(newBaseNetworkThreadsCount)));
        Assertions.assertEquals((int)2, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
        int newInternalNetworkThreadsCount = 3;
        props = new Properties();
        props.put("listener.name." + this.internal().toLowerCase() + ".num.network.threads", Integer.toString(newInternalNetworkThreadsCount));
        this.reconfigureServers(props, (Tuple2<String, String>)new Tuple2((Object)("listener.name." + this.internal().toLowerCase() + ".num.network.threads"), (Object)Integer.toString(newInternalNetworkThreadsCount)));
        Assertions.assertEquals((int)newInternalNetworkThreadsCount, (int)this.getNumNetworkThreads(this.internal()));
        Assertions.assertEquals((int)newBaseNetworkThreadsCount, (int)this.getNumNetworkThreads(this.external()));
    }

    private void reconfigureServers(Properties newProps, Tuple2<String, String> aPropToVerify) {
        Admin adminClient = this.createAdminClient();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), adminClient, newProps, false, AlterConfigOp.OpType.SET).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        adminClient.close();
    }

    private Admin createAdminClient() {
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.brokers(), new ListenerName(this.securityProtocol().name));
        Properties config = new Properties();
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicNumNetworkThreadsTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$1(MetricName x$2) {
        String string = x$2.name();
        String string2 = "request-rate";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$getNumNetworkThreads$2(String listener$1, MetricName x$3) {
        String string = listener$1;
        Object v = x$3.tags().get("listener");
        return !(string != null ? !string.equals(v) : v != null);
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicNumNetworkThreadsTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaBroker)$this.brokers().head()).config().originals().get(propName$1));
    }

    public DynamicNumNetworkThreadsTest() {
        this.internal = "PLAINTEXT";
        this.external = "EXTERNAL";
    }
}

