/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.api.Flaky;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-g\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005BqBqa\u0011\u0001C\u0002\u0013\u0005A\t\u0003\u0004N\u0001\u0001\u0006I!\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019a\u0006\u0001)A\u0005!\"9Q\f\u0001b\u0001\n\u0003q\u0006BB3\u0001A\u0003%q\fC\u0004g\u0001\t\u0007I\u0011\u0001#\t\r\u001d\u0004\u0001\u0015!\u0003F\u0011\u001dA\u0007A1A\u0005\u0002qBa!\u001b\u0001!\u0002\u0013i\u0004\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0001l\u0011%!\b\u00011AA\u0002\u0013\u0005Q\u000fC\u0005|\u0001\u0001\u0007\t\u0011)Q\u0005Y\"IA\u0010\u0001a\u0001\u0002\u0004%\t! \u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u0012\u0001\u0001\r\u0011!Q!\nyDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!!4\u0001\t\u0013\ty\rC\u0004\u0002j\u0002!I!a;\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!1\u0001\u0001\u0005\n\t\u0015\u0001\"\u0003B\r\u0001E\u0005I\u0011\u0002B\u000e\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAaA!\u0011\u0001\t\u0003a\u0004b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u001f\u0002A\u0011\u0002B)\u0011%\u0011)\u0006AI\u0001\n\u0013\u00119\u0006C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t\r\u0004\u0001\"\u0003\u0003f!9!Q\u000f\u0001\u0005\n\t]\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0011\u001d\u00119\n\u0001C\u0005\u00053\u0013!\u0004R=oC6L7mQ8o]\u0016\u001cG/[8o#V|G/\u0019+fgRT!\u0001L\u0017\u0002\u000f9,Go^8sW*\ta&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b.\u0003\u0019\u0019XM\u001d<fe&\u0011ag\r\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011aK\u0001\fEJ|7.\u001a:D_VtG/F\u0001>!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\rIe\u000e^\u0001\u0006i>\u0004\u0018nY\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005Y\u0006twMC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\tY&\u001cH/\u001a8feV\t\u0001\u000b\u0005\u0002R56\t!K\u0003\u0002-'*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u000592&BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001eL!a\u0017*\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002\u00131L7\u000f^3oKJ\u0004\u0013\u0001\u00047pG\u0006d\u0017\t\u001a3sKN\u001cX#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tL\u0015a\u00018fi&\u0011A-\u0019\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/A\u0007m_\u000e\fG.\u00113ee\u0016\u001c8\u000fI\u0001\fk:\\gn\\<o\u0011>\u001cH/\u0001\u0007v].twn\u001e8I_N$\b%A\u000fqY\u0006Lg\u000e^3yi2K7\u000f^3oKJ$UMZ1vYR\fVo\u001c;b\u0003y\u0001H.Y5oi\u0016DH\u000fT5ti\u0016tWM\u001d#fM\u0006,H\u000e^)v_R\f\u0007%\u0001\u0005fq\u0016\u001cW\u000f^8s+\u0005a\u0007CA7s\u001b\u0005q'BA8q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003c&\u000bA!\u001e;jY&\u00111O\u001c\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006aQ\r_3dkR|'o\u0018\u0013fcR\u0011a/\u001f\t\u0003}]L!\u0001_ \u0003\tUs\u0017\u000e\u001e\u0005\bu:\t\t\u00111\u0001m\u0003\rAH%M\u0001\nKb,7-\u001e;pe\u0002\nQ!\u00193nS:,\u0012A \t\u0004\u007f\u0006\u001dQBAA\u0001\u0015\ra\u00181\u0001\u0006\u0004\u0003\u000b)\u0016aB2mS\u0016tGo]\u0005\u0005\u0003\u0013\t\tAA\u0003BI6Lg.A\u0005bI6Lgn\u0018\u0013fcR\u0019a/a\u0004\t\u000fi\f\u0012\u0011!a\u0001}\u00061\u0011\rZ7j]\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0007Y\f9\u0002C\u0004\u0002\u001aM\u0001\r!a\u0007\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0003\u0002\u001e\u0005}Q\"\u00019\n\u0007\u0005\u0005\u0002O\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$2A^A\u0014\u0011\u001d\tI\u0003\u0006a\u0001\u0003W\t\u0001\u0002^3ti&sgm\u001c\t\u0005\u0003[\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\r\t\u0007/\u001b\u0006\u0005\u0003k\t9$A\u0004kkBLG/\u001a:\u000b\u0007\u0005e\u0002,A\u0003kk:LG/\u0003\u0003\u0002>\u0005=\"\u0001\u0003+fgRLeNZ8)\u0007Q\t\t\u0005\u0005\u0003\u0002.\u0005\r\u0013\u0002BA#\u0003_\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#\u0001<)\u0007U\ti\u0005\u0005\u0003\u0002.\u0005=\u0013\u0002BA)\u0003_\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f\u001e#z]\u0006l\u0017nY\"p]:,7\r^5p]F+x\u000e^1\u0015\u0007Y\f9\u0006C\u0004\u0002ZY\u0001\r!a\u0017\u0002\rE,xN];n!\u0011\ti&a\u001b\u000f\t\u0005}\u0013q\r\t\u0004\u0003CzTBAA2\u0015\r\t)gL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%t(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0019\u00065$bAA5\u007f!:a#!\u001d\u0002\u0000\u0005\u0005\u0005\u0003BA:\u0003wj!!!\u001e\u000b\t\u0005E\u0012q\u000f\u0006\u0004\u0003s\u001a\u0016\u0001\u0002;fgRLA!! \u0002v\t)a\t\\1ls\u0006)a/\u00197vK\u0006\u0012\u00111Q\u0001\f\u0017\u000635*Q\u00172oeJ\u0014\bK\u0002\u0017\u0003\u000f\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000b\u0019$\u0001\u0004qCJ\fWn]\u0005\u0005\u0003#\u000bYIA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDsAFAK\u0003C\u000b\u0019\u000b\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*a#\u0002\u0011A\u0014xN^5eKJLA!a(\u0002\u001a\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#!!*\"\u0005\u0005\u001d\u0016!B6sC\u001a$\u0018A\t;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\rF\u0002w\u0003[Cq!!\u0017\u0018\u0001\u0004\tY\u0006K\u0002\u0018\u0003\u000fCsaFAK\u0003C\u000b\u0019\f\f\u0002\u0002&\u0006qC/Z:u\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|gn\u0011:fCRLwN\u001c*bi\u0016\fVo\u001c;b)\r1\u0018\u0011\u0018\u0005\b\u00033B\u0002\u0019AA.Q\rA\u0012q\u0011\u0015\b1\u0005U\u0015\u0011UA`Y\t\t)+\u0001\u0011uKN$H)\u001f8b[&\u001c\u0017\n]\"p]:,7\r^5p]J\u000bG/Z)v_R\fGc\u0001<\u0002F\"9\u0011\u0011L\rA\u0002\u0005m\u0003fA\r\u0002\b\":\u0011$!&\u0002\"\u0006-GFAAS\u0003I\u0011XmY8oM&<WO]3TKJ4XM]:\u0015\u000fY\f\t.!6\u0002`\"9\u00111\u001b\u000eA\u0002\u0005m\u0011\u0001\u00038foB\u0013x\u000e]:\t\u000f\u0005]'\u00041\u0001\u0002Z\u0006y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rE\u0002?\u00037L1!!8@\u0005\u001d\u0011un\u001c7fC:Dq!!9\u001b\u0001\u0004\t\u0019/A\u0007b!J|\u0007\u000fV8WKJLg-\u001f\t\b}\u0005\u0015\u00181LA.\u0013\r\t9o\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0002-U\u0004H-\u0019;f\u0013B\u001cuN\u001c8fGRLwN\u001c*bi\u0016$RA^Aw\u0003oDq!a<\u001c\u0001\u0004\t\t0\u0001\u0002jaB)a(a=\u0002\\%\u0019\u0011Q_ \u0003\r=\u0003H/[8o\u0011\u0019\tIp\u0007a\u0001{\u0005YQ\u000f\u001d3bi\u0016$'+\u0019;f\u0003=9\u0018-\u001b;G_Jd\u0015n\u001d;f]\u0016\u0014Hc\u0001<\u0002\u0000\"9!\u0011\u0001\u000fA\u0002\u0005m\u0013\u0001\u00047jgR,g.\u001a:OC6,\u0017!F<bSR4uN]\"p]\u001aLwm\u00148TKJ4XM\u001d\u000b\bm\n\u001d!1\u0002B\b\u0011\u001d\u0011I!\ba\u0001\u00037\n\u0001\u0002\u001d:pa:\u000bW.\u001a\u0005\b\u0005\u001bi\u0002\u0019AA.\u0003%\u0001(o\u001c9WC2,X\rC\u0005\u0003\u0012u\u0001\n\u00111\u0001\u0003\u0014\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004}\tU\u0011b\u0001B\f\u007f\t!Aj\u001c8h\u0003}9\u0018-\u001b;G_J\u001cuN\u001c4jO>s7+\u001a:wKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005;QCAa\u0005\u0003 -\u0012!\u0011\u0005\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0003,}\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yC!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bqe>$WoY3SKF,Xm\u001d;\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\u0007\tm2+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011yD!\u000f\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG/A\u0004d_:tWm\u0019;\u0015\t\t\u001d#Q\n\t\u0004A\n%\u0013b\u0001B&C\n11k\\2lKRDaAT\u0011A\u0002\u0005m\u0013!G2sK\u0006$X-\u00118e-\u0016\u0014\u0018NZ=D_:tWm\u0019;j_:$2A\u001eB*\u0011!q%\u0005%AA\u0002\u0005m\u0013aI2sK\u0006$X-\u00118e-\u0016\u0014\u0018NZ=D_:tWm\u0019;j_:$C-\u001a4bk2$H%M\u000b\u0003\u00053RC!a\u0017\u0003 \u0005\u0001b/\u001a:jMf\u001cuN\u001c8fGRLwN\u001c\u000b\u0004m\n}\u0003b\u0002B1I\u0001\u0007!qI\u0001\u0007g>\u001c7.\u001a;\u0002)Y,'/\u001b4z\u001b\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t)\u00151(q\rB6\u0011\u0019\u0011I'\na\u0001{\u0005qQ.\u0019=D_:tWm\u0019;j_:\u001c\bb\u0002B7K\u0001\u0007!qN\u0001\u0013G>tg.Z2u/&$\bNR1jYV\u0014X\r\u0005\u0003?\u0005c2\u0018b\u0001B:\u007f\tIa)\u001e8di&|g\u000eM\u0001\u0011G>tg.Z2u\u0003:$g+\u001a:jMf$RA\u001eB=\u0005wBaA\u0014\u0014A\u0002\u0005m\u0003b\u0002B?M\u0001\u0007\u0011\u0011\\\u0001\u0013S\u001etwN]3J\u001f\u0016C8-\u001a9uS>t7/\u0001\fxC&$hi\u001c:D_:tWm\u0019;j_:\u001cu.\u001e8u)\r1(1\u0011\u0005\u0007\u0005\u000b;\u0003\u0019A\u001f\u0002/\u0015D\b/Z2uK\u0012\u001cuN\u001c8fGRLwN\\\"pk:$\u0018\u0001\u0006<fe&4\u0017pQ8o]\u0016\u001cG/[8o%\u0006$X\rF\u0005w\u0005\u0017\u0013yIa%\u0003\u0016\"1!Q\u0012\u0015A\u0002u\n\u0011#\\5o\u0007>tg.Z2uS>t'+\u0019;f\u0011\u0019\u0011\t\n\u000ba\u0001{\u0005\tR.\u0019=D_:tWm\u0019;j_:\u0014\u0016\r^3\t\r9C\u0003\u0019AA.\u0011\u001d\u0011i\b\u000ba\u0001\u00033\f\u0011#\u00197uKJ\u001cE.[3oiF+x\u000e^1t)\u0019\u0011YJ!)\u0003&B\u0019qP!(\n\t\t}\u0015\u0011\u0001\u0002\u0018\u00032$XM]\"mS\u0016tG/U;pi\u0006\u001c(+Z:vYRDaAa)*\u0001\u0004q\u0018aC1e[&t7\t\\5f]RDqAa**\u0001\u0004\u0011I+A\u0004sKF,Xm\u001d;\u0011\u0011\t-&\u0011\u0017B[\u0005\u0003l!A!,\u000b\u0007\t=v(\u0001\u0006d_2dWm\u0019;j_:LAAa-\u0003.\n\u0019Q*\u00199\u0011\t\t]&QX\u0007\u0003\u0005sS1Aa/T\u0003\u0015\tXo\u001c;b\u0013\u0011\u0011yL!/\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010\u0005\u0005\u0003,\nE\u00161\fBb!\u0015q\u00141\u001fBc!\rq$qY\u0005\u0004\u0005\u0013|$A\u0002#pk\ndW\r")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final String unknownHost;
    private final int plaintextListenerDefaultQuota;
    private ExecutorService executor;
    private Admin admin;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public String unknownHost() {
        return this.unknownHost;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("quota.window.num", "2");
        properties.put("listener.name.plaintext.max.connection.creation.rate", Integer.toString(this.plaintextListenerDefaultQuota()));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(this.createAdminClient(this.listener(), this.createAdminClient$default$2()));
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assertions.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Flaky(value="KAFKA-17999")
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicConnectionQuota(String quorum) {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put("max.connections.per.ip", Integer.toString(maxConnectionsPerIP));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections.per.ip", (Object)Integer.toString(maxConnectionsPerIP)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIP - 1).map((Function1 & Serializable)x$14 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs2), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs3), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var5_4 = null;
        Object var7_6 = null;
        int maxConnectionsPerIPOverride = 7;
        props.put("max.connections.per.ip.overrides", "localhost:" + maxConnectionsPerIPOverride);
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections.per.ip.overrides", (Object)("localhost:" + maxConnectionsPerIPOverride)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable)x$14 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l4 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs4), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs5), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs6), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicListenerConnectionQuota(String quorum) {
        void verifyMaxConnections_connectWithFailure;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put("max.connections", "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections", (Object)"5"));
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), verifyMaxConnections_maxConnections - 1).map((Function1 & Serializable)x$14 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs2), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs3), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        intersect = null;
        Object var15_7 = null;
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put("listeners", newListeners);
        props.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT, CONTROLLER: PLAINTEXT");
        props.put("max.connections", "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)"listeners", (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable)x$3 -> this.connect("PLAINTEXT"));
        conns = (IndexedSeq)conns.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable)x$4 -> this.connect("INTERNAL")));
        conns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = this.listener().configPrefix() + "max.connections";
        props.put(listenerProp, Integer.toString(maxConnectionsPlaintext));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)Integer.toString(maxConnectionsPlaintext)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext - 1).map((Function1 & Serializable)x$14 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs4), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs5), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        long l7 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs6), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var40_24 = null;
        Object var42_26 = null;
        IndexedSeq plaintextConnections = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1 & Serializable)x$6 -> this.connect("PLAINTEXT"));
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection("PLAINTEXT"));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        IndexedSeq plaintextConns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable)x$8 -> this.connect("PLAINTEXT"));
        IndexedSeq internalConns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable)x$9 -> this.connect("INTERNAL"));
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).map((Function1 & Serializable)x$10 -> this.connect("PLAINTEXT")));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Internal connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(IOException.class, () -> internalConns.foreach((Function1 & Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class))));
        plaintextConns.foreach((Function1 & Serializable)x$11 -> {
            x$11.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)x$12 -> {
            x$12.close();
            return BoxedUnit.UNIT;
        });
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicListenerConnectionCreationRateQuota(String quorum) {
        .colon.colon newListenerNames = new .colon.colon((Object)"PLAINTEXT", (List)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$));
        String newListeners = "PLAINTEXT://localhost:0,EXTERNAL://localhost:0";
        Properties props = new Properties();
        props.put("listeners", newListeners);
        props.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,EXTERNAL:PLAINTEXT,CONTROLLER:PLAINTEXT");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)"listeners", (Object)newListeners));
        this.waitForListener("EXTERNAL");
        int initialConnectionCount = this.connectionCount();
        int connRateLimit = 9;
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        props.clear();
        props.put("max.connection.creation.rate", Integer.toString(connRateLimit));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connection.creation.rate", (Object)Integer.toString(connRateLimit)));
        this.verifyConnectionRate(8, connRateLimit, "EXTERNAL", false);
        this.waitForConnectionCount(initialConnectionCount);
        int listenerConnRateLimit = 4;
        String plaintextListenerProp = this.listener().configPrefix() + "max.connection.creation.rate";
        props.put("listener.name.external.max.connection.creation.rate", Integer.toString(listenerConnRateLimit));
        props.put(plaintextListenerProp, Integer.toString(listenerConnRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(listenerConnRateLimit)));
        this.executor_$eq(Executors.newFixedThreadPool(newListenerNames.size()));
        ((scala.collection.immutable.Seq)newListenerNames.map((Function1 & Serializable)listener -> this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, (String)listener, false)))).foreach((Function1 & Serializable)x$13 -> x$13.get(40L, TimeUnit.SECONDS));
        this.waitForConnectionCount(initialConnectionCount);
        int newPlaintextRateLimit = 12;
        props.put(plaintextListenerProp, Integer.toString(newPlaintextRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(newPlaintextRateLimit)));
        Future<?> plaintextFuture = this.executor().submit(() -> this.verifyConnectionRate(10, newPlaintextRateLimit, "PLAINTEXT", false));
        Future<?> externalFuture = this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, "EXTERNAL", false));
        plaintextFuture.get(40L, TimeUnit.SECONDS);
        externalFuture.get(40L, TimeUnit.SECONDS);
        this.waitForConnectionCount(initialConnectionCount);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testDynamicIpConnectionRateQuota(String quorum) {
        int connRateLimit = 10;
        int initialConnectionCount = this.connectionCount();
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.updateIpConnectionRate((Option<String>)None$.MODULE$, connRateLimit);
        this.verifyConnectionRate(8, connRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
        int newRateLimit = 18;
        this.updateIpConnectionRate((Option<String>)new Some((Object)this.localAddress().getHostAddress()), newRateLimit);
        this.verifyConnectionRate(14, newRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), this.admin(), newProps, perBrokerConfig, AlterConfigOp.OpType.SET).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$reconfigureServers$2(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateIpConnectionRate(Option<String> ip, int updatedRate) {
        int initialConnectionCount = this.connectionCount();
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), ip.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))}))).asJava());
        Map request = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)updatedRate)))})))}));
        this.alterClientQuotas(this.admin(), (Map<ClientQuotaEntity, Map<String, Option<Object>>>)request).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$1(this, ip, updatedRate)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for connection rate update to propagate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$4(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$5(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private void waitForListener(String listenerName) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    /*
     * WARNING - void declaration
     */
    private ProduceRequest produceRequest() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var1_2 = null;
        Object var2_1 = null;
        return (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(this.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records))))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build();
    }

    public int connectionCount() {
        return ((KafkaBroker)this.brokers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaBroker)this.brokers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1 & Serializable)x$14 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> connectWithFailure.apply$mcV$sp());
        ((Socket)conns.head()).close();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        conns.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    private void connectAndVerify(String listener, boolean ignoreIOExceptions) {
        try (Socket socket = this.connect(listener);){
            try {
                this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
            }
            catch (IOException e) {
                if (!ignoreIOExceptions) {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCount(int expectedConnectionCount) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$1(this, expectedConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$2(this, expectedConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConnectionRate(int minConnectionRate, int maxConnectionRate, String listener, boolean ignoreIOExceptions) {
        long runTimeMs = TimeUnit.SECONDS.toMillis(13L);
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + runTimeMs;
        int connCount = 0;
        while (System.currentTimeMillis() < endTimeMs) {
            this.connectAndVerify(listener, ignoreIOExceptions);
            ++connCount;
        }
        long elapsedMs = System.currentTimeMillis() - startTimeMs;
        double actualRate = (double)connCount / (double)elapsedMs * (double)1000;
        double rateCap = maxConnectionRate < Integer.MAX_VALUE ? 1.2 * (double)maxConnectionRate : 2.147483647E9;
        Assertions.assertTrue((actualRate <= rateCap ? 1 : 0) != 0, (String)("Listener " + listener + " connection rate " + actualRate + " must be below " + rateCap));
        Assertions.assertTrue((actualRate >= (double)minConnectionRate ? 1 : 0) != 0, (String)("Listener " + listener + " connection rate " + actualRate + " must be above " + minConnectionRate));
    }

    private AlterClientQuotasResult alterClientQuotas(Admin adminClient, Map<ClientQuotaEntity, Map<String, Option<Object>>> request) {
        Collection entries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
                Map alter = (Map)x0$1._2();
                Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        Option value = (Option)x0$2._2();
                        return new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> DynamicConnectionQuotaTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).asJavaCollection();
                return new ClientQuotaAlteration(entity, ops);
            }
            throw new MatchError(null);
        })).asJavaCollection();
        return adminClient.alterClientQuotas(entries);
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return "Admin client connection not closed (initial = " + initialConnectionCount$2 + ", current = " + $this.connectionCount() + ")";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$1(DynamicConnectionQuotaTest $this, Option ip$1, int updatedRate$1) {
        return ((KafkaBroker)$this.brokers().head()).socketServer().connectionQuotas().connectionRateForIp(InetAddress.getByName((String)ip$1.getOrElse((Function0 & Serializable)() -> $this.unknownHost()))) == updatedRate$1;
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$3() {
        return "Timed out waiting for connection rate update to propagate";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$4(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$5(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return "Admin client connection not closed (initial = " + initialConnectionCount$3 + ", current = " + $this.connectionCount() + ")";
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assertions.assertTrue((((KafkaBroker)$this.brokers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaBroker)$this.brokers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$5(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$6() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$8(DynamicConnectionQuotaTest $this, int initialConnectionCount$4) {
        return initialConnectionCount$4 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$9() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCount$1(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return expectedConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$waitForConnectionCount$2(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return "Connections not closed (expected = " + expectedConnectionCount$1 + " current = " + $this.connectionCount() + ")";
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
        this.unknownHost = "255.255.0.1";
        this.plaintextListenerDefaultQuota = 30;
    }
}

