/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.UnifiedLog;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.TransactionStateManagerConfig;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r}h\u0001B4i\u0001=DQA\u001e\u0001\u0005\u0002]DqA\u001f\u0001C\u0002\u0013\u00051\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\t\u0003\u0003\u0001!\u0019!C\u0001w\"9\u00111\u0001\u0001!\u0002\u0013a\b\u0002CA\u0003\u0001\t\u0007I\u0011A>\t\u000f\u0005\u001d\u0001\u0001)A\u0005y\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u000e!A\u0011Q\u0005\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002(\u0001\u0001\u000b\u0011\u0002?\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005-\u0002\u0002CA%\u0001\u0001\u0006I!!\f\t\u0013\u0005-\u0003A1A\u0005\u0002\u00055\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA9\u0001\u0001\u0006I!!\u0019\t\u0013\u0005M\u0004A1A\u0005\u0002\u0005U\u0004\u0002CAA\u0001\u0001\u0006I!a\u001e\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAG\u0001\u0001\u0006I!a\"\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005E\u0005\u0002CAO\u0001\u0001\u0006I!a%\t\u0013\u0005}\u0005A1A\u0005\u0002\u0005\u0005\u0006\u0002CAU\u0001\u0001\u0006I!a)\t\u0013\u0005-\u0006A1A\u0005\u0002\u00055\u0006\u0002CA[\u0001\u0001\u0006I!a,\t\u0013\u0005]\u0006A1A\u0005\u0002\u0005e\u0006\u0002CAi\u0001\u0001\u0006I!a/\t\u0013\u0005M\u0007A1A\u0005\u0002\u0005e\u0006\u0002CAk\u0001\u0001\u0006I!a/\t\u0013\u0005]\u0007A1A\u0005\u0002\u0005e\u0007\u0002CAt\u0001\u0001\u0006I!a7\t\u0013\u0005%\bA1A\u0005\u0002\u0005e\u0007\u0002CAv\u0001\u0001\u0006I!a7\t\u0013\u00055\bA1A\u0005\u0002\u0005=\b\u0002CA\u0000\u0001\u0001\u0006I!!=\t\u0013\t\u0005\u0001\u00011A\u0005\u0002\t\r\u0001\"\u0003B\u0006\u0001\u0001\u0007I\u0011\u0001B\u0007\u0011!\u0011I\u0002\u0001Q!\n\t\u0015\u0001\"\u0003B\u000e\u0001\u0001\u0007I\u0011\u0001B\u0002\u0011%\u0011i\u0002\u0001a\u0001\n\u0003\u0011y\u0002\u0003\u0005\u0003$\u0001\u0001\u000b\u0015\u0002B\u0003\u0011%\u0011)\u0003\u0001a\u0001\n\u0003\u00119\u0003C\u0005\u00036\u0001\u0001\r\u0011\"\u0001\u00038!A!1\b\u0001!B\u0013\u0011I\u0003C\u0004\u0003>\u0001!\tAa\u0010\t\u000f\t]\u0003\u0001\"\u0001\u0003@!9!\u0011\r\u0001\u0005\u0002\t}\u0002b\u0002B6\u0001\u0011\u0005!q\b\u0005\b\u0005_\u0002A\u0011\u0001B \u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005\u007fAqAa\u001e\u0001\t\u0003\u0011y\u0004C\u0004\u0003|\u0001!\tAa\u0010\t\u000f\t}\u0004\u0001\"\u0001\u0003@!9!1\u0011\u0001\u0005\u0002\t}\u0002b\u0002BD\u0001\u0011\u0005!q\b\u0005\b\u0005\u0017\u0003A\u0011\u0001B \u0011\u001d\u0011y\t\u0001C\u0001\u0005\u007fAqAa%\u0001\t\u0003\u0011y\u0004C\u0004\u0003\u0018\u0002!\tAa\u0010\t\u000f\tm\u0005\u0001\"\u0001\u0003@!9!q\u0014\u0001\u0005\u0002\t}\u0002b\u0002BR\u0001\u0011\u0005!q\b\u0005\b\u0005O\u0003A\u0011\u0001B \u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005\u007fAqAa,\u0001\t\u0003\u0011y\u0004C\u0004\u00034\u0002!\tAa\u0010\t\u000f\t]\u0006\u0001\"\u0001\u0003@!9!1\u0018\u0001\u0005\u0002\t}\u0002b\u0002B`\u0001\u0011\u0005!q\b\u0005\b\u0005\u0007\u0004A\u0011\u0001B \u0011\u001d\u00119\r\u0001C\u0001\u0005\u007fAqAa3\u0001\t\u0003\u0011y\u0004C\u0004\u0003P\u0002!\tAa\u0010\t\u000f\tM\u0007\u0001\"\u0001\u0003@!9!q\u001b\u0001\u0005\u0002\t}\u0002b\u0002Bn\u0001\u0011\u0005!q\b\u0005\b\u0005?\u0004A\u0011\u0001B \u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqa!\u0001\u0001\t\u0013\u0019\u0019\u0001C\u0004\u0004\n\u0001!Iaa\u0003\t\u000f\r5\u0001\u0001\"\u0001\u0003@!91\u0011\u0003\u0001\u0005\u0002\t}\u0002bBB\u000b\u0001\u0011%1q\u0003\u0005\b\u0007C\u0001A\u0011\u0001B \u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OAqa!\f\u0001\t\u0013\u0019y\u0003C\u0004\u00044\u0001!Ia!\u000e\t\u000f\r}\u0002\u0001\"\u0003\u0004B!91\u0011\f\u0001\u0005\n\rm\u0003bBB2\u0001\u0011%1Q\r\u0005\b\u0007k\u0002A\u0011BB<\u0011\u001d\u0019i\b\u0001C\u0005\u0007\u007fBqaa!\u0001\t\u0013\u0019)\tC\u0005\u0004\u0014\u0002\t\n\u0011\"\u0003\u0004\u0016\"I11\u0016\u0001\u0012\u0002\u0013%1Q\u0016\u0005\b\u0007c\u0003A\u0011BBZ\u0011\u001d\u0019y\f\u0001C\u0005\u0007\u0003Dqa!2\u0001\t\u0003\u0011y\u0004C\u0004\u0004J\u0002!\tAa\u0010\t\u000f\r5\u0007\u0001\"\u0001\u0004P\nYBK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d+fgRT!!\u001b6\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003W2\f1bY8pe\u0012Lg.\u0019;pe*\tQ.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\bCA9u\u001b\u0005\u0011(\"A:\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0014(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002qB\u0011\u0011\u0010A\u0007\u0002Q\u0006Y\u0001/\u0019:uSRLwN\\%e+\u0005a\bCA9~\u0013\tq(OA\u0002J]R\fA\u0002]1si&$\u0018n\u001c8JI\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0015iJ\fgn]1di&|g\u000eV5nK>,H/T:\u0002+Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tWCAA\u0007!\u0011\ty!a\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\taaY8n[>t'bA7\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QD\u0001\u0004_J<\u0017\u0002BA\u0011\u0003#\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.A\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0002\n!\u0002\u001e=o%\u0016\u001cwN\u001d3t+\t\ti\u0003\u0005\u0004\u00020\u0005e\u0012QH\u0007\u0003\u0003cQA!a\r\u00026\u00059Q.\u001e;bE2,'bAA\u001ce\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\u0011\t\u0019%!\u0005\u0002\rI,7m\u001c:e\u0013\u0011\t9%!\u0011\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\u0002\u0017QDhNU3d_J$7\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005E\u0011!B;uS2\u001c\u0018\u0002BA-\u0003'\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\ng\u000eDW\rZ;mKJ,\"!!\u0019\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005!Q\u000f^5m\u0015\u0011\tY'!\u0006\u0002\rM,'O^3s\u0013\u0011\ty'!\u001a\u0003\u001b5{7m[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\t9\b\u0005\u0003\u0002z\u0005uTBAA>\u0015\r\tY\u0007\\\u0005\u0005\u0003\u007f\nYH\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",WCAAD!\u0011\tI(!#\n\t\u0005-\u00151\u0010\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u00059Q.\u001a;sS\u000e\u001cXCAAJ!\u0011\t)*!'\u000e\u0005\u0005]%\u0002BAH\u0003#IA!a'\u0002\u0018\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0013QDhnQ8oM&<WCAAR!\rI\u0018QU\u0005\u0004\u0003OC'!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006QA\u000f\u001f8D_:4\u0017n\u001a\u0011\u0002%Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM]\u000b\u0003\u0003_\u00032!_AY\u0013\r\t\u0019\f\u001b\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f1\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4fe\u0002\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0019\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u0017tA!a0\u0002HB\u0019\u0011\u0011\u0019:\u000e\u0005\u0005\r'bAAc]\u00061AH]8pizJ1!!3s\u0003\u0019\u0001&/\u001a3fM&!\u0011QZAh\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u001a:\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0005\tBO]1og\u0006\u001cG/[8oC2LEM\r\u0011\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019\u0016\u0005\u0005m\u0007#B9\u0002^\u0006\u0005\u0018bAApe\n)\u0011I\u001d:bsB\u0019\u0011/a9\n\u0007\u0005\u0015(O\u0001\u0003CsR,\u0017\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\f\u0004%A\nuq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c('\u0001\u000buq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c(\u0007I\u0001\faJ|G-^2fe&#7/\u0006\u0002\u0002rBA\u00111_A{\u0003w\u000bI0\u0004\u0002\u00026%!\u0011q_A\u001b\u0005\ri\u0015\r\u001d\t\u0004c\u0006m\u0018bAA\u007fe\n!Aj\u001c8h\u00031\u0001(o\u001c3vG\u0016\u0014\u0018\nZ:!\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\u0011)\u0001E\u0002z\u0005\u000fI1A!\u0003i\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0003A!\bP\\'fi\u0006$\u0017\r^12?\u0012*\u0017\u000f\u0006\u0003\u0003\u0010\tU\u0001cA9\u0003\u0012%\u0019!1\u0003:\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005/9\u0013\u0011!a\u0001\u0005\u000b\t1\u0001\u001f\u00132\u00035!\bP\\'fi\u0006$\u0017\r^12A\u0005aA\u000f\u001f8NKR\fG-\u0019;be\u0005\u0001B\u000f\u001f8NKR\fG-\u0019;be}#S-\u001d\u000b\u0005\u0005\u001f\u0011\t\u0003C\u0005\u0003\u0018)\n\t\u00111\u0001\u0003\u0006\u0005iA\u000f\u001f8NKR\fG-\u0019;be\u0001\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014XC\u0001B\u0015!\u0011\u0011YC!\r\u000e\u0005\t5\"\u0002\u0002B\u0018\u0003#\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005g\u0011iC\u0001\u0004FeJ|'o]\u0001\u0012Kb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:`I\u0015\fH\u0003\u0002B\b\u0005sA\u0011Ba\u0006.\u0003\u0003\u0005\rA!\u000b\u0002\u001d\u0015D\b/Z2uK\u0012,%O]8sA\u0005)1/\u001a;VaR\u0011!q\u0002\u0015\u0004_\t\r\u0003\u0003\u0002B#\u0005'j!Aa\u0012\u000b\t\t%#1J\u0001\u0004CBL'\u0002\u0002B'\u0005\u001f\nqA[;qSR,'O\u0003\u0003\u0003R\u0005m\u0011!\u00026v]&$\u0018\u0002\u0002B+\u0005\u000f\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0019\u0003\\A!!Q\tB/\u0013\u0011\u0011yFa\u0012\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgR4\u0016\r\\5eCR,GK]1og\u0006\u001cG/[8o)&lWm\\;uQ\r\t$Q\r\t\u0005\u0005\u000b\u00129'\u0003\u0003\u0003j\t\u001d#\u0001\u0002+fgR\fa\u0002^3ti\u0006#GmR3u!&$7\u000fK\u00023\u0005K\n1\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3a\rB3\u0003i!Xm\u001d;EK2,G/\u001a'pC\u0012Lgn\u001a)beRLG/[8oQ\r!$QM\u0001!i\u0016\u001cH/T1lK\u001a{G\u000e\\8xKJdu.\u00193j]\u001e\u0004\u0016M\u001d;ji&|g\u000eK\u00026\u0005K\n\u0011\u0006^3ti2{\u0017\rZ!oIJ+Wn\u001c<f)J\fgn]1di&|gn\u001d$peB\u000b'\u000f^5uS>t\u0007f\u0001\u001c\u0003f\u0005IC/Z:u\u0007>l\u0007\u000f\\3uKR\u0013\u0018M\\:ji&|gn\u00165f]\u0006\u0003\b/\u001a8e'V\u001c7-Z3eK\u0012D3a\u000eB3\u00031\"Xm\u001d;BaB,g\u000e\u001a$bS2$vnQ8pe\u0012Lg.\u0019;pe:{G/\u0011<bS2\f'\r\\3FeJ|'\u000fK\u00029\u0005K\n1\u0005^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8O_R\u001cun\u001c:eS:\fGo\u001c:FeJ|'\u000fK\u0002:\u0005K\nq\u0005^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8D_>\u0014H-\u001b8bi>\u0014Hj\\1eS:<WI\u001d:pe\"\u001a!H!\u001a\u00029Q,7\u000f^!qa\u0016tGMR1jYR{WK\\6o_^tWI\u001d:pe\"\u001a1H!\u001a\u0002KQ,7\u000f\u001e)f]\u0012LgnZ*uCR,gj\u001c;SKN,Go\u00148SKR\u0014\u00180\u00119qK:$\u0007f\u0001\u001f\u0003f\u0005iC/Z:u\u0003B\u0004XM\u001c3Ue\u0006t7/Y2uS>tGk\u001c'pO^C\u0017\u000e\\3Qe>$WoY3s\r\u0016t7-\u001a3)\u0007u\u0012)'\u0001\u001auKN$\u0018\t\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{wm\u00165jY\u0016\u0004VM\u001c3j]\u001e\u001cF/\u0019;f\u0007\"\fgnZ3eQ\rq$QM\u0001@g\"|W\u000f\u001c3SKR,(O\u001c(pi\u000e{wN\u001d3j]\u0006$xN]#se>\u0014\u0018J\u001a+sC:\u001c\u0018m\u0019;j_:LE\rU1si&$\u0018n\u001c8O_R|uO\\3eQ\ry$QM\u00015i\u0016\u001cH\u000fT5tiR\u0013\u0018M\\:bGRLwN\\:XSRD7i\\8sI&t\u0017\r^8s\u0019>\fG-\u001b8h\u0013:\u0004&o\\4sKN\u001c\bf\u0001!\u0003f\u0005iB/Z:u\u0019&\u001cH\u000f\u0016:b]N\f7\r^5p]N4\u0015\u000e\u001c;fe&tw\rK\u0002B\u0005K\nag\u001d5pk2$wJ\u001c7z\u0007>t7/\u001b3feR\u0013\u0018M\\:bGRLwN\\:J]RCWm\u00148h_&twm\u0015;bi\u0016$v.\u00112peRD3A\u0011B3\u0003a\u001a\bn\\;mI^\u0013\u0018\u000e^3Uq:l\u0015M]6feN4uN\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000e\u0015:fa\u0006\u0014X\rZ\"p[6LGo\u0015;bi\u0016D3a\u0011B3\u0003]\u001a\bn\\;mI^\u0013\u0018\u000e^3Uq:l\u0015M]6feN4uN\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000e\u0015:fa\u0006\u0014X\rZ!c_J$8\u000b^1uK\"\u001aAI!\u001a\u0002cMDw.\u001e7e%\u0016lwN^3D_6\u0004H.\u001a;f\u0007>lW.\u001b;FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001aQI!\u001a\u0002aMDw.\u001e7e%\u0016lwN^3D_6\u0004H.\u001a;f\u0003\n|'\u000f^#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\r1%QM\u0001)g\"|W\u000f\u001c3SK6|g/Z#naRLX\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\u000f\n\u0015\u0014AN:i_VdGMT8u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&3Gj\\4BaB,g\u000e\u001a$bS2\u001c\bf\u0001%\u0003f\u000513\u000f[8vY\u0012tu\u000e\u001e*f[>4Xm\u00148h_&tw\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007%\u0013)'A\u0016tQ>,H\u000e\u001a(piJ+Wn\u001c<f!J,\u0007/\u0019:f\u0003\n|'\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\rQ%QM\u0001-g\"|W\u000f\u001c3O_R\u0014V-\\8wKB\u0013X\r]1sK\u000e{W.\\5u)J\fgn]1di&|g.\u00197JIND3a\u0013B3\u0003A\"Xm\u001d;Ue\u0006t7/Y2uS>t\u0017\r\\#ya&\u0014\u0018\r^5p]^KG\u000f\u001b+p_Nk\u0017\r\u001c7CCR\u001c\u0007nU5{K\"\u001aAJ!\u001a\u0002YQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u0012=qSJ\fG/[8o/&$\bn\u00144gY&tW\rT8h\t&\u0014\bfA'\u0003f\u0005yC/Z:u)J\fgn]1di&|g.\u0012=qSJ\fG/[8o'\"|W\u000f\u001c3SKN\u0004Xm\u0019;CCR\u001c\u0007nU5{K\"\u001aaJ!\u001a\u0002\u0015R,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:,\u0005\u0010]5sCRLwN\\*i_VdGMT8u\r\u0006LGnV5uQVs\u0017N\\5uS\u0006d\u0017N_3e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0015\u0004\u001f\n\u0015\u0014!J2pY2,7\r\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\rJ|W\u000eV8nEN$xN\\3t)\u0011\u00119O!<\u0011\r\u0005u&\u0011^A^\u0013\u0011\u0011Y/a4\u0003\u0007M+G\u000fC\u0004\u0003pB\u0003\rA!=\u0002\u001f\u0005\u0004\b/\u001a8eK\u0012\u0014VmY8sIN\u0004\u0002\"a\f\u0003t\u00065!Q_\u0005\u0005\u0003o\f\t\u0004\u0005\u0004\u00020\t](1`\u0005\u0005\u0005s\f\tD\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003\u007f\u0011i0\u0003\u0003\u0003\u0000\u0006\u0005#!D'f[>\u0014\u0018PU3d_J$7/A\u000em_\u0006$W\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm\u001d\u000b\u0005\u0005O\u001c)\u0001\u0003\u0004\u0004\bE\u0003\r\u0001`\u0001\u0014]VlGK]1og\u0006\u001cG/[8oC2LEm]\u0001\u001eY&\u001cH/\u0012=qSJ\f'\r\\3Ue\u0006t7/Y2uS>t\u0017\r\\%egR\u0011!q]\u0001\u001ci\u0016\u001cHoU;dG\u0016\u001c8OZ;m%\u0016LW.\\5he\u0006$\u0018n\u001c8)\u0007M\u0013)'A\u0016uKN$Hj\\1e)J\fgn]1di&|g.T3uC\u0012\fG/Y,ji\"\u001cuN\u001d:vaR,G\rT8hQ\r!&QM\u0001\u0011GJ,\u0017\r^3F[B$\u0018PQ1uG\"$bAa?\u0004\u001a\ru\u0001bBB\u000e+\u0002\u0007\u0011\u0011`\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$\bbBB\u0010+\u0002\u0007\u0011\u0011`\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\u0018\u0001\u0011;fgRdu.\u00193Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mQ8oi\u0006Lg.\u001b8h'\u0016<W.\u001a8u\u000b:$\u0017N\\4XSRDW)\u001c9us\n\u000bGo\u00195)\u0007Y\u0013)'\u0001\u0012wKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001cX\t_5ti\u0006sG-S:Vg\u0006\u0014G.\u001a\u000b\u0005\u0005\u001f\u0019I\u0003C\u0004\u0004,]\u0003\r!a/\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0011D^3sS\u001aLX*\u001a;bI\u0006$\u0018\rR8fg:$X\t_5tiR!!qBB\u0019\u0011\u001d\u0019Y\u0003\u0017a\u0001\u0003w\u000bq$\u001a=qK\u000e$HK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o)\u0019\u0011yaa\u000e\u0004<!91\u0011H-A\u0002\t%\u0012aC1qa\u0016tG-\u0012:s_JDqa!\u0010Z\u0001\u0004\u0011\t0A\bdCB$XO]3e\u0003B\u0004XM\u001c3t\u0003uaw.\u00193Ue\u0006t7/Y2uS>t7OR8s!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\b\u0007\u0007Bqa!\u0012[\u0001\u0004\u00199%\u0001\u0007qCJ$\u0018\u000e^5p]&#7\u000fE\u0003\u0004J\rMCP\u0004\u0003\u0004L\r=c\u0002BAa\u0007\u001bJ\u0011a]\u0005\u0004\u0007#\u0012\u0018a\u00029bG.\fw-Z\u0005\u0005\u0007+\u001a9FA\u0002TKFT1a!\u0015s\u0003=)\u0007\u0010]3di2{wmQ8oM&<GC\u0002B\b\u0007;\u001ay\u0006C\u0004\u0004Fm\u0003\raa\u0012\t\r\r\u00054\f1\u0001}\u00031i\u0017\r\u001f\"bi\u000eD7+\u001b>f\u0003\u0011\u001aX\r^;q\u0003:$'+\u001e8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>tGC\u0002B\b\u0007O\u001aY\u0007C\u0004\u0004jq\u0003\rA!\u000b\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\r5D\f1\u0001\u0004p\u0005AA\u000f\u001f8Ti\u0006$X\rE\u0002z\u0007cJ1aa\u001di\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-\u0001\u0013wKJLg-_,sSR,7\u000f\u0016=o\u001b\u0006\u00148.\u001a:t\u0013:\u0004&/\u001a9be\u0016\u001cF/\u0019;f)\u0011\u0011ya!\u001f\t\u000f\rmT\f1\u0001\u0004p\u0005)1\u000f^1uK\u0006q\u0011m]:feR\u001c\u0015\r\u001c7cC\u000e\\G\u0003\u0002B\b\u0007\u0003Cqa!\u001b_\u0001\u0004\u0011I#A\nue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0006\u0003\u0006\r\u001d5\u0011RBG\u0007\u001fCqaa\u000b`\u0001\u0004\tY\fC\u0004\u0004\f~\u0003\r!!?\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0005\u0004|}\u0003\n\u00111\u0001\u0004p!A1\u0011S0\u0011\u0002\u0003\u0007A0\u0001\u0006uq:$\u0016.\\3pkR\fQ\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0007/SCaa\u001c\u0004\u001a.\u001211\u0014\t\u0005\u0007;\u001b9+\u0004\u0002\u0004 *!1\u0011UBR\u0003%)hn\u00195fG.,GMC\u0002\u0004&J\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019Ika(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019yKK\u0002}\u00073\u000bQ\u0002\u001d:fa\u0006\u0014X\r\u0016=o\u0019><G\u0003\u0003B\b\u0007k\u001b9la/\t\u000f\u0005%!\r1\u0001\u0002\u000e!91\u0011\u00182A\u0002\u0005e\u0018aC:uCJ$xJ\u001a4tKRDqa!0c\u0001\u0004\u0011Y0A\u0004sK\u000e|'\u000fZ:\u00025A\u0014X\r]1sK\u001a{'\u000f\u0016=o\u001b\u0016\u001c8/Y4f\u0003B\u0004XM\u001c3\u0015\t\t=11\u0019\u0005\b\u0007S\u001a\u0007\u0019\u0001B\u0015\u0003]!Xm\u001d;QCJ$\u0018\u000e^5p]2{\u0017\rZ'fiJL7\rK\u0002e\u0005K\n1\u0004^3ti&;gn\u001c:f+:\\gn\\<o%\u0016\u001cwN\u001d3UsB,\u0007fA3\u0003f\u0005QC/Z:u)J\fgn]1di&|gNV3sg&|g.\u00138Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014H\u0003\u0002B\b\u0007#Dqaa5g\u0001\u0004\u0019).\u0001\nue\u0006t7/Y2uS>tg+\u001a:tS>t\u0007\u0003BBl\u00077l!a!7\u000b\t\u0005M\u0011\u0011N\u0005\u0005\u0007;\u001cIN\u0001\nUe\u0006t7/Y2uS>tg+\u001a:tS>t\u0007f\u00014\u0004bB!11]Bu\u001b\t\u0019)O\u0003\u0003\u0004h\n-\u0013A\u00029be\u0006l7/\u0003\u0003\u0004l\u000e\u0015(!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":ama<\u0004|\u000eu\b\u0003BBy\u0007ol!aa=\u000b\t\rU8Q]\u0001\taJ|g/\u001b3fe&!1\u0011`Bz\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0003\u0007+\u0004")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        Assertions.assertEquals((Object)new Right((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Right((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Right((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteLoadingPartition() {
        void withRecords_records;
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2))};
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var21_7 = null;
        Object var19_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            latch.await();
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable)(x$3, x$4, x$5, x$6) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(BoxesRunTime.unboxToInt((Object)x$3), x$4, x$5, x$6);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$4(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)"Timed out waiting for loading partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)new Left((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeFollowerLoadingPartition() {
        void withRecords_records;
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2))};
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var21_7 = null;
        Object var19_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$7 -> {
            latch.await();
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable)(x$8, x$9, x$10, x$11) -> {
            TransactionStateManagerTest.$anonfun$testMakeFollowerLoadingPartition$3(BoxesRunTime.unboxToInt((Object)x$8), x$9, x$10, x$11);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long x$4 = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testMakeFollowerLoadingPartition$4(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)"Timed out waiting for loading partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch + 1);
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)new Left((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        void withRecords_records;
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), TransactionVersion.TV_2)));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), TransactionVersion.TV_2)));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), TransactionVersion.TV_2)));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), TransactionVersion.TV_2)));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var8_4 = null;
        Object var6_3 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$12 -> (Nothing$)Assertions.fail((String)(this.transactionalId1() + "'s transaction state is already in the cache")));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$13 -> (Nothing$)Assertions.fail((String)(this.transactionalId2() + "'s transaction state is already in the cache")));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$14, x$15, x$16, x$17) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$14), x$15, x$16, x$17);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> (Nothing$)Assertions.fail((String)(this.transactionalId1() + "'s transaction state access returns error " + err)), (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)(this.transactionalId1() + "'s transaction state was not loaded into the cache"))));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            throw new AssertionError((Object)(this.transactionalId1() + "'s transaction state access returns error " + err));
        }, (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)(this.transactionalId1() + "'s transaction state was not loaded into the cache"));
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            throw new AssertionError((Object)(this.transactionalId2() + "'s transaction state access returns error " + err));
        }, (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)(this.transactionalId2() + "'s transaction state was not loaded into the cache"));
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$18 -> (Nothing$)Assertions.fail((String)(this.transactionalId1() + "'s transaction state is still in the cache")));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$19 -> (Nothing$)Assertions.fail((String)(this.transactionalId2() + "'s transaction state is still in the cache")));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds(), TransactionVersion.TV_0);
        String x$1 = this.transactionalId1();
        int x$2 = this.coordinatorEpoch();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, x$2, newMetadata, (Function1)x$4, x$6, x$5);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        RequestLocal requestLocal = RequestLocal.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        String x$7 = this.transactionalId1();
        Function1 & Serializable x$10 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, 10, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        String x$13 = this.transactionalId1();
        Function1 & Serializable x$16 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, 10, failedMetadata, (Function1)x$16, x$18, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        String x$19 = this.transactionalId1();
        Function1 & Serializable x$22 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, 10, failedMetadata, (Function1)x$22, x$24, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        RequestLocal requestLocal = RequestLocal.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        String x$7 = this.transactionalId1();
        Function1 & Serializable x$10 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, 10, failedMetadata, (Function1)x$10, x$12, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        String x$13 = this.transactionalId1();
        Function1 & Serializable x$16 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$18 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$13, 10, failedMetadata, (Function1)x$16, x$18, requestLocal);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        String x$19 = this.transactionalId1();
        Function1 & Serializable x$22 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$24 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$19, 10, failedMetadata, (Function1)x$22, x$24, requestLocal);
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        RequestLocal requestLocal = RequestLocal.withThreadConfinedCaching();
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, failedMetadata, (Function1)x$4, x$6, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        String x$7 = this.transactionalId1();
        Function1 & Serializable x$10 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        Function1 x$12 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$7, 10, failedMetadata, (Function1)x$10, x$12, requestLocal);
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$20)), RequestLocal.withThreadConfinedCaching());
        Assertions.assertEquals((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        String x$1 = this.transactionalId1();
        Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$5 = RequestLocal.withThreadConfinedCaching();
        Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
        this.transactionManager().appendTransactionToLog(x$1, 10, newMetadata, (Function1)x$4, x$6, x$5);
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds(), TransactionVersion.TV_0);
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> {
            String x$1 = this.transactionalId1();
            Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
                this.assertCallback(error);
                return BoxedUnit.UNIT;
            };
            RequestLocal x$5 = RequestLocal.withThreadConfinedCaching();
            Function1 x$6 = this.transactionManager().appendTransactionToLog$default$5();
            this.transactionManager().appendTransactionToLog(x$1, 10, newMetadata, (Function1)x$4, x$6, x$5);
        });
    }

    @Test
    public void shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$21 -> (Nothing$)Assertions.fail((String)(this.transactionalId1() + "'s transaction state is already in the cache")));
    }

    @Test
    public void testListTransactionsWithCoordinatorLoadingInProgress() {
        this.transactionManager().addLoadingPartition(0, 15);
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty(), -1L);
        Assertions.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)Errors.forCode((short)listResponse.errorCode()));
    }

    @Test
    public void testListTransactionsFiltering() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
        this.putTransaction$1("t0", 0L, (TransactionState)Ongoing$.MODULE$);
        this.putTransaction$1("t1", 1L, (TransactionState)Ongoing$.MODULE$);
        this.time().sleep(1000L);
        this.putTransaction$1("t2", 2L, (TransactionState)PrepareCommit$.MODULE$);
        this.putTransaction$1("t3", 3L, (TransactionState)PrepareAbort$.MODULE$);
        this.time().sleep(1000L);
        this.putTransaction$1("t4", 4L, (TransactionState)CompleteCommit$.MODULE$);
        this.putTransaction$1("t5", 5L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t6", 6L, (TransactionState)CompleteAbort$.MODULE$);
        this.putTransaction$1("t7", 7L, (TransactionState)PrepareEpochFence$.MODULE$);
        this.time().sleep(1000L);
        this.putTransaction$1("t8", 8L, (TransactionState)Dead$.MODULE$);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"})), TransactionStateManagerTest.assertListTransactions$default$2$1(), TransactionStateManagerTest.assertListTransactions$default$3$1(), -1L);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3", "t4", "t5", "t6", "t7"}));
        scala.collection.immutable.Set x$3 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$4 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$1, x$3, x$4, 0L);
        scala.collection.immutable.Set x$5 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1", "t2", "t3"}));
        scala.collection.immutable.Set x$7 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$8 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$5, x$7, x$8, 1000L);
        scala.collection.immutable.Set x$9 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$11 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$12 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$9, x$11, x$12, 2000L);
        scala.collection.immutable.Set x$13 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$15 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        scala.collection.immutable.Set x$16 = TransactionStateManagerTest.assertListTransactions$default$3$1();
        this.assertListTransactions$1(x$13, x$15, x$16, 3000L);
        scala.collection.immutable.Set x$17 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$18 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing"}));
        scala.collection.immutable.Set x$19 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$20 = -1L;
        this.assertListTransactions$1(x$17, x$19, x$18, x$20);
        scala.collection.immutable.Set x$21 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t0", "t1"}));
        scala.collection.immutable.Set x$22 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Ongoing", "UnknownState"}));
        scala.collection.immutable.Set x$23 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$24 = -1L;
        this.assertListTransactions$1(x$21, x$23, x$22, x$24);
        scala.collection.immutable.Set x$25 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2", "t4"}));
        scala.collection.immutable.Set x$26 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PrepareCommit", "CompleteCommit"}));
        scala.collection.immutable.Set x$27 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$28 = -1L;
        this.assertListTransactions$1(x$25, x$27, x$26, x$28);
        scala.collection.immutable.Set x$29 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$30 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"}));
        scala.collection.immutable.Set x$31 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$32 = -1L;
        this.assertListTransactions$1(x$29, x$31, x$30, x$32);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L})), TransactionStateManagerTest.assertListTransactions$default$3$1(), -1L);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t5", "t6"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{5L, 6L, 8L, 9L})), TransactionStateManagerTest.assertListTransactions$default$3$1(), -1L);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})), -1L);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t4", "t5"})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{4L, 5L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit", "CompleteAbort"})), -1L);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{3L, 6L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnknownState"})), -1L);
        this.assertListTransactions$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{10L})), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CompleteCommit"})), -1L);
        scala.collection.immutable.Set x$33 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Set x$34 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dead"}));
        scala.collection.immutable.Set x$35 = TransactionStateManagerTest.assertListTransactions$default$2$1();
        long x$36 = -1L;
        this.assertListTransactions$1(x$33, x$35, x$34, x$36);
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionTimeoutMs()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        attemptedAppends.values().foreach((Function1 & Serializable)batches -> {
            batches.foreach((Function1 & Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        void var9_9;
        void var8_8;
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        Mockito.when((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).thenReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable)x$23 -> BoxesRunTime.boxToInteger((int)x$23.partition())));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)var8_8, expiredTransactionalIds);
        Assertions.assertEquals((Object)var9_9, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assertions.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToInteger((int)x$25.partition())));
        appendedRecords.values().foreach((Function1 & Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    @Test
    public void testTransactionExpirationShouldNotFailWithUninitializedTransactionMetadata() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        String transactionalId = "id";
        scala.collection.immutable.Set allTransactionalIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{transactionalId}));
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        long timestamp = this.time().milliseconds();
        TransactionMetadata txnMetadata = new TransactionMetadata(transactionalId, 1L, -1L, -1L, -1, -1, this.transactionTimeoutMs(), (TransactionState)Empty$.MODULE$, (scala.collection.mutable.Set)Set$.MODULE$.empty(), timestamp, timestamp, TransactionVersion.TV_0);
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        this.time().sleep((long)(this.txnConfig().transactionalIdExpirationMs() + 1));
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.atLeastOnce())).appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable)batches -> {
            batches.foreach((Function1 & Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1 & Serializable)i -> TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, BoxesRunTime.unboxToInt((Object)i)));
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((IterableOnceOps)((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.transactionManager().listTransactionStates(Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty(), -1L).transactionStates()).asScala().map((Function1 & Serializable)x$27 -> x$27.transactionalId())).filter((Function1 & Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$2(this, transactionalId)))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulReimmigration() {
        void withRecords_records;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var6_4 = null;
        Object var4_3 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$28, x$29, x$30, x$31) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$28), x$29, x$30, x$31);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable)(x$32, x$33, x$34, x$35) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$32), x$33, x$34, x$35);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)MemoryRecords.EMPTY));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$36, x$37, x$38, x$39) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$36), x$37, x$38, x$39);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).getLog(this.topicPartition());
        ((UnifiedLog)Mockito.verify((Object)logMock)).logStartOffset();
        ((UnifiedLog)Mockito.verify((Object)logMock)).read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true));
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager(), (VerificationMode)Mockito.times((int)2))).getLogEndOffset(this.topicPartition());
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords createEmptyBatch(long baseOffset, long lastOffset) {
        void writeEmptyHeader_partitionLeaderEpoch;
        void writeEmptyHeader_isControlRecord;
        void writeEmptyHeader_isTransactional;
        void writeEmptyHeader_baseSequence;
        void writeEmptyHeader_producerEpoch;
        void writeEmptyHeader_producerId;
        void writeEmptyHeader_timestamp;
        void writeEmptyHeader_timestampType;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        boolean bl = false;
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        TimestampType timestampType = TimestampType.CREATE_TIME;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l2 = -1L;
        byte writeEmptyHeader_magic = 2;
        int writeEmptyHeader_offsetDelta = (int)(lastOffset - baseOffset);
        DefaultRecordBatch.writeHeader((ByteBuffer)buffer, (long)baseOffset, (int)writeEmptyHeader_offsetDelta, (int)61, (byte)writeEmptyHeader_magic, (CompressionType)CompressionType.NONE, (TimestampType)writeEmptyHeader_timestampType, (long)-1L, (long)writeEmptyHeader_timestamp, (long)writeEmptyHeader_producerId, (short)writeEmptyHeader_producerEpoch, (int)writeEmptyHeader_baseSequence, (boolean)writeEmptyHeader_isTransactional, (boolean)writeEmptyHeader_isControlRecord, (boolean)false, (int)writeEmptyHeader_partitionLeaderEpoch, (int)0);
        timestampType = null;
        buffer.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buffer);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadTransactionMetadataContainingSegmentEndingWithEmptyBatch() {
        void withRecords_records;
        void withRecords_timestampType;
        void withRecords_records2;
        void withRecords_timestampType2;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})));
        SimpleRecord txnRecords1 = new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{txnRecords1};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        NoCompression withRecords_compression = Compression.NONE;
        Object var10_4 = null;
        timestampType = null;
        simpleRecordArray = null;
        MemoryRecords records1 = MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2);
        MemoryRecords records2 = this.createEmptyBatch(1L, 1L);
        ByteBuffer combinedBuffer = ByteBuffer.allocate(records1.buffer().limit() + records2.buffer().limit());
        combinedBuffer.put(records1.buffer());
        combinedBuffer.put(records2.buffer());
        combinedBuffer.flip();
        MemoryRecords firstSegmentRecords = MemoryRecords.readableRecords((ByteBuffer)combinedBuffer);
        SimpleRecord txnRecords3 = new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit(), TransactionVersion.TV_2));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{txnRecords3};
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        NoCompression withRecords_compression2 = Compression.NONE;
        Object var13_12 = null;
        timestampType2 = null;
        simpleRecordArray2 = null;
        MemoryRecords secondSegmentRecords = MemoryRecords.withRecords((byte)2, (long)2L, (Compression)withRecords_compression2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicPartition())).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)0L), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L), (Records)firstSegmentRecords));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)2L), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(2L), (Records)secondSegmentRecords));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable)(x$40, x$41, x$42, x$43) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataContainingSegmentEndingWithEmptyBatch$1(BoxesRunTime.unboxToInt((Object)x$40), x$41, x$42, x$43);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertEquals((int)1, (int)this.transactionManager().transactionMetadataCache().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Pool txnMetadataPool = ((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).metadataPerTransactionalId();
        Assertions.assertEquals((int)2, (int)txnMetadataPool.size());
        Assertions.assertTrue((boolean)txnMetadataPool.contains((Object)this.transactionalId1()));
        Assertions.assertTrue((boolean)txnMetadataPool.contains((Object)this.transactionalId2()));
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        ArgumentCaptor recordsCapture = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((short)((short)-1)), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)recordsCapture.capture(), (Function1)callbackCapture.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$44 -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError, x$44);
            return BoxedUnit.UNIT;
        });
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logConfig.maxMessageSize())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxBatchSize));
        partitionIds.foreach((Function1 & Serializable)partitionId -> TransactionStateManagerTest.$anonfun$expectLogConfig$1(this, logConfig, BoxesRunTime.unboxToInt((Object)partitionId)));
    }

    /*
     * WARNING - void declaration
     */
    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, 0x10000C);
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        this.transactionManager().removeExpiredTransactionalIds();
        if (Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState))) {
            void withRecords_records;
            void withRecords_timestampType;
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{expectedTombstone};
            Compression withRecords_compression = TransactionLog$.MODULE$.EnforcedCompression();
            byte withRecords_magic = 2;
            TimestampType timestampType = TimestampType.CREATE_TIME;
            long withRecords_initialOffset = 0L;
            timestampType = null;
            Object var9_9 = null;
            simpleRecordArray = null;
            MemoryRecords expectedRecords = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assertions.assertEquals((Object)new .colon.colon((Object)expectedRecords, (List)Nil$.MODULE$), (Object)((IterableOnceOps)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assertions.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        void withRecords_records;
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var8_5 = null;
        Object var6_4 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        long timestamp = this.time().milliseconds();
        return new TransactionMetadata(transactionalId, producerId, -1L, -1L, (short)0, -1, txnTimeout, state, (scala.collection.mutable.Set)Set$.MODULE$.empty(), timestamp, timestamp, TransactionVersion.TV_0);
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        UnifiedLog logMock = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        FileRecords fileRecordsMock = (FileRecords)Mockito.mock(FileRecords.class);
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        Mockito.when((Object)this.replicaManager().getLog(topicPartition)).thenReturn((Object)new Some((Object)logMock));
        Mockito.when((Object)this.replicaManager().getLogEndOffset(topicPartition)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        Mockito.when((Object)logMock.read(ArgumentMatchers.eq((long)startOffset), ArgumentMatchers.anyInt(), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecordsMock));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecordsMock.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$45 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(records.buffer().duplicate());
            return buffer.flip();
        });
    }

    private void prepareForTxnMessageAppend(Errors error) {
        Mockito.reset((Object[])new ReplicaManager[]{this.replicaManager()});
        ArgumentCaptor capturedArgument = ArgumentCaptor.forClass(Function1.class);
        this.replicaManager().appendRecords(ArgumentMatchers.anyLong(), ArgumentMatchers.anyShort(), ArgumentMatchers.eq((boolean)true), (AppendOrigin)ArgumentMatchers.eq((Object)AppendOrigin.COORDINATOR), (Map)ArgumentMatchers.any(), (Function1)capturedArgument.capture(), (Option)ArgumentMatchers.any(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any(), (ActionQueue)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$46 -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error, x$46);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionLoadMetric() {
        void withRecords_records;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var10_8 = null;
        Object var8_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$47, x$48, x$49, x$50) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$47), x$48, x$49, x$50);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIgnoreUnknownRecordType() {
        void withRecords_records;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit(), TransactionVersion.TV_2)));
        long startOffset = 0L;
        TransactionLogKey unknownKey = new TransactionLogKey();
        byte[] unknownMessage = MessageUtil.toVersionPrefixedBytes((short)Short.MAX_VALUE, (Message)unknownKey);
        SimpleRecord unknownRecord = new SimpleRecord(unknownMessage, unknownMessage);
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)new .colon.colon((Object)unknownRecord, (List)Nil$.MODULE$).$plus$plus(this.txnRecords())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        Object var11_7 = null;
        Object var9_6 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable)(x$51, x$52, x$53, x$54) -> {
            TransactionStateManagerTest.$anonfun$testIgnoreUnknownRecordType$1(BoxesRunTime.unboxToInt((Object)x$51), x$52, x$53, x$54);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().contains((Object)BoxesRunTime.boxToInteger((int)this.partitionId())));
        Pool txnMetadataPool = ((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).metadataPerTransactionalId();
        Assertions.assertFalse((boolean)txnMetadataPool.isEmpty());
        Assertions.assertTrue((boolean)txnMetadataPool.contains((Object)this.transactionalId1()));
        TransactionMetadata txnMetadata = (TransactionMetadata)txnMetadataPool.get((Object)this.transactionalId1());
        Assertions.assertEquals((Object)this.txnMetadata1().transactionalId(), (Object)txnMetadata.transactionalId());
        Assertions.assertEquals((long)this.txnMetadata1().producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.txnMetadata1().previousProducerId(), (long)txnMetadata.previousProducerId());
        Assertions.assertEquals((short)this.txnMetadata1().producerEpoch(), (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)this.txnMetadata1().lastProducerEpoch(), (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)this.txnMetadata1().txnTimeoutMs(), (int)txnMetadata.txnTimeoutMs());
        Assertions.assertEquals((Object)this.txnMetadata1().state(), (Object)txnMetadata.state());
        Assertions.assertEquals((Object)this.txnMetadata1().topicPartitions(), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().apply((Object)BoxesRunTime.boxToInteger((int)this.partitionId()))).coordinatorEpoch());
    }

    @ParameterizedTest
    @EnumSource(value=TransactionVersion.class)
    public void testTransactionVersionInTransactionManager(TransactionVersion transactionVersion) {
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.features()).thenReturn((Object)new FinalizedFeatures(MetadataVersion.latestTesting(), Collections.singletonMap("transaction.version", Predef$.MODULE$.short2Short(transactionVersion.featureLevel())), 0L, true));
        TransactionStateManager transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), metadataCache, this.txnConfig(), (Time)this.time(), this.metrics());
        Assertions.assertEquals((Object)transactionVersion, (Object)transactionManager.transactionVersionLevel());
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$3(int x$3, TransactionResult x$4, TransactionMetadata x$5, TxnTransitMetadata x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$4(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$5() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testMakeFollowerLoadingPartition$3(int x$8, TransactionResult x$9, TransactionMetadata x$10, TxnTransitMetadata x$11) {
    }

    public static final /* synthetic */ boolean $anonfun$testMakeFollowerLoadingPartition$4(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerLoadingPartition$5() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$14, TransactionResult x$15, TransactionMetadata x$16, TxnTransitMetadata x$17) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$20) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCoordinatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private final void putTransaction$1(String transactionalId, long producerId, TransactionState state) {
        TransactionMetadata txnMetadata = this.transactionMetadata(transactionalId, producerId, state, this.transactionTimeoutMs());
        this.transactionManager().putTransactionStateIfNotExists(txnMetadata).left().toOption().foreach((Function1 & Serializable)error -> (Nothing$)Assertions.fail((String)("Failed to insert transaction " + txnMetadata + " due to error " + error)));
    }

    public static final /* synthetic */ boolean $anonfun$testListTransactionsFiltering$4(String state) {
        return TransactionState$.MODULE$.fromName(state).isEmpty();
    }

    private final void assertListTransactions$1(scala.collection.immutable.Set expectedTransactionalIds, scala.collection.immutable.Set filterProducerIds, scala.collection.immutable.Set filterStates, long filterDuration) {
        ListTransactionsResponseData listResponse = this.transactionManager().listTransactionStates(filterProducerIds, filterStates, filterDuration);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)listResponse.errorCode()));
        Assertions.assertEquals((Object)expectedTransactionalIds, (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(listResponse.transactionStates()).asScala().map((Function1 & Serializable)x$22 -> x$22.transactionalId())).toSet());
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)filterStates.filter((Function1 & Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testListTransactionsFiltering$4(state)))), (Object)CollectionConverters$.MODULE$.ListHasAsScala(listResponse.unknownStateFilters()).asScala().toSet());
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$2$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final scala.collection.immutable.Set assertListTransactions$default$3$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private static final long assertListTransactions$default$4$1() {
        return -1L;
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assertions.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$26) {
        return x$26.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assertions.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)batches.forall((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$26))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assertions.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assertions.assertEquals((Object)new Right((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = "id_" + i;
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, (TransactionState)Empty$.MODULE$, $this.transactionTimeoutMs());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$2(TransactionStateManagerTest $this, String transactionalId) {
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            return $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$28, TransactionResult x$29, TransactionMetadata x$30, TxnTransitMetadata x$31) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$32, TransactionResult x$33, TransactionMetadata x$34, TxnTransitMetadata x$35) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$36, TransactionResult x$37, TransactionMetadata x$38, TxnTransitMetadata x$39) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataContainingSegmentEndingWithEmptyBatch$1(int x$40, TransactionResult x$41, TransactionMetadata x$42, TxnTransitMetadata x$43) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(ArgumentCaptor callbackCapture$1, ArgumentCaptor recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1, InvocationOnMock x$44) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((MapOps)recordsCapture$1.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                MemoryRecords records = (MemoryRecords)x0$1._2();
                ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
                    Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                    capturedAppends$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)batches));
                    return batches;
                })).$plus$eq((Object)records);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L));
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$expectLogConfig$1(TransactionStateManagerTest $this, LogConfig logConfig$1, int partitionId) {
        return Mockito.when((Object)$this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).thenReturn((Object)new Some((Object)logConfig$1));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, ArgumentCaptor capturedArgument$1, Errors error$1, InvocationOnMock x$46) {
        ((Function1)capturedArgument$1.getValue()).apply(scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$47, TransactionResult x$48, TransactionMetadata x$49, TxnTransitMetadata x$50) {
    }

    public static final /* synthetic */ void $anonfun$testIgnoreUnknownRecordType$1(int x$51, TransactionResult x$52, TransactionMetadata x$53, TxnTransitMetadata x$54) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        Mockito.when((Object)this.metadataCache().features()).thenReturn((Object)new FinalizedFeatures(MetadataVersion.latestTesting(), Collections.singletonMap("transaction.version", Predef$.MODULE$.short2Short(TransactionVersion.TV_2.featureLevel())), 0L, true));
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionStateManagerConfig.TRANSACTIONAL_ID_EXPIRATION_MS_DEFAULT, TransactionStateManagerConfig.TRANSACTIONS_MAX_TIMEOUT_MS_DEFAULT, 50, 3, 0x6400000, 0x500000, 2, TransactionStateManagerConfig.TRANSACTIONS_ABORT_TIMED_OUT_TRANSACTION_CLEANUP_INTERVAL_MS_DEFAULT, TransactionStateManagerConfig.TRANSACTIONS_REMOVE_EXPIRED_TRANSACTIONAL_ID_CLEANUP_INTERVAL_MS_DEFAULT, 30000);
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.metadataCache(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.expectedError = Errors.NONE;
    }
}

