/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Replica;
import kafka.cluster.ReplicaState;
import kafka.cluster.ReplicaTest$;
import kafka.log.UnifiedLog$;
import kafka.server.MetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015u!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007o\u0005\u0001\u000b\u0011\u0002\u001b\t\u000fa\n!\u0019!C\u0001s!1Q)\u0001Q\u0001\niBqAR\u0001C\u0002\u0013\u0005q\t\u0003\u0004L\u0003\u0001\u0006I\u0001\u0013\u0004\u0005Q\u0005\u0002A\nC\u00031\u0013\u0011\u0005Q\nC\u0004P\u0013\t\u0007I\u0011\u0001)\t\reK\u0001\u0015!\u0003R\u0011%Q\u0016\u00021AA\u0002\u0013\u00051\fC\u0005`\u0013\u0001\u0007\t\u0019!C\u0001A\"Ia-\u0003a\u0001\u0002\u0003\u0006K\u0001\u0018\u0005\u0006O&!\t\u0001\u001b\u0005\u0006i&!I!\u001e\u0005\n\u0003\u0017I\u0011\u0013!C\u0005\u0003\u001bAq!a\t\n\t\u0003\t)\u0003C\u0004\u00022%!I!a\r\t\u000f\u0005\u0005\u0013\u0002\"\u0003\u0002D!9\u0011QK\u0005\u0005\n\u0005]\u0003BBA.\u0013\u0011\u0005\u0001\u000e\u0003\u0004\u0002f%!\t\u0001\u001b\u0005\u0007\u0003SJA\u0011\u00015\t\r\u00055\u0014\u0002\"\u0001i\u0011\u0019\t\t(\u0003C\u0001Q\"1\u0011QO\u0005\u0005\u0002!Da!!\u001f\n\t\u0003A\u0007BBA?\u0013\u0011\u0005\u0001\u000e\u0003\u0004\u0002\u0002&!\t\u0001[\u0001\f%\u0016\u0004H.[2b)\u0016\u001cHO\u0003\u0002#G\u000591\r\\;ti\u0016\u0014(\"\u0001\u0013\u0002\u000b-\fgm[1\u0004\u0001A\u0011q%A\u0007\u0002C\tY!+\u001a9mS\u000e\fG+Z:u'\t\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\n\u0001B\u0011:pW\u0016\u0014\u0018\nZ\u000b\u0002iA\u00111&N\u0005\u0003m1\u00121!\u00138u\u0003%\u0011%o\\6fe&#\u0007%A\u0005QCJ$\u0018\u000e^5p]V\t!\b\u0005\u0002<\u00076\tAH\u0003\u0002>}\u000511m\\7n_:T!\u0001J \u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0005\u0003\tr\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006QCJ$\u0018\u000e^5p]\u0002\n1CU3qY&\u001c\u0017\rT1h)&lW-T1y\u001bN,\u0012\u0001\u0013\t\u0003W%K!A\u0013\u0017\u0003\t1{gnZ\u0001\u0015%\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj\u001d\u0011\u0014\u0005%QC#\u0001(\u0011\u0005\u001dJ\u0011\u0001\u0002;j[\u0016,\u0012!\u0015\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000bA!\u001e;jY*\u0011aKP\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005a\u001b&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000fI,\u0007\u000f\\5dCV\tA\f\u0005\u0002(;&\u0011a,\t\u0002\b%\u0016\u0004H.[2b\u0003-\u0011X\r\u001d7jG\u0006|F%Z9\u0015\u0005\u0005$\u0007CA\u0016c\u0013\t\u0019GF\u0001\u0003V]&$\bbB3\u000f\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014\u0001\u0003:fa2L7-\u0019\u0011\u0002\u000bM,G/\u001e9\u0015\u0003\u0005D#\u0001\u00056\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017aA1qS*\u0011q\u000e]\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t\u0018)A\u0003kk:LG/\u0003\u0002tY\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002%\u0005\u001c8/\u001a:u%\u0016\u0004H.[2b'R\fG/\u001a\u000b\tCZD(\u0010 @\u0002\u0002!)q/\u0005a\u0001\u0011\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\"B=\u0012\u0001\u0004A\u0015\u0001\u00047pO\u0016sGm\u00144gg\u0016$\b\"B>\u0012\u0001\u0004A\u0015A\u00057bgR\u001c\u0015-^4iiV\u0003H+[7f\u001bNDQ!`\tA\u0002!\u000b1\u0004\\1ti\u001a+Go\u00195MK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\b\"B@\u0012\u0001\u0004A\u0015a\u00047bgR4U\r^2i)&lW-T:\t\u0013\u0005\r\u0011\u0003%AA\u0002\u0005\u0015\u0011a\u00032s_.,'/\u00129pG\"\u0004BaKA\u0004\u0011&\u0019\u0011\u0011\u0002\u0017\u0003\r=\u0003H/[8o\u0003q\t7o]3siJ+\u0007\u000f\\5dCN#\u0018\r^3%I\u00164\u0017-\u001e7uIY*\"!a\u0004+\t\u0005\u0015\u0011\u0011C\u0016\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0004\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0012m]:feR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f\t>,7OT8u\u0007\"\fgnZ3\u0015\u0007\u0005\f9\u0003\u0003\u0005\u0002*M!\t\u0019AA\u0016\u0003\ty\u0007\u000f\u0005\u0003,\u0003[\t\u0017bAA\u0018Y\tAAHY=oC6,g(\u0001\tva\u0012\fG/\u001a$fi\u000eD7\u000b^1uKR9\u0001*!\u000e\u0002:\u0005u\u0002BBA\u001c)\u0001\u0007\u0001*A\ng_2dwn^3s\r\u0016$8\r[(gMN,G\u000f\u0003\u0004\u0002<Q\u0001\r\u0001S\u0001\u0014M>dGn\\<feN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\u0007\u0003\u007f!\u0002\u0019\u0001%\u0002\u001f1,\u0017\rZ3s\u000b:$wJ\u001a4tKR\f\u0011C]3tKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u001dA\u0015QIA$\u0003#Ba!a\u0010\u0016\u0001\u0004A\u0005bBA%+\u0001\u0007\u00111J\u0001\fSNtUm\u001e'fC\u0012,'\u000fE\u0002,\u0003\u001bJ1!a\u0014-\u0005\u001d\u0011un\u001c7fC:Dq!a\u0015\u0016\u0001\u0004\tY%\u0001\tjg\u001a{G\u000e\\8xKJLenU=oG\u0006Q\u0011n]\"bk\u001eDG/\u00169\u0015\t\u0005-\u0013\u0011\f\u0005\u0007\u0003\u007f1\u0002\u0019\u0001%\u0002!Q,7\u000f^%oSRL\u0017\r\\*uCR,\u0007fA\f\u0002`A\u00191.!\u0019\n\u0007\u0005\rDN\u0001\u0003UKN$\u0018\u0001\u0006;fgR,\u0006\u000fZ1uK\u001a+Go\u00195Ti\u0006$X\rK\u0002\u0019\u0003?\nA\b^3tiJ+7/\u001a;SKBd\u0017nY1Ti\u0006$Xm\u00165f]2+\u0017\rZ3s\u0013N\u0014V-\u001a7fGR,G-\u00118e%\u0016\u0004H.[2b\u0013NLenU=oG\"\u001a\u0011$a\u0018\u0002\u007fQ,7\u000f\u001e*fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uK^CWM\u001c'fC\u0012,'/S:SK\u0016dWm\u0019;fI\u0006sGMU3qY&\u001c\u0017-S:O_RLenU=oG\"\u001a!$a\u0018\u0002{Q,7\u000f\u001e*fg\u0016$(+\u001a9mS\u000e\f7\u000b^1uK^CWM\u001c(fo2+\u0017\rZ3s\u0013N,E.Z2uK\u0012\fe\u000e\u001a*fa2L7-Y%t\u0013:\u001c\u0016P\\2)\u0007m\ty&\u0001!uKN$(+Z:fiJ+\u0007\u000f\\5dCN#\u0018\r^3XQ\u0016tg*Z<MK\u0006$WM]%t\u000b2,7\r^3e\u0003:$'+\u001a9mS\u000e\f\u0017j\u001d(pi&s7+\u001f8dQ\ra\u0012qL\u0001,i\u0016\u001cH/S:DCV<\u0007\u000e^+q/\",gNU3qY&\u001c\u0017-S:DCV<\u0007\u000e^+q)>dunZ#oI\"\u001aQ$a\u0018\u0002]Q,7\u000f^%t\u0007\u0006,x\r\u001b;Va^CWM\u001c*fa2L7-Y%t\u001d>$8)Y;hQR,\u0006\u000fV8M_\u001e,e\u000e\u001a\u0015\u0004=\u0005}\u0013!\u0006;fgR4UM\\2f'R\fG.Z+qI\u0006$Xm\u001d\u0015\u0004?\u0005}\u0003")
public class ReplicaTest {
    private final MockTime time = new MockTime();
    private Replica replica;

    public static long ReplicaLagTimeMaxMs() {
        return ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs();
    }

    public static TopicPartition Partition() {
        return ReplicaTest$.MODULE$.Partition();
    }

    public static int BrokerId() {
        return ReplicaTest$.MODULE$.BrokerId();
    }

    public MockTime time() {
        return this.time;
    }

    public Replica replica() {
        return this.replica;
    }

    public void replica_$eq(Replica x$1) {
        this.replica = x$1;
    }

    @BeforeEach
    public void setup() {
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokerEpoch(ReplicaTest$.MODULE$.BrokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        this.replica_$eq(new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition(), (MetadataCache)metadataCache));
    }

    private void assertReplicaState(long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchLeaderLogEndOffset, long lastFetchTimeMs, Option<Object> brokerEpoch) {
        ReplicaState replicaState = this.replica().stateSnapshot();
        Assertions.assertEquals((long)logStartOffset, (long)replicaState.logStartOffset(), (String)"Unexpected Log Start Offset");
        Assertions.assertEquals((long)logEndOffset, (long)replicaState.logEndOffset(), (String)"Unexpected Log End Offset");
        Assertions.assertEquals((long)lastCaughtUpTimeMs, (long)replicaState.lastCaughtUpTimeMs(), (String)"Unexpected Last Caught Up Time");
        Assertions.assertEquals((long)lastFetchLeaderLogEndOffset, (long)replicaState.lastFetchLeaderLogEndOffset(), (String)"Unexpected Last Fetch Leader Log End Offset");
        Assertions.assertEquals((long)lastFetchTimeMs, (long)replicaState.lastFetchTimeMs(), (String)"Unexpected Last Fetch Time");
        Assertions.assertEquals(brokerEpoch, (Object)replicaState.brokerEpoch(), (String)"Broker Epoch Mismatch");
    }

    private Option<Object> assertReplicaState$default$6() {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L));
    }

    public void assertReplicaStateDoesNotChange(Function0<BoxedUnit> op) {
        ReplicaState previousState = this.replica().stateSnapshot();
        op.apply$mcV$sp();
        this.assertReplicaState(previousState.logStartOffset(), previousState.logEndOffset(), previousState.lastCaughtUpTimeMs(), previousState.lastFetchLeaderLogEndOffset(), previousState.lastFetchTimeMs(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    private long updateFetchState(long followerFetchOffset, long followerStartOffset, long leaderEndOffset) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().updateFetchStateOrThrow(new LogOffsetMetadata(followerFetchOffset), followerStartOffset, currentTimeMs, leaderEndOffset, 1L);
        return currentTimeMs;
    }

    private long resetReplicaState(long leaderEndOffset, boolean isNewLeader, boolean isFollowerInSync) {
        long currentTimeMs = this.time().milliseconds();
        this.replica().resetReplicaState(currentTimeMs, leaderEndOffset, isNewLeader, isFollowerInSync);
        return currentTimeMs;
    }

    private boolean isCaughtUp(long leaderEndOffset) {
        return this.replica().stateSnapshot().isCaughtUp(leaderEndOffset, this.time().milliseconds(), ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs());
    }

    @Test
    public void testInitialState() {
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, 0L, 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testUpdateFetchState() {
        long fetchTimeMs1 = this.updateFetchState(5L, 1L, 10L);
        this.assertReplicaState(1L, 5L, 0L, 10L, fetchTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        long fetchTimeMs2 = this.updateFetchState(10L, 2L, 15L);
        this.assertReplicaState(2L, 10L, fetchTimeMs1, 15L, fetchTimeMs2, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
        long fetchTimeMs3 = this.updateFetchState(15L, 3L, 15L);
        this.assertReplicaState(3L, 15L, fetchTimeMs3, 15L, fetchTimeMs3, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, false, true);
        this.assertReplicaState(1L, 10L, resetTimeMs1, 11L, resetTimeMs1, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetReplicaStateWhenLeaderIsReelectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, false, false);
        this.assertReplicaState(1L, 10L, 0L, 11L, 0L, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1L)));
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsInSync() {
        this.updateFetchState(10L, 1L, 10L);
        long resetTimeMs1 = this.resetReplicaState(11L, true, true);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), resetTimeMs1, UnifiedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testResetReplicaStateWhenNewLeaderIsElectedAndReplicaIsNotInSync() {
        this.updateFetchState(10L, 1L, 10L);
        this.resetReplicaState(11L, true, false);
        this.assertReplicaState(UnifiedLog$.MODULE$.UnknownOffset(), UnifiedLog$.MODULE$.UnknownOffset(), 0L, UnifiedLog$.MODULE$.UnknownOffset(), 0L, (Option<Object>)Option$.MODULE$.empty());
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 10L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertTrue((boolean)this.isCaughtUp(10L));
    }

    @Test
    public void testIsCaughtUpWhenReplicaIsNotCaughtUpToLogEnd() {
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(5L, 1L, 10L);
        Assertions.assertFalse((boolean)this.isCaughtUp(10L));
        this.updateFetchState(10L, 1L, 15L);
        Assertions.assertTrue((boolean)this.isCaughtUp(16L));
        this.time().sleep(ReplicaTest$.MODULE$.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertFalse((boolean)this.isCaughtUp(16L));
    }

    @Test
    public void testFenceStaleUpdates() {
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokerEpoch(ReplicaTest$.MODULE$.BrokerId())).thenReturn((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)2L)));
        Replica replica = new Replica(ReplicaTest$.MODULE$.BrokerId(), ReplicaTest$.MODULE$.Partition(), (MetadataCache)metadataCache);
        replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 1L, 1L, 10L, 2L);
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 3L, 10L, 1L));
        replica.updateFetchStateOrThrow(new LogOffsetMetadata(5L), 2L, 4L, 10L, -1L);
    }
}

