/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ConcurrentTransactionsException;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.test.api.Flaky;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Mb\u0001\u0002!B\u0001\u0019CQa\u0013\u0001\u0005\u00021CQA\u0014\u0001\u0005B=CqA\u0016\u0001C\u0002\u0013\u0005q\n\u0003\u0004X\u0001\u0001\u0006I\u0001\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0001P\u0011\u0019I\u0006\u0001)A\u0005!\"9!\f\u0001b\u0001\n\u0003y\u0005BB.\u0001A\u0003%\u0001\u000bC\u0004]\u0001\t\u0007I\u0011A/\t\r\u0019\u0004\u0001\u0015!\u0003_\u0011\u001d9\u0007A1A\u0005\u0002uCa\u0001\u001b\u0001!\u0002\u0013q\u0006bB5\u0001\u0005\u0004%\ta\u0014\u0005\u0007U\u0002\u0001\u000b\u0011\u0002)\t\u000f-\u0004!\u0019!C\u0001Y\"9\u0011\u0011\u0003\u0001!\u0002\u0013i\u0007\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0011!\t)\u0003\u0001Q\u0001\n\u0005]\u0001\"CA\u0014\u0001\t\u0007I\u0011AA\u000b\u0011!\tI\u0003\u0001Q\u0001\n\u0005]\u0001bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003w\u0001A\u0011KA\u001f\u0011\u001d\t\t\u0006\u0001C)\u0003'Bq!a\u001b\u0001\t\u0003\ti\u0003C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqAa\u0005\u0001\t\u0013\u0011)\u0002C\u0004\u0003\"\u0001!\tAa\t\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqA!\u001e\u0001\t\u0003\u00119\bC\u0004\u0003\u0004\u0002!IA!\"\t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\"9!\u0011\u0016\u0001\u0005\u0002\t-\u0006b\u0002B\\\u0001\u0011\u0005!\u0011\u0018\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u001d\u0011\u0019\u000e\u0001C\u0001\u0005+DqA!9\u0001\t\u0003\u0011\u0019\u000fC\u0004\u0004\u0002\u0001!\taa\u0001\t\u000f\re\u0001\u0001\"\u0001\u0004\u001c!91Q\u0007\u0001\u0005\u0002\r]\u0002bBB#\u0001\u0011%1q\t\u0005\b\u00077\u0002A\u0011BB/\u0011%\u0019I\u0007AI\u0001\n\u0013\u0019Y\u0007C\u0005\u0004\u0002\u0002\t\n\u0011\"\u0003\u0004\u0004\"I1q\u0011\u0001\u0012\u0002\u0013%1\u0011\u0012\u0005\b\u0007\u001b\u0003A\u0011BBH\u0011\u001d\u0019\u0019\n\u0001C\u0005\u0007+C\u0011b!-\u0001#\u0003%Iaa-\t\u0013\r]\u0006!%A\u0005\n\rM\u0006\"CB]\u0001E\u0005I\u0011BBB\u0011%\u0019Y\fAI\u0001\n\u0013\u0019\u0019\tC\u0004\u0004>\u0002!\taa0\t\u000f\r=\u0007\u0001\"\u0001\u0004R\"91Q\u001c\u0001\u0005\n\r}\u0007b\u0002C\u0006\u0001\u0011\u0005AQ\u0002\u0002\u0011)J\fgn]1di&|gn\u001d+fgRT!AQ\"\u0002\u0007\u0005\u0004\u0018NC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A$\u0011\u0005!KU\"A!\n\u0005)\u000b%AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005i\u0005C\u0001%\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003A\u0003\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u00131!\u00138u\u0003i!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8u\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA\u0005QBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0006YBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\nQD\\8o)J\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u001f]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\na\u0001^8qS\u000e\fT#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00027b]\u001eT\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]:\u0016\u00035\u00042A\\:v\u001b\u0005y'B\u00019r\u0003\u001diW\u000f^1cY\u0016T!A\u001d*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002u_\n1!)\u001e4gKJ\u0004rA^A\u0001\u0003\u000b\t)!D\u0001x\u0015\tA\u00180\u0001\u0005qe>$WoY3s\u0015\tQ80A\u0004dY&,g\u000e^:\u000b\u0005\u0011c(BA?\u007f\u0003\u0019\t\u0007/Y2iK*\tq0A\u0002pe\u001eL1!a\u0001x\u00055Y\u0015MZ6b!J|G-^2feB)\u0011+a\u0002\u0002\f%\u0019\u0011\u0011\u0002*\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\u000bi!C\u0002\u0002\u0010I\u0013AAQ=uK\u00069BO]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u00148\u000fI\u0001\u0017iJ\fgn]1di&|g.\u00197D_:\u001cX/\\3sgV\u0011\u0011q\u0003\t\u0005]N\fI\u0002\u0005\u0005\u0002\u001c\u0005\u0005\u0012QAA\u0003\u001b\t\tiBC\u0002\u0002 e\f\u0001bY8ogVlWM]\u0005\u0005\u0003G\tiB\u0001\u0005D_:\u001cX/\\3s\u0003]!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001c\b%A\ro_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001c\u0018A\u00078p]R\u0013\u0018M\\:bGRLwN\\1m\u0007>t7/^7feN\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0015\u0005\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U\"-\u0001\u0003vi&d\u0017\u0002BA\u001d\u0003g\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u00035iw\u000eZ5gs\u000e{gNZ5hgR!\u0011qHA#!\r\t\u0016\u0011I\u0005\u0004\u0003\u0007\u0012&\u0001B+oSRDq!a\u0012\u0017\u0001\u0004\tI%A\u0003qe>\u00048\u000f\u0005\u0004\u0002L\u00055\u0013qF\u0007\u0002c&\u0019\u0011qJ9\u0003\u0007M+\u0017/\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\u0011\tI%!\u0016\t\u000f\u0005]s\u00031\u0001\u0002Z\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\\\u0005\u001dTBAA/\u0015\r\u0011\u0015q\f\u0006\u0005\u0003C\n\u0019'A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0015d0A\u0003kk:LG/\u0003\u0003\u0002j\u0005u#\u0001\u0003+fgRLeNZ8\u0002\u0017Q|\u0007/[2D_:4\u0017nZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003\u007f\t\t\bC\u0004\u0002Xe\u0001\r!!\u0017)\u0007e\t)\b\u0005\u0003\u0002\\\u0005]\u0014\u0002BA=\u0003;\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tGCAA Q\rQ\u0012\u0011\u0011\t\u0005\u00037\n\u0019)\u0003\u0003\u0002\u0006\u0006u#!C!gi\u0016\u0014X)Y2i\u0003U!Xm\u001d;CCNL7\r\u0016:b]N\f7\r^5p]N$b!a\u0010\u0002\f\u0006\r\u0006bBAG7\u0001\u0007\u0011qR\u0001\u0007cV|'/^7\u0011\t\u0005E\u0015q\u0014\b\u0005\u0003'\u000bY\nE\u0002\u0002\u0016Jk!!a&\u000b\u0007\u0005eU)\u0001\u0004=e>|GOP\u0005\u0004\u0003;\u0013\u0016A\u0002)sK\u0012,g-C\u0002f\u0003CS1!!(S\u0011\u001d\t)k\u0007a\u0001\u0003\u001f\u000bQb\u001a:pkB\u0004&o\u001c;pG>d\u0007fB\u000e\u0002*\u0006U\u0016q\u0017\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVA0\u0003\u0019\u0001\u0018M]1ng&!\u00111WAW\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002:\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\bfB\u000e\u0002>\u0006%\u00171\u001a\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YAW\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BAd\u0003\u0003\u0014A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d#!!4\"\u0005\u0005=\u0017AK4fiR+7\u000f^)v_J,X.\u00118e\u000fJ|W\u000f\u001d)s_R|7m\u001c7QCJ\fW.\u001a;feN\fE\u000e\\\u00013i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'o\u00155pk2$gj\u001c;TK\u0016,f\u000eZ3dS\u0012,G\rR1uCR1\u0011qHAk\u0003/Dq!!$\u001d\u0001\u0004\ty\tC\u0004\u0002&r\u0001\r!a$)\u000fq\tY.!3\u0002nB!\u0011Q\\Au\u001b\t\tyNC\u0002C\u0003CTA!a9\u0002f\u0006!A/Z:u\u0015\r\t9o_\u0001\u0007G>lWn\u001c8\n\t\u0005-\u0018q\u001c\u0002\u0006\r2\f7._\u0011\u0003\u0003_\f1bS!G\u0017\u0006k\u0013\u0007\u000f\u00194m!:A$!+\u00026\u0006]\u0006f\u0002\u000f\u0002>\u0006%\u0017Q\u001f\u0017\u0003\u0003\u001b\f!\u0006^3ti\u0012+G.Y=fI\u001a+Go\u00195J]\u000edW\u000fZ3t\u0003\n|'\u000f^3e)J\fgn]1di&|g\u000e\u0006\u0004\u0002@\u0005m\u0018Q \u0005\b\u0003\u001bk\u0002\u0019AAH\u0011\u001d\t)+\ba\u0001\u0003\u001fCs!HAU\u0003k\u000b9\fK\u0004\u001e\u0003{\u000bIMa\u0001-\u0005\u00055\u0017\u0001\t;fgR\u001cVM\u001c3PM\u001a\u001cX\r^:XSRDwI]8va6+G/\u00193bi\u0006$b!a\u0010\u0003\n\t-\u0001bBAG=\u0001\u0007\u0011q\u0012\u0005\b\u0003Ks\u0002\u0019AAHQ\u001dq\u0012\u0011VA[\u0003oCsAHA_\u0003\u0013\u0014\t\u0002\f\u0002\u0002N\u0006Q1/\u001a8e\u001f\u001a47/\u001a;\u0015\t\u0005}\"q\u0003\u0005\b\u00053y\u0002\u0019\u0001B\u000e\u0003\u0019\u0019w.\\7jiBQ\u0011K!\bv\u0003\u001f\u000bI\"a\u0010\n\u0007\t}!KA\u0005Gk:\u001cG/[8og\u0005\u0019B/Z:u\r\u0016t7-\u001b8h\u001f:\u001cu.\\7jiR1\u0011q\bB\u0013\u0005OAq!!$!\u0001\u0004\ty\tC\u0004\u0002&\u0002\u0002\r!a$)\u000f\u0001\nI+!.\u00028\":\u0001%!0\u0002J\n5BFAAg\u0003a!Xm\u001d;GK:\u001c\u0017N\\4P]N+g\u000eZ(gMN,Go\u001d\u000b\u0007\u0003\u007f\u0011\u0019D!\u000e\t\u000f\u00055\u0015\u00051\u0001\u0002\u0010\"9\u0011QU\u0011A\u0002\u0005=\u0005fB\u0011\u0002*\u0006U\u0016q\u0017\u0015\bC\u0005u\u0016\u0011\u001aB\u001eY\t\ti-\u0001\u0017uKN$xJ\u001a4tKRlU\r^1eCR\f\u0017J\\*f]\u0012|eMZ:fiN$v\u000e\u0016:b]N\f7\r^5p]R1\u0011q\bB!\u0005\u0007Bq!!$#\u0001\u0004\ty\tC\u0004\u0002&\n\u0002\r!a$)\u000f\t\nI+!.\u00028\":!%!0\u0002J\n%CFAAg\u0003m!Xm\u001d;J]&$HK]1og\u0006\u001cG/[8ogRKW.Z8viR1\u0011q\bB(\u0005#Bq!!$$\u0001\u0004\ty\tC\u0004\u0002&\u000e\u0002\r!a$)\u000f\r\nI+!.\u00028\":1%!0\u0002J\n]CFAAg\u0003\r\"Xm\u001d;TK:$wJ\u001a4tKR\u001cHk\u001c+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkR$b!a\u0010\u0003^\t}\u0003bBAGI\u0001\u0007\u0011q\u0012\u0005\b\u0003K#\u0003\u0019AAHQ\u001d!\u0013\u0011VA[\u0003oCs\u0001JA_\u0003\u0013\u0014)\u0007\f\u0002\u0002N\u0006aB/Z:u\u0007>lW.\u001b;Ue\u0006t7/Y2uS>tG+[7f_V$HCBA \u0005W\u0012i\u0007C\u0004\u0002\u000e\u0016\u0002\r!a$\t\u000f\u0005\u0015V\u00051\u0001\u0002\u0010\":Q%!+\u00026\u0006]\u0006fB\u0013\u0002>\u0006%'1\u000f\u0017\u0003\u0003\u001b\f1\u0004^3ti\u0006\u0013wN\u001d;Ue\u0006t7/Y2uS>tG+[7f_V$HCBA \u0005s\u0012Y\bC\u0004\u0002\u000e\u001a\u0002\r!a$\t\u000f\u0005\u0015f\u00051\u0001\u0002\u0010\":a%!+\u00026\u0006]\u0006f\u0002\u0014\u0002>\u0006%'\u0011\u0011\u0017\u0003\u0003\u001b\f1\u0002^3tiRKW.Z8viR1\u0011q\bBD\u0005#CqA!#(\u0001\u0004\u0011Y)\u0001\noK\u0016$\u0017J\\5u\u0003:$7+\u001a8e\u001bN<\u0007cA)\u0003\u000e&\u0019!q\u0012*\u0003\u000f\t{w\u000e\\3b]\"9!1S\u0014A\u0002\tU\u0015A\u0004;j[\u0016|W\u000f\u001e)s_\u000e,7o\u001d\t\u0007#\n]U/a\u0010\n\u0007\te%KA\u0005Gk:\u001cG/[8oc\u0005\tB/Z:u\r\u0016t7-\u001b8h\u001f:\u001cVM\u001c3\u0015\r\u0005}\"q\u0014BQ\u0011\u001d\ti\t\u000ba\u0001\u0003\u001fCq!!*)\u0001\u0004\ty\tK\u0004)\u0003S\u000b),a.)\u000f!\ni,!3\u0003(2\u0012\u0011QZ\u0001\u001bi\u0016\u001cHOR3oG&twm\u00148BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003\u007f\u0011iKa,\t\u000f\u00055\u0015\u00061\u0001\u0002\u0010\"9\u0011QU\u0015A\u0002\u0005=\u0005fB\u0015\u0002*\u0006U\u0016q\u0017\u0015\bS\u0005u\u0016\u0011\u001aB[Y\t\ti-\u0001\u0012uKN$h)\u001a8dS:<wJ\u001c+sC:\u001c\u0018m\u0019;j_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0007\u0003\u007f\u0011YL!0\t\u000f\u00055%\u00061\u0001\u0002\u0010\"9\u0011Q\u0015\u0016A\u0002\u0005=\u0005f\u0002\u0016\u0002*\u0006U\u0016q\u0017\u0015\bU\u0005u\u0016\u0011\u001aBbY\t\ti-\u0001\u000fuKN$X*\u001e7uSBdW-T1sW\u0016\u00148o\u00148f\u0019\u0016\fG-\u001a:\u0015\r\u0005}\"\u0011\u001aBf\u0011\u001d\tii\u000ba\u0001\u0003\u001fCq!!*,\u0001\u0004\ty\tK\u0004,\u0003S\u000b),a.)\u000f-\ni,!3\u0003R2\u0012\u0011QZ\u0001%i\u0016\u001cHoQ8og\u0016\u001cW\u000f^5wK2L(+\u001e8J]&$HK]1og\u0006\u001cG/[8ogR1\u0011q\bBl\u00053Dq!!$-\u0001\u0004\ty\tC\u0004\u0002&2\u0002\r!a$)\u000f1\nI+!.\u00028\":A&!0\u0002J\n}GFAAg\u0003%\"Xm\u001d;Ck6\u0004HK]1og\u0006\u001cG/[8oC2,\u0005o\\2i/&$\b\u000e\u0016,3\t&\u001c\u0018M\u00197fIRA\u0011q\bBs\u0005O\u0014I\u000fC\u0004\u0002\u000e6\u0002\r!a$\t\u000f\u0005\u0015V\u00061\u0001\u0002\u0010\"9!1^\u0017A\u0002\t-\u0015\u0001D5t)Z\u0013TI\\1cY\u0016$\u0007fA\u0017\u0002*\":QF!=\u0002J\n]\b\u0003BA`\u0005gLAA!>\u0002B\nI1i\u001d<T_V\u00148-\u001a\u0017\u0005\u0005s\u0014i0\t\u0002\u0003|\u0006\u00192N]1gi2\u001aG.Y:tS\u000edc-\u00197tK\u0006\u0012!q`\u0001\u0015WJ\fg\r\u001e\u0017d_:\u001cX/\\3sY\u0019\fGn]3\u0002QQ,7\u000f\u001e\"v[B$&/\u00198tC\u000e$\u0018n\u001c8bY\u0016\u0003xn\u00195XSRDGK\u0016\u001aF]\u0006\u0014G.\u001a3\u0015\u0011\u0005}2QAB\u0004\u0007\u0013Aq!!$/\u0001\u0004\ty\tC\u0004\u0002&:\u0002\r!a$\t\u000f\t-h\u00061\u0001\u0003\f\"\u001aa&!+)\u000f9\u0012\t0!3\u0004\u00101\"1\u0011CB\u000bC\t\u0019\u0019\"\u0001\u000ble\u00064G\u000f\f\u0011dY\u0006\u001c8/[2-AQ\u0014X/Z\u0011\u0003\u0007/\tQc\u001b:bMRd\u0003eY8ogVlWM\u001d\u0017!iJ,X-A\fuKN$h)Y5mkJ,Gk\u001c$f]\u000e,W\t]8dQRA\u0011qHB\u000f\u0007?\u0019\t\u0003C\u0004\u0002\u000e>\u0002\r!a$\t\u000f\u0005\u0015v\u00061\u0001\u0002\u0010\"9!1^\u0018A\u0002\t-\u0005fB\u0018\u0002*\u0006U6QE\u0011\u0003\u0007O\t1h\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\fTPL5t)Z\u0013TI\\1cY\u0016$Wh\u001f\u001a~Q\u001dy#\u0011_Ae\u0007Wa\u0003b!\f\u00042\rE1QC\u0011\u0003\u0007_\tQc\u001b:bMRd\u0003e\u00197bgNL7\r\f\u0011gC2\u001cX-\t\u0002\u00044\u000512N]1gi2\u00023m\u001c8tk6,'\u000f\f\u0011gC2\u001cX-A\ruKN$X)\u001c9us\u0006\u0013wN\u001d;BMR,'oQ8n[&$H\u0003CA \u0007s\u0019Yd!\u0010\t\u000f\u00055\u0005\u00071\u0001\u0002\u0010\"9\u0011Q\u0015\u0019A\u0002\u0005=\u0005b\u0002Bva\u0001\u0007!1\u0012\u0015\ba\u0005%\u0016QWB\u0013Q\u001d\u0001$\u0011_Ae\u0007\u0007b#a!\u0006\u0002OM,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\fG.T3tg\u0006<Wm],ji\"4\u0016\r\\;f%\u0006tw-\u001a\u000b\r\u0003\u007f\u0019Iea\u0013\u0004P\rM3q\u000b\u0005\u0006qF\u0002\r!\u001e\u0005\b\u0007\u001b\n\u0004\u0019AAH\u0003\u0015!x\u000e]5d\u0011\u0019\u0019\t&\ra\u0001!\u0006)1\u000f^1si\"11QK\u0019A\u0002A\u000b1!\u001a8e\u0011\u001d\u0019I&\ra\u0001\u0005\u0017\u000bqb^5mY\n+7i\\7nSR$X\rZ\u0001\u001cGJ,\u0017\r^3SK\u0006$7i\\7nSR$X\rZ\"p]N,X.\u001a:\u0015\u0011\u0005e1qLB2\u0007OB\u0011b!\u00193!\u0003\u0005\r!a$\u0002\u000b\u001d\u0014x.\u001e9\t\u0011\r\u0015$\u0007%AA\u0002A\u000ba\"\\1y!>dGNU3d_J$7\u000fC\u0005\u0002HI\u0002\n\u00111\u0001\u00020\u0005)3M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$C-\u001a4bk2$H%M\u000b\u0003\u0007[RC!a$\u0004p-\u00121\u0011\u000f\t\u0005\u0007g\u001ai(\u0004\u0002\u0004v)!1qOB=\u0003%)hn\u00195fG.,GMC\u0002\u0004|I\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0019yh!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0011\u0016\u0004!\u000e=\u0014!J2sK\u0006$XMU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YI\u000b\u0003\u00020\r=\u0014!H2sK\u0006$XMU3bIVs7m\\7nSR$X\rZ\"p]N,X.\u001a:\u0015\t\u0005e1\u0011\u0013\u0005\b\u0007C2\u0004\u0019AAH\u0003m\u0019'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2feRYQoa&\u0004\u001c\u000e\u00156\u0011VBW\u0011\u001d\u0019Ij\u000ea\u0001\u0003\u001f\u000bq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0005\n\u0007;;\u0004\u0013!a\u0001\u0007?\u000bA\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\bcA)\u0004\"&\u001911\u0015*\u0003\t1{gn\u001a\u0005\n\u0007O;\u0004\u0013!a\u0001\u0007?\u000b!\"\\1y\u00052|7m['t\u0011!\u0019Yk\u000eI\u0001\u0002\u0004\u0001\u0016!\u00053fY&4XM]=US6,w.\u001e;Ng\"A1qV\u001c\u0011\u0002\u0003\u0007\u0001+\u0001\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0006)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEM\u000b\u0003\u0007kSCaa(\u0004p\u0005)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HeM\u0001&GJ,\u0017\r^3Ue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIQ\nQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002G5\f\u0017PY3XC&$hi\u001c:Bi2+\u0017m\u001d;P]\u0016\u001cVmZ7f]R,\u0006\u000f\\8bIR!\u0011qHBa\u0011\u001d\u0019\u0019\r\u0010a\u0001\u0007\u000b\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0003\u0017\niea2\u0011\t\r%71Z\u0007\u0003\u0003KLAa!4\u0002f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!\u0006<fe&4\u0017\u0010T8h'R\f'\u000f^(gMN,Go\u001d\u000b\u0005\u0003\u007f\u0019\u0019\u000eC\u0004\u0004Vv\u0002\raa6\u0002+A\f'\u000f^5uS>t7\u000b^1si>3gm]3ugB9\u0011\u0011SBm\u0007\u000f\u0004\u0016\u0002BBn\u0003C\u00131!T1q\u0003E\u0019wN\\:v[\u0016\u0014VmY8sIN4uN]\u000b\u0007\u0007C\u001cy\u000fb\u0001\u0015\t\r\rHq\u0001\t\u0007\u0003\u0017\nie!:\u0011\u0011\u0005m1q]Bv\t\u0003IAa!;\u0002\u001e\tq1i\u001c8tk6,'OU3d_J$\u0007\u0003BBw\u0007_d\u0001\u0001B\u0004\u0004rz\u0012\raa=\u0003\u0003-\u000bBa!>\u0004|B\u0019\u0011ka>\n\u0007\re(KA\u0004O_RD\u0017N\\4\u0011\u0007E\u001bi0C\u0002\u0004\u0000J\u00131!\u00118z!\u0011\u0019i\u000fb\u0001\u0005\u000f\u0011\u0015aH1\u0001\u0004t\n\ta\u000bC\u0004\u0002 y\u0002\r\u0001\"\u0003\u0011\u0011\u0005m\u0011\u0011EBv\t\u0003\tq$\\1zE\u00164VM]5gs2{7-\u00197M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;t)\u0011\ty\u0004b\u0004\t\u000f\rUw\b1\u0001\u0005\u0012AA\u0011\u0011SBm\u0007\u000f$\u0019\u0002E\u0002`\t+I1aa)aQ\u0015yD\u0011\u0004C\u0019!\u0015\tF1\u0004C\u0010\u0013\r!iB\u0015\u0002\u0007i\"\u0014xn^:\u0011\t\u0011\u0005B1\u0006\b\u0005\tG!9C\u0004\u0003\u0002\u0016\u0012\u0015\u0012\"A*\n\u0007\u0011%\"+A\u0004qC\u000e\\\u0017mZ3\n\t\u00115Bq\u0006\u0002\u0015\u0013:$XM\u001d:vaR,G-\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0011%\"k\t\u0002\u0005 \u0001")
public class TransactionsTest
extends IntegrationTestHarness {
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    @Override
    public int brokerCount() {
        return 3;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<Consumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<Consumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    public Properties overridingProps() {
        Properties props = new Properties();
        props.put("auto.create.topics.enable", Boolean.toString(false));
        props.put("offsets.topic.num.partitions", Integer.toString(1));
        props.put("transaction.state.log.num.partitions", Integer.toString(3));
        props.put("transaction.state.log.replication.factor", Integer.toString(2));
        props.put("transaction.state.log.min.isr", Integer.toString(2));
        props.put("controlled.shutdown.enable", Boolean.toString(true));
        props.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(false));
        props.put("auto.leader.rebalance.enable", Boolean.toString(false));
        props.put("group.initial.rebalance.delay.ms", "0");
        props.put("transaction.abort.timed.out.transaction.cleanup.interval.ms", "200");
        return props;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overridingProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.overridingProps(), (List)Nil$.MODULE$);
    }

    public Properties topicConfig() {
        Properties topicConfig = new Properties();
        topicConfig.put(ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG, Integer.toString(2));
        return topicConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalProducerCount()).foreach((Function1 & Serializable)x$1 -> this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.transactionalConsumerCount()).foreach((Function1 & Serializable)x$2 -> this.createReadCommittedConsumer("transactional-group", 500, new Properties()));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nonTransactionalConsumerCount()).foreach((Function1 & Serializable)x$3 -> this.createReadUncommittedConsumer("non-transactional-group"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testBasicTransactions(String quorum, String groupProtocol) {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        TopicPartition tp11 = new TopicPartition(this.topic1(), 1);
        TopicPartition tp22 = new TopicPartition(this.topic2(), 2);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "4", "4", false));
        producer.flush();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(0L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(0L))}))));
        producer.abortTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)new .colon.colon((Object)tp11, (List)new .colon.colon((Object)tp22, (List)Nil$.MODULE$)));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(1L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(1L))}))));
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(2), "3", "3", true));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(1L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(1L))}))));
        producer.commitTransaction();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)tp22, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp11, (Object)Predef$.MODULE$.long2Long(3L)), new Tuple2((Object)tp22, (Object)Predef$.MODULE$.long2Long(3L))}))));
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, 15000L);
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Flaky(value="KAFKA-18036")
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testReadCommittedConsumerShouldNotSeeUndecidedData(String quorum, String groupProtocol) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        Consumer readCommittedConsumer = (Consumer)this.transactionalConsumers().head();
        Consumer readUncommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, 15000L);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertEquals((int)2, (int)readUncommittedOffsetsForTimes.size());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assertions.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L).foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assertions.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Predef$.MODULE$.long2Long(latestWrittenTimestamp))}))).asJava());
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assertions.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testDelayedFetchIncludesAbortedTransaction(String quorum, String groupProtocol) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        TopicPartition tp10 = new TopicPartition(this.topic1(), 0);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)Predef$.MODULE$.long2Long(0L))}))));
        producer1.abortTransaction();
        producer2.commitTransaction();
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)new .colon.colon((Object)tp10, (List)Nil$.MODULE$));
        this.verifyLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)BoxesRunTime.boxToInteger((int)0))}))));
        this.maybeVerifyLocalLogStartOffsets((scala.collection.immutable.Map<TopicPartition, Long>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)tp10, (Object)Predef$.MODULE$.long2Long(5L))}))));
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = "group";
        int x$3 = 500;
        Consumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp10}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L);
        Assertions.assertEquals((int)2, (int)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assertions.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assertions.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assertions.assertEquals((long)3L, (long)second.offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSendOffsetsWithGroupMetadata(String quorum, String groupProtocol) {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, this.brokers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "committed transaction.. Last committed record: " + new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8) + ". Num records written to " + this.topic2() + ": " + recordsProcessed$1.elem);
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> "aborted transaction Last committed record: " + new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8) + ". Num records written to " + this.topic2() + ": " + recordsProcessed$1.elem);
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        ListBuffer sendOffset_partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)sendOffset_partitions.toSeq());
        Consumer sendOffset_verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assertions.assertEquals((int)sendOffset_numSeedMessages, (int)sendOffset_valueSeq.size(), (String)("Expected " + sendOffset_numSeedMessages + " values in " + this.topic2() + "."));
        Assertions.assertEquals((int)sendOffset_valueSeq.size(), (int)sendOffset_valueSet.size(), (String)("Expected " + sendOffset_valueSeq.size() + " unique messages in " + this.topic2() + "."));
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, this.brokers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), 15000L);
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "committed transaction.. Last committed record: " + new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8) + ". Num records written to " + this.topic2() + ": " + recordsProcessed$1.elem);
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> "aborted transaction Last committed record: " + new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8) + ". Num records written to " + this.topic2() + ": " + recordsProcessed$1.elem);
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        ListBuffer partitions = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach((Function1 & Serializable)partition -> TransactionsTest.$anonfun$sendOffset$4(this, sendOffset_partitions, BoxesRunTime.unboxToInt((Object)partition)));
        this.maybeWaitForAtLeastOneSegmentUpload((Seq<TopicPartition>)partitions.toSeq());
        Consumer verifyingConsumer = (Consumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)))));
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assertions.assertEquals((int)numSeedMessages, (int)valueSeq.size(), (String)("Expected " + numSeedMessages + " values in " + this.topic2() + "."));
        Assertions.assertEquals((int)valueSeq.size(), (int)valueSet.size(), (String)("Expected " + valueSeq.size() + " unique messages in " + this.topic2() + "."));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFencingOnCommit(String quorum, String groupProtocol) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.commitTransaction());
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFencingOnSendOffsets(String quorum, String groupProtocol) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.flush();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        Assertions.assertThrows(ProducerFencedException.class, () -> producer1.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(110L))}))).asJava(), new ConsumerGroupMetadata("foobarGroup")));
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testOffsetMetadataInSendOffsetsToTransaction(String quorum, String groupProtocol) {
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        Consumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, 500, new Properties());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetAndMetadata)}))).asJava(), new ConsumerGroupMetadata(groupId));
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"cannot read committed offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testInitTransactionsTimeout(String quorum, String groupProtocol) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.initTransactions();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = false;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSendOffsetsToTransactionTimeout(String quorum, String groupProtocol) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)new OffsetAndMetadata(0L))}))).asJava(), new ConsumerGroupMetadata("test-group"));
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCommitTransactionTimeout(String quorum, String groupProtocol) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.commitTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testAbortTransactionTimeout(String quorum, String groupProtocol) {
        void testTimeout_timeoutProcess;
        Function1 & Serializable intersect = (Function1 & Serializable)producer -> {
            producer.abortTransaction();
            return BoxedUnit.UNIT;
        };
        boolean testTimeout_needInitAndSendMsg = true;
        long testTimeout_x$3 = 60000L;
        int testTimeout_x$4 = 120000;
        int testTimeout_x$5 = 30000;
        KafkaProducer<byte[], byte[]> testTimeout_producer = this.createTransactionalProducer("transactionProducer", testTimeout_x$3, 3000L, testTimeout_x$4, testTimeout_x$5);
        if (testTimeout_needInitAndSendMsg) {
            testTimeout_producer.initTransactions();
            testTimeout_producer.beginTransaction();
            testTimeout_producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> TransactionsTest.$anonfun$testTimeout$2((Function1)testTimeout_timeoutProcess, testTimeout_producer));
        testTimeout_producer.close(Duration.ZERO);
    }

    private void testTimeout(boolean needInitAndSendMsg, Function1<KafkaProducer<byte[], byte[]>, BoxedUnit> timeoutProcess) {
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionProducer", x$3, 3000L, x$4, x$5);
        if (needInitAndSendMsg) {
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(new ProducerRecord(this.topic1(), (Object)"foo".getBytes(), (Object)"bar".getBytes()));
        }
        this.brokers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.killBroker(i));
        Assertions.assertThrows(TimeoutException.class, () -> timeoutProcess.apply((Object)producer));
        producer.close(Duration.ZERO);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFencingOnSend(String quorum, String groupProtocol) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> "Missed a producer fenced exception when writing to " + recordMetadata.topic() + "-" + recordMetadata.partition() + ". Grab the logs!!");
            this.brokers().foreach((Function1 & Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> "log dirs: " + ((IterableOps)broker.logManager().liveLogDirs().map((Function1 & Serializable)x$8 -> x$8.getAbsolutePath())).head());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidProducerEpochException));
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFencingOnAddPartitions(String quorum, String groupProtocol) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        Consumer consumer = (Consumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic1(), 0), 15000L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic2(), 0), 15000L);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> "Missed an exception when writing to " + recordMetadata.topic() + "-" + recordMetadata.partition() + ". Grab the logs!!");
            this.brokers().foreach((Function1 & Serializable)broker -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> "log dirs: " + ((IterableOps)broker.logManager().liveLogDirs().map((Function1 & Serializable)x$9 -> x$9.getAbsolutePath())).head());
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"Should not be able to send messages from a fenced producer.");
        }
        catch (InvalidProducerEpochException invalidProducerEpochException) {
        }
        catch (ExecutionException e) {
            String string = quorum;
            String string2 = "zk";
            if (string != null && string.equals(string2)) {
                Assertions.assertTrue((boolean)(e.getCause() instanceof ProducerFencedException));
            } else {
                Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidProducerEpochException));
            }
        }
        catch (Exception e) {
            throw new AssertionError("Got an unexpected exception from a fenced producer.", e);
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testFencingOnTransactionExpiration(String quorum, String groupProtocol) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 300L, 60000L, 120000, 30000);
        producer.initTransactions();
        producer.beginTransaction();
        Assertions.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            Assertions.fail((String)"should have raised an error due to concurrent transactions or invalid producer epoch");
        }
        catch (ConcurrentTransactionsException concurrentTransactionsException) {
        }
        catch (InvalidProducerEpochException invalidProducerEpochException) {
        }
        catch (ExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidProducerEpochException), (String)("Error was " + e.getCause() + " and not InvalidProducerEpochException"));
        }
        Consumer nonTransactionalConsumer = (Consumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, 15000L);
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        Consumer transactionalConsumer = (Consumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertTrue((boolean)this.consumeRecordsFor(transactionalConsumer).isEmpty());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testMultipleMarkersOneLeader(String quorum, String groupProtocol) {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        Consumer unCommittedConsumer = (Consumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        this.createTopic(topicWith10Partitions, 10, this.brokerCount(), this.topicConfig(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, 15000L);
        scala.collection.immutable.Set expectedValues = package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable)x$10 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$10))).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testConsecutivelyRunInitTransactions(String quorum, String groupProtocol) {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", 60000L, 60000L, 120000, 30000);
        producer.initTransactions();
        Assertions.assertThrows(IllegalStateException.class, () -> producer.initTransactions());
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,classic,false", "kraft,consumer,false"})
    public void testBumpTransactionalEpochWithTV2Disabled(String quorum, String groupProtocol, boolean isTV2Enabled) {
        int defaultLinger = 5;
        int x$2 = 5000 + defaultLinger;
        long x$4 = 60000L;
        long x$5 = 60000L;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", x$4, x$5, x$2, 5000);
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(testTopic, 0), 15000L);
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
            Assertions.assertTrue((boolean)activeProducersIter.hasNext());
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get(20L, TimeUnit.SECONDS);
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertNotNull((Object)producerStateEntry);
            Assertions.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest
    @CsvSource(value={"kraft, classic, true", "kraft, consumer, true"})
    public void testBumpTransactionalEpochWithTV2Enabled(String quorum, String groupProtocol, boolean isTV2Enabled) {
        int defaultLinger = 5;
        int x$2 = 5000 + defaultLinger;
        long x$4 = 60000L;
        long x$5 = 60000L;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", x$4, x$5, x$2, 5000);
        Consumer consumer = (Consumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(testTopic, 0), 15000L);
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get(20L, TimeUnit.SECONDS);
            LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            Iterator activeProducersIter = ((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator();
            Assertions.assertTrue((boolean)activeProducersIter.hasNext());
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)activeProducersIter.next().getValue();
            long producerId = producerStateEntry.producerId();
            short previousProducerEpoch = producerStateEntry.producerEpoch();
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true)).get(20L, TimeUnit.SECONDS);
            LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(this.topic2(), 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
            Assertions.assertNotNull((Object)producerStateEntry);
            Assertions.assertTrue((producerStateEntry.producerEpoch() > previousProducerEpoch ? 1 : 0) != 0);
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}.isTV2Enabled={2}")
    @CsvSource(value={"kraft, classic, false", "kraft, consumer, false", "kraft, classic, true", "kraft, consumer, true"})
    public void testFailureToFenceEpoch(String quorum, String groupProtocol, boolean isTV2Enabled) {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("transactional-producer", x$3, 1000L, x$4, x$5);
        int initialProducerEpoch = 0;
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.brokers(), new TopicPartition(this.topic1(), 0), 15000L);
        LogManager qual$1 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().entrySet().iterator().next().getValue();
        long producerId = producerStateEntry.producerId();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from initTransactions", e);
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw new AssertionError("Got an unexpected exception from commitTransaction", e);
            }
        }
        finally {
            producer1.close();
        }
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaBroker)this.brokers().apply(partitionLeader)).logManager();
        TopicPartition x$8 = new TopicPartition(this.topic1(), 0);
        boolean x$9 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((UnifiedLog)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().get(BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertNotNull((Object)producerStateEntry);
        if (!isTV2Enabled) {
            Assertions.assertEquals((short)((short)(initialProducerEpoch + 1)), (short)producerStateEntry.producerEpoch());
            return;
        }
        Assertions.assertTrue(((short)(initialProducerEpoch + 1) <= producerStateEntry.producerEpoch() ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}.isTV2Enabled={2}")
    @CsvSource(value={"kraft, consumer, true"})
    public void testEmptyAbortAfterCommit(String quorum, String groupProtocol, boolean isTV2Enabled) {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(1), "4", "4", false));
        producer.commitTransaction();
        producer.beginTransaction();
        producer.abortTransaction();
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable)i -> TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
    }

    private Consumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        GroupProtocol x$2 = this.groupProtocolFromTestParameters();
        String x$7 = "earliest";
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, x$2, group, x$7, false, true, maxPollRecords, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    private Consumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        GroupProtocol x$2 = this.groupProtocolFromTestParameters();
        String x$5 = "earliest";
        boolean x$6 = false;
        int x$7 = 500;
        SecurityProtocol x$8 = SecurityProtocol.PLAINTEXT;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        Consumer consumer = TestUtils$.MODULE$.createConsumer(x$1, x$2, group, x$5, false, x$6, x$7, x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaBroker> x$2 = this.brokers();
        int x$7 = 16384;
        int x$8 = 5;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs, x$8);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public void maybeWaitForAtLeastOneSegmentUpload(Seq<TopicPartition> topicPartitions) {
    }

    /*
     * WARNING - void declaration
     */
    public void verifyLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionStartOffsets) {
        HashMap offsets = new HashMap();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsTest.$anonfun$verifyLogStartOffsets$1(this, partitionStartOffsets, offsets)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$verifyLogStartOffsets$4(partitionStartOffsets, offsets));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private <K, V> Seq<ConsumerRecord<K, V>> consumeRecordsFor(Consumer<K, V> consumer) {
        int duration = 1000;
        long startTime = System.currentTimeMillis();
        ArrayBuffer records = new ArrayBuffer();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsTest.$anonfun$consumeRecordsFor$1(records, consumer, startTime, duration)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TransactionsTest.$anonfun$consumeRecordsFor$2(duration));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return records;
    }

    public void maybeVerifyLocalLogStartOffsets(scala.collection.immutable.Map<TopicPartition, Long> partitionStartOffsets) throws InterruptedException {
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assertions.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assertions.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ ListBuffer $anonfun$sendOffset$4(TransactionsTest $this, ListBuffer partitions$1, int partition) {
        return (ListBuffer)partitions$1.$plus$eq((Object)new TopicPartition($this.topic2(), partition));
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$10) {
        return Integer.toString(x$10);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assertions.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$4, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$4.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogStartOffsets$3(KafkaBroker broker$3, HashMap offsets$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            int offset = x0$1._2$mcI$sp();
            long lso = ((UnifiedLog)broker$3.replicaManager().localLog(partition).get()).logStartOffset();
            offsets$1.put(Predef$.MODULE$.int2Integer(broker$3.config().brokerId()), Predef$.MODULE$.long2Long(lso));
            return (long)offset == lso;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyLogStartOffsets$1(TransactionsTest $this, scala.collection.immutable.Map partitionStartOffsets$1, HashMap offsets$1) {
        return $this.brokers().forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)partitionStartOffsets$1.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionsTest.$anonfun$verifyLogStartOffsets$3(broker, offsets$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$verifyLogStartOffsets$4(scala.collection.immutable.Map partitionStartOffsets$1, HashMap offsets$1) {
        return "log start offset doesn't change to the expected position: " + partitionStartOffsets$1 + ", current position: " + offsets$1;
    }

    public static final /* synthetic */ boolean $anonfun$consumeRecordsFor$1(ArrayBuffer records$2, Consumer consumer$2, long startTime$1, int duration$1) {
        records$2.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)consumer$2.poll(Duration.ofMillis(50L))).asScala());
        return System.currentTimeMillis() - startTime$1 > (long)duration$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecordsFor$2(int duration$1) {
        return "The timeout " + duration$1 + " was greater than the maximum wait time.";
    }

    public TransactionsTest() {
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$7, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }
}

