/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004F\u0001\u0001\u0006Ia\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0003?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0013q\u0004BB%\u0001A\u0003%q\bC\u0004K\u0001\t\u0007I\u0011\u0002 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u001da\u0005A1A\u0005\u0002yBa!\u0014\u0001!\u0002\u0013y\u0004b\u0002(\u0001\u0005\u0004%\ta\u0014\u0005\u00071\u0002\u0001\u000b\u0011\u0002)\t\u000be\u0003A\u0011\u0001.\t\u0013\u001d\u0004\u0001\u0019!a\u0001\n\u0013A\u0007\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0011)\t9\u0001\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\u000b\u0003\u0013\u0001\u0001\u0019!a\u0001\n\u0013A\u0007bCA\u0006\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bA!\"!\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003j\u0011)\t\u0019\u0002\u0001a\u0001\u0002\u0004%I\u0001\u001b\u0005\f\u0003+\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0002\u0003\u0006\u0002\u001c\u0001\u0001\r\u0011!Q!\n%D!\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003i\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0015\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0011\u000eC\u0005\u0002(\u0001\u0011\r\u0011\"\u0003\u0002*!A\u0011q\u0007\u0001!\u0002\u0013\tY\u0003C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002*!A\u00111\b\u0001!\u0002\u0013\tY\u0003C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0007\u0001\u0011\u0005!q\u0002\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005O\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(B\u0001\u00180\u0003\r\t\u0007/\u001b\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\t1t&A\u0006j]R,wM]1uS>t\u0017B\u0001\u001d6\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001<!\ta\u0004!D\u0001.\u0003I\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u00131!\u00138u\u0003M\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3!\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\fac]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7\u000fI\u0001\u001ee\u0016\u0004H.[2b\r\u0016$8\r['bqB\u000b'\u000f^5uS>t')\u001f;fg\u0006q\"/\u001a9mS\u000e\fg)\u001a;dQ6\u000b\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000fI\u0001\u001de\u0016\u0004H.[2b\r\u0016$8\r['bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3t\u0003u\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D(+Z:q_:\u001cXMQ=uKN\u0004\u0013A\u00038v[N+'O^3sg\u0006Ya.^7TKJ4XM]:!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001)\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002X%\nQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003m\u00032\u0001X0b\u001b\u0005i&B\u00010B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Av\u00131aU3r!\t\u0011W-D\u0001d\u0015\t!w&\u0001\u0004tKJ4XM]\u0005\u0003M\u000e\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006I\u0001O]8ek\u000e,'/M\u000b\u0002SB!!\u000e\u001e<w\u001b\u0005Y'B\u00017n\u0003!\u0001(o\u001c3vG\u0016\u0014(B\u00018p\u0003\u001d\u0019G.[3oiNT!\u0001\r9\u000b\u0005E\u0014\u0018AB1qC\u000eDWMC\u0001t\u0003\ry'oZ\u0005\u0003k.\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bc\u0001!xs&\u0011\u00010\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0001jL!a_!\u0003\t\tKH/Z\u0001\u000eaJ|G-^2feFzF%Z9\u0015\u0007y\f\u0019\u0001\u0005\u0002A\u007f&\u0019\u0011\u0011A!\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u000b\u0001\u0012\u0011!a\u0001S\u0006\u0019\u0001\u0010J\u0019\u0002\u0015A\u0014x\u000eZ;dKJ\f\u0004%A\u0005qe>$WoY3se\u0005i\u0001O]8ek\u000e,'OM0%KF$2A`A\b\u0011!\t)aEA\u0001\u0002\u0004I\u0017A\u00039s_\u0012,8-\u001a:3A\u0005I\u0001O]8ek\u000e,'oM\u0001\u000eaJ|G-^2feNzF%Z9\u0015\u0007y\fI\u0002\u0003\u0005\u0002\u0006Y\t\t\u00111\u0001j\u0003)\u0001(o\u001c3vG\u0016\u00148\u0007I\u0001\naJ|G-^2feR\nQ\u0002\u001d:pIV\u001cWM\u001d\u001b`I\u0015\fHc\u0001@\u0002$!A\u0011QA\r\u0002\u0002\u0003\u0007\u0011.\u0001\u0006qe>$WoY3si\u0001\na\u0001^8qS\u000e\fTCAA\u0016!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019)\u0006!A.\u00198h\u0013\u0011\t)$a\f\u0003\rM#(/\u001b8h\u0003\u001d!x\u000e]5dc\u0001\na\u0001^8qS\u000e\u0014\u0014a\u0002;pa&\u001c'\u0007I\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004}\u0006\u0005\u0003bBA\"?\u0001\u0007\u0011QI\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qIA*\u001b\t\tIEC\u0002/\u0003\u0017RA!!\u0014\u0002P\u00059!.\u001e9ji\u0016\u0014(bAA)e\u0006)!.\u001e8ji&!\u0011QKA%\u0005!!Vm\u001d;J]\u001a|\u0007fA\u0010\u0002ZA!\u0011qIA.\u0013\u0011\ti&!\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005q\bf\u0001\u0011\u0002fA!\u0011qIA4\u0013\u0011\tI'!\u0013\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\b;fgR$vn\u001c'be\u001e,'+Z2pe\u0012<\u0016\u000e\u001e5BG.TVM]8\u0015\u0007y\fy\u0007C\u0004\u0002r\u0005\u0002\r!a\u001d\u0002\rE,xN];n!\u0011\t)(a!\u000f\t\u0005]\u0014q\u0010\t\u0004\u0003s\nUBAA>\u0015\r\ti(M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0005\u0015)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t)IC\u0002\u0002\u0002\u0006Cs!IAE\u0003+\u000b9\n\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)a\u0013\u0002\rA\f'/Y7t\u0013\u0011\t\u0019*!$\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAAM\u0003)ZH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b' \u0018he>,\b\u000f\u0015:pi>\u001cw\u000e\\\u001f|cuDs!IAO\u0003S\u000bY\u000b\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\u0011\t\u0019+!$\u0002\u0011A\u0014xN^5eKJLA!a*\u0002\"\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011QV\u0011\u0003\u0003_\u000b!fZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.\u0001\u000fuKN$Hk\\8MCJ<WMU3d_J$w+\u001b;i\u0003\u000e\\wJ\\3\u0015\u0007y\f)\fC\u0004\u0002r\t\u0002\r!a\u001d)\u000f\t\nI)!&\u0002\u0018\":!%!(\u0002*\u0006mFFAAW\u0003-\u001a\u0007.Z2l)>|G*\u0019:hKJ+7m\u001c:e\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGc\u0001@\u0002B\"1\u00111Y\u0012A\u0002}\nA\"\\1y\r\u0016$8\r[*ju\u0016\fQ\u0006^3tiB\u000b'\u000f^5uS>tGk\\8MCJ<WMR8s%\u0016\u0004H.[2bi&|gnV5uQ\u0006\u001b7.\u00117m)\rq\u0018\u0011\u001a\u0005\b\u0003c\"\u0003\u0019AA:Q\r!\u0013\u0011\u0012\u0015\bI\u0005=\u0017Q[Al!\u0011\ty*!5\n\t\u0005M\u0017\u0011\u0015\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005\u0005e\u0017EAAn\u0003\u0015Y'/\u00194u\u00031\"Xm\u001d;SKN\u0004xN\\:f)>|G*\u0019:hK\u001a{'OU3qY&\u001c\u0017\r^5p]^KG\u000f[!dW\u0006cG\u000eF\u0002\u007f\u0003CDq!!\u001d&\u0001\u0004\t\u0019\bK\u0002&\u0003\u0013Cs!JAh\u0003+\f9\u000f\f\u0002\u0002Z\u0006!B/Z:u\u001d>tW\t_5ti\u0016tG\u000fV8qS\u000e$2A`Aw\u0011\u001d\t\tH\na\u0001\u0003gBsAJAE\u0003+\u000b9\nK\u0004'\u0003;\u000bI+a=-\u0005\u00055\u0016a\u0005;fgR<&o\u001c8h\u0005J|7.\u001a:MSN$Hc\u0001@\u0002z\"9\u0011\u0011O\u0014A\u0002\u0005M\u0004fA\u0014\u0002\n\":q%a4\u0002V\u0006}HFAAm\u0003Q!Xm\u001d;J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]R\u0019aP!\u0002\t\u000f\u0005E\u0004\u00061\u0001\u0002t!\u001a\u0001&!#)\u000f!\ny-!6\u0003\f1\u0012\u0011\u0011\\\u0001\u0014i\u0016\u001cHoU3oI\u00063G/\u001a:DY>\u001cX\r\u001a\u000b\u0004}\nE\u0001bBA9S\u0001\u0007\u00111\u000f\u0015\u0004S\u0005%\u0005fB\u0015\u0002P\u0006U'q\u0003\u0017\u0003\u00033\fQ\u0004^3ti\u000e\u000bgN\\8u'\u0016tG\rV8J]R,'O\\1m)>\u0004\u0018n\u0019\u000b\u0004}\nu\u0001bBA9U\u0001\u0007\u00111\u000f\u0015\u0004U\u0005%\u0005f\u0002\u0016\u0002P\u0006U'1\u0005\u0017\u0003\u00033\f\u0001\u0006^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u00114uKJ\u0014%o\\6feNCW\u000f\u001e3po:$2A B\u0015\u0011\u001d\t\th\u000ba\u0001\u0003gB3aKAEQ\u001dY\u0013qZAk\u0005_a#!!7")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer1;
    private KafkaProducer<byte[], byte[]> producer2;
    private KafkaProducer<byte[], byte[]> producer3;
    private KafkaProducer<byte[], byte[]> producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    private KafkaProducer<byte[], byte[]> producer1() {
        return this.producer1;
    }

    private void producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer1 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer2() {
        return this.producer2;
    }

    private void producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer2 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer3() {
        return this.producer3;
    }

    private void producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer3 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer4() {
        return this.producer4;
    }

    private void producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        long x$6 = this.producerBufferSize();
        int x$7 = 30000;
        int x$8 = 0;
        int x$9 = 16384;
        String x$10 = "none";
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        this.producer1_$eq(TestUtils$.MODULE$.createProducer(x$1, 0, 10000L, x$6, 0, x$7, x$8, x$9, x$10, 30000, x$11, (Option<File>)x$12, (Option<Properties>)x$13, x$14, x$15, x$16));
        String x$17 = this.bootstrapServers(this.bootstrapServers$default$1());
        long x$22 = this.producerBufferSize();
        int x$23 = 30000;
        int x$24 = 0;
        int x$25 = 16384;
        String x$26 = "none";
        SecurityProtocol x$27 = SecurityProtocol.PLAINTEXT;
        None$ x$28 = None$.MODULE$;
        None$ x$29 = None$.MODULE$;
        ByteArraySerializer x$30 = new ByteArraySerializer();
        ByteArraySerializer x$31 = new ByteArraySerializer();
        boolean x$32 = false;
        this.producer2_$eq(TestUtils$.MODULE$.createProducer(x$17, 1, 10000L, x$22, 0, x$23, x$24, x$25, x$26, 30000, x$27, (Option<File>)x$28, (Option<Properties>)x$29, x$30, x$31, x$32));
        String x$33 = this.bootstrapServers(this.bootstrapServers$default$1());
        long x$38 = this.producerBufferSize();
        int x$39 = 30000;
        int x$40 = 0;
        int x$41 = 16384;
        String x$42 = "none";
        SecurityProtocol x$43 = SecurityProtocol.PLAINTEXT;
        None$ x$44 = None$.MODULE$;
        None$ x$45 = None$.MODULE$;
        ByteArraySerializer x$46 = new ByteArraySerializer();
        ByteArraySerializer x$47 = new ByteArraySerializer();
        boolean x$48 = false;
        this.producer3_$eq(TestUtils$.MODULE$.createProducer(x$33, -1, 10000L, x$38, 0, x$39, x$40, x$41, x$42, 30000, x$43, (Option<File>)x$44, (Option<Properties>)x$45, x$46, x$47, x$48));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer1() != null) {
            this.producer1().close();
        }
        if (this.producer2() != null) {
            this.producer2().close();
        }
        if (this.producer3() != null) {
            this.producer3().close();
        }
        if (this.producer4() != null) {
            this.producer4().close();
        }
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testTooLargeRecordWithAckZero(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer1().send(record).get();
        Assertions.assertNotNull((Object)recordMetadata);
        Assertions.assertFalse((boolean)recordMetadata.hasOffset());
        Assertions.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testTooLargeRecordWithAckOne(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assertions.assertThrows(ExecutionException.class, () -> this.producer2().send(record).get());
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", Integer.toString(this.numServers()));
        topicConfig.setProperty("max.message.bytes", Integer.toString(maxMessageSize));
        String topic10 = "topic10";
        this.createTopic(topic10, this.brokers().size(), this.numServers(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer3().send(record).get();
        Assertions.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testPartitionTooLargeForReplicationWithAckAll(String quorum) {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testResponseTooLargeForReplicationWithAckAll(String quorum) {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testNonExistentTopic(String quorum) {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(ExecutionException.class, () -> this.producer1().send(record).get());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testWrongBrokerList(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        this.producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(ExecutionException.class, () -> this.producer4().send(record).get());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testInvalidPartition(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer1().send(higherRecord).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testSendAfterClosed(String quorum) {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer1().send(record).get();
        this.producer2().send(record).get();
        this.producer3().send(record).get();
        this.producer1().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer1().send(record));
        this.producer2().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer2().send(record));
        this.producer3().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.producer3().send(record));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCannotSendToInternalTopic(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        ExecutionException thrown = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get());
        Assertions.assertTrue((boolean)(thrown.getCause() instanceof InvalidTopicException), (String)("Unexpected exception while sending to an invalid topic " + thrown.getCause()));
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testNotEnoughReplicasAfterBrokerShutdown(String quorum) {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", Integer.toString(this.numServers()));
        int x$2 = this.numServers();
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topicName, x$4, x$2, topicProps, x$5, x$6);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer3().send(record).get();
        ((KafkaBroker)this.brokers().head()).shutdown();
        ((KafkaBroker)this.brokers().head()).awaitShutdown();
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.producer3().send(record).get());
        Assertions.assertTrue((e.getCause() instanceof NotEnoughReplicasException || e.getCause() instanceof NotEnoughReplicasAfterAppendException || e.getCause() instanceof TimeoutException ? 1 : 0) != 0);
        ((KafkaBroker)this.brokers().head()).startup();
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put("auto.create.topics.enable", Boolean.toString(false));
        this.overridingProps().put("message.max.bytes", Integer.toString(this.serverMessageMaxBytes()));
        this.overridingProps().put("replica.fetch.max.bytes", Integer.toString(this.replicaFetchMaxPartitionBytes()));
        this.overridingProps().put("Maximum bytes expected for the entire fetch response. Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).", Integer.toString(this.replicaFetchMaxResponseBytes()));
        this.overridingProps().put("offsets.topic.num.partitions", Integer.toString(1));
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

