/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.server.config.ServerConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;

public final class PlaintextAdminIntegrationTest$ {
    public static final PlaintextAdminIntegrationTest$ MODULE$ = new PlaintextAdminIntegrationTest$();

    public void checkValidAlterConfigs(Admin admin, KafkaServerTestHarness test, ConfigResource topicResource1, ConfigResource topicResource2, String maxMessageBytes, String retentionMs) {
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> alterConfigs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        alterConfigs.put(topicResource1, Arrays.asList(new AlterConfigOp(new ConfigEntry("flush.ms", "1000"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(topicResource2, Arrays.asList(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("compression.type", "lz4"), AlterConfigOp.OpType.SET)));
        AlterConfigsResult alterResult = admin.incrementalAlterConfigs(alterConfigs);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        test.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource2, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)"1000", (Object)((Config)configs.get(topicResource1)).get("flush.ms").value());
        Assertions.assertEquals((Object)maxMessageBytes, (Object)((Config)configs.get(topicResource1)).get("max.message.bytes").value());
        Assertions.assertEquals((Object)retentionMs, (Object)((Config)configs.get(topicResource1)).get("retention.ms").value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)"lz4", (Object)((Config)configs.get(topicResource2)).get("compression.type").value());
        alterConfigs.put(topicResource1, Arrays.asList(new AlterConfigOp(new ConfigEntry("max.message.bytes", "10"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(topicResource2, Arrays.asList(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "0.3"), AlterConfigOp.OpType.SET)));
        alterResult = admin.incrementalAlterConfigs(alterConfigs, new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        test.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)Nil$.MODULE$))).asJava()).all().get();
        Assertions.assertEquals((int)2, (int)configs.size());
        Assertions.assertEquals((Object)maxMessageBytes, (Object)((Config)configs.get(topicResource1)).get("max.message.bytes").value());
        Assertions.assertEquals((Object)"0.9", (Object)((Config)configs.get(topicResource2)).get("min.cleanable.dirty.ratio").value());
    }

    public void checkInvalidAlterConfigs(KafkaServerTestHarness test, Admin admin) {
        String topic1 = "invalid-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic1, test.brokers(), test.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        String topic2 = "invalid-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        TestUtils$.MODULE$.createTopicWithAdmin(admin, topic2, test.brokers(), test.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaBroker)test.brokers().head()).config().brokerId()));
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> alterConfigs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        alterConfigs.put(topicResource1, Arrays.asList(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "1.1"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("compression.type", "lz4"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(topicResource2, Arrays.asList(new AlterConfigOp(new ConfigEntry("compression.type", "snappy"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(brokerResource, Arrays.asList(new AlterConfigOp(new ConfigEntry("advertised.listeners", "EXTERNAL://localhost:0,INTERNAL://localhost:0"), AlterConfigOp.OpType.SET)));
        AlterConfigsResult alterResult = admin.incrementalAlterConfigs(alterConfigs);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils.assertFutureThrows((Future)((Future)alterResult.values().get(topicResource1)), InvalidConfigurationException.class);
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils.assertFutureThrows((Future)((Future)alterResult.values().get(brokerResource)), InvalidRequestException.class);
        test.ensureConsistentKRaftMetadata();
        java.util.Map configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)LogConfig.DEFAULT_COMPRESSION_TYPE, (Object)((Config)configs.get(topicResource1)).get("compression.type").value());
        Assertions.assertEquals((Object)"snappy", (Object)((Config)configs.get(topicResource2)).get("compression.type").value());
        Assertions.assertEquals((Object)LogConfig.DEFAULT_COMPRESSION_TYPE, (Object)((Config)configs.get(brokerResource)).get(ServerConfigs.COMPRESSION_TYPE_CONFIG).value());
        alterConfigs.put(topicResource1, Arrays.asList(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", "1.1"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("compression.type", "lz4"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(topicResource2, Arrays.asList(new AlterConfigOp(new ConfigEntry("compression.type", "gzip"), AlterConfigOp.OpType.SET)));
        alterConfigs.put(brokerResource, Arrays.asList(new AlterConfigOp(new ConfigEntry("advertised.listeners", "EXTERNAL://localhost:0,INTERNAL://localhost:0"), AlterConfigOp.OpType.SET)));
        alterResult = admin.incrementalAlterConfigs(alterConfigs, new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource}))).asJava(), alterResult.values().keySet());
        TestUtils.assertFutureThrows((Future)((Future)alterResult.values().get(topicResource1)), InvalidConfigurationException.class);
        ((KafkaFuture)alterResult.values().get(topicResource2)).get();
        TestUtils.assertFutureThrows((Future)((Future)alterResult.values().get(brokerResource)), InvalidRequestException.class);
        test.ensureConsistentKRaftMetadata();
        configs = (java.util.Map)admin.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$)))).asJava()).all().get();
        Assertions.assertEquals((int)3, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(0.5), (Object)((Config)configs.get(topicResource1)).get("min.cleanable.dirty.ratio").value());
        Assertions.assertEquals((Object)LogConfig.DEFAULT_COMPRESSION_TYPE, (Object)((Config)configs.get(topicResource1)).get("compression.type").value());
        Assertions.assertEquals((Object)"snappy", (Object)((Config)configs.get(topicResource2)).get("compression.type").value());
        Assertions.assertEquals((Object)LogConfig.DEFAULT_COMPRESSION_TYPE, (Object)((Config)configs.get(brokerResource)).get(ServerConfigs.COMPRESSION_TYPE_CONFIG).value());
    }

    private PlaintextAdminIntegrationTest$() {
    }
}

