/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import kafka.api.ConsumerTopicCreationTest$;
import kafka.api.IntegrationTestHarness;
import kafka.utils.EmptyTestInfo;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\u0002!:Q\u0001Y\f\t\u0002\u00054QAF\f\t\u0002\tDQa\t\u0003\u0005\u0002\r4A\u0001\u001a\u0003\u0005K\"AQF\u0002B\u0001B\u0003%a\u0006\u0003\u0005;\r\t\u0005\t\u0015!\u0003<\u0011!!eA!A!\u0002\u0013Y\u0004\"B\u0012\u0007\t\u0003I\u0007bB8\u0007\u0005\u0004%I\u0001\u001d\u0005\u0007g\u001a\u0001\u000b\u0011B9\t\u000fQ4!\u0019!C\u0005a\"1QO\u0002Q\u0001\nEDqA\u001e\u0004C\u0002\u0013%\u0001\u000f\u0003\u0004x\r\u0001\u0006I!\u001d\u0005\bq\u001a\u0011\r\u0011\"\u0003q\u0011\u0019Ih\u0001)A\u0005c\")!P\u0002C)w\"1qP\u0002C\u0001\u0003\u0003Aaa\u0018\u0003\u0005\u0002\u0005\r!!G\"p]N,X.\u001a:U_BL7m\u0011:fCRLwN\u001c+fgRT!\u0001G\r\u0002\u0007\u0005\u0004\u0018NC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\tq#A\u000buKN$\u0018)\u001e;p)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8\u0015\t%b\u0013h\u0011\t\u0003=)J!aK\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006[\t\u0001\rAL\u0001\u000eOJ|W\u000f\u001d)s_R|7m\u001c7\u0011\u0005=2dB\u0001\u00195!\t\tt$D\u00013\u0015\t\u00194$\u0001\u0004=e>|GOP\u0005\u0003k}\ta\u0001\u0015:fI\u00164\u0017BA\u001c9\u0005\u0019\u0019FO]5oO*\u0011Qg\b\u0005\u0006u\t\u0001\raO\u0001\u001eEJ|7.\u001a:BkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:,e.\u00192mKB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\t\n\u0001\raO\u0001\u001eG>t7/^7fe\u0006cGn\\<BkR|7I]3bi\u0016$v\u000e]5dg\"\"!A\u0012*T!\t9\u0005+D\u0001I\u0015\tI%*\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u00172\u000bqA[;qSR,'O\u0003\u0002N\u001d\u0006)!.\u001e8ji*\tq*A\u0002pe\u001eL!!\u0015%\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001+\u0002Gn$\u0017n\u001d9mCft\u0015-\\3~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\u0004TP\f2s_.,'/Q;u_R{\u0007/[2De\u0016\fG/[8o\u000b:\f'\r\\3>wFjhfY8ogVlWM]!mY><\u0018)\u001e;p\u0007J,\u0017\r^3U_BL7m]\u001f|euDCA\u0001,];B\u0011qKW\u0007\u00021*\u0011\u0011\fS\u0001\taJ|g/\u001b3fe&\u00111\f\u0017\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0002=\u0006\nq,\u0001\u0006qCJ\fW.\u001a;feN\f\u0011dQ8ogVlWM\u001d+pa&\u001c7I]3bi&|g\u000eV3tiB\u0011a\u0005B\n\u0003\tu!\u0012!\u0019\u0002\t)\u0016\u001cHoQ1tKN\u0011aA\u001a\t\u0003M\u001dL!\u0001[\f\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN$BA\u001b7n]B\u00111NB\u0007\u0002\t!)QF\u0003a\u0001]!)!H\u0003a\u0001w!)AI\u0003a\u0001w\u00059Ao\u001c9jG~\u000bT#A9\u0011\u0005q\u0012\u0018BA\u001c>\u0003!!x\u000e]5d?F\u0002\u0013a\u0002;pa&\u001cwLM\u0001\ti>\u0004\u0018nY03A\u0005\u0001\u0002O]8ek\u000e,'o\u00117jK:$\u0018\nZ\u0001\u0012aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003E\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\rI\u0001\fEJ|7.\u001a:D_VtG/F\u0001}!\tqR0\u0003\u0002\u007f?\t\u0019\u0011J\u001c;\u0002\tQ,7\u000f\u001e\u000b\u0002SU\u0011\u0011Q\u0001\t\u0007\u0003\u000f\t\t\"!\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\taa\u001d;sK\u0006l'bAA\b\u007f\u0005!Q\u000f^5m\u0013\u0011\t\u0019\"!\u0003\u0003\rM#(/Z1n!\r9\u0016qC\u0005\u0004\u00033A&!C!sOVlWM\u001c;t\u0001")
public class ConsumerTopicCreationTest {
    public static Stream<Arguments> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}.brokerAutoTopicCreationEnable={1}.consumerAllowAutoCreateTopics={2}")
    @MethodSource(value={"parameters"})
    public void testAutoTopicCreation(String groupProtocol, Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        TestCase testCase = new TestCase(groupProtocol, brokerAutoTopicCreationEnable, consumerAllowAutoCreateTopics);
        testCase.setUp(new EmptyTestInfo(null){

            public String getDisplayName() {
                return "quorum=kraft";
            }
        });
        try {
            testCase.test();
        }
        finally {
            testCase.tearDown();
        }
    }

    private static class TestCase
    extends IntegrationTestHarness {
        private final Boolean brokerAutoTopicCreationEnable;
        private final Boolean consumerAllowAutoCreateTopics;
        private final String topic_1;
        private final String topic_2;
        private final String producerClientId;
        private final String consumerClientId;

        private String topic_1() {
            return this.topic_1;
        }

        private String topic_2() {
            return this.topic_2;
        }

        private String producerClientId() {
            return this.producerClientId;
        }

        private String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public int brokerCount() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        public void test() {
            Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            Admin adminClient = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, (short)1))).all().get();
            producer.send(record).get();
            consumer.subscribe(Arrays.asList(this.topic_1(), this.topic_2()));
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestCase.$anonfun$test$1(consumer)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting to consume");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            boolean topicCreated = this.getTopicIds().keySet().contains((Object)this.topic_2());
            if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
                Assertions.assertTrue((boolean)topicCreated);
                return;
            }
            Assertions.assertFalse((boolean)topicCreated);
        }

        public static final /* synthetic */ boolean $anonfun$test$1(Consumer consumer$1) {
            return consumer$1.poll(Duration.ofMillis(100L)).count() > 0;
        }

        public static final /* synthetic */ String $anonfun$test$2() {
            return "Timed out waiting to consume";
        }

        public TestCase(String groupProtocol, Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
            this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
            this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
            this.topic_1 = "topic-1";
            this.topic_2 = "topic-2";
            this.producerClientId = "ConsumerTestProducer";
            this.consumerClientId = "ConsumerTestConsumer";
            this.serverConfig().setProperty("controlled.shutdown.enable", "false");
            this.serverConfig().setProperty("auto.create.topics.enable", brokerAutoTopicCreationEnable.toString());
            this.producerConfig().setProperty("client.id", this.producerClientId());
            this.consumerConfig().setProperty("client.id", this.consumerClientId());
            this.consumerConfig().setProperty("group.id", "my-test");
            this.consumerConfig().setProperty("auto.offset.reset", "earliest");
            this.consumerConfig().setProperty("enable.auto.commit", "false");
            this.consumerConfig().setProperty("metadata.max.age.ms", "100");
            this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
            this.consumerConfig().setProperty("group.protocol", groupProtocol);
        }
    }
}

