/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005]g!B\f\u0019\u0003\u0003i\u0002\"\u0002\u0015\u0001\t\u0003I\u0003\"B\u0016\u0001\t\u0003a\u0003\"B\u001a\u0001\t\u0003b\u0003\"\u0003\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00016\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!\tC\u0005I\u0001\u0001\u0007\t\u0011)Q\u0005m!I\u0011\n\u0001a\u0001\u0002\u0004%\tA\u0013\u0005\n-\u0002\u0001\r\u00111A\u0005\u0002]C\u0011\"\u0017\u0001A\u0002\u0003\u0005\u000b\u0015B&\t\u000bi\u0003A\u0011I.\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u001d\u0004A\u0011\u00015\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBa!a\u001e\u0001\t\u0003Q\u0005bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011%\ti\u000bAI\u0001\n\u0003\ty\u000bC\u0005\u0002F\u0002\t\n\u0011\"\u0001\u0002H\nA\")Y:f\u0003\u0012l\u0017N\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005eQ\u0012aA1qS*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001q\"\u0005\u0005\u0002 A5\t\u0001$\u0003\u0002\"1\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002$M5\tAE\u0003\u0002&5\u0005)Q\u000f^5mg&\u0011q\u0005\n\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002 \u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#aA%oi\u0006YAn\\4ESJ\u001cu.\u001e8u\u0003!!Xm\u001d;J]\u001a|W#\u0001\u001c\u0011\u0005]zT\"\u0001\u001d\u000b\u0005eI$B\u0001\u001e<\u0003\u001dQW\u000f]5uKJT!\u0001P\u001f\u0002\u000b),h.\u001b;\u000b\u0003y\n1a\u001c:h\u0013\t\u0001\u0005H\u0001\u0005UKN$\u0018J\u001c4p\u00031!Xm\u001d;J]\u001a|w\fJ3r)\t\u0019e\t\u0005\u0002/\t&\u0011Qi\f\u0002\u0005+:LG\u000fC\u0004H\u000b\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013'A\u0005uKN$\u0018J\u001c4pA\u000511\r\\5f]R,\u0012a\u0013\t\u0003\u0019Rk\u0011!\u0014\u0006\u0003\u001d>\u000bQ!\u00193nS:T!\u0001U)\u0002\u000f\rd\u0017.\u001a8ug*\u00111D\u0015\u0006\u0003'v\na!\u00199bG\",\u0017BA+N\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0007bCqa\u0012\u0005\u0002\u0002\u0003\u00071*A\u0004dY&,g\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0005\rc\u0006\"\u0002\u001b\u000b\u0001\u00041\u0004F\u0001\u0006_!\t9t,\u0003\u0002aq\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012a\u0011\u0015\u0003\u0017\u0011\u0004\"aN3\n\u0005\u0019D$!C!gi\u0016\u0014X)Y2i\u0003Y!Xm\u001d;De\u0016\fG/\u001a#fY\u0016$X\rV8qS\u000e\u001cHCA\"j\u0011\u0015QG\u00021\u0001l\u0003\u0019\tXo\u001c:v[B\u0011An\u001d\b\u0003[F\u0004\"A\\\u0018\u000e\u0003=T!\u0001\u001d\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011x&\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:0Q\taq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{s\u00051\u0001/\u0019:b[NL!\u0001`=\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0004\r}\u0006%\u00111\u0002\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019!_\u0001\taJ|g/\u001b3fe&!\u0011qAA\u0001\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011QB\u0011\u0003\u0003\u001f\tQa\u001b:bMR\f\u0001\u0004^3ti\u0006+H\u000f[8sSj,Gm\u00149fe\u0006$\u0018n\u001c8t)\r\u0019\u0015Q\u0003\u0005\u0006U6\u0001\ra\u001b\u0015\u0003\u001b]Dc!\u0004@\u0002\n\u0005mAFAA\u0007\u0003q\u0019wN\u001c4jOV\u0014X\rZ\"mkN$XM\u001d)fe6L7o]5p]N,\"!!\t\u0011\u000b1\f\u0019#a\n\n\u0007\u0005\u0015ROA\u0002TKR\u0004B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0002bG2T1!!\rR\u0003\u0019\u0019w.\\7p]&!\u0011QGA\u0016\u00051\t5\r\\(qKJ\fG/[8o\u00035iw\u000eZ5gs\u000e{gNZ5hgR\u00191)a\u000f\t\u000f\u0005ur\u00021\u0001\u0002@\u000591m\u001c8gS\u001e\u001c\bCBA!\u0003\u000f\nY%\u0004\u0002\u0002D)\u0019\u0011QI\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0005\r#aA*fcB!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001B;uS2T!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyE\u0001\u0006Qe>\u0004XM\u001d;jKN\fac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0005\u0003\u007f\ty\u0006C\u00035!\u0001\u0007a'\u0001\u0007de\u0016\fG/Z\"p]\u001aLw-\u0006\u0002\u0002fA9\u0011QJA4W\u0006-\u0014\u0002BA5\u0003\u001f\u00121!T1q!\u0011\ti'a\u001d\u000e\u0005\u0005=$\u0002BA9\u0003'\nA\u0001\\1oO&!\u0011QOA8\u0005\u0019y%M[3di\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0002\u001b]\f\u0017\u000e\u001e$peR{\u0007/[2t)\u001d\u0019\u0015QPA@\u0003\u000bCQ!S\nA\u0002-Cq!!!\u0014\u0001\u0004\t\u0019)A\bfqB,7\r^3e!J,7/\u001a8u!\u0015\t\t%a\u0012l\u0011\u001d\t9i\u0005a\u0001\u0003\u0007\u000bq\"\u001a=qK\u000e$X\rZ'jgNLgnZ\u0001\u0011O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$\"\"!$\u0002\u0014\u0006U\u0015\u0011TAR!\ra\u0015qR\u0005\u0004\u0003#k%\u0001\u0005+pa&\u001cG)Z:de&\u0004H/[8o\u0011\u0015IE\u00031\u0001L\u0011\u0019\t9\n\u0006a\u0001W\u0006)Ao\u001c9jG\"I\u00111\u0014\u000b\u0011\u0002\u0003\u0007\u0011QT\u0001\u0010I\u0016\u001c8M]5cK>\u0003H/[8ogB\u0019A*a(\n\u0007\u0005\u0005VJA\u000bEKN\u001c'/\u001b2f)>\u0004\u0018nY:PaRLwN\\:\t\u0013\u0005\u0015F\u0003%AA\u0002\u0005\u001d\u0016\u0001G3ya\u0016\u001cG/\u001a3Ok6\u0004\u0016M\u001d;ji&|gn](qiB!a&!+.\u0013\r\tYk\f\u0002\u0007\u001fB$\u0018n\u001c8\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E&\u0006BAO\u0003g[#!!.\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f{\u0013AC1o]>$\u0018\r^5p]&!\u00111YA]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0013TC!a*\u00024\":\u0001!!4\u0002T\u0006U\u0007cA\u001c\u0002P&\u0019\u0011\u0011\u001b\u001d\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\t\u0001\u0010")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private TestInfo testInfo;
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public TestInfo testInfo() {
        return this.testInfo;
    }

    public void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), 15000L);
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateDeleteTopics(String quorum) {
        this.client_$eq(this.createAdminClient());
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.empty())), OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        scala.collection.immutable.Map<String, Uuid> topicIds = this.getTopicIds();
        topics.foreach((Function1 & Serializable)topic -> {
            BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$1(createResult, topicIds, topic);
            return BoxedUnit.UNIT;
        });
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assertions.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils.assertFutureThrows((Future)((Future)results.get("mytopic")), TopicExistsException.class);
        Assertions.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils.assertFutureThrows((Future)((Future)results.get("mytopic2")), TopicExistsException.class);
        Assertions.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils.assertFutureThrows((Future)((Future)results.get("mytopic3")), TopicExistsException.class);
        TestUtils.assertFutureThrows((Future)failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class);
        TestUtils.assertFutureThrows((Future)failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class);
        TestUtils.assertFutureThrows((Future)failedCreateResult.config("mytopic3"), TopicExistsException.class);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava()).allTopicNames().get();
        Assertions.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assertions.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assertions.assertEquals((int)2, (int)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assertions.assertEquals((int)1, (int)topic0Partition0.leader().id());
        Assertions.assertEquals((int)0, (int)topic0Partition0.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(topic0Partition0.isr()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id())));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(topic0Partition0.replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assertions.assertEquals((int)2, (int)topic0Partition1.leader().id());
        Assertions.assertEquals((int)1, (int)topic0Partition1.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(topic0Partition1.isr()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(topic0Partition1.replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assertions.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assertions.assertEquals((int)3, (int)topic1.partitions().size());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assertions.assertEquals((int)partitionId, (int)partition.partition());
            Assertions.assertEquals((int)3, (int)partition.replicas().size());
            partition.replicas().forEach(replica -> {
                Assertions.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((replica.id() < this.brokerCount() ? 1 : 0) != 0);
            });
            Assertions.assertEquals((int)partition.replicas().size(), (int)((SeqOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()))).distinct()).size(), (String)"No duplicate replica ids");
            Assertions.assertEquals((int)3, (int)partition.isr().size());
            Assertions.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assertions.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assertions.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (int)topic3.partitions().size());
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (int)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testAuthorizedOperations(String quorum) {
        this.client_$eq(this.createAdminClient());
        DescribeClusterResult result = this.client().describeCluster();
        Assertions.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava(this.configuredClusterPermissions()).asJava(), (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assertions.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        Assertions.assertEquals((Object)AclEntry.supportedOperations((ResourceType)ResourceType.TOPIC), (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return CollectionConverters$.MODULE$.SetHasAsScala(AclEntry.supportedOperations((ResourceType)ResourceType.CLUSTER)).asScala().toSet();
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        if (this.testInfo().getTestMethod().toString().contains("testCreateTopicsReturnsConfigs")) {
            configs.foreach((Function1 & Serializable)config -> {
                config.setProperty("log.roll.hours", "2");
                config.setProperty("log.retention.minutes", "240");
                return config.setProperty(ServerLogConfigs.LOG_ROLL_TIME_JITTER_MILLIS_CONFIG, "123");
            });
        }
        configs.foreach((Function1 & Serializable)config -> {
            config.setProperty("delete.topic.enable", "true");
            config.setProperty("group.initial.rebalance.delay.ms", "0");
            config.setProperty("auto.leader.rebalance.enable", "false");
            config.setProperty("controlled.shutdown.enable", "false");
            if (!config.containsKey("ssl.truststore.password")) {
                return config.setProperty("ssl.truststore.password", "some.invalid.pass");
            }
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties controllerConfig = new Properties();
        .colon.colon controllerConfigs = new .colon.colon((Object)controllerConfig, (List)Nil$.MODULE$);
        this.modifyConfigs((Seq<Properties>)controllerConfigs);
        return controllerConfigs;
    }

    public java.util.Map<String, Object> createConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.put("request.timeout.ms", "20000");
        config.put("default.api.timeout.ms", "40000");
        return config;
    }

    public Admin createAdminClient() {
        Properties props = new Properties();
        props.putAll(this.createConfig());
        ListenerName x$2 = this.createAdminClient$default$1();
        return this.createAdminClient(x$2, props);
    }

    /*
     * WARNING - void declaration
     */
    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$waitForTopics$1(client, expectedPresent, expectedMissing)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for topics");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        ObjectRef result = ObjectRef.create(null);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            KafkaFuture $anonfun$getTopicMetadata$1_topicResult = (KafkaFuture)client.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava(), describeOptions).topicNameValues().get(topic);
            try {
                result.elem = (TopicDescription)$anonfun$getTopicMetadata$1_topicResult.get();
                bl = BoxesRunTime.unboxToBoolean((Object)expectedNumPartitionsOpt.map((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 == ((TopicDescription)result$1.elem).partitions().size()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                    bl = false;
                }
                throw throwable;
            }
            Object var12_9 = null;
            Object var13_10 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$getTopicMetadata$4(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (TopicDescription)result.elem;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assertions.assertEquals((int)2, (Integer)((Integer)result.numPartitions("mytopic").get()));
        Assertions.assertEquals((int)2, (Integer)((Integer)result.replicationFactor("mytopic").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.numPartitions("mytopic2").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.replicationFactor("mytopic2").get()));
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (Integer)((Integer)result.numPartitions("mytopic3").get()));
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (Integer)((Integer)result.replicationFactor("mytopic3").get()));
        Assertions.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$1(CreateTopicsResult createResult$1, scala.collection.immutable.Map topicIds$1, String topic) {
        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)createResult$1.topicId(topic).get());
        Assertions.assertEquals((Object)topicIds$1.apply((Object)topic), (Object)createResult$1.topicId(topic).get());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$1(Admin client$1, Seq expectedPresent$1, Seq expectedMissing$1) {
        java.util.Set topics = (java.util.Set)client$1.listTopics().names().get();
        return expectedPresent$1.forall((Function1 & Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing$1.forall((Function1 & Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
    }

    public static final /* synthetic */ String $anonfun$waitForTopics$4() {
        return "timed out waiting for topics";
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$1(Admin client$2, String topic$1, DescribeTopicsOptions describeOptions$1, ObjectRef result$1, Option expectedNumPartitionsOpt$1) {
        KafkaFuture topicResult = (KafkaFuture)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava(), describeOptions$1).topicNameValues().get(topic$1);
        try {
            result$1.elem = (TopicDescription)topicResult.get();
            return BoxesRunTime.unboxToBoolean((Object)expectedNumPartitionsOpt$1.map((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 == ((TopicDescription)result$1.elem).partitions().size()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$getTopicMetadata$4(String topic$1) {
        return "Timed out waiting for metadata for " + topic$1;
    }
}

