/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommandIntegrationTest;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.NoRetryException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

public class UserScramCredentialsCommandTest {
    private static final String USER1 = "user1";
    private static final String USER2 = "user2";
    private final ClusterInstance cluster;

    public UserScramCredentialsCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigCommandResult runConfigCommandViaBroker(String ... args) {
        AtomicReference<OptionalInt> exitStatus = new AtomicReference<OptionalInt>(OptionalInt.empty());
        Exit.setExitProcedure((status, __) -> {
            exitStatus.set(OptionalInt.of(status));
            throw new RuntimeException();
        });
        ArrayList<String> commandArgs = new ArrayList<String>(Arrays.asList("--bootstrap-server", this.cluster.bootstrapServers()));
        commandArgs.addAll(Arrays.asList(args));
        try {
            String output = ConfigCommandIntegrationTest.captureStandardStream(false, () -> ConfigCommand.main((String[])commandArgs.toArray(new String[0])));
            ConfigCommandResult configCommandResult = new ConfigCommandResult(output);
            return configCommandResult;
        }
        catch (Exception e) {
            ConfigCommandResult configCommandResult = new ConfigCommandResult("", exitStatus.get());
            return configCommandResult;
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @ClusterTest
    public void testUserScramCredentialsRequests() throws Exception {
        this.createAndAlterUser(USER1);
        this.createAndAlterUser(USER2);
        String quotaPossibilityAOut = UserScramCredentialsCommandTest.quotaMessage(USER1) + "\n" + UserScramCredentialsCommandTest.quotaMessage(USER2);
        String quotaPossibilityBOut = UserScramCredentialsCommandTest.quotaMessage(USER2) + "\n" + UserScramCredentialsCommandTest.quotaMessage(USER1);
        String scramPossibilityAOut = UserScramCredentialsCommandTest.describeUserMessage(USER1) + "\n" + UserScramCredentialsCommandTest.describeUserMessage(USER2);
        String scramPossibilityBOut = UserScramCredentialsCommandTest.describeUserMessage(USER2) + "\n" + UserScramCredentialsCommandTest.describeUserMessage(USER1);
        this.describeUsers(quotaPossibilityAOut + "\n" + scramPossibilityAOut, quotaPossibilityAOut + "\n" + scramPossibilityBOut, quotaPossibilityBOut + "\n" + scramPossibilityAOut, quotaPossibilityBOut + "\n" + scramPossibilityBOut);
        this.deleteConfig(USER1, "consumer_byte_rate");
        this.deleteConfig(USER2, "SCRAM-SHA-256");
        this.describeUsers(UserScramCredentialsCommandTest.quotaMessage(USER2) + "\n" + UserScramCredentialsCommandTest.describeUserMessage(USER1));
        this.deleteConfig(USER1, "SCRAM-SHA-256");
        this.deleteConfig(USER2, "consumer_byte_rate");
        this.describeUsers("");
    }

    @ClusterTest
    public void testAlterWithEmptyPassword() {
        String user1 = USER1;
        ConfigCommandResult result = this.runConfigCommandViaBroker("--user", user1, "--alter", "--add-config", "SCRAM-SHA-256=[iterations=4096,password=]");
        Assertions.assertTrue((boolean)result.exitStatus.isPresent(), (String)"Expected System.exit() to be called with an empty password");
        Assertions.assertEquals((int)1, (int)result.exitStatus.getAsInt(), (String)"Expected empty password to cause failure with exit status=1");
    }

    @ClusterTest
    public void testDescribeUnknownUser() {
        String unknownUser = "unknownUser";
        ConfigCommandResult result = this.runConfigCommandViaBroker("--user", unknownUser, "--describe");
        Assertions.assertFalse((boolean)result.exitStatus.isPresent(), (String)"Expected System.exit() to not be called with an unknown user");
        Assertions.assertEquals((Object)"", (Object)result.stdout);
    }

    private void createAndAlterUser(String user) throws InterruptedException {
        ConfigCommandResult result = this.runConfigCommandViaBroker("--user", user, "--alter", "--add-config", "SCRAM-SHA-256=[iterations=4096,password=foo-secret]");
        Assertions.assertEquals((Object)UserScramCredentialsCommandTest.updateUserMessage(user), (Object)result.stdout);
        TestUtils.waitForCondition(() -> {
            try {
                return Objects.equals(this.runConfigCommandViaBroker((String[])new String[]{"--user", user, "--describe"}).stdout, UserScramCredentialsCommandTest.describeUserMessage(user));
            }
            catch (Exception e) {
                throw new NoRetryException((Throwable)e);
            }
        }, () -> "Failed to describe SCRAM credential change '" + user + "'");
        result = this.runConfigCommandViaBroker("--user", user, "--alter", "--add-config", "consumer_byte_rate=20000");
        Assertions.assertEquals((Object)UserScramCredentialsCommandTest.updateUserMessage(user), (Object)result.stdout);
        TestUtils.waitForCondition(() -> {
            try {
                return Objects.equals(this.runConfigCommandViaBroker((String[])new String[]{"--user", user, "--describe"}).stdout, UserScramCredentialsCommandTest.quotaMessage(user) + "\n" + UserScramCredentialsCommandTest.describeUserMessage(user));
            }
            catch (Exception e) {
                throw new NoRetryException((Throwable)e);
            }
        }, () -> "Failed to describe Quota change for '" + user + "'");
    }

    private void deleteConfig(String user, String config) {
        ConfigCommandResult result = this.runConfigCommandViaBroker("--user", user, "--alter", "--delete-config", config);
        Assertions.assertEquals((Object)UserScramCredentialsCommandTest.updateUserMessage(user), (Object)result.stdout);
    }

    private void describeUsers(String ... msgs) throws InterruptedException {
        TestUtils.waitForCondition(() -> {
            try {
                String output = this.runConfigCommandViaBroker((String[])new String[]{"--entity-type", "users", "--describe"}).stdout;
                return Arrays.asList(msgs).contains(output);
            }
            catch (Exception e) {
                throw new NoRetryException((Throwable)e);
            }
        }, () -> "Failed to describe config");
    }

    private static String describeUserMessage(String user) {
        return "SCRAM credential configs for user-principal '" + user + "' are SCRAM-SHA-256=iterations=4096";
    }

    private static String updateUserMessage(String user) {
        return "Completed updating config for user " + user + ".";
    }

    private static String quotaMessage(String user) {
        return "Quota configs for user-principal '" + user + "' are consumer_byte_rate=20000.0";
    }

    static class ConfigCommandResult {
        public final String stdout;
        public final OptionalInt exitStatus;

        public ConfigCommandResult(String stdout) {
            this(stdout, OptionalInt.empty());
        }

        public ConfigCommandResult(String stdout, OptionalInt exitStatus) {
            this.stdout = stdout;
            this.exitStatus = exitStatus;
        }
    }
}

