/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tMb\u0001\u0002\u0013&\u0001)BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u00037\u0011\u0019\t\u0005\u0001)A\u0005o!I!\t\u0001a\u0001\u0002\u0004%Ia\u0011\u0005\n!\u0002\u0001\r\u00111A\u0005\nEC\u0011B\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002#\t\u000fm\u0003!\u0019!C\u00059\"1Q\r\u0001Q\u0001\nuCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004o\u0001\u0001\u0006I\u0001\u001b\u0005\u0006_\u0002!\t\u0005\u001d\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!!*\u0001\t\u0013\t\u0019\u0002C\u0004\u0002(\u0002!I!!+\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"I\u0011\u0011\u001a\u0001\u0012\u0002\u0013%\u00111\u001a\u0005\n\u0003C\u0004\u0011\u0013!C\u0005\u0003GDq!a:\u0001\t\u0013\tI\u000fC\u0004\u0003\b\u0001!IA!\u0003\t\u0013\tE\u0001!%A\u0005\n\u0005-\u0007\"\u0003B\n\u0001E\u0005I\u0011BAf\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/A\u0011B!\b\u0001#\u0003%I!a3\t\u0013\t}\u0001!%A\u0005\n\u0005-\u0007b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0002\u001b\u0019&\u001cHo\u00144gg\u0016$8/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003M\u001d\nQ!\u00193nS:T\u0011\u0001K\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0006\u0005\u0002-_5\tQF\u0003\u0002/O\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\t\u0001TF\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\tQ%A\u0005u_BL7MT1nKV\tq\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!A.\u00198h\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001d\u0003\rM#(/\u001b8h\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\u001bi>\u0004\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5DkN$x.\\\"p]\u001aLwm]\u0001\u001ci>\u0004\u0018n\u0019(b[\u0016<\u0016\u000e\u001e5DkN$x.\\\"p]\u001aLwm\u001d\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0002\tB\u0011QIT\u0007\u0002\r*\u0011ae\u0012\u0006\u0003\u0011&\u000bqa\u00197jK:$8O\u0003\u0002)\u0015*\u00111\nT\u0001\u0007CB\f7\r[3\u000b\u00035\u000b1a\u001c:h\u0013\tyeIA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\t\u0011\u0006\f\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0003V]&$\bbB-\b\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0014\u0001D1e[&t7\t\\5f]R\u0004\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\tL\u0015AB2p[6|g.\u0003\u0002e?\n!A+[7f\u0003%iwnY6US6,\u0007%\u0001\u0006eCR\fgi\u001c7eKJ,\u0012\u0001\u001b\t\u0004S2<T\"\u00016\u000b\u0005-$\u0016AC2pY2,7\r^5p]&\u0011QN\u001b\u0002\u0004'\u0016\f\u0018a\u00033bi\u00064u\u000e\u001c3fe\u0002\nQa]3u+B$\"AU9\t\u000bIl\u0001\u0019A:\u0002\u0011Q,7\u000f^%oM>\u0004\"\u0001^>\u000e\u0003UT!A^<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ys\u00069!.\u001e9ji\u0016\u0014(B\u0001>M\u0003\u0015QWO\\5u\u0013\taXO\u0001\u0005UKN$\u0018J\u001c4pQ\tia\u0010\u0005\u0002u\u007f&\u0019\u0011\u0011A;\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0006ce>\\WM\u001d+j[\u0016$2!XA\u0004\u0011\u001d\tIA\u0004a\u0001\u0003\u0017\t\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0004'\u00065\u0011bAA\b)\n\u0019\u0011J\u001c;\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\u0015\u0015\u0004\u001f\u0005]\u0001c\u0001;\u0002\u001a%\u0019\u00111D;\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\t;fgRd\u0015n\u001d;NCb$\u0016.\\3ti\u0006l\u0007oV5uQ\u0016k\u0007\u000f^=M_\u001e$2AUA\u0011\u0011\u001d\t\u0019\u0003\u0005a\u0001\u0003K\ta!];peVl\u0007\u0003BA\u0014\u0003kqA!!\u000b\u00022A\u0019\u00111\u0006+\u000e\u0005\u00055\"bAA\u0018S\u00051AH]8pizJ1!a\rU\u0003\u0019\u0001&/\u001a3fM&\u0019a(a\u000e\u000b\u0007\u0005MB\u000bK\u0002\u0011\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003:\u0018A\u00029be\u0006l7/\u0003\u0003\u0002F\u0005}\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":\u0001#!\u0013\u0002V\u0005]\u0003\u0003BA&\u0003#j!!!\u0014\u000b\t\u0005=\u0013qH\u0001\taJ|g/\u001b3fe&!\u00111KA'\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011\u0011L\u0011\u0003\u00037\nQa\u001b:bMR\fA\u0005^3tiRC'/Z3D_6\u0004(/Z:tK\u0012\u0014VmY8sINLen\u00148f\u0005\u0006$8\r\u001b\u000b\u0004%\u0006\u0005\u0004bBA\u0012#\u0001\u0007\u0011Q\u0005\u0015\u0004#\u0005m\u0002fB\t\u0002J\u0005U\u0013q\r\u0017\u0003\u00033\nq\u0005^3tiRC'/Z3O_:\u001cu.\u001c9sKN\u001cX\r\u001a*fG>\u0014Hm]%o\u001f:,')\u0019;dQR\u0019!+!\u001c\t\u000f\u0005\r\"\u00031\u0001\u0002&!\u001a!#a\u000f)\u000fI\tI%!\u0016\u0002t1\u0012\u0011\u0011L\u0001-i\u0016\u001cH\u000f\u00165sK\u0016tuN\\\"p[B\u0014Xm]:fIJ+7m\u001c:eg&s7+\u001a9be\u0006$XMQ1uG\"$2AUA=\u0011\u001d\t\u0019c\u0005a\u0001\u0003KA3aEA\u001eQ\u001d\u0019\u0012\u0011JA+\u0003\u007fb#!!\u0017\u0002\u0005R,7\u000f\u001e+ie\u0016,'+Z2pe\u0012\u001c\u0018J\\(oK\n\u000bGo\u00195ICZLgn\u001a#jM\u001a,'/\u001a8u\u0007>l\u0007O]3tg&|g\u000eV=qK^KG\u000f[*feZ,'\u000fF\u0002S\u0003\u000bCq!a\t\u0015\u0001\u0004\t)\u0003K\u0002\u0015\u0003wAs\u0001FA%\u0003+\nY\t\f\u0002\u0002Z\u00059E/Z:u)\"\u0014X-\u001a*fG>\u0014Hm]%o'\u0016\u0004\u0018M]1uK\n\u000bGo\u00195ICZLgn\u001a#jM\u001a,'/\u001a8u\u0007>l\u0007O]3tg&|g\u000eV=qK^KG\u000f[*feZ,'\u000fF\u0002S\u0003#Cq!a\t\u0016\u0001\u0004\t)\u0003K\u0002\u0016\u0003wAs!FA%\u0003+\n9\n\f\u0002\u0002Z\u0005IC/Z:u)\"\u0014X-Z\"p[B\u0014Xm]:fIJ+7m\u001c:eg&s7+\u001a9be\u0006$XMQ1uG\"$2AUAO\u0011\u001d\t\u0019C\u0006a\u0001\u0003KA3AFA\u001eQ\u001d1\u0012\u0011JA+\u0003Gc#!!\u0017\u00023M,G/\u00169G_JdunZ!qa\u0016tG\rV5nK\u000e\u000b7/Z\u0001\u0016GJ,\u0017\r^3U_BL7mV5uQ\u000e{gNZ5h)\u0015\u0011\u00161VAX\u0011\u001d\ti\u000b\u0007a\u0001\u0003K\tQ\u0001^8qS\u000eDq!!-\u0019\u0001\u0004\t\u0019,A\u0003qe>\u00048\u000f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tIlO\u0001\u0005kRLG.\u0003\u0003\u0002>\u0006]&A\u0003)s_B,'\u000f^5fg\u0006\tb/\u001a:jMfd\u0015n\u001d;PM\u001a\u001cX\r^:\u0015\u000bI\u000b\u0019-!2\t\u0013\u00055\u0016\u0004%AA\u0002\u0005\u0015\u0002\"CAd3A\u0005\t\u0019AA\u0006\u0003i)\u0007\u0010]3di\u0016$W*\u0019=US6,7\u000f^1na>3gm]3u\u0003m1XM]5gs2K7\u000f^(gMN,Go\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001a\u0016\u0005\u0003K\tym\u000b\u0002\u0002RB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017!C;oG\",7m[3e\u0015\r\tY\u000eV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAp\u0003+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m1XM]5gs2K7\u000f^(gMN,Go\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001d\u0016\u0005\u0003\u0017\ty-A\bsk:4U\r^2i\u001f\u001a47/\u001a;t)!\tY/!?\u0002|\n\u0015\u0001\u0003BAw\u0003gt1!RAx\u0013\r\t\tPR\u0001\u0012\u0019&\u001cHo\u00144gg\u0016$8OU3tk2$\u0018\u0002BA{\u0003o\u0014Q\u0003T5ti>3gm]3ugJ+7/\u001e7u\u0013:4wNC\u0002\u0002r\u001aCQA\u0011\u000fA\u0002\u0011Cq!!@\u001d\u0001\u0004\ty0\u0001\u0006pM\u001a\u001cX\r^*qK\u000e\u00042!\u0012B\u0001\u0013\r\u0011\u0019A\u0012\u0002\u000b\u001f\u001a47/\u001a;Ta\u0016\u001c\u0007bBAW9\u0001\u0007\u0011QE\u0001\u001aaJ|G-^2f\u001b\u0016\u001c8/Y4fg&swJ\\3CCR\u001c\u0007\u000eF\u0003S\u0005\u0017\u0011y\u0001C\u0005\u0003\u000eu\u0001\n\u00111\u0001\u0002&\u0005y1m\\7qe\u0016\u001c8/[8o)f\u0004X\rC\u0005\u0002.v\u0001\n\u00111\u0001\u0002&\u0005\u0019\u0003O]8ek\u000e,W*Z:tC\u001e,7/\u00138P]\u0016\u0014\u0015\r^2iI\u0011,g-Y;mi\u0012\n\u0014a\t9s_\u0012,8-Z'fgN\fw-Z:J]>sWMQ1uG\"$C-\u001a4bk2$HEM\u0001\u001faJ|G-^2f\u001b\u0016\u001c8/Y4fg&s7+\u001a9be\u0006$XMQ1uG\"$RA\u0015B\r\u00057A\u0011B!\u0004!!\u0003\u0005\r!!\n\t\u0013\u00055\u0006\u0005%AA\u0002\u0005\u0015\u0012\u0001\u000b9s_\u0012,8-Z'fgN\fw-Z:J]N+\u0007/\u0019:bi\u0016\u0014\u0015\r^2iI\u0011,g-Y;mi\u0012\n\u0014\u0001\u000b9s_\u0012,8-Z'fgN\fw-Z:J]N+\u0007/\u0019:bi\u0016\u0014\u0015\r^2iI\u0011,g-Y;mi\u0012\u0012\u0014aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0005\t\u0015\u0002\u0003B5m\u0005O\u0001BA!\u000b\u000305\u0011!1\u0006\u0006\u0004\u0005[9\u0013AB:feZ,'/\u0003\u0003\u00032\t-\"aC&bM.\f7i\u001c8gS\u001e\u0004")
public class ListOffsetsIntegrationTest
extends KafkaServerTestHarness {
    private final String topicName;
    private final String topicNameWithCustomConfigs;
    private Admin adminClient;
    private final Time mockTime = new MockTime(1L);
    private final Seq<String> dataFolder = new .colon.colon((Object)TestUtils.tempDirectory(null, null).getAbsolutePath(), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null).getAbsolutePath(), (List)Nil$.MODULE$));

    private String topicName() {
        return this.topicName;
    }

    private String topicNameWithCustomConfigs() {
        return this.topicNameWithCustomConfigs;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private Time mockTime() {
        return this.mockTime;
    }

    private Seq<String> dataFolder() {
        return this.dataFolder;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopicWithConfig(this.topicName(), new Properties());
        this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava()));
    }

    @Override
    public Time brokerTime(int brokerId) {
        return this.mockTime();
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        super.tearDown();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testListMaxTimestampWithEmptyLog(String quorum) {
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.MaxTimestampSpec(), this.topicName());
        Assertions.assertEquals((long)-1L, (long)maxTimestampOffset.offset());
        Assertions.assertEquals((long)-1L, (long)maxTimestampOffset.timestamp());
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testThreeCompressedRecordsInOneBatch(String quorum) {
        this.produceMessagesInOneBatch("gzip", this.produceMessagesInOneBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        this.produceMessagesInOneBatch("gzip", this.topicNameWithCustomConfigs());
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testThreeNonCompressedRecordsInOneBatch(String quorum) {
        this.produceMessagesInOneBatch("none", this.produceMessagesInOneBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInOneBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testThreeNonCompressedRecordsInSeparateBatch(String quorum) {
        this.produceMessagesInSeparateBatch("none", this.produceMessagesInSeparateBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInSeparateBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 2);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testThreeRecordsInOneBatchHavingDifferentCompressionTypeWithServer(String quorum) {
        Properties props = new Properties();
        props.setProperty("compression.type", "lz4");
        this.createTopicWithConfig(this.topicNameWithCustomConfigs(), props);
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInOneBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 1);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testThreeRecordsInSeparateBatchHavingDifferentCompressionTypeWithServer(String quorum) {
        Properties props = new Properties();
        props.setProperty("compression.type", "lz4");
        this.createTopicWithConfig(this.topicNameWithCustomConfigs(), props);
        String x$1 = this.topicNameWithCustomConfigs();
        String x$2 = "none";
        this.produceMessagesInSeparateBatch(x$2, x$1);
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 1);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testThreeCompressedRecordsInSeparateBatch(String quorum) {
        this.produceMessagesInSeparateBatch("gzip", this.produceMessagesInSeparateBatch$default$2());
        this.verifyListOffsets(this.verifyListOffsets$default$1(), 1);
        this.setUpForLogAppendTimeCase();
        this.produceMessagesInSeparateBatch("gzip", this.topicNameWithCustomConfigs());
        this.verifyListOffsets(this.topicNameWithCustomConfigs(), 2);
    }

    private void setUpForLogAppendTimeCase() {
        Properties props = new Properties();
        props.setProperty("message.timestamp.type", "LogAppendTime");
        this.createTopicWithConfig(this.topicNameWithCustomConfigs(), props);
    }

    private void createTopicWithConfig(String topic, Properties props) {
        this.createTopic(topic, 1, (short)1, props, this.createTopic$default$5(), this.createTopic$default$6());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyListOffsets(String topic, int expectedMaxTimestampOffset) {
        int n;
        this.check$1(topic, expectedMaxTimestampOffset);
        int previousLeader = this.leader$1(topic);
        int newLeader = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.brokers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsIntegrationTest.$anonfun$verifyListOffsets$1(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> x$3 != previousLeader).get());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(new TopicPartition(topic, 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(newLeader)))))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsIntegrationTest.$anonfun$verifyListOffsets$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"There still are ongoing reassignments");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((n = this.leader$1(topic)) == newLeader)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)("expected leader: " + newLeader + " but actual: " + n));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.check$1(topic, expectedMaxTimestampOffset);
        Set indexFiles = ((IterableOnceOps)this.brokers().flatMap((Function1 & Serializable)x$4 -> x$4.config().logDirs())).toSet();
        this.brokers().foreach((Function1 & Serializable)b -> {
            this.killBroker(b.config().brokerId());
            return BoxedUnit.UNIT;
        });
        indexFiles.foreach((Function1 & Serializable)root -> {
            ListOffsetsIntegrationTest.$anonfun$verifyListOffsets$9(topic, root);
            return BoxedUnit.UNIT;
        });
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"ListOffsetsAdminClient");
        this.adminClient_$eq(Admin.create(Collections.singletonMap("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()))));
        this.check$1(topic, expectedMaxTimestampOffset);
    }

    private String verifyListOffsets$default$1() {
        return this.topicName();
    }

    private int verifyListOffsets$default$2() {
        return 1;
    }

    private ListOffsetsResult.ListOffsetsResultInfo runFetchOffsets(Admin adminClient, OffsetSpec offsetSpec, String topic) {
        TopicPartition tp = new TopicPartition(topic, 0);
        return (ListOffsetsResult.ListOffsetsResultInfo)((java.util.Map)adminClient.listOffsets(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offsetSpec)}))).asJava(), new ListOffsetsOptions()).all().get()).get(tp);
    }

    private void produceMessagesInOneBatch(String compressionType, String topic) {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10]), (List)new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10]), (List)new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10]), (List)Nil$.MODULE$)));
        String x$12 = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        int x$52 = -1;
        long x$6 = 60000L;
        long x$7 = 0x100000L;
        int x$8 = Integer.MAX_VALUE;
        int x$9 = 16384;
        int x$10 = 20000;
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$122 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$12, x$52, x$6, x$7, x$8, Integer.MAX_VALUE, Integer.MAX_VALUE, x$9, compressionType, x$10, x$11, (Option<File>)x$122, (Option<Properties>)x$13, x$14, x$15, x$16);){
            Seq futures = (Seq)records.map((Function1 & Serializable)x$1 -> producer.send(x$1));
            producer.flush();
            futures.foreach((Function1 & Serializable)x$5 -> (RecordMetadata)x$5.get());
        }
    }

    private String produceMessagesInOneBatch$default$1() {
        return "none";
    }

    private String produceMessagesInOneBatch$default$2() {
        return this.topicName();
    }

    private void produceMessagesInSeparateBatch(String compressionType, String topic) {
        .colon.colon records = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(100L), null, (Object)new byte[10]), (List)Nil$.MODULE$);
        .colon.colon records2 = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(999L), null, (Object)new byte[10]), (List)Nil$.MODULE$);
        .colon.colon records3 = new .colon.colon((Object)new ProducerRecord(topic, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(200L), null, (Object)new byte[10]), (List)Nil$.MODULE$);
        String x$12 = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        int x$3 = -1;
        long x$4 = 60000L;
        long x$5 = 0x100000L;
        int x$62 = Integer.MAX_VALUE;
        int x$72 = 30000;
        int x$82 = 0;
        int x$9 = 16384;
        int x$10 = 20000;
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$122 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$12, x$3, x$4, x$5, x$62, x$72, x$82, x$9, compressionType, x$10, x$11, (Option<File>)x$122, (Option<Properties>)x$13, x$14, x$15, x$16);){
            ((Seq)records.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$6 -> (RecordMetadata)x$6.get());
            this.mockTime().sleep(100L);
            ((Seq)records2.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$7 -> (RecordMetadata)x$7.get());
            this.mockTime().sleep(100L);
            ((Seq)records3.map((Function1 & Serializable)x$1 -> producer.send(x$1))).foreach((Function1 & Serializable)x$8 -> (RecordMetadata)x$8.get());
        }
    }

    private String produceMessagesInSeparateBatch$default$1() {
        return "none";
    }

    private String produceMessagesInSeparateBatch$default$2() {
        return this.topicName();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((IterableOps)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(2, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Properties props = (Properties)x0$1._1();
                int index = x0$1._2$mcI$sp();
                props.setProperty(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "-1");
                props.setProperty("log.dir", (String)this.dataFolder().apply(index));
                return props;
            }
            throw new MatchError(null);
        })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    private final void check$1(String topic$1, int expectedMaxTimestampOffset$1) {
        ListOffsetsResult.ListOffsetsResultInfo earliestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.EarliestSpec(), topic$1);
        Assertions.assertEquals((long)0L, (long)earliestOffset.offset());
        ListOffsetsResult.ListOffsetsResultInfo latestOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.LatestSpec(), topic$1);
        Assertions.assertEquals((long)3L, (long)latestOffset.offset());
        ListOffsetsResult.ListOffsetsResultInfo maxTimestampOffset = this.runFetchOffsets(this.adminClient(), (OffsetSpec)new OffsetSpec.MaxTimestampSpec(), topic$1);
        Assertions.assertEquals((long)expectedMaxTimestampOffset$1, (long)maxTimestampOffset.offset());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)maxTimestampOffset.leaderEpoch());
    }

    private final int leader$1(String topic$1) {
        return ((TopicPartitionInfo)((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(topic$1)).allTopicNames().get()).get(topic$1)).partitions().get(0)).leader().id();
    }

    public static final /* synthetic */ int $anonfun$verifyListOffsets$1(KafkaBroker x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$verifyListOffsets$3(ListOffsetsIntegrationTest $this) {
        return ((java.util.Map)$this.adminClient().listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$verifyListOffsets$4() {
        return "There still are ongoing reassignments";
    }

    public static final /* synthetic */ boolean $anonfun$verifyListOffsets$5(ListOffsetsIntegrationTest $this, IntRef lastLeader$1, int newLeader$1, String topic$1) {
        lastLeader$1.elem = $this.leader$1(topic$1);
        return lastLeader$1.elem == newLeader$1;
    }

    public static final /* synthetic */ String $anonfun$verifyListOffsets$6(int newLeader$1, IntRef lastLeader$1) {
        return "expected leader: " + newLeader$1 + " but actual: " + lastLeader$1.elem;
    }

    public static final /* synthetic */ void $anonfun$verifyListOffsets$9(String topic$1, String root) {
        Object[] files = new File(root + "/" + topic$1 + "-0").listFiles();
        if (files != null) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(files), (Function1 & Serializable)f -> {
                if (f.getName().endsWith(".index")) {
                    return BoxesRunTime.boxToBoolean((boolean)f.delete());
                }
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public ListOffsetsIntegrationTest() {
        this.topicName = "foo";
        this.topicNameWithCustomConfigs = "foo2";
    }
}

