/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZkMigrationClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.migration.ZkAclMigrationClient;
import kafka.zk.migration.ZkConfigMigrationClient;
import kafka.zk.migration.ZkDelegationTokenMigrationClient;
import kafka.zk.migration.ZkTopicMigrationClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.DelegationTokenMigrationClient;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.metadata.migration.ZkRecordConsumer;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u000e\u001d\u0001\u0005BQA\f\u0001\u0005\u0002=2AA\r\u0001\u0001g!A\u0011J\u0001B\u0001B\u0003%!\nC\u0003/\u0005\u0011\u0005Q\nC\u0004R\u0005\t\u0007I\u0011\u0001*\t\r\u001d\u0014\u0001\u0015!\u0003T\u0011\u001dA'\u00011A\u0005\u0002%DqA\u001d\u0002A\u0002\u0013\u00051\u000f\u0003\u0004z\u0005\u0001\u0006KA\u001b\u0005\bu\n\u0001\r\u0011\"\u0001|\u0011!y(\u00011A\u0005\u0002\u0005\u0005\u0001bBA\u0003\u0005\u0001\u0006K\u0001 \u0005\b\u0003\u000f\u0011A\u0011IA\u0005\u0011\u001d\t9C\u0001C\u0001\u0003SAq!a\u000f\u0003\t\u0003\tiD\u0002\u0004\u0002D\u0001\u0001\u0011Q\t\u0005\u000b\u0003'\u0002\"\u0011!Q\u0001\n\u0005U\u0003B\u0002\u0018\u0011\t\u0003\tY\u0006C\u0005\u0002bA\u0011\r\u0011\"\u0001\u0002d!A\u00111\u000e\t!\u0002\u0013\t)\u0007C\u0004\u0002nA!\t%a\u001c\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003k\u0014qCW6NS\u001e\u0014\u0018\r^5p]\u001a\u000b\u0017\u000e\\8wKJ$Vm\u001d;\u000b\u0005uq\u0012A\u0001>l\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0004\u0001\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*Y5\t!F\u0003\u0002,=\u0005)Q\u000f^5mg&\u0011QF\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0007\u0005\u00022\u00015\tADA\u000bDCB$XO]5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0014\u0007\t!D\b\u0005\u00026u5\taG\u0003\u00028q\u0005!A.\u00198h\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\r=\u0013'.Z2u!\tit)D\u0001?\u0015\ty\u0004)A\u0003gCVdGO\u0003\u0002B\u0005\u000611/\u001a:wKJT!aH\"\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0005\u0003\u0011z\u0012ABR1vYRD\u0015M\u001c3mKJ\faA\\8eK&#\u0007CA\u0012L\u0013\taEEA\u0002J]R$\"A\u0014)\u0011\u0005=\u0013Q\"\u0001\u0001\t\u000b%#\u0001\u0019\u0001&\u0002\r\u0019\fW\u000f\u001c;t+\u0005\u0019\u0006c\u0001+Z76\tQK\u0003\u0002W/\u00069Q.\u001e;bE2,'B\u0001-%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00035V\u0013aAQ;gM\u0016\u0014\bC\u0001/e\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002aA\u00051AH]8pizJ\u0011!J\u0005\u0003G\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002fM\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003G\u0012\nqAZ1vYR\u001c\b%\u0001\u0004gkR,(/Z\u000b\u0002UB\u00191\u000e].\u000e\u00031T!!\u001c8\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002pq\u0005!Q\u000f^5m\u0013\t\tHNA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\f!BZ;ukJ,w\fJ3r)\t!x\u000f\u0005\u0002$k&\u0011a\u000f\n\u0002\u0005+:LG\u000fC\u0004y\u0011\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0013'A\u0004gkR,(/\u001a\u0011\u0002\u001b]\f\u0017\u000e^5oO\u001a{'/T:h+\u0005a\bCA\u001b~\u0013\tqhG\u0001\u0004TiJLgnZ\u0001\u0012o\u0006LG/\u001b8h\r>\u0014Xj]4`I\u0015\fHc\u0001;\u0002\u0004!9\u0001pCA\u0001\u0002\u0004a\u0018AD<bSRLgn\u001a$pe6\u001bx\rI\u0001\fQ\u0006tG\r\\3GCVdG\u000f\u0006\u0004\u0002\f\u0005E\u00111\u0005\t\u00049\u00065\u0011bAA\bM\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0005\b\u0003'i\u0001\u0019AA\u000b\u000391\u0017-\u001b7ve\u0016lUm]:bO\u0016\u0004B!a\u0006\u0002 9!\u0011\u0011DA\u000e!\tqF%C\u0002\u0002\u001e\u0011\na\u0001\u0015:fI\u00164\u0017b\u0001@\u0002\")\u0019\u0011Q\u0004\u0013\t\r\u0005\u0015R\u00021\u0001\\\u0003\u0015\u0019\u0017-^:f\u00035\u0019\u0007.Z2l\u0003:$7\t\\3beR\u0019A/a\u000b\t\u000f\u00055b\u00021\u0001\u00020\u0005Aa/\u001a:jM&,'\u000f\u0005\u0004$\u0003c\t)\u0004^\u0005\u0004\u0003g!#!\u0003$v]\u000e$\u0018n\u001c82!\u0011a\u0016qG.\n\u0007\u0005ebMA\u0002TKF\fAb^1ji\u001a{'/\u0012:s_J$2A[A \u0011\u001d\t\te\u0004a\u0001\u0003+\tq!\\3tg\u0006<WMA\u0010DCB$XO]5oOj[Gk\u001c9jG6KwM]1uS>t7\t\\5f]R\u001c2\u0001EA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'9\u0005IQ.[4sCRLwN\\\u0005\u0005\u0003#\nYE\u0001\f[WR{\u0007/[2NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0003!Q8n\u00117jK:$\bcA\u0019\u0002X%\u0019\u0011\u0011\f\u000f\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u)\u0011\ti&a\u0018\u0011\u0005=\u0003\u0002bBA*%\u0001\u0007\u0011QK\u0001\u000eGJ,\u0017\r^3e)>\u0004\u0018nY:\u0016\u0005\u0005\u0015\u0004#\u0002+\u0002h\u0005U\u0011bAA5+\n\u00191+\u001a;\u0002\u001d\r\u0014X-\u0019;fIR{\u0007/[2tA\u0005Y1M]3bi\u0016$v\u000e]5d))\t\t(a \u0002\u0004\u0006M\u0015Q\u0016\t\u0005\u0003g\nY(\u0004\u0002\u0002v)!\u0011QJA<\u0015\r\tIHQ\u0001\t[\u0016$\u0018\rZ1uC&!\u0011QPA;\u0005iQ6.T5he\u0006$\u0018n\u001c8MK\u0006$WM]:iSB\u001cF/\u0019;f\u0011\u001d\t\t)\u0006a\u0001\u0003+\t\u0011\u0002^8qS\u000et\u0015-\\3\t\u000f\u0005\u0015U\u00031\u0001\u0002\b\u00069Ao\u001c9jG&#\u0007\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055%)\u0001\u0004d_6lwN\\\u0005\u0005\u0003#\u000bYI\u0001\u0003Vk&$\u0007bBAK+\u0001\u0007\u0011qS\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003CAM\u00037\u000by*!*\u000e\u00039L1!!(o\u0005\ri\u0015\r\u001d\t\u0004k\u0005\u0005\u0016bAARm\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BAT\u0003Sk!!a\u001e\n\t\u0005-\u0016q\u000f\u0002\u0016!\u0006\u0014H/\u001b;j_:\u0014VmZ5tiJ\fG/[8o\u0011\u001d\ty+\u0006a\u0001\u0003c\nQa\u001d;bi\u0016\fACY;jY\u0012l\u0015n\u001a:bi&|g\u000e\u0012:jm\u0016\u0014HCBA[\u0003\u0003\f\u0019\r\u0005\u0004$\u0003o\u000bYLT\u0005\u0004\u0003s##A\u0002+va2,'\u0007\u0005\u0003\u0002t\u0005u\u0016\u0002BA`\u0003k\u0012Ac\u0013*bMRl\u0015n\u001a:bi&|g\u000e\u0012:jm\u0016\u0014\b\"B%\u0017\u0001\u0004Q\u0005bBAc-\u0001\u0007\u0011qY\u0001\u0012u.l\u0015n\u001a:bi&|gn\u00117jK:$\bcA\u0019\u0002J&\u0019\u00111\u001a\u000f\u0003#i[W*[4sCRLwN\\\"mS\u0016tG/\u0001\nsK\u0006$W*[4sCRLwN\u001c.O_\u0012,G\u0003BA9\u0003#Dq!!2\u0018\u0001\u0004\t9-A\u0004tC\u001a,w)\u001a;\u0016\t\u0005]\u0017Q\u001c\u000b\u0005\u00033\fy\u000f\u0005\u0003\u0002\\\u0006uG\u0002\u0001\u0003\b\u0003?D\"\u0019AAq\u0005\u0005!\u0016\u0003BAr\u0003S\u00042aIAs\u0013\r\t9\u000f\n\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u00131^\u0005\u0004\u0003[$#aA!os\"1\u0001\u000e\u0007a\u0001\u0003c\u0004Ba\u001b9\u0002Z\u0006aB/Z:u\u0007>tGO]8mY\u0016\u0014h)Y5m_Z,'OW6SC\u000e,G#\u0001;)\u0007e\tI\u0010\u0005\u0003\u0002|\n%QBAA\u007f\u0015\u0011\tyP!\u0001\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003\u0004\t\u0015\u0011a\u00026va&$XM\u001d\u0006\u0004\u0005\u000f)\u0015!\u00026v]&$\u0018\u0002\u0002B\u0006\u0003{\u0014A\u0001V3ti\u0006\u0019C/Z:u\tJLg/\u001a:TW&\u00048/\u0012<f]R\u001chI]8n\u001f2$WM]#q_\u000eD\u0007f\u0001\u000e\u0002z\u0002")
public class ZkMigrationFailoverTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Tuple2<KRaftMigrationDriver, CapturingFaultHandler> buildMigrationDriver(int nodeId, ZkMigrationClient zkMigrationClient) {
        CapturingFaultHandler faultHandler = new CapturingFaultHandler(this, nodeId);
        KRaftMigrationDriver driver = new KRaftMigrationDriver.Builder().setNodeId(nodeId).setZkRecordConsumer(new ZkRecordConsumer(null){

            public CompletableFuture<?> beginMigration() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public CompletableFuture<?> acceptBatch(List<ApiMessageAndVersion> recordBatch) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public CompletableFuture<OffsetAndEpoch> completeMigration() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void abortMigration() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }).setInitialZkLoadHandler(x$1 -> {}).setZkMigrationClient((MigrationClient)zkMigrationClient).setFaultHandler((FaultHandler)faultHandler).setQuorumFeatures(new QuorumFeatures(nodeId, QuorumFeatures.defaultFeatureMap((boolean)true), Arrays.asList(Predef$.MODULE$.int2Integer(3000), Predef$.MODULE$.int2Integer(3001), Predef$.MODULE$.int2Integer(3002)))).setConfigSchema(KafkaConfigSchema.EMPTY).setControllerMetrics(new QuorumControllerMetrics(Optional.empty(), Time.SYSTEM, true)).setTime(Time.SYSTEM).setPropagator(new LegacyPropagator(null){

            public void startup() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void shutdown() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void publishMetadata(MetadataImage image) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void sendRPCsToBrokersFromMetadataDelta(MetadataDelta delta, MetadataImage image, int zkControllerEpoch) {
            }

            public void sendRPCsToBrokersFromMetadataImage(MetadataImage image, int zkControllerEpoch) {
            }

            public void clear() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }).build();
        return new Tuple2((Object)driver, (Object)faultHandler);
    }

    public ZkMigrationLeadershipState readMigrationZNode(ZkMigrationClient zkMigrationClient) {
        return zkMigrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
    }

    public <T> T safeGet(CompletableFuture<T> future) {
        return future.get(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerFailoverZkRace() {
        void var9_10;
        void var6_7;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        KafkaZkClient kafkaZkClient = null;
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            kafkaZkClient = KafkaZkClient$.MODULE$.apply(zkConnect, false, 30000, 60000, 1, Time.SYSTEM, "ZkMigrationFailoverTest", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11(), KafkaZkClient$.MODULE$.apply$default$12());
        }
        catch (Throwable t) {
            Utils.closeQuietly((AutoCloseable)zookeeper, (String)"EmbeddedZookeeper");
            zookeeper.shutdown();
            if ((KafkaZkClient)kafkaZkClient != null) {
                Utils.closeQuietly((AutoCloseable)kafkaZkClient, (String)"KafkaZkClient");
            }
            throw t;
        }
        ZkMigrationClient zkMigrationClient = ZkMigrationClient$.MODULE$.apply(kafkaZkClient, PasswordEncoder.NOOP);
        Tuple2<KRaftMigrationDriver, CapturingFaultHandler> tuple2 = this.buildMigrationDriver(3000, zkMigrationClient);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KRaftMigrationDriver driver1 = (KRaftMigrationDriver)tuple2._1();
        CapturingFaultHandler faultHandler1 = (CapturingFaultHandler)tuple2._2();
        Tuple2<KRaftMigrationDriver, CapturingFaultHandler> tuple22 = this.buildMigrationDriver(3001, zkMigrationClient);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        KRaftMigrationDriver driver2 = (KRaftMigrationDriver)tuple22._1();
        CapturingFaultHandler faultHandler2 = (CapturingFaultHandler)tuple22._2();
        kafkaZkClient.registerControllerAndIncrementControllerEpoch(0);
        ZkMigrationLeadershipState zkState = zkMigrationClient.claimControllerLeadership(ZkMigrationLeadershipState.EMPTY.withNewKRaftController(3000, 1));
        zkState = zkState.withKRaftMetadataOffsetAndEpoch(100L, 10);
        zkMigrationClient.getOrCreateMigrationRecoveryState(zkState);
        zkState = null;
        try {
            void var7_8;
            void var10_11;
            var6_7.start();
            var9_10.start();
            LeaderAndEpoch newLeader1 = new LeaderAndEpoch(OptionalInt.of(3000), 2);
            MetadataImage image1 = MetadataImage.EMPTY;
            MetadataDelta delta1 = new MetadataDelta(image1);
            delta1.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_6_IV1.featureLevel()));
            delta1.replay(ZkMigrationState.MIGRATION.toRecord().message());
            delta1.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName("topic-to-sync"));
            MetadataProvenance provenance1 = new MetadataProvenance(210L, 11, 1L);
            image1 = delta1.apply(provenance1);
            LogDeltaManifest manifest1 = new LogDeltaManifest.Builder().provenance(provenance1).leaderAndEpoch(newLeader1).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            var6_7.onMetadataUpdate(delta1, image1, (LoaderManifest)manifest1);
            var6_7.onControllerChange(newLeader1);
            var9_10.onControllerChange(newLeader1);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void waitUntilTrue_pause;
                boolean bl;
                Option option;
                if ((option = kafkaZkClient.getControllerId()) instanceof Some) {
                    bl = BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3000;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                option = null;
                if (bl) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"waiting for 3000 to claim ZK leadership");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            LeaderAndEpoch newLeader2 = new LeaderAndEpoch(OptionalInt.of(3001), 3);
            var9_10.onControllerChange(newLeader2);
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$3(this, (KRaftMigrationDriver)var9_10)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"waiting for node 3001 to enter WAIT_FOR_CONTROLLER_QUORUM");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            MetadataDelta delta2 = new MetadataDelta(image1);
            delta2.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName("another-topic-to-sync"));
            MetadataProvenance provenance2 = new MetadataProvenance(211L, 11, 1L);
            MetadataImage image2 = delta2.apply(provenance2);
            LogDeltaManifest manifest2 = new LogDeltaManifest.Builder().provenance(provenance2).leaderAndEpoch(newLeader1).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            int migrationZkVersion = this.readMigrationZNode(zkMigrationClient).migrationZkVersion();
            var6_7.onMetadataUpdate(delta2, image2, (LoaderManifest)manifest2);
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$5(this, zkMigrationClient, migrationZkVersion)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"waiting for /migration znode to change");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            MetadataDelta delta3 = new MetadataDelta(image1);
            delta3.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName("another-topic-to-sync"));
            MetadataProvenance provenance3 = new MetadataProvenance(211L, 11, 1L);
            MetadataImage image3 = delta3.apply(provenance3);
            LogDeltaManifest manifest3 = new LogDeltaManifest.Builder().provenance(provenance3).leaderAndEpoch(newLeader2).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            var9_10.onMetadataUpdate(delta3, image3, (LoaderManifest)manifest3);
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (true) {
                void waitUntilTrue_pause;
                boolean bl;
                Option option;
                if ((option = kafkaZkClient.getControllerId()) instanceof Some) {
                    bl = BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3001;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                option = null;
                if (bl) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                    Assertions.fail((String)"waiting for 3001 to claim ZK leadership");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
            }
            var10_11.checkAndClear((Function1<Seq<Throwable>, BoxedUnit>)(Function1 & Serializable)faults -> {
                ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$9(faults);
                return BoxedUnit.UNIT;
            });
            var6_7.onMetadataUpdate(delta3, image3, (LoaderManifest)manifest3);
            this.safeGet(var7_8.waitForError("Controller epoch zkVersion check fails"));
            var6_7.onControllerChange(newLeader2);
            var10_11.checkAndClear((Function1<Seq<Throwable>, BoxedUnit>)(Function1 & Serializable)faults -> {
                ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$10(faults);
                return BoxedUnit.UNIT;
            });
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long waitUntilTrue_waitTimeMs5 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$11(this, (KRaftMigrationDriver)var9_10)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                    Assertions.fail((String)"waiting for driver to enter DUAL_WRITE");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
            }
            var10_11.checkAndClear((Function1<Seq<Throwable>, BoxedUnit>)(Function1 & Serializable)faults -> {
                ZkMigrationFailoverTest.$anonfun$testControllerFailoverZkRace$13(faults);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            var6_7.close();
            var9_10.close();
            zookeeper.shutdown();
            Utils.closeQuietly((AutoCloseable)kafkaZkClient, (String)"KafkaZkClient");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDriverSkipsEventsFromOlderEpoch() {
        void var11_18;
        void var9_16;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        KafkaZkClient kafkaZkClient = null;
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            kafkaZkClient = KafkaZkClient$.MODULE$.apply(zkConnect, false, 30000, 60000, 1, Time.SYSTEM, "ZkMigrationFailoverTest", new ZKClientConfig(), "kafka.server", "SessionExpireListener", false, true);
        }
        catch (Throwable t) {
            zookeeper.shutdown();
            if ((KafkaZkClient)kafkaZkClient != null) {
                Utils.closeQuietly((AutoCloseable)kafkaZkClient, (String)"KafkaZkClient");
            }
            throw t;
        }
        CapturingZkTopicMigrationClient topicClient1 = new CapturingZkTopicMigrationClient(kafkaZkClient);
        CapturingZkTopicMigrationClient topicClient2 = new CapturingZkTopicMigrationClient(kafkaZkClient);
        ZkConfigMigrationClient buildZkMigrationClient$1_configClient = new ZkConfigMigrationClient(kafkaZkClient, PasswordEncoder.NOOP);
        ZkAclMigrationClient buildZkMigrationClient$1_aclClient = new ZkAclMigrationClient(kafkaZkClient);
        ZkDelegationTokenMigrationClient buildZkMigrationClient$1_delegationTokenClient = new ZkDelegationTokenMigrationClient(kafkaZkClient);
        Object var38_7 = null;
        Object var39_8 = null;
        Object var40_9 = null;
        ZkMigrationClient zkMigrationClient1 = new ZkMigrationClient(kafkaZkClient, (TopicMigrationClient)topicClient1, (ConfigMigrationClient)buildZkMigrationClient$1_configClient, (AclMigrationClient)buildZkMigrationClient$1_aclClient, (DelegationTokenMigrationClient)buildZkMigrationClient$1_delegationTokenClient);
        ZkConfigMigrationClient buildZkMigrationClient$1_configClient2 = new ZkConfigMigrationClient(kafkaZkClient, PasswordEncoder.NOOP);
        ZkAclMigrationClient buildZkMigrationClient$1_aclClient2 = new ZkAclMigrationClient(kafkaZkClient);
        ZkDelegationTokenMigrationClient buildZkMigrationClient$1_delegationTokenClient2 = new ZkDelegationTokenMigrationClient(kafkaZkClient);
        Object var41_11 = null;
        Object var42_12 = null;
        Object var43_13 = null;
        ZkMigrationClient zkMigrationClient2 = new ZkMigrationClient(kafkaZkClient, (TopicMigrationClient)topicClient2, (ConfigMigrationClient)buildZkMigrationClient$1_configClient2, (AclMigrationClient)buildZkMigrationClient$1_aclClient2, (DelegationTokenMigrationClient)buildZkMigrationClient$1_delegationTokenClient2);
        Tuple2<KRaftMigrationDriver, CapturingFaultHandler> tuple2 = this.buildMigrationDriver(3000, zkMigrationClient1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KRaftMigrationDriver driver1 = (KRaftMigrationDriver)tuple2._1();
        CapturingFaultHandler cfr_ignored_0 = (CapturingFaultHandler)tuple2._2();
        Tuple2<KRaftMigrationDriver, CapturingFaultHandler> tuple22 = this.buildMigrationDriver(3001, zkMigrationClient2);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        KRaftMigrationDriver driver2 = (KRaftMigrationDriver)tuple22._1();
        CapturingFaultHandler cfr_ignored_1 = (CapturingFaultHandler)tuple22._2();
        kafkaZkClient.registerControllerAndIncrementControllerEpoch(0);
        ZkMigrationLeadershipState zkState = zkMigrationClient1.claimControllerLeadership(ZkMigrationLeadershipState.EMPTY.withNewKRaftController(3000, 1));
        zkState = zkState.withKRaftMetadataOffsetAndEpoch(100L, 10);
        zkMigrationClient1.getOrCreateMigrationRecoveryState(zkState);
        zkState = null;
        try {
            var9_16.start();
            var11_18.start();
            LeaderAndEpoch leader1 = new LeaderAndEpoch(OptionalInt.of(3000), 2);
            ObjectRef image = ObjectRef.create((Object)MetadataImage.EMPTY);
            MetadataDelta delta = new MetadataDelta((MetadataImage)image.elem);
            delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.latestProduction().featureLevel()));
            delta.replay(ZkMigrationState.MIGRATION.toRecord().message());
            MetadataProvenance provenance = new MetadataProvenance(210L, 11, 1L);
            image.elem = delta.apply(provenance);
            LogDeltaManifest manifest = new LogDeltaManifest.Builder().provenance(provenance).leaderAndEpoch(leader1).numBatches(1).elapsedNs(100L).numBytes(42L).build();
            var9_16.onMetadataUpdate(delta, (MetadataImage)image.elem, (LoaderManifest)manifest);
            var9_16.onControllerChange(leader1);
            var11_18.onControllerChange(leader1);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ZkMigrationFailoverTest.$anonfun$testDriverSkipsEventsFromOlderEpoch$1(this, (KRaftMigrationDriver)var9_16)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"waiting for driver to enter DUAL_WRITE");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1000).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> ZkMigrationFailoverTest.$anonfun$testDriverSkipsEventsFromOlderEpoch$3(image, leader1, (KRaftMigrationDriver)var9_16, (KRaftMigrationDriver)var11_18, arg_0)));
            Thread.sleep(50L);
            LeaderAndEpoch leader2 = new LeaderAndEpoch(OptionalInt.of(3001), 3);
            var9_16.onControllerChange(leader2);
            Thread.sleep(50L);
            var11_18.onControllerChange(leader2);
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (true) {
                void waitUntilTrue_pause;
                boolean bl;
                Option option;
                if ((option = kafkaZkClient.getControllerId()) instanceof Some) {
                    bl = BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3001;
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                option = null;
                if (bl) break;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"waiting for 3001 to claim ZK leadership");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!(kafkaZkClient.getAllTopicsInCluster(false).size() == 1000)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"waiting for topics to be created in ZK.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)topicClient1.createdTopics().nonEmpty(), (String)"Expect first leader to write some topics");
            Assertions.assertTrue((boolean)topicClient2.createdTopics().nonEmpty(), (String)"Expect second leader to write some topics");
            Assertions.assertEquals((int)1000, (int)(topicClient1.createdTopics().size() + topicClient2.createdTopics().size()), (String)"Expect drivers to only write to ZK if they are the leader");
        }
        finally {
            var9_16.close();
            var11_18.close();
            zookeeper.shutdown();
            Utils.closeQuietly((AutoCloseable)kafkaZkClient, (String)"KafkaZkClient");
        }
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$1(ObjectRef zkClient$1) {
        Option option = ((KafkaZkClient)zkClient$1.elem).getControllerId();
        if (option instanceof Some) {
            return BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3000;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$2() {
        return "waiting for 3000 to claim ZK leadership";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$3(ZkMigrationFailoverTest $this, KRaftMigrationDriver driver2$1) {
        return ((Enum)$this.safeGet(driver2$1.migrationState())).equals(MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$4() {
        return "waiting for node 3001 to enter WAIT_FOR_CONTROLLER_QUORUM";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$5(ZkMigrationFailoverTest $this, ZkMigrationClient zkMigrationClient$1, int migrationZkVersion$1) {
        return $this.readMigrationZNode(zkMigrationClient$1).migrationZkVersion() > migrationZkVersion$1;
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$6() {
        return "waiting for /migration znode to change";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$7(ObjectRef zkClient$1) {
        Option option = ((KafkaZkClient)zkClient$1.elem).getControllerId();
        if (option instanceof Some) {
            return BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3001;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$8() {
        return "waiting for 3001 to claim ZK leadership";
    }

    public static final /* synthetic */ void $anonfun$testControllerFailoverZkRace$9(Seq faults) {
        Assertions.assertTrue((boolean)faults.isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testControllerFailoverZkRace$10(Seq faults) {
        Assertions.assertTrue((boolean)faults.isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverZkRace$11(ZkMigrationFailoverTest $this, KRaftMigrationDriver driver2$1) {
        return ((Enum)$this.safeGet(driver2$1.migrationState())).equals(MigrationDriverState.DUAL_WRITE);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverZkRace$12() {
        return "waiting for driver to enter DUAL_WRITE";
    }

    public static final /* synthetic */ void $anonfun$testControllerFailoverZkRace$13(Seq faults) {
        Assertions.assertTrue((boolean)faults.isEmpty());
    }

    private static final ZkMigrationClient buildZkMigrationClient$1(TopicMigrationClient topicClient, ObjectRef zkClient$2) {
        ZkConfigMigrationClient configClient = new ZkConfigMigrationClient((KafkaZkClient)zkClient$2.elem, PasswordEncoder.NOOP);
        ZkAclMigrationClient aclClient = new ZkAclMigrationClient((KafkaZkClient)zkClient$2.elem);
        ZkDelegationTokenMigrationClient delegationTokenClient = new ZkDelegationTokenMigrationClient((KafkaZkClient)zkClient$2.elem);
        return new ZkMigrationClient((KafkaZkClient)zkClient$2.elem, topicClient, (ConfigMigrationClient)configClient, (AclMigrationClient)aclClient, (DelegationTokenMigrationClient)delegationTokenClient);
    }

    public static final /* synthetic */ boolean $anonfun$testDriverSkipsEventsFromOlderEpoch$1(ZkMigrationFailoverTest $this, KRaftMigrationDriver driver1$1) {
        return ((Enum)$this.safeGet(driver1$1.migrationState())).equals(MigrationDriverState.DUAL_WRITE);
    }

    public static final /* synthetic */ String $anonfun$testDriverSkipsEventsFromOlderEpoch$2() {
        return "waiting for driver to enter DUAL_WRITE";
    }

    public static final /* synthetic */ void $anonfun$testDriverSkipsEventsFromOlderEpoch$3(ObjectRef image$1, LeaderAndEpoch leader1$1, KRaftMigrationDriver driver1$1, KRaftMigrationDriver driver2$2, int i) {
        MetadataDelta delta = new MetadataDelta((MetadataImage)image$1.elem);
        delta.replay(new TopicRecord().setTopicId(Uuid.randomUuid()).setName(new StringBuilder(6).append("topic-").append(i).toString()));
        MetadataProvenance provenance = new MetadataProvenance((long)(210 + i), 11, 1L);
        image$1.elem = delta.apply(provenance);
        LogDeltaManifest manifest = new LogDeltaManifest.Builder().provenance(provenance).leaderAndEpoch(leader1$1).numBatches(1).elapsedNs(100L).numBytes(42L).build();
        driver1$1.onMetadataUpdate(delta, (MetadataImage)image$1.elem, (LoaderManifest)manifest);
        driver2$2.onMetadataUpdate(delta, (MetadataImage)image$1.elem, (LoaderManifest)manifest);
    }

    public static final /* synthetic */ boolean $anonfun$testDriverSkipsEventsFromOlderEpoch$4(ObjectRef zkClient$2) {
        Option option = ((KafkaZkClient)zkClient$2.elem).getControllerId();
        if (option instanceof Some) {
            return BoxesRunTime.unboxToInt((Object)((Some)option).value()) == 3001;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$testDriverSkipsEventsFromOlderEpoch$5() {
        return "waiting for 3001 to claim ZK leadership";
    }

    public static final /* synthetic */ boolean $anonfun$testDriverSkipsEventsFromOlderEpoch$6(ObjectRef zkClient$2) {
        return ((KafkaZkClient)zkClient$2.elem).getAllTopicsInCluster(false).size() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testDriverSkipsEventsFromOlderEpoch$7() {
        return "waiting for topics to be created in ZK.";
    }

    public class CapturingFaultHandler
    implements FaultHandler {
        private final int nodeId;
        private final Buffer<Throwable> faults;
        private CompletableFuture<Throwable> future;
        private String waitingForMsg;
        public final /* synthetic */ ZkMigrationFailoverTest $outer;

        public RuntimeException handleFault(String x$1) {
            return super.handleFault(x$1);
        }

        public Buffer<Throwable> faults() {
            return this.faults;
        }

        public CompletableFuture<Throwable> future() {
            return this.future;
        }

        public void future_$eq(CompletableFuture<Throwable> x$1) {
            this.future = x$1;
        }

        public String waitingForMsg() {
            return this.waitingForMsg;
        }

        public void waitingForMsg_$eq(String x$1) {
            this.waitingForMsg = x$1;
        }

        public RuntimeException handleFault(String failureMessage, Throwable cause) {
            this.kafka$zk$ZkMigrationFailoverTest$CapturingFaultHandler$$$outer().error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Fault handled on node ").append($this.nodeId).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> cause);
            this.faults().append((Object)cause);
            if (!this.future().isDone() && cause.getMessage().contains(this.waitingForMsg())) {
                this.future().complete(cause);
            }
            return new RuntimeException(cause);
        }

        public void checkAndClear(Function1<Seq<Throwable>, BoxedUnit> verifier) {
            Seq faultsSoFar = this.faults().toSeq();
            try {
                verifier.apply((Object)faultsSoFar);
                return;
            }
            catch (AssertionError ae) {
                Assertions.fail((String)new StringBuilder(35).append("Assertion failed. Faults on ").append(this.nodeId).append(" were: ").append(faultsSoFar).toString(), (Throwable)((Object)ae));
                return;
            }
        }

        public CompletableFuture<Throwable> waitForError(String message) {
            this.future_$eq(new CompletableFuture<Throwable>());
            this.waitingForMsg_$eq(message);
            return this.future();
        }

        public /* synthetic */ ZkMigrationFailoverTest kafka$zk$ZkMigrationFailoverTest$CapturingFaultHandler$$$outer() {
            return this.$outer;
        }

        public CapturingFaultHandler(ZkMigrationFailoverTest $outer, int nodeId) {
            this.nodeId = nodeId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.faults = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.future = CompletableFuture.completedFuture(new RuntimeException());
            this.waitingForMsg = "";
        }
    }

    public class CapturingZkTopicMigrationClient
    extends ZkTopicMigrationClient {
        private final Set<String> createdTopics;

        public Set<String> createdTopics() {
            return this.createdTopics;
        }

        public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
            this.createdTopics().add((Object)topicName);
            return super.createTopic(topicName, topicId, partitions, state);
        }

        public /* synthetic */ ZkMigrationFailoverTest kafka$zk$ZkMigrationFailoverTest$CapturingZkTopicMigrationClient$$$outer() {
            return ZkMigrationFailoverTest.this;
        }

        public CapturingZkTopicMigrationClient(KafkaZkClient zkClient) {
            if (ZkMigrationFailoverTest.this == null) {
                throw null;
            }
            super(zkClient);
            this.createdTopics = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

