/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.OptionalInt;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionState;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u0014(\u00011B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0019\u0003!Q1A\u0005\u0002yB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u007f!A\u0011\n\u0001B\u0001B\u0003%!\nC\u0003N\u0001\u0011\u0005a\nC\u0004W\u0001\t\u0007I\u0011B,\t\r9\u0004\u0001\u0015!\u0003Y\u0011\u001dy\u0007\u00011A\u0005\nADq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004|\u0001\u0001\u0006K!\u001d\u0005\u0006y\u0002!\t! \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!9\u0011Q\u0012\u0001\u0005B\u0005=\u0005bBAL\u0001\u0011\u0005\u0013\u0011\u0014\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!!+\u0001\t\u0003\nY\u000bC\u0004\u0002B\u0002!\t!a1\t\u0013\u00055\u0007A1A\u0005R\u0005=\u0007\u0002CAi\u0001\u0001\u0006I!!\u000b\b\u0013\u0005Mw%!A\t\u0002\u0005Ug\u0001\u0003\u0014(\u0003\u0003E\t!a6\t\r5\u0003C\u0011AAp\u0011%\t\t\u000fII\u0001\n\u0003\t\u0019\u000fC\u0005\u0002z\u0002\n\n\u0011\"\u0001\u0002d\"I\u00111 \u0011\u0012\u0002\u0013\u0005\u00111\u001d\u0005\n\u0003{\u0004\u0013\u0013!C\u0001\u0003\u007f\u0014\u0011#T8dW\u001a+Go\u00195feRC'/Z1e\u0015\tA\u0013&\u0001\u0004tKJ4XM\u001d\u0006\u0002U\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001.!\tqs&D\u0001(\u0013\t\u0001tEA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u00155|7m\u001b'fC\u0012,'/F\u00014!\tqC'\u0003\u00026O\t\u0011Rj\\2l\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0003-iwnY6MK\u0006$WM\u001d\u0011\u0002)5|7m\u001b+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f+\u0005I\u0004C\u0001\u0018;\u0013\tYtE\u0001\u000bN_\u000e\\G+[3s'R\fG/Z'bG\"Lg.Z\u0001\u0016[>\u001c7\u000eV5feN#\u0018\r^3NC\u000eD\u0017N\\3!\u0003%\u0011X\r\u001d7jG\u0006LE-F\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\rIe\u000e^\u0001\u000be\u0016\u0004H.[2b\u0013\u0012\u0004\u0013\u0001\u00037fC\u0012,'/\u00133\u0002\u00131,\u0017\rZ3s\u0013\u0012\u0004\u0013A\u00044fi\u000eD')Y2l\u001f\u001a4Wj]\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"AL&\n\u00051;#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003\u0019a\u0014N\\5u}Q9q\nU)S'R+\u0006C\u0001\u0018\u0001\u0011\u0015\t4\u00021\u00014\u0011\u001594\u00021\u0001:\u0011\u001di4\u0002%AA\u0002}BqAR\u0006\u0011\u0002\u0003\u0007q\bC\u0004I\u0017A\u0005\t\u0019A \t\u000f%[\u0001\u0013!a\u0001\u0015\u00061\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7/F\u0001Y!\u0011If\fY6\u000e\u0003iS!a\u0017/\u0002\u000f5,H/\u00192mK*\u0011Q,Q\u0001\u000bG>dG.Z2uS>t\u0017BA0[\u0005\ri\u0015\r\u001d\t\u0003C&l\u0011A\u0019\u0006\u0003G\u0012\faaY8n[>t'B\u0001\u0016f\u0015\t1w-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0006\u0019qN]4\n\u0005)\u0014'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003]1L!!\\\u0014\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\u00069\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7\u000fI\u0001\u0013Y\u0006$Xm\u001d;Fa>\u001c\u0007\u000eR3gCVdG/F\u0001r!\r\u0001%oP\u0005\u0003g\u0006\u0013aa\u00149uS>t\u0017A\u00067bi\u0016\u001cH/\u00129pG\"$UMZ1vYR|F%Z9\u0015\u0005YL\bC\u0001!x\u0013\tA\u0018I\u0001\u0003V]&$\bb\u0002>\u0010\u0003\u0003\u0005\r!]\u0001\u0004q\u0012\n\u0014a\u00057bi\u0016\u001cH/\u00129pG\"$UMZ1vYR\u0004\u0013aD:fiJ+\u0007\u000f\\5dCN#\u0018\r^3\u0015\tYt\u0018\u0011\u0001\u0005\u0006\u007fF\u0001\r\u0001Y\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\u0019!\u0005a\u0001W\u0006)1\u000f^1uK\u0006)\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,GcA6\u0002\n!)qP\u0005a\u0001A\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$b!a\u0004\u0002\u0018\u0005\u0015\u0002#BA\t\u0003'\u0001W\"\u0001/\n\u0007\u0005UALA\u0002TKRDq!!\u0007\u0014\u0001\u0004\tY\"\u0001\nj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\u001c\bcBA\t\u0003;\u0001\u0017qD\u0005\u0003?r\u00032ALA\u0011\u0013\r\t\u0019c\n\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0007bBA\u0014'\u0001\u0007\u0011\u0011F\u0001\u0010M>\u00148-\u001a+sk:\u001c\u0017\r^5p]B\u0019\u0001)a\u000b\n\u0007\u00055\u0012IA\u0004C_>dW-\u00198\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b))\t\u0019$!\u0013\u0002L\u0005U\u0013\u0011\f\t\u0005\u0001J\f)\u0004\u0005\u0003\u00028\u0005\u0015SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u00071|wM\u0003\u0003\u0002@\u0005\u0005\u0013!C5oi\u0016\u0014h.\u00197t\u0015\r\t\u0019\u0005Z\u0001\bgR|'/Y4f\u0013\u0011\t9%!\u000f\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u0015yH\u00031\u0001a\u0011\u001d\ti\u0005\u0006a\u0001\u0003\u001f\n1BZ3uG\"|eMZ:fiB\u0019\u0001)!\u0015\n\u0007\u0005M\u0013I\u0001\u0003M_:<\u0007BBA,)\u0001\u0007q(A\u000bmK\u0006$WM]#q_\u000eDgi\u001c:SKBd\u0017nY1\t\u000f\u0005mC\u00031\u0001\u0002^\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004B!a\u0018\u0002b5\t\u0001!C\u0002\u0002d=\u0012\u0011BR3uG\"$\u0015\r^1\u0002;!\f7\u000fS5hQ\u0016\u0014\b+\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"$b!!\u000b\u0002j\u0005e\u0004bBA6+\u0001\u0007\u0011QN\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111\u000f2\u0002\rI,7m\u001c:e\u0013\u0011\t9(!\u001d\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\u0007\u0003w*\u0002\u0019A \u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\tiJ,hnY1uKR)a/!!\u0002\u0004\")qP\u0006a\u0001A\"9\u0011Q\u0011\fA\u0002\u0005\u001d\u0015a\u0004;sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0011\u00079\nI)C\u0002\u0002\f\u001e\u0012Qc\u00144gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X-A\fueVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;BiR)a/!%\u0002\u0014\")qp\u0006a\u0001A\"9\u0011QS\fA\u0002\u0005=\u0013AB8gMN,G/A\u0006mCR,7\u000f^#q_\u000eDGcA9\u0002\u001c\")q\u0010\u0007a\u0001A\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0003BA(\u0003CCQa`\rA\u0002\u0001\fA\u0002\\8h\u000b:$wJ\u001a4tKR$B!a\u0014\u0002(\")qP\u0007a\u0001A\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u00055\u00161XA_!\u0011\u0001%/a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1aYA[\u0015\tAC-\u0003\u0003\u0002:\u0006M&AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\u0006\u007fn\u0001\r\u0001\u0019\u0005\u0007\u0003\u007f[\u0002\u0019A \u0002\u000b\u0015\u0004xn\u00195\u0002-Y,'/\u001b4z\u0019\u0006\u001cHOR3uG\",G-\u00129pG\"$RA^Ac\u0003\u0013Da!a2\u001d\u0001\u0004\u0001\u0017!\u00039beRLG/[8o\u0011\u0019\tY\r\ba\u0001c\u0006iQ\r\u001f9fGR,G-\u00129pG\"\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e+\t\tI#\u0001\u0011jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013!E'pG.4U\r^2iKJ$\u0006N]3bIB\u0011a\u0006I\n\u0004A\u0005e\u0007c\u0001!\u0002\\&\u0019\u0011Q\\!\u0003\r\u0005s\u0017PU3g)\t\t).A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003KT3aPAtW\t\tI\u000f\u0005\u0003\u0002l\u0006UXBAAw\u0015\u0011\ty/!=\u0002\u0013Ut7\r[3dW\u0016$'bAAz\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0018Q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t\u0005!f\u0001&\u0002h\u0002")
public class MockFetcherThread
extends AbstractFetcherThread {
    private final MockLeaderEndPoint mockLeader;
    private final MockTierStateMachine mockTierStateMachine;
    private final int replicaId;
    private final int leaderId;
    private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
    private Option<Object> latestEpochDefault;
    private final boolean isOffsetForLeaderEpochSupported;

    public static FailedPartitions $lessinit$greater$default$6() {
        return new FailedPartitions();
    }

    public static int $lessinit$greater$default$5() {
        return 0;
    }

    public static int $lessinit$greater$default$4() {
        return 1;
    }

    public static int $lessinit$greater$default$3() {
        return 0;
    }

    public MockLeaderEndPoint mockLeader() {
        return this.mockLeader;
    }

    public MockTierStateMachine mockTierStateMachine() {
        return this.mockTierStateMachine;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
        return this.replicaPartitionStates;
    }

    private Option<Object> latestEpochDefault() {
        return this.latestEpochDefault;
    }

    private void latestEpochDefault_$eq(Option<Object> x$1) {
        this.latestEpochDefault = x$1;
    }

    public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
        this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
    }

    public PartitionState replicaPartitionState(TopicPartition topicPartition) {
        return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
        });
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates, boolean forceTruncation) {
        this.latestEpochDefault_$eq((Option<Object>)(forceTruncation ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)0))));
        Set partitions = super.addPartitions(initialFetchStates);
        this.latestEpochDefault_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        return partitions;
    }

    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int leaderEpochForReplica, FetchResponseData.PartitionData partitionData) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        if (this.leader().isTruncationOnFetchSupported() && FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
            throw new IllegalStateException("processPartitionData should not be called for a partition with a diverging epoch.");
        }
        if (fetchOffset != state.logEndOffset()) {
            throw new RuntimeException(new StringBuilder(69).append("Offset mismatch for partition ").append(topicPartition).append(": ").append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString());
        }
        Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala();
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef shallowOffsetOfMaxTimestamp = LongRef.create((long)-1L);
        LongRef lastOffset = LongRef.create((long)state.logEndOffset());
        ObjectRef lastEpoch = ObjectRef.create((Object)OptionalInt.empty());
        BooleanRef skipRemainingBatches = BooleanRef.create((boolean)false);
        batches.foreach((Function1 & Serializable)batch -> {
            MockFetcherThread.$anonfun$processPartitionData$1(this, skipRemainingBatches, leaderEpochForReplica, maxTimestamp, shallowOffsetOfMaxTimestamp, state, lastOffset, lastEpoch, batch);
            return BoxedUnit.UNIT;
        });
        state.logStartOffset_$eq(partitionData.logStartOffset());
        state.highWatermark_$eq(partitionData.highWatermark());
        return new Some((Object)new LogAppendInfo(fetchOffset, lastOffset.elem, (OptionalInt)lastEpoch.elem, maxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordValidationStats.EMPTY, CompressionType.NONE, FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData), BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))));
    }

    private boolean hasHigherPartitionLeaderEpoch(RecordBatch batch, int leaderEpoch) {
        return batch.partitionLeaderEpoch() != -1 && batch.partitionLeaderEpoch() > leaderEpoch;
    }

    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
        state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> state.logStartOffset())));
        state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log().clear();
        if (state.rlmEnabled()) {
            state.localLogStartOffset_$eq(offset);
        } else {
            state.logStartOffset_$eq(offset);
        }
        state.logEndOffset_$eq(offset);
        state.highWatermark_$eq(offset);
    }

    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).log().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partitionLeaderEpoch())).orElse((Function0 & Serializable)() -> this.latestEpochDefault());
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logStartOffset();
    }

    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logEndOffset();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(epoch);
        OffsetForLeaderEpochResponseData.EpochEndOffset result = this.mockLeader().lookupEndOffsetForEpoch(topicPartition, epochData, this.replicaPartitionState(topicPartition));
        if (result.endOffset() == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
    }

    public void verifyLastFetchedEpoch(TopicPartition partition, Option<Object> expectedEpoch) {
        if (this.leader().isTruncationOnFetchSupported()) {
            Assertions.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)this.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
            Assertions.assertEquals(expectedEpoch, (Object)this.fetchState(partition).flatMap((Function1 & Serializable)x$5 -> x$5.lastFetchedEpoch()));
            return;
        }
    }

    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(MockFetcherThread $this, BooleanRef skipRemainingBatches$1, int leaderEpochForReplica$1, LongRef maxTimestamp$1, LongRef shallowOffsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, ObjectRef lastEpoch$1, RecordBatch batch) {
        batch.ensureValid();
        boolean bl = skipRemainingBatches$1.elem = skipRemainingBatches$1.elem || $this.hasHigherPartitionLeaderEpoch(batch, leaderEpochForReplica$1);
        if (skipRemainingBatches$1.elem) {
            $this.info((Function0 & Serializable)() -> new StringBuilder(40).append("Skipping batch ").append(batch).append(" because leader epoch is ").append(leaderEpochForReplica$1).toString());
            return;
        }
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            shallowOffsetOfMaxTimestamp$1.elem = batch.baseOffset();
        }
        state$1.log().append((Object)batch);
        state$1.logEndOffset_$eq(batch.nextOffset());
        lastOffset$1.elem = batch.lastOffset();
        lastEpoch$1.elem = OptionalInt.of(batch.partitionLeaderEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
        return batch.lastOffset() < truncationState$1.offset();
    }

    public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$2) {
        return x$2.lastOffset() + 1L;
    }

    public MockFetcherThread(MockLeaderEndPoint mockLeader, MockTierStateMachine mockTierStateMachine, int replicaId, int leaderId, int fetchBackOffMs, FailedPartitions failedPartitions) {
        this.mockLeader = mockLeader;
        this.mockTierStateMachine = mockTierStateMachine;
        this.replicaId = replicaId;
        this.leaderId = leaderId;
        BrokerTopicStats x$7 = new BrokerTopicStats(false);
        boolean x$8 = true;
        super("mock-fetcher", "mock-fetcher", (LeaderEndPoint)mockLeader, failedPartitions, (TierStateMachine)mockTierStateMachine, fetchBackOffMs, x$8, x$7);
        this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.latestEpochDefault = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        mockTierStateMachine.setFetcher(this);
        this.isOffsetForLeaderEpochSupported = true;
    }
}

