/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.TierStateMachine;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmh\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005\u0002\u0001CQ!\u0015\u0001\u0005\nICQa\u0019\u0001\u0005\u0002\u0001CQ\u0001\u001b\u0001\u0005\u0002\u0001CQA\u001b\u0001\u0005\u0002\u0001CQ\u0001\u001c\u0001\u0005\u0002\u0001CQA\u001c\u0001\u0005\u0002\u0001CQ\u0001\u001d\u0001\u0005\u0002\u0001CQA\u001d\u0001\u0005\nMDq! \u0001\u0012\u0002\u0013%a\u0010C\u0004\u0002\u0014\u0001!I!!\u0006\t\u0013\u0005\u0005\u0003!%A\u0005\n\u0005\r\u0003bBA$\u0001\u0011%\u0011\u0011\n\u0004\u0007\u0003#\u0002A!a\u0015\t\u0015\u0005msB!A!\u0002\u0013\ti\u0006\u0003\u0004<\u001f\u0011\u0005\u0011\u0011\u000e\u0005\u0007\u0003czA\u0011\t!\t\r\u0005Mt\u0002\"\u0011A\u0011\u001d\t)h\u0004C!\u0003oBq!!\u001f\u0010\t\u0003\nY\bC\u0004\u0002$>!\t%!*\t\u000f\u0005mv\u0002\"\u0011\u0002>\"9\u00111Y\b\u0005B\u0005\u0015\u0007bBA~\u001f\u0011\u0005\u0013Q \u0005\n\u0005[y!\u0019!C!\u0005_A\u0001Ba\u000e\u0010A\u0003%!\u0011\u0007\u0005\b\u0005syA\u0011\tB\u001e\r\u0019\u0011\t\u0005\u0001\u0003\u0003D!11(\bC\u0001\u0005\u0017BqAa\u0014\u001e\t\u0003\u0012\tF\u0002\u0004\u0003l\u0001!!Q\u000e\u0005\u000b\u00037\u0002#\u0011!Q\u0001\n\u0005u\u0003B\u0003B;A\t\u0005\t\u0015!\u0003\u0003x!Q!Q\u0010\u0011\u0003\u0002\u0003\u0006IA!\u0012\t\rm\u0002C\u0011\u0001B@\u0011\u001d\u0011I\t\tC)\u0005\u0017CqA!0!\t#\u0012y\fC\u0004\u0003N\u0002\"\tFa4\t\u000f\t]\u0007\u0005\"\u0015\u0003Z\"9!q\u001c\u0011\u0005R\t\u0005\bb\u0002BsA\u0011E#q\u001d\u0005\b\u0005W\u0004C\u0011\u000bBw\u0011%\u00119\u0010\tb\u0001\n#\u0012y\u0003\u0003\u0005\u0003z\u0002\u0002\u000b\u0011\u0002B\u0019\u0005i\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0001\u0014'\u0001\u0004tKJ4XM\u001d\u0006\u0002e\u0005)1.\u00194lC\u000e\u00011C\u0001\u00016!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0010\t\u0003}\u0001i\u0011aL\u0001\u0014G2,\u0017M\\'fiJL7MU3hSN$(/\u001f\u000b\u0002\u0003B\u0011aGQ\u0005\u0003\u0007^\u0012A!\u00168ji\"\u0012!!\u0012\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000b1!\u00199j\u0015\tQ5*A\u0004kkBLG/\u001a:\u000b\u00051k\u0015!\u00026v]&$(\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\u000f\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001d\u001d,G/T3ue&\u001cg+\u00197vKR\u00111K\u0016\t\u0003mQK!!V\u001c\u0003\u0007\u0005s\u0017\u0010C\u0003X\u0007\u0001\u0007\u0001,\u0001\u0003oC6,\u0007CA-a\u001d\tQf\f\u0005\u0002\\o5\tAL\u0003\u0002^g\u00051AH]8pizJ!aX\u001c\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?^\n\u0011\u0004^3ti\u0006#G-\u00118e%\u0016lwN^3QCJ$\u0018\u000e^5p]\"\u0012A!\u001a\t\u0003\r\u001aL!aZ$\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cH/T3ue&\u001cg)Y5mK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD#!B3\u00023Q,7\u000f\u001e#fC\u0012$\u0006N]3bI\u000e{WO\u001c;NKR\u0014\u0018n\u0019\u0015\u0003\r\u0015\fq\u0003^3ti6\u000b\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:)\u0005\u001d)\u0017\u0001\u0006;fgR,\u0005\u0010]1oIRC'/Z1e!>|G\u000e\u000b\u0002\tK\u0006!B/Z:u'\"\u0014\u0018N\\6UQJ,\u0017\r\u001a)p_2D#!C3\u0002)Q,7\u000f\u001e*fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\tE/_>\t\u000bUT\u0001\u0019\u0001<\u0002%\r,(O]3oi\u001a+Go\u00195feNK'0\u001a\t\u0003m]L!\u0001_\u001c\u0003\u0007%sG\u000fC\u0003{\u0015\u0001\u0007a/\u0001\boK^4U\r^2iKJ\u001c\u0016N_3\t\u000fqT\u0001\u0013!a\u0001m\u0006I!M]8lKJtU/\\\u0001\u001fi\u0016\u001cHOU3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7%I\u00164\u0017-\u001e7uIM*\u0012a \u0016\u0004m\u0006\u00051FAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055q'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%5\f7.\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003/\t)$!\u000f\u0002>A1\u0011\u0011DA\u0010\u0003Gi!!a\u0007\u000b\u0007\u0005uq'\u0001\u0006d_2dWm\u0019;j_:LA!!\t\u0002\u001c\t\u00191+\u001a;\u0011\t\u0005\u0015\u0012\u0011G\u0007\u0003\u0003OQA!!\u000b\u0002,\u000511m\\7n_:T1AMA\u0017\u0015\r\ty#T\u0001\u0007CB\f7\r[3\n\t\u0005M\u0012q\u0005\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t9\u0004\u0004a\u0001m\u0006AAo\u001c9jG:+X\u000e\u0003\u0004\u0002<1\u0001\rA^\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\t\u0003\u007fa\u0001\u0013!a\u00011\u0006YAo\u001c9jGB\u0013XMZ5y\u0003qi\u0017m[3U_BL7\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\"!!\u0012+\u0007a\u000b\t!A\u0006hKR\u0014%o\\6fe&#G#\u0002<\u0002L\u0005=\u0003bBA'\u001d\u0001\u0007\u00111E\u0001\u0003iBDQ\u0001 \bA\u0002Y\u0014!#T8dW2+\u0017\rZ3s\u000b:$\u0007k\\5oiN!q\"NA+!\rq\u0014qK\u0005\u0004\u00033z#A\u0004'fC\u0012,'/\u00128e!>Lg\u000e^\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M\u0019\u0002\u000f\rdWo\u001d;fe&!\u0011qMA1\u00059\u0011%o\\6fe\u0016sG\rU8j]R$B!a\u001b\u0002pA\u0019\u0011QN\b\u000e\u0003\u0001Aq!a\u0017\u0012\u0001\u0004\ti&A\u0007j]&$\u0018.\u0019;f\u00072|7/Z\u0001\u0006G2|7/Z\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\t\ti&A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u0002~\u0005-\u0005\u0003CA\r\u0003\u007f\n\u0019#a!\n\t\u0005\u0005\u00151\u0004\u0002\u0004\u001b\u0006\u0004\b\u0003BAC\u0003\u000fk\u0011aD\u0005\u0005\u0003\u0013\u000b9FA\u0005GKR\u001c\u0007\u000eR1uC\"9\u0011QR\u000bA\u0002\u0005=\u0015\u0001\u00044fi\u000eD'+Z9vKN$\b\u0003BAI\u0003;sA!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000b9#\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\tY*!&\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005}\u0015\u0011\u0015\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tY*!&\u0002'\u0019,Go\u00195FCJd\u0017.Z:u\u001f\u001a47/\u001a;\u0015\r\u0005\u001d\u00161WA\\!\u0011\tI+a,\u000e\u0005\u0005-&\u0002BA\u0015\u0003[S1\u0001MA\u0016\u0013\u0011\t\t,a+\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"9\u0011Q\u0017\fA\u0002\u0005\r\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003s3\u0002\u0019\u0001<\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[\u0001\u0012M\u0016$8\r\u001b'bi\u0016\u001cHo\u00144gg\u0016$HCBAT\u0003\u007f\u000b\t\rC\u0004\u00026^\u0001\r!a\t\t\r\u0005ev\u00031\u0001w\u0003Q1W\r^2i\u000bB|7\r[#oI>3gm]3ugR!\u0011qYAx!!\tI\"a \u0002$\u0005%\u0007\u0003BAf\u0003StA!!4\u0002d:!\u0011qZAp\u001d\u0011\t\t.!8\u000f\t\u0005M\u00171\u001c\b\u0005\u0003+\fIND\u0002\\\u0003/L\u0011AT\u0005\u0004\u0003_i\u0015b\u0001\u001a\u0002.%!\u0011\u0011FA\u0016\u0013\u0011\t\t/a\n\u0002\u000f5,7o]1hK&!\u0011Q]At\u0003\u0001zeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+7\u000f]8og\u0016$\u0015\r^1\u000b\t\u0005\u0005\u0018qE\u0005\u0005\u0003W\fiO\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\u000b\t\u0005\u0015\u0018q\u001d\u0005\b\u0003cD\u0002\u0019AAz\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\t\u00033\ty(a\t\u0002vB!\u0011QQA|\u0013\u0011\tI0a\u0016\u0003\u0013\u0015\u0003xn\u00195ECR\f\u0017A\u00032vS2$g)\u001a;dQR!\u0011q B\u0011!\u0019\u0011\tAa\u0004\u0003\u00169!!1\u0001B\u0006\u001d\u0011\u0011)A!\u0003\u000f\u0007m\u00139!C\u00013\u0013\t\u0001\u0014'C\u0002\u0003\u000e=\nQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0003\u0012\tM!\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0003\u000e=\u0002RA\u000eB\f\u00057I1A!\u00078\u0005\u0019y\u0005\u000f^5p]B!!\u0011\u0001B\u000f\u0013\u0011\u0011yBa\u0005\u0003\u0019I+\u0007\u000f\\5dC\u001a+Go\u00195\t\u000f\t\r\u0012\u00041\u0001\u0003&\u0005a\u0001/\u0019:uSRLwN\\'baBA\u0011\u0011DA@\u0003G\u00119\u0003E\u0002?\u0005SI1Aa\u000b0\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003qI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012,\"A!\r\u0011\u0007Y\u0012\u0019$C\u0002\u00036]\u0012qAQ8pY\u0016\fg.A\u000fjgR\u0013XO\\2bi&|gn\u00148GKR\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003a1W\r^2i\u000b\u0006\u0014H.[3ti2{7-\u00197PM\u001a\u001cX\r\u001e\u000b\u0007\u0003O\u0013iDa\u0010\t\u000f\u0005UF\u00041\u0001\u0002$!1\u0011\u0011\u0018\u000fA\u0002Y\u0014\u0011%T8dWJ+7/\u001b>f\r\u0016$8\r[3s)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016\u001c2!\bB#!\rq$qI\u0005\u0004\u0005\u0013z#\u0001\u0005+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\t\u0011i\u0005E\u0002\u0002nu\tQa\u001d;beR$\u0002Ba\n\u0003T\tU#\u0011\f\u0005\b\u0003k{\u0002\u0019AA\u0012\u0011\u001d\u00119f\ba\u0001\u0005O\t\u0011cY;se\u0016tGOR3uG\"\u001cF/\u0019;f\u0011\u001d\u0011Yf\ba\u0001\u0005;\n!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB!!q\fB3\u001d\u0011\tiM!\u0019\n\t\t\r\u0014q]\u0001\u0012\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002\u0002B4\u0005S\u0012Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002\u0002B2\u0003O\u0014q\u0003V3tiJ+7/\u001b>f\r\u0016$8\r[3s)\"\u0014X-\u00193\u0014\u0007\u0001\u0012y\u0007E\u0002?\u0005cJ1Aa\u001d0\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0007y\u0012I(C\u0002\u0003|=\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002+\u0019,Go\u00195US\u0016\u00148\u000b^1uK6\u000b7\r[5oKRA!\u0011\u0011BB\u0005\u000b\u00139\tE\u0002\u0002n\u0001Bq!a\u0017%\u0001\u0004\ti\u0006C\u0004\u0003v\u0011\u0002\rAa\u001e\t\u000f\tuD\u00051\u0001\u0003F\u0005!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\"B!$\u0003$\n\u0015&q\u0016BZ!\u00151$q\u0003BH!\u0011\u0011\tJa(\u000e\u0005\tM%\u0002\u0002BK\u0005/\u000b1\u0001\\8h\u0015\u0011\u0011IJa'\u0002\u0013%tG/\u001a:oC2\u001c(\u0002\u0002BO\u0003W\tqa\u001d;pe\u0006<W-\u0003\u0003\u0003\"\nM%!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u00026\u0016\u0002\r!a\t\t\u000f\t\u001dV\u00051\u0001\u0003*\u0006Ya-\u001a;dQ>3gm]3u!\r1$1V\u0005\u0004\u0005[;$\u0001\u0002'p]\u001eDaA!-&\u0001\u00041\u0018\u0001\u00069beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u00036\u0016\u0002\rAa.\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0011ILa/\u000e\u0003\u0001JA!!#\u0003r\u0005AAO];oG\u0006$X\rF\u0003B\u0005\u0003\u0014\u0019\rC\u0004\u00026\u001a\u0002\r!a\t\t\u000f\t\u0015g\u00051\u0001\u0003H\u0006yAO];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002?\u0005\u0013L1Aa30\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\u000b\u0005\u0013\tNa5\t\u000f\u0005Uv\u00051\u0001\u0002$!9!Q[\u0014A\u0002\t%\u0016AB8gMN,G/A\u0006mCR,7\u000f^#q_\u000eDG\u0003\u0002Bn\u0005;\u0004BA\u000eB\fm\"9\u0011Q\u0017\u0015A\u0002\u0005\r\u0012A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0005\u0005S\u0013\u0019\u000fC\u0004\u00026&\u0002\r!a\t\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\t%&\u0011\u001e\u0005\b\u0003kS\u0003\u0019AA\u0012\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0005_\u0014\tPa=\u0011\u000bY\u00129\"a*\t\u000f\u0005U6\u00061\u0001\u0002$!1!Q_\u0016A\u0002Y\fQ!\u001a9pG\"\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e\u0003\u0001J7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\r\u001a\u0011")
public class AbstractFetcherManagerTest {
    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_lastFetchedEpoch;
        void apply_state;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ apply_lag = None$.MODULE$;
        Object var9_10 = null;
        truncating$ = null;
        none$ = null;
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeUpdateTopicIds() {
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_lastFetchedEpoch4;
        void apply_state4;
        void apply_lag2;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        None$ none$ = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$2 = None$.MODULE$;
        None$ apply_topicId = None$.MODULE$;
        Object var16_15 = null;
        none$2 = null;
        truncating$ = null;
        none$ = null;
        None$ none$3 = None$.MODULE$;
        Truncating$ truncating$2 = Truncating$.MODULE$;
        None$ apply_lag3 = None$.MODULE$;
        Object var20_18 = null;
        truncating$2 = null;
        none$3 = null;
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId, fetchOffset, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state4, (Option)apply_lastFetchedEpoch4))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId1, fetchOffset, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3)));
        None$ none$4 = None$.MODULE$;
        Truncating$ truncating$3 = Truncating$.MODULE$;
        None$ none$5 = None$.MODULE$;
        None$ apply_topicId2 = None$.MODULE$;
        Object var23_22 = null;
        none$5 = null;
        truncating$3 = null;
        none$4 = null;
        None$ none$6 = None$.MODULE$;
        Truncating$ truncating$4 = Truncating$.MODULE$;
        None$ apply_lag4 = None$.MODULE$;
        Object var27_25 = null;
        truncating$4 = null;
        none$6 = null;
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)apply_topicId2, fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2))).thenReturn((Object)new Some((Object)new PartitionFetchState((Option)topicId2, fetchOffset, (Option)apply_lag4, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions(), this.$outer.new MockResizeFetcherTierStateMachine());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1);
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1), arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return (Map)Map$.MODULE$.empty();
        }

        public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return (Map)Map$.MODULE$.empty();
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, (Set)Set$.MODULE$.empty());
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class MockResizeFetcherTierStateMachine
    extends TierStateMachine {
        public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
            throw new UnsupportedOperationException("Materializing tier state is not supported in this test.");
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherTierStateMachine$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public MockResizeFetcherTierStateMachine() {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            super(null, null, false);
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, TierStateMachine fetchTierStateMachine) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            MockLeaderEndPoint x$3 = new MockLeaderEndPoint(AbstractFetcherManagerTest.this, sourceBroker);
            BrokerTopicStats x$7 = new BrokerTopicStats(false);
            boolean x$8 = true;
            super("test-resize-fetcher", "mock-fetcher", (LeaderEndPoint)x$3, failedPartitions, fetchTierStateMachine, 0, x$8, x$7);
            this.isOffsetForLeaderEpochSupported = false;
        }
    }
}

