/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.coordinator.group.CoordinatorLoaderImpl;
import kafka.coordinator.group.StringKeyValueDeserializer;
import kafka.log.UnifiedLog;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.group.runtime.Deserializer;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQa\u000e\u0001\u0005\u0002\u0019BQ!\u000f\u0001\u0005\u0002\u0019BQa\u000f\u0001\u0005\u0002\u0019BQ!\u0010\u0001\u0005\u0002\u0019BQa\u0010\u0001\u0005\u0002\u0019BQ!\u0011\u0001\u0005\u0002\u0019BQa\u0011\u0001\u0005\u0002\u0019BQ!\u0012\u0001\u0005\u0002\u0019BQa\u0012\u0001\u0005\u0002\u0019BQ!\u0013\u0001\u0005\u0002\u0019BQa\u0013\u0001\u0005\u0002\u0019BQ!\u0014\u0001\u0005\n9CqA \u0001\u0012\u0002\u0013%q\u0010C\u0005\u0002\u0016\u0001\t\n\u0011\"\u0003\u0002\u0018!1Q\n\u0001C\u0005\u00037\u0011\u0011dQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ3s\u00136\u0004H\u000eV3ti*\u0011A#F\u0001\u0006OJ|W\u000f\u001d\u0006\u0003-]\t1bY8pe\u0012Lg.\u0019;pe*\t\u0001$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002'\u0005AB/Z:u\u001d>tW\r_5ti\u0016tG\u000fU1si&$\u0018n\u001c8\u0015\u0003\u001d\u0002\"\u0001\b\u0015\n\u0005%j\"\u0001B+oSRD#AA\u0016\u0011\u00051*T\"A\u0017\u000b\u00059z\u0013aA1qS*\u0011\u0001'M\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00114'A\u0003kk:LGOC\u00015\u0003\ry'oZ\u0005\u0003m5\u0012A\u0001V3ti\u0006yB/Z:u\u0019>\fG-\u001b8h\u0013N\u0014VM[3di\u0016$w\u000b[3o\u00072|7/\u001a3)\u0005\rY\u0013a\u0003;fgRdu.\u00193j]\u001eD#\u0001B\u0016\u00029Q,7\u000f\u001e'pC\u0012LgnZ*u_B\u0004X\rZ,iK:\u001cEn\\:fI\"\u0012QaK\u0001 i\u0016\u001cH/\u00168l]><hNU3d_J$G+\u001f9f\u0003J,\u0017j\u001a8pe\u0016$\u0007F\u0001\u0004,\u0003\u001d\"Xm\u001d;EKN,'/[1mSj\fG/[8o\u000bJ\u0014xN\u001d$bS2\u001cH\u000b[3M_\u0006$\u0017N\\4)\u0005\u001dY\u0013a\n;fgRdu.\u00193He>,\b/\u00118e\u001f\u001a47/\u001a;t/&$\bnQ8seV\u0004H/\u001a3M_\u001eD#\u0001C\u0016\u0002\u001fQ,7\u000f\u001e'pC\u0012\u001cV/\\7befD#!C\u0016\u0002QQ,7\u000f^+qI\u0006$X\rT1ti^\u0013\u0018\u000e\u001e;f]>3gm]3u\u001f:\u0014\u0015\r^2i\u0019>\fG-\u001a3)\u0005)Y\u0013\u0001\u0012;fgR,\u0006\u000fZ1uK2\u000b7\u000f^,sSR$XM\\(gMN,G/\u00118e+B$\u0017\r^3MCN$8i\\7nSR$X\rZ(gMN,GOT8SK\u000e|'\u000fZ:SK\u0006$\u0007FA\u0006,\u0003}\"Xm\u001d;Va\u0012\fG/\u001a'bgR<&/\u001b;uK:|eMZ:fi>s')\u0019;dQ2{\u0017\rZ3e/\"LG.\u001a%jO\"<\u0016\r^3s[\u0006\u00148.\u00115fC\u0012D#\u0001D\u0016\u0002EQ,7\u000f\u001e)beRLG/[8o\u000f>,7o\u00144gY&tW\rR;sS:<Gj\\1eQ\ti1&A\u0007m_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u000b\u0006\u001fr\u000b7\r\u001b\t\u0003!jk\u0011!\u0015\u0006\u0003%N\u000b1\u0001\\8h\u0015\t!V+A\u0005j]R,'O\\1mg*\u0011akV\u0001\bgR|'/Y4f\u0015\tA\u0002L\u0003\u0002Zg\u00051\u0011\r]1dQ\u0016L!aW)\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u0015if\u00021\u0001_\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0011\u0005qy\u0016B\u00011\u001e\u0005\u0011auN\\4\t\u000f\tt\u0001\u0013!a\u0001=\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\u0011t\u0001\u0013!a\u0001K\u0006i\u0001O]8ek\u000e,'/\u00129pG\"\u0004\"\u0001\b4\n\u0005\u001dl\"!B*i_J$\b\"B5\u000f\u0001\u0004Q\u0017a\u0002:fG>\u0014Hm\u001d\t\u0004WN4hB\u00017r\u001d\ti\u0007/D\u0001o\u0015\ty\u0017$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011!/H\u0001\ba\u0006\u001c7.Y4f\u0013\t!XOA\u0002TKFT!A]\u000f\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018A\u0002:fG>\u0014HM\u0003\u0002|/\u000611m\\7n_:L!! =\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\u0002/1|wMU3bIJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u0012TCAA\u0001U\rq\u00161A\u0016\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0005v]\u000eDWmY6fI*\u0019\u0011qB\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0005%!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069Bn\\4SK\u0006$'+Z:vYR$C-\u001a4bk2$HeM\u000b\u0003\u00033Q3!ZA\u0002)%y\u0015QDA\u0010\u0003C\t\u0019\u0003C\u0003^#\u0001\u0007a\fC\u0003c#\u0001\u0007a\fC\u0003e#\u0001\u0007Q\rC\u0004\u0002&E\u0001\r!a\n\u0002#\r|g\u000e\u001e:pYJ+7m\u001c:e)f\u0004X\rE\u0002x\u0003SI1!a\u000by\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0015\b\u0001\u0005=\u0012QGA\u001c!\ra\u0013\u0011G\u0005\u0004\u0003gi#a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002y\u0001")
public class CoordinatorLoaderImplTest {
    @Test
    public void testNonexistentPartition() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Deserializer serde = (Deserializer)Mockito.mock(Deserializer.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, serde, 1000), (Function1 & Serializable)loader -> {
            Mockito.when((Object)replicaManager.getLog(tp)).thenReturn((Object)None$.MODULE$);
            return (NotLeaderOrFollowerException)TestUtils.assertFutureThrows((Future)loader.load(tp, coordinator), NotLeaderOrFollowerException.class);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadingIsRejectedWhenClosed() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Deserializer serde = (Deserializer)Mockito.mock(Deserializer.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, serde, 1000), (Function1 & Serializable)loader -> {
            loader.close();
            return (RuntimeException)TestUtils.assertFutureThrows((Future)loader.load(tp, coordinator), RuntimeException.class);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoading() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoading$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadingStoppedWhenClosed() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoadingStoppedWhenClosed$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUnknownRecordTypeAreIgnored() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUnknownRecordTypeAreIgnored$1(this, replicaManager, tp, log, serde, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDeserializationErrorFailsTheLoading() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testDeserializationErrorFailsTheLoading$1(this, replicaManager, tp, log, serde, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadGroupAndOffsetsWithCorruptedLog() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = (StringKeyValueDeserializer)Mockito.mock(StringKeyValueDeserializer.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testLoadSummary() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        MockTime time = new MockTime();
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl((Time)time, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testLoadSummary$1(this, time, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetOnBatchLoaded() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetOnBatchLoaded$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetAndUpdateLastCommittedOffsetNoRecordsRead() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetAndUpdateLastCommittedOffsetNoRecordsRead$1(replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testUpdateLastWrittenOffsetOnBatchLoadedWhileHighWatermarkAhead() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            CoordinatorLoaderImplTest.$anonfun$testUpdateLastWrittenOffsetOnBatchLoadedWhileHighWatermarkAhead$1(this, replicaManager, tp, log, coordinator, loader);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testPartitionGoesOfflineDuringLoad() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        StringKeyValueDeserializer serde = new StringKeyValueDeserializer();
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        CoordinatorPlayback coordinator = (CoordinatorPlayback)Mockito.mock(CoordinatorPlayback.class);
        Using$.MODULE$.resource((Object)new CoordinatorLoaderImpl(Time.SYSTEM, replicaManager, (Deserializer)serde, 1000), (Function1 & Serializable)loader -> {
            Mockito.when((Object)replicaManager.getLog(tp)).thenReturn((Object)new Some((Object)log));
            Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
            Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
            Mockito.when((Object)replicaManager.getLogEndOffset(tp)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)5L))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
            .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
            long x$3 = -1L;
            short x$4 = -1;
            FetchDataInfo readResult1 = this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
            Mockito.when((Object)log.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
            .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
            long x$7 = -1L;
            short x$8 = -1;
            FetchDataInfo readResult2 = this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
            Mockito.when((Object)log.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
            return (NotLeaderOrFollowerException)TestUtils.assertFutureThrows((Future)loader.load(tp, coordinator), NotLeaderOrFollowerException.class);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private FetchDataInfo logReadResult(long startOffset, long producerId, short producerEpoch, Seq<SimpleRecord> records) {
        MemoryRecords memoryRecords;
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        if (producerId == -1L) {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            NoCompression withRecords_compression = Compression.NONE;
            TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
            memoryRecords = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            Object var16_8 = null;
            Object var10_7 = null;
            simpleRecordArray = null;
        } else {
            void withTransactionalRecords_records;
            void withTransactionalRecords_partitionLeaderEpoch;
            void withTransactionalRecords_baseSequence;
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            int n = -1;
            boolean bl = false;
            NoCompression withTransactionalRecords_compression = Compression.NONE;
            memoryRecords = MemoryRecords.withRecords((byte)2, (long)startOffset, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)withTransactionalRecords_partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
            Object var12_12 = null;
            simpleRecordArray = null;
        }
        MemoryRecords memoryRecords2 = memoryRecords;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecords.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)memoryRecords2.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecords.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(memoryRecords2.buffer().duplicate());
            return buffer.flip();
        });
        return new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecords);
    }

    private FetchDataInfo logReadResult(long startOffset, long producerId, short producerEpoch, ControlRecordType controlRecordType) {
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        MemoryRecords memoryRecords = MemoryRecords.withEndTransactionMarker((long)startOffset, (long)0L, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(controlRecordType, 0));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)fileRecords.sizeInBytes())).thenReturn((Object)BoxesRunTime.boxToInteger((int)memoryRecords.sizeInBytes()));
        ArgumentCaptor bufferCapture = ArgumentCaptor.forClass(ByteBuffer.class);
        fileRecords.readInto((ByteBuffer)bufferCapture.capture(), ArgumentMatchers.anyInt());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            ByteBuffer buffer = (ByteBuffer)bufferCapture.getValue();
            buffer.put(memoryRecords.buffer().duplicate());
            return buffer.flip();
        });
        return new FetchDataInfo(new LogOffsetMetadata(startOffset), (Records)fileRecords);
    }

    private long logReadResult$default$2() {
        return -1L;
    }

    private short logReadResult$default$3() {
        return -1;
    }

    public static final /* synthetic */ void $anonfun$testLoading$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$2, TopicPartition tp$3, UnifiedLog log$1, CoordinatorPlayback coordinator$3, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$2.getLog(tp$3)).thenReturn((Object)new Some((Object)log$1));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$1.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$2.getLogEndOffset(tp$3)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)9L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$1.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$1.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$1.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        FetchDataInfo readResult3 = $this.logReadResult(5L, 100L, (short)5, (Seq<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$)));
        Mockito.when((Object)log$1.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        FetchDataInfo readResult4 = $this.logReadResult(7L, 100L, (short)5, ControlRecordType.COMMIT);
        Mockito.when((Object)log$1.read(7L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult4);
        FetchDataInfo readResult5 = $this.logReadResult(8L, 500L, (short)10, ControlRecordType.ABORT);
        Mockito.when((Object)log$1.read(8L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult5);
        Assertions.assertNotNull(loader.load(tp$3, coordinator$3).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(5L, 100L, (short)5, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replay(6L, 100L, (short)5, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replayEndTransactionMarker(100L, (short)5, TransactionResult.COMMIT);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).replayEndTransactionMarker(500L, (short)10, TransactionResult.ABORT);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastWrittenOffset(Predef$.MODULE$.long2Long(8L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$3)).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
    }

    public static final /* synthetic */ void $anonfun$testLoadingStoppedWhenClosed$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$3, TopicPartition tp$4, UnifiedLog log$2, CoordinatorPlayback coordinator$4, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$3.getLog(tp$4)).thenReturn((Object)new Some((Object)log$2));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$2.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$3.getLogEndOffset(tp$4)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)100L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)log$2.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)1000), (FetchIsolation)ArgumentMatchers.eq((Object)FetchIsolation.LOG_END), ArgumentMatchers.eq((boolean)true))).thenAnswer(x$1 -> {
            latch.countDown();
            return readResult;
        });
        CompletableFuture result = loader.load(tp$4, coordinator$4);
        latch.await(10L, TimeUnit.SECONDS);
        loader.close();
        RuntimeException ex = (RuntimeException)TestUtils.assertFutureThrows((Future)result, RuntimeException.class);
        Assertions.assertEquals((Object)"Coordinator loader is closed.", (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testUnknownRecordTypeAreIgnored$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$4, TopicPartition tp$5, UnifiedLog log$3, StringKeyValueDeserializer serde$1, CoordinatorPlayback coordinator$5, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$4.getLog(tp$5)).thenReturn((Object)new Some((Object)log$3));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$3.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$4.getLogEndOffset(tp$5)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$3.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Mockito.when(serde$1.deserialize((ByteBuffer)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new CoordinatorLoader.UnknownRecordTypeException(1)}).thenReturn((Object)new Tuple2((Object)"k2", (Object)"v2"));
        loader.load(tp$5, coordinator$5).get(10L, TimeUnit.SECONDS);
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$5)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
    }

    public static final /* synthetic */ void $anonfun$testDeserializationErrorFailsTheLoading$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$5, TopicPartition tp$6, UnifiedLog log$4, StringKeyValueDeserializer serde$2, CoordinatorPlayback coordinator$6, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$5.getLog(tp$6)).thenReturn((Object)new Some((Object)log$4));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$4.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$5.getLogEndOffset(tp$6)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$4.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Mockito.when(serde$2.deserialize((ByteBuffer)ArgumentMatchers.any(), (ByteBuffer)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Error!")});
        RuntimeException ex = (RuntimeException)TestUtils.assertFutureThrows((Future)loader.load(tp$6, coordinator$6), RuntimeException.class);
        Assertions.assertEquals((Object)"Error!", (Object)ex.getMessage());
    }

    public static final /* synthetic */ void $anonfun$testLoadGroupAndOffsetsWithCorruptedLog$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$6, TopicPartition tp$7, UnifiedLog log$5, CoordinatorPlayback coordinator$7, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$6.getLog(tp$7)).thenReturn((Object)new Some((Object)log$5));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$5.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$6.getLogEndOffset(tp$7)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)10L)));
        Nil$ x$2 = Nil$.MODULE$;
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$5.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult);
        Assertions.assertNotNull(loader.load(tp$7, coordinator$7).get(10L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ void $anonfun$testLoadSummary$1(CoordinatorLoaderImplTest $this, MockTime time$1, ReplicaManager replicaManager$7, TopicPartition tp$8, UnifiedLog log$6, CoordinatorPlayback coordinator$8, CoordinatorLoaderImpl loader) {
        long startTimeMs = time$1.milliseconds();
        Mockito.when((Object)replicaManager$7.getLog(tp$8)).thenReturn((Object)new Some((Object)log$6));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$6.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$7.getLogEndOffset(tp$8)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)5L)));
        .colon.colon x$22 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$22);
        Mockito.when((Object)log$6.read(0L, 1000, FetchIsolation.LOG_END, true)).thenAnswer(x$2 -> {
            time$1.sleep(1000L);
            return readResult1;
        });
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$6.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        CoordinatorLoader.LoadSummary summary = (CoordinatorLoader.LoadSummary)loader.load(tp$8, coordinator$8).get(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)startTimeMs, (long)summary.startTimeMs());
        Assertions.assertEquals((long)(startTimeMs + 1000L), (long)summary.endTimeMs());
        Assertions.assertEquals((long)5L, (long)summary.numRecords());
        Assertions.assertEquals((long)(readResult1.records.sizeInBytes() + readResult2.records.sizeInBytes()), (long)summary.numBytes());
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetOnBatchLoaded$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$8, TopicPartition tp$9, UnifiedLog log$7, CoordinatorPlayback coordinator$9, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$8.getLog(tp$9)).thenReturn((Object)new Some((Object)log$7));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$7.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$7.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L)).thenReturn((Object)BoxesRunTime.boxToLong((long)0L)).thenReturn((Object)BoxesRunTime.boxToLong((long)2L));
        Mockito.when((Object)replicaManager$8.getLogEndOffset(tp$9)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)7L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$7.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$7.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        .colon.colon x$10 = new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$));
        long x$11 = -1L;
        short x$12 = -1;
        FetchDataInfo readResult3 = $this.logReadResult(5L, x$11, x$12, (Seq<SimpleRecord>)x$10);
        Mockito.when((Object)log$7.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        Assertions.assertNotNull(loader.load(tp$9, coordinator$9).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(5L, -1L, (short)-1, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9)).replay(6L, -1L, (short)-1, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$9, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(5L));
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetAndUpdateLastCommittedOffsetNoRecordsRead$1(ReplicaManager replicaManager$9, TopicPartition tp$10, UnifiedLog log$8, CoordinatorPlayback coordinator$10, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$9.getLog(tp$10)).thenReturn((Object)new Some((Object)log$8));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$8.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$8.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)replicaManager$9.getLogEndOffset(tp$10)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertNotNull(loader.load(tp$10, coordinator$10).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$10, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(ArgumentMatchers.anyLong()));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$10, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(ArgumentMatchers.anyLong()));
    }

    public static final /* synthetic */ void $anonfun$testUpdateLastWrittenOffsetOnBatchLoadedWhileHighWatermarkAhead$1(CoordinatorLoaderImplTest $this, ReplicaManager replicaManager$10, TopicPartition tp$11, UnifiedLog log$9, CoordinatorPlayback coordinator$11, CoordinatorLoaderImpl loader) {
        Mockito.when((Object)replicaManager$10.getLog(tp$11)).thenReturn((Object)new Some((Object)log$9));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$9.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log$9.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L)).thenReturn((Object)BoxesRunTime.boxToLong((long)7L)).thenReturn((Object)BoxesRunTime.boxToLong((long)7L));
        Mockito.when((Object)replicaManager$10.getLogEndOffset(tp$11)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)7L)));
        .colon.colon x$2 = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        long x$3 = -1L;
        short x$4 = -1;
        FetchDataInfo readResult1 = $this.logReadResult(0L, x$3, x$4, (Seq<SimpleRecord>)x$2);
        Mockito.when((Object)log$9.read(0L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult1);
        .colon.colon x$6 = new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v5".getBytes()), (List)Nil$.MODULE$)));
        long x$7 = -1L;
        short x$8 = -1;
        FetchDataInfo readResult2 = $this.logReadResult(2L, x$7, x$8, (Seq<SimpleRecord>)x$6);
        Mockito.when((Object)log$9.read(2L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult2);
        .colon.colon x$10 = new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v6".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v7".getBytes()), (List)Nil$.MODULE$));
        long x$11 = -1L;
        short x$12 = -1;
        FetchDataInfo readResult3 = $this.logReadResult(5L, x$11, x$12, (Seq<SimpleRecord>)x$10);
        Mockito.when((Object)log$9.read(5L, 1000, FetchIsolation.LOG_END, true)).thenReturn((Object)readResult3);
        Assertions.assertNotNull(loader.load(tp$11, coordinator$11).get(10L, TimeUnit.SECONDS));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(0L, -1L, (short)-1, (Object)new Tuple2((Object)"k1", (Object)"v1"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(1L, -1L, (short)-1, (Object)new Tuple2((Object)"k2", (Object)"v2"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(2L, -1L, (short)-1, (Object)new Tuple2((Object)"k3", (Object)"v3"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(3L, -1L, (short)-1, (Object)new Tuple2((Object)"k4", (Object)"v4"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(4L, -1L, (short)-1, (Object)new Tuple2((Object)"k5", (Object)"v5"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(5L, -1L, (short)-1, (Object)new Tuple2((Object)"k6", (Object)"v6"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11)).replay(6L, -1L, (short)-1, (Object)new Tuple2((Object)"k7", (Object)"v7"));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)1))).updateLastWrittenOffset(Predef$.MODULE$.long2Long(7L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(0L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(2L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)0))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(5L));
        ((CoordinatorPlayback)Mockito.verify((Object)coordinator$11, (VerificationMode)Mockito.times((int)1))).updateLastCommittedOffset(Predef$.MODULE$.long2Long(7L));
    }
}

