/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\f\u0018\u0001qAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005B\u0015BQ\u0001\f\u0001\u0005R5BQa\u000f\u0001\u0005\u0002qBQA\u001c\u0001\u0005\u0002=DQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002qDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0018\u0001\t\u0013\t\t\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBAz\u0001\u0011%\u0011Q\u001f\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\u0011Q\u0002T8h\u001f\u001a47/\u001a;UKN$(B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u00059\u0012B\u0001\u0011\u0018\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001$!\tq\u0002!A\u0006ce>\\WM]\"pk:$X#\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u0007%sG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011a&\r\t\u0003O=J!\u0001\r\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\r\u0001\raM\u0001\u0006aJ|\u0007o\u001d\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA!\u001e;jY*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005)\u0001&o\u001c9feRLWm]\u0001\u001ei\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\r>\u0014XK\\6o_^tGk\u001c9jGR\u0011a&\u0010\u0005\u0006}\u0011\u0001\raP\u0001\u0007cV|'/^7\u0011\u0005\u0001;eBA!F!\t\u0011\u0005&D\u0001D\u0015\t!5$\u0001\u0004=e>|GOP\u0005\u0003\r\"\na\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\u0019\u0019FO]5oO*\u0011a\t\u000b\u0015\u0007\t-su*\u0015*\u0011\u0005\u001db\u0015BA')\u0005)!W\r\u001d:fG\u0006$X\rZ\u0001\b[\u0016\u001c8/Y4fC\u0005\u0001\u0016!\u0006'jgR|eMZ:fiN\u0014V-];fgR\u0004c\u000bM\u0001\u0006g&t7-Z\u0011\u0002'\u0006\u0001\u0001F\u0001\u0003V!\t1v,D\u0001X\u0015\tA\u0016,\u0001\u0004qCJ\fWn\u001d\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002];\u0006)!.\u001e8ji*\ta,A\u0002pe\u001eL!\u0001Y,\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u0005E\"L\u0007CA2g\u001b\u0005!'BA3X\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA4e\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012!\u000e\\\u0011\u0002W\u0006\u0011!p[\u0011\u0002[\u0006)1N]1gi\u0006\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t)\tq\u0003\u000fC\u0003?\u000b\u0001\u0007q\b\u000b\u0004\u0006\u0017:{\u0015K\u0015\u0015\u0003\u000bUCC!\u00022ii2\u0012!\u000e\\\u00017i\u0016\u001cHOR3uG\"|eMZ:fi\nKH+[7fgR\fW\u000e\u001d$pe6\u000b\u0007\u0010V5nKN$\u0018-\u001c9BMR,'\u000f\u0016:v]\u000e\fG/\u001a\u000b\u0003]]DQA\u0010\u0004A\u0002}B#AB+)\t\u0019\u0011\u0007N\u001f\u0017\u0003U2\f\u0001\t^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B4uN]'bqRKW.Z:uC6\u0004x+\u001b;i+:|'\u000fZ3sK\u0012$\u0016.\\3ti\u0006l\u0007o\u001d\u000b\u0003]uDQAP\u0004A\u0002}B#aB+)\u000b\u001d\u0011\u0007.!\u0001-\u0005)d\u0017A\b;fgR<U\r^(gMN,Go\u001d\"fM>\u0014X\rT1uKN$H+[7f)\rq\u0013q\u0001\u0005\u0006}!\u0001\ra\u0010\u0015\u0003\u0011UCS\u0001\u00032i\u0003\u001ba#A\u001b7\u0002/Q,7\u000f^#naRLHj\\4t\u000f\u0016$xJ\u001a4tKR\u001cHc\u0001\u0018\u0002\u0014!)a(\u0003a\u0001\u007f!\u0012\u0011\"\u0016\u0015\u0006\u0013\tD\u0017\u0011\u0004\u0017\u0003U2\fQ\u0007^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B4uN]'bqRKW.Z:uC6\u0004x+\u001b;i\u000b6\u0004H/\u001f'pOR\u0019a&a\b\t\u000byR\u0001\u0019A )\u0005))\u0006&\u0002\u0006cQ\u0006\u0015BF\u00016m\u0003]!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK:{w\u000fF\u0002/\u0003WAQAP\u0006A\u0002}BsaC&O\u0003_\t&+\t\u0002\u00022\u0005AB.Z4bGf4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3)\u0005-)\u0006&B\u0006cQ\u0006]BF\u00016m\u0003\u0001\"Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK\u0016\u000b'\u000f\\5fgR$\u0016.\\3\u0015\u00079\ni\u0004C\u0003?\u0019\u0001\u0007q\bK\u0004\r\u0017:\u000by#\u0015*)\u00051)\u0006&\u0002\u0007cQ\u0006\u0015CF\u00016m\u00035\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8OQ3g_J,w+\u001b;i\u0007\"\fgnZ5oON+w-\\3oiNK'0\u001a\u000b\u0004]\u0005-\u0003\"\u0002 \u000e\u0001\u0004y\u0004FA\u0007VQ\u0015i!\r[A)Y\tQG.\u0001\u0016uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^:\u0015\u00079\n9\u0006C\u0003?\u001d\u0001\u0007q\b\u000b\u0002\u000f+\"*aB\u00195\u0002^1\u0012!\u000e\\\u0001\u0007EJ|7.\u001a:\u0016\u0005\u0005\r\u0004c\u0001\u0010\u0002f%\u0019\u0011qM\f\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u0017g\u0016tG\rT5ti>3gm]3ugJ+\u0017/^3tiR!\u0011QNAB!\u0011\ty'a \u000e\u0005\u0005E$\u0002BA:\u0003k\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0005\u0003o\nI(\u0001\u0004d_6lwN\u001c\u0006\u00045\u0005m$bAA?;\u00061\u0011\r]1dQ\u0016LA!!!\u0002r\t\u0019B*[:u\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\"9\u0011Q\u0011\tA\u0002\u0005\u001d\u0015a\u0002:fcV,7\u000f\u001e\t\u0005\u0003_\nI)\u0003\u0003\u0002\f\u0006E$A\u0005'jgR|eMZ:fiN\u0014V-];fgR\f\u0001c]3oI\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\u0005E\u0015q\u0013\t\u0005\u0003_\n\u0019*\u0003\u0003\u0002\u0016\u0006E$!\u0004$fi\u000eD'+Z:q_:\u001cX\rC\u0004\u0002\u0006F\u0001\r!!'\u0011\t\u0005=\u00141T\u0005\u0005\u0003;\u000b\tH\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\tck&dG\rV1sO\u0016$H+[7fgRA\u00111UAm\u0003K\fy\u000f\u0005\u0004\u0002&\u0006=\u0016Q\u0017\b\u0005\u0003O\u000bYKD\u0002C\u0003SK\u0011!K\u0005\u0004\u0003[C\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003c\u000b\u0019L\u0001\u0003MSN$(bAAWQA!\u0011qWAj\u001d\u0011\tI,!4\u000f\t\u0005m\u00161\u001a\b\u0005\u0003{\u000bIM\u0004\u0003\u0002@\u0006\u001dg\u0002BAa\u0003\u000bt1AQAb\u0013\u0005q\u0016bAA?;&\u0019!$a\u001f\n\t\u0005]\u0014\u0011P\u0005\u0004\u001d\u0006U\u0014\u0002BAh\u0003#\fa\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u001d\u0006U\u0014\u0002BAk\u0003/\u0014\u0001\u0003T5ti>3gm]3ugR{\u0007/[2\u000b\t\u0005=\u0017\u0011\u001b\u0005\b\u00037\u0014\u0002\u0019AAo\u0003\t!\b\u000f\u0005\u0003\u0002`\u0006\u0005XBAA;\u0013\u0011\t\u0019/!\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011q\u001d\nA\u0002\u0005%\u0018!\u0003;j[\u0016\u001cH/Y7q!\r9\u00131^\u0005\u0004\u0003[D#\u0001\u0002'p]\u001eDa!!=\u0013\u0001\u00041\u0013!D7bq:+Xn\u00144gg\u0016$8/A\u0007gS:$\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0003o\u0014)Aa\b\u0011\t\u0005e\u0018q \b\u0005\u0003s\u000bY0\u0003\u0003\u0002~\u0006E\u0017a\u0006'jgR|eMZ:fiN\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011\tAa\u0001\u000391K7\u000f^(gMN,Go\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tK*!\u0011Q`Ai\u0011\u001d\u00119a\u0005a\u0001\u0005\u0013\ta\u0001^8qS\u000e\u001c\bC\u0002B\u0006\u0005+\u0011I\"\u0004\u0002\u0003\u000e)!!q\u0002B\t\u0003\u001diW\u000f^1cY\u0016T1Aa\u0005)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005/\u0011iA\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003s\u0014Y\"\u0003\u0003\u0003\u001e\t\r!\u0001\u0007'jgR|eMZ:fiN$v\u000e]5d%\u0016\u001c\bo\u001c8tK\"9\u00111\\\nA\u0002\u0005u\u0017\u0001F2sK\u0006$X\rV8qS\u000e\fe\u000eZ$fi2{w\r\u0006\u0004\u0003&\tE\"Q\u0007\t\u0005\u0005O\u0011i#\u0004\u0002\u0003*)\u0019!1F\r\u0002\u00071|w-\u0003\u0003\u00030\t%\"AC+oS\u001aLW\r\u001a'pO\"1!1\u0007\u000bA\u0002}\nQ\u0001^8qS\u000eDqAa\u000e\u0015\u0001\u0004\ti.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002+%\u001cH*Z1eKJdunY1m\u001f:\u0014%o\\6feRA!Q\bB\"\u0005\u000b\u0012I\u0005E\u0002(\u0005\u007fI1A!\u0011)\u0005\u001d\u0011un\u001c7fC:DaAa\r\u0016\u0001\u0004y\u0004B\u0002B$+\u0001\u0007a%A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBA0+\u0001\u0007\u00111\r\u0015\b\u0001\t5#\u0011\fB.!\u0011\u0011yE!\u0016\u000e\u0005\tE#b\u0001B*3\u0006\u0019\u0011\r]5\n\t\t]#\u0011\u000b\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\t\tA\u0006")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2()));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$3 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeNow(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$52 = logManager.getOrCreateLog$default$5();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$52);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$5);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$6 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-2L, -4L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
            Seq offsets = log.legacyFetchOffsetsBefore(timestamp, 10);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Leader should be elected");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, timestamp, 10)).asJava()).build();
            Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        java.util.List logSegments = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$)).asJava();
        Mockito.when((Object)log.logSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.logSegments()).thenReturn((Object)new AbstractCollection<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return Arrays.asList(this.logSegment$1).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$7))).get()).partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$8))).get();
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    private boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaBroker broker) {
        return broker.replicaManager().onlinePartition(new TopicPartition(topic, partitionId)).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$isLeaderLocalOnBroker$1(x$9)));
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5(), log$2.appendAsLeader$default$6());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        NoCompression x$4 = Compression.NONE;
        byte x$5 = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, (Compression)x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5(), log$3.appendAsLeader$default$6());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$7) {
        String string = x$7.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$8) {
        return x$8.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ boolean $anonfun$isLeaderLocalOnBroker$1(Partition x$9) {
        return x$9.leaderLogIfLocal().isDefined();
    }
}

