/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote.quota;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import kafka.log.remote.quota.RLMQuotaManager;
import kafka.log.remote.quota.RLMQuotaManagerConfig;
import kafka.server.QuotaType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RLMQuotaManagerTest {
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time);
    private static final QuotaType QUOTA_TYPE = QuotaType.RLMFetch$.MODULE$;
    private static final String DESCRIPTION = "Tracking byte rate";

    @Test
    public void testQuotaExceeded() {
        RLMQuotaManager quotaManager = new RLMQuotaManager(new RLMQuotaManagerConfig(50L, 11, 1), this.metrics, QUOTA_TYPE, DESCRIPTION, (Time)this.time);
        Assertions.assertFalse((boolean)quotaManager.isQuotaExceeded());
        quotaManager.record(500.0);
        this.moveClock(1);
        Assertions.assertTrue((boolean)quotaManager.isQuotaExceeded());
        this.moveClock(8);
        Assertions.assertTrue((boolean)quotaManager.isQuotaExceeded());
        this.moveClock(1);
        Assertions.assertFalse((boolean)quotaManager.isQuotaExceeded());
    }

    @Test
    public void testQuotaUpdate() {
        RLMQuotaManager quotaManager = new RLMQuotaManager(new RLMQuotaManagerConfig(50L, 11, 1), this.metrics, QUOTA_TYPE, DESCRIPTION, (Time)this.time);
        Assertions.assertFalse((boolean)quotaManager.isQuotaExceeded());
        quotaManager.record(51.0);
        Assertions.assertTrue((boolean)quotaManager.isQuotaExceeded());
        Map<MetricName, KafkaMetric> fetchQuotaMetrics = this.metrics.metrics().entrySet().stream().filter(entry -> ((MetricName)entry.getKey()).name().equals("byte-rate") && ((MetricName)entry.getKey()).group().equals(QUOTA_TYPE.toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<MetricName, KafkaMetric> nonQuotaMetrics = this.metrics.metrics().entrySet().stream().filter(entry -> !((MetricName)entry.getKey()).name().equals("byte-rate") || !((MetricName)entry.getKey()).group().equals(QUOTA_TYPE.toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Assertions.assertEquals((int)1, (int)fetchQuotaMetrics.size());
        Assertions.assertFalse((boolean)nonQuotaMetrics.isEmpty());
        Map<MetricName, MetricConfig> configForQuotaMetricsBeforeUpdate = this.extractMetricConfig(fetchQuotaMetrics);
        Map<MetricName, MetricConfig> configForNonQuotaMetricsBeforeUpdate = this.extractMetricConfig(nonQuotaMetrics);
        Quota quota60Bytes = new Quota(60.0, true);
        quotaManager.updateQuota(quota60Bytes);
        Assertions.assertFalse((boolean)quotaManager.isQuotaExceeded());
        Map<MetricName, MetricConfig> configForQuotaMetricsAfterFirstUpdate = this.extractMetricConfig(fetchQuotaMetrics);
        Assertions.assertNotEquals(configForQuotaMetricsBeforeUpdate, configForQuotaMetricsAfterFirstUpdate);
        fetchQuotaMetrics.values().forEach(metric -> Assertions.assertEquals((Object)quota60Bytes, (Object)metric.config().quota()));
        Assertions.assertEquals(configForNonQuotaMetricsBeforeUpdate, this.extractMetricConfig(nonQuotaMetrics));
        Quota quota40Bytes = new Quota(40.0, true);
        quotaManager.updateQuota(quota40Bytes);
        Assertions.assertTrue((boolean)quotaManager.isQuotaExceeded());
        Assertions.assertNotEquals(configForQuotaMetricsAfterFirstUpdate, this.extractMetricConfig(fetchQuotaMetrics));
        fetchQuotaMetrics.values().forEach(metric -> Assertions.assertEquals((Object)quota40Bytes, (Object)metric.config().quota()));
        Assertions.assertEquals(configForNonQuotaMetricsBeforeUpdate, this.extractMetricConfig(nonQuotaMetrics));
    }

    private void moveClock(int secs) {
        this.time.setCurrentTimeMs(this.time.milliseconds() + (long)secs * 1000L);
    }

    private Map<MetricName, MetricConfig> extractMetricConfig(Map<MetricName, KafkaMetric> metrics) {
        return metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((KafkaMetric)entry.getValue()).config()));
    }
}

