/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.admin.ConfigCommand;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.ZkClusterInvocationContext;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.None$;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

@ExtendWith(value={ClusterTestExtensions.class})
@Tag(value="integration")
public class ConfigCommandIntegrationTest {
    AdminZkClient adminZkClient;
    List<String> alterOpts;
    private final ClusterInstance cluster;

    public ConfigCommandIntegrationTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest(types={Type.ZK, Type.KRAFT})
    public void testExitWithNonZeroStatusOnUpdatingUnallowedConfig() {
        ConfigCommandIntegrationTest.assertNonZeroStatusExit(Stream.concat(this.quorumArgs(), Stream.of("--entity-name", this.cluster.isKRaftTest() ? "0" : "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT")), errOut -> Assertions.assertTrue((boolean)errOut.contains("Cannot update these configs dynamically: Set(security.inter.broker.protocol)"), (String)errOut));
    }

    @ClusterTest(types={Type.ZK})
    public void testExitWithNonZeroStatusOnZkCommandAlterUserQuota() {
        ConfigCommandIntegrationTest.assertNonZeroStatusExit(Stream.concat(this.quorumArgs(), Stream.of("--entity-type", "users", "--entity-name", "admin", "--alter", "--add-config", "consumer_byte_rate=20000")), errOut -> Assertions.assertTrue((boolean)errOut.contains("User configuration updates using ZooKeeper are only supported for SCRAM credential updates."), (String)errOut));
    }

    public static void assertNonZeroStatusExit(Stream<String> args, Consumer<String> checkErrOut) {
        AtomicReference exitStatus = new AtomicReference();
        Exit.setExitProcedure((status, __) -> {
            exitStatus.set(status);
            throw new RuntimeException();
        });
        String errOut = ConfigCommandIntegrationTest.captureStandardErr(() -> {
            try {
                ConfigCommand.main((String[])((String[])args.toArray(String[]::new)));
            }
            catch (RuntimeException runtimeException) {
            }
            finally {
                Exit.resetExitProcedure();
            }
        });
        checkErrOut.accept(errOut);
        Assertions.assertNotNull(exitStatus.get());
        Assertions.assertEquals((int)1, (Integer)((Integer)exitStatus.get()));
    }

    private Stream<String> quorumArgs() {
        return this.cluster.isKRaftTest() ? Stream.of("--bootstrap-server", this.cluster.bootstrapServers()) : Stream.of("--zookeeper", ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect());
    }

    public List<String> entityOp(Optional<String> brokerId) {
        return brokerId.map(id -> Arrays.asList("--entity-name", id)).orElse(Collections.singletonList("--entity-default"));
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, java.util.Map<String, String> configs, Optional<String> brokerId) throws Exception {
        this.alterConfigWithZk(zkClient, configs, brokerId, Collections.emptyMap());
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, java.util.Map<String, String> configs, Optional<String> brokerId, java.util.Map<String, String> encoderConfigs) {
        String configStr = Stream.of(configs.entrySet(), encoderConfigs.entrySet()).flatMap(Collection::stream).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(this.alterOpts, this.entityOp(brokerId), Arrays.asList("--add-config", configStr)));
        ConfigCommand.alterConfigWithZk((KafkaZkClient)zkClient, (ConfigCommand.ConfigCommandOptions)addOpts, (AdminZkClient)this.adminZkClient);
    }

    void verifyConfig(KafkaZkClient zkClient, java.util.Map<String, String> configs, Optional<String> brokerId) {
        Properties entityConfigs = zkClient.getEntityConfigs("brokers", brokerId.orElse("<default>"));
        Assertions.assertEquals(configs, (Object)entityConfigs);
    }

    void alterAndVerifyConfig(KafkaZkClient zkClient, java.util.Map<String, String> configs, Optional<String> brokerId) throws Exception {
        this.alterConfigWithZk(zkClient, configs, brokerId);
        this.verifyConfig(zkClient, configs, brokerId);
    }

    void deleteAndVerifyConfig(KafkaZkClient zkClient, Set<String> configNames, Optional<String> brokerId) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions(ConfigCommandIntegrationTest.toArray(this.alterOpts, this.entityOp(brokerId), Arrays.asList("--delete-config", String.join((CharSequence)",", configNames))));
        ConfigCommand.alterConfigWithZk((KafkaZkClient)zkClient, (ConfigCommand.ConfigCommandOptions)deleteOpts, (AdminZkClient)this.adminZkClient);
        this.verifyConfig(zkClient, Collections.emptyMap(), brokerId);
    }

    @ClusterTest(types={Type.ZK})
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() throws Exception {
        this.cluster.shutdownBroker(0);
        String zkConnect = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkConnect();
        KafkaZkClient zkClient = ((ZkClusterInvocationContext.ZkClusterInstance)this.cluster).getUnderlying().zkClient();
        String brokerId = "1";
        this.adminZkClient = new AdminZkClient(zkClient, None$.empty());
        this.alterOpts = Arrays.asList("--zookeeper", zkConnect, "--entity-type", "brokers", "--alter");
        this.alterAndVerifyConfig(zkClient, Collections.singletonMap("message.max.size", "110000"), Optional.of(brokerId));
        this.alterAndVerifyConfig(zkClient, Collections.singletonMap("message.max.size", "120000"), Optional.empty());
        this.alterAndVerifyConfig(zkClient, Collections.singletonMap("message.max.size", "130000"), Optional.of(brokerId));
        this.alterAndVerifyConfig(zkClient, Collections.singletonMap("message.max.size", "140000"), Optional.empty());
        this.deleteAndVerifyConfig(zkClient, Collections.singleton("message.max.size"), Optional.of(brokerId));
        this.deleteAndVerifyConfig(zkClient, Collections.singleton("message.max.size"), Optional.empty());
        this.alterAndVerifyConfig(zkClient, Collections.singletonMap("listener.name.external.ssl.keystore.location", "/tmp/test.jks"), Optional.of(brokerId));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, Collections.singletonMap("ssl.keystore.location", "/tmp/test.jks"), Optional.of(brokerId)));
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, Collections.singletonMap("listener.name.external.ssl.keystore.location", "/tmp/test.jks"), Optional.empty()));
        this.deleteAndVerifyConfig(zkClient, Collections.singleton("listener.name.external.ssl.keystore.location"), Optional.of(brokerId));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk(zkClient, Collections.singletonMap("listener.name.external.ssl.keystore.password", "secret"), Optional.of(brokerId)));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("listener.name.external.ssl.keystore.password", "secret");
        configs.put("log.cleaner.threads", "2");
        java.util.Map<String, String> encoderConfigs = Collections.singletonMap("password.encoder.secret", "encoder-secret");
        this.alterConfigWithZk(zkClient, configs, Optional.of(brokerId), encoderConfigs);
        Properties brokerConfigs = zkClient.getEntityConfigs("brokers", brokerId);
        Assertions.assertFalse((boolean)brokerConfigs.contains("password.encoder.secret"), (String)"Encoder secret stored in ZooKeeper");
        Assertions.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand.createPasswordEncoder((Map)JavaConverters.mapAsScalaMap(encoderConfigs));
        Assertions.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assertions.assertEquals((int)configs.size(), (int)brokerConfigs.size());
        java.util.Map<String, String> configs2 = Collections.singletonMap("listener.name.internal.ssl.keystore.password", "secret2");
        HashMap<String, String> encoderConfigs2 = new HashMap<String, String>();
        encoderConfigs2.put("password.encoder.secret", "encoder-secret");
        encoderConfigs2.put("password.encoder.cipher.algorithm", "DES/CBC/PKCS5Padding");
        encoderConfigs2.put("password.encoder.iterations", "1024");
        encoderConfigs2.put("password.encoder.keyfactory.algorithm", "PBKDF2WithHmacSHA1");
        encoderConfigs2.put("password.encoder.key.length", "64");
        this.alterConfigWithZk(zkClient, configs2, Optional.of(brokerId), encoderConfigs2);
        Properties brokerConfigs2 = zkClient.getEntityConfigs("brokers", brokerId);
        String encodedPassword2 = brokerConfigs2.getProperty("listener.name.internal.ssl.keystore.password");
        Assertions.assertEquals((Object)"secret2", (Object)ConfigCommand.createPasswordEncoder((Map)JavaConverters.mapAsScalaMap(encoderConfigs)).decode(encodedPassword2).value());
        Assertions.assertEquals((Object)"secret2", (Object)ConfigCommand.createPasswordEncoder((Map)JavaConverters.mapAsScalaMap(encoderConfigs2)).decode(encodedPassword2).value());
        Assertions.assertThrows(ConfigException.class, () -> this.alterConfigWithZk(zkClient, configs, Optional.empty(), encoderConfigs));
        this.registerBrokerInZk(zkClient, Integer.parseInt(brokerId));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk(zkClient, Collections.singletonMap("message.max.size", "210000"), Optional.of(brokerId)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.alterConfigWithZk(zkClient, Collections.singletonMap("message.max.size", "220000"), Optional.empty()));
        this.alterAndVerifyConfig(zkClient, Collections.singletonMap("message.max.size", "230000"), Optional.of("2"));
    }

    private void registerBrokerInZk(KafkaZkClient zkClient, int id) {
        zkClient.createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo.apply((Broker)Broker.apply((int)id, ConfigCommandIntegrationTest.seq(endpoint), (Option)None$.empty()), (MetadataVersion)MetadataVersion.latestTesting(), (int)9192);
        zkClient.registerBroker(brokerInfo);
    }

    @SafeVarargs
    static <T> Seq<T> seq(T ... seq) {
        return ConfigCommandIntegrationTest.seq(Arrays.asList(seq));
    }

    static <T> Seq<T> seq(Collection<T> seq) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(seq.iterator()).asScala()).toSeq();
    }

    @SafeVarargs
    public static String[] toArray(List<String> ... lists) {
        return (String[])Stream.of(lists).flatMap(Collection::stream).toArray(String[]::new);
    }

    public static String captureStandardErr(Runnable runnable) {
        return ConfigCommandIntegrationTest.captureStandardStream(true, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String captureStandardStream(boolean isErr, Runnable runnable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream currentStream = isErr ? System.err : System.out;
        PrintStream tempStream = new PrintStream(outputStream);
        if (isErr) {
            System.setErr(tempStream);
        } else {
            System.setOut(tempStream);
        }
        try {
            runnable.run();
            String string = outputStream.toString().trim();
            return string;
        }
        finally {
            if (isErr) {
                System.setErr(currentStream);
            } else {
                System.setOut(currentStream);
            }
            tempStream.close();
        }
    }
}

