/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\rb\u0001B#G\u0001-CQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001A\u0002\u0013\u0005Q\fC\u0004p\u0001\u0001\u0007I\u0011\u00019\t\r]\u0004\u0001\u0015)\u0003_\u0011\u001dA\bA1A\u0005\neDq!a\u0005\u0001A\u0003%!\u0010C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003\u0002\u0018!A\u0011\u0011\u0006\u0001!\u0002\u0013\tI\u0002C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002.!A\u0011\u0011\t\u0001!\u0002\u0013\ty\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011\u0011\u000b\u0001!\u0002\u0013\t9\u0005C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u00111\r\u0001!\u0002\u0013\t9\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u00111\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002n\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002h!A\u00111\u000f\u0001!\u0002\u0013\tI\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000f\u0001!\u0002\u0013\tI\u0007C\u0005\u0002z\u0001\u0011\r\u0011\"\u0003\u0002h!A\u00111\u0010\u0001!\u0002\u0013\tI\u0007C\u0005\u0002~\u0001\u0011\r\u0011\"\u0003\u0002\u0000!A\u00111\u0014\u0001!\u0002\u0013\t\t\tC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0003\u0002 \"A\u0011q\u0017\u0001!\u0002\u0013\t\t\u000bC\u0004\u0002:\u0002!I!a/\t\u0013\u0005E\u0007!%A\u0005\n\u0005M\u0007\"CAu\u0001\t\u0007I\u0011BAv\u0011!\ti\u000f\u0001Q\u0001\n\u0005u\u0006\"CAx\u0001\t\u0007I\u0011BAy\u0011!\tI\u0010\u0001Q\u0001\n\u0005M\bbCA~\u0001\u0001\u0007\t\u0019!C\u0005\u0003{D1Ba\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u000e!Y!\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0000\u0011-\u0011\u0019\u0002\u0001a\u0001\u0002\u0004%IA!\u0006\t\u0017\t]\u0001\u00011AA\u0002\u0013%!\u0011\u0004\u0005\f\u0005;\u0001\u0001\u0019!A!B\u0013\t)\nC\u0006\u0003 \u0001\u0001\r\u00111A\u0005\n\tU\u0001b\u0003B\u0011\u0001\u0001\u0007\t\u0019!C\u0005\u0005GA1Ba\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0016\"9!\u0011\u0006\u0001\u0005B\t-\u0002b\u0002B'\u0001\u0011\u0005#q\n\u0005\b\u00053\u0002A\u0011\u0001B(\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005\u001fBqAa\u001a\u0001\t\u0013\u0011I\u0007C\u0005\u0003\u0002\u0002\t\n\u0011\"\u0003\u0003\u0004\"9!q\u0011\u0001\u0005\n\t%\u0005b\u0002BI\u0001\u0011%!1\u0013\u0005\b\u00053\u0003A\u0011\u0002BN\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005\u001fBqA!-\u0001\t\u0003\u0011y\u0005C\u0004\u00036\u0002!\tAa\u0014\t\u000f\te\u0006\u0001\"\u0003\u0003<\"9!q\u0018\u0001\u0005\u0002\t=\u0003b\u0002Bb\u0001\u0011\u0005!q\n\u0005\b\u0005\u000f\u0004A\u0011\u0002Be\u0011\u001d\u0011i\r\u0001C\u0001\u0005\u001fBqA!5\u0001\t\u0003\u0011y\u0005C\u0004\u0003V\u0002!IAa6\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"9!1\u001f\u0001\u0005\n\tU\bb\u0002B}\u0001\u0011%!1 \u0005\b\u0007/\u0001A\u0011BB\r\u00059\t5\r\\\"p[6\fg\u000e\u001a+fgRT!a\u0012%\u0002\u000b\u0005$W.\u001b8\u000b\u0003%\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0019J\u0003\"!\u0014)\u000e\u00039S!a\u0014%\u0002\rM,'O^3s\u0013\t\tfJA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\u0004\"a\u0015,\u000e\u0003QS!!\u0016%\u0002\u000bU$\u0018\u000e\\:\n\u0005]#&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0003\"a\u0017\u0001\u000e\u0003\u0019\u000bqa]3sm\u0016\u00148/F\u0001_!\ry\u0016\u000e\u001c\b\u0003A\u001at!!\u00193\u000e\u0003\tT!a\u0019&\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0017!B:dC2\f\u0017BA4i\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!Z\u0005\u0003U.\u00141aU3r\u0015\t9\u0007\u000e\u0005\u0002N[&\u0011aN\u0014\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHCA9v!\t\u00118/D\u0001i\u0013\t!\bN\u0001\u0003V]&$\bb\u0002<\u0004\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014\u0001C:feZ,'o\u001d\u0011\u0002\u0013A\u0014\u0018N\\2ja\u0006dW#\u0001>\u0011\u0007m\fy!D\u0001}\u0015\tih0\u0001\u0003bkRD'bA@\u0002\u0002\u0005A1/Z2ve&$\u0018P\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB2p[6|gNC\u0002J\u0003\u000fQA!!\u0003\u0002\f\u00051\u0011\r]1dQ\u0016T!!!\u0004\u0002\u0007=\u0014x-C\u0002\u0002\u0012q\u0014abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\u0006qe&t7-\u001b9bY\u0002\nQ!V:feN,\"!!\u0007\u0011\u000b\u0005m\u0011Q\u0005>\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005\r\u0002.\u0001\u0006d_2dWm\u0019;j_:LA!a\n\u0002\u001e\t\u00191+\u001a;\u0002\rU\u001bXM]:!\u0003\u0015Aun\u001d;t+\t\ty\u0003\u0005\u0004\u0002\u001c\u0005\u0015\u0012\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0012\u0001\u00026bm\u0006LA!a\u0010\u00026\t11\u000b\u001e:j]\u001e\fa\u0001S8tiN\u0004\u0013\u0001E!mY><\bj\\:u\u0007>lW.\u00198e+\t\t9\u0005E\u0003s\u0003\u0013\n\t$C\u0002\u0002L!\u0014Q!\u0011:sCf\f\u0011#\u00117m_^Dun\u001d;D_6l\u0017M\u001c3!\u0003=!UM\\=I_N$8i\\7nC:$\u0017\u0001\u0005#f]fDun\u001d;D_6l\u0017M\u001c3!\u0003=\u0019E.^:uKJ\u0014Vm]8ve\u000e,WCAA,!\u0011\tI&a\u0018\u000e\u0005\u0005m#\u0002BA/\u0003\u0003\t\u0001B]3t_V\u00148-Z\u0005\u0005\u0003C\nYFA\bSKN|WO]2f!\u0006$H/\u001a:o\u0003A\u0019E.^:uKJ\u0014Vm]8ve\u000e,\u0007%\u0001\bU_BL7MU3t_V\u00148-Z:\u0016\u0005\u0005%\u0004CBA\u000e\u0003K\t9&A\bU_BL7MU3t_V\u00148-Z:!\u000399%o\\;q%\u0016\u001cx.\u001e:dKN\fqb\u0012:pkB\u0014Vm]8ve\u000e,7\u000fI\u0001\u0019)J\fgn]1di&|g.\u00197JIJ+7o\\;sG\u0016\u001c\u0018!\u0007+sC:\u001c\u0018m\u0019;j_:\fG.\u00133SKN|WO]2fg\u0002\na\u0002V8lK:\u0014Vm]8ve\u000e,7/A\bU_.,gNU3t_V\u00148-Z:!\u00035)6/\u001a:SKN|WO]2fg\u0006qQk]3s%\u0016\u001cx.\u001e:dKN\u0004\u0013!\u0005*fg>,(oY3U_\u000e{W.\\1oIV\u0011\u0011\u0011\u0011\t\t\u00037\t\u0019)a\"\u0002\u0016&!\u0011QQA\u000f\u0005\ri\u0015\r\u001d\t\u0007\u0003\u0013\u000b\t*a\u0016\u000f\t\u0005-\u0015Q\u0012\t\u0003C\"L1!a$i\u0003\u0019\u0001&/\u001a3fM&!\u0011qEAJ\u0015\r\ty\t\u001b\t\u0006e\u0006%\u0013q\u0013\t\u0005\u0003\u0013\u000bI*\u0003\u0003\u0002@\u0005M\u0015A\u0005*fg>,(oY3U_\u000e{W.\\1oI\u0002\nACU3t_V\u00148-\u001a+p\u001fB,'/\u0019;j_:\u001cXCAAQ!!\tY\"a!\u0002\b\u0006\r\u0006c\u0002:\u0002&\u0006%\u0016QS\u0005\u0004\u0003OC'A\u0002+va2,'\u0007\u0005\u0004\u0002\n\u0006E\u00151\u0016\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*!\u0011\u0011WA\u0001\u0003\r\t7\r\\\u0005\u0005\u0003k\u000byK\u0001\u0007BG2|\u0005/\u001a:bi&|g.A\u000bSKN|WO]2f)>|\u0005/\u001a:bi&|gn\u001d\u0011\u0002-A\u0013x\u000eZ;dKJ\u0014Vm]8ve\u000e,Gk\\!dYN$B!!0\u0002HBA\u00111DAB\u0003\u000f\u000by\f\u0005\u0004\u0002\n\u0006E\u0015\u0011\u0019\t\u0005\u0003[\u000b\u0019-\u0003\u0003\u0002F\u0006=&AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uefD\u0011\"!3 !\u0003\u0005\r!a3\u0002#\u0015t\u0017M\u00197f\u0013\u0012,W\u000e]8uK:\u001cW\rE\u0002s\u0003\u001bL1!a4i\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0005\u0015:pIV\u001cWM\u001d*fg>,(oY3U_\u0006\u001bGn\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001b\u0016\u0005\u0003\u0017\f9n\u000b\u0002\u0002ZB!\u00111\\As\u001b\t\tiN\u0003\u0003\u0002`\u0006\u0005\u0018!C;oG\",7m[3e\u0015\r\t\u0019\u000f[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAt\u0003;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y\u0019uN\\:v[\u0016\u0014(+Z:pkJ\u001cW\rV8BG2\u001cXCAA_\u0003]\u0019uN\\:v[\u0016\u0014(+Z:pkJ\u001cW\rV8BG2\u001c\b%A\nD[\u0012$vNU3t_V\u00148-Z:U_\u0006\u001bG.\u0006\u0002\u0002tBA\u00111DAB\u0003+\u000b)\u0010\u0005\u0005\u0002\n\u0006]\u0018qQA`\u0013\u0011\t))a%\u0002)\rkG\rV8SKN|WO]2fgR{\u0017i\u00197!\u0003-\u0011'o\\6feB\u0013x\u000e]:\u0016\u0005\u0005}\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\t\t\u0015\u0011\u0011H\u0001\u0005kRLG.\u0003\u0003\u0003\n\t\r!A\u0003)s_B,'\u000f^5fg\u0006y!M]8lKJ\u0004&o\u001c9t?\u0012*\u0017\u000fF\u0002r\u0005\u001fA\u0001B\u001e\u0014\u0002\u0002\u0003\u0007\u0011q`\u0001\rEJ|7.\u001a:Qe>\u00048\u000fI\u0001\u0007u.\f%oZ:\u0016\u0005\u0005U\u0015A\u0003>l\u0003J<7o\u0018\u0013fcR\u0019\u0011Oa\u0007\t\u0011YL\u0013\u0011!a\u0001\u0003+\u000bqA_6Be\u001e\u001c\b%A\u0005bI6Lg.\u0011:hg\u0006i\u0011\rZ7j]\u0006\u0013xm]0%KF$2!\u001dB\u0013\u0011!1H&!AA\u0002\u0005U\u0015AC1e[&t\u0017I]4tA\u0005)1/\u001a;VaR\u0019\u0011O!\f\t\u000f\t=b\u00061\u0001\u00032\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u00034\t\u0005SB\u0001B\u001b\u0015\u0011\u00119D!\u000f\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003<\tu\u0012a\u00026va&$XM\u001d\u0006\u0005\u0005\u007f\tY!A\u0003kk:LG/\u0003\u0003\u0003D\tU\"\u0001\u0003+fgRLeNZ8)\u00079\u00129\u0005\u0005\u0003\u00034\t%\u0013\u0002\u0002B&\u0005k\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^tG#A9)\u0007=\u0012\u0019\u0006\u0005\u0003\u00034\tU\u0013\u0002\u0002B,\u0005k\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u00021Q,7\u000f^!dY\u000ec\u0017nV5uQ\u0006+H\u000f[8sSj,'\u000fK\u00021\u0005;\u0002BAa\r\u0003`%!!\u0011\rB\u001b\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f^!dY\u000ec\u0017nV5uQ\u0006#W.\u001b8B!&C3!\rB/\u00031\u0019'/Z1uKN+'O^3s)\r\t(1\u000e\u0005\n\u0005[\u0012\u0004\u0013!a\u0001\u0005_\nQbY8n[\u0006tGmQ8oM&<\u0007#\u0002:\u0003r\tU\u0014b\u0001B:Q\n1q\n\u001d;j_:\u0004BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0005\u0005w\nI$\u0001\u0002j_&!!q\u0010B=\u0005\u00111\u0015\u000e\\3\u0002-\r\u0014X-\u0019;f'\u0016\u0014h/\u001a:%I\u00164\u0017-\u001e7uIE*\"A!\"+\t\t=\u0014q[\u0001\tG\u0006dG.T1j]R!!1\u0012BG!\u001d\u0011\u0018QUAL\u0003/CqAa$5\u0001\u0004\t)*\u0001\u0003be\u001e\u001c\u0018A\u0003;fgR\f5\r\\\"mSR\u0019\u0011O!&\t\u000f\t]U\u00071\u0001\u0002\u0016\u000691-\u001c3Be\u001e\u001c\u0018\u0001F1tg\u0016\u0014HoT;uaV$8i\u001c8uC&t7\u000fF\u0005r\u0005;\u0013\tK!*\u0003*\"9!q\u0014\u001cA\u0002\u0005]\u0015A\u00029sK\u001aL\u0007\u0010C\u0004\u0003$Z\u0002\r!a\"\u0002\u0013I,7o\\;sG\u0016\u001c\bb\u0002BTm\u0001\u0007\u0011QS\u0001\fe\u0016\u001cx.\u001e:dK\u000ekG\rC\u0004\u0003,Z\u0002\r!a&\u0002\r=,H\u000f];u\u0003\u0015\"Xm\u001d;Qe>$WoY3s\u0007>t7/^7fe\u000ec\u0017nV5uQ\u0006+H\u000f[8sSj,'\u000fK\u00028\u0005;\n1\u0005^3tiB\u0013x\u000eZ;dKJ\u001cuN\\:v[\u0016\u00148\t\\5XSRD\u0017\tZ7j]\u0006\u0003\u0016\nK\u00029\u0005;\na\u0003^3ti\u0006\u001bGn\u00117j/&$\bn\u00117jK:$\u0018\n\u001a\u0015\u0004s\tu\u0013a\u0006;fgR\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'o\u00117j)\r\t(Q\u0018\u0005\b\u0005/S\u0004\u0019AAK\u0003%\"Xm\u001d;BG2\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fg^KG\u000f[!vi\"|'/\u001b>fe\"\u001a1H!\u0018\u0002OQ,7\u000f^!dYN|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3t/&$\b.\u00113nS:\f\u0005+\u0013\u0015\u0004y\tu\u0013a\u0007;fgR\f5\r\\:P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,7\u000fF\u0002r\u0005\u0017DqAa&>\u0001\u0004\t)*A\u000fuKN$\u0018J\u001c<bY&$\u0017)\u001e;i_JL'0\u001a:Qe>\u0004XM\u001d;zQ\rq$QL\u0001\u0011i\u0016\u001cH\u000fU1ui\u0016\u0014h\u000eV=qKND3a\u0010B/\u0003)!Xm\u001d;SK6|g/\u001a\u000b\bc\ne'1\u001cBo\u0011\u001d\u00119\n\u0011a\u0001\u0003+CqAa)A\u0001\u0004\t9\tC\u0004\u0003(\u0002\u0003\r!!&\u0002\u001f\u001d,G/Q2m)>\u001cu.\\7b]\u0012$bAa9\u0003f\n=\bc\u0002:\u0002&\u0006}\u0016Q\u0013\u0005\b\u0005O\f\u0005\u0019\u0001Bu\u00039\u0001XM]7jgNLwN\u001c+za\u0016\u0004B!!,\u0003l&!!Q^AX\u0005E\t5\r\u001c)fe6L7o]5p]RK\b/\u001a\u0005\b\u0005c\f\u0005\u0019AAU\u0003)y\u0007/\u001a:bi&|gn]\u0001\u0007O\u0016$8)\u001c3\u0015\t\u0005U%q\u001f\u0005\b\u0005O\u0014\u0005\u0019\u0001Bu\u000399\u0018\u000e\u001e5BkRDwN]5{KJ$\"A!@\u0015\u0007E\u0014y\u0010C\u0004\u0004\u0002\r\u0003\raa\u0001\u0002\u0003\u0019\u0004bA]B\u0003\u0007\u0013\t\u0018bAB\u0004Q\nIa)\u001e8di&|g.\r\t\u0005\u0007\u0017\u0019\u0019\"\u0004\u0002\u0004\u000e)!1qBB\t\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0004\u001f\u0006\u0015\u0011\u0002BB\u000b\u0007\u001b\u0011!\"Q;uQ>\u0014\u0018N_3s\u0003e9'/\u00192D_:\u001cx\u000e\\3PkR\u0004X\u000f^!oI\u0016\u0013(o\u001c:\u0015\t\t-51\u0004\u0005\t\u0007\u0003!E\u00111\u0001\u0004\u001eA!!oa\br\u0013\r\u0019\t\u0003\u001b\u0002\ty\tLh.Y7f}\u0001")
public class AclCommandTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = new String[]{"--allow-host", "host1", "--allow-host", "host2"};
    private final String[] DenyHostCommand = new String[]{"--deny-host", "host1", "--deny-host", "host2"};
    private final ResourcePattern ClusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final Set<ResourcePattern> TopicResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> GroupResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TokenResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> UserResources = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.USER, "User:test-user1", PatternType.LITERAL), new ResourcePattern(ResourceType.USER, "User:test-user2", PatternType.LITERAL)}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, String[]> ResourceToCommand = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.UserResources()), (Object)new String[]{"--user-principal", "User:test-user1", "--user-principal", "User:test-user2"})}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE})), (Object)new String[]{"--operation", "Read", "--operation", "Describe", "--operation", "Delete"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.UserResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS})), (Object)new String[]{"--operation", "CreateTokens", "--operation", "DescribeTokens"}))}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ})), this.Hosts()))}));
    private final scala.collection.immutable.Map<String[], scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), (Object)this.ConsumerResourceToAcls().map((Function1 & Serializable)x0$1 -> {
        if (x0$1 != null) {
            Set k = (Set)x0$1._1();
            Set v = (Set)x0$1._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)this.ProducerResourceToAcls(false).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        }
        throw new MatchError(null);
    })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), (Object)this.ConsumerResourceToAcls().map((Function1 & Serializable)x0$2 -> {
        if (x0$2 != null) {
            Set k = (Set)x0$2._1();
            Set v = (Set)x0$2._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        }
        throw new MatchError(null);
    }))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private ResourcePattern ClusterResource() {
        return this.ClusterResource;
    }

    private Set<ResourcePattern> TopicResources() {
        return this.TopicResources;
    }

    private Set<ResourcePattern> GroupResources() {
        return this.GroupResources;
    }

    private Set<ResourcePattern> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<ResourcePattern> TokenResources() {
        return this.TokenResources;
    }

    private Set<ResourcePattern> UserResources() {
        return this.UserResources;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)AclOperation.IDEMPOTENT_WRITE) : None$.MODULE$}))).flatten(Predef$.MODULE$.$conforms()), this.Hosts()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private scala.collection.immutable.Map<String[], scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.brokerProps().put("authorizer.class.name", AclAuthorizer.class.getName());
        this.brokerProps().put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq(new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()});
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testAclCli(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    private void createServer(Option<File> commandConfig) {
        void createServer_time;
        void createServer_config;
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        boolean createServer_createServer_createServer_startup = true;
        Object var7_5 = null;
        Object var4_4 = null;
        kafkaConfig = null;
        time = null;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false), (List)Nil$.MODULE$));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        Object[] adminArgs = new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)};
        if (commandConfig.isDefined()) {
            adminArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(adminArgs), (Object)new String[]{"--command-config", ((File)commandConfig.get()).getAbsolutePath()}, ClassTag$.MODULE$.apply(String.class));
        }
        this.adminArgs_$eq((String[])adminArgs);
    }

    private Option<File> createServer$default$1() {
        return None$.MODULE$;
    }

    private Tuple2<String, String> callMain(String[] args) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> AclCommand$.MODULE$.main(args);
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> AclCommandTest.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)grabConsoleOutputAndError_out.toString(), (Object)grabConsoleOutputAndError_err.toString());
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCli$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$7 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, String[] resourceCmd, String output) {
        resources.foreach((Function1 & Serializable)resource -> {
            AclCommandTest.$anonfun$assertOutputContains$1(this, resourceCmd, prefix, output, resource);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testProducerConsumerCli(this.adminArgs());
    }

    @Test
    public void testAclCliWithClientId() {
        String tempFile_contents = "client.id=my-client";
        Object var5_1 = null;
        File adminClientConfig = TestUtils.tempFile((String)tempFile_contents);
        this.createServer((Option<File>)new Some((Object)adminClientConfig));
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, Level.WARN);
        try {
            this.testAclCli(this.adminArgs());
        }
        finally {
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, previousLevel);
            LogCaptureAppender$.MODULE$.unregister(appender);
        }
        Assertions.assertFalse((boolean)appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCliWithClientId$1(e))).isDefined(), (String)"There should be no warnings about multiple registration of mbeans");
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$12 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$12);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        void withAuthorizer_fromProps_doLog;
        void withAuthorizer_fromProps_doLog2;
        String[] cmd = new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"};
        this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = this.brokerProps();
        Object var6_4 = null;
        KafkaConfig withAuthorizer_kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog2);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, (Authorizer)withAuthorizer_authZ);
        }
        Object var3_5 = null;
        Object var4_6 = null;
        this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--remove", ClassTag$.MODULE$.apply(String.class))), (Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        boolean bl2 = false;
        Properties withAuthorizer_fromProps_props2 = this.brokerProps();
        Object var11_9 = null;
        KafkaConfig withAuthorizer_kafkaConfig2 = new KafkaConfig((Map)withAuthorizer_fromProps_props2, (boolean)withAuthorizer_fromProps_doLog);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig2.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2((Authorizer)withAuthorizer_authZ);
        }
    }

    @Test
    public void testInvalidAuthorizerProperty() {
        String[] args = new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()};
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(args));
        Assertions.assertThrows(IllegalArgumentException.class, () -> aclCommandService.listAcls());
    }

    @Test
    public void testPatternTypes() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$13) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$13);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var2_1 = null;
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])PatternType.values()), (Function1 & Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testRemove(String[] cmdArgs, Set<ResourcePattern> resources, String[] resourceCmd) {
        void var6_6;
        void var5_5;
        Tuple2<String, String> tuple2 = this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)resourceCmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--remove", ClassTag$.MODULE$.apply(String.class))), (Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String out = (String)tuple2._1();
        String err = (String)tuple2._2();
        Assertions.assertEquals((Object)"", (Object)var5_5);
        Assertions.assertEquals((Object)"", (Object)var6_6);
        resources.foreach((Function1 & Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<AccessControlEntry>, String[]> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts()), (Object)this.getCmd(permissionType));
    }

    private String[] getCmd(AclPermissionType permissionType) {
        AclPermissionType aclPermissionType = permissionType;
        AclPermissionType aclPermissionType2 = AclPermissionType.ALLOW;
        String principalCmd = !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null) ? "--allow-principal" : "--deny-principal";
        AclPermissionType aclPermissionType3 = permissionType;
        AclPermissionType aclPermissionType4 = AclPermissionType.ALLOW;
        String[] cmd2 = !(aclPermissionType3 != null ? !aclPermissionType3.equals(aclPermissionType4) : aclPermissionType4 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable)(cmd, user) -> (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmd), (Object)new String[]{principalCmd, user.toString()}, ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        void fromProps_doLog;
        boolean bl = false;
        Properties fromProps_props = this.brokerProps();
        Object var5_3 = null;
        KafkaConfig kafkaConfig = new KafkaConfig((Map)fromProps_props, (boolean)fromProps_doLog);
        try (AclAuthorizer authZ = new AclAuthorizer();){
            authZ.configure(kafkaConfig.originals());
            f.apply((Object)authZ);
        }
    }

    private Tuple2<String, String> grabConsoleOutputAndError(Function0<BoxedUnit> f) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable)() -> Console$.MODULE$.withErr((OutputStream)err, f));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)out.toString(), (Object)err.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testAclCli$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$4(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        Object var6_4 = null;
        KafkaConfig withAuthorizer_kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, AclPermissionType permissionType) {
        void var14_14;
        void var13_13;
        void var7_7;
        void var11_11;
        void var10_10;
        void var8_8;
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<AclOperation>)((Set)operationToCmd._1()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        Tuple2<String, String> tuple22 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1), (Object)var8_8, ClassTag$.MODULE$.apply(String.class))), (Object)resourceCmd$1, ClassTag$.MODULE$.apply(String.class))), operationToCmd._2(), ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var10_10);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var10_10);
        Assertions.assertEquals((Object)"", (Object)var11_11);
        resources$1.foreach(arg_0 -> AclCommandTest.$anonfun$testAclCli$4$adapted($this, (Set)var7_7, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1), (Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var13_13);
        Assertions.assertEquals((Object)"", (Object)var14_14);
        $this.testRemove(cmdArgs$1, (Set<ResourcePattern>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$7) {
        if (x$7 != null) {
            Set resources = (Set)x$7._1();
            String[] resourceCmd = (String[])x$7._2();
            ((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclPermissionType[]{AclPermissionType.ALLOW, AclPermissionType.DENY}))).foreach((Function1 & Serializable)permissionType -> {
                AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$3(String prefix$1, String resourceType$1, String output$1, String name) {
        String expected = new StringBuilder(75).append(prefix$1).append(" for resource `ResourcePattern(resourceType=").append(resourceType$1).append(", name=").append(name).append(", patternType=LITERAL)`:").toString();
        Assertions.assertTrue((boolean)output$1.contains(expected), (String)new StringBuilder(26).append("Substring ").append(expected).append(" not in output:\n").append(output$1).toString());
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$1(AclCommandTest $this, String[] resourceCmd$2, String prefix$1, String output$1, ResourcePattern resource) {
        Object[] objectArray;
        String resourceType = resource.resourceType().toString();
        if (resource.equals($this.ClusterResource())) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "kafka-cluster";
        } else {
            objectArray = (Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith("--")));
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectArray), (Function1 & Serializable)name -> {
            AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType, output$1, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAclCliWithClientId$1(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        if (!(level != null ? !level.equals(level2) : level2 != null) && e.getThrowableInformation() != null) {
            String string = e.getThrowableInformation().getThrowable().getClass().getName();
            String string2 = InstanceAlreadyExistsException.class.getName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$1(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$4(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$6(AclCommandTest $this, Set acls$2, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        Object var6_4 = null;
        KafkaConfig withAuthorizer_kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$11) {
        if (x$11 != null) {
            Set resources = (Set)x$11._1();
            Set acls = (Set)x$11._2();
            resources.foreach((Function1 & Serializable)resource -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$6($this, acls, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$12) {
        if (x$12 != null) {
            String[] cmd = (String[])x$12._1();
            scala.collection.immutable.Map resourcesToAcls = (scala.collection.immutable.Map)x$12._2();
            Object[] resourceCommand = (String[])((IterableOnceOps)resourcesToAcls.keys().map($this.ResourceToCommand())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable)(x$9, x$10) -> (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])x$9), x$10, ClassTag$.MODULE$.apply(String.class)));
            $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2), (Object)$this.getCmd(AclPermissionType.ALLOW), ClassTag$.MODULE$.apply(String.class))), (Object)resourceCommand, ClassTag$.MODULE$.apply(String.class))), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
            resourcesToAcls.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$4(check$ifrefutable$3))).foreach((Function1 & Serializable)x$11 -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$11);
                return BoxedUnit.UNIT;
            });
            $this.testRemove(cmdArgs$2, (Set<ResourcePattern>)((IterableOnceOps)resourcesToAcls.keys().flatten(Predef$.MODULE$.$conforms())).toSet(), (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(resourceCommand), (Object)cmd, ClassTag$.MODULE$.apply(String.class)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        AccessControlEntry writeAcl = new AccessControlEntry($this.principal().toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry($this.principal().toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry($this.principal().toString(), "*", AclOperation.CREATE, AclPermissionType.ALLOW);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl, describeAcl, createAcl}))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$13) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
            return;
        }
        Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(listCmd, !patternType.equals(PatternType.UNKNOWN));
        String[] removeCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(removeCmd, !patternType.equals(PatternType.UNKNOWN));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        Object var5_3 = null;
        KafkaConfig withAuthorizer_kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$1$adapted(AclCommandTest $this, Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$1($this, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$2$adapted(Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$5$adapted(Set acls$1, ResourcePattern resource$1, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, authorizer, resource$1, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$4$adapted(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testAclCli$4($this, acls$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProducerConsumerCli$7$adapted(Set acls$2, ResourcePattern resource$2, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, authorizer, resource$2, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testRemove$2$adapted(ResourcePattern resource$3, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, resource$3, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }
}

