/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\f\u0019\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011]\u0003!\u0011!Q\u0001\naCQa\u0017\u0001\u0005\u0002qCq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004l\u0001\u0001\u0006Ia\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019q\u0007\u0001)A\u0005\u0011\"Qq\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u00029\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001bBA\u000b\u0001\u0001\u0006Ia\u001d\u0005\n\u0003/\u0001!\u0019!C\u0005\u00033Aq!a\u0007\u0001A\u0003%\u0011\u0010C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA=\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003w\u0002A\u0011IA?\u0005Q\u0011%o\\6fe\ncwnY6j]\u001e\u001cVM\u001c3fe*\u0011\u0011DG\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003m\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005A\u0012BA\u0014\u0019\u00051\u0011En\\2lS:<7+\u001a8e\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tQS&D\u0001,\u0015\ta#$A\u0004dYV\u001cH/\u001a:\n\u00059Z#A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003KEJ!A\r\r\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\t)d(D\u00017\u0015\t\u0019tG\u0003\u00029s\u000511m\\7n_:T!a\u0007\u001e\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\u0005\u0003\u007fY\u0012q!T3ue&\u001c7/\u0001\u0003uS6,\u0007C\u0001\"F\u001b\u0005\u0019%B\u0001#8\u0003\u0015)H/\u001b7t\u0013\t15I\u0001\u0003US6,\u0017!\u00034fi\u000eDWM]%e!\ty\u0012*\u0003\u0002KA\t\u0019\u0011J\u001c;\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004\"!\u0014+\u000f\u00059\u0013\u0006CA(!\u001b\u0005\u0001&BA)\u001d\u0003\u0019a$o\\8u}%\u00111\u000bI\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002TA\u0005QAn\\4D_:$X\r\u001f;\u0011\u0005\tK\u0016B\u0001.D\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011usv\fY1cG\u0012\u0004\"!\n\u0001\t\u000b!B\u0001\u0019A\u0015\t\u000b=B\u0001\u0019\u0001\u0019\t\u000bMB\u0001\u0019\u0001\u001b\t\u000b\u0001C\u0001\u0019A!\t\u000b\u001dC\u0001\u0019\u0001%\t\u000b-C\u0001\u0019\u0001'\t\u000b]C\u0001\u0019\u0001-\u0002\u0015M|WO]2f\u001d>$W-F\u0001h!\tA\u0017.D\u00018\u0013\tQwG\u0001\u0003O_\u0012,\u0017aC:pkJ\u001cWMT8eK\u0002\nQb]8dW\u0016$H+[7f_V$X#\u0001%\u0002\u001dM|7m[3u)&lWm\\;uA\u0005\u0019\u0001\u0010J\u0019\u0011\t}\t8/_\u0005\u0003e\u0002\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001;x\u001b\u0005)(B\u0001<:\u0003\u001d\u0019G.[3oiNL!\u0001_;\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u!\ry\"\u0010`\u0005\u0003w\u0002\u0012aa\u00149uS>t'\u0003B?\u0000\u0003\u00171AA \u0001\u0001y\naAH]3gS:,W.\u001a8u}A!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006]\nqA\\3uo>\u00148.\u0003\u0003\u0002\n\u0005\r!AD\"iC:tW\r\u001c\"vS2$WM\u001d\t\u0004Q\u00065\u0011bAA\bo\tq!+Z2p]\u001aLw-\u001e:bE2,\u0017!\u00048fi^|'o[\"mS\u0016tG/F\u0001t\u00039qW\r^<pe.\u001cE.[3oi\u0002\nAD]3d_:4\u0017nZ;sC\ndWm\u00115b]:,GNQ;jY\u0012,'/F\u0001z\u0003u\u0011XmY8oM&<WO]1cY\u0016\u001c\u0005.\u00198oK2\u0014U/\u001b7eKJ\u0004\u0013A\u00042s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0002S\u0005Y1/\u001a8e%\u0016\fX/Z:u)\u0011\t)#a\u000b\u0011\u0007Q\f9#C\u0002\u0002*U\u0014ab\u00117jK:$(+Z:q_:\u001cX\rC\u0004\u0002.M\u0001\r!a\f\u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feB\"\u0011\u0011GA.!\u0019\t\u0019$!\u0015\u0002X9!\u0011QGA&\u001d\u0011\t9$a\u0012\u000f\t\u0005e\u0012Q\t\b\u0005\u0003w\t\u0019E\u0004\u0003\u0002>\u0005\u0005cbA(\u0002@%\tQ(\u0003\u0002<y%\u00111DO\u0005\u0003qeJ1!!\u00138\u0003!\u0011X-];fgR\u001c\u0018\u0002BA'\u0003\u001f\nq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0006\u0004\u0003\u0013:\u0014\u0002BA*\u0003+\u0012qAQ;jY\u0012,'O\u0003\u0003\u0002N\u0005=\u0003\u0003BA-\u00037b\u0001\u0001\u0002\u0007\u0002^\u0005-\u0012\u0011!A\u0001\u0006\u0003\tyFA\u0002`II\nB!!\u0019\u0002hA\u0019q$a\u0019\n\u0007\u0005\u0015\u0004EA\u0004O_RD\u0017N\\4\u0011\t\u0005%\u00141N\u0007\u0003\u0003\u001fJA!!\u001c\u0002P\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH/A\u0007j]&$\u0018.\u0019;f\u00072|7/\u001a\u000b\u0003\u0003g\u00022aHA;\u0013\r\t9\b\t\u0002\u0005+:LG/A\u0003dY>\u001cX-\u0001\u0005u_N#(/\u001b8h)\u0005a\u0005")
public class BrokerBlockingSender
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final KafkaConfig brokerConfig;
    private final Time time;
    private final int fetcherId;
    private final Node sourceNode;
    private final int socketTimeout;
    private final /* synthetic */ Tuple2 x$1;
    private final NetworkClient networkClient;
    private final Option<ChannelBuilder> reconfigurableChannelBuilder;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private Option<ChannelBuilder> reconfigurableChannelBuilder() {
        return this.reconfigurableChannelBuilder;
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode(), (Time)this.time, (long)this.socketTimeout())) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout()).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(Integer.toString(this.sourceBroker.id()), requestBuilder, this.time.milliseconds(), true);
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(Integer.toString(this.sourceBroker.id()));
            throw e;
        }
    }

    @Override
    public void initiateClose() {
        this.reconfigurableChannelBuilder().foreach((Function1 & Serializable)reconfigurable -> {
            this.brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.networkClient().initiateClose();
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public String toString() {
        return new StringBuilder(47).append("BrokerBlockingSender(sourceBroker=").append(this.sourceBroker).append(", fetcherId=").append(this.fetcherId).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public BrokerBlockingSender(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext) {
        void var9_9;
        None$ none$;
        this.sourceBroker = sourceBroker;
        this.brokerConfig = brokerConfig;
        this.time = time;
        this.fetcherId = fetcherId;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)brokerConfig.interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)brokerConfig, (ListenerName)brokerConfig.interBrokerListenerName(), (String)brokerConfig.saslMechanismInterBrokerProtocol(), (Time)time, (boolean)brokerConfig.saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            brokerConfig.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(brokerConfig.connectionSetupTimeoutMaxMs()), time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
        Option reconfigurableChannelBuilder2 = (Option)var9_9;
        this.x$1 = new Tuple2((Object)networkClient, (Object)reconfigurableChannelBuilder2);
        this.networkClient = (NetworkClient)this.x$1._1();
        this.reconfigurableChannelBuilder = (Option)this.x$1._2();
    }
}

