/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005%a!B\u0006\r\u0003\u0003\t\u0002\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\t\u000b}\u0001A\u0011\u0001\u0011\t\u000b\u0011\u0002A\u0011A\u0013\t\u000b\u0001\u0003A\u0011A!\t\u000b=\u0003A\u0011\u0001)\t\u000bI\u0003A\u0011A*\t\u000f\r\u0004\u0011\u0013!C\u0001I\"9q\u000eAI\u0001\n\u0003\u0001\bb\u0002:\u0001#\u0003%\t\u0001\u001d\u0005\bg\u0002\t\n\u0011\"\u0001u\u0005y\t%m\u001d;sC\u000e$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\tQR$D\u0001\u001c\u0015\tab\"\u0001\u0003uKN$\u0018B\u0001\u0010\u001c\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002\"GA\u0011!\u0005A\u0007\u0002\u0019!)\u0001D\u0001a\u00013\u000512/\u001a8e\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fF\u0002'ga\u0002\"aJ\u0019\u000e\u0003!R!!\u000b\u0016\u0002\u0011I,\u0017/^3tiNT!a\u000b\u0017\u0002\r\r|W.\\8o\u0015\tyQF\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<\u0017B\u0001\u001a)\u0005M\t\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f\u0011\u0015!4\u00011\u00016\u0003\u001d\u0011X-];fgR\u0004\"a\n\u001c\n\u0005]B#AE!qSZ+'o]5p]N\u0014V-];fgRDQ!O\u0002A\u0002i\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004\"a\u000f \u000e\u0003qR!!\u0010\u0016\u0002\u000f9,Go^8sW&\u0011q\b\u0010\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"AQ#\u0011\u0005M\u0019\u0015B\u0001#\u0015\u0005\u0011)f.\u001b;\t\u000b\u0019#\u0001\u0019A$\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0011tK:$WK\\:vaB|'\u000f^3e\u0003BLg+\u001a:tS>t'+Z9vKN$HC\u0001\u0014R\u0011\u0015!T\u00011\u00016\u0003m1\u0018\r\\5eCR,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tKR1!\t\u0016,X9zCQ!\u0016\u0004A\u0002\u0019\n1#\u00199j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016Dq!\u000f\u0004\u0011\u0002\u0003\u0007!\bC\u0004Y\rA\u0005\t\u0019A-\u00023\u0015t\u0017M\u00197f+:\u001cH/\u00192mK2\u000b7\u000f\u001e,feNLwN\u001c\t\u0003'iK!a\u0017\u000b\u0003\u000f\t{w\u000e\\3b]\"9QL\u0002I\u0001\u0002\u0004I\u0016AF2mS\u0016tG\u000fV3mK6,GO]=F]\u0006\u0014G.\u001a3\t\u000f}3\u0001\u0013!a\u0001A\u0006Q\u0011\r]5WKJ\u001c\u0018n\u001c8\u0011\u0005M\t\u0017B\u00012\u0015\u0005\u0015\u0019\u0006n\u001c:u\u0003\u00152\u0018\r\\5eCR,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$#'F\u0001fU\tQdmK\u0001h!\tAW.D\u0001j\u0015\tQ7.A\u0005v]\u000eDWmY6fI*\u0011A\u000eF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00018j\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001&m\u0006d\u0017\u000eZ1uK\u0006\u0003\u0018NV3sg&|gn\u001d*fgB|gn]3%I\u00164\u0017-\u001e7uIM*\u0012!\u001d\u0016\u00033\u001a\fQE^1mS\u0012\fG/Z!qSZ+'o]5p]N\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001b\u0002KY\fG.\u001b3bi\u0016\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012*T#A;+\u0005\u00014\u0007F\u0002\u0001x\u0003\u0007\t)\u0001\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u0006\u0019\u0011\r]5\u000b\u0005ql\u0018a\u00026va&$XM\u001d\u0006\u0003}>\nQA[;oSRL1!!\u0001z\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000f\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public abstract class AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, ListenerName listenerName) {
        SocketServer socket = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? (SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.controllerSocketServers()).asScala().head() : (SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head();
        return (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socket, listenerName, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public void brokerPropertyOverrides(Properties properties) {
        if (!this.cluster.isKRaftTest()) {
            String controlPlaneListenerName = "CONTROL_PLANE";
            SecurityProtocol securityProtocol = this.cluster.config().securityProtocol();
            properties.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), controlPlaneListenerName);
            properties.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(3).append(controlPlaneListenerName).append(":").append(securityProtocol).append(",").append(securityProtocol).append(":").append(securityProtocol).toString());
            properties.setProperty("listeners", new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
            properties.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
            return;
        }
    }

    public ApiVersionsResponse sendUnsupportedApiVersionRequest(ApiVersionsRequest request) {
        ApiVersionsResponse apiVersionsResponse;
        RequestHeader overrideHeader = IntegrationTestUtils$.MODULE$.nextRequestHeader(ApiKeys.API_VERSIONS, (short)Short.MAX_VALUE, "client-id", (Option<Object>)None$.MODULE$);
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener());){
            byte[] serializedBytes = Utils.toArray((ByteBuffer)RequestUtils.serialize((Message)overrideHeader.data(), (short)overrideHeader.headerVersion(), (Message)request.data(), (short)request.version()));
            IntegrationTestUtils$.MODULE$.sendRequest(socket, serializedBytes);
            apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.receive(socket, ApiKeys.API_VERSIONS, (short)0, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        }
        return apiVersionsResponse;
    }

    public void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse, ListenerName listenerName, boolean enableUnstableLastVersion, boolean clientTelemetryEnabled, short apiVersion) {
        if (this.cluster.isKRaftTest() && apiVersion >= 3) {
            Assertions.assertEquals((int)1, (int)apiVersionsResponse.data().finalizedFeatures().size());
            Assertions.assertEquals((short)MetadataVersion.latestTesting().featureLevel(), (short)apiVersionsResponse.data().finalizedFeatures().find("metadata.version").minVersionLevel());
            Assertions.assertEquals((short)MetadataVersion.latestTesting().featureLevel(), (short)apiVersionsResponse.data().finalizedFeatures().find("metadata.version").maxVersionLevel());
            Assertions.assertEquals((int)1, (int)apiVersionsResponse.data().supportedFeatures().size());
            Assertions.assertEquals((short)MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("metadata.version").minVersion());
            Assertions.assertEquals((short)MetadataVersion.latestTesting().featureLevel(), (short)apiVersionsResponse.data().supportedFeatures().find("metadata.version").maxVersion());
        }
        ApiVersionsResponseData.ApiVersionCollection expectedApis = !this.cluster.isKRaftTest() ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER), (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER), (boolean)enableUnstableLastVersion) : ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (RecordVersion)RecordVersion.current(), (Map)NodeApiVersions.create((Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER)).asScala().map((Function1 & Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1))).asJava()).allSupportedApiVersions(), (boolean)enableUnstableLastVersion, (boolean)clientTelemetryEnabled));
        Assertions.assertEquals((int)expectedApis.size(), (int)apiVersionsResponse.data().apiKeys().size(), (String)"API keys in ApiVersionsResponse must match API keys supported by broker.");
        ApiVersionsResponse defaultApiVersionsResponse = !this.cluster.isKRaftTest() ? TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER, (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? TestUtils.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER, (boolean)enableUnstableLastVersion) : TestUtils.createApiVersionsResponse((int)0, (ApiVersionsResponseData.ApiVersionCollection)expectedApis));
        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)defaultApiVersionsResponse.data().apiKeys()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$2(check$ifrefutable$1))).foreach((Function1 & Serializable)expectedApiVersion -> {
            AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$3(apiVersionsResponse, expectedApiVersion);
            return BoxedUnit.UNIT;
        });
    }

    public ListenerName validateApiVersionsResponse$default$2() {
        return this.cluster.clientListener();
    }

    public boolean validateApiVersionsResponse$default$3() {
        return false;
    }

    public boolean validateApiVersionsResponse$default$4() {
        return false;
    }

    public short validateApiVersionsResponse$default$5() {
        return ApiKeys.API_VERSIONS.latestVersion();
    }

    public static final /* synthetic */ boolean $anonfun$validateApiVersionsResponse$2(ApiVersionsResponseData.ApiVersion check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$validateApiVersionsResponse$3(ApiVersionsResponse apiVersionsResponse$1, ApiVersionsResponseData.ApiVersion expectedApiVersion) {
        ApiVersionsResponseData.ApiVersion actualApiVersion = apiVersionsResponse$1.apiVersion(expectedApiVersion.apiKey());
        Assertions.assertNotNull((Object)actualApiVersion, (String)new StringBuilder(73).append("API key ").append(expectedApiVersion.apiKey()).append(" is supported by broker, but not received in ApiVersionsResponse.").toString());
        Assertions.assertEquals((short)expectedApiVersion.apiKey(), (short)actualApiVersion.apiKey(), (String)"API key must be supported by the broker.");
        Assertions.assertEquals((short)expectedApiVersion.minVersion(), (short)actualApiVersion.minVersion(), (String)new StringBuilder(45).append("Received unexpected min version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
        Assertions.assertEquals((short)expectedApiVersion.maxVersion(), (short)actualApiVersion.maxVersion(), (String)new StringBuilder(45).append("Received unexpected max version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
    }

    public AbstractApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

