/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u0010 \u0001\u0011BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004>\u0001\u0001\u0006Ia\u000e\u0005\b}\u0001\u0011\r\u0011\"\u00017\u0011\u0019y\u0004\u0001)A\u0005o!9\u0001\t\u0001b\u0001\n\u0003\t\u0005B\u0002&\u0001A\u0003%!\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u001d\u0011\u0007A1A\u0005\u0002YBaa\u0019\u0001!\u0002\u00139\u0004\"\u00023\u0001\t\u0003)\u0007bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0005-iU\r\u001e:jGN$Vm\u001d;\u000b\u0005\u0001\n\u0013aB7fiJL7m\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\u0011\u0001&I\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002+O\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002-_5\tQF\u0003\u0002/C\u0005)Q\u000f^5mg&\u0011\u0001'\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u00025\u00015\tq$\u0001\u0005ok6tu\u000eZ3t+\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$aA%oi\u0006Ia.^7O_\u0012,7\u000fI\u0001\t]Vl\u0007+\u0019:ug\u0006Ia.^7QCJ$8\u000fI\u0001\u001ae\u0016\fX/\u001b:fI.\u000bgm[1TKJ4XM\u001d)sK\u001aL\u00070F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003mC:<'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0012\u0013aa\u0015;sS:<\u0017A\u0007:fcVL'/\u001a3LC\u001a\\\u0017mU3sm\u0016\u0014\bK]3gSb\u0004\u0013aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001\u0015$\u0002\tU$\u0018\u000e\\\u0005\u0003%>\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u00051\u0006cA,[96\t\u0001L\u0003\u0002Zs\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005mC&aA*fcB\u0011Q\fY\u0007\u0002=*\u0011q,I\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0005t&aC&bM.\f7i\u001c8gS\u001e\f\u0011B\\'fgN\fw-Z:\u0002\u00159lUm]:bO\u0016\u001c\b%A\u0013uKN$X*\u001a;sS\u000e\u001c(+\u001a9peR,'/\u00114uKJ$U\r\\3uS:<Gk\u001c9jGR\u0011a-\u001b\t\u0003q\u001dL!\u0001[\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006U6\u0001\ra[\u0001\u0007cV|'/^7\u0011\u00051\u001chBA7r!\tq\u0017(D\u0001p\u0015\t\u00018%\u0001\u0004=e>|GOP\u0005\u0003ef\na\u0001\u0015:fI\u00164\u0017BA%u\u0015\t\u0011\u0018\b\u000b\u0004\u000em\u0006\u0015\u0011q\u0001\t\u0004o\u0006\u0005Q\"\u0001=\u000b\u0005eT\u0018A\u00029be\u0006l7O\u0003\u0002|y\u00069!.\u001e9ji\u0016\u0014(BA?\u007f\u0003\u0015QWO\\5u\u0015\u0005y\u0018aA8sO&\u0019\u00111\u0001=\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA\u0005\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\":Q\"!\u0004\u0002\u001a\u0005m\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u00010\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\t9\"!\u0005\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ti\"!\t\"\u0005\u0005}\u0011A\u0001>lC\t\t\u0019#A\u0003le\u00064G/\u0001\u001buKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t+:\u0014XmZ5ti\u0016\u0014X\rZ!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000e$2AZA\u0015\u0011\u0015Qg\u00021\u0001lQ\u0019qa/!\u0002\u0002\b!:a\"!\u0004\u0002\u001a\u0005=B\u0006BA\u000f\u0003C\t1\u0003^3ti\u000ecWo\u001d;fe&#W*\u001a;sS\u000e$2AZA\u001b\u0011\u0015Qw\u00021\u0001lQ\u0019ya/!\u0002\u0002\b!:q\"!\u0004\u0002\u001a\u0005mB\u0006BA\u000f\u0003C\tQ\u0003^3ti\n\u0013xn[3s'R\fG/Z'fiJL7\rF\u0002g\u0003\u0003BQA\u001b\tA\u0002-Dc\u0001\u0005<\u0002\u0006\u0005\u001d\u0001f\u0002\t\u0002\u000e\u0005e\u0011q\t\u0017\u0005\u0003;\t\t#\u0001\u000fuKN$\u0018,Y7nKJlU\r\u001e:jGN\u001cu.\u001e8u\u001b\u0016$(/[2\u0015\u0007\u0019\fi\u0005C\u0003k#\u0001\u00071\u000e\u000b\u0004\u0012m\u0006\u0015\u0011q\u0001\u0015\b#\u00055\u0011\u0011DA*Y\u0011\ti\"!\t\u0002%Q,7\u000f\u001e'j]VD\u0018j\\'fiJL7m\u001d\u000b\u0004M\u0006e\u0003\"\u00026\u0013\u0001\u0004Y\u0007F\u0002\nw\u0003\u000b\t9\u0001K\u0004\u0013\u0003\u001b\tI\"a\u0018-\t\u0005u\u0011\u0011E\u0001\u000ei\u0016\u001cHOS'Y\r&dG/\u001a:\u0015\u0007\u0019\f)\u0007C\u0003k'\u0001\u00071\u000e\u000b\u0004\u0014m\u0006\u0015\u0011q\u0001\u0015\b'\u00055\u0011\u0011DA6Y\u0011\ti\"!\t\u0002'Q,7\u000f^+qI\u0006$XMS'Y\r&dG/\u001a:\u0015\u0007\u0019\f\t\bC\u0003k)\u0001\u00071\u000e\u000b\u0004\u0015m\u0006\u0015\u0011q\u0001\u0015\b)\u00055\u0011\u0011DA<Y\u0011\ti\"!\t\u0002eQ,7\u000f^$f]\u0016\u0014\u0018\r\u001c\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\f%/Z$sK\u0016$\u0017\u000e\\=SK\u001eL7\u000f^3sK\u0012$2AZA?\u0011\u0015QW\u00031\u0001lQ\u0019)b/!\u0002\u0002\b!:Q#!\u0004\u0002\u001a\u0005\rE\u0006BA\u000f\u0003C\t\u0001\u0004^3ti^Kg\u000eZ8xgN#\u0018\u0010\\3UC\u001et\u0015-\\3t)\r1\u0017\u0011\u0012\u0005\u0006UZ\u0001\ra\u001b\u0015\u0007-Y\f)!a\u0002)\u000fY\ti!!\u0007\u0002\u00102\"\u0011QDA\u0011\u0003\u0001\"Xm\u001d;Ce>\\WM\u001d+pa&\u001cW*\u001a;sS\u000e\u001c()\u001f;fg&sw*\u001e;\u0015\u0007\u0019\f)\nC\u0003k/\u0001\u00071\u000e\u000b\u0004\u0018m\u0006\u0015\u0011q\u0001\u0015\b/\u00055\u0011\u0011DANY\u0011\ti\"!\t\u0002/Q,7\u000f\u001e.l\u0007>tGO]8mY\u0016\u0014X*\u001a;sS\u000e\u001cHc\u00014\u0002\"\")!\u000e\u0007a\u0001W\"2\u0001D^A\u0003\u0003\u000fAs\u0001GA\u0007\u00033\t9\u000b\f\u0002\u0002\u001e\u0005QB/Z:u\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7fe6+GO]5dgR\u0019a-!,\t\u000b)L\u0002\u0019A6)\re1\u0018QAA\u0004Q\u001dI\u0012QBA\r\u0003gc#!!\t\u0002AQ,7\u000f^*fgNLwN\\#ya&\u0014X\rT5ti\u0016tWM]'fiJL7m\u001d\u000b\u0004M\u0006e\u0006\"\u00026\u001b\u0001\u0004Y\u0007F\u0002\u000ew\u0003\u000b\t9\u0001K\u0004\u001b\u0003\u001b\tI\"a0-\t\u0005u\u0011\u0011E\u0001\ri>\u0004\u0018nY'fiJL7m\u001d\u000b\u0005\u0003\u000b\fY\r\u0005\u0003X\u0003\u000f\\\u0017bAAe1\n\u00191+\u001a;\t\u000f\u000557\u00041\u0001\u0002P\u0006)Ao\u001c9jGB!\u0001(!5l\u0013\r\t\u0019.\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002#Q|\u0007/[2NKR\u0014\u0018nY$s_V\u00048\u000f\u0006\u0003\u0002F\u0006e\u0007BBAg9\u0001\u00071.\u0001\rgS2$XM\u001d\"z)>\u0004\u0018nY'fiJL7MU3hKb$b!!2\u0002`\u0006\u0005\bB\u0002\u0011\u001e\u0001\u0004\t)\rC\u0004\u0002Nv\u0001\r!a4)\u000f\u0001\t)/!=\u0002tB!\u0011q]Aw\u001b\t\tIOC\u0002\u0002lj\f1!\u00199j\u0013\u0011\ty/!;\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\t\u0001\u0010")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsReporterAfterDeletingTopic(String quorum) {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerStateMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testYammerMetricsCountMetric(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLinuxIoMetrics(String quorum) {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testJMXFilter(String quorum) {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateJMXFilter(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered(String quorum) {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertEquals((int)0, (int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricGaugeMap().size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWindowsStyleTagNames(String quorum) {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = new KafkaMetricsGroup(this.getClass()).metricName("test-metric", CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerTopicMetricsBytesInOut(String quorum) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testZkControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$1(x$8))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$2(x$9))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$3(x$10))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$4(x$11))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$5(x$12))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$6(x$13))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$7(x$14))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$8(x$15))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$9(x$16))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$10(x$17))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$11(x$18))), (int)1);
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$12(x$19))), (int)1);
        MetricName zkStateMetricName = (MetricName)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().filter((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testZkControllerMetrics$13(x$20)))).head();
        Gauge zkStateGauge = (Gauge)metrics.get(zkStateMetricName);
        Assertions.assertEquals((int)ZkMigrationState.ZK.value(), (int)BoxesRunTime.unboxToInt((Object)zkStateGauge.value()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"kraft"})
    public void testKRaftControllerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount", "kafka.controller:type=KafkaController,name=ZkMigrationState"}))).foreach((Function1 & Serializable)expected -> {
            MetricsTest.$anonfun$testKRaftControllerMetrics$1(metrics, expected);
            return BoxedUnit.UNIT;
        });
        MetricName zkStateMetricName = (MetricName)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().filter((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$3(x$22)))).head();
        Gauge zkStateGauge = (Gauge)metrics.get(zkStateMetricName);
        Assertions.assertEquals((int)ZkMigrationState.NONE.value(), (int)BoxesRunTime.unboxToInt((Object)zkStateGauge.value()));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSessionExpireListenerMetrics(String quorum) {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        int expectedNumMetrics = this.isKRaftTest() ? 0 : 1;
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$23))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$24))));
        Assertions.assertEquals((int)expectedNumMetrics, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$25))));
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$26 -> x$26.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable)() -> "")).toString())).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$27)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$1(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$2(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$3(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$4(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$5(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$6(MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$7(MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$8(MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$9(MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$10(MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$11(MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=FencedBrokerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$12(MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ZkMigrationState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testZkControllerMetrics$13(MetricName x$20) {
        String string = x$20.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ZkMigrationState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$2(String expected$1, MetricName x$21) {
        return x$21.getMBeanName().equals(expected$1);
    }

    public static final /* synthetic */ void $anonfun$testKRaftControllerMetrics$1(java.util.Map metrics$2, String expected) {
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$2.keySet()).asScala().count((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$2(expected, x$21))), (String)new StringBuilder(15).append("Unable to find ").append(expected).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$3(MetricName x$22) {
        String string = x$22.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ZkMigrationState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$23) {
        String string = x$23.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$24) {
        String string = x$24.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$25) {
        String string = x$25.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$27) {
        return pattern$1.matcher(x$27).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        this.nMessages = 2;
    }
}

