/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-h\u0001\u0002%J\u00019C\u0001b\u0017\u0001\u0003\u0006\u0004%I\u0001\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005;\"A!\r\u0001BC\u0002\u0013\u00051\r\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003e\u0011!\u0011\bA!b\u0001\n\u0003\u0019\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011q\u0004!Q1A\u0005\nuD\u0011\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u0005-\u0001A!b\u0001\n\u0003\ti\u0001\u0003\u0006\u0002`\u0001\u0011\t\u0011)A\u0005\u0003\u001fA!\"!\u0019\u0001\u0005\u000b\u0007I\u0011AA2\u0011)\tY\u0007\u0001B\u0001B\u0003%\u0011Q\r\u0005\b\u0003[\u0002A\u0011AA8\u0011%\ty\b\u0001b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\n\u0002\u0001\u000b\u0011BAB\u0011%\tY\t\u0001a\u0001\n\u0013\ti\tC\u0005\u0002\u0016\u0002\u0001\r\u0011\"\u0003\u0002\u0018\"A\u00111\u0015\u0001!B\u0013\ty\tC\u0005\u0002&\u0002\u0001\r\u0011\"\u0003\u0002\u000e\"I\u0011q\u0015\u0001A\u0002\u0013%\u0011\u0011\u0016\u0005\t\u0003[\u0003\u0001\u0015)\u0003\u0002\u0010\"I\u0011q\u0016\u0001A\u0002\u0013%\u0011Q\u0012\u0005\n\u0003c\u0003\u0001\u0019!C\u0005\u0003gC\u0001\"a.\u0001A\u0003&\u0011q\u0012\u0005\t\u0003s\u0003!\u0019!C\u00019\"9\u00111\u0018\u0001!\u0002\u0013i\u0006\u0002CA_\u0001\t\u0007I\u0011\u0001/\t\u000f\u0005}\u0006\u0001)A\u0005;\"A\u00111\u0001\u0001A\u0002\u0013\u0005Q\u0010C\u0005\u0002B\u0002\u0001\r\u0011\"\u0001\u0002D\"9\u0011q\u0019\u0001!B\u0013q\bbCAi\u0001\u0001\u0007\t\u0019!C\u0001\u0003'D1\"a;\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002n\"Y\u0011\u0011\u001f\u0001A\u0002\u0003\u0005\u000b\u0015BAk\u0011-\t)\u0010\u0001a\u0001\u0002\u0004%\t!a>\t\u0017\t\r\u0001\u00011AA\u0002\u0013\u0005!Q\u0001\u0005\f\u0005\u0013\u0001\u0001\u0019!A!B\u0013\tI\u0010C\u0006\u0003\u000e\u0001\u0001\r\u00111A\u0005\u0002\t=\u0001b\u0003B\u0010\u0001\u0001\u0007\t\u0019!C\u0001\u0005CA1B!\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0012!Y!\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0016\u0011-\u0011Y\u0004\u0001a\u0001\u0002\u0004%\tA!\u0010\t\u0017\t\u0005\u0003\u00011A\u0001B\u0003&!Q\u0006\u0005\n\u0005\u000b\u0002!\u0019!C\u0001\u0005\u000fB\u0001B!\u001a\u0001A\u0003%!\u0011\n\u0005\f\u0005O\u0002\u0001\u0019!a\u0001\n\u0003\u0011I\u0007C\u0006\u0003x\u0001\u0001\r\u00111A\u0005\u0002\te\u0004b\u0003B?\u0001\u0001\u0007\t\u0011)Q\u0005\u0005WB1B!!\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0004\"Y!1\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001BG\u0011-\u0011\t\n\u0001a\u0001\u0002\u0003\u0006KA!\"\t\u0017\tU\u0005\u00011AA\u0002\u0013\u0005!q\u0013\u0005\f\u0005G\u0003\u0001\u0019!a\u0001\n\u0003\u0011)\u000bC\u0006\u0003*\u0002\u0001\r\u0011!Q!\n\te\u0005b\u0002BW\u0001\u0011\u0005!q\u0016\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqAa0\u0001\t\u0003\u0011\t\rC\u0004\u0003D\u0002!\tA!1\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003B\"9!q\u0019\u0001\u0005\u0002\t\u0005\u0007b\u0002Be\u0001\u0011\u0005!1\u001a\u0005\b\u00053\u0004A\u0011\u0001Bf\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005\u0017DqA!8\u0001\t\u0003\u0011Y\rC\u0004\u0003`\u0002!\tAa3\t\u000f\t\u0005\b\u0001\"\u0001\u0003L\"9!1\u001d\u0001\u0005\u0002\t-\u0007b\u0002Bs\u0001\u0011%!\u0011\u0019\u0005\b\u0005O\u0004A\u0011\u0001Ba\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005\u0003\u0014Ab\u00155be\u0016$7+\u001a:wKJT!AS&\u0002\rM,'O^3s\u0015\u0005a\u0015!B6bM.\f7\u0001A\n\u0004\u0001=+\u0006C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&AB!osJ+g\r\u0005\u0002W36\tqK\u0003\u0002Y\u0017\u0006)Q\u000f^5mg&\u0011!l\u0016\u0002\b\u0019><w-\u001b8h\u0003I\u0019\b.\u0019:fIN+'O^3s\u0007>tg-[4\u0016\u0003u\u0003\"AX0\u000e\u0003%K!\u0001Y%\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0014g\"\f'/\u001a3TKJ4XM]\"p]\u001aLw\rI\u0001\u0012[\u0016$\u0018\r\u0015:paN,en]3nE2,W#\u00013\u0011\u0005\u0015|W\"\u00014\u000b\u0005\u001dD\u0017A\u00039s_B,'\u000f^5fg*\u0011\u0011N[\u0001\t[\u0016$\u0018\rZ1uC*\u0011Aj\u001b\u0006\u0003Y6\fa!\u00199bG\",'\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qM\n1R*\u001a;b!J|\u0007/\u001a:uS\u0016\u001cXI\\:f[\ndW-\u0001\nnKR\f\u0007K]8qg\u0016s7/Z7cY\u0016\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u001e\t\u0003kfl\u0011A\u001e\u0006\u00031^T!\u0001\u001f6\u0002\r\r|W.\\8o\u0013\tQhO\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001C0nKR\u0014\u0018nY:\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004]\fq!\\3ue&\u001c7/\u0003\u0003\u0002\b\u0005\u0005!aB'fiJL7m]\u0001\n?6,GO]5dg\u0002\nAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002\u0010A1\u0011\u0011CA\u0010\u0003Gi!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\r\u00037\tA!\u001e;jY*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\"\u0005M!!E\"p[BdW\r^1cY\u00164U\u000f^;sKBA\u0011QEA\u0014\u0003W\t9$\u0004\u0002\u0002\u0018%!\u0011\u0011FA\f\u0005\ri\u0015\r\u001d\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)!\u0011\u0011GA\u000e\u0003\u0011a\u0017M\\4\n\t\u0005U\u0012q\u0006\u0002\b\u0013:$XmZ3s!\u0011\tI$!\u0017\u000f\t\u0005m\u00121\u000b\b\u0005\u0003{\tyE\u0004\u0003\u0002@\u00055c\u0002BA!\u0003\u0017rA!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fj\u0015A\u0002\u001fs_>$h(C\u0001o\u0013\taW.\u0003\u0002MW&\u0019\u0011\u0011\u000b6\u0002\tI\fg\r^\u0005\u0005\u0003+\n9&\u0001\u0006SC\u001a$8i\u001c8gS\u001eT1!!\u0015k\u0013\u0011\tY&!\u0018\u0003\u0017\u0005#GM]3tgN\u0003Xm\u0019\u0006\u0005\u0003+\n9&A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003M1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z+\t\t)\u0007E\u0002_\u0003OJ1!!\u001bJ\u0005M1\u0015-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z\u0003Q1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:zA\u00051A(\u001b8jiz\"b\"!\u001d\u0002t\u0005U\u0014qOA=\u0003w\ni\b\u0005\u0002_\u0001!)1,\u0004a\u0001;\")!-\u0004a\u0001I\")!/\u0004a\u0001i\")A0\u0004a\u0001}\"9\u00111B\u0007A\u0002\u0005=\u0001bBA1\u001b\u0001\u0007\u0011QM\u0001\u000bY><7i\u001c8uKb$XCAAB!\r)\u0018QQ\u0005\u0004\u0003\u000f3(A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003\u001d\u0019H/\u0019:uK\u0012,\"!a$\u0011\u0007A\u000b\t*C\u0002\u0002\u0014F\u0013qAQ8pY\u0016\fg.A\u0006ti\u0006\u0014H/\u001a3`I\u0015\fH\u0003BAM\u0003?\u00032\u0001UAN\u0013\r\ti*\u0015\u0002\u0005+:LG\u000fC\u0005\u0002\"F\t\t\u00111\u0001\u0002\u0010\u0006\u0019\u0001\u0010J\u0019\u0002\u0011M$\u0018M\u001d;fI\u0002\nA\"^:fI\nK(I]8lKJ\f\u0001#^:fI\nK(I]8lKJ|F%Z9\u0015\t\u0005e\u00151\u0016\u0005\n\u0003C#\u0012\u0011!a\u0001\u0003\u001f\u000bQ\"^:fI\nK(I]8lKJ\u0004\u0013\u0001E;tK\u0012\u0014\u0015pQ8oiJ|G\u000e\\3s\u0003Q)8/\u001a3Cs\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR!\u0011\u0011TA[\u0011%\t\tkFA\u0001\u0002\u0004\ty)A\tvg\u0016$')_\"p]R\u0014x\u000e\u001c7fe\u0002\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\u0013\u0001E2p]R\u0014x\u000e\u001c7fe\u000e{gNZ5h\u0003E\u0019wN\u001c;s_2dWM]\"p]\u001aLw\rI\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0006\u0015\u0007\u0002CAQ=\u0005\u0005\t\u0019\u0001@\u0002\u00115,GO]5dg\u0002B3aHAf!\r\u0001\u0016QZ\u0005\u0004\u0003\u001f\f&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003+\u0004b!a6\u0002\\\u0006}WBAAm\u0015\r\t\tfS\u0005\u0005\u0003;\fIN\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feB!\u0011\u0011]At\u001b\t\t\u0019OC\u0002y\u0003KT!A\u00136\n\t\u0005%\u00181\u001d\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\u001fI\fg\r^'b]\u0006<WM]0%KF$B!!'\u0002p\"I\u0011\u0011U\u0011\u0002\u0002\u0003\u0007\u0011Q[\u0001\re\u00064G/T1oC\u001e,'\u000f\t\u0015\u0004E\u0005-\u0017!\u00042s_.,'/T3ue&\u001c7/\u0006\u0002\u0002zB!\u00111`A\u0000\u001b\t\tiP\u0003\u0002j\u0013&!!\u0011AA\u007f\u0005M\u0011%o\\6feN+'O^3s\u001b\u0016$(/[2t\u0003E\u0011'o\\6fe6+GO]5dg~#S-\u001d\u000b\u0005\u00033\u00139\u0001C\u0005\u0002\"\u0012\n\t\u00111\u0001\u0002z\u0006q!M]8lKJlU\r\u001e:jGN\u0004\u0003fA\u0013\u0002L\u000692m\u001c8ue>dG.\u001a:TKJ4XM]'fiJL7m]\u000b\u0003\u0005#\u0001BAa\u0005\u0003\u001c5\u0011!Q\u0003\u0006\u0005\u0003\u0007\u00119BC\u0002\u0003\u001a)\f!bY8oiJ|G\u000e\\3s\u0013\u0011\u0011iB!\u0006\u00033\r{g\u000e\u001e:pY2,'/T3uC\u0012\fG/Y'fiJL7m]\u0001\u001cG>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN|F%Z9\u0015\t\u0005e%1\u0005\u0005\n\u0003C;\u0013\u0011!a\u0001\u0005#\t\u0001dY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:NKR\u0014\u0018nY:!Q\rA\u00131Z\u0001\u0007Y>\fG-\u001a:\u0016\u0005\t5\u0002\u0003\u0002B\u0018\u0005oi!A!\r\u000b\t\t%\"1\u0007\u0006\u0004\u0005kQ\u0017!B5nC\u001e,\u0017\u0002\u0002B\u001d\u0005c\u0011a\"T3uC\u0012\fG/\u0019'pC\u0012,'/\u0001\u0006m_\u0006$WM]0%KF$B!!'\u0003@!I\u0011\u0011\u0015\u0016\u0002\u0002\u0003\u0007!QF\u0001\bY>\fG-\u001a:!Q\rY\u00131Z\u0001\u0018g:\f\u0007o\u001d5piN$\u0015n]1cY\u0016$'+Z1t_:,\"A!\u0013\u0011\r\t-#\u0011\u000bB+\u001b\t\u0011iE\u0003\u0003\u0003P\u0005M\u0011AB1u_6L7-\u0003\u0003\u0003T\t5#aD!u_6L7MU3gKJ,gnY3\u0011\t\t]#q\f\b\u0005\u00053\u0012Y\u0006E\u0002\u0002DEK1A!\u0018R\u0003\u0019\u0001&/\u001a3fM&!!\u0011\rB2\u0005\u0019\u0019FO]5oO*\u0019!QL)\u00021Mt\u0017\r]:i_R\u001cH)[:bE2,GMU3bg>t\u0007%A\bt]\u0006\u00048\u000f[8u\u000b6LG\u000f^3s+\t\u0011Y\u0007\u0005\u0003\u0003n\tMTB\u0001B8\u0015\u0011\u0011\tHa\r\u0002\u0013A,(\r\\5tQ\u0016\u0014\u0018\u0002\u0002B;\u0005_\u0012qb\u00158baNDw\u000e^#nSR$XM]\u0001\u0014g:\f\u0007o\u001d5pi\u0016k\u0017\u000e\u001e;fe~#S-\u001d\u000b\u0005\u00033\u0013Y\bC\u0005\u0002\">\n\t\u00111\u0001\u0003l\u0005\u00012O\\1qg\"|G/R7jiR,'\u000f\t\u0015\u0004a\u0005-\u0017!E:oCB\u001c\bn\u001c;HK:,'/\u0019;peV\u0011!Q\u0011\t\u0005\u0005[\u00129)\u0003\u0003\u0003\n\n=$!E*oCB\u001c\bn\u001c;HK:,'/\u0019;pe\u0006)2O\\1qg\"|GoR3oKJ\fGo\u001c:`I\u0015\fH\u0003BAM\u0005\u001fC\u0011\"!)3\u0003\u0003\u0005\rA!\"\u0002%Mt\u0017\r]:i_R<UM\\3sCR|'\u000f\t\u0015\u0004g\u0005-\u0017!F7fi\u0006$\u0017\r^1M_\u0006$WM]'fiJL7m]\u000b\u0003\u00053\u0003BAa'\u0003 6\u0011!Q\u0014\u0006\u0005\u0003\u0007\u0011\t$\u0003\u0003\u0003\"\nu%!F'fi\u0006$\u0017\r^1M_\u0006$WM]'fiJL7m]\u0001\u001a[\u0016$\u0018\rZ1uC2{\u0017\rZ3s\u001b\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\n\u001d\u0006\"CAQk\u0005\u0005\t\u0019\u0001BM\u0003YiW\r^1eCR\fGj\\1eKJlU\r\u001e:jGN\u0004\u0003f\u0001\u001c\u0002L\u0006I1\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0003\u0005+\naA\\8eK&#WC\u0001B[!\r\u0001&qW\u0005\u0004\u0005s\u000b&aA%oi\u00061\u0011n]+tK\u0012$\"!a$\u0002\u001dM$\u0018M\u001d;G_J\u0014%o\\6feR\u0011\u0011\u0011T\u0001\u0013gR\f'\u000f\u001e$pe\u000e{g\u000e\u001e:pY2,'/A\u0007ti>\u0004hi\u001c:Ce>\\WM]\u0001\u0012gR|\u0007OR8s\u0007>tGO]8mY\u0016\u0014\u0018a\u0006:bMRl\u0015M\\1hKJ4\u0015-\u001e7u\u0011\u0006tG\r\\3s+\t\u0011i\r\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\u0011\u0011\u0019.!:\u0002\u000b\u0019\fW\u000f\u001c;\n\t\t]'\u0011\u001b\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001b[\u0016$\u0018\rZ1uC2{\u0017\rZ3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001eG>tGO]8mY\u0016\u00148\u000b^1siV\u0004h)Y;mi\"\u000bg\u000e\u001a7fe\u0006)\u0013N\\5uS\u0006d'I]8lKJlU\r^1eCR\fGj\\1e\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\"M\u0006$\u0018\r\\)v_J,XnQ8oiJ|G\u000e\\3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001%]>tg)\u0019;bYF+xN];n\u0007>tGO]8mY\u0016\u0014h)Y;mi\"\u000bg\u000e\u001a7fe\u0006qR.\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u0006gR\f'\u000f^\u0001\u0014K:\u001cXO]3O_R\u0014\u0016M\u001a;MK\u0006$WM]\u0001\u0005gR|\u0007\u000f")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    public void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public String clusterId() {
        return (String)this.metaPropsEnsemble().clusterId().get();
    }

    public int nodeId() {
        return this.metaPropsEnsemble().nodeId().getAsInt();
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$8)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$9 -> {
                    x$9.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$10 -> {
                    x$10.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$11)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$12 -> {
                    x$12.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$13 -> {
                    x$13.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$14 -> {
                    x$14.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$15)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$16 -> {
                    x$16.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$, (Option<ClientMetricsReceiverPlugin>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                Metrics apply_metrics = this.metrics();
                Object var5_1 = null;
                this.brokerMetrics_$eq(new BrokerServerMetrics(apply_metrics));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.clusterId(), this.sharedServerConfig(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$17 -> {}, x$18 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics());
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.nodeId()).setRaftClient(_raftManager.client()).setMetrics(new SnapshotEmitterMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time())).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            try {
                this.loader().installPublishers(Arrays.asList(this.snapshotGenerator())).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            throw e;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().close(), this, Level.WARN);
            this.loader_$eq(null);
        }
        if (this.metadataLoaderMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metadataLoaderMetrics().close(), this, Level.WARN);
            this.metadataLoaderMetrics_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().close(), this, Level.WARN);
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.controllerServerMetrics().close(), this, Level.WARN);
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.brokerMetrics().close(), this, Level.WARN);
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.metrics().close(), this, Level.WARN);
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$8) {
        return x$8.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$11) {
        return x$11.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$15) {
        return x$15.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaPropertiesEnsemble metaPropsEnsemble, Time time, Metrics _metrics, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaPropsEnsemble = metaPropsEnsemble;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

