/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerChannelManagerImpl;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0006\f\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005\u0002qAQa\f\u0001\u0005\u0002ABQ!\u0017\u0001\u0005\u0002iCq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAI\u0001\u0011\u0005\u00111\u0013\u0002\u001e\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|gNU3rk\u0016\u001cH\u000fV3ti*\u0011A\"D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001#A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0006\u0002A\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u000b\u0003;\u001d\u0002\"AH\u0013\u000e\u0003}Q!\u0001\u0004\u0011\u000b\u00059\t#B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001eL!AJ\u0010\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\b\"\u0002\u0015\u0003\u0001\u0004I\u0013aD2mkN$XM]%ogR\fgnY3\u0011\u0005)jS\"A\u0016\u000b\u00051j\u0011\u0001\u0002;fgRL!AL\u0016\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fab]3oI\u0006sGMU3dK&4X-F\u00022\u001dR\"BA\r\"E)B\u00111\u0007\u000e\u0007\u0001\t\u0015)4A1\u00017\u0005\u0005\u0011\u0016CA\u001c;!\t\u0011\u0002(\u0003\u0002:'\t9aj\u001c;iS:<\u0007CA\u001eA\u001b\u0005a$BA\u001f?\u0003!\u0011X-];fgR\u001c(BA !\u0003\u0019\u0019w.\\7p]&\u0011\u0011\t\u0010\u0002\u0011\u0003\n\u001cHO]1diJ+7\u000f]8og\u0016DQaQ\u0002A\u0002u\tab\u00195b]:,G.T1oC\u001e,'\u000fC\u0003F\u0007\u0001\u0007a)\u0001\u0006sKF\u0014U/\u001b7eKJ\u00042a\u0012&N\u001d\tY\u0004*\u0003\u0002Jy\u0005y\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH/\u0003\u0002L\u0019\n9!)^5mI\u0016\u0014(BA%=!\t\u0019d\nB\u0003P\u0007\t\u0007\u0001KA\u0001U#\t9\u0014\u000b\u0005\u0002<%&\u00111\u000b\u0010\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\")Qk\u0001a\u0001-\u0006IA/[7f_V$Xj\u001d\t\u0003%]K!\u0001W\n\u0003\u0007%sG/\u0001\bsK\u001eL7\u000f^3s\u0005J|7.\u001a:\u0015\rm\u000b'm\\9z!\tav,D\u0001^\u0015\tqf(\u0001\u0005qe>$xnY8m\u0013\t\u0001WL\u0001\u0004FeJ|'o\u001d\u0005\u0006\u0007\u0012\u0001\r!\b\u0005\u0006G\u0012\u0001\r\u0001Z\u0001\nG2,8\u000f^3s\u0013\u0012\u0004\"!\u001a7\u000f\u0005\u0019T\u0007CA4\u0014\u001b\u0005A'BA5\u0010\u0003\u0019a$o\\8u}%\u00111nE\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002l'!)\u0001\u000f\u0002a\u0001-\u0006A!M]8lKJLE\rC\u0003s\t\u0001\u00071/A\u0004{W\u0016\u0003xn\u00195\u0011\u0007I!h/\u0003\u0002v'\t1q\n\u001d;j_:\u0004\"AE<\n\u0005a\u001c\"\u0001\u0002'p]\u001eDQA\u001f\u0003A\u0002m\f\u0011\"\u001b2q)>\u001cVM\u001c3\u0011\u0007I!H\u0010\u0005\u0003\u0013{~|\u0018B\u0001@\u0014\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011AA\u0003\u001b\t\t\u0019A\u0003\u0002@?%!\u0011qAA\u0002\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001D2sK\u0006$X\rV8qS\u000e\u001cH#B.\u0002\u000e\u0005=\u0001\"B\"\u0006\u0001\u0004i\u0002BBA\t\u000b\u0001\u0007A-A\u0005u_BL7MT1nK\u0006AC/Z:u%\u0016<\u0017n\u001d;fej[w+\u001b;i\u0017J\u000bg\r^'jOJ\fG/[8o\t&\u001c\u0018M\u00197fIR!\u0011qCA\u000f!\r\u0011\u0012\u0011D\u0005\u0004\u00037\u0019\"\u0001B+oSRDQ\u0001\u000b\u0004A\u0002%BsCBA\u0011\u0003[\ty#!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\ni%a\u0014\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t)CA\u0006DYV\u001cH/\u001a:UKN$\u0018aC2mkN$XM\u001d+za\u0016$#!!\r\n\t\u0005M\u0012QG\u0001\u0006\u0017J\u000be\t\u0016\u0006\u0005\u0003o\t)#\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0001\u0005Y1m\u001c8ue>dG.\u001a:t;\u0005\t\u0011aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8%\u0005\u0005\u0015\u0013\u0002BA$\u0003\u0013\n1\"\u0013\"Q?NzFgX%Wa)!\u00111JA\u0002\u0003=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001E:feZ,'\u000f\u0015:pa\u0016\u0014H/[3tY\t\t\tf\u000b\u0006\u0002T\u0005e\u00131LA0\u0003C\u0002B!a\t\u0002V%!\u0011qKA\u0013\u0005U\u0019E.^:uKJ\u001cuN\u001c4jOB\u0013x\u000e]3sif\f1a[3zC\t\ti&A\u0012{_>\\W-\u001a9fe:jW\r^1eCR\fg&\\5he\u0006$\u0018n\u001c8/K:\f'\r\\3\u0002\u000bY\fG.^3\"\u0005\u0005\r\u0014!\u00024bYN,\u0017A\b;fgR\u0014VmZ5ti\u0016\u0014(l[,ji\"\u001c4gQ8oiJ|G\u000e\\3s)\u0011\t9\"!\u001b\t\u000b!:\u0001\u0019A\u0015)/\u001d\t\t#!\f\u00020\u0005e\u00121HA\u001f\u0003\u007f\t\t%!\u001c\u0002N\u0005MDEAA8\u0013\u0011\t\t(!\u0013\u0002\u0017%\u0013\u0005kX\u001a`g}Kek\r\u0017\u0003\u0003#\nq\u0005^3tiJ+w-[:uKJT6nV5uQ.\u0013\u0016M\u001a;NS\u001e\u0014\u0018\r^5p]\u0016s\u0017M\u00197fIR!\u0011qCA=\u0011\u0015A\u0003\u00021\u0001*QmA\u0011\u0011EA\u0017\u0003_\tI$a\u0010\u0002>\u0005}\u0012\u0011IA\"\u0003{\ny(!\u0014\u0002\n\u0006I\u0011-\u001e;p'R\f'\u000f\u001e\u0013\u0003\u0003\u0003KA!a!\u0002\u0006\u0006\u0011aj\u0014\u0006\u0005\u0003\u000f\u000b)#A\u0005BkR|7\u000b^1si2\u0012\u00111R\u0016\u000b\u0003'\nI&a\u0017\u0002`\u00055\u0015EAAH\u0003\u0011!(/^3\u0002OQ,7\u000f\u001e(p\u001b\u0016$\u0018\rZ1uC\u000eC\u0017M\\4fg&s\u0007K]3NS\u001e\u0014\u0018\r^5p]6{G-\u001a\u000b\u0005\u0003/\t)\nC\u0003)\u0013\u0001\u0007\u0011\u0006K\u0004\n\u00033\u000by&a(\u0011\t\u0005\r\u00121T\u0005\u0005\u0003;\u000b)C\u0001\u0007DYV\u001cH/\u001a:UKN$8\u000f\f\u0002\u0002\".2\u0012\u0011EA\u0017\u0003_\ti(a \u0002>\u0005}\u0012\u0011IA\"\u0003\u001b\n\u0019\u000b\f\u0002\u0002\f\":\u0001!a*\u0002`\u0005m\u0006\u0003BAU\u0003ok!!a+\u000b\t\u00055\u0016qV\u0001\u0004CBL'\u0002BAY\u0003g\u000bqA[;qSR,'OC\u0002\u00026\u000e\nQA[;oSRLA!!/\u0002,\n9A+[7f_V$h$\u0001=)\u000f\u0001\ty,a\u0018\u0002FB!\u0011\u0011VAa\u0013\u0011\t\u0019-a+\u0003\u0007Q\u000bw-\t\u0002\u0002H\u0006Y\u0011N\u001c;fOJ\fG/[8oQ\u001d\u0001\u00111ZA0\u0003/\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0005\u0003#\fY+A\u0005fqR,gn]5p]&!\u0011Q[Ah\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0003\u00033\u001c#!a7\u0011\t\u0005u\u0017\u0011]\u0007\u0003\u0003?T1!!.,\u0013\u0011\t\u0019/a8\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\u0002")
public class BrokerRegistrationRequestTest {
    public NodeToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        return new NodeToControllerChannelManagerImpl(new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort(this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            private boolean isZkController() {
                return !this.clusterInstance$1.isKRaftTest();
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism(), this.isZkController());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        }, Time.SYSTEM, new Metrics(), clusterInstance.anyControllerSocketServer().config(), "heartbeat", "test-heartbeat-", 10000L);
    }

    public <T extends AbstractRequest, R extends AbstractResponse> R sendAndReceive(NodeToControllerChannelManager channelManager, AbstractRequest.Builder<T> reqBuilder, int timeoutMs) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest(reqBuilder, new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(response.responseBody());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (R)((AbstractResponse)responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS));
    }

    public Errors registerBroker(NodeToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<MetadataVersion, MetadataVersion>> ibpToSend) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ibpToSend.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(features, x0$1)));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features);
        return Errors.forCode((short)((BrokerRegistrationResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), 30000)).data().errorCode());
    }

    public Errors createTopics(NodeToControllerChannelManager channelManager, String topicName) {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTopics(new CreateTopicsRequestData.CreatableTopicCollection());
        createTopics.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(10).setReplicationFactor((short)1));
        createTopics.setTimeoutMs(500);
        CreateTopicsRequest.Builder req = new CreateTopicsRequest.Builder(createTopics);
        return Errors.forCode((short)((CreateTopicsResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)req, 3000)).data().topics().find(topicName).errorCode());
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWithKRaftMigrationDisabled(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWith33Controller(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabled(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$1 -> x$1.startup());
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, autoStart=AutoStart.NO, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})})
    public void testNoMetadataChangesInPreMigrationMode(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().forEach(x$2 -> x$2.startup());
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertThrows(TimeoutException.class, () -> this.createTopics(channelManager, "test-pre-migration"));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataVersion min = (MetadataVersion)x0$1._1();
            MetadataVersion max = (MetadataVersion)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min.featureLevel()).setMaxSupportedVersion(max.featureLevel()));
        }
        throw new MatchError(null);
    }
}

