/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t-e\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004I\u0001\u0001\u0006I!\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003=\u0011\u0019Q\u0005\u0001)A\u0005{!91\n\u0001b\u0001\n\u0013a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\r\r\u0004\u0001\u0015!\u0003T\u0011\u001d!\u0007A1A\u0005\n\u0015Daa\u001a\u0001!\u0002\u00131\u0007b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007[\u0002\u0001\u000b\u0011\u00026\t\u000f9\u0004!\u0019!C\u0005_\"11\u000f\u0001Q\u0001\nADq\u0001\u001e\u0001C\u0002\u0013%Q\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002<\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u0010\u0001\u0001\u0006I!a\u0005\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005\r\u0002\u0002CA\u0019\u0001\u0001\u0006I!!\n\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013%\u00111\u000b\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\tI\t\u0001C\u0001\u0003WBq!!$\u0001\t\u0003\tY\u0007C\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005m\u0006\u0001\"\u0001\u0002l!9\u0011q\u0018\u0001\u0005\u0002\u0005-\u0004bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0005\u0013\u0001A\u0011AA6\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003WBqA!\u0005\u0001\t\u0003\tY\u0007C\u0004\u0003\u0016\u0001!\t!a\u001b\t\u000f\te\u0001\u0001\"\u0001\u0002l!9!Q\u0004\u0001\u0005\u0002\u0005-\u0004b\u0002B\u0011\u0001\u0011\u0005\u00111\u000e\u0005\b\u0005K\u0001A\u0011AA6\u0011\u001d\u0011I\u0003\u0001C\u0001\u0003WBqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u0003Z\u0001!\tAa\u0017\u0003;I+\u0007\u000f\\5dC\u0006cG/\u001a:M_\u001e$\u0015N]:UQJ,\u0017\r\u001a+fgRT!\u0001L\u0017\u0002\rM,'O^3s\u0015\u0005q\u0013!B6bM.\f7\u0001A\n\u0003\u0001E\u0002\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001:!\tQ\u0004!D\u0001,\u0003\u0011!\u0018\u0007\u001d\u0019\u0016\u0003u\u0002\"A\u0010$\u000e\u0003}R!\u0001Q!\u0002\r\r|W.\\8o\u0015\tq#I\u0003\u0002D\t\u00061\u0011\r]1dQ\u0016T\u0011!R\u0001\u0004_J<\u0017BA$@\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ\u0001^\u0019qa\u0001\nA\u0001^\u0019qc\u0005)A/\r92A\u00059Ao\u001c9jG&#W#A'\u0011\u0005yr\u0015BA(@\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\n\u0001\u0002^8qS\u000eLEm]\u000b\u0002'B!A+W.N\u001b\u0005)&B\u0001,X\u0003%IW.\\;uC\ndWM\u0003\u0002Yg\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005i+&aA'baB\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005Y\u0006twMC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&AB*ue&tw-A\u0005u_BL7-\u00133tA\u0005QAo\u001c9jG:\u000bW.Z:\u0016\u0003\u0019\u0004B\u0001V-N7\u0006YAo\u001c9jG:\u000bW.Z:!\u0003\u0019!\u0018\u000eZ\u0019qaU\t!\u000e\u0005\u0002?W&\u0011An\u0010\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\fq\u0001^5ecA\u0004\u0004%\u0001\tgC&dW\r\u001a)beRLG/[8ogV\t\u0001\u000f\u0005\u0002;c&\u0011!o\u000b\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f\u0011CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:!\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001cX#\u0001<\u0011\u0007]TH0D\u0001y\u0015\tIx,\u0001\u0003vi&d\u0017BA>y\u0005\u0011a\u0015n\u001d;\u0011\u0007u\f9AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003y\u0014aB7fgN\fw-Z\u0005\u0004\u0003\u000by\u0018!G+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e#bi\u0006LA!!\u0003\u0002\f\taR\u000b\u001d3bi\u0016lU\r^1eCR\f\u0007+\u0019:uSRLwN\\*uCR,'bAA\u0003\u007f\u0006\u0001\u0002/\u0019:uSRLwN\\*uCR,7\u000fI\u0001\u0016kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbP\u0001\te\u0016\fX/Z:ug&!\u0011QDA\f\u0005U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\fa#\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-2&\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\ty#!\u000b\u0003\u001fi[W*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%A\tj]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016$b!a\u000e\u0002>\u0005\u001d\u0003c\u0001\u001e\u0002:%\u0019\u00111H\u0016\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0002@Y\u0001\r!!\u0011\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\t\u0004e\u0005\r\u0013bAA#g\t!Aj\u001c8h\u0011%\tIE\u0006I\u0001\u0002\u0004\tY%A\u0006mK\u0006$WM]#q_\u000eD\u0007c\u0001\u001a\u0002N%\u0019\u0011qJ\u001a\u0003\u0007%sG/A\u000ej]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003+RC!a\u0013\u0002X-\u0012\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003%)hn\u00195fG.,GMC\u0002\u0002dM\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9'!\u0018\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0017tQ>,H\u000e\u001a(pi\u0006#G\rU1si&$\u0018n\u001c8JM\u001a+H/\u001e:f\u0019><\u0017j\u001d(pi\u0012+g-\u001b8fIR\u0011\u0011Q\u000e\t\u0004e\u0005=\u0014bAA9g\t!QK\\5uQ\rA\u0012Q\u000f\t\u0005\u0003o\n))\u0004\u0002\u0002z)!\u00111PA?\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u007f\n\t)A\u0004kkBLG/\u001a:\u000b\u0007\u0005\rE)A\u0003kk:LG/\u0003\u0003\u0002\b\u0006e$\u0001\u0002+fgR\fAf\u001d5pk2$W\u000b\u001d3bi\u0016dU-\u00193fe\u0016\u0003xn\u00195BMR,'OR3oG\u0016$W\t]8dQ\u0016\u0013(o\u001c:)\u0007e\t)(\u0001\u0014tQ>,H\u000e\u001a*fa2\f7-Z\"veJ,g\u000e\u001e'pO\u0012K'o\u00165f]\u000e\u000bWo\u001a5u+BD3AGA;\u0003q)\b\u000fZ1uK\u0006\u001b8/[4o[\u0016tGOU3rk\u0016\u001cHo\u0015;bi\u0016$\u0002\"!&\u0002\u001c\u0006\u0015\u0016\u0011\u0016\t\u0006e\u0005]\u0015QN\u0005\u0004\u00033\u001b$AB(qi&|g\u000eC\u0004\u0002\u001en\u0001\r!a(\u0002\rQD'/Z1e!\rQ\u0014\u0011U\u0005\u0004\u0003G[#!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012Dq!a*\u001c\u0001\u0004\tY%A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBAV7\u0001\u0007\u0011QV\u0001\t]\u0016<8\u000b^1uKB!\u0011qVA[\u001d\rQ\u0014\u0011W\u0005\u0004\u0003g[\u0013!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012LA!a.\u0002:\nQB)\u001b:fGR|'/_#wK:$(+Z9vKN$8\u000b^1uK*\u0019\u00111W\u0016\u0002!NDw.\u001e7e%\u0016\u0004H.Y2f\u0007V\u0014(/\u001a8u\u0019><G)\u001b:XQ\u0016t7)Y;hQR,\u0006oV5uQ\u00063G/\u001a:BgNLwM\\7f]R\u0014V-];fgRD\u0015m\u001d\"fK:\u001cu.\u001c9mKR,G\rK\u0002\u001d\u0003k\n\u0001i\u001d5pk2$'+\u001a<feR\fe._*dQ\u0016$W\u000f\\3e\u0003N\u001c\u0018n\u001a8nK:$(+Z9vKN$\u0018JZ!tg&<g.\\3oi&\u001b8)\u00198dK2dW\r\u001a\u0015\u0004;\u0005U\u0014aF7pG.4U\r^2i\rJ|WnQ;se\u0016tG\u000fT8h)1\ti'a2\u0002L\u0006u\u0017q]Ay\u0011\u0019\tIM\ba\u0001U\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u001bt\u0002\u0019AAh\u0003-\u0011X-];fgR$\u0015\r^1\u0011\t\u0005E\u0017q\u001b\b\u0005\u0003+\t\u0019.\u0003\u0003\u0002V\u0006]\u0011\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002BAm\u00037\u0014Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002BAk\u0003/Aq!a8\u001f\u0001\u0004\t\t/\u0001\u0004d_:4\u0017n\u001a\t\u0004u\u0005\r\u0018bAAsW\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\tIO\ba\u0001\u0003W\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002;\u0003[L1!a<,\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!a=\u001f\u0001\u0004\t)0\u0001\u0007sKN\u0004xN\\:f\t\u0006$\u0018\r\u0005\u0003\u0002x\n\u0015QBAA}\u0015\u0011\tY0!@\u0002\u00071|wM\u0003\u0003\u0002\u0000\n\u0005\u0011!C5oi\u0016\u0014h.\u00197t\u0015\r\u0011\u0019!Q\u0001\bgR|'/Y4f\u0013\u0011\u00119!!?\u0003%\u0019+Go\u00195QCJ$\u0018\u000e^5p]\u0012\u000bG/Y\u0001#SN\u001cX/Z:Fa>\u001c\u0007NU3rk\u0016\u001cHO\u0012:p[2{7-\u00197SKBd\u0017nY1)\u0007}\t)(A\u001fgKR\u001c\u0007.\u00129pG\"\u001chI]8n\u0019\u0016\fG-\u001a:TQ>,H\u000e\u001a%b]\u0012dW-\u0012=dKB$\u0018n\u001c8Ge>lw)\u001a;M_\u000e\fGNU3qY&\u001c\u0017\rK\u0002!\u0003k\nQd\u001d5pk2$GK];oG\u0006$X\rV8SKBd\u0017nY1PM\u001a\u001cX\r\u001e\u0015\u0004C\u0005U\u0014!L:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u000b:$wJ\u001a4tKR|e\rT1sO\u0016\u001cHoQ8n[>tW\t]8dQ\"\u001a!%!\u001e\u0002\u0003NDw.\u001e7e)J,hnY1uKR{\u0017J\\5uS\u0006dg)\u001a;dQ>3gm]3u\u0013\u001a\u0014V\r\u001d7jG\u0006\u0014V\r^;s]N,f\u000eZ3gS:,Gm\u00144gg\u0016$\bfA\u0012\u0002v\u0005Y3\u000f[8vY\u0012\u0004v\u000e\u001c7J]\u0012,g-\u001b8ji\u0016d\u00170\u00134SKBd\u0017nY1O_R\fe/Y5mC\ndW\rK\u0002%\u0003k\nae\u001d5pk2$g)\u001a;dQ2+\u0017\rZ3s\u000bB|7\r[(o\r&\u00148\u000f\u001e$fi\u000eDwJ\u001c7zQ\r)\u0013QO\u0001\u001dg\"|W\u000f\u001c3GKR\u001c\u0007n\u00148f%\u0016\u0004H.[2b\u0003R\fE+[7fQ\r1\u0013QO\u0001.g\"|W\u000f\u001c3GKR\u001c\u0007NT8o\t\u0016d\u0017-_3e\u0003:$gj\u001c8UeVt7-\u0019;j]\u001e\u0014V\r\u001d7jG\u0006\u001c\bfA\u0014\u0002v\u0005!1\u000f^;c)1\tiG!\r\u0003@\t\r#q\tB,\u0011\u001d\u0011\u0019\u0004\u000ba\u0001\u0005k\tq\u0001\\8h)F\u0002\b\u0007\u0005\u0003\u00038\tmRB\u0001B\u001d\u0015\r\tY0L\u0005\u0005\u0005{\u0011ID\u0001\u0006V]&4\u0017.\u001a3M_\u001eDqA!\u0011)\u0001\u0004\u0011)$A\u0004m_\u001e$\u0016\u0007]\u0019\t\u000f\t\u0015\u0003\u00061\u0001\u00036\u0005Ia-\u001e;ve\u0016dun\u001a\u0005\b\u0005\u0013B\u0003\u0019\u0001B&\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0003N\tMSB\u0001B(\u0015\r\u0011\t&L\u0001\bG2,8\u000f^3s\u0013\u0011\u0011)Fa\u0014\u0003\u0013A\u000b'\u000f^5uS>t\u0007bBAuQ\u0001\u0007\u00111^\u0001\u0016gR,(mV5uQ\u001a+Go\u00195NKN\u001c\u0018mZ3t)9\tiG!\u0018\u0003`\t\u0005$1\rB3\u0005OBqAa\r*\u0001\u0004\u0011)\u0004C\u0004\u0003B%\u0002\rA!\u000e\t\u000f\t\u0015\u0013\u00061\u0001\u00036!9!\u0011J\u0015A\u0002\t-\u0003bBAuS\u0001\u0007\u00111\u001e\u0005\b\u0005SJ\u0003\u0019\u0001B6\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0004\u0003n\tM$qO\u0007\u0003\u0005_R1A!\u001dE\u0003\u001diwnY6ji>LAA!\u001e\u0003p\tq\u0011I]4v[\u0016tGoQ1qi>\u0014\bc\u0002\u001a\u0003z\tu\u0014QN\u0005\u0004\u0005w\u001a$!\u0003$v]\u000e$\u0018n\u001c82!\u0019\u0011yH!!\u0003\u00066\tq+C\u0002\u0003\u0004^\u00131aU3r!\u0019\u0011$q\u00116\u0002v&\u0019!\u0011R\u001a\u0003\rQ+\b\u000f\\33\u0001")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final Uuid topicId = Uuid.randomUuid();
    private final scala.collection.immutable.Map<String, Uuid> topicIds = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId())}));
    private final scala.collection.immutable.Map<Uuid, String> topicNames = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicId()), (Object)"topic1")}));
    private final TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId(), this.t1p0());
    private final FailedPartitions failedPartitions = new FailedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$)).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicIds()).asJava()).build();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latestTesting(), BrokerFeatures$.MODULE$.createEmpty(), (Seq)Seq$.MODULE$.empty(), false);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private scala.collection.immutable.Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private scala.collection.immutable.Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    private TopicIdPartition tid1p0() {
        return this.tid1p0;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private InitialFetchState initialFetchState(long fetchOffset, int leaderEpoch) {
        Some x$1 = new Some((Object)this.topicId());
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState((Option)x$1, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$2() {
        return 1;
    }

    @Test
    public void shouldNotAddPartitionIfFutureLogIsNotDefined() {
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(Optional.empty()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        Set addedPartitions = thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)addedPartitions);
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
    }

    @Test
    public void shouldUpdateLeaderEpochAfterFencedEpochError() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData fencedRequestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)));
        FetchPartitionData fencedResponseData = new FetchPartitionData(Errors.FENCED_LEADER_EPOCH, -1L, -1L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), fencedRequestData, config, replicaManager, fencedResponseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-log-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(Optional.empty()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch - 1))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.currentLeaderEpoch())));
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        thread.doWork();
        Assertions.assertFalse((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUp() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(Optional.empty()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    public Option<BoxedUnit> updateAssignmentRequestState(ReplicaAlterLogDirsThread thread, int partitionId, ReplicaAlterLogDirsThread.DirectoryEventRequestState newState) {
        return this.topicNames().get((Object)this.topicId()).map((Function1 & Serializable)topicName -> {
            thread.updatedAssignmentRequestState(new TopicPartition(topicName, partitionId), newState);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUpWithAfterAssignmentRequestHasBeenCompleted() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.futureReplicaDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(Optional.empty()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), directoryEventHandler);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateAssignmentRequestState(thread, partitionId, (ReplicaAlterLogDirsThread.DirectoryEventRequestState)ReplicaAlterLogDirsThread.QUEUED$.MODULE$);
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateAssignmentRequestState(thread, partitionId, (ReplicaAlterLogDirsThread.DirectoryEventRequestState)ReplicaAlterLogDirsThread.COMPLETED$.MODULE$);
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Mockito.verifyNoInteractions((Object[])new Object[]{directoryEventHandler});
    }

    @Test
    public void shouldRevertAnyScheduledAssignmentRequestIfAssignmentIsCancelled() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        DirectoryEventHandler directoryEventHandler = (DirectoryEventHandler)Mockito.mock(DirectoryEventHandler.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)partition.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)partition.futureReplicaDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)partition.logDirectoryId()).thenReturn((Object)new Some((Object)Uuid.randomUuid()));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FetchRequest.PartitionData requestData = new FetchRequest.PartitionData(this.topicId(), 0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, Optional.empty(), OptionalLong.empty(), Optional.empty(), OptionalInt.empty(), false);
        this.mockFetchFromCurrentLog(this.tid1p0(), requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats(Optional.empty()), Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), directoryEventHandler);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        this.updateAssignmentRequestState(thread, partitionId, (ReplicaAlterLogDirsThread.DirectoryEventRequestState)ReplicaAlterLogDirsThread.QUEUED$.MODULE$);
        thread.removePartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0()})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isEmpty());
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        ArgumentCaptor topicIdPartitionCaptureT1p0 = ArgumentCaptor.forClass(org.apache.kafka.server.common.TopicIdPartition.class);
        ArgumentCaptor logIdCaptureT1p0 = ArgumentCaptor.forClass(Uuid.class);
        ((DirectoryEventHandler)Mockito.verify((Object)directoryEventHandler)).handleAssignment((org.apache.kafka.server.common.TopicIdPartition)topicIdPartitionCaptureT1p0.capture(), (Uuid)logIdCaptureT1p0.capture(), (Runnable)ArgumentMatchers.any());
        Assertions.assertEquals((Object)new org.apache.kafka.server.common.TopicIdPartition(this.topicId(), this.t1p0().partition()), (Object)topicIdPartitionCaptureT1p0.getValue());
        Assertions.assertEquals((Object)partition.logDirectoryId().get(), (Object)logIdCaptureT1p0.getValue());
    }

    private void mockFetchFromCurrentLog(TopicIdPartition topicIdPartition, FetchRequest.PartitionData requestData, KafkaConfig config, ReplicaManager replicaManager, FetchPartitionData responseData) {
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(Function1.class);
        FetchParams expectedFetchParams = new FetchParams(ApiKeys.FETCH.latestVersion(), -3, -1L, 0L, 0, Predef$.MODULE$.Integer2int(config.replicaFetchResponseMaxBytes()), FetchIsolation.LOG_END, Optional.empty());
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.eq((Object)expectedFetchParams), (Seq)ArgumentMatchers.eq((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)requestData), (List)Nil$.MODULE$)), (ReplicaQuota)ArgumentMatchers.eq((Object)QuotaFactory.UnboundedQuota$.MODULE$), (Function1)callbackCaptor.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$mockFetchFromCurrentLog$1(callbackCaptor, topicIdPartition, responseData, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, null, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpochT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpochT1p1))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1))}))), (Object)result, (String)"results from leader epoch request should have offset from local replica");
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int partitionId = 0;
        int leaderEpoch = 2;
        int leo = 13;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenThrow(new Throwable[]{new KafkaStorageException()});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, null);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, null, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP).leader().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpoch))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.KAFKA_STORAGE_ERROR.code()))}))), (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        ArgumentCaptor truncateCaptureT1p0 = ArgumentCaptor.forClass(Long.TYPE);
        ArgumentCaptor truncateCaptureT1p1 = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog logT1p0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog logT1p1 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLogT1p0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLogT1p1 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partitionT1p0 = (Partition)Mockito.mock(Partition.class);
        Partition partitionT1p1 = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partitionT1p1.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partitionT1p0);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partitionT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLogT1p0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLogT1p1);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLogT1p0.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p0LEO));
        Mockito.when((Object)futureLogT1p1.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p1LEO));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partitionT1p0)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.capture()), ArgumentMatchers.anyBoolean());
        ((Partition)Mockito.verify((Object)partitionT1p1)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2))));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 1).setEndOffset((long)replicaLEO));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2)));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 2).setEndOffset((long)replicaEpochEndOffset));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        thread.doWork();
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)), (String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getAllValues()).toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(initialFetchOffset, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()), (String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET");
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        Mockito.when((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(futureReplicaLeaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(responseCallback, x$3);
            return BoxedUnit.UNIT;
        });
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((int)0, (int)truncated.getAllValues().size());
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.eq((boolean)true));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ArgumentCaptor responseCallback = ArgumentCaptor.forClass(Function1.class);
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaLEO));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(futureReplicaLEO)));
        Mockito.when((Object)futureLog.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition)).lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false);
        ((Partition)Mockito.verify((Object)partition)).truncateTo((long)futureReplicaLEO, true);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void var14_14;
        void var13_13;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        Assertions.assertTrue((boolean)var13_13.isDefined());
        FetchRequest.Builder fetchRequest = ((AbstractFetcherThread.ReplicaFetch)var13_13.get()).fetchRequest();
        Assertions.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assertions.assertFalse((boolean)var14_14.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assertions.assertEquals((int)0, (int)request.minBytes());
        scala.collection.immutable.Seq fetchInfos = CollectionConverters$.MODULE$.MapHasAsScala(request.fetchData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava())).asScala().toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for first partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void var25_40;
        void var24_39;
        void var20_35;
        void var19_34;
        void apply_lastFetchedEpoch;
        void apply_state;
        void apply_lag;
        void apply_offset;
        void var15_25;
        void var14_24;
        void apply_lastFetchedEpoch2;
        void apply_state2;
        void apply_lag2;
        void apply_offset2;
        void apply_lastFetchedEpoch3;
        void apply_state3;
        void apply_lag3;
        void apply_offset3;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        UnifiedLog futureLog = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int startOffset = 123;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(startOffset)));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        this.stub(log, null, futureLog, partition, replicaManager);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        LocalLeaderEndPoint leader = new LocalLeaderEndPoint(endPoint, config, replicaManager, (ReplicaQuota)quotaManager);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", (LeaderEndPoint)leader, this.failedPartitions(), replicaManager, quotaManager, null, Predef$.MODULE$.Integer2int(config.replicaFetchBackoffMs()), DirectoryEventHandler.NOOP);
        thread.addPartitions((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Object[] objectArray = new Tuple2[2];
        None$ none$ = None$.MODULE$;
        Fetching$ fetching$ = Fetching$.MODULE$;
        None$ none$2 = None$.MODULE$;
        long l = 150L;
        Some apply_topicId = new Some((Object)this.topicId());
        Object var26_17 = null;
        none$2 = null;
        fetching$ = null;
        none$ = null;
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)apply_topicId, (long)apply_offset3, (Option)apply_lag3, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state3, (Option)apply_lastFetchedEpoch3));
        None$ none$3 = None$.MODULE$;
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ none$4 = None$.MODULE$;
        long l2 = 160L;
        Some apply_topicId2 = new Some((Object)this.topicId());
        Object var32_22 = null;
        none$4 = null;
        truncating$ = null;
        none$3 = null;
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)apply_topicId2, (long)apply_offset2, (Option)apply_lag2, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state2, (Option)apply_lastFetchedEpoch2));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        Assertions.assertTrue((boolean)var14_24.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest = (AbstractFetcherThread.ReplicaFetch)var14_24.get();
        Assertions.assertFalse((boolean)fetchRequest.partitionData().isEmpty());
        Assertions.assertFalse((boolean)var15_25.nonEmpty());
        scala.collection.immutable.Seq fetchInfos = CollectionConverters$.MODULE$.MapHasAsScala(((FetchRequest)fetchRequest.fetchRequest().build()).fetchData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava())).asScala().toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos.head())._1()).topicPartition(), (String)"Expected fetch request for non-truncating partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
        Object[] objectArray2 = new Tuple2[2];
        None$ none$5 = None$.MODULE$;
        Fetching$ fetching$2 = Fetching$.MODULE$;
        None$ none$6 = None$.MODULE$;
        long l3 = 140L;
        Some apply_topicId3 = new Some((Object)this.topicId());
        Object var38_32 = null;
        none$6 = null;
        fetching$2 = null;
        none$5 = null;
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)apply_topicId3, (long)apply_offset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state, (Option)apply_lastFetchedEpoch));
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
        Set partitionsWithError2 = resultWithPartitions2.partitionsWithError();
        Assertions.assertTrue((boolean)var19_34.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest2 = (AbstractFetcherThread.ReplicaFetch)var19_34.get();
        Assertions.assertFalse((boolean)fetchRequest2.partitionData().isEmpty());
        Assertions.assertFalse((boolean)var20_35.nonEmpty());
        scala.collection.immutable.Seq fetchInfos2 = CollectionConverters$.MODULE$.MapHasAsScala(((FetchRequest)fetchRequest2.fetchRequest().build()).fetchData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava())).asScala().toSeq();
        Assertions.assertEquals((int)1, (int)fetchInfos2.length());
        Assertions.assertEquals((Object)this.t1p0(), (Object)((TopicIdPartition)((Tuple2)fetchInfos2.head())._1()).topicPartition(), (String)"Expected fetch request for non-delayed partition");
        Assertions.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.leader().buildFetch((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 140L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
        Set partitionsWithError3 = resultWithPartitions3.partitionsWithError();
        Assertions.assertTrue((boolean)var24_39.isEmpty(), (String)"Expected no fetch requests since all partitions are delayed");
        Assertions.assertFalse((boolean)var25_40.nonEmpty());
    }

    public void stub(UnifiedLog logT1p0, UnifiedLog logT1p1, UnifiedLog futureLog, Partition partition, ReplicaManager replicaManager) {
        Mockito.when((Object)replicaManager.localLog(this.t1p0())).thenReturn((Object)new Some((Object)logT1p0));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)logT1p0);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.localLog(this.t1p1())).thenReturn((Object)new Some((Object)logT1p1));
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)logT1p1);
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p1())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p1())).thenReturn((Object)new Some((Object)partition));
    }

    public void stubWithFetchMessages(UnifiedLog logT1p0, UnifiedLog logT1p1, UnifiedLog futureLog, Partition partition, ReplicaManager replicaManager, ArgumentCaptor<Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages((FetchParams)ArgumentMatchers.any(), (Seq)ArgumentMatchers.any(), (ReplicaQuota)ArgumentMatchers.any(), (Function1)responseCallback.capture());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$10 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$stubWithFetchMessages$1(responseCallback, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$mockFetchFromCurrentLog$1(ArgumentCaptor callbackCaptor$1, TopicIdPartition topicIdPartition$1, FetchPartitionData responseData$1, InvocationOnMock x$2) {
        ((Function1)callbackCaptor$1.getValue()).apply((Object)new .colon.colon((Object)new Tuple2((Object)topicIdPartition$1, (Object)responseData$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(ArgumentCaptor responseCallback$1, InvocationOnMock x$3) {
        ((Function1)responseCallback$1.getValue()).apply((Object)Seq$.MODULE$.empty());
    }

    public static final /* synthetic */ void $anonfun$stubWithFetchMessages$1(ArgumentCaptor responseCallback$2, InvocationOnMock x$10) {
        ((Function1)responseCallback$2.getValue()).apply((Object)Seq$.MODULE$.empty());
    }

    public ReplicaAlterLogDirsThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

