/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.log.LogManager;
import kafka.log.remote.RemoteLogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerServer;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]h\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBQ!\u0011\u0001\u0005\u0002\tCQa\u0015\u0001\u0005\u0002\tCQ!\u0016\u0001\u0005\u0002\tCQa\u0016\u0001\u0005\u0002\tCQ!\u0017\u0001\u0005\u0002\tCQa\u0017\u0001\u0005\u0002\tCQ!\u0018\u0001\u0005\u0002\tCQa\u0018\u0001\u0005\u0002\tCQ!\u0019\u0001\u0005\u0002\tCQa\u0019\u0001\u0005\n\u0011Dq!a\u0002\u0001\t\u0013\tI\u0001\u0003\u0004\u00024\u0001!\tA\u0011\u0005\u0007\u0003o\u0001A\u0011\u0001\"\t\r\u0005m\u0002\u0001\"\u0001C\r\u0019\ty\u0004\u0001\u0001\u0002B!1Q\b\u0005C\u0001\u0003GB\u0011\"!\u001b\u0011\u0001\u0004%\t!a\u001b\t\u0013\u0005E\u0004\u00031A\u0005\u0002\u0005M\u0004\u0002CA=!\u0001\u0006K!!\u001c\t\u000f\u0005\r\u0005\u0003\"\u0011\u0002\u0006\"9\u0011q\u0018\t\u0005B\u0005\u0005\u0007bBAs!\u0011\u0005\u0013q\u001d\u0005\b\u0005#\u0001B\u0011\tB\n\u0011\u001d\u00119\u0004\u0005C!\u0005sAaA!\u0012\u0011\t\u0003\u0012\u0005b\u0002B$!\u0011\u0005#\u0011\n\u0005\b\u0005C\u0002B\u0011\tB2\u0011\u001d\u0011Y\u0007\u0005C!\u0005[BqAa\u001f\u0011\t\u0003\u0012i\b\u0003\u0004\u0003\f\u0002!\tA\u0011\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0011\u0019\u0011\t\u000b\u0001C\u0001\u0005\"9!Q\u0015\u0001\u0005\n\t\u001d\u0006B\u0002BW\u0001\u0011\u0005!\t\u0003\u0004\u00032\u0002!\tA\u0011\u0005\u0007\u0005k\u0003A\u0011\u0001\"\t\r\te\u0006\u0001\"\u0001C\u0011\u0019\u0011i\f\u0001C\u0001\u0005\"1!\u0011\u0019\u0001\u0005\u0002\tCaA!2\u0001\t\u0003\u0011\u0005B\u0002Be\u0001\u0011\u0005!\t\u0003\u0004\u0003N\u0002!\tA\u0011\u0005\u0007\u0005#\u0004A\u0011\u0001\"\t\r\tU\u0007\u0001\"\u0001C\u0011\u0019\u0011I\u000e\u0001C\u0001\u0005\"9!Q\u001c\u0001\u0005\u0002\t}'a\u0006#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<G+Z:u\u0015\t\u00114'\u0001\u0004tKJ4XM\u001d\u0006\u0002i\u0005)1.\u00194lC\u000e\u00011C\u0001\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011!M\u0001\u0011i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016$\u0012a\u0011\t\u0003q\u0011K!!R\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u001d\u0003\"\u0001S)\u000e\u0003%S!AS&\u0002\u0007\u0005\u0004\u0018N\u0003\u0002M\u001b\u00069!.\u001e9ji\u0016\u0014(B\u0001(P\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0016aA8sO&\u0011!+\u0013\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$XI\\1cY\u0016$UMZ1vYR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:D#aA$\u00027Q,7\u000f^+qI\u0006$X\rR=oC6L7\r\u00165sK\u0006$\u0007k\\8mQ\t!q)\u0001\u0014uKN$8i\u001c8gS\u001e,\u0006\u000fZ1uK^KG\u000f[*p[\u0016LeN^1mS\u0012\u001cuN\u001c4jOND#!B$\u0002gQ,7\u000f^\"p]\u001aLw-\u00169eCR,w+\u001b;i%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f-\u0006d\u0017\u000eZ1uS>tg)Y5mkJ,\u0007F\u0001\u0004H\u0003q!Xm\u001d;SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:D#aB$\u0002'Q,7\u000f^*fGV\u0014\u0018\u000e^=D_:4\u0017nZ:)\u0005!9\u0015a\u0005;fgR\u001cuN\u001c8fGRLwN\\)v_R\f\u0007FA\u0005H\u0003]!Xm\u001d;D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018\r\u000b\u0002\u000b\u000f\u0006\u0011b/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f)\u0019\u0019UM\u001d?\u0002\u0004!)am\u0003a\u0001O\u0006!a.Y7f!\tAwN\u0004\u0002j[B\u0011!.O\u0007\u0002W*\u0011A.N\u0001\u0007yI|w\u000e\u001e \n\u00059L\u0014A\u0002)sK\u0012,g-\u0003\u0002qc\n11\u000b\u001e:j]\u001eT!A\\\u001d\t\u000bM\\\u0001\u0019\u0001;\u0002\u000bY\fG.^3\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001\u00027b]\u001eT\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002|m\n1qJ\u00196fGRDQ!`\u0006A\u0002y\fq\u0002]3s\u0005J|7.\u001a:D_:4\u0017n\u001a\t\u0003q}L1!!\u0001:\u0005\u001d\u0011un\u001c7fC:Da!!\u0002\f\u0001\u0004q\u0018!D3ya\u0016\u001cGOR1jYV\u0014X-A\u0012wKJLg-_\"p]\u001aLw-\u00169eCR,w+\u001b;i\u0013:4\u0018\r\\5e\u0007>tg-[4\u0015\u0013\r\u000bY!!\u0006\u0002&\u0005=\u0002bBA\u0007\u0019\u0001\u0007\u0011qB\u0001\u0007G>tg-[4\u0011\u0007\u0001\u000b\t\"C\u0002\u0002\u0014E\u00121bS1gW\u0006\u001cuN\u001c4jO\"9\u0011q\u0003\u0007A\u0002\u0005e\u0011!C8sS\u001e\u0004&o\u001c9t!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010q\u0006!Q\u000f^5m\u0013\u0011\t\u0019#!\b\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002(1\u0001\r!!\u000b\u0002\u0015Y\fG.\u001b3Qe>\u00048\u000fE\u0003i\u0003W9w-C\u0002\u0002.E\u00141!T1q\u0011\u001d\t\t\u0004\u0004a\u0001\u0003S\tA\"\u001b8wC2LG\r\u0015:paN\fA\u0004^3tiB\u000b7o]<pe\u0012\u001cuN\u001c4jO\u0016s7M]=qi&|g\u000e\u000b\u0002\u000e\u000f\u0006)C/Z:u!\u0006\u001c8o^8sI\u000e{gNZ5h\u000b:\u001cw\u000eZ3s'\u0016\u001c'/\u001a;DQ\u0006tw-\u001a\u0015\u0003\u001d\u001d\u000b\u0011\u0004^3ti\u0012Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c4jO\"\u0012qb\u0012\u0002\u000f)\u0016\u001cH/Q;uQ>\u0014\u0018N_3s'\u0019\u0001B/a\u0011\u0002XA!\u0011QIA*\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013AC1vi\"|'/\u001b>fe*\u0019!'!\u0014\u000b\u0007Q\nyEC\u0002\u0002R=\u000ba!\u00199bG\",\u0017\u0002BA+\u0003\u000f\u0012!\"Q;uQ>\u0014\u0018N_3s!\u0011\tI&a\u0018\u000e\u0005\u0005m#\u0002BA/\u0003\u001b\naaY8n[>t\u0017\u0002BA1\u00037\u0012aBU3d_:4\u0017nZ;sC\ndW\r\u0006\u0002\u0002fA\u0019\u0011q\r\t\u000e\u0003\u0001\t!b];qKJ,6/\u001a:t+\t\ti\u0007E\u0002v\u0003_J!\u0001\u001d<\u0002\u001dM,\b/\u001a:Vg\u0016\u00148o\u0018\u0013fcR\u00191)!\u001e\t\u0013\u0005]4#!AA\u0002\u00055\u0014a\u0001=%c\u0005Y1/\u001e9feV\u001bXM]:!Q\r!\u0012Q\u0010\t\u0004q\u0005}\u0014bAAAs\tAao\u001c7bi&dW-A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002\b\u0006U\u0006\u0007BAE\u0003/\u0003\u0002\"a\u0007\u0002\f\u00065\u00151S\u0005\u0005\u0003[\ti\u0002\u0005\u0003\u0002Z\u0005=\u0015\u0002BAI\u00037\u0012\u0001\"\u00128ea>Lg\u000e\u001e\t\u0005\u0003+\u000b9\n\u0004\u0001\u0005\u0017\u0005eU#!A\u0001\u0002\u000b\u0005\u00111\u0014\u0002\u0004?\u0012B\u0014\u0003BAO\u0003G\u00032\u0001OAP\u0013\r\t\t+\u000f\u0002\b\u001d>$\b.\u001b8h!\u0019\t)+a+\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bi\"\u0001\u0006d_:\u001cWO\u001d:f]RLA!!,\u0002(\ny1i\\7qY\u0016$\u0018n\u001c8Ti\u0006<W\rE\u0002v\u0003cK1!a-w\u0005\u00111v.\u001b3\t\u000f\u0005]V\u00031\u0001\u0002:\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u0005\u0015\u00131X\u0005\u0005\u0003{\u000b9E\u0001\u000bBkRDwN]5{KJ\u001cVM\u001d<fe&sgm\\\u0001\nCV$\bn\u001c:ju\u0016$b!a1\u0002P\u0006e\u0007CBA\u000e\u0003\u000b\fI-\u0003\u0003\u0002H\u0006u!\u0001\u0002'jgR\u0004B!!\u0012\u0002L&!\u0011QZA$\u0005M\tU\u000f\u001e5pe&T\u0018\r^5p]J+7/\u001e7u\u0011\u001d\t\tN\u0006a\u0001\u0003'\faB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0002F\u0005U\u0017\u0002BAl\u0003\u000f\u0012!$Q;uQ>\u0014\u0018N_1cY\u0016\u0014V-];fgR\u001cuN\u001c;fqRDq!a7\u0017\u0001\u0004\ti.A\u0004bGRLwN\\:\u0011\r\u0005m\u0011QYAp!\u0011\t)%!9\n\t\u0005\r\u0018q\t\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0002\u0015\r\u0014X-\u0019;f\u0003\u000ed7\u000f\u0006\u0004\u0002j\u0006u\u0018q \u0019\u0005\u0003W\fy\u000f\u0005\u0004\u0002\u001c\u0005\u0015\u0017Q\u001e\t\u0005\u0003+\u000by\u000fB\u0006\u0002r^\t\t\u0011!A\u0003\u0002\u0005M(aA0%sE!\u0011QTA{!\u0019\t)+a+\u0002xB!\u0011QIA}\u0013\u0011\tY0a\u0012\u0003\u001f\u0005\u001bGn\u0011:fCR,'+Z:vYRDq!!5\u0018\u0001\u0004\t\u0019\u000eC\u0004\u0003\u0002]\u0001\rAa\u0001\u0002\u0017\u0005\u001cGNQ5oI&twm\u001d\t\u0007\u00037\t)M!\u0002\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013QAAa\u0003\u0002\\\u0005\u0019\u0011m\u00197\n\t\t=!\u0011\u0002\u0002\u000b\u0003\u000ed')\u001b8eS:<\u0017A\u00033fY\u0016$X-Q2mgR1!Q\u0003B\u0015\u0005W\u0001DAa\u0006\u0003\u001cA1\u00111DAc\u00053\u0001B!!&\u0003\u001c\u0011Y!Q\u0004\r\u0002\u0002\u0003\u0005)\u0011\u0001B\u0010\u0005\u0011yF%\r\u0019\u0012\t\u0005u%\u0011\u0005\t\u0007\u0003K\u000bYKa\t\u0011\t\u0005\u0015#QE\u0005\u0005\u0005O\t9EA\bBG2$U\r\\3uKJ+7/\u001e7u\u0011\u001d\t\t\u000e\u0007a\u0001\u0003'DqA!\f\u0019\u0001\u0004\u0011y#A\tbG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feN\u0004b!a\u0007\u0002F\nE\u0002\u0003\u0002B\u0004\u0005gIAA!\u000e\u0003\n\t\u0001\u0012i\u00197CS:$\u0017N\\4GS2$XM]\u0001\u0005C\u000ed7\u000f\u0006\u0003\u0003<\t\u0005\u0003#B;\u0003>\t\u0015\u0011b\u0001B m\nA\u0011\n^3sC\ndW\rC\u0004\u0003De\u0001\rA!\r\u0002\r\u0019LG\u000e^3s\u0003\u0015\u0019Gn\\:f\u0003%\u0019wN\u001c4jOV\u0014X\rF\u0002D\u0005\u0017BqA!\u0014\u001c\u0001\u0004\u0011y%A\u0004d_:4\u0017nZ:1\t\tE#Q\u000b\t\b\u00037\tYi\u001aB*!\u0011\t)J!\u0016\u0005\u0019\t]#1JA\u0001\u0002\u0003\u0015\tA!\u0017\u0003\t}#\u0013'M\t\u0005\u0003;\u0013Y\u0006E\u00029\u0005;J1Aa\u0018:\u0005\r\te._\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\t\u0011)\u0007E\u0003\u0002\u001c\t\u001dt-\u0003\u0003\u0003j\u0005u!aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0004\u0007\n=\u0004b\u0002B';\u0001\u0007!\u0011\u000f\u0019\u0005\u0005g\u00129\bE\u0004\u0002\u001c\u0005-uM!\u001e\u0011\t\u0005U%q\u000f\u0003\r\u0005s\u0012y'!A\u0001\u0002\u000b\u0005!\u0011\f\u0002\u0005?\u0012\n$'A\u0006sK\u000e|gNZ5hkJ,GcA\"\u0003\u0000!9!Q\n\u0010A\u0002\t\u0005\u0005\u0007\u0002BB\u0005\u000f\u0003r!a\u0007\u0002\f\u001e\u0014)\t\u0005\u0003\u0002\u0016\n\u001dE\u0001\u0004BE\u0005\u007f\n\t\u0011!A\u0003\u0002\te#\u0001B0%cM\nA\u0003^3ti\u0006+H\u000f[8sSj,'oQ8oM&<\u0007FA\u0010H\u0003y\u0019'/Z1uK\u000e{WNY5oK\u0012\u001cuN\u001c;s_2dWM]\"p]\u001aLw\r\u0006\u0004\u0002\u001a\tM%Q\u0014\u0005\b\u0005+\u0003\u0003\u0019\u0001BL\u0003\u0019qw\u000eZ3JIB\u0019\u0001H!'\n\u0007\tm\u0015HA\u0002J]RDqAa(!\u0001\u0004\u00119*\u0001\u0003q_J$\u0018A\n;fgR\u001cu.\u001c2j]\u0016$7i\u001c8ue>dG.\u001a:BkRDwN]5{KJ\u001cuN\u001c4jO\"\u0012\u0011eR\u0001\u001fGJ,\u0017\r^3Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e$b!!\u0007\u0003*\n-\u0006b\u0002BKE\u0001\u0007!q\u0013\u0005\b\u0005?\u0013\u0003\u0019\u0001BL\u0003\u0019\"Xm\u001d;Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u0014\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003G\u001d\u000bA\u0002^3tiNKhn\u001c8z[ND#\u0001J$\u0002cQ,7\u000f\u001e#z]\u0006l\u0017nY\"p]\u001aLw-\u00138ji&\fG.\u001b>bi&|gnV5uQ>,HoQ8oM&<7/\u00138[\u0017\"\u0012QeR\u0001\u001ei\u0016\u001cH/S7qe>\u0004XM]\"p]\u001aLwm]!sKJ+Wn\u001c<fI\"\u0012aeR\u0001\u001ai\u0016\u001cH/\u00169eCR,W*\u001a;sS\u000e\u0014V\r]8si\u0016\u00148\u000f\u000b\u0002(\u000f\u00061C/Z:u+B$\u0017\r^3NKR\u0014\u0018n\u0019*fa>\u0014H/\u001a:t\u001d>TU\u000e\u001f*fa>\u0014H/\u001a:)\u0005!:\u0015!\r;fgRtuN\\%oi\u0016\u0014h.\u00197WC2,Xm\u001d#pKNtu\u000e^#ya>\u001cX-\u00138uKJt\u0017\r\\\"p]\u001aLwm\u001d\u0015\u0003S\u001d\u000bA\u0005^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|g.T:D_:4\u0017n\u001a\u0015\u0003U\u001d\u000ba\u0005^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|gnU5{K\u000e{gNZ5hQ\tYs)\u0001\u0019uKN$H)\u001f8b[&\u001cGj\\4M_\u000e\fGNU3uK:$\u0018n\u001c8TW&\u00048o\u00148J]Z\fG.\u001b3D_:4\u0017n\u001a\u0015\u0003Y\u001d\u000b1\u0007^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|g\u000e\u00165s_^\u001cxJ\\%oG>\u0014(/Z2u\u0007>tg-[4)\u00055:\u0015a\n;fgR,\u0006\u000fZ1uK\u0012Kh.Y7jGJ+Wn\u001c;f\u0019><W*\u00198bO\u0016\u00148i\u001c8gS\u001eD#AL$\u0002KY,'/\u001b4z\u0013:\u001cwN\u001d:fGRdun\u001a'pG\u0006d'+\u001a;f]RLwN\u001c)s_B\u001cH#C\"\u0003b\n-(q\u001eBz\u0011\u001d\u0011\u0019o\fa\u0001\u0005K\f1\u0003\\8h\u0019>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u001bN\u00042\u0001\u000fBt\u0013\r\u0011I/\u000f\u0002\u0005\u0019>tw\rC\u0004\u0003n>\u0002\rA!:\u0002\u0017I,G/\u001a8uS>tWj\u001d\u0005\b\u0005c|\u0003\u0019\u0001Bs\u0003Yawn\u001a'pG\u0006d'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\bb\u0002B{_\u0001\u0007!Q]\u0001\u000fe\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t\u0001")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put("listener.name.external.ssl.keystore.location", newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn(package$.MODULE$.Iterable().empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var32_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var33_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var34_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("ssl.keystore.type", "JKS");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        scala.collection.immutable.Map excludedTopicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_19 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig configWithoutSecret = new KafkaConfig((java.util.Map)props, apply_doLog);
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean apply_doLog2 = true;
        KafkaConfig configWithSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var31_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var32_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var33_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        boolean apply_doLog2 = true;
        KafkaConfig newConfigWithSameSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        boolean apply_doLog3 = true;
        KafkaConfig newConfigWithNewAndOldSecret = new KafkaConfig((java.util.Map)props, apply_doLog3);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        boolean apply_doLog4 = true;
        KafkaConfig newConfigWithNewSecret = new KafkaConfig((java.util.Map)props, apply_doLog4);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        boolean apply_doLog = true;
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean apply_doLog = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        retval.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        retval.put(KafkaConfig$.MODULE$.ListenersProp(), new StringBuilder(25).append(retval.get(KafkaConfig$.MODULE$.ListenersProp())).append(",CONTROLLER://localhost:0").toString());
        retval.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        retval.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        retval.remove(KafkaConfig$.MODULE$.AdvertisedListenersProp());
        retval.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        retval.put(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        retval.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties initialProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        initialProps.remove(KafkaConfig$.MODULE$.BackgroundThreadsProp());
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(initialProps);
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient), (Option)None$.MODULE$);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.AutoIncludeJmxReporterProp(), "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove(KafkaConfig$.MODULE$.MetricReporterClassesProp());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testNonInternalValuesDoesNotExposeInternalConfigs() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "localhost:2181");
        props.put(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp(), "1024");
        KafkaConfig config = new KafkaConfig((java.util.Map)props);
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()));
        config.updateCurrentConfig(new KafkaConfig((java.util.Map)props));
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()));
    }

    @Test
    public void testDynamicLogLocalRetentionMsConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "2592000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", "2160000000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)2160000000L, (Long)config.logLocalRetentionMs());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.ms", "2150000000");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)2150000000L, (Long)config.logLocalRetentionMs());
    }

    @Test
    public void testDynamicLogLocalRetentionSizeConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "4294967296");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.bytes", "4294967295");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)0xFFFFFFFFL, (Long)config.logLocalRetentionBytes());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.bytes", "4294967294");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)0xFFFFFFFEL, (Long)config.logLocalRetentionBytes());
    }

    @Test
    public void testDynamicLogLocalRetentionSkipsOnInvalidConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var23_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var24_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var25_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("log.local.retention.ms", "1000");
        props.put("log.local.retention.bytes", "1024");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.ms"), (Object)"-3")}))));
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.bytes"), (Object)"-3")}))));
    }

    @Test
    public void testDynamicLogLocalRetentionThrowsOnIncorrectConfig() {
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, 2L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(500L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(-1L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, -1L, 100L);
    }

    @Test
    public void testUpdateDynamicRemoteLogManagerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var26_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var27_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var28_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("remote.log.index.file.cache.total.size.bytes", "2");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Option remoteLogManagerMockOpt = Option$.MODULE$.apply(Mockito.mock(RemoteLogManager.class));
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)remoteLogManagerMockOpt);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.index.file.cache.total.size.bytes", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (Long)config.getLong("remote.log.index.file.cache.total.size.bytes"));
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManagerMockOpt.get())).resizeCacheSize(4L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManagerMockOpt.get()});
    }

    public void verifyIncorrectLogLocalRetentionProps(long logLocalRetentionMs, long retentionMs, long logLocalRetentionBytes, long retentionBytes) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var33_13 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var34_16 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var35_19 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), Long.toString(retentionMs));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), Long.toString(retentionBytes));
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaServer.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", Long.toString(logLocalRetentionMs));
        newProps.put("log.local.retention.bytes", Long.toString(logLocalRetentionBytes));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, false));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, true));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1), config$3.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1, config$3.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

