/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareMode;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tea\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001A\u0002\u0013\u00051\u0007C\u0004@\u0001\u0001\u0007I\u0011\u0001!\t\r\u001d\u0003\u0001\u0015)\u00035\u0011\u001dA\u0005A1A\u0005\u0002%CaA\u0016\u0001!\u0002\u0013Q\u0005bB,\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007A\u0002\u0001\u000b\u0011B-\t\u000b\u0005\u0004A\u0011\t2\t\u000bA\u0004A\u0011\u00012\t\u000bU\u0004A\u0011\u00012\t\u000b]\u0004A\u0011\u00012\t\u000be\u0004A\u0011\u00012\t\u000bm\u0004A\u0011\u0002?\t\u000f\u00055\u0002\u0001\"\u0003\u00020!9\u0011Q\n\u0001\u0005\n\u0005=\u0003BBA,\u0001\u0011%!\rC\u0004\u0002Z\u0001!I!a\u0017\t\r\u0005]\u0004\u0001\"\u0001c\u0011\u0019\tY\b\u0001C\u0001E\"1\u0011q\u0010\u0001\u0005\u0002\tDa!a!\u0001\t\u0003\u0011\u0007BBAD\u0001\u0011\u0005!\r\u0003\u0004\u0002\f\u0002!\tA\u0019\u0005\u0007\u0003\u001f\u0003A\u0011\u00012\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"I\u0011\u0011\u0018\u0001\u0012\u0002\u0013%\u00111\u0018\u0005\n\u0003#\u0004\u0011\u0013!C\u0005\u0003'Dq!a%\u0001\t\u0013\t9\u000eC\u0004\u0002t\u0002!I!!>\t\r\tE\u0001\u0001\"\u0001c\u0011\u0019\u0011)\u0002\u0001C\u0001E\nyA)\u001a7fi\u0016$v\u000e]5d)\u0016\u001cHO\u0003\u0002$I\u0005)\u0011\rZ7j]*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015-\u001b\u0005Q#BA\u0016%\u0003\u0019\u0019XM\u001d<fe&\u0011QF\u000b\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u00011!\t\t\u0004!D\u0001#\u0003\u001d\u0019XM\u001d<feN,\u0012\u0001\u000e\t\u0004kibT\"\u0001\u001c\u000b\u0005]B\u0014AC2pY2,7\r^5p]*\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<m\t\u00191+Z9\u0011\u0005%j\u0014B\u0001 +\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\u0003\u0016\u0003\"AQ\"\u000e\u0003aJ!\u0001\u0012\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\r\u000e\t\t\u00111\u00015\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005IR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u+\u0005Q\u0005\u0003B&O!Nk\u0011\u0001\u0014\u0006\u0003\u001bZ\n\u0011\"[7nkR\f'\r\\3\n\u0005=c%aA'baB\u0011!)U\u0005\u0003%b\u00121!\u00138u!\rYE\u000bU\u0005\u0003+2\u0013A\u0001T5ti\u0006QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA\u0005iR\r\u001f9fGR,GMU3qY&\u001c\u0017MR;mY\u0006\u001b8/[4o[\u0016tG/F\u0001Z!\u0011Ye\n\u0015.\u0011\u0005msV\"\u0001/\u000b\u0005u#\u0013AC2p]R\u0014x\u000e\u001c7fe&\u0011q\f\u0018\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\u0018AH3ya\u0016\u001cG/\u001a3SKBd\u0017nY1Gk2d\u0017i]:jO:lWM\u001c;!\u0003!!X-\u0019:E_^tG#A!)\u0005%!\u0007CA3o\u001b\u00051'BA4i\u0003\r\t\u0007/\u001b\u0006\u0003S*\fqA[;qSR,'O\u0003\u0002lY\u0006)!.\u001e8ji*\tQ.A\u0002pe\u001eL!a\u001c4\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\t;fgR$U\r\\3uKR{\u0007/[2XSRD\u0017\t\u001c7BY&4XMU3qY&\u001c\u0017m\u001d\u0015\u0003\u0015I\u0004\"!Z:\n\u0005Q4'\u0001\u0002+fgR\f!\u0006^3tiJ+7/^7f\t\u0016dW\r^3U_BL7mV5uQJ+7m\u001c<fe\u0016$gi\u001c7m_^,'\u000f\u000b\u0002\fe\u0006IC/Z:u%\u0016\u001cX/\\3EK2,G/\u001a+pa&\u001cwJ\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJD#\u0001\u0004:\u0002UQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e#ve&tw\rR3mKR,Gk\u001c9jG\"\u0012QB]\u0001\u0013o\u0006LG/\u00168uS2$v\u000e]5d\u000f>tW\r\u0006\u0003B{\u0006M\u0001\"\u0002@\u000f\u0001\u0004y\u0018aC1e[&t7\t\\5f]R\u0004B!!\u0001\u0002\u00105\u0011\u00111\u0001\u0006\u0004G\u0005\u0015!\u0002BA\u0004\u0003\u0013\tqa\u00197jK:$8OC\u0002&\u0003\u0017Q1!!\u0004m\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011CA\u0002\u0005\u0015\tE-\\5o\u0011\u001d\t)B\u0004a\u0001\u0003/\t\u0011\u0002^8qS\u000et\u0015-\\3\u0011\t\u0005e\u0011q\u0005\b\u0005\u00037\t\u0019\u0003E\u0002\u0002\u001eaj!!a\b\u000b\u0007\u0005\u0005b%\u0001\u0004=e>|GOP\u0005\u0004\u0003KA\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002*\u0005-\"AB*ue&twMC\u0002\u0002&a\n\u0011E^3sS\u001aL(+Z1tg&<g.\\3oi\u001a\u000b\u0017\u000e\\:G_Jl\u0015n]:j]\u001e$r!QA\u0019\u0003g\t\u0019\u0005C\u0003\u007f\u001f\u0001\u0007q\u0010C\u0004\u00026=\u0001\r!a\u000e\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\t\u0005u\u0012\u0011B\u0001\u0007G>lWn\u001c8\n\t\u0005\u0005\u00131\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t)e\u0004a\u0001\u0003\u000f\nAB]3bgNLwM\\7f]R\u0004B!!\u0001\u0002J%!\u00111JA\u0002\u0005aqUm\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^\u0001\u000eO\u0016$8i\u001c8ue>dG.\u001a:\u0015\u0005\u0005E\u0003#\u0002\"\u0002Tq\u0002\u0016bAA+q\t1A+\u001e9mKJ\na#\u001a8tkJ,7i\u001c8ue>dG.\u001a:Fq&\u001cHo]\u0001\u001dO\u0016$\u0018\t\u001c7SKBd\u0017nY1t\rJ|W.Q:tS\u001etW.\u001a8u)\u0019\ti&!\u001b\u0002nA1\u0011\u0011DA0\u0003GJA!!\u0019\u0002,\t\u00191+\u001a;\u0011\u0007m\u000b)'C\u0002\u0002hq\u00131\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!a\u001b\u0013\u0001\u0004\t9\"A\u0003u_BL7\rC\u0004\u0002pI\u0001\r!!\u001d\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000fE\u0004\u0002\u001a\u0005M\u0004+!\u001e\n\u0007=\u000bY\u0003E\u00026uA\u000b1\u0006^3ti&s7M]3bg\u0016\u0004\u0016M\u001d;ji&|gnQ8v]R$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0003'I\f\u0011\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018n\u0019#ve&tw-\u00113e!\u0006\u0014H/\u001b;j_:D#\u0001\u0006:\u0002CQ,7\u000f^!eIB\u000b'\u000f^5uS>tG)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0005U\u0011\u0018A\b;fgR\u0014Vm\u0019:fCR,Gk\u001c9jG\u00063G/\u001a:EK2,G/[8oQ\t1\"/\u0001\u000euKN$H)\u001a7fi\u0016tuN\\#ySN$\u0018N\\4U_BL7\r\u000b\u0002\u0018e\u0006QB/Z:u\t\u0016dW\r^3U_BL7mV5uQ\u000ecW-\u00198fe\"\u0012\u0001D]\u0001&i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0006c'/Z1es6\u000b'o[3e\u0003N$U\r\\3uK\u0012D#!\u0007:\u00023\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u000b\bi\u0005]\u0015\u0011TAR\u0011\u001d\tYG\u0007a\u0001\u0003/A\u0011\"a'\u001b!\u0003\u0005\r!!(\u0002%\u0011,G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\t\u0004\u0005\u0006}\u0015bAAQq\t9!i\\8mK\u0006t\u0007\"CAS5A\u0005\t\u0019AAT\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\b\u00033\t\u0019\bUAU!\u0015\tY+!.Q\u001d\u0011\ti+!-\u000f\t\u0005u\u0011qV\u0005\u0002s%\u0019\u00111\u0017\u001d\u0002\u000fA\f7m[1hK&\u0019Q+a.\u000b\u0007\u0005M\u0006(A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u&\u0006BAO\u0003\u007f[#!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017D\u0014AC1o]>$\u0018\r^5p]&!\u0011qZAc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001$GJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)N\u000b\u0003\u0002(\u0006}Fc\u0002\u001b\u0002Z\u0006m\u0017\u0011\u001f\u0005\b\u0003Wj\u0002\u0019AA\f\u0011\u001d\ti.\ba\u0001\u0003?\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\b\u0003B\u001b;\u0003C\u0004B!a9\u0002n6\u0011\u0011Q\u001d\u0006\u0005\u0003O\fI/\u0001\u0003vi&d'BAAv\u0003\u0011Q\u0017M^1\n\t\u0005=\u0018Q\u001d\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAS;\u0001\u0007\u0011qU\u0001\noJLG/\u001a#vaN$\u0002\"a>\u0002|\u0006}(1\u0001\t\u0005ki\nI\u0010E\u0003C\u0003'\u0002\u0006\u000b\u0003\u0004\u0002~z\u0001\r\u0001U\u0001\b]Vl7*Z=t\u0011\u0019\u0011\tA\ba\u0001!\u00069a.^7EkB\u001c\bb\u0002B\u0003=\u0001\u0007!qA\u0001\u0004Y><\u0007\u0003\u0002B\u0005\u0005\u001bi!Aa\u0003\u000b\u0007\t\u0015A%\u0003\u0003\u0003\u0010\t-!AC+oS\u001aLW\r\u001a'pO\u00061B/Z:u\t&\u001c\u0018M\u00197f\t\u0016dW\r^3U_BL7\r\u000b\u0002 e\u0006\tC/Z:u\t\u0016dW\r^5oOB\u000b'\u000f^5bY2LH)\u001a7fi\u0016$Gk\u001c9jG\"\u0012\u0001E\u001d")
public class DeleteTopicTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment = (scala.collection.immutable.Map)this.expectedReplicaAssignment().map((Function1 & Serializable)x0$1 -> {
        if (x0$1 != null) {
            void apply_removingReplicas;
            int k = x0$1._1$mcI$sp();
            List v = (List)x0$1._2();
            Nil$ nil$ = Nil$.MODULE$;
            Nil$ apply_addingReplicas = Nil$.MODULE$;
            Object var3_4 = null;
            nil$ = null;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)new ReplicaAssignment((Seq)v, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas));
        }
        throw new MatchError(null);
    });

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment() {
        return this.expectedReplicaFullAssignment;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$2(this, follower, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replicas 0,1 have not deleted log.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$6(this, topic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Admin path /admin/delete_topics/test path deleted even when a follower replica is down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)"Controller doesn't exist")));
        KafkaServer controller = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(leaderIdOpt, controllerId, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$4(this, topic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Admin path /admin/delete_topics/test path deleted even when a replica is down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean createServer_createServer_createServer_startup = true;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        });
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), servers);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$5(topicPartition$2, x$2)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replicas for topic test not created.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)servers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.plaintextBootstrapServers(servers));
        try (Admin adminClient = Admin.create((Properties)props);){
            this.waitUntilTopicGone(adminClient, "test");
            this.verifyReassignmentFailsForMissing(adminClient, new TopicPartition(topic, 0), new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3))));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, servers);
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTopicGone(Admin adminClient, String topicName) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$waitUntilTopicGone$1(adminClient, topicName)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$waitUntilTopicGone$2(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyReassignmentFailsForMissing(Admin adminClient, TopicPartition partition, NewPartitionReassignment reassignment) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> adminClient.alterPartitionReassignments(Collections.singletonMap(partition, Optional.of(reassignment))).all().get());
        Assertions.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
    }

    private Tuple2<KafkaServer, Object> getController() {
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)"Controller doesn't exist");
        }));
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    private void ensureControllerExists() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$ensureControllerExists$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Controller should eventually exist");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment) {
        return ((IterableOnceOps)assignment.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                return (Seq)((Seq)x0$1._2()).map((Function1 & Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)));
            }
            throw new MatchError(null);
        })).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        void var9_12;
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean createServer_createServer_createServer_startup = true;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        });
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), servers);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$5(topicPartition$3, x$3)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replicas for topic test not created.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)servers.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer controller = (KafkaServer)tuple2._1();
        int n = tuple2._2$mcI$sp();
        scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, this.expectedReplicaAssignment());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$8((KafkaServer)var9_12, topic, allReplicasForTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$9(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.plaintextBootstrapServers(servers));
        try (Admin resource_resource = Admin.create((Properties)props);){
            DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$10(topic, resource_resource);
        }
        Object var24_19 = null;
        var9_12.shutdown();
        this.ensureControllerExists();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$11(this, n)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"The new controller should not have the failed controller id");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        follower.startup();
        var9_12.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, servers);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((boolean)leaderIdOpt.isDefined(), (String)"Leader should exist for partition [test,0]");
        KafkaServer follower = (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$6)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        follower.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$2(this, follower)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$3(follower));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        Some x$7 = new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$8 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, 2, (Option)x$7, x$8);
        this.adminZkClient().deleteTopic(topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$4(this, newPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Replica logs not for new partition [test,1] not deleted after delete topic is complete.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        Some x$7 = new Some(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
        boolean x$82 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, 2, (Option)x$7, x$82);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$8))), (String)"Replica logs not deleted after delete topic is complete");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replicas for topic test not created.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().deleteTopic("test2"));
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$2(this, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replicas for topic test not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.zkClient().topicExists(topic), (String)"Topic test mistakenly deleted");
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$1.getLog(topicPartition, x$2).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$2 = server.logManager().cleaner();
        TopicPartition x$3 = new TopicPartition(topicName, 0);
        long x$5 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$3, 0L, x$5);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic(topic);
        Assertions.assertThrows(TopicAlreadyMarkedForDeletionException.class, () -> this.adminZkClient().deleteTopic(topic));
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false);
        brokerConfigs.foreach((Function1 & Serializable)x$11 -> x$11.setProperty("delete.topic.enable", Boolean.toString(deleteTopicEnabled)));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time = Time.SYSTEM;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            boolean createServer_createServer_createServer_startup = true;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, createServer_createServer_createServer_startup, false);
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), servers);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$4(topicPartition$6, x$12)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replicas for topic test not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, UnifiedLog log) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable)x$13 -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, counter, log, BoxesRunTime.unboxToInt((Object)x$13)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.expectedReplicaAssignment()));
        this.adminZkClient().deleteTopic("test");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDisableDeleteTopic$1(this, topic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Admin path /admin/delete_topics/%s path not deleted even if deleteTopic is disabled"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$14))));
        Assertions.assertTrue((boolean)this.zkClient().topicExists(topic), (String)"Topic path disappeared");
        Assertions.assertTrue((boolean)this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0)).isDefined(), (String)"Leader should exist for topic test");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletingPartiallyDeletedTopic() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1 & Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$1 = this.zkClient();
        String x$1 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$2 = qual$1.deleteRecursive$default$2();
        qual$1.deleteRecursive(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1 & Serializable)x$16 -> {
            x$16.startup();
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$3(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"No controller is elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$3(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(TopicPartition topicPartition$1, KafkaServer x$1) {
        LogManager qual$1 = x$1.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$2(DeleteTopicTest $this, KafkaServer follower$1, TopicPartition topicPartition$1) {
        return ((IterableOnceOps)$this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$3(follower$1, s)))).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(topicPartition$1, x$1)));
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$5() {
        return "Replicas 0,1 have not deleted log.";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$6(DeleteTopicTest $this, String topic$1) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$1);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$7() {
        return "Admin path /admin/delete_topics/test path deleted even when a follower replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(Option leaderIdOpt$2, int controllerId$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$4(DeleteTopicTest $this, String topic$2) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicOnControllerFailover$5() {
        return "Admin path /admin/delete_topics/test path deleted even when a replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((List)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$5(TopicPartition topicPartition$2, KafkaServer x$2) {
        LogManager qual$1 = x$2.getLogManager();
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$2, x$22).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTopicGone$1(Admin adminClient$1, String topicName$1) {
        try {
            adminClient$1.describeTopics(Collections.singletonList(topicName$1)).allTopicNames().get();
            return false;
        }
        catch (ExecutionException e) {
            return UnknownTopicOrPartitionException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$waitUntilTopicGone$2(String topicName$1) {
        return new StringBuilder(25).append("Topic ").append(topicName$1).append(" should be deleted.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerExists$1(DeleteTopicTest $this) {
        try {
            $this.getController();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$ensureControllerExists$2() {
        return "Controller should eventually exist";
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$2, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$2), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((List)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$5(TopicPartition topicPartition$3, KafkaServer x$3) {
        LogManager qual$1 = x$3.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$7(Option leaderIdOpt$4, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$8(KafkaServer controller$1, String topic$4, scala.collection.immutable.Set allReplicasForTopic$1) {
        Set replicasInDeletionSuccessful = controller$1.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Set offlineReplicas = controller$1.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)OfflineReplica$.MODULE$);
        scala.collection.immutable.Set set = allReplicasForTopic$1;
        SetOps setOps = replicasInDeletionSuccessful.union(offlineReplicas);
        return !(set != null ? !set.equals(setOps) : setOps != null);
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$9(String topic$4) {
        return new StringBuilder(95).append("Not all replicas for topic ").append(topic$4).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString();
    }

    public static final /* synthetic */ Object $anonfun$testIncreasePartitionCountDuringDeleteTopic$10(String topic$4, Admin adminClient) {
        try {
            return adminClient.createPartitions(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic$4), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).all().get();
        }
        catch (ExecutionException executionException) {
            return BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$11(DeleteTopicTest $this, int previousControllerId$1) {
        Tuple2<KafkaServer, Object> tuple2 = $this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer cfr_ignored_0 = (KafkaServer)tuple2._1();
        return tuple2._2$mcI$sp() != previousControllerId$1;
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$12() {
        return "The new controller should not have the failed controller id";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$5, KafkaServer x$6) {
        return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$5.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$2(DeleteTopicTest $this, KafkaServer follower$2) {
        return $this.zkClient().getBroker(follower$2.config().brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$3(KafkaServer follower$2) {
        return new StringBuilder(33).append("Follower ").append(follower$2.config().brokerId()).append(" was not removed from ZK").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$5(TopicPartition newPartition$1, KafkaServer x$7) {
        LogManager qual$3 = x$7.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$1, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$4(DeleteTopicTest $this, TopicPartition newPartition$1) {
        return $this.servers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$5(newPartition$1, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$6() {
        return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$8) {
        LogManager qual$3 = x$8.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$2, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$2(TopicPartition topicPartition$4, KafkaServer x$9) {
        LogManager qual$1 = x$9.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$4, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$1(DeleteTopicTest $this, TopicPartition topicPartition$4) {
        return $this.servers().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$2(topicPartition$4, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testRecreateTopicAfterDeletion$3() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$3(TopicPartition topicPartition$5, KafkaServer x$10) {
        LogManager qual$1 = x$10.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$5, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$2(DeleteTopicTest $this, TopicPartition topicPartition$5) {
        return $this.servers().forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(topicPartition$5, x$10)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonExistingTopic$4() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$4(TopicPartition topicPartition$6, KafkaServer x$12) {
        LogManager qual$1 = x$12.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$6, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$5() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(IntRef counter$1, UnifiedLog log$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(counter$1.elem).getBytes(), Integer.toString(key).getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5(), log$1.appendAsLeader$default$6());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IterableOnce $anonfun$writeDups$1(int numKeys$1, IntRef counter$1, UnifiedLog log$1, int x$13) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(counter$1, log$1, BoxesRunTime.unboxToInt((Object)key)));
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$1(DeleteTopicTest $this, String topic$6) {
        return !$this.zkClient().isTopicMarkedForDeletion(topic$6);
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$7, KafkaServer x$14) {
        LogManager qual$1 = x$14.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$7, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$4(KafkaServer x$17) {
        return x$17.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$3(DeleteTopicTest $this) {
        return $this.servers().exists((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$4(x$17)));
    }

    public static final /* synthetic */ String $anonfun$testDeletingPartiallyDeletedTopic$5() {
        return "No controller is elected";
    }
}

