/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.RemoteIndexCache;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%g\u0001B\u001e=\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013%q\n\u0003\u0004Y\u0001\u0001\u0006I\u0001\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00028\t\rI\u0004\u0001\u0015!\u0003p\u0011\u001d\u0019\bA1A\u0005\n9Da\u0001\u001e\u0001!\u0002\u0013y\u0007bB;\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007m\u0002\u0001\u000b\u0011B5\t\u000f]\u0004!\u0019!C\u0005q\"9\u00111\u0001\u0001!\u0002\u0013I\bbCA\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000fA1\"!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001c!Y\u0011q\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0005\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\t\u0017\u0005M\u0002\u00011AA\u0002\u0013%\u0011Q\u0007\u0005\f\u0003s\u0001\u0001\u0019!A!B\u0013\ti\u0003C\u0006\u0002<\u0001\u0001\r\u00111A\u0005\n\u0005u\u0002bCA(\u0001\u0001\u0007\t\u0019!C\u0005\u0003#B1\"!\u0016\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002@!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005}\u0003\u00011A\u0001B\u0003&\u0011q\b\u0005\f\u0003C\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0007C\u0006\u0002r\u0001\u0001\r\u00111A\u0005\n\u0005M\u0004bCA<\u0001\u0001\u0007\t\u0011)Q\u0005\u0003KBq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\u0014\u0002!\t!a\u001f\t\u000f\u0005u\u0005\u0001\"\u0001\u0002|!9\u0011q\u0015\u0001\u0005\u0002\u0005m\u0004bBAV\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003_\u0003A\u0011AA>\u0011\u001d\t\u0019\f\u0001C\u0001\u0003wBq!a.\u0001\t\u0003\tY\bC\u0004\u0002<\u0002!\t!a\u001f\t\u000f\u0005}\u0006\u0001\"\u0001\u0002|!9\u00111\u0019\u0001\u0005\u0002\u0005m\u0004bBAd\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u0017\u0004A\u0011AA>\u0011\u001d\ty\r\u0001C\u0001\u0003wBq!a5\u0001\t\u0003\tY\bC\u0004\u0002X\u0002!\t!a\u001f\t\u000f\u0005m\u0007\u0001\"\u0001\u0002|!9\u0011q\u001c\u0001\u0005\n\u0005\u0005\b\"CA~\u0001E\u0005I\u0011BA\u007f\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u00032\u0001!IAa\r\t\u0013\t}\u0004!%A\u0005\n\t\u0005\u0005b\u0002BC\u0001\u0011%!q\u0011\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011y\n\u0001C\u0005\u0005CCqAa+\u0001\t\u0013\u0011i\u000bC\u0004\u0003>\u0002!IAa0\u0003)I+Wn\u001c;f\u0013:$W\r_\"bG\",G+Z:u\u0015\tid(\u0001\u0004sK6|G/\u001a\u0006\u0003\u007f\u0001\u000b1\u0001\\8h\u0015\u0005\t\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0011\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001M!\ti\u0005!D\u0001=\u0003\u0019awnZ4feV\t\u0001\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006)1\u000f\u001c45U*\tQ+A\u0002pe\u001eL!a\u0016*\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nA\u0001^5nKV\t1\f\u0005\u0002]I6\tQL\u0003\u0002_?\u0006!Q\u000f^5m\u0015\t\u0001\u0017-\u0001\u0004tKJ4XM\u001d\u0006\u0003\u0003\nT!a\u0019+\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t)WL\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003!\u0011'o\\6fe&#W#A5\u0011\u0005\u0015S\u0017BA6G\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n!BY1tK>3gm]3u+\u0005y\u0007CA#q\u0013\t\thI\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\n!\u0002\\1ti>3gm]3u\u0003-a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\u0017M,w-\\3oiNK'0Z\u0001\rg\u0016<W.\u001a8u'&TX\rI\u0001\u0004eNlW#A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018aB:u_J\fw-\u001a\u0006\u0003{yT!aP0\n\u0007\u0005\u00051P\u0001\u000bSK6|G/Z*u_J\fw-Z'b]\u0006<WM]\u0001\u0005eNl\u0007%A\u0003dC\u000eDW-\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiAC\u0002@\u0003\u001fQA!!\u0005\u0002\u0014\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003y\u0006LA!a\u0006\u0002\u000e\t\u0001\"+Z7pi\u0016Le\u000eZ3y\u0007\u0006\u001c\u0007.Z\u0001\nG\u0006\u001c\u0007.Z0%KF$B!!\b\u0002$A\u0019Q)a\b\n\u0007\u0005\u0005bI\u0001\u0003V]&$\b\"CA\u0013#\u0005\u0005\t\u0019AA\u0005\u0003\rAH%M\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0017Id7/T3uC\u0012\fG/Y\u000b\u0003\u0003[\u00012A_A\u0018\u0013\r\t\td\u001f\u0002\u0019%\u0016lw\u000e^3M_\u001e\u001cVmZ7f]RlU\r^1eCR\f\u0017a\u0004:mg6+G/\u00193bi\u0006|F%Z9\u0015\t\u0005u\u0011q\u0007\u0005\n\u0003K!\u0012\u0011!a\u0001\u0003[\tAB\u001d7t\u001b\u0016$\u0018\rZ1uC\u0002\na\u0001\\8h\t&\u0014XCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n!![8\u000b\u0005\u0005%\u0013\u0001\u00026bm\u0006LA!!\u0014\u0002D\t!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0005\u0003;\t\u0019\u0006C\u0005\u0002&]\t\t\u00111\u0001\u0002@\u00059An\\4ESJ\u0004\u0013!\u0002;q\t&\u0014\u0018!\u0003;q\t&\u0014x\fJ3r)\u0011\ti\"!\u0018\t\u0013\u0005\u0015\"$!AA\u0002\u0005}\u0012A\u0002;q\t&\u0014\b%A\u0006jIB\u000b'\u000f^5uS>tWCAA3!\u0011\t9'!\u001c\u000e\u0005\u0005%$bAA6C\u000611m\\7n_:LA!a\u001c\u0002j\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0010S\u0012\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR!\u0011QDA;\u0011%\t)#HA\u0001\u0002\u0004\t)'\u0001\u0007jIB\u000b'\u000f^5uS>t\u0007%A\u0003tKR,\b\u000f\u0006\u0002\u0002\u001e!\u001aq$a \u0011\t\u0005\u0005\u0015qR\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006\u0019\u0011\r]5\u000b\t\u0005%\u00151R\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\ti\tV\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003#\u000b\u0019I\u0001\u0006CK\u001a|'/Z#bG\"\fqa\u00197fC:,\b\u000fK\u0002!\u0003/\u0003B!!!\u0002\u001a&!\u00111TAB\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0012uKN$\u0018J\u001c3fq\u001aKG.\u001a(b[\u0016\fe\u000e\u001a'pG\u0006$\u0018n\u001c8P]\u0012K7o\u001b\u0015\u0004C\u0005\u0005\u0006\u0003BAA\u0003GKA!!*\u0002\u0004\n!A+Z:u\u0003}!Xm\u001d;GKR\u001c\u0007.\u00138eKb4%o\\7SK6|G/Z*u_J\fw-\u001a\u0015\u0004E\u0005\u0005\u0016\u0001\u000b;fgR4U\r^2i\u0013:$W\r\u001f$pe6K7o]5oOR\u0013\u0018M\\:bGRLwN\\%oI\u0016D\bfA\u0012\u0002\"\u0006\u0001D/Z:u!>\u001c\u0018\u000e^5p]\u001a{'OT8o\u000bbL7\u000f^5oO&sG-\u001a=Ge>l'+Z7pi\u0016\u001cFo\u001c:bO\u0016D3\u0001JAQ\u0003Q!Xm\u001d;DC\u000eDW-\u00128uef,\u0005\u0010]5ss\"\u001aQ%!)\u00027Q,7\u000f^$fi&sG-\u001a=BMR,'oQ1dQ\u0016\u001cEn\\:fQ\r1\u0013\u0011U\u0001\u0016i\u0016\u001cHo\u00117pg\u0016L5/\u00133f[B|G/\u001a8uQ\r9\u0013\u0011U\u0001&i\u0016\u001cHoQ1dQ\u0016,e\u000e\u001e:z\u0013N$U\r\\3uK\u0012|e.\u00138wC2LG-\u0019;j_:D3\u0001KAQ\u0003e!Xm\u001d;DY\u0016\fg.\u001a:UQJ,\u0017\rZ*ikR$wn\u001e8)\u0007%\n\t+A\u0005uKN$8\t\\8tK\"\u001a!&!)\u0002KQ,7\u000f^\"p]\u000e,(O]3oiJ+\u0017\rZ,sSR,\u0017iY2fgN4uN]\"bG\",\u0007fA\u0016\u0002\"\u0006IB/Z:u%\u0016dw.\u00193DC\u000eDW-\u00114uKJ\u001cEn\\:fQ\ra\u0013\u0011U\u0001\u000fi\u0016\u001cHOU3n_Z,\u0017\n^3nQ\ri\u0013\u0011U\u0001\u001ai\u0016\u001cHOU3n_Z,gj\u001c8Fq&\u001cH/\u001a8u\u0013R,W\u000eK\u0002/\u0003C\u000bq\u0003^3tiJ+Wn\u001c<f\u001bVdG/\u001b9mK&#X-\\:)\u0007=\n\t+A\u000bhK:,'/\u0019;f'BL8)Y2iK\u0016sGO]=\u0015\t\u0005\r\u0018\u0011\u001f\t\u0005\u0003K\fYO\u0004\u0003\u0002\f\u0005\u001d\u0018\u0002BAu\u0003\u001b\t\u0001CU3n_R,\u0017J\u001c3fq\u000e\u000b7\r[3\n\t\u00055\u0018q\u001e\u0002\u0006\u000b:$(/\u001f\u0006\u0005\u0003S\fi\u0001C\u0005\u0002tB\u0002\n\u00111\u0001\u0002v\u0006\u0011\"/Z7pi\u0016dunZ*fO6,g\u000e^%e!\rQ\u0018q_\u0005\u0004\u0003s\\(A\u0005*f[>$X\rT8h'\u0016<W.\u001a8u\u0013\u0012\fqdZ3oKJ\fG/Z*qs\u000e\u000b7\r[3F]R\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyP\u000b\u0003\u0002v\n\u00051F\u0001B\u0002!\u0011\u0011)Aa\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5a)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0005\u0003\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\u0005\u001c8/\u001a:u\u0003RdU-Y:u\u001f:,\u0007K]3tK:$HCBA\u000f\u0005/\u0011I\u0002C\u0004\u0002\u0006I\u0002\r!!\u0003\t\u000f\tm!\u00071\u0001\u0003\u001e\u0005)Q/^5egB)QIa\b\u0003$%\u0019!\u0011\u0005$\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002h\t\u0015\u0012\u0002\u0002B\u0014\u0003S\u0012A!V;jI\u0006y\u0011m]:feR\u001c\u0015m\u00195f'&TX\r\u0006\u0003\u0002\u001e\t5\u0002B\u0002B\u0018g\u0001\u0007\u0011.\u0001\u0007fqB,7\r^3e'&TX-\u0001\u000ewKJLg-\u001f$fi\u000eD\u0017J\u001c3fq&sgo\\2bi&|g\u000e\u0006\u0004\u0002\u001e\tU\"\u0011\b\u0005\u0007\u0005o!\u0004\u0019A5\u0002\u000b\r|WO\u001c;\t\u0013\tmB\u0007%AA\u0002\tu\u0012AC5oI\u0016DH+\u001f9fgB1!q\bB(\u0005+rAA!\u0011\u0003L9!!1\tB%\u001b\t\u0011)EC\u0002\u0003H\t\u000ba\u0001\u0010:p_Rt\u0014\"A$\n\u0007\t5c)A\u0004qC\u000e\\\u0017mZ3\n\t\tE#1\u000b\u0002\u0004'\u0016\f(b\u0001B'\rB!!q\u000bB=\u001d\u0011\u0011IF!\u001e\u000f\t\tm#1\u000f\b\u0005\u0005;\u0012\tH\u0004\u0003\u0003`\t=d\u0002\u0002B1\u0005[rAAa\u0019\u0003l9!!Q\rB5\u001d\u0011\u0011\u0019Ea\u001a\n\u0003UK!a\u0019+\n\u0005\u0005\u0013\u0017B\u00011b\u0013\tyt,\u0003\u0002>}&\u0011A0`\u0005\u0004\u0005oZ\u0018\u0001\u0006*f[>$Xm\u0015;pe\u0006<W-T1oC\u001e,'/\u0003\u0003\u0003|\tu$!C%oI\u0016DH+\u001f9f\u0015\r\u00119h_\u0001%m\u0016\u0014\u0018NZ=GKR\u001c\u0007.\u00138eKbLeN^8dCRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0011\u0016\u0005\u0005{\u0011\t!A\u0010de\u0016\fG/\u001a+y\u0013:$W\r\u001f$peN+w-\\3oi6+G/\u00193bi\u0006$BA!#\u0003\u0010B!\u00111\u0002BF\u0013\u0011\u0011i)!\u0004\u0003!Q\u0013\u0018M\\:bGRLwN\\%oI\u0016D\bb\u0002BIm\u0001\u0007\u0011QF\u0001\t[\u0016$\u0018\rZ1uC\u0006\t3M]3bi\u0016$\u0016.\\3J]\u0012,\u0007PR8s'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR!!q\u0013BO!\u0011\tYA!'\n\t\tm\u0015Q\u0002\u0002\n)&lW-\u00138eKbDqA!%8\u0001\u0004\ti#A\u0012de\u0016\fG/Z(gMN,G/\u00138eKb4uN]*fO6,g\u000e^'fi\u0006$\u0017\r^1\u0015\t\t\r&\u0011\u0016\t\u0005\u0003\u0017\u0011)+\u0003\u0003\u0003(\u00065!aC(gMN,G/\u00138eKbDqA!%9\u0001\u0004\ti#\u0001\u0011hK:,'/\u0019;f%\u0016lw\u000e^3M_\u001e\u001cVmZ7f]RlU\r^1eCR\fGC\u0002BX\u0005k\u0013I\f\u0005\u0004\u0003@\tE\u0016QF\u0005\u0005\u0005g\u0013\u0019F\u0001\u0003MSN$\bB\u0002B\\s\u0001\u0007\u0011.\u0001\u0003tSj,\u0007b\u0002B^s\u0001\u0007\u0011QM\u0001\u0005iBLE-A\fnCf\u0014W-\u00119qK:$\u0017J\u001c3fq\u0016sGO]5fgR1\u0011Q\u0004Ba\u0005\u000bDqAa1;\u0001\u0004\u0011\u0019+A\u0006pM\u001a\u001cX\r^%oI\u0016D\bb\u0002Bdu\u0001\u0007!qS\u0001\ni&lW-\u00138eKb\u0004")
public class RemoteIndexCacheTest {
    private final Logger logger = LoggerFactory.getLogger(RemoteIndexCacheTest.class);
    private final MockTime time = new MockTime();
    private final int brokerId;
    private final long baseOffset = (long)Integer.MAX_VALUE + 101337L;
    private final long lastOffset = this.baseOffset() + 30L;
    private final int segmentSize;
    private final RemoteStorageManager rsm = (RemoteStorageManager)Mockito.mock(RemoteStorageManager.class);
    private RemoteIndexCache cache;
    private RemoteLogSegmentMetadata rlsMetadata;
    private File logDir;
    private File tpDir;
    private TopicIdPartition idPartition;

    private Logger logger() {
        return this.logger;
    }

    private MockTime time() {
        return this.time;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private long baseOffset() {
        return this.baseOffset;
    }

    private long lastOffset() {
        return this.lastOffset;
    }

    private int segmentSize() {
        return this.segmentSize;
    }

    private RemoteStorageManager rsm() {
        return this.rsm;
    }

    private RemoteIndexCache cache() {
        return this.cache;
    }

    private void cache_$eq(RemoteIndexCache x$1) {
        this.cache = x$1;
    }

    private RemoteLogSegmentMetadata rlsMetadata() {
        return this.rlsMetadata;
    }

    private void rlsMetadata_$eq(RemoteLogSegmentMetadata x$1) {
        this.rlsMetadata = x$1;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private File tpDir() {
        return this.tpDir;
    }

    private void tpDir_$eq(File x$1) {
        this.tpDir = x$1;
    }

    private TopicIdPartition idPartition() {
        return this.idPartition;
    }

    private void idPartition_$eq(TopicIdPartition x$1) {
        this.idPartition = x$1;
    }

    @BeforeEach
    public void setup() {
        this.idPartition_$eq(new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0)));
        String tempDirectory_prefix = new StringBuilder(6).append("kafka-").append(this.getClass().getSimpleName()).toString();
        Object var2_1 = null;
        this.logDir_$eq(TestUtils.tempDirectory(null, (String)tempDirectory_prefix));
        this.tpDir_$eq(new File(this.logDir(), this.idPartition().toString()));
        Files.createDirectory(this.tpDir().toPath(), new FileAttribute[0]);
        RemoteLogSegmentId remoteLogSegmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
        this.rlsMetadata_$eq(new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L))));
        this.cache_$eq(new RemoteIndexCache(this.rsm(), this.tpDir().toString()));
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata);
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata);
            TransactionIndex txnIdx = this.createTxIndexForSegmentMetadata(metadata);
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                return new FileInputStream(txnIdx.file());
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
    }

    @AfterEach
    public void cleanup() {
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        try {
            Utils.delete((File)this.logDir());
        }
        catch (IOException iOException) {}
        TestUtils$.MODULE$.assertNoNonDaemonThreads("remote-log-index-cleaner");
    }

    @Test
    public void testIndexFileNameAndLocationOnDisk() {
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Path offsetIndexFile = entry.offsetIndex().file().toPath();
        Path txnIndexFile = entry.txnIndex().file().toPath();
        Path timeIndexFile = entry.timeIndex().file().toPath();
        String expectedOffsetIndexFileName = RemoteIndexCache.remoteOffsetIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTimeIndexFileName = RemoteIndexCache.remoteTimeIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        String expectedTxnIndexFileName = RemoteIndexCache.remoteTransactionIndexFileName((RemoteLogSegmentMetadata)this.rlsMetadata());
        Assertions.assertEquals((Object)expectedOffsetIndexFileName, (Object)((Object)offsetIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTxnIndexFileName, (Object)((Object)txnIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)expectedTimeIndexFileName, (Object)((Object)timeIndexFile.getFileName()).toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)offsetIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(46).append("offsetIndex=").append(offsetIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)txnIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(43).append("txnIndex=").append(txnIndexFile).append(" is created under incorrect parent").toString());
        Assertions.assertEquals((Object)"remote-log-index-cache", (Object)((Object)timeIndexFile.getParent().getFileName()).toString(), (String)new StringBuilder(44).append("timeIndex=").append(timeIndexFile).append(" is created under incorrect parent").toString());
    }

    @Test
    public void testFetchIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        OffsetPosition offsetPosition1 = offsetIndex.entry(1);
        int resultPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition1.offset);
        Assertions.assertEquals((int)offsetPosition1.position, (int)resultPosition);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        OffsetPosition offsetPosition2 = offsetIndex.entry(2);
        int resultPosition2 = this.cache().lookupOffset(this.rlsMetadata(), offsetPosition2.offset);
        Assertions.assertEquals((int)offsetPosition2.position, (int)resultPosition2);
        Assertions.assertNotNull((Object)this.cache().getIndexEntry(this.rlsMetadata()));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.rsm()});
    }

    @Test
    public void testFetchIndexForMissingTransactionIndex() {
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(ans -> {
            RemoteLogSegmentMetadata metadata = (RemoteLogSegmentMetadata)ans.getArgument(0);
            RemoteStorageManager.IndexType indexType = (RemoteStorageManager.IndexType)ans.getArgument(1);
            OffsetIndex offsetIdx = this.createOffsetIndexForSegmentMetadata(metadata);
            TimeIndex timeIdx = this.createTimeIndexForSegmentMetadata(metadata);
            this.maybeAppendIndexEntries(offsetIdx, timeIdx);
            if (RemoteStorageManager.IndexType.OFFSET.equals(indexType)) {
                return new FileInputStream(offsetIdx.file());
            }
            if (RemoteStorageManager.IndexType.TIMESTAMP.equals(indexType)) {
                return new FileInputStream(timeIdx.file());
            }
            if (RemoteStorageManager.IndexType.TRANSACTION.equals(indexType)) {
                throw new RemoteResourceNotFoundException("txn index not found");
            }
            if (RemoteStorageManager.IndexType.LEADER_EPOCH.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            if (RemoteStorageManager.IndexType.PRODUCER_SNAPSHOT.equals(indexType)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)indexType);
        });
        RemoteIndexCache.Entry entry = this.cache().getIndexEntry(this.rlsMetadata());
        Assertions.assertTrue((boolean)entry.txnIndex().file().exists());
        Assertions.assertEquals((long)0L, (long)entry.txnIndex().file().length());
    }

    @Test
    public void testPositionForNonExistingIndexFromRemoteStorage() {
        OffsetIndex offsetIndex = this.cache().getIndexEntry(this.rlsMetadata()).offsetIndex();
        int lastOffsetPosition = this.cache().lookupOffset(this.rlsMetadata(), offsetIndex.lastOffset());
        long greaterOffsetThanLastOffset = offsetIndex.lastOffset() + 1L;
        Assertions.assertEquals((int)lastOffsetPosition, (int)this.cache().lookupOffset(this.rlsMetadata(), greaterOffsetThanLastOffset));
        OffsetPosition nonExistentOffsetPosition = new OffsetPosition(this.baseOffset(), 0);
        long lowerOffsetThanBaseOffset = offsetIndex.baseOffset() - 1L;
        Assertions.assertEquals((int)nonExistentOffsetPosition.position, (int)this.cache().lookupOffset(this.rlsMetadata(), lowerOffsetThanBaseOffset));
    }

    @Test
    public void testCacheEntryExpiry() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        this.assertAtLeastOnePresent(this.cache(), (Seq<Uuid>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{((RemoteLogSegmentMetadata)metadataList.apply(1)).remoteLogSegmentId().id(), ((RemoteLogSegmentMetadata)metadataList.head()).remoteLogSegmentId().id()}));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        Option missingEntryOpt = metadataList.find((Function1 & Serializable)segmentMetadata -> BoxesRunTime.boxToBoolean((boolean)RemoteIndexCacheTest.$anonfun$testCacheEntryExpiry$1(this, segmentMetadata)));
        Assertions.assertFalse((boolean)missingEntryOpt.isEmpty());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)missingEntryOpt.get());
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(4, this.verifyFetchIndexInvocation$default$2());
    }

    @Test
    public void testGetIndexAfterCacheClose() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
    }

    @Test
    public void testCloseIsIdempotent() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        this.cache().close();
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheEntryIsDeletedOnInvalidation() {
        Uuid internalIndexKey = this.rlsMetadata().remoteLogSegmentId().id();
        RemoteIndexCache.Entry cacheEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".index").isPresent(), (String)new StringBuilder(47).append("Offset index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".txnindex").isPresent(), (String)new StringBuilder(44).append("Txn index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertTrue((boolean)this.getIndexFileFromDisk$1(".timeindex").isPresent(), (String)new StringBuilder(45).append("Time index file should be present on disk at ").append(this.tpDir().toPath()).toString());
        this.cache().internalCache().put((Object)internalIndexKey, (Object)cacheEntry);
        Assertions.assertEquals((int)0, (int)this.cache().expiredIndexes().size(), (String)"expiredIndex queue should be zero at start of test");
        this.cache().internalCache().invalidate((Object)internalIndexKey);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cacheEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!cacheEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Failed to cleanup cache entry after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry, (VerificationMode)Mockito.times((int)2))).markForCleanup();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)cacheEntry)).cleanup();
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.timeIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((AbstractIndex)Mockito.verify((Object)cacheEntry.offsetIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        ((TransactionIndex)Mockito.verify((Object)cacheEntry.txnIndex())).renameTo((File)ArgumentMatchers.any(File.class));
        Assertions.assertFalse((boolean)this.getIndexFileFromDisk$1(".index").isPresent(), (String)new StringBuilder(51).append("Offset index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromDisk$1(".txnindex").isPresent(), (String)new StringBuilder(48).append("Txn index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromDisk$1(".timeindex").isPresent(), (String)new StringBuilder(49).append("Time index file should not be present on disk at ").append(this.tpDir().toPath()).toString());
        Assertions.assertFalse((boolean)this.getIndexFileFromDisk$1(".deleted").isPresent(), (String)new StringBuilder(64).append("Index file marked for deletion should not be present on disk at ").append(this.tpDir().toPath()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanerThreadShutdown() {
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().isEmpty());
        TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        spyEntry.cleanup();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("kaboom! I am expected exception in unit test.")});
        Uuid key = Uuid.randomUuid();
        this.cache().internalCache().put((Object)key, (Object)spyEntry);
        this.cache().internalCache().invalidate((Object)key);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isCleanStarted()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed while waiting for clean up to start");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Thread.sleep(100L);
        Set<Thread> threads = TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        Assertions.assertEquals((int)1, (int)threads.size(), (String)new StringBuilder(26).append("Found unexpected ").append(threads.size()).append(" threads=").append(((IterableOnceOps)threads.map((Function1 & Serializable)t -> t.getName())).mkString(", ")).toString());
        this.cache().close();
        threads = TestUtils$.MODULE$.numThreadsRunning("remote-log-index-cleaner", true);
        Assertions.assertTrue((boolean)threads.isEmpty(), (String)new StringBuilder(26).append("Found unexpected ").append(threads.size()).append(" threads=").append(((IterableOnceOps)threads.map((Function1 & Serializable)t -> t.getName())).mkString(", ")).toString());
        Assertions.assertFalse((boolean)this.cache().cleanerThread().isRunning(), (String)"Unexpected thread state=running. Check error logs.");
    }

    @Test
    public void testClose() {
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(this.generateSpyCacheEntry$default$1());
        this.cache().internalCache().put((Object)this.rlsMetadata().remoteLogSegmentId().id(), (Object)spyEntry);
        this.cache().close();
        ((RemoteIndexCache.Entry)Mockito.verify((Object)spyEntry)).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex())).close();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex())).close();
        ((TransactionIndex)Mockito.verify((Object)spyEntry.txnIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.offsetIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        ((AbstractIndex)Mockito.verify((Object)spyEntry.timeIndex(), (VerificationMode)Mockito.times((int)0))).deleteIfExists();
        Assertions.assertTrue((boolean)this.cache().cleanerThread().isShutdownComplete());
    }

    @Test
    public void testConcurrentReadWriteAccessForCache() {
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, (Seq<RemoteStorageManager.IndexType>)new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)Nil$.MODULE$)));
        Mockito.reset((Object[])new RemoteStorageManager[]{this.rsm()});
        CountDownLatch latchForCacheHit = new CountDownLatch(1);
        CountDownLatch latchForCacheMiss = new CountDownLatch(1);
        Runnable readerCacheHit = () -> {
            this.logger().debug(new StringBuilder(38).append("Waiting for signal to begin read from ").append(Thread.currentThread()).toString());
            latchForCacheHit.await();
            Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head()));
            this.logger().debug(new StringBuilder(36).append("Signaling CacheMiss to unblock from ").append(Thread.currentThread()).toString());
            latchForCacheMiss.countDown();
        };
        Mockito.when((Object)this.rsm().fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.any(RemoteStorageManager.IndexType.class))).thenAnswer(x$7 -> {
            RemoteIndexCacheTest.$anonfun$testConcurrentReadWriteAccessForCache$2(this, latchForCacheHit, latchForCacheMiss, x$7);
            return BoxedUnit.UNIT;
        });
        Runnable readerCacheMiss = () -> Assertions.assertNotNull((Object)this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.last()));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            executor.submit(readerCacheMiss);
            executor.submit(readerCacheHit);
            Assertions.assertTrue((boolean)latchForCacheMiss.await(30L, TimeUnit.SECONDS));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testReloadCacheAfterClose() {
        Utils.closeQuietly((AutoCloseable)this.cache(), (String)"RemoteIndexCache created for unit test");
        this.cache_$eq(new RemoteIndexCache(2, this.rsm(), this.tpDir().toString()));
        TopicIdPartition tpId = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        List<RemoteLogSegmentMetadata> metadataList = this.generateRemoteLogSegmentMetadata(3, tpId);
        this.assertCacheSize(0);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.head());
        this.assertCacheSize(1);
        this.verifyFetchIndexInvocation(1, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(1));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(2, this.verifyFetchIndexInvocation$default$2());
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.cache().getIndexEntry((RemoteLogSegmentMetadata)metadataList.apply(2));
        this.assertCacheSize(2);
        this.verifyFetchIndexInvocation(3, this.verifyFetchIndexInvocation$default$2());
        this.cache().close();
        RemoteIndexCache reloadedCache = new RemoteIndexCache(2, this.rsm(), this.tpDir().toString());
        Assertions.assertEquals((int)2, (int)reloadedCache.internalCache().asMap().size());
        reloadedCache.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.rsm()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRemoveItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        this.cache().remove(segmentId.id());
        Assertions.assertFalse((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!spyEntry.isMarkedForCleanup()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testRemoveNonExistentItem() {
        RemoteLogSegmentId segmentId = this.rlsMetadata().remoteLogSegmentId();
        Uuid segmentUuid = segmentId.id();
        RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
        this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        this.cache().remove(Uuid.randomUuid());
        Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
        Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
    }

    @Test
    public void testRemoveMultipleItems() {
        HashMap uuidAndEntryList = new HashMap();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> {
            RemoteLogSegmentId segmentId = RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
            Uuid segmentUuid = segmentId.id();
            RemoteIndexCache.Entry spyEntry = this.generateSpyCacheEntry(segmentId);
            uuidAndEntryList.put(segmentUuid, spyEntry);
            this.cache().internalCache().put((Object)segmentUuid, (Object)spyEntry);
            Assertions.assertTrue((boolean)this.cache().internalCache().asMap().containsKey(segmentUuid));
            Assertions.assertFalse((boolean)spyEntry.isMarkedForCleanup());
        });
        this.cache().removeAll(uuidAndEntryList.keySet());
        uuidAndEntryList.values().forEach(entry -> {
            long waitUntilTrue_pause = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!entry.isMarkedForCleanup()) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to mark cache entry for cleanup after invalidation");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
            }
        });
    }

    private RemoteIndexCache.Entry generateSpyCacheEntry(RemoteLogSegmentId remoteLogSegmentId) {
        RemoteLogSegmentMetadata rlsMetadata = new RemoteLogSegmentMetadata(remoteLogSegmentId, this.baseOffset(), this.lastOffset(), this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)));
        TimeIndex timeIndex = (TimeIndex)Mockito.spy((Object)this.createTimeIndexForSegmentMetadata(rlsMetadata));
        TransactionIndex txIndex = (TransactionIndex)Mockito.spy((Object)this.createTxIndexForSegmentMetadata(rlsMetadata));
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.spy((Object)this.createOffsetIndexForSegmentMetadata(rlsMetadata));
        return (RemoteIndexCache.Entry)Mockito.spy((Object)new RemoteIndexCache.Entry(offsetIndex, timeIndex, txIndex));
    }

    private RemoteLogSegmentId generateSpyCacheEntry$default$1() {
        return RemoteLogSegmentId.generateNew((TopicIdPartition)this.idPartition());
    }

    private void assertAtLeastOnePresent(RemoteIndexCache cache, Seq<Uuid> uuids) {
        Object object = new Object();
        try {
            uuids.foreach((Function1 & Serializable)uuid -> {
                RemoteIndexCacheTest.$anonfun$assertAtLeastOnePresent$1(cache, object, uuid);
                return BoxedUnit.UNIT;
            });
            Assertions.fail((String)"all uuids are not present in cache");
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assertCacheSize(int expectedSize) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteIndexCacheTest.$anonfun$assertCacheSize$1(this, expectedSize)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteIndexCacheTest.$anonfun$assertCacheSize$2(expectedSize));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyFetchIndexInvocation(int count, Seq<RemoteStorageManager.IndexType> indexTypes) {
        indexTypes.foreach((Function1 & Serializable)indexType -> ((RemoteStorageManager)Mockito.verify((Object)this.rsm(), (VerificationMode)Mockito.times((int)count))).fetchIndex((RemoteLogSegmentMetadata)ArgumentMatchers.any(RemoteLogSegmentMetadata.class), (RemoteStorageManager.IndexType)ArgumentMatchers.eq((Object)indexType)));
    }

    private Seq<RemoteStorageManager.IndexType> verifyFetchIndexInvocation$default$2() {
        return new .colon.colon((Object)RemoteStorageManager.IndexType.OFFSET, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TIMESTAMP, (List)new .colon.colon((Object)RemoteStorageManager.IndexType.TRANSACTION, (List)Nil$.MODULE$)));
    }

    private TransactionIndex createTxIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata) {
        File txnIdxFile = RemoteIndexCache.remoteTransactionIndexFile((File)this.tpDir(), (RemoteLogSegmentMetadata)metadata);
        txnIdxFile.createNewFile();
        return new TransactionIndex(metadata.startOffset(), txnIdxFile);
    }

    private TimeIndex createTimeIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new TimeIndex(RemoteIndexCache.remoteTimeIndexFile((File)this.tpDir(), (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 12);
    }

    private OffsetIndex createOffsetIndexForSegmentMetadata(RemoteLogSegmentMetadata metadata) {
        int maxEntries = (int)(metadata.endOffset() - metadata.startOffset());
        return new OffsetIndex(RemoteIndexCache.remoteOffsetIndexFile((File)this.tpDir(), (RemoteLogSegmentMetadata)metadata), metadata.startOffset(), maxEntries * 8);
    }

    private List<RemoteLogSegmentMetadata> generateRemoteLogSegmentMetadata(int size, TopicIdPartition tpId) {
        Buffer metadataList = (Buffer)Buffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach((Function1 & Serializable)i -> metadataList.append((Object)new RemoteLogSegmentMetadata(new RemoteLogSegmentId(tpId, Uuid.randomUuid()), this.baseOffset() * (long)BoxesRunTime.unboxToInt((Object)i), this.baseOffset() * (long)BoxesRunTime.unboxToInt((Object)i) + 10L, this.time().milliseconds(), this.brokerId(), this.time().milliseconds(), this.segmentSize(), Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L)))));
        return metadataList.toList();
    }

    private void maybeAppendIndexEntries(OffsetIndex offsetIndex, TimeIndex timeIndex) {
        if (!offsetIndex.isFull()) {
            long curTime = this.time().milliseconds();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), offsetIndex.maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long offset = offsetIndex.baseOffset() + (long)i;
                offsetIndex.append(offset, i);
                timeIndex.maybeAppend(curTime + (long)i, offset, true);
            });
            offsetIndex.flush();
            timeIndex.flush();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryExpiry$1(RemoteIndexCacheTest $this, RemoteLogSegmentMetadata segmentMetadata) {
        Uuid segmentId = segmentMetadata.remoteLogSegmentId().id();
        return !$this.cache().internalCache().asMap().containsKey(segmentId);
    }

    private final Optional getIndexFileFromDisk$1(String suffix) {
        return Files.walk(this.tpDir().toPath(), new FileVisitOption[0]).filter(x$6 -> Files.isRegularFile(x$6, new LinkOption[0])).filter(path -> ((Object)path.getFileName()).toString().endsWith(suffix)).findAny();
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryIsDeletedOnInvalidation$3(RemoteIndexCache.Entry cacheEntry$1) {
        return cacheEntry$1.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnInvalidation$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testCacheEntryIsDeletedOnInvalidation$5(RemoteIndexCache.Entry cacheEntry$1) {
        return cacheEntry$1.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testCacheEntryIsDeletedOnInvalidation$6() {
        return "Failed to cleanup cache entry after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testCleanerThreadShutdown$1(RemoteIndexCache.Entry spyEntry$1) {
        return spyEntry$1.isCleanStarted();
    }

    public static final /* synthetic */ String $anonfun$testCleanerThreadShutdown$2() {
        return "Failed while waiting for clean up to start";
    }

    public static final /* synthetic */ void $anonfun$testConcurrentReadWriteAccessForCache$2(RemoteIndexCacheTest $this, CountDownLatch latchForCacheHit$1, CountDownLatch latchForCacheMiss$1, InvocationOnMock x$7) {
        $this.logger().debug(new StringBuilder(38).append("Signaling CacheHit to begin read from ").append(Thread.currentThread()).toString());
        latchForCacheHit$1.countDown();
        $this.logger().debug(new StringBuilder(46).append("Waiting for signal to complete rsm fetch from ").append(Thread.currentThread()).toString());
        latchForCacheMiss$1.await();
    }

    public static final /* synthetic */ boolean $anonfun$testRemoveItem$1(RemoteIndexCache.Entry spyEntry$2) {
        return spyEntry$2.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testRemoveItem$2() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ boolean $anonfun$testRemoveMultipleItems$3(RemoteIndexCache.Entry entry$1) {
        return entry$1.isMarkedForCleanup();
    }

    public static final /* synthetic */ String $anonfun$testRemoveMultipleItems$4() {
        return "Failed to mark cache entry for cleanup after invalidation";
    }

    public static final /* synthetic */ void $anonfun$assertAtLeastOnePresent$1(RemoteIndexCache cache$1, Object nonLocalReturnKey1$1, Uuid uuid) {
        if (cache$1.internalCache().asMap().containsKey(uuid)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$assertCacheSize$1(RemoteIndexCacheTest $this, int expectedSize$1) {
        return $this.cache().internalCache().asMap().size() == expectedSize$1;
    }

    public static final /* synthetic */ String $anonfun$assertCacheSize$2(int expectedSize$1) {
        return new StringBuilder(41).append("cache did not adhere to expected size of ").append(expectedSize$1).toString();
    }

    public RemoteIndexCacheTest() {
        this.brokerId = 1;
        this.segmentSize = 1024;
    }
}

