/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005a\u0001B\"E\u0001%CQA\u0017\u0001\u0005\u0002mCQ!\u0018\u0001\u0005ByCq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004t\u0001\u0001\u0006Ia\u001c\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019I\b\u0001)A\u0005m\"9!\u0010\u0001b\u0001\n\u0013q\u0007BB>\u0001A\u0003%q\u000eC\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u00055\u0001\u0001)A\u0005}\"Y\u0011q\u0002\u0001A\u0002\u0003\u0007I\u0011BA\t\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%I!!\r\t\u0017\u0005u\u0002\u00011A\u0001B\u0003&\u00111\u0003\u0005\f\u0003\u007f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0005C\u0006\u0002\\\u0001\u0001\r\u00111A\u0005\n\u0005u\u0003bCA1\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0007B1\"a\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002f!Y\u0011Q\u000f\u0001A\u0002\u0003\u0007I\u0011BA<\u0011-\tY\b\u0001a\u0001\u0002\u0003\u0006K!a\u001a\t\u0011\u0005u\u0004\u0001)C\u0005\u0003\u007fB\u0001\"a#\u0001A\u0013%\u0011Q\u0012\u0005\n\u0003/\u0003\u0011\u0013!C\u0005\u00033Cq!a,\u0001\t\u0003\n\t\fC\u0004\u0002T\u0002!\t!!6\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9!Q\u0003\u0001\u0005\u0002\t]\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005[\u0001A\u0011\u0001B\u0018\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqA!\u0012\u0001\t\u0003\u00119\u0005C\u0004\u0003R\u0001!\tAa\u0015\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!\u0011\u000e\u0001\u0005\u0002\t-\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001fCqA!'\u0001\t\u0003\u0011Y\nC\u0004\u0003&\u0002!\tAa*\t\u000f\tE\u0006\u0001\"\u0001\u00034\"9!Q\u0018\u0001\u0005\u0002\t}\u0006b\u0002Be\u0001\u0011\u0005!1\u001a\u0005\b\u0005+\u0004A\u0011\u0001Bl\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0005GDqA!<\u0001\t\u0003\u0011y\u000fC\u0004\u0003z\u0002!\tAa?\t\u000f\r\u0015\u0001\u0001\"\u0001\u0004\b!91\u0011\u0003\u0001\u0005\u0002\rM\u0001bBB\u000f\u0001\u0011\u00051q\u0004\u0005\b\u0007S\u0001A\u0011AB\u0016\u0011\u001d\u0019)\u0004\u0001C\u0001\u0007oAqa!\u0011\u0001\t\u0003\u0019\u0019\u0005C\u0004\u0004N\u0001!\taa\u0014\t\u000f\re\u0003\u0001\"\u0001\u0004\\!91Q\r\u0001\u0005\u0002\r\u001d\u0004bBB9\u0001\u0011\u000511\u000f\u0005\b\u0007{\u0002A\u0011AB@\u0011\u001d\u0019I\t\u0001C\u0001\u0007\u0017Cqa!&\u0001\t\u0003\u00199\nC\u0004\u0004\"\u0002!\taa)\t\u000f\r5\u0006\u0001\"\u0001\u00040\"91\u0011\u0018\u0001\u0005\u0002\rm\u0006bBBc\u0001\u0011\u00051q\u0019\u0005\b\u0007#\u0004A\u0011ABj\u0011\u001d\u0019i\u000e\u0001C\u0001\u0007?Dqa!;\u0001\t\u0003\u0019Y\u000fC\u0004\u0004v\u0002!\taa>\u00037Q{\u0007/[2D_6l\u0017M\u001c3J]R,wM]1uS>tG+Z:u\u0015\t)e)A\u0003bI6LgNC\u0001H\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001&Q-B\u00111JT\u0007\u0002\u0019*\u0011QJR\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002P\u0019\n12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002R)6\t!K\u0003\u0002T\r\u0006)Q\u000f^5mg&\u0011QK\u0015\u0002\b\u0019><w-\u001b8h!\t9\u0006,D\u0001E\u0013\tIFIA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0003\"a\u0016\u0001\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\u0018\t\u0004A\u0016<W\"A1\u000b\u0005\t\u001c\u0017AC2pY2,7\r^5p]*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gC\n\u00191+Z9\u0011\u0005!\\W\"A5\u000b\u0005)4\u0015AB:feZ,'/\u0003\u0002mS\nY1*\u00194lC\u000e{gNZ5h\u00035qW/\u001c)beRLG/[8ogV\tq\u000e\u0005\u0002qc6\t1-\u0003\u0002sG\n\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005AB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003Y\u0004\"\u0001]<\n\u0005a\u001c'!B*i_J$\u0018!\u00073fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\n!B\\;n\u0005J|7.\u001a:t\u0003-qW/\u001c\"s_.,'o\u001d\u0011\u0002\u001b1Lg.Z*fa\u0006\u0014\u0018\r^8s+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003mC:<'BAA\u0004\u0003\u0011Q\u0017M^1\n\t\u0005-\u0011\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u0002\u001d1Lg.Z*fa\u0006\u0014\u0018\r^8sA\u0005aAo\u001c9jGN+'O^5dKV\u0011\u00111\u0003\t\u0005\u0003+\tIC\u0004\u0003\u0002\u0018\u0005\u0015b\u0002BA\r\u0003GqA!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?A\u0015A\u0002\u001fs_>$h(C\u0001H\u0013\t)e)C\u0002\u0002(\u0011\u000bA\u0002V8qS\u000e\u001cu.\\7b]\u0012LA!a\u000b\u0002.\taAk\u001c9jGN+'O^5dK*\u0019\u0011q\u0005#\u0002!Q|\u0007/[2TKJ4\u0018nY3`I\u0015\fH\u0003BA\u001a\u0003s\u00012\u0001]A\u001b\u0013\r\t9d\u0019\u0002\u0005+:LG\u000fC\u0005\u0002<1\t\t\u00111\u0001\u0002\u0014\u0005\u0019\u0001\u0010J\u0019\u0002\u001bQ|\u0007/[2TKJ4\u0018nY3!\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0005\u0005\r\u0003\u0003BA#\u0003/j!!a\u0012\u000b\u0007\u0015\u000bIE\u0003\u0003\u0002L\u00055\u0013aB2mS\u0016tGo\u001d\u0006\u0004\u000f\u0006=#\u0002BA)\u0003'\na!\u00199bG\",'BAA+\u0003\ry'oZ\u0005\u0005\u00033\n9EA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\u0011\t\u0019$a\u0018\t\u0013\u0005mr\"!AA\u0002\u0005\r\u0013\u0001D1e[&t7\t\\5f]R\u0004\u0013!\u0004;fgR$v\u000e]5d\u001d\u0006lW-\u0006\u0002\u0002hA!\u0011\u0011NA9\u001d\u0011\tY'!\u001c\u0011\u0007\u0005m1-C\u0002\u0002p\r\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003gR1!a\u001cd\u0003E!Xm\u001d;U_BL7MT1nK~#S-\u001d\u000b\u0005\u0003g\tI\bC\u0005\u0002<I\t\t\u00111\u0001\u0002h\u0005qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013AE2sK\u0006$X-\u00118e/\u0006LG\u000fV8qS\u000e$B!a\r\u0002\u0002\"9\u00111\u0011\u000bA\u0002\u0005\u0015\u0015\u0001B8qiN\u0004B!!\u0006\u0002\b&!\u0011\u0011RA\u0017\u0005M!v\u000e]5d\u0007>lW.\u00198e\u001fB$\u0018n\u001c8t\u0003M9\u0018-\u001b;G_J$v\u000e]5d\u0007J,\u0017\r^3e)\u0019\t\u0019$a$\u0002\u0014\"9\u0011\u0011S\u000bA\u0002\u0005\u001d\u0014!\u0003;pa&\u001cg*Y7f\u0011!\t)*\u0006I\u0001\u0002\u0004y\u0017a\u0002;j[\u0016|W\u000f^\u0001\u001eo\u0006LGOR8s)>\u0004\u0018nY\"sK\u0006$X\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0014\u0016\u0004_\u0006u5FAAP!\u0011\t\t+a+\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%6-\u0001\u0006b]:|G/\u0019;j_:LA!!,\u0002$\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000bM,G/\u00169\u0015\t\u0005M\u00121\u0017\u0005\b\u0003k;\u0002\u0019AA\\\u0003\u0011IgNZ8\u0011\t\u0005e\u0016qY\u0007\u0003\u0003wSA!!0\u0002@\u0006\u0019\u0011\r]5\u000b\t\u0005\u0005\u00171Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t)-a\u0015\u0002\u000b),h.\u001b;\n\t\u0005%\u00171\u0018\u0002\t)\u0016\u001cH/\u00138g_\"\u001aq#!4\u0011\t\u0005e\u0016qZ\u0005\u0005\u0003#\fYL\u0001\u0006CK\u001a|'/Z#bG\"\fQa\u00197pg\u0016$\"!a\r)\u0007a\tI\u000e\u0005\u0003\u0002:\u0006m\u0017\u0002BAo\u0003w\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0015Q,7\u000f^\"sK\u0006$X\r\u0006\u0003\u00024\u0005\r\bbBAs3\u0001\u0007\u0011qM\u0001\u0007cV|'/^7)\u000fe\tI/!?\u0002|B!\u00111^A{\u001b\t\tiO\u0003\u0003\u0002p\u0006E\u0018\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005M\u0018qX\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005]\u0018Q\u001e\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005u(\u0011A\u0011\u0003\u0003\u007f\f!A_6\"\u0005\t\r\u0011!B6sC\u001a$\bfB\r\u0003\b\t=!\u0011\u0003\t\u0005\u0005\u0013\u0011Y!\u0004\u0002\u0002r&!!QBAy\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0003\u0014\u0005A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002-Q,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miN$B!a\r\u0003\u001a!9\u0011Q\u001d\u000eA\u0002\u0005\u001d\u0004f\u0002\u000e\u0002j\u0006e(Q\u0004\u0017\u0005\u0003{\u0014\t\u0001K\u0004\u001b\u0005\u000f\u0011yA!\u0005\u0002AQ,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c\u000b\u0005\u0003g\u0011)\u0003C\u0004\u0002fn\u0001\r!a\u001a)\u000fm\tI/!?\u0003*1\"\u0011Q B\u0001Q\u001dY\"q\u0001B\b\u0005#\tq\u0004^3ti\u000e\u0013X-\u0019;f/&$\b\u000eR3gCVdG\u000fU1si&$\u0018n\u001c8t)\u0011\t\u0019D!\r\t\u000f\u0005\u0015H\u00041\u0001\u0002h!:A$!;\u0002z\nUB\u0006BA\u007f\u0005\u0003As\u0001\bB\u0004\u0005\u001f\u0011\t\"A\u000buKN$8I]3bi\u0016<\u0016\u000e\u001e5D_:4\u0017nZ:\u0015\t\u0005M\"Q\b\u0005\b\u0003Kl\u0002\u0019AA4Q\u001di\u0012\u0011^A}\u0005\u0003bC!!@\u0003\u0002!:QDa\u0002\u0003\u0010\tE\u0011a\u0007;fgR\u001c%/Z1uK^CWM\\!me\u0016\fG-_#ySN$8\u000f\u0006\u0003\u00024\t%\u0003bBAs=\u0001\u0007\u0011q\r\u0015\b=\u0005%\u0018\u0011 B'Y\u0011\tiP!\u0001)\u000fy\u00119Aa\u0004\u0003\u0012\u0005QC/Z:u\u0007J,\u0017\r^3XQ\u0016t\u0017\t\u001c:fC\u0012LX\t_5tiN<\u0016\u000e\u001e5JM:{G/\u0012=jgR\u001cH\u0003BA\u001a\u0005+Bq!!: \u0001\u0004\t9\u0007K\u0004 \u0003S\fIP!\u0017-\t\u0005u(\u0011\u0001\u0015\b?\t\u001d!q\u0002B\t\u0003}!Xm\u001d;De\u0016\fG/Z,ji\"\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\u0005\u0003g\u0011\t\u0007C\u0004\u0002f\u0002\u0002\r!a\u001a)\u000f\u0001\nI/!?\u0003f1\"\u0011Q B\u0001Q\u001d\u0001#q\u0001B\b\u0005#\ta\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138wC2LGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s)\u0011\t\u0019D!\u001c\t\u000f\u0005\u0015\u0018\u00051\u0001\u0002h!:\u0011%!;\u0002z\nED\u0006BA\u007f\u0005\u0003As!\tB\u0004\u0005\u001f\u0011\t\"A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f%\u0016\u0004H.[2bi&|gNR1di>\u0014H\u0003BA\u001a\u0005sBq!!:#\u0001\u0004\t9\u0007K\u0004#\u0003S\fIP! -\t\u0005u(\u0011\u0001\u0015\bE\t\u001d!q\u0002B\t\u0003\u0011\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,\u0007+\u0019:uSRLwN\\\"pk:$H\u0003BA\u001a\u0005\u000bCq!!:$\u0001\u0004\t9\u0007K\u0004$\u0003S\fIP!#-\t\u0005u(\u0011\u0001\u0015\bG\t\u001d!q\u0002B\t\u0003m!Xm\u001d;J]Z\fG.\u001b3U_BL7\rT3wK2\u001cuN\u001c4jOR!\u00111\u0007BI\u0011\u001d\t)\u000f\na\u0001\u0003OBs\u0001JAu\u0003s\u0014)\n\f\u0003\u0002~\n\u0005\u0001f\u0002\u0013\u0003\b\t=!\u0011C\u0001\u000fi\u0016\u001cH\u000fT5tiR{\u0007/[2t)\u0011\t\u0019D!(\t\u000f\u0005\u0015X\u00051\u0001\u0002h!:Q%!;\u0002z\n\u0005F\u0006BA\u007f\u0005\u0003As!\nB\u0004\u0005\u001f\u0011\t\"A\u000fuKN$H*[:u)>\u0004\u0018nY:XSRD\u0017J\\2mk\u0012,G*[:u)\u0011\t\u0019D!+\t\u000f\u0005\u0015h\u00051\u0001\u0002h!:a%!;\u0002z\n5F\u0006BA\u007f\u0005\u0003AsA\nB\u0004\u0005\u001f\u0011\t\"A\u0011uKN$H*[:u)>\u0004\u0018nY:XSRDW\t_2mk\u0012,\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u00024\tU\u0006bBAsO\u0001\u0007\u0011q\r\u0015\bO\u0005%\u0018\u0011 B]Y\u0011\tiP!\u0001)\u000f\u001d\u00129Aa\u0004\u0003\u0012\u00059B/Z:u\u00032$XM\u001d)beRLG/[8o\u0007>,h\u000e\u001e\u000b\u0005\u0003g\u0011\t\rC\u0004\u0002f\"\u0002\r!a\u001a)\u000f!\nI/!?\u0003F2\"\u0011Q B\u0001Q\u001dA#q\u0001B\b\u0005#\t1\u0003^3ti\u0006cG/\u001a:BgNLwM\\7f]R$B!a\r\u0003N\"9\u0011Q]\u0015A\u0002\u0005\u001d\u0004fB\u0015\u0002j\u0006e(\u0011\u001b\u0017\u0005\u0003{\u0014\t\u0001K\u0004*\u0005\u000f\u0011yA!\u0005\u0002gQ,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;XSRDWj\u001c:f\u0003N\u001c\u0018n\u001a8nK:$H\u000b[1o!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\u001a\u00053Dq!!:+\u0001\u0004\t9\u0007K\u0004+\u0003S\fIP!8-\t\u0005u(\u0011\u0001\u0015\bU\t\u001d!q\u0002B\t\u0003M\"Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8u/&$\b.T8sKB\u000b'\u000f^5uS>t7\u000f\u00165b]\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u00024\t\u0015\bbBAsW\u0001\u0007\u0011q\r\u0015\bW\u0005%\u0018\u0011 BuY\u0011\tiP!\u0001)\u000f-\u00129Aa\u0004\u0003\u0012\u0005\u0011C/Z:u\u00032$XM],ji\"LeN^1mS\u0012\u0004\u0016M\u001d;ji&|gnQ8v]R$B!a\r\u0003r\"9\u0011Q\u001d\u0017A\u0002\u0005\u001d\u0004f\u0002\u0017\u0002j\u0006e(Q\u001f\u0017\u0005\u0003{\u0014\t\u0001K\u0004-\u0005\u000f\u0011yA!\u0005\u0002;Q,7\u000f^!mi\u0016\u0014x\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR$B!a\r\u0003~\"9\u0011Q]\u0017A\u0002\u0005\u001d\u0004fB\u0017\u0002j\u0006e8\u0011\u0001\u0017\u0005\u0003{\u0014\t\u0001K\u0004.\u0005\u000f\u0011yA!\u0005\u0002SQ,7\u000f^!mi\u0016\u0014x\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR<\u0016\u000e\u001e5JM\u0016C\u0018n\u001d;t)\u0011\t\u0019d!\u0003\t\u000f\u0005\u0015h\u00061\u0001\u0002h!:a&!;\u0002z\u000e5A\u0006BA\u007f\u0005\u0003AsA\fB\u0004\u0005\u001f\u0011\t\"A\u0011uKN$8I]3bi\u0016\fE\u000e^3s)>\u0004\u0018nY,ji\"\u0014\u0016mY6Bo\u0006\u0014X\r\u0006\u0003\u00024\rU\u0001bBAs_\u0001\u0007\u0011q\r\u0015\b_\u0005%\u0018\u0011`B\rY\u0011\tiP!\u0001)\u000f=\u00129Aa\u0004\u0003\u0012\u0005yC/Z:u\u0007>tg-[4Qe\u0016\u001cXM\u001d<bi&|g.Q2s_N\u001c\b+\u0019:uSRLwN\\!mi\u0016\u0014\u0018\r^5p]R!\u00111GB\u0011\u0011\u001d\t)\u000f\ra\u0001\u0003OBs\u0001MAu\u0003s\u001c)\u0003\f\u0003\u0002~\n\u0005\u0001f\u0002\u0019\u0003\b\t=!\u0011C\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>tG\u0003BA\u001a\u0007[Aq!!:2\u0001\u0004\t9\u0007K\u00042\u0003S\fIp!\r-\t\u0005u(\u0011\u0001\u0015\bc\t\u001d!q\u0002B\t\u0003A\"Xm\u001d;U_BL7mV5uQ\u000e{G\u000e\\5eS:<7\t[1s\t\u0016dW\r^5p]\u0006sGm\u0011:fCR,\u0017iZ1j]R!\u00111GB\u001d\u0011\u001d\t)O\ra\u0001\u0003OBsAMAu\u0003s\u001ci\u0004\f\u0003\u0002~\n\u0005\u0001f\u0002\u001a\u0003\b\t=!\u0011C\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\u001c;fe:\fG\u000eV8qS\u000e$B!a\r\u0004F!9\u0011Q]\u001aA\u0002\u0005\u001d\u0004fB\u001a\u0002j\u0006e8\u0011\n\u0017\u0005\u0003{\u0014\t\u0001K\u00044\u0005\u000f\u0011yA!\u0005\u0002=Q,7\u000f\u001e#fY\u0016$Xm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$H\u0003BA\u001a\u0007#Bq!!:5\u0001\u0004\t9\u0007K\u00045\u0003S\fIp!\u0016-\t\u0005u(\u0011\u0001\u0015\bi\t\u001d!q\u0002B\t\u0003)\"Xm\u001d;EK2,G/Z,iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cHoV5uQ&3W\t_5tiN$B!a\r\u0004^!9\u0011Q]\u001bA\u0002\u0005\u001d\u0004fB\u001b\u0002j\u0006e8\u0011\r\u0017\u0005\u0003{\u0014\t\u0001K\u00046\u0005\u000f\u0011yA!\u0005\u0002\u0019Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3\u0015\t\u0005M2\u0011\u000e\u0005\b\u0003K4\u0004\u0019AA4Q\u001d1\u0014\u0011^A}\u0007[bC!!@\u0003\u0002!:aGa\u0002\u0003\u0010\tE\u0011\u0001\t;fgR$Um]2sS\n,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR$B!a\r\u0004v!9\u0011Q]\u001cA\u0002\u0005\u001d\u0004fB\u001c\u0002j\u0006e8\u0011\u0010\u0017\u0005\u0003{\u0014\t\u0001K\u00048\u0005\u000f\u0011yA!\u0005\u0002YQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f^,ji\"Le-\u0012=jgR\u001cH\u0003BA\u001a\u0007\u0003Cq!!:9\u0001\u0004\t9\u0007K\u00049\u0003S\fIp!\"-\t\u0005u(\u0011\u0001\u0015\bq\t\u001d!q\u0002B\t\u0003\u0005\"Xm\u001d;EKN\u001c'/\u001b2f+:\fg/Y5mC\ndW\rU1si&$\u0018n\u001c8t)\u0011\t\u0019d!$\t\u000f\u0005\u0015\u0018\b1\u0001\u0002h!:\u0011(!;\u0002z\u000eEE\u0006BA\u007f\u0005\u0003As!\u000fB\u0004\u0005\u001f\u0011\t\"A\u0013uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8ogR!\u00111GBM\u0011\u001d\t)O\u000fa\u0001\u0003OBsAOAu\u0003s\u001ci\n\f\u0003\u0002~\n\u0005\u0001f\u0002\u001e\u0003\b\t=!\u0011C\u0001\"i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003g\u0019)\u000bC\u0004\u0002fn\u0002\r!a\u001a)\u000fm\nI/!?\u0004*2\"\u0011Q B\u0001Q\u001dY$q\u0001B\b\u0005#\t\u0011\t^3ti\u0012+7o\u0019:jE\u0016,f\u000eZ3s%\u0016\u0004H.[2bi\u0016$\u0007+\u0019:uSRLwN\\:XQ\u0016t'+Z1tg&<g.\\3oi&\u001b\u0018J\u001c)s_\u001e\u0014Xm]:\u0015\t\u0005M2\u0011\u0017\u0005\b\u0003Kd\u0004\u0019AA4Q\u001da\u0014\u0011^A}\u0007kcC!!@\u0003\u0002!:AHa\u0002\u0003\u0010\tE\u0011A\b;fgR$Um]2sS\n,\u0017\t^'j]&\u001b(\u000fU1si&$\u0018n\u001c8t)\u0011\t\u0019d!0\t\u000f\u0005\u0015X\b1\u0001\u0002h!:Q(!;\u0002z\u000e\u0005G\u0006BA\u007f\u0005\u0003As!\u0010B\u0004\u0005\u001f\u0011\t\"\u0001\u0014uKN$H)Z:de&\u0014W-\u00168eKJl\u0015N\\%teB\u000b'\u000f^5uS>t7/T5yK\u0012$B!a\r\u0004J\"9\u0011Q\u001d A\u0002\u0005\u001d\u0004f\u0002 \u0002j\u0006e8Q\u001a\u0017\u0005\u0003{\u0014\t\u0001K\u0004?\u0005\u000f\u0011yA!\u0005\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKB|'\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hgR!\u00111GBk\u0011\u001d\t)o\u0010a\u0001\u0003OBsaPAu\u0003s\u001cI\u000e\f\u0003\u0002~\n\u0005\u0001fB \u0003\b\t=!\u0011C\u0001/i\u0016\u001cH\u000fR3tGJL'-Z!oI2K7\u000f\u001e+pa&\u001c7oV5uQ>,H/\u00138uKJt\u0017\r\u001c+pa&\u001c7\u000f\u0006\u0003\u00024\r\u0005\bbBAs\u0001\u0002\u0007\u0011q\r\u0015\b\u0001\u0006%\u0018\u0011`BsY\u0011\tiP!\u0001)\u000f\u0001\u00139Aa\u0004\u0003\u0012\u0005aD/Z:u\t\u0016\u001c8M]5cK\u0012{Wm\u001d(pi\u001a\u000b\u0017\u000e\\,iK:d\u0015n\u001d;j]\u001e\u0014V-Y:tS\u001etW.\u001a8u\u0013N,f.Y;uQ>\u0014\u0018N_3e)\u0011\t\u0019d!<\t\u000f\u0005\u0015\u0018\t1\u0001\u0002h!:\u0011)!;\u0002z\u000eEH\u0006BA\u007f\u0005\u0003As!\u0011B\u0004\u0005\u001f\u0011\t\"\u0001\u0011uKN$8I]3bi\u0016<\u0016\u000e\u001e5U_BL7MT1nK\u000e{G\u000e\\5tS>tG\u0003BA\u001a\u0007sDq!!:C\u0001\u0004\t9\u0007K\u0004C\u0003S\fIp!@-\t\u0005u(\u0011\u0001\u0015\b\u0005\n\u001d!q\u0002B\t\u0001")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private final int numBrokers;
    private final String lineSeparator = System.lineSeparator();
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Collection<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.numBrokers();
        String x$2 = this.zkConnectOrNull();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = true;
        boolean x$7 = true;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        boolean x$11 = true;
        boolean x$12 = false;
        boolean x$13 = false;
        boolean x$14 = false;
        int x$15 = 1;
        boolean x$16 = false;
        int x$17 = 0;
        boolean x$18 = false;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5, x$17, x$18).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private int numBrokers() {
        return this.numBrokers;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), 10000);
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_3 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
            return;
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreate(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaults(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultReplication(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultPartitions(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithConfigs(String quorum) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExists(String quorum) {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExistsWithIfNotExists(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithReplicaAssignment(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithInvalidReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativeReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativePartitionCount(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidTopicLevelConfig(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithIncludeList(String quorum) {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), topic1, this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), topic2, this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), topic3, this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_5 = null;
        Object var7_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(topic2), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains(topic3), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithExcludeInternal(String quorum) {
        String topic1 = "kafka.testTopic1";
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), topic1, this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), "__consumer_offsets", this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_3 = null;
        Object var5_4 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterPartitionCount(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignment(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterAssignment$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMoreAssignmentThanPartitions(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMorePartitionsThanAssignment(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWithInvalidPartitionCount(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        Object var4_3 = null;
        TopicCommand.TopicService topicService = new TopicCommand.TopicService(apply_adminClient);
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService.alterTopic(alterOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAlterTopicWithRackAware(String quorum) {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$3(this, alteredNumPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigPreservationAcrossPartitionAlteration(String quorum) {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        Config props = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)props.get(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)props.get(cleanupKey).value(), (String)"Properties after creation have incorrect value");
        if (!this.isKRaftTest()) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        }
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Config newProps = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)newProps.get(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)newProps.get(cleanupKey).value(), (String)"Updated properties have incorrect value");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.testTopicName(), 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicWithCollidingCharDeletionAndCreateAgain(String quorum) {
        String topicWithCollidingChar = "test.a";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", topicWithCollidingChar});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", topicWithCollidingChar});
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(topicWithCollidingChar);
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topicWithCollidingChar, 1, this.brokers());
        Assertions.assertDoesNotThrow(() -> this.createAndWaitTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteInternalTopic(String quorum) {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        if (!this.isKRaftTest()) {
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "__consumer_offsets", 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribe(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 2, 2, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_2 = null;
        Object var5_3 = null;
        String output = grabConsoleOutput_out.toString();
        Object[] rows = output.split(this.lineSeparator());
        Assertions.assertEquals((int)3, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append((String)rows[0]).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExist(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnavailablePartitions(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), this.numBrokers(), 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        try {
            TopicDescription testTopicDescription = (TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$13))).get()).partition();
            this.killBroker(0);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var12_7 = null;
            Object var13_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split(this.lineSeparator());
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitions(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 1, this.numBrokers(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                TestUtils$.MODULE$.waitForPartitionMetadata(this.aliveBrokers(), this.testTopicName(), 0, 15000L);
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split(this.lineSeparator());
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitions(String quorum) {
        Properties topicProps = new Properties();
        topicProps.setProperty("min.insync.replicas", Integer.toString(this.numBrokers()));
        Admin x$1 = this.adminClient();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        int x$5 = this.numBrokers();
        Map x$7 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, 1, x$5, (Map<Object, Seq<Object>>)x$7, topicProps);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(this)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var16_11 = null;
            Object var17_12 = null;
            String[] rows = grabConsoleOutput_out.toString().split(this.lineSeparator());
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress(String quorum) {
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.brokers().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$18)));
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).allTopicNames().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(firstPartition.replicas()).asScala().map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Reassignment didn't add the second node");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var18_11 = null;
        Object var19_12 = null;
        String simpleDescribeOutput = grabConsoleOutput_out.toString();
        Object[] simpleDescribeOutputRows = simpleDescribeOutput.split(this.lineSeparator());
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(simpleDescribeOutputRows[0]).toString());
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(simpleDescribeOutputRows)), (String)new StringBuilder(19).append("Unexpected output: ").append(simpleDescribeOutput).toString());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var21_16 = null;
        Object var22_17 = null;
        String underReplicatedOutput = grabConsoleOutput_out2.toString();
        Assertions.assertEquals((Object)"", (Object)underReplicatedOutput, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$20))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAtMinIsrPartitions(String quorum) {
        Properties topicProps = new Properties();
        topicProps.setProperty("min.insync.replicas", "4");
        Admin x$1 = this.adminClient();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        int x$5 = this.numBrokers();
        Map x$7 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, 1, x$5, (Map<Object, Seq<Object>>)x$7, topicProps);
        try {
            this.killBroker(0);
            this.killBroker(1);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$1(this)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var17_11 = null;
            Object var18_12 = null;
            String output = grabConsoleOutput_out.toString();
            String[] rows = output.split(this.lineSeparator());
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
            Assertions.assertEquals((int)1, (int)rows.length, (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitionsMixed(String quorum) {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        Properties topicProps = new Properties();
        topicProps.setProperty("min.insync.replicas", Integer.toString(this.numBrokers()));
        Admin x$1 = this.adminClient();
        Buffer<KafkaBroker> x$3 = this.brokers();
        int x$5 = this.numBrokers();
        Map x$7 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, underMinIsrTopic, x$3, 1, x$5, (Map<Object, Seq<Object>>)x$7, topicProps);
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), notUnderMinIsrTopic, this.brokers(), 1, this.numBrokers(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        Admin x$8 = this.adminClient();
        Buffer<KafkaBroker> x$10 = this.brokers();
        scala.collection.immutable.Map x$12 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}));
        int x$13 = 1;
        Properties x$14 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$8, offlineTopic, x$10, 1, x$13, (Map<Object, Seq<Object>>)x$12, x$14);
        Admin x$15 = this.adminClient();
        Buffer<KafkaBroker> x$17 = this.brokers();
        scala.collection.immutable.Map x$19 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        int x$20 = 1;
        Properties x$21 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$15, fullyReplicatedTopic, x$17, 1, x$20, (Map<Object, Seq<Object>>)x$19, x$21);
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(this, underMinIsrTopic, offlineTopic)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var30_24 = null;
            Object var31_25 = null;
            String output = grabConsoleOutput_out.toString();
            String[] rows = output.split(this.lineSeparator());
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[1]).toString());
            Assertions.assertEquals((int)2, (int)rows.length, (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeReportOverriddenConfigs(String quorum) {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAndListTopicsWithoutInternalTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized(String quorum) {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var7_2 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), this.testTopicName(), this.brokers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_3 = null;
        Object var5_4 = null;
        String output = grabConsoleOutput_out.toString();
        Object[] rows = output.split(this.lineSeparator());
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)), (String)new StringBuilder(19).append("Unexpected output: ").append(output).toString());
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append((String)rows[0]).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithTopicNameCollision(String quorum) {
        TestUtils$.MODULE$.createTopicWithAdmin(this.adminClient(), "foo_bar", this.brokers(), 1, this.numBrokers(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        Assertions.assertThrows(InvalidTopicException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "foo.bar"})));
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$2(TopicCommandIntegrationTest $this, KafkaBroker x$7) {
        return x$7.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$2($this, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testAlterPartitionCount$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$2(TopicCommandIntegrationTest $this, KafkaBroker x$8) {
        return x$8.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterAssignment$2($this, x$8)));
    }

    public static final /* synthetic */ String $anonfun$testAlterAssignment$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$4(TopicCommandIntegrationTest $this, int alteredNumPartitions$1, KafkaBroker x$11) {
        return x$11.metadataCache().getTopicPartitions($this.testTopicName()).size() == alteredNumPartitions$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$3(TopicCommandIntegrationTest $this, int alteredNumPartitions$1) {
        return $this.brokers().forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$4($this, alteredNumPartitions$1, x$11)));
    }

    public static final /* synthetic */ String $anonfun$testCreateAlterTopicWithRackAware$5() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$13) {
        return x$13.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaBroker x$14) {
        return x$14.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$15) {
        return x$15.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$16) {
        return x$16.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaBroker server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$15))).get()).partitions()).asScala().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$16)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (testPartitionMetadata instanceof Some) {
            MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
            return result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        }
        throw new MatchError((Object)testPartitionMetadata);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.brokers().filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$14)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$17) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$17.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 5;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$2($this, x$17)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaBroker x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$20) {
        return x$20.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$21) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$21.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 4;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$2($this, x$21)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeAtMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$2(TopicCommandIntegrationTest $this, String underMinIsrTopic$1, String offlineTopic$1, KafkaBroker broker) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(underMinIsrTopic$1, 0).get()).isr().size() < $this.numBrokers() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(offlineTopic$1, 0).get()).leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(TopicCommandIntegrationTest $this, String underMinIsrTopic$1, String offlineTopic$1) {
        return $this.aliveBrokers().forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$2($this, underMinIsrTopic$1, offlineTopic$1, broker)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitionsMixed$3() {
        return "Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic";
    }

    public TopicCommandIntegrationTest() {
        this.numPartitions = 1;
        this.numBrokers = 6;
    }
}

