/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.ZkAdminManager$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZkMigrationClient;
import kafka.zk.migration.ZkMigrationTestHarness;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\u0007\u000e\u0001QAQ!\u0007\u0001\u0005\u0002iAQ\u0001\b\u0001\u0005\u0002uAQa\u000f\u0001\u0005\u0002qBQa\u0013\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u0002qBQa\u0014\u0001\u0005\nACa!a\u0004\u0001\t\u0003a\u0004BBA\n\u0001\u0011\u0005A\b\u0003\u0004\u0002\u0018\u0001!\t\u0001\u0010\u0005\u0007\u00037\u0001A\u0011\u0001\u001f\t\r\u0005}\u0001\u0001\"\u0001=\u0005mQ6nQ8oM&<W*[4sCRLwN\\\"mS\u0016tG\u000fV3ti*\u0011abD\u0001\n[&<'/\u0019;j_:T!\u0001E\t\u0002\u0005i\\'\"\u0001\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0006\t\u0003-]i\u0011!D\u0005\u000315\u0011aCW6NS\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002\u0019I\fg\u000eZ8n\u0005V4g-\u001a:\u0015\u0007y9c\u0007E\u0002 E\u0011j\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003?\u0015J!A\n\u0011\u0003\t\tKH/\u001a\u0005\u0006Q\t\u0001\r!K\u0001\u0007e\u0006tGm\\7\u0011\u0005)\"T\"A\u0016\u000b\u00051j\u0013\u0001B;uS2T!AL\u0018\u0002\rM,'O^3s\u0015\t\u0011\u0002G\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b,\u0005)iunY6SC:$w.\u001c\u0005\u0006o\t\u0001\r\u0001O\u0001\u0007Y\u0016tw\r\u001e5\u0011\u0005}I\u0014B\u0001\u001e!\u0005\rIe\u000e^\u0001\u001bi\u0016\u001cH/T5he\u0006$\u0018n\u001c8Ce>\\WM]\"p]\u001aLwm\u001d\u000b\u0002{A\u0011qDP\u0005\u0003\u007f\u0001\u0012A!\u00168ji\"\u00121!\u0011\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000b1!\u00199j\u0015\t1u)A\u0004kkBLG/\u001a:\u000b\u0005!\u0013\u0014!\u00026v]&$\u0018B\u0001&D\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^'jOJ\fG/Z\"mS\u0016tG/U;pi\u0006\u001c\bF\u0001\u0003B\u0003u!Xm\u001d;Xe&$X-\u0012=jgRLgnZ\"mS\u0016tG/U;pi\u0006\u001c\bFA\u0003B\u0003e9(/\u001b;f\u00072LWM\u001c;Rk>$\u0018-\u00118e-\u0016\u0014\u0018NZ=\u0015\u0015ECflY3y\u0003\u000f\tY\u0001\u0005\u0002S-6\t1K\u0003\u0002\u000f)*\u0011QkL\u0001\t[\u0016$\u0018\rZ1uC&\u0011qk\u0015\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\u00063\u001a\u0001\rAW\u0001\u0010[&<'/\u0019;j_:\u001cE.[3oiB\u00111\fX\u0007\u0002\u001f%\u0011Ql\u0004\u0002\u00125.l\u0015n\u001a:bi&|gn\u00117jK:$\b\"B0\u0007\u0001\u0004\u0001\u0017!D1e[&t'l[\"mS\u0016tG\u000f\u0005\u0002\\C&\u0011!m\u0004\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\t\u000b\u00114\u0001\u0019A)\u0002\u001d5LwM]1uS>t7\u000b^1uK\")aM\u0002a\u0001O\u00061QM\u001c;jif\u0004B\u0001[6n[6\t\u0011N\u0003\u0002kA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051L'aA'baB\u0011a.\u001e\b\u0003_N\u0004\"\u0001\u001d\u0011\u000e\u0003ET!A]\n\u0002\rq\u0012xn\u001c;?\u0013\t!\b%\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;!\u0011\u0015Ih\u00011\u0001{\u0003\u0019\tXo\u001c;bgB!\u0001n[7|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0005!!.\u0019<b\u0013\r\t)! \u0002\u0007\t>,(\r\\3\t\r\u0005%a\u00011\u0001n\u00031Q8.\u00128uSRLH+\u001f9f\u0011\u0019\tiA\u0002a\u0001[\u0006a!p[#oi&$\u0018PT1nK\u0006AB/Z:u/JLG/\u001a(fo\u000ec\u0017.\u001a8u#V|G/Y:)\u0005\u001d\t\u0015\u0001\u0007;fgR<&/\u001b;f\u001d\u0016<Hk\u001c9jG\u000e{gNZ5hg\"\u0012\u0001\"Q\u0001\u001ei\u0016\u001cHo\u0016:ji\u0016,\u00050[:uS:<Gk\u001c9jG\u000e{gNZ5hg\"\u0012\u0011\"Q\u0001\ni\u0016\u001cHoU2sC6D#AC!\u0002EQ,7\u000f^*de\u0006l\u0017I\u001c3Rk>$\u0018m\u00115b]\u001e,7/\u00138T]\u0006\u00048\u000f[8uQ\tY\u0011\t")
public class ZkConfigMigrationClientTest
extends ZkMigrationTestHarness {
    public byte[] randomBuffer(MockRandom random, int length) {
        byte[] buf = new byte[length];
        random.nextBytes(buf);
        return buf;
    }

    @Test
    public void testMigrationBrokerConfigs() {
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "1");
        props.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.encoder().encode(new Password(this.SECRET())));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Broker(), "1", props);
        this.migrationClient().migrateBrokerConfigs(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)1, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)2, (int)((java.util.List)batches.get(0)).size());
        ((Iterable)batches.get(0)).forEach(record -> {
            ConfigRecord message = (ConfigRecord)record.message();
            String name = message.name();
            String value = message.value();
            Assertions.assertTrue((boolean)props.containsKey(name));
            String string = name;
            String string2 = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Assertions.assertEquals((Object)this.SECRET(), (Object)value);
                return;
            }
            Assertions.assertEquals((Object)props.getProperty(name), (Object)value);
        });
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        newProps.put(KafkaConfig$.MODULE$.SslKeystorePasswordProp(), this.NEW_SECRET());
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.BROKER, "1"), newProps, this.migrationState()));
        Properties actualPropsInZk = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), "1");
        Assertions.assertEquals((int)2, (int)actualPropsInZk.size());
        actualPropsInZk.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> {
            Object object = x0$1;
            String string = KafkaConfig$.MODULE$.SslKeystorePasswordProp();
            if (!(object != null ? !object.equals(string) : string != null)) {
                Assertions.assertEquals((Object)this.NEW_SECRET(), (Object)this.encoder().decode(x1$1.toString()).value());
                return;
            }
            Assertions.assertEquals(newProps.get(x0$1), (Object)x1$1);
        }));
        this.migrationState_$eq(this.migrationClient().configClient().deleteConfigs(new ConfigResource(ConfigResource.Type.BROKER, "1"), this.migrationState()));
        Assertions.assertEquals((int)0, (int)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), "1").size());
    }

    @Test
    public void testMigrateClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, "<default>", props, x$4);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = ConfigType$.MODULE$.User();
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, "user1", props, x$8);
        AdminZkClient qual$3 = this.adminZkClient();
        String x$9 = ConfigType$.MODULE$.User();
        boolean x$12 = qual$3.changeConfigs$default$4();
        qual$3.changeConfigs(x$9, "user1/clients/clientA", props, x$12);
        AdminZkClient qual$4 = this.adminZkClient();
        String x$13 = ConfigType$.MODULE$.User();
        boolean x$16 = qual$4.changeConfigs$default$4();
        qual$4.changeConfigs(x$13, "<default>/clients/<default>", props, x$16);
        AdminZkClient qual$5 = this.adminZkClient();
        String x$17 = ConfigType$.MODULE$.User();
        boolean x$20 = qual$5.changeConfigs$default$4();
        qual$5.changeConfigs(x$17, "<default>/clients/clientA", props, x$20);
        AdminZkClient qual$6 = this.adminZkClient();
        String x$21 = ConfigType$.MODULE$.Client();
        boolean x$24 = qual$6.changeConfigs$default$4();
        qual$6.changeConfigs(x$21, "<default>", props, x$24);
        AdminZkClient qual$7 = this.adminZkClient();
        String x$25 = ConfigType$.MODULE$.Client();
        boolean x$28 = qual$7.changeConfigs$default$4();
        qual$7.changeConfigs(x$25, "clientB", props, x$28);
        props.remove("producer_byte_rate");
        props.put("connection_creation_rate", "10");
        AdminZkClient qual$8 = this.adminZkClient();
        String x$29 = ConfigType$.MODULE$.Ip();
        boolean x$32 = qual$8.changeConfigs$default$4();
        qual$8.changeConfigs(x$29, "1.1.1.1", props, x$32);
        AdminZkClient qual$9 = this.adminZkClient();
        String x$33 = ConfigType$.MODULE$.Ip();
        boolean x$36 = qual$9.changeConfigs$default$4();
        qual$9.changeConfigs(x$33, "<default>", props, x$36);
        ArrayList batches = new ArrayList();
        this.migrationClient().migrateClientQuotas(batch -> batches.add(batch));
        Assertions.assertEquals((int)9, (int)batches.size());
        ClientQuotasDelta delta = new ClientQuotasDelta(ClientQuotasImage.EMPTY);
        RecordTestUtils.replayAllBatches((Object)delta, batches);
        ClientQuotasImage image = delta.apply();
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientB")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"1.1.1.1")}))).asJava())));
        Assertions.assertTrue((boolean)image.entities().containsKey(new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), (Object)"")}))).asJava())));
    }

    @Test
    public void testWriteExistingClientQuotas() {
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, "user1", props, x$4);
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = ConfigType$.MODULE$.User();
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, "user1/clients/clientA", props, x$8);
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.empty()), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)3, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user1")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), ConfigType$.MODULE$.User(), "user1"));
        Assertions.assertEquals((int)4, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), ConfigType$.MODULE$.User(), "<default>"));
        Assertions.assertEquals((int)5, (int)this.migrationState().migrationZkVersion());
    }

    private ZkMigrationLeadershipState writeClientQuotaAndVerify(ZkMigrationClient migrationClient, AdminZkClient adminZkClient, ZkMigrationLeadershipState migrationState, Map<String, String> entity, Map<String, Double> quotas, String zkEntityType, String zkEntityName) {
        ZkMigrationLeadershipState nextMigrationState = migrationClient.configClient().writeClientQuotas(CollectionConverters$.MODULE$.MapHasAsJava(entity).asJava(), CollectionConverters$.MODULE$.MapHasAsJava(quotas).asJava(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.empty()).asJava(), migrationState);
        Map newProps = ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(adminZkClient.fetchEntityConfig(zkEntityType, zkEntityName)).asScala());
        Assertions.assertEquals(quotas, (Object)newProps);
        return nextMigrationState;
    }

    @Test
    public void testWriteNewClientQuotas() {
        Assertions.assertEquals((int)0, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(20000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(100.0))}))), ConfigType$.MODULE$.User(), "user2"));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        this.migrationState_$eq(this.writeClientQuotaAndVerify(this.migrationClient(), this.adminZkClient(), this.migrationState(), (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"user2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"clientA")}))), (Map<String, Double>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)Predef$.MODULE$.double2Double(10000.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)Predef$.MODULE$.double2Double(200.0))}))), ConfigType$.MODULE$.User(), "user2/clients/clientA"));
        Assertions.assertEquals((int)2, (int)this.migrationState().migrationZkVersion());
    }

    @Test
    public void testWriteNewTopicConfigs() {
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testWriteExistingTopicConfigs() {
        Properties props = new Properties();
        props.put("flush.ms", "60000");
        props.put("retention.ms", "300000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), "test", props);
        this.migrationState_$eq(this.migrationClient().configClient().writeConfigs(new ConfigResource(ConfigResource.Type.TOPIC, "test"), Collections.singletonMap("segment.ms", "100000"), this.migrationState()));
        Assertions.assertEquals((int)1, (int)this.migrationState().migrationZkVersion());
        Properties newProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), "test");
        Assertions.assertEquals((int)1, (int)newProps.size());
        Assertions.assertEquals((Object)"100000", (Object)newProps.getProperty("segment.ms"));
    }

    @Test
    public void testScram() {
        MockRandom random = new MockRandom();
        ScramCredential scramCredential = new ScramCredential(this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), 4096);
        Properties props = new Properties();
        props.put("SCRAM-SHA-256", ScramCredentialUtils.credentialToString((ScramCredential)scramCredential));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$1, "alice", props, x$4);
        ArrayList brokers = new ArrayList();
        ArrayList batches = new ArrayList();
        this.migrationClient().readAllMetadata(batch -> batches.add(batch), brokerId -> brokers.add(brokerId));
        Assertions.assertEquals((int)0, (int)brokers.size());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertEquals((int)1, (int)((java.util.List)batches.get(0)).size());
    }

    @Test
    public void testScramAndQuotaChangesInSnapshot() {
        MockRandom random = new MockRandom();
        Properties props = new Properties();
        props.put("producer_byte_rate", "100000");
        AdminZkClient qual$1 = this.adminZkClient();
        String x$12 = ConfigType$.MODULE$.User();
        boolean x$4 = qual$1.changeConfigs$default$4();
        qual$1.changeConfigs(x$12, "user1", props, x$4);
        ScramCredential aliceScramCredential = new ScramCredential(this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), this.randomBuffer(random, 1024), 4096);
        Properties alicePropsInit = new Properties();
        alicePropsInit.put("SCRAM-SHA-256", ScramCredentialUtils.credentialToString((ScramCredential)aliceScramCredential));
        AdminZkClient qual$2 = this.adminZkClient();
        String x$5 = ConfigType$.MODULE$.User();
        boolean x$8 = qual$2.changeConfigs$default$4();
        qual$2.changeConfigs(x$5, "alice", alicePropsInit, x$8);
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY);
        ClientQuotaRecord.EntityData entityData = new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("user2");
        ClientQuotaRecord clientQuotaRecord = new ClientQuotaRecord().setEntity(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)entityData, (List)Nil$.MODULE$)).asJava()).setKey("request_percentage").setValue(58.58).setRemove(false);
        delta.replay(clientQuotaRecord);
        UserScramCredentialRecord scramCredentialRecord = new UserScramCredentialRecord().setName("george").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setSalt(this.randomBuffer(random, 1024)).setStoredKey(this.randomBuffer(random, 1024)).setServerKey(this.randomBuffer(random, 1024)).setIterations(8192);
        delta.replay(scramCredentialRecord);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        new KRaftMigrationZkWriter((MigrationClient)this.migrationClient()).handleSnapshot(image, (x$1, x$2, operation) -> this.migrationState_$eq(operation.apply(this.migrationState())));
        Properties user1Props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user1");
        Assertions.assertEquals((int)0, (int)user1Props.size());
        Properties user2Props = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "user2");
        Assertions.assertEquals((int)1, (int)user2Props.size());
        Properties georgeProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "george");
        Assertions.assertEquals((int)1, (int)georgeProps.size());
        Properties aliceProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.User(), "alice");
        Assertions.assertEquals((int)0, (int)aliceProps.size());
    }
}

