/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.server.AddPartitionsToTxnRequestServerTest$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAqA\b\u0001C\u0002\u0013%q\u0004\u0003\u0004)\u0001\u0001\u0006I\u0001\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\t\u0004\u0001)A\u0005W!)!\u0007\u0001C!g!)q\b\u0001C!\u0001\")1\u000b\u0001C\u0001)\")1\u0010\u0001C\u0001y\"1\u00111\u0001\u0001\u0005\u0002qDq!a\u0002\u0001\t\u0013\tIaB\u0004\u0002bEA\t!a\u0019\u0007\rA\t\u0002\u0012AA3\u0011\u0019YR\u0002\"\u0001\u0002n!1!/\u0004C\u0001\u0003_\u00121%\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]J+\u0017/^3tiN+'O^3s)\u0016\u001cHO\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011#\u0003\u0002\u001b#\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t1\fgn\u001a\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0004TiJLgnZ\u0001\bi>\u0004\u0018nY\u0019!\u00035qW/\u001c)beRLG/[8ogV\t1\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0002J]R\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011Ag\u000e\t\u0003YUJ!AN\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006q\u0019\u0001\r!O\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f%\u0003\u0011)H/\u001b7\n\u0005yZ$A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR\u0011A'\u0011\u0005\u0006\u0005\u001e\u0001\raQ\u0001\ti\u0016\u001cH/\u00138g_B\u0011A)T\u0007\u0002\u000b*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u001dQW\u000f]5uKJT!AS&\u0002\u000b),h.\u001b;\u000b\u00031\u000b1a\u001c:h\u0013\tqUI\u0001\u0005UKN$\u0018J\u001c4pQ\t9\u0001\u000b\u0005\u0002E#&\u0011!+\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001P:i_VdGMU3dK&4Xm\u00149fe\u0006$\u0018n\u001c8O_R\fE\u000f^3naR,Gm\u00165f]>#\b.\u001a:QCJ$\u0018\u000e^5p]\"\u000b7/\u0012:s_J$2\u0001N+b\u0011\u00151\u0006\u00021\u0001X\u0003\u0019\tXo\u001c:v[B\u0011\u0001l\u0018\b\u00033v\u0003\"AW\u0017\u000e\u0003mS!\u0001X\u000b\u0002\rq\u0012xn\u001c;?\u0013\tqV&\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\u0001T!AX\u0017\t\u000b\tD\u0001\u0019A2\u0002\u000fY,'o]5p]B\u0011A\u0006Z\u0005\u0003K6\u0012Qa\u00155peRDC\u0001C4paB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\taJ|g/\u001b3fe*\u0011AnR\u0001\u0007a\u0006\u0014\u0018-\\:\n\u00059L'\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A9\"\u0003I\f!\u0002]1sC6,G/\u001a:tQ\u0011AA\u000f_=\u0011\u0005U4X\"A6\n\u0005]\\'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005Q\u0018\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u00061C/Z:u\u001f:,7+^2dKN\u001cxJ\\3FeJ|'/\u00138CCR\u001c\u0007.\u001a3SKF,Xm\u001d;\u0015\u0003QB#!\u0003@\u0011\u0005\u0011{\u0018bAA\u0001\u000b\n!A+Z:u\u00039!Xm\u001d;WKJLg-_(oYfD#A\u0003@\u0002#M,G/\u00169Ue\u0006t7/Y2uS>t7\u000f\u0006\u0005\u0002\f\u0005\u0005\u0013QIA(!\u0019a\u0013QB\u0016\u0002\u0012%\u0019\u0011qB\u0017\u0003\rQ+\b\u000f\\33!\u0011\t\u0019\"a\u000f\u000f\t\u0005U\u0011Q\u0007\b\u0005\u0003/\tyC\u0004\u0003\u0002\u001a\u0005%b\u0002BA\u000e\u0003KqA!!\b\u0002\"9\u0019!,a\b\n\u00031K1!a\tL\u0003\u0019\t\u0007/Y2iK&\u0019A#a\n\u000b\u0007\u0005\r2*\u0003\u0003\u0002,\u00055\u0012AB2p[6|gNC\u0002\u0015\u0003OIA!!\r\u00024\u00059Q.Z:tC\u001e,'\u0002BA\u0016\u0003[IA!a\u000e\u0002:\u0005i\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0003\u00022\u0005M\u0012\u0002BA\u001f\u0003\u007f\u0011Q$\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]R\u0013\u0018M\\:bGRLwN\u001c\u0006\u0005\u0003o\tI\u0004\u0003\u0004\u0002D-\u0001\raV\u0001\u0010iJ\fgn]1di&|g.\u00197JI\"9\u0011qI\u0006A\u0002\u0005%\u0013A\u0003<fe&4\u0017p\u00148msB\u0019A&a\u0013\n\u0007\u00055SFA\u0004C_>dW-\u00198\t\u000f\u0005E3\u00021\u0001\u0002T\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000ba\u000b)&!\u0017\n\u0007\u0005]\u0003MA\u0002TKR\u0004B!a\u0017\u0002^5\u0011\u00111G\u0005\u0005\u0003?\n\u0019D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002G\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fcV,7\u000f^*feZ,'\u000fV3tiB\u0011\u0001$D\n\u0004\u001b\u0005\u001d\u0004c\u0001\u0017\u0002j%\u0019\u00111N\u0017\u0003\r\u0005s\u0017PU3g)\t\t\u0019'\u0006\u0002\u0002rA1\u00111OA=\u0003{j!!!\u001e\u000b\u0007\u0005]4(\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003w\n)H\u0001\u0004TiJ,\u0017-\u001c\t\u0004Q\u0006}\u0014bAAAS\nI\u0011I]4v[\u0016tGo\u001d")
public class AddPartitionsToTxnRequestServerTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    public static Stream<Arguments> parameters() {
        return AddPartitionsToTxnRequestServerTest$.MODULE$.parameters();
    }

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.UnstableApiVersionsEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic1(), this.numPartitions(), this.brokers().size(), new Properties(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @MethodSource(value={"parameters"})
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError(String quorum, short version) {
        AddPartitionsToTxnRequest addPartitionsToTxnRequest;
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        if (version < 4) {
            addPartitionsToTxnRequest = AddPartitionsToTxnRequest.Builder.forClient((String)transactionalId, (long)producerId, (short)producerEpoch, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)createdTopicPartition, (List)new .colon.colon((Object)nonExistentTopic, (List)Nil$.MODULE$))).asJava()).build(version);
        } else {
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
            topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(createdTopicPartition.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(createdTopicPartition.partition()))));
            topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(nonExistentTopic.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(nonExistentTopic.partition()))));
            AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
            transactions.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setVerifyOnly(false).setTopics(topics));
            addPartitionsToTxnRequest = AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build(version);
        }
        AddPartitionsToTxnRequest request = addPartitionsToTxnRequest;
        int leaderId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        java.util.Map errors = version < 4 ? (java.util.Map)response.errors().get("") : (java.util.Map)response.errors().get(transactionalId);
        Assertions.assertEquals((int)2, (int)errors.size());
        Assertions.assertTrue((boolean)errors.containsKey(createdTopicPartition));
        Assertions.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, errors.get(createdTopicPartition));
        Assertions.assertTrue((boolean)errors.containsKey(nonExistentTopic));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, errors.get(nonExistentTopic));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOneSuccessOneErrorInBatchedRequest() {
        void var9_8;
        void var10_9;
        TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
        String transactionalId1 = "foobar";
        String transactionalId2 = "barfoo";
        long producerId2 = 1000L;
        short producerEpoch2 = 0;
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection txn2Topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
        txn2Topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(tp0.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(tp0.partition()))));
        Tuple2<Object, AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction> tuple2 = this.setUpTransactions(transactionalId1, false, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0}))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int coordinatorId = tuple2._1$mcI$sp();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction txn1 = (AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction)tuple2._2();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
        transactions.add((ImplicitLinkedHashCollection.Element)var10_9);
        transactions.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId2).setProducerId(producerId2).setProducerEpoch(producerEpoch2).setVerifyOnly(false).setTopics(txn2Topics));
        AddPartitionsToTxnRequest request = (AddPartitionsToTxnRequest)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build();
        java.util.Map errors = ((AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer((int)var9_8), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).errors();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionalId1), Collections.singletonMap(tp0, Errors.NONE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionalId2), Collections.singletonMap(tp0, Errors.INVALID_PRODUCER_ID_MAPPING))}))).asJava(), (Object)errors);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testVerifyOnly() {
        void var4_4;
        void var5_5;
        TopicPartition tp0 = new TopicPartition(this.topic1(), 0);
        String transactionalId = "foobar";
        Tuple2<Object, AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction> tuple2 = this.setUpTransactions(transactionalId, true, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0}))));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int coordinatorId = tuple2._1$mcI$sp();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction txn = (AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction)tuple2._2();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection transactions = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection();
        transactions.add((ImplicitLinkedHashCollection.Element)var5_5);
        AddPartitionsToTxnRequest verifyRequest = (AddPartitionsToTxnRequest)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)transactions).build();
        java.util.Map verifyErrors = ((AddPartitionsToTxnResponse)this.connectAndReceive((AbstractRequest)verifyRequest, this.brokerSocketServer((int)var4_4), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AddPartitionsToTxnResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).errors();
        Assertions.assertEquals(Collections.singletonMap(transactionalId, Collections.singletonMap(tp0, Errors.INVALID_TXN_STATE)), (Object)verifyErrors);
    }

    private Tuple2<Object, AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction> setUpTransactions(String transactionalId, boolean verifyOnly, Set<TopicPartition> partitions) {
        FindCoordinatorRequest findCoordinatorRequest = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKey(transactionalId).setKeyType(FindCoordinatorRequest.CoordinatorType.TRANSACTION.id())).build();
        this.connectAndReceive((AbstractRequest)findCoordinatorRequest, this.brokerSocketServer(((KafkaBroker)this.brokers().head()).config().brokerId()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.brokers(), "__transaction_state", 50);
        int coordinatorId = ((FindCoordinatorResponseData.Coordinator)((FindCoordinatorResponse)this.connectAndReceive((AbstractRequest)findCoordinatorRequest, this.brokerSocketServer(((KafkaBroker)this.brokers().head()).config().brokerId()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).data().coordinators().get(0)).nodeId();
        InitProducerIdRequest initPidRequest = (InitProducerIdRequest)new InitProducerIdRequest.Builder(new InitProducerIdRequestData().setTransactionalId(transactionalId).setTransactionTimeoutMs(10000)).build();
        InitProducerIdResponse initPidResponse = (InitProducerIdResponse)this.connectAndReceive((AbstractRequest)initPidRequest, this.brokerSocketServer(coordinatorId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitProducerIdResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        long producerId1 = initPidResponse.data().producerId();
        short producerEpoch1 = initPidResponse.data().producerEpoch();
        AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection txn1Topics = new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection();
        partitions.foreach((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)txn1Topics.add((ImplicitLinkedHashCollection.Element)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(tp.topic()).setPartitions(Collections.singletonList(Predef$.MODULE$.int2Integer(tp.partition()))))));
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorId), (Object)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId1).setProducerEpoch(producerEpoch1).setVerifyOnly(verifyOnly).setTopics(txn1Topics));
    }

    public AddPartitionsToTxnRequestServerTest() {
        this.topic1 = "topic1";
        this.numPartitions = 1;
    }
}

