/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.ZkAdminManager$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\t\u0013\u0001eA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!)Q\b\u0001C\u0001}!91\t\u0001b\u0001\n\u0003!\u0005B\u0002%\u0001A\u0003%Q\tC\u0003J\u0001\u0011%!\nC\u0003[\u0001\u0011%1\fC\u0003^\u0001\u0011%a\fC\u0003w\u0001\u0011\u0005s\u000fC\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA%\u0001\u0011\u0005\u00131\n\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!!$\u0001\t\u0013\tyIA\f[W\u000e{gNZ5h\u001b&<'/\u0019;j_:\u001cE.[3oi*\u00111\u0003F\u0001\n[&<'/\u0019;j_:T!!\u0006\f\u0002\u0005i\\'\"A\f\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0007\u0012/!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u00142kK\u000e$\bCA\u0012-\u001b\u0005!#BA\n&\u0015\t1s%\u0001\u0005nKR\fG-\u0019;b\u0015\t9\u0002F\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017%\u0005U\u0019uN\u001c4jO6KwM]1uS>t7\t\\5f]R\u0004\"a\f\u001a\u000e\u0003AR!!\r\f\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0002$a\u0002'pO\u001eLgnZ\u0001\tu.\u001cE.[3oiB\u0011agN\u0007\u0002)%\u0011\u0001\b\u0006\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u001fA\f7o]<pe\u0012,enY8eKJ\u0004\"aL\u001e\n\u0005q\u0002$a\u0004)bgN<xN\u001d3F]\u000e|G-\u001a:\u0002\rqJg.\u001b;?)\ry\u0014I\u0011\t\u0003\u0001\u0002i\u0011A\u0005\u0005\u0006i\r\u0001\r!\u000e\u0005\u0006s\r\u0001\rAO\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0016\u0003\u0015\u0003\"A\u000e$\n\u0005\u001d#\"!D!e[&t'l[\"mS\u0016tG/\u0001\bbI6LgNW6DY&,g\u000e\u001e\u0011\u0002!\u0019\u0014x.\u001c.l\u000b:$\u0018\u000e^=OC6,GCA&Y!\taUK\u0004\u0002N'B\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bG\u0001\u0007yI|w\u000e\u001e \u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)FCQ!\u0017\u0004A\u0002-\u000b!\"\u001a8uSRLh*Y7f\u00039!xNW6F]RLG/\u001f(b[\u0016$\"a\u0013/\t\u000be;\u0001\u0019A&\u0002\u001f\t,\u0018\u000e\u001c3F]RLG/\u001f#bi\u0006$2aX:v!\t\u0001\u0007O\u0004\u0002b[:\u0011!m\u001b\b\u0003G&t!\u0001\u001a5\u000f\u0005\u0015<gB\u0001(g\u0013\u0005Y\u0013BA\u0015+\u0013\t9\u0002&\u0003\u0002kO\u000511m\\7n_:L!A\n7\u000b\u0005)<\u0013B\u00018p\u0003E\u0019E.[3oiF+x\u000e^1SK\u000e|'\u000f\u001a\u0006\u0003M1L!!\u001d:\u0003\u0015\u0015sG/\u001b;z\t\u0006$\u0018M\u0003\u0002o_\")A\u000f\u0003a\u0001\u0017\u0006QQM\u001c;jif$\u0016\u0010]3\t\u000beC\u0001\u0019A&\u0002'%$XM]1uK\u000ec\u0017.\u001a8u#V|G/Y:\u0015\u0005ad\bCA={\u001b\u0005\t\u0016BA>R\u0005\u0011)f.\u001b;\t\u000buL\u0001\u0019\u0001@\u0002\u000fYL7/\u001b;peB\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\b\u0005\u0003\u0007\t9AD\u0002d\u0003\u000bI!AJ\u0014\n\u0005M)\u0013bAA\u0006I\u0005)2i\u001c8gS\u001el\u0015n\u001a:bi&|gn\u00117jK:$\u0018\u0002BA\b\u0003#\u0011!c\u00117jK:$\u0018+^8uCZK7/\u001b;pe*\u0019\u00111\u0002\u0013\u0002)%$XM]1uK\n\u0013xn[3s\u0007>tg-[4t)\rA\u0018q\u0003\u0005\b\u00033Q\u0001\u0019AA\u000e\u00039\u0019wN\u001c4jO\u000e{gn];nKJ\u0004r!!\b\u0002(-\u000bY#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003!1WO\\2uS>t'bAA\u0013=\u0005!Q\u000f^5m\u0013\u0011\tI#a\b\u0003\u0015\tK7i\u001c8tk6,'\u000f\u0005\u0004\u0002.\u0005=2jS\u0007\u0003\u0003GIA!!\r\u0002$\t\u0019Q*\u00199\u0002'%$XM]1uKR{\u0007/[2D_:4\u0017nZ:\u0015\u0007a\f9\u0004C\u0004\u0002\u001a-\u0001\r!a\u0007\u0002!I,\u0017\r\u001a+pa&\u001c7i\u001c8gS\u001e\u001cH#\u0002=\u0002>\u0005\u0005\u0003BBA \u0019\u0001\u00071*A\u0005u_BL7MT1nK\"9\u0011\u0011\u0004\u0007A\u0002\u0005\r\u0003CBA\u000f\u0003\u000b\nY#\u0003\u0003\u0002H\u0005}!\u0001C\"p]N,X.\u001a:\u0002\u0019]\u0014\u0018\u000e^3D_:4\u0017nZ:\u0015\u0011\u00055\u00131KA2\u0003O\u00022aIA(\u0013\r\t\t\u0006\n\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\b\u0003+j\u0001\u0019AA,\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;b\u0017AB2p]\u001aLw-\u0003\u0003\u0002b\u0005m#AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0005\b\u0003Kj\u0001\u0019AA\u0016\u0003%\u0019wN\u001c4jO6\u000b\u0007\u000fC\u0004\u0002j5\u0001\r!!\u0014\u0002\u000bM$\u0018\r^3\u0002\u001b\u0011,G.\u001a;f\u0007>tg-[4t)\u0019\ti%a\u001c\u0002r!9\u0011Q\u000b\bA\u0002\u0005]\u0003bBA5\u001d\u0001\u0007\u0011QJ\u0001\u0012oJLG/Z\"mS\u0016tG/U;pi\u0006\u001cHCCA'\u0003o\nY(a\"\u0002\f\"9\u0011\u0011P\bA\u0002\u0005-\u0012AB3oi&$\u0018\u0010C\u0004\u0002~=\u0001\r!a \u0002\rE,x\u000e^1t!\u001d\ti#a\fL\u0003\u0003\u00032aGAB\u0013\r\t)\t\b\u0002\u0007\t>,(\r\\3\t\u000f\u0005%u\u00021\u0001\u0002,\u0005)1o\u0019:b[\"9\u0011\u0011N\bA\u0002\u00055\u0013\u0001\u0006;ss^\u0013\u0018\u000e^3F]RLG/_\"p]\u001aLw\r\u0006\u0007\u0002\u0012\u0006]\u0015\u0011TAO\u0003O\u000b\t\fE\u0003z\u0003'\u000bi%C\u0002\u0002\u0016F\u0013aa\u00149uS>t\u0007\"\u0002;\u0011\u0001\u0004Y\u0005BBAN!\u0001\u00071*\u0001\u0003qCRD\u0007bBAP!\u0001\u0007\u0011\u0011U\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003[\t\u0019+\u0003\u0003\u0002&\u0006\r\"A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\u0016\tA\u0002\u0005-\u0016AB2sK\u0006$X\rE\u0002z\u0003[K1!a,R\u0005\u001d\u0011un\u001c7fC:Dq!!\u001b\u0011\u0001\u0004\ti\u0005")
public class ZkConfigMigrationClient
implements ConfigMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final PasswordEncoder passwordEncoder;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String fromZkEntityName(String entityName) {
        if (entityName.equals(ConfigEntityName$.MODULE$.Default())) {
            return "";
        }
        return entityName;
    }

    private String toZkEntityName(String entityName) {
        if (entityName.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        return entityName;
    }

    private ClientQuotaRecord.EntityData buildEntityData(String entityType, String entityName) {
        return new ClientQuotaRecord.EntityData().setEntityType(entityType).setEntityName(this.fromZkEntityName(entityName));
    }

    public void iterateClientQuotas(ConfigMigrationClient.ClientQuotaVisitor visitor) {
        this.migrateEntityType$1(ConfigType$.MODULE$.User(), "user", visitor);
        this.migrateEntityType$1(ConfigType$.MODULE$.Client(), "client-id", visitor);
        this.adminZkClient().fetchAllChildEntityConfigs(ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$7(this, visitor, x0$1);
            return BoxedUnit.UNIT;
        });
        this.migrateEntityType$1(ConfigType$.MODULE$.Ip(), "ip", visitor);
    }

    public void iterateBrokerConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Broker());
        this.zkClient.getEntitiesConfigs(ConfigType$.MODULE$.Broker(), (Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateBrokerConfigs$1(this, configConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void iterateTopicConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        this.zkClient.getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).foreach((Function1 & Serializable)topic -> {
            this.readTopicConfigs(topic, props -> configConsumer.accept(topic, props));
            return BoxedUnit.UNIT;
        });
    }

    public void readTopicConfigs(String topicName, Consumer<java.util.Map<String, String>> configConsumer) {
        String topicResource = this.fromZkEntityName(topicName);
        Properties props = this.zkClient.getEntityConfigs(ConfigType$.MODULE$.Topic(), topicResource);
        java.util.Map decodedProps = CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        String logAndRethrow_msg = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(topicResource).append(".").toString();
        try {
            configConsumer.accept(decodedProps);
        }
        catch (Throwable logAndRethrow_e) {
            this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource configResource, java.util.Map<String, String> configMap, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$writeConfigs$1(this, configResource, configMap, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteConfigs(ConfigResource configResource, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$deleteConfigs$1(this, configResource, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, java.util.Map<String, String> scram, ZkMigrationLeadershipState state) {
        Object object = new Object();
        try {
            ZkMigrationLeadershipState zkMigrationLeadershipState;
            try {
                zkMigrationLeadershipState = ZkConfigMigrationClient.$anonfun$writeClientQuotas$1(this, entity, object, state, quotas, scram);
            }
            catch (Throwable throwable) {
                if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                    throw throwable;
                }
                if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                    throw new MigrationClientAuthException(throwable);
                }
                if (throwable instanceof KeeperException) {
                    KeeperException keeperException = (KeeperException)throwable;
                    throw new MigrationClientException((Throwable)keeperException);
                }
                throw throwable;
            }
            return zkMigrationLeadershipState;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ZkMigrationLeadershipState)ex.value();
            }
            throw ex;
        }
    }

    private Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$tryWriteEntityConfig$1(this, props, create, entityType, path, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$iterateClientQuotas$2(ScramMechanism x$1) {
        ScramMechanism scramMechanism = x$1;
        ScramMechanism scramMechanism2 = ScramMechanism.UNKNOWN;
        return scramMechanism == null ? scramMechanism2 != null : !scramMechanism.equals(scramMechanism2);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$4(ConfigMigrationClient.ClientQuotaVisitor visitor$1, String name$1, ScramMechanism mechanism$1, ScramCredential scramCredentials$1) {
        visitor$1.visitScramCredential(name$1, mechanism$1, scramCredentials$1);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$6(ConfigMigrationClient.ClientQuotaVisitor visitor$1, java.util.List entity$1, java.util.Map quotaMap$1) {
        visitor$1.visitClientQuota(entity$1, quotaMap$1);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$1(ZkConfigMigrationClient $this, String entityType$1, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            java.util.List entity = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)$this.buildEntityData(entityType$1, name), (List)Nil$.MODULE$)).asJava();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkConfigMigrationClient.$anonfun$iterateClientQuotas$2(x$1)))), (Function1 & Serializable)mechanism -> {
                String propertyValue = props.getProperty(mechanism.mechanismName());
                if (propertyValue != null) {
                    ScramCredential scramCredentials = ScramCredentialUtils.credentialFromString((String)propertyValue);
                    String logAndRethrow_msg = new StringBuilder(62).append("Error in client quota visitor for SCRAM credential. User was ").append(entity).append(".").toString();
                    try {
                        visitor$1.visitScramCredential(name, mechanism, scramCredentials);
                    }
                    catch (Throwable logAndRethrow_e) {
                        $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                        throw logAndRethrow_e;
                    }
                    Object var8_8 = null;
                    return props.remove(mechanism.mechanismName());
                }
                return BoxedUnit.UNIT;
            });
            java.util.Map quotaMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala()).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    double value = x0$2._2$mcD$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            if (!quotaMap.isEmpty()) {
                String logAndRethrow_msg = new StringBuilder(43).append("Error in client quota visitor. Entity was ").append(entity).append(".").toString();
                try {
                    visitor$1.visitClientQuota(entity, quotaMap);
                }
                catch (Throwable logAndRethrow_e) {
                    $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                    throw logAndRethrow_e;
                }
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void migrateEntityType$1(String zkEntityType, String entityType, ConfigMigrationClient.ClientQuotaVisitor visitor$1) {
        this.adminZkClient().fetchAllEntityConfigs(zkEntityType).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$1(this, entityType, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$7(ZkConfigMigrationClient $this, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        block4: {
            Object[] components;
            Properties props;
            block6: {
                String name;
                block5: {
                    if (x0$1 == null) break block4;
                    name = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = name.split("/");
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(components)) != 3) break block5;
                    Object object = components[1];
                    String string = "clients";
                    if (object != null && object.equals(string)) break block6;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(name).toString());
            }
            .colon.colon entity = new .colon.colon((Object)$this.buildEntityData("user", (String)components[0]), (List)new .colon.colon((Object)$this.buildEntityData("client-id", (String)components[2]), (List)Nil$.MODULE$));
            java.util.Map quotaMap = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Double d;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    try {
                        d = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                    }
                    Double doubleValue = d;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)doubleValue);
                }
                throw new MatchError(null);
            })).asJava();
            String logAndRethrow_msg = new StringBuilder(50).append("Error in client quota entity visitor. Entity was ").append(entity).append(".").toString();
            try {
                visitor$1.visitClientQuota(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)entity)).asJava(), quotaMap);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$3(BiConsumer configConsumer$1, String brokerResource$1, java.util.Map decodedProps$1) {
        configConsumer$1.accept(brokerResource$1, decodedProps$1);
    }

    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$1(ZkConfigMigrationClient $this, BiConsumer configConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String brokerResource = $this.fromZkEntityName(broker);
            java.util.Map decodedProps = CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String logAndRethrow_msg = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append(brokerResource).append(".").toString();
            try {
                configConsumer$1.accept(brokerResource, decodedProps);
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$readTopicConfigs$2(Consumer configConsumer$3, java.util.Map decodedProps$2) {
        configConsumer$3.accept(decodedProps$2);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$1, java.util.Map configMap$1, ZkMigrationLeadershipState state$1) {
        ConfigResource.Type type = configResource$1.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : None$.MODULE$);
        String configName = $this.toZkEntityName(configResource$1.name());
        if (configType.isDefined()) {
            Properties props = new Properties();
            configMap$1.forEach((x0$1, x1$1) -> {
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig((String)x0$1)) {
                    props.put(x0$1, $this.passwordEncoder.encode(new Password(x1$1)));
                    return;
                }
                props.put(x0$1, x1$1);
            });
            Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType.get(), configName, props, false, state$1);
            if (option instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)configType.get());
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(configResource$1).append(" configs a second time.").toString());
                byte[] x$3 = $this.zkClient.createRecursive$default$2();
                $this.zkClient.createRecursive(createPath, x$3, false);
                Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType.get(), configName, props, true, state$1);
                if (option2 instanceof Some) {
                    return (ZkMigrationLeadershipState)((Some)option2).value();
                }
                if (None$.MODULE$.equals(option2)) {
                    throw new MigrationClientException(new StringBuilder(80).append("Could not write ").append(configType.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$1).append(" since it is not a Broker or Topic entity.").toString());
        return state$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$2, ZkMigrationLeadershipState state$2) {
        ConfigResource.Type type = configResource$2.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)ConfigType$.MODULE$.Broker()) : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)ConfigType$.MODULE$.Topic()) : None$.MODULE$);
        String configName = $this.toZkEntityName(configResource$2.name());
        if (configType.isDefined()) {
            void var10_10;
            String path = ConfigEntityZNode$.MODULE$.path((String)configType.get(), configName);
            .colon.colon requests = new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
            Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$2);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int migrationZkVersion = tuple2._1$mcI$sp();
            Seq responses = (Seq)tuple2._2();
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Did not delete ").append(configResource$2).append(" since the node did not exist.").toString());
                return state$2;
            }
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
                void var9_9;
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(configType).append("/").append(configName).toString());
                return state$2.withMigrationZkVersion((int)var9_9);
            }
            throw KeeperException.create((KeeperException.Code)((DeleteResponse)var10_10.head()).resultCode(), (String)path);
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$2).append(" since it is not a Broker or Topic entity.").toString());
        return state$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeClientQuotas$1(ZkConfigMigrationClient $this, java.util.Map entity$3, Object nonLocalReturnKey1$1, ZkMigrationLeadershipState state$3, java.util.Map quotas$1, java.util.Map scram$1) {
        void var11_13;
        void var12_14;
        java.util.Map<String, ConfigDef.ConfigKey> map;
        Option option;
        Some some;
        scala.collection.mutable.Map entityMap = CollectionConverters$.MODULE$.MapHasAsScala(entity$3).asScala();
        Option user = entityMap.get((Object)"user").map((Function1 & Serializable)entityName -> $this.toZkEntityName((String)entityName));
        Option client = entityMap.get((Object)"client-id").map((Function1 & Serializable)entityName -> $this.toZkEntityName((String)entityName));
        Option ip = entityMap.get((Object)"ip").map((Function1 & Serializable)entityName -> $this.toZkEntityName((String)entityName));
        Properties props = new Properties();
        if (user.isDefined() && client.isEmpty()) {
            some = new Some((Object)ConfigType$.MODULE$.User());
            option = user;
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (user.isDefined() && client.isDefined()) {
            some = new Some((Object)ConfigType$.MODULE$.User());
            option = new Some((Object)new StringBuilder(9).append(user.get()).append("/clients/").append(client.get()).toString());
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (client.isDefined()) {
            some = new Some((Object)ConfigType$.MODULE$.Client());
            option = client;
            map = DynamicConfig$Client$.MODULE$.configKeys();
        } else if (ip.isDefined()) {
            some = new Some((Object)ConfigType$.MODULE$.Ip());
            option = ip;
            map = DynamicConfig$Ip$.MODULE$.configKeys();
        } else {
            some = None$.MODULE$;
            option = None$.MODULE$;
            map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }
        java.util.Map<String, ConfigDef.ConfigKey> map2 = map;
        Option option2 = option;
        Option configType = (Option)some;
        Option path = option2;
        if (var12_14.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity$3).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)state$3);
        }
        quotas$1.forEach((x0$1, x1$1) -> {
            ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)map2.get(x0$1);
            if (configKey == null) {
                throw new MigrationClientException(new StringBuilder(26).append("Invalid configuration key ").append((String)x0$1).toString());
            }
            ConfigDef.Type type = configKey.type;
            if (ConfigDef.Type.DOUBLE.equals(type)) {
                props.setProperty((String)x0$1, x1$1.toString());
                return;
            }
            if (ConfigDef.Type.LONG.equals(type) ? true : ConfigDef.Type.INT.equals(type)) {
                long intValue;
                double epsilon = 1.0E-6;
                ConfigDef.Type type2 = configKey.type;
                ConfigDef.Type type3 = ConfigDef.Type.LONG;
                long l = !(type2 != null ? !type2.equals(type3) : type3 != null) ? (long)(Predef$.MODULE$.Double2double(x1$1) + epsilon) : (intValue = (long)((int)(Predef$.MODULE$.Double2double(x1$1) + epsilon)));
                if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((double)intValue - Predef$.MODULE$.Double2double(x1$1))) > epsilon) {
                    throw new InvalidRequestException(new StringBuilder(31).append("Configuration ").append((String)x0$1).append(" must be a ").append(configKey.type).append(" value").toString());
                }
                props.setProperty((String)x0$1, Long.toString(intValue));
                return;
            }
            throw new MigrationClientException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
        });
        scram$1.forEach((x0$2, x1$2) -> props.put(x0$2, x1$2));
        Option<ZkMigrationLeadershipState> option3 = $this.tryWriteEntityConfig((String)var11_13.get(), (String)var12_14.get(), props, false, state$3);
        if (option3 instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option3).value();
        }
        if (None$.MODULE$.equals(option3)) {
            String createPath = user.isDefined() && client.isDefined() ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)var11_13.get())).append("/").append(user.get()).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)var11_13.get());
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(createPath, x$3, false);
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity$3).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option4 = $this.tryWriteEntityConfig((String)var11_13.get(), (String)var12_14.get(), props, true, state$3);
            if (option4 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option4).value();
            }
            if (None$.MODULE$.equals(option4)) {
                throw new MigrationClientException(new StringBuilder(89).append("Could not write client quotas for ").append(entity$3).append(" on second attempt when using Create instead of SetData").toString());
            }
            throw new MatchError(option4);
        }
        throw new MatchError(option3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteEntityConfig$1(ZkConfigMigrationClient $this, Properties props$4, boolean create$1, String entityType$2, String path$1, ZkMigrationLeadershipState state$4) {
        void var10_10;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props$4);
        .colon.colon requests = create$1 ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, $this.zkClient.defaultAcls(path$1), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create$1 && ((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var9_9;
            $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(entityType$2).append("/").append(path$1).toString());
            return new Some((Object)state$4.withMigrationZkVersion((int)var9_9));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var10_10.head()).resultCode(), (String)path$1);
    }

    public ZkConfigMigrationClient(KafkaZkClient zkClient, PasswordEncoder passwordEncoder) {
        this.zkClient = zkClient;
        this.passwordEncoder = passwordEncoder;
        this.adminZkClient = new AdminZkClient(zkClient);
    }
}

