/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\u00180\u0001QB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011%\ti\u0001AI\u0001\n\u0003\ty\u0001C\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u0002\u0016!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001\"CA\u001f\u0001E\u0005I\u0011AA\b\u0011%\ty\u0004AI\u0001\n\u0003\t\t\u0005C\u0004\u0002F\u0001!\t!a\u0012\t\u0013\u0005}\u0003!%A\u0005\u0002\u0005U\u0001\"CA1\u0001E\u0005I\u0011AA\u000b\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!!\u001c\u0001\t\u0013\ty\u0007C\u0005\u0002\f\u0002\t\n\u0011\"\u0003\u0002\u0016!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\n\u0003[\u0003\u0011\u0013!C\u0001\u0003_C\u0011\"a-\u0001#\u0003%\t!!.\t\u0013\u0005e\u0006!%A\u0005\u0002\u0005U\u0001bBA^\u0001\u0011\u0005\u0011Q\u0018\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0001\u0003_C\u0011\"a3\u0001#\u0003%\t!!.\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003o\u0004A\u0011AA}\u0011%\u0011Y\u0001AI\u0001\n\u0003\t)\u0002C\u0004\u0003\u000e\u0001!IAa\u0004\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002\"\u0003B\u0017\u0001E\u0005I\u0011AA\u000b\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005cAqA!\u000f\u0001\t\u0003\u0011Y\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B)\u0001\u0011\u0005!1\f\u0005\b\u0005C\u0002A\u0011\u0001B2\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SB\u0011Ba\u001e\u0001#\u0003%I!!\u0006\t\u000f\te\u0004\u0001\"\u0001\u0003|!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BD\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u00055\tE-\\5o5.\u001cE.[3oi*\u0011\u0001'M\u0001\u0003u.T\u0011AM\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qzT\"A\u001f\u000b\u0005y\n\u0014!B;uS2\u001c\u0018B\u0001!>\u0005\u001daunZ4j]\u001e\f\u0001B_6DY&,g\u000e\u001e\t\u0003\u0007\u0012k\u0011aL\u0005\u0003\u000b>\u0012QbS1gW\u0006T6n\u00117jK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0002I\u0013B\u00111\t\u0001\u0005\u0006\u0003\n\u0001\rAQ\u0001\fGJ,\u0017\r^3U_BL7\rF\u0004M\u001fr\u000b7-\\;\u0011\u0005Yj\u0015B\u0001(8\u0005\u0011)f.\u001b;\t\u000bA\u001b\u0001\u0019A)\u0002\u000bQ|\u0007/[2\u0011\u0005IKfBA*X!\t!v'D\u0001V\u0015\t16'\u0001\u0004=e>|GOP\u0005\u00031^\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001l\u000e\u0005\u0006;\u000e\u0001\rAX\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u001c`\u0013\t\u0001wGA\u0002J]RDQAY\u0002A\u0002y\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d!7\u0001%AA\u0002\u0015\f1\u0002^8qS\u000e\u001cuN\u001c4jOB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0005kRLGNC\u0001k\u0003\u0011Q\u0017M^1\n\u00051<'A\u0003)s_B,'\u000f^5fg\"9an\u0001I\u0001\u0002\u0004y\u0017!\u0004:bG.\fu/\u0019:f\u001b>$W\r\u0005\u0002qg6\t\u0011O\u0003\u0002sc\u0005)\u0011\rZ7j]&\u0011A/\u001d\u0002\u000e%\u0006\u001c7.Q<be\u0016lu\u000eZ3\t\u000fY\u001c\u0001\u0013!a\u0001o\u0006YQo]3t)>\u0004\u0018nY%e!\t1\u00040\u0003\u0002zo\t9!i\\8mK\u0006t\u0017!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H\u0005N\u000b\u0002y*\u0012Q-`\u0016\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dq'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0003\u0002\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0003\u0016\u0003_v\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0018)\u0012q/`\u0001\u0013O\u0016$(I]8lKJlU\r^1eCR\f7\u000f\u0006\u0004\u0002\u001e\u0005=\u0012\u0011\u0007\t\u0007\u0003?\t)#!\u000b\u000e\u0005\u0005\u0005\"bAA\u0012o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u0004'\u0016\f\bc\u00019\u0002,%\u0019\u0011QF9\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\"9an\u0002I\u0001\u0002\u0004y\u0007\"CA\u001a\u000fA\u0005\t\u0019AA\u001b\u0003)\u0011'o\\6fe2K7\u000f\u001e\t\u0006m\u0005]\u00121H\u0005\u0004\u0003s9$AB(qi&|g\u000eE\u0003\u0002 \u0005\u0015b,\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000fJ\u0019\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\t\u0016\u0004\u0003ki\u0018!G2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$2\u0002TA%\u0003\u0017\ny%!\u0017\u0002^!)\u0001K\u0003a\u0001#\"1\u0011Q\n\u0006A\u0002\u0015\faaY8oM&<\u0007bBA)\u0015\u0001\u0007\u00111K\u0001\u001ba\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\b\u0003?\t)FXA\u001e\u0013\u0011\t9&!\t\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0002\\)\u0001\n\u00111\u0001x\u0003!1\u0018\r\\5eCR,\u0007b\u0002<\u000b!\u0003\u0005\ra^\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIU\n1C^1mS\u0012\fG/\u001a+pa&\u001c7I]3bi\u0016$r\u0001TA4\u0003S\nY\u0007C\u0003Q\u001b\u0001\u0007\u0011\u000bC\u0004\u0002R5\u0001\r!a\u0015\t\r\u00055S\u00021\u0001f\u0003u9(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H#\u0003'\u0002r\u0005M\u0014QQAE\u0011\u0015\u0001f\u00021\u0001R\u0011\u001d\t)H\u0004a\u0001\u0003o\n\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u001d\ty\"!\u0016_\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\n\u0014AC2p]R\u0014x\u000e\u001c7fe&!\u00111QA?\u0005E\u0011V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\u0007\u0003\u000fs\u0001\u0019A<\u0002\u0011%\u001cX\u000b\u001d3bi\u0016DqA\u001e\b\u0011\u0002\u0003\u0007q/A\u0014xe&$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\"\u0014a\u00033fY\u0016$X\rV8qS\u000e$2\u0001TAI\u0011\u0015\u0001\u0006\u00031\u0001R\u00035\tG\r\u001a)beRLG/[8ogRq\u00111KAL\u00033\u000bi*!)\u0002&\u0006%\u0006\"\u0002)\u0012\u0001\u0004\t\u0006bBAN#\u0001\u0007\u0011qO\u0001\u0013KbL7\u000f^5oO\u0006\u001b8/[4o[\u0016tG\u000fC\u0004\u0002 F\u0001\r!!\b\u0002\u0015\u0005dGN\u0011:pW\u0016\u00148\u000f\u0003\u0005\u0002$F\u0001\n\u00111\u0001_\u00035qW/\u001c)beRLG/[8og\"I\u0011QO\t\u0011\u0002\u0003\u0007\u0011q\u0015\t\u0006m\u0005]\u00121\u000b\u0005\t\u0003W\u000b\u0002\u0013!a\u0001o\u0006aa/\u00197jI\u0006$Xm\u00148ms\u00069\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003cS#AX?\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012*TCAA\\U\r\t9+`\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIY\nQd\u0019:fCR,g*Z<QCJ$\u0018\u000e^5p]N\f5o]5h]6,g\u000e\u001e\u000b\r\u0003o\ny,!1\u0002D\u0006\u0015\u0017q\u0019\u0005\u0006!V\u0001\r!\u0015\u0005\b\u00037+\u0002\u0019AA<\u0011\u001d\ty*\u0006a\u0001\u0003;A\u0001\"a)\u0016!\u0003\u0005\rA\u0018\u0005\n\u0003k*\u0002\u0013!a\u0001\u0003O\u000bqe\u0019:fCR,g*Z<QCJ$\u0018\u000e^5p]N\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u000593M]3bi\u0016tUm\u001e)beRLG/[8og\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003y\u0019'/Z1uKB\u000b'\u000f^5uS>t7oV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u0002x\u0005E\u00171[Ak\u0011\u0015\u0001\u0006\u00041\u0001R\u0011\u001d\tY\n\u0007a\u0001\u0003oBq!a6\u0019\u0001\u0004\t9(\u0001\foK^\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u\u0003e1\u0018\r\\5eCR,'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\u0015\u000f1\u000bi.a8\u0002d\"9\u0011QO\rA\u0002\u0005M\u0003BBAq3\u0001\u0007a,A\rfqB,7\r^3e%\u0016\u0004H.[2bi&|gNR1di>\u0014\bbBAs3\u0001\u0007\u0011q]\u0001\u0013CZ\f\u0017\u000e\\1cY\u0016\u0014%o\\6fe&#7\u000f\u0005\u0003S\u0003St\u0016bAAv7\n\u00191+\u001a;\u0002\u0017A\f'o]3Ce>\\WM\u001d\u000b\u0005\u0003c\f\u0019\u0010\u0005\u00037\u0003oq\u0006BBA{5\u0001\u0007\u0011+\u0001\u0004ce>\\WM]\u0001\u000eG\"\fgnZ3D_:4\u0017nZ:\u0015\u00131\u000bY0a@\u0003\u0004\t\u001d\u0001BBA\u007f7\u0001\u0007\u0011+\u0001\u0006f]RLG/\u001f+za\u0016DaA!\u0001\u001c\u0001\u0004\t\u0016AC3oi&$\u0018PT1nK\"1!QA\u000eA\u0002\u0015\fqaY8oM&<7\u000f\u0003\u0005\u0003\nm\u0001\n\u00111\u0001x\u00039I7/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fqc\u00195b]\u001e,7i\u001c8gS\u001e\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0002%Q\u0014\u0018p\u00117fC:\fVo\u001c;b\u001d>$Wm\u001d\u000b\bo\nE!1\u0003B\u000b\u0011\u0019\ti0\ba\u0001#\"1!\u0011A\u000fA\u0002ECaA!\u0003\u001e\u0001\u00049\u0018\u0001F2iC:<Wm\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003M\u00057\u0011y\u0002\u0003\u0004\u0003\u001ey\u0001\r!U\u0001\u0012g\u0006t\u0017\u000e^5{K\u0012\u001cE.[3oi&#\u0007B\u0002B\u0003=\u0001\u0007Q-\u0001\u0010dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR9AJ!\n\u0003*\t-\u0002B\u0002B\u0014?\u0001\u0007\u0011+A\ntC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\r\u0003\u0004\u0003\u0006}\u0001\r!\u001a\u0005\t\u0005\u0013y\u0002\u0013!a\u0001o\u0006A3\r[1oO\u0016,6/\u001a:PeV\u001bXM]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u0001b/\u00197jI\u0006$X-\u00139D_:4\u0017n\u001a\u000b\u0006\u0019\nM\"q\u0007\u0005\u0007\u0005k\t\u0003\u0019A)\u0002\u0005%\u0004\bB\u0002B\u0003C\u0001\u0007Q-\u0001\bdQ\u0006tw-Z%q\u0007>tg-[4\u0015\u000b1\u0013iDa\u0010\t\r\tU\"\u00051\u0001R\u0011\u0019\u0011)A\ta\u0001K\u0006\u0019b/\u00197jI\u0006$X\rV8qS\u000e\u001cuN\u001c4jOR)AJ!\u0012\u0003H!)\u0001k\ta\u0001#\"1!QA\u0012A\u0002\u0015\f\u0011c\u00195b]\u001e,Gk\u001c9jG\u000e{gNZ5h)\u0015a%Q\nB(\u0011\u0015\u0001F\u00051\u0001R\u0011\u0019\u0011)\u0001\na\u0001K\u0006\u00112\r[1oO\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0015a%Q\u000bB-\u0011\u001d\u00119&\na\u0001\u0003w\tqA\u0019:pW\u0016\u00148\u000f\u0003\u0004\u0003\u0006\u0015\u0002\r!\u001a\u000b\u0006\u0019\nu#q\f\u0005\b\u0003k4\u0003\u0019AAy\u0011\u0019\u0011)A\na\u0001K\u0006!b/\u00197jI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e$2\u0001\u0014B3\u0011\u0019\u0011)a\na\u0001K\u0006\u00112\r[1oO\u0016,e\u000e^5us\u000e{gNZ5h)%a%1\u000eB8\u0005g\u0012)\b\u0003\u0004\u0003n!\u0002\r!U\u0001\u000fe>|G/\u00128uSRLH+\u001f9f\u0011\u0019\u0011\t\b\u000ba\u0001#\u00069b-\u001e7m'\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\u0007\u0005\u000bA\u0003\u0019A3\t\u0011\t%\u0001\u0006%AA\u0002]\fAd\u00195b]\u001e,WI\u001c;jif\u001cuN\u001c4jO\u0012\"WMZ1vYR$C'A\tgKR\u001c\u0007.\u00128uSRL8i\u001c8gS\u001e$R!\u001aB?\u0005\u007fBaA!\u001c+\u0001\u0004\t\u0006B\u0002B\u0014U\u0001\u0007\u0011+\u0001\nhKR\fE\u000e\u001c+pa&\u001c7i\u001c8gS\u001e\u001cHC\u0001BC!\u0019\ty\"!\u0016RK\u0006)b-\u001a;dQ\u0006cG.\u00128uSRL8i\u001c8gS\u001e\u001cH\u0003\u0002BC\u0005\u0017Ca!!@-\u0001\u0004\t\u0016A\u00074fi\u000eD\u0017\t\u001c7DQ&dG-\u00128uSRL8i\u001c8gS\u001e\u001cHC\u0002BC\u0005#\u0013\u0019\n\u0003\u0004\u0003n5\u0002\r!\u0015\u0005\u0007\u0005+k\u0003\u0019A)\u0002\u001f\rD\u0017\u000e\u001c3F]RLG/\u001f+za\u0016\u0004")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesTopicId) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map<Object, Seq<Object>> replicaAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerMetadatas, partitions, replicationFactor, -1, -1);
        boolean x$5 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment, x$5, usesTopicId);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$)) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack())))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment, boolean validate, boolean usesTopicId) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)((Map)partitionReplicaAssignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)v));
            }
            throw new MatchError(null);
        })), false, usesTopicId);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            scala.collection.immutable.Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            scala.collection.immutable.Set collidingTopics = (scala.collection.immutable.Set)allTopics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig.validate((Properties)config);
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesTopicId) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ topicIdOpt = usesTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Map<TopicPartition, Seq<Object>>)((Map)assignment.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        TopicPartition k = (TopicPartition)x0$2._1();
                        ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.replicas());
                    }
                    throw new MatchError(null);
                })));
            } else {
                Map<String, Uuid> topicIds = this.zkClient.getTopicIdsForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                this.zkClient.setTopicAssignment(topic, (Option<Uuid>)topicIds.get((Object)topic), (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$4());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment);
        if (validateOnly) {
            return (Map)((MapOps)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions)).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
                }
                throw new MatchError(null);
            });
        }
        return (Map)this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
            }
            throw new MatchError(null);
        });
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        replicaAssignment.foreach((Function1 & Serializable)proposedReplicaAssignment -> {
            this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()))).toSet());
            return BoxedUnit.UNIT;
        });
        return (Map)((Map)replicaAssignment.getOrElse((Function0 & Serializable)() -> {
            int startIndex = package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$5(existingAssignmentPartition0, x$7))));
            return AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)allBrokers, partitionsToAdd, existingAssignmentPartition0.size(), startIndex, existingAssignment.size());
        })).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void apply_removingReplicas;
                int tp = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                Nil$ nil$ = Nil$.MODULE$;
                Nil$ apply_addingReplicas = Nil$.MODULE$;
                Object var3_4 = null;
                nil$ = null;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)new ReplicaAssignment((Seq<Object>)replicas, (Seq<Object>)apply_addingReplicas, (Seq<Object>)apply_removingReplicas));
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> createNewPartitionsAssignment$default$5() {
        return None$.MODULE$;
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, false);
        return combinedAssignment;
    }

    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, replicas) -> AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), replicas);
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    Seq replicas = (Seq)x1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                return x1 != null && ((Seq)x1._2()).size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs, boolean isUserClientId) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs, isUserClientId);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public boolean changeConfigs$default$4() {
        return false;
    }

    private boolean tryCleanQuotaNodes(String entityType, String entityName, boolean isUserClientId) {
        String currPath = ConfigEntityZNode$.MODULE$.path(entityType, entityName);
        if (this.zkClient.getChildren(currPath).isEmpty()) {
            ObjectRef pathToDelete = ObjectRef.create((Object)currPath);
            if (isUserClientId) {
                String user = entityName.substring(0, entityName.indexOf("/"));
                String clientId = entityName.substring(entityName.lastIndexOf("/") + 1);
                String clientsPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), new StringBuilder(1).append(user).append("/").append(ConfigType$.MODULE$.Client()).toString());
                Seq<String> seq = this.zkClient.getChildren(clientsPath);
                .colon.colon colon2 = new .colon.colon((Object)clientId, (List)Nil$.MODULE$);
                if (seq != null && seq.equals((Object)colon2)) {
                    pathToDelete.elem = clientsPath;
                    Properties userData = this.fetchEntityConfig(ConfigType$.MODULE$.User(), user);
                    String userPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), user);
                    Seq<String> userChildren = this.zkClient.getChildren(userPath);
                    if (userData.isEmpty()) {
                        Seq<String> seq2 = userChildren;
                        .colon.colon colon3 = new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$);
                        if (seq2 != null && seq2.equals((Object)colon3)) {
                            pathToDelete.elem = userPath;
                        }
                    }
                }
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Deleting zk node ").append((String)pathToDelete$1.elem).append(" since node of entityType ").append(entityType).append(" and entityName ").append(entityName).append(" is empty.").toString());
            this.zkClient.deletePath((String)pathToDelete.elem, this.zkClient.deletePath$default$2(), this.zkClient.deletePath$default$3());
            return true;
        }
        return false;
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs, false);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs, isUserClientId);
    }

    public boolean changeUserOrUserClientIdConfig$default$3() {
        return false;
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs, false);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig.validate((Properties)configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs, false);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs, false));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable)x$8 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$8))).getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs, false);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs, boolean isUserClientId) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        boolean needUpdateConfigs = true;
        if ((ConfigType$.MODULE$.Client().equals(rootEntityType) || ConfigType$.MODULE$.User().equals(rootEntityType) || ConfigType$.MODULE$.Ip().equals(rootEntityType)) && configs.isEmpty() && this.tryCleanQuotaNodes(rootEntityType, fullSanitizedEntityName, isUserClientId)) {
            needUpdateConfigs = false;
        }
        if (needUpdateConfigs) {
            this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        }
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    private boolean changeEntityConfig$default$4() {
        return false;
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$7) {
        return x$7.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Tuple2 $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, Seq replicas) {
        if (replicas.isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (replicas.size() != replicas.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!replicas.toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$8) {
        return Integer.toString(x$8);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }
}

