/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001\u0002\u0011\"\u0001\u0019B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"Iq\t\u0001BC\u0002\u0013\u0005\u0011\u0005\u0013\u0005\t)\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u00111\u0004!\u0011!Q\u0001\n5DQ!\u001d\u0001\u0005\u0002IDq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002@\t\u0011\u0005=\u0001A1A\u0005\nuDq!!\u0005\u0001A\u0003%a\u0010\u0003\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003~\u0011\u001d\t)\u0002\u0001Q\u0001\nyD\u0001\"a\u0006\u0001\u0005\u0004%I! \u0005\b\u00033\u0001\u0001\u0015!\u0003\u007f\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!!\n\u0001\t\u0003\n9\u0003C\u0004\u00020\u0001!\t%a\n\t\u000f\u0005E\u0002\u0001\"\u0011\u00024!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!a)\u0001\t\u0013\t)\u000bC\u0004\u00020\u0002!\t%!-\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0002\u0015%\u0016lw\u000e^3MK\u0006$WM]#oIB{\u0017N\u001c;\u000b\u0005\t\u001a\u0013AB:feZ,'OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0014.cA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0018\u000e\u0003\u0005J!\u0001M\u0011\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oiB\u0011!'N\u0007\u0002g)\u0011AgI\u0001\u0006kRLGn]\u0005\u0003mM\u0012q\u0001T8hO&tw-A\u0005m_\u001e\u0004&/\u001a4jqB\u0011\u0011\b\u0011\b\u0003uy\u0002\"aO\u0015\u000e\u0003qR!!P\u0013\u0002\rq\u0012xn\u001c;?\u0013\ty\u0014&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003\n\u0013aa\u0015;sS:<'BA *\u00039\u0011Gn\\2lS:<7+\u001a8eKJ\u0004\"AL#\n\u0005\u0019\u000b#\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0017a\u00054fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014X#A%\u0011\u0005)\u0013V\"A&\u000b\u00051k\u0015aB2mS\u0016tGo\u001d\u0006\u0003I9S!a\u0014)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0016aA8sO&\u00111k\u0013\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u0001\u0015M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0011\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u00059:\u0016B\u0001-\"\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011afW\u0005\u00039\u0006\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0003rk>$\u0018\r\u0005\u0002/?&\u0011\u0001-\t\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ\u00042\u0001K2f\u0013\t!\u0017FA\u0005Gk:\u001cG/[8oaA\u0011aM[\u0007\u0002O*\u0011\u0001.[\u0001\u0007G>lWn\u001c8\u000b\u0005\tj\u0015BA6h\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017a\u00052s_.,'/\u00129pG\"\u001cV\u000f\u001d9mS\u0016\u0014\bc\u0001\u0015d]B\u0011\u0001f\\\u0005\u0003a&\u0012A\u0001T8oO\u00061A(\u001b8jiz\"\u0012b\u001d;vm^D\u0018P_>\u0011\u00059\u0002\u0001\"B\u001c\u000b\u0001\u0004A\u0004\"B\"\u000b\u0001\u0004!\u0005\"B$\u000b\u0001\u0004I\u0005\"B+\u000b\u0001\u00041\u0006\"B-\u000b\u0001\u0004Q\u0006\"B/\u000b\u0001\u0004q\u0006\"B1\u000b\u0001\u0004\u0011\u0007\"\u00027\u000b\u0001\u0004i\u0017aB7bq^\u000b\u0017\u000e^\u000b\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA\u0001\\1oO*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!aB%oi\u0016<WM]\u0001\t[\u0006Dx+Y5uA\u0005AQ.\u001b8CsR,7/A\u0005nS:\u0014\u0015\u0010^3tA\u0005AQ.\u0019=CsR,7/A\u0005nCb\u0014\u0015\u0010^3tA\u0005Ia-\u001a;dQNK'0Z\u0001\u000bM\u0016$8\r[*ju\u0016\u0004\u0013\u0001H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u0003?\u00012\u0001KA\u0011\u0013\r\t\u0019#\u000b\u0002\b\u0005>|G.Z1o\u00035Ig.\u001b;jCR,7\t\\8tKR\u0011\u0011\u0011\u0006\t\u0004Q\u0005-\u0012bAA\u0017S\t!QK\\5u\u0003\u0015\u0019Gn\\:f\u00039\u0011'o\\6fe\u0016sG\rU8j]R$\"!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f$\u0003\u001d\u0019G.^:uKJLA!a\u0010\u0002:\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018!\u00024fi\u000eDG\u0003BA#\u0003G\u0002\u0002\"a\u0012\u0002N\u0005E\u00131L\u0007\u0003\u0003\u0013R1!a\u0013*\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\nIEA\u0002NCB\u0004B!a\u0015\u0002X5\u0011\u0011Q\u000b\u0006\u0003Q6KA!!\u0017\u0002V\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA/\u0003?j\u0011\u0001A\u0005\u0004\u0003Cz#!\u0003$fi\u000eDG)\u0019;b\u0011\u001d\t)g\u0006a\u0001\u0003O\nABZ3uG\"\u0014V-];fgR\u0004B!!\u001b\u0002v9!\u00111NA9\u001b\t\tiG\u0003\u0003\u0002p\u0005U\u0013\u0001\u0003:fcV,7\u000f^:\n\t\u0005M\u0014QN\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0003o\nIHA\u0004Ck&dG-\u001a:\u000b\t\u0005M\u0014QN\u0001\u0014M\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e\u000b\u0007\u0003\u007f\n))!#\u0011\u0007\u0019\f\t)C\u0002\u0002\u0004\u001e\u0014ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0004\u0002\bb\u0001\r!!\u0015\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111\u0012\rA\u0002\u00055\u0015AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\u00042\u0001KAH\u0013\r\t\t*\u000b\u0002\u0004\u0013:$\u0018!\u00054fi\u000eDG*\u0019;fgR|eMZ:fiR1\u0011qPAL\u00033Cq!a\"\u001a\u0001\u0004\t\t\u0006C\u0004\u0002\ff\u0001\r!!$\u00021\u0019,Go\u00195FCJd\u0017.Z:u\u0019>\u001c\u0017\r\\(gMN,G\u000f\u0006\u0004\u0002\u0000\u0005}\u0015\u0011\u0015\u0005\b\u0003\u000fS\u0002\u0019AA)\u0011\u001d\tYI\u0007a\u0001\u0003\u001b\u000b1BZ3uG\"|eMZ:fiRA\u0011qPAT\u0003S\u000bY\u000bC\u0004\u0002\bn\u0001\r!!\u0015\t\u000f\u0005-5\u00041\u0001\u0002\u000e\"1\u0011QV\u000eA\u00029\f\u0011\u0002^5nKN$\u0018-\u001c9\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\t\u0019,a7\u0011\u0011\u0005\u001d\u0013QJA)\u0003k\u0003B!a.\u0002V:!\u0011\u0011XAh\u001d\u0011\tY,a3\u000f\t\u0005u\u0016\u0011\u001a\b\u0005\u0003\u007f\u000b9M\u0004\u0003\u0002B\u0006\u0015gbA\u001e\u0002D&\t\u0011+\u0003\u0002P!&\u0011AET\u0005\u0003Q6KA!!4\u0002V\u00059Q.Z:tC\u001e,\u0017\u0002BAi\u0003'\f\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC*!\u0011QZA+\u0013\u0011\t9.!7\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi*!\u0011\u0011[Aj\u0011\u001d\ti\u000e\ba\u0001\u0003?\f!\u0002]1si&$\u0018n\u001c8t!!\t9%!\u0014\u0002R\u0005\u0005\b\u0003BA/\u0003GL1!!:0\u0005%)\u0005o\\2i\t\u0006$\u0018-\u0001\u0006ck&dGMR3uG\"$B!a;\u0003\u000eA1\u0011Q^A~\u0005\u0003qA!a<\u0002x:!\u0011\u0011_A{\u001d\rY\u00141_\u0005\u0002I%\u0011!eI\u0005\u0004\u0003s\f\u0013!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0003{\fyP\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0003s\f\u0003#\u0002\u0015\u0003\u0004\t\u001d\u0011b\u0001B\u0003S\t1q\n\u001d;j_:\u0004B!!<\u0003\n%!!1BA\u0000\u00051\u0011V\r\u001d7jG\u00064U\r^2i\u0011\u001d\ti.\ba\u0001\u0005\u001f\u0001\u0002\"a\u0012\u0002N\u0005E#\u0011\u0003\t\u0004]\tM\u0011b\u0001B\u000bC\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\u000612\u000f[8vY\u00124u\u000e\u001c7po\u0016\u0014H\u000b\u001b:piRdW\r\u0006\u0005\u0002 \tm!Q\u0004B\u0011\u0011\u0015if\u00041\u0001_\u0011\u001d\u0011yB\ba\u0001\u0005#\t!BZ3uG\"\u001cF/\u0019;f\u0011\u001d\t9I\ba\u0001\u0003#\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002q\u0001")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Function0<Object> brokerEpochSupplier;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return ((MetadataVersion)this.metadataVersionSupplier.apply()).isTruncationOnFetchSupported();
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        FetchResponse fetchResponse = (FetchResponse)clientResponse2.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse2.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return (Map)Map$.MODULE$.empty();
        }
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse2.requestHeader().apiVersion())).asScala();
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -4L);
    }

    private OffsetAndEpoch fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
        ListOffsetsRequest.Builder requestBuilder = ListOffsetsRequest.Builder.forReplica((short)metadataVersion.listOffsetRequestVersion(), (int)this.brokerConfig.brokerId()).setTargetTimes(Collections.singletonList(topic));
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$1))).get()).partitions()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$2))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
            if (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV2)) {
                return new OffsetAndEpoch(responsePartition.offset(), responsePartition.leaderEpoch());
            }
            return new OffsetAndEpoch(Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0)), responsePartition.leaderEpoch());
        }
        throw errors.exception();
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return (Map)Map$.MODULE$.empty();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchEpochEndOffsets$2(topics, topicPartition, epochData));
        partitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_3 = null;
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)((MetadataVersion)this.metadataVersionSupplier.apply()).offsetForLeaderEpochRequestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)topics, (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responseBody.data().topics()).asScala().flatMap((Function1 & Serializable)offsetForLeaderTopicResult -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(offsetForLeaderTopicResult.partitions()).asScala().map((Function1 & Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                }
                throw new MatchError(null);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$3 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(topicPartition);
                }
            }
            return BoxedUnit.UNIT;
        };
        partitions.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var9_4 = null;
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void forReplica_fetchData;
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaEpoch;
            MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
            short s = metadataVersion.fetchRequestVersion() >= 13 && !fetchData.canUseTopicIds() ? 12 : metadataVersion.fetchRequestVersion();
            java.util.Map map = fetchData.toSend();
            int n = Predef$.MODULE$.Integer2int(this.minBytes());
            int n2 = Predef$.MODULE$.Integer2int(this.maxWait());
            long l = this.brokerEpochSupplier.apply$mcJ$sp();
            int forReplica_replicaId = this.brokerConfig.brokerId();
            map = null;
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(s, s, forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, (java.util.Map)forReplica_fetchData).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).removed(fetchData.toForget()).replaced(fetchData.toReplace()).metadata(fetchData.metadata());
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public String toString() {
        return new StringBuilder(37).append("RemoteLeaderEndPoint(blockingSender=").append(this.blockingSender).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$1) {
        String string = x$1.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$2) {
        return x$2.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochEndOffsets$2(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier, Function0<Object> brokerEpochSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.logIdent_$eq(logPrefix);
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

