/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005%f\u0001B\u000e\u001d\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%I!\f\u0005\tw\u0001\u0011\t\u0011)A\u0005]!AA\b\u0001BC\u0002\u0013%Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011!)\u0005A!b\u0001\n\u00131\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011-\u0003!Q1A\u0005\n1C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\u00069\u0002!\t%\u0018\u0005\u0006U\u0002!\te\u001b\u0004\u0005w\u0002!A\u0010\u0003\u0006\u0002\u00121\u0011)\u0019!C\u0001\u0003'A!\"!\u0006\r\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t9\u0002\u0004BC\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003Ca!\u0011!Q\u0001\n\u0005m\u0001BB+\r\t\u0003\t\u0019\u0003C\u0006\u0002.1\u0001\r\u00111A\u0005\u0002\u0005=\u0002bCA.\u0019\u0001\u0007\t\u0019!C\u0001\u0003;B1\"a\u0019\r\u0001\u0004\u0005\t\u0015)\u0003\u00022!9\u0011Q\r\u0007\u0005B\u0005\u001d\u0004bBA5\u0019\u0011\u0005\u00131\u000e\u0005\b\u0003[bA\u0011IA8\u0011\u001d\t9\b\u0001C!\u0003sBq!!&\u0001\t\u0003\n9\nC\u0004\u0002\"\u0002!\t%a)\u0003/%s7M]3nK:$\u0018\r\u001c$fi\u000eD7i\u001c8uKb$(BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011\u0001H\u0005\u0003Wq\u0011ABR3uG\"\u001cuN\u001c;fqR\fA\u0001^5nKV\ta\u0006\u0005\u00020s5\t\u0001G\u0003\u00022e\u0005)Q\u000f^5mg*\u00111\u0007N\u0001\u0007G>lWn\u001c8\u000b\u0005})$B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001eL!A\u000f\u0019\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\fe\u0016\fX*\u001a;bI\u0006$\u0018-F\u0001?!\ty$)D\u0001A\u0015\t\t%'\u0001\u0005sKF,Xm\u001d;t\u0013\t\u0019\u0005IA\u0007GKR\u001c\u0007.T3uC\u0012\fG/Y\u0001\re\u0016\fX*\u001a;bI\u0006$\u0018\rI\u0001\bg\u0016\u001c8/[8o+\u00059\u0005CA\u0015I\u0013\tIED\u0001\u0007GKR\u001c\u0007nU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003)!x\u000e]5d\u001d\u0006lWm]\u000b\u0002\u001bB\u0011a*\u0015\b\u0003S=K!\u0001\u0015\u000f\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\u0005I\u001b&A\u0004+P!&\u001buLT!N\u000b~k\u0015\t\u0015\u0006\u0003!r\t1\u0002^8qS\u000et\u0015-\\3tA\u00051A(\u001b8jiz\"Ra\u0016-Z5n\u0003\"!\u000b\u0001\t\u000b1J\u0001\u0019\u0001\u0018\t\u000bqJ\u0001\u0019\u0001 \t\u000b\u0015K\u0001\u0019A$\t\u000b-K\u0001\u0019A'\u0002\u001d\u001d,GOR3uG\"|eMZ:fiR\u0011a\f\u001a\t\u0004G}\u000b\u0017B\u00011%\u0005\u0019y\u0005\u000f^5p]B\u00111EY\u0005\u0003G\u0012\u0012A\u0001T8oO\")QM\u0003a\u0001M\u0006\u0011A\u000f\u001d\t\u0003O\"l\u0011AM\u0005\u0003SJ\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002!\u0019|'/Z1dQB\u000b'\u000f^5uS>tGC\u00017p!\t\u0019S.\u0003\u0002oI\t!QK\\5u\u0011\u0015\u00018\u00021\u0001r\u0003\r1WO\u001c\t\u0006GI4G\u000f\\\u0005\u0003g\u0012\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0005UDhBA w\u0013\t9\b)\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002zu\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!a\u001e!\u0003#A\u000b'\u000f^5uS>t\u0017\n^3sCR|'o\u0005\u0003\r{\u0006-\u0001c\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(AB(cU\u0016\u001cG\u000fE\u0002O\u0003\u001bI1!a\u0004T\u00055\u0011Vi\u0015)`\u001b\u0006\u0003v,\u0013+F%\u0006!\u0011\u000e^3s+\t\tY!A\u0003ji\u0016\u0014\b%A\u0013va\u0012\fG/\u001a$fi\u000eD7i\u001c8uKb$\u0018I\u001c3SK6|g/Z+og\u0016dWm\u0019;fIV\u0011\u00111\u0004\t\u0004G\u0005u\u0011bAA\u0010I\t9!i\\8mK\u0006t\u0017AJ;qI\u0006$XMR3uG\"\u001cuN\u001c;fqR\fe\u000e\u001a*f[>4X-\u00168tK2,7\r^3eAQ1\u0011QEA\u0015\u0003W\u00012!a\n\r\u001b\u0005\u0001\u0001bBA\t#\u0001\u0007\u00111\u0002\u0005\b\u0003/\t\u0002\u0019AA\u000e\u0003-qW\r\u001f;FY\u0016lWM\u001c;\u0016\u0005\u0005E\u0002cBA\u001a\u0003\u00072\u0017\u0011\n\b\u0005\u0003k\tiD\u0004\u0003\u00028\u0005eRBAA\u0002\u0013\u0011\tY$a\u0001\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u007f\t\t%A\u0002NCBTA!a\u000f\u0002\u0004%!\u0011QIA$\u0005\u0015)e\u000e\u001e:z\u0015\u0011\ty$!\u0011\u0011\t\u0005-\u0013q\u000b\b\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u001a\u0002\u000f5,7o]1hK&!\u0011QKA(\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0004s\u0006e#\u0002BA+\u0003\u001f\nqB\\3yi\u0016cW-\\3oi~#S-\u001d\u000b\u0004Y\u0006}\u0003\"CA1'\u0005\u0005\t\u0019AA\u0019\u0003\rAH%M\u0001\r]\u0016DH/\u00127f[\u0016tG\u000fI\u0001\bQ\u0006\u001ch*\u001a=u)\t\tY\"\u0001\u0003oKb$HCAA\u0019\u0003\u0019\u0011X-\\8wKR\u0011\u0011\u0011\u000f\t\u0004G\u0005M\u0014bAA;I\t9aj\u001c;iS:<\u0017aD4fiJ+7\u000f]8og\u0016\u001c\u0016N_3\u0015\r\u0005m\u0014\u0011QAF!\r\u0019\u0013QP\u0005\u0004\u0003\u007f\"#aA%oi\"9\u00111\u0011\rA\u0002\u0005\u0015\u0015aB;qI\u0006$Xm\u001d\t\u0004\u001d\u0006\u001d\u0015bAAE'\nA!+R*Q?6\u000b\u0005\u000bC\u0004\u0002\u000eb\u0001\r!a$\u0002\u0013Y,'o]5p]&#\u0007cA\u0012\u0002\u0012&\u0019\u00111\u0013\u0013\u0003\u000bMCwN\u001d;\u0002;U\u0004H-\u0019;f\u0003:$w)\u001a8fe\u0006$XMU3ta>t7/\u001a#bi\u0006$B!!'\u0002 B\u0019q(a'\n\u0007\u0005u\u0005IA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\u0005\b\u0003\u0007K\u0002\u0019AAC\u0003Q9W\r\u001e+ie>$H\u000f\\3e%\u0016\u001c\bo\u001c8tKR!\u0011\u0011TAS\u0011\u001d\t9K\u0007a\u0001\u0003w\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final FetchMetadata reqMetadata;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private final Map<Uuid, String> topicNames;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    private Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(part -> {
                if (this.kafka$server$IncrementalFetchContext$$session().usesTopicIds()) {
                    part.maybeResolveUnknownName(this.topicNames());
                }
                fun.apply((Object)new TopicIdPartition(part.topicId(), new TopicPartition(part.topic(), part.partition())), (Object)part.reqData());
            });
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), updates);
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, FetchMetadata reqMetadata, FetchSession session, Map<Uuid, String> topicNames) {
        this.time = time;
        this.reqMetadata = reqMetadata;
        this.kafka$server$IncrementalFetchContext$$session = session;
        this.topicNames = topicNames;
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        public Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement() {
            return this.nextElement;
        }

        public void nextElement_$eq(Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.iter().next();
                TopicIdPartition topicPart = element.getKey();
                FetchResponseData.PartitionData respData = element.getValue();
                CachedPartition cachedPart = (CachedPartition)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new CachedPartition(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected() || FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) <= 0) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        @Override
        public Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.nextElement();
            this.nextElement_$eq(null);
            return element;
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

