/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.AclApis;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.server.AuthHelper;
import kafka.server.ControllerMutationQuota;
import kafka.server.EnvelopeUtils$;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.RequestHandlerHelper;
import kafka.server.RequestLocal;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.UnregisterBrokerResponseData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterClientQuotasResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.UnregisterBrokerResponse;
import org.apache.kafka.common.requests.UpdateFeaturesRequest;
import org.apache.kafka.common.requests.UpdateFeaturesResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015h\u0001B A\u0001\u0015C\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t=\u0002\u0011\t\u0011)A\u00051\"Aq\f\u0001BC\u0002\u0013\u0005\u0001\r\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003b\u0011!\u0001\bA!b\u0001\n\u0003\t\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003s\u0011)\t\u0019\u0001\u0001BC\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\f\u0001\t\u0015\r\u0011\"\u0001\u0002\u001a!Q\u0011Q\u0005\u0001\u0003\u0002\u0003\u0006I!a\u0007\t\u0015\u0005\u001d\u0002A!b\u0001\n\u0003\tI\u0003\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003WA!\"a\u0011\u0001\u0005\u000b\u0007I\u0011AA#\u0011)\ti\u0005\u0001B\u0001B\u0003%\u0011q\t\u0005\u000b\u0003\u001f\u0002!Q1A\u0005\u0002\u0005E\u0003BCA-\u0001\t\u0005\t\u0015!\u0003\u0002T!Q\u00111\f\u0001\u0003\u0006\u0004%\t!!\u0018\t\u0015\u0005e\u0004A!A!\u0002\u0013\ty\u0006\u0003\u0006\u0002|\u0001\u0011)\u0019!C\u0001\u0003{B!\"!\"\u0001\u0005\u0003\u0005\u000b\u0011BA@\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013C\u0011\"!)\u0001\u0005\u0004%\t!a)\t\u0011\u0005-\u0006\u0001)A\u0005\u0003KC\u0011\"!,\u0001\u0005\u0004%\t!a,\t\u0011\u0005]\u0006\u0001)A\u0005\u0003cC\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003{Cq!!2\u0001\t\u0003\t9\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005e\u0007\u0001\"\u0011\u0002\\\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqAa\n\u0001\t\u0003\u0011I\u0003C\u0004\u0003.\u0001!\tAa\f\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!1\u0017\u0001\u0005\u0002\tU\u0006b\u0002B]\u0001\u0011%!1\u0018\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0011\u001d\u0019I\u0001\u0001C\u0001\u0007\u0017Aqaa\u0004\u0001\t\u0003\u0019\t\u0002C\u0004\u00048\u0001!\ta!\u000f\t\u000f\ru\u0002\u0001\"\u0001\u0004@!911\t\u0001\u0005\u0002\r\u0015\u0003bBB%\u0001\u0011\u000511\n\u0005\b\u0007\u001f\u0002A\u0011AB)\u0011\u001d\u0019)\u0006\u0001C\u0001\u0007/Bqaa\u0017\u0001\t\u0003\u0019i\u0006C\u0004\u0004b\u0001!\taa\u0019\t\u000f\r\u001d\u0004\u0001\"\u0001\u0004j!91Q\u000e\u0001\u0005\u0002\r=\u0004bBB:\u0001\u0011%1Q\u000f\u0005\b\u0007#\u0003A\u0011ABJ\u0011\u001d\u00199\n\u0001C\u0001\u00073Cqa!(\u0001\t\u0003\u0019y\nC\u0004\u0004$\u0002!\ta!*\t\u000f\r\u001d\u0007\u0001\"\u0001\u0004J\"91Q\u001a\u0001\u0005\u0002\r=\u0007bBBj\u0001\u0011\u00051Q\u001b\u0005\b\u00073\u0004A\u0011ABn\u0011\u001d\u0019y\u000e\u0001C\u0001\u0007C\u0014abQ8oiJ|G\u000e\\3s\u0003BL7O\u0003\u0002B\u0005\u000611/\u001a:wKJT\u0011aQ\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001a\t\u0014)\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g!\tie*D\u0001A\u0013\ty\u0005IA\tBa&\u0014V-];fgRD\u0015M\u001c3mKJ\u0004\"!\u0015+\u000e\u0003IS!a\u0015\"\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0013&a\u0002'pO\u001eLgnZ\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\u0005A\u0006CA-]\u001b\u0005Q&BA.C\u0003\u001dqW\r^<pe.L!!\u0018.\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0006bkRDwN]5{KJ,\u0012!\u0019\t\u0004\u000f\n$\u0017BA2I\u0005\u0019y\u0005\u000f^5p]B\u0011Q-\\\u0007\u0002M*\u0011ql\u001a\u0006\u0003\u0003\"T!aQ5\u000b\u0005)\\\u0017AB1qC\u000eDWMC\u0001m\u0003\ry'oZ\u0005\u0003]\u001a\u0014!\"Q;uQ>\u0014\u0018N_3s\u0003-\tW\u000f\u001e5pe&TXM\u001d\u0011\u0002\rE,x\u000e^1t+\u0005\u0011\bCA:~\u001d\t!8P\u0004\u0002vu:\u0011a/_\u0007\u0002o*\u0011\u0001\u0010R\u0001\u0007yI|w\u000e\u001e \n\u0003\rK!!\u0011\"\n\u0005q\u0004\u0015\u0001D)v_R\fg)Y2u_JL\u0018B\u0001@\u0000\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011A\u0010Q\u0001\bcV|G/Y:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003#i!!a\u0003\u000b\u0007M\u000biAC\u0002\u0002\u0010!\faaY8n[>t\u0017\u0002BA\n\u0003\u0017\u0011A\u0001V5nK\u0006)A/[7fA\u0005Q1m\u001c8ue>dG.\u001a:\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Ci!!a\b\u000b\u0007\u0005]\u0001.\u0003\u0003\u0002$\u0005}!AC\"p]R\u0014x\u000e\u001c7fe\u0006Y1m\u001c8ue>dG.\u001a:!\u0003-\u0011\u0018M\u001a;NC:\fw-\u001a:\u0016\u0005\u0005-\u0002CBA\u0017\u0003g\t9$\u0004\u0002\u00020)\u0019\u0011\u0011\u0007\"\u0002\tI\fg\r^\u0005\u0005\u0003k\tyCA\u0006SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0007\u0005=q-\u0003\u0003\u0002@\u0005m\"\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.\u0001\u0007sC\u001a$X*\u00198bO\u0016\u0014\b%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003\u000f\u00022!TA%\u0013\r\tY\u0005\u0011\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u001d5,G/\u0019)s_B,'\u000f^5fgV\u0011\u00111\u000b\t\u0004\u001b\u0006U\u0013bAA,\u0001\nqQ*\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\u0018aD7fi\u0006\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u001f\r|g\u000e\u001e:pY2,'OT8eKN,\"!a\u0018\u0011\r\u0005\u0005\u00141NA9\u001d\u0011\t\u0019'a\u001a\u000f\u0007Y\f)'C\u0001J\u0013\r\tI\u0007S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti'a\u001c\u0003\u0007M+\u0017OC\u0002\u0002j!\u0003B!a\u001d\u0002v5\u0011\u0011QB\u0005\u0005\u0003o\niA\u0001\u0003O_\u0012,\u0017\u0001E2p]R\u0014x\u000e\u001c7fe:{G-Z:!\u0003E\t\u0007/\u001b,feNLwN\\'b]\u0006<WM]\u000b\u0003\u0003\u007f\u00022!TAA\u0013\r\t\u0019\t\u0011\u0002\u0012\u0003BLg+\u001a:tS>tW*\u00198bO\u0016\u0014\u0018AE1qSZ+'o]5p]6\u000bg.Y4fe\u0002\na\u0001P5oSRtDCFAF\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015qSAM\u00037\u000bi*a(\u0011\u00055\u0003\u0001\"\u0002,\u0016\u0001\u0004A\u0006\"B0\u0016\u0001\u0004\t\u0007\"\u00029\u0016\u0001\u0004\u0011\bbBA\u0002+\u0001\u0007\u0011q\u0001\u0005\b\u0003/)\u0002\u0019AA\u000e\u0011\u001d\t9#\u0006a\u0001\u0003WAq!a\u0011\u0016\u0001\u0004\t9\u0005C\u0004\u0002PU\u0001\r!a\u0015\t\u000f\u0005mS\u00031\u0001\u0002`!9\u00111P\u000bA\u0002\u0005}\u0014AC1vi\"DU\r\u001c9feV\u0011\u0011Q\u0015\t\u0004\u001b\u0006\u001d\u0016bAAU\u0001\nQ\u0011)\u001e;i\u0011\u0016d\u0007/\u001a:\u0002\u0017\u0005,H\u000f\u001b%fYB,'\u000fI\u0001\u000ee\u0016\fX/Z:u\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005E\u0006cA'\u00024&\u0019\u0011Q\u0017!\u0003)I+\u0017/^3ti\"\u000bg\u000e\u001a7fe\"+G\u000e]3s\u00039\u0011X-];fgRDU\r\u001c9fe\u0002\nq!Y2m\u0003BL7/\u0006\u0002\u0002>B\u0019Q*a0\n\u0007\u0005\u0005\u0007IA\u0004BG2\f\u0005/[:\u0002\u0011\u0005\u001cG.\u00119jg\u0002\n\u0001\"[:DY>\u001cX\rZ\u000b\u0003\u0003\u0013\u00042aRAf\u0013\r\ti\r\u0013\u0002\b\u0005>|G.Z1o\u0003\u0015\u0019Gn\\:f)\t\t\u0019\u000eE\u0002H\u0003+L1!a6I\u0005\u0011)f.\u001b;\u0002\r!\fg\u000e\u001a7f)\u0019\t\u0019.!8\u0002p\"9\u0011q\u001c\u0010A\u0002\u0005\u0005\u0018a\u0002:fcV,7\u000f\u001e\t\u0005\u0003G\fIOD\u0002Z\u0003KL1!a:[\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2LA!a;\u0002n\n9!+Z9vKN$(bAAt5\"9\u0011\u0011\u001f\u0010A\u0002\u0005M\u0018\u0001\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007cA'\u0002v&\u0019\u0011q\u001f!\u0003\u0019I+\u0017/^3ti2{7-\u00197\u0002+!\fg\u000e\u001a7f\u000b:4X\r\\8qKJ+\u0017/^3tiR1\u0011Q B\t\u0005'\u0001b!a@\u0003\u000e\u0005MWB\u0001B\u0001\u0015\u0011\u0011\u0019A!\u0002\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003\b\t%\u0011\u0001B;uS2T!Aa\u0003\u0002\t)\fg/Y\u0005\u0005\u0005\u001f\u0011\tAA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016Dq!a8 \u0001\u0004\t\t\u000fC\u0004\u0002r~\u0001\r!a=\u00025!\fg\u000e\u001a7f'\u0006\u001cH\u000eS1oIND\u0017m[3SKF,Xm\u001d;\u0015\t\u0005u(\u0011\u0004\u0005\b\u0003?\u0004\u0003\u0019AAq\u0003uA\u0017M\u001c3mKN\u000b7\u000f\\!vi\",g\u000e^5dCR,'+Z9vKN$H\u0003BA\u007f\u0005?Aq!a8\"\u0001\u0004\t\t/A\u0006iC:$G.\u001a$fi\u000eDG\u0003BA\u007f\u0005KAq!a8#\u0001\u0004\t\t/A\niC:$G.\u001a$fi\u000eD7K\\1qg\"|G\u000f\u0006\u0003\u0002~\n-\u0002bBApG\u0001\u0007\u0011\u0011]\u0001\u0013Q\u0006tG\r\\3EK2,G/\u001a+pa&\u001c7\u000f\u0006\u0003\u0002~\nE\u0002bBApI\u0001\u0007\u0011\u0011]\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\u000f\u0005o\u00119G!\u001d\u0003|\t\u0015%\u0011\u0012BX!\u0019\tyP!\u0004\u0003:A1!1\bB\u001f\u0005\u0003j!A!\u0002\n\t\t}\"Q\u0001\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003D\t\u0005d\u0002\u0002B#\u00057rAAa\u0012\u0003X9!!\u0011\nB+\u001d\u0011\u0011YEa\u0015\u000f\t\t5#\u0011\u000b\b\u0004m\n=\u0013\"\u00017\n\u0005)\\\u0017BA\"j\u0013\r\ty\u0001[\u0005\u0005\u00053\ni!A\u0004nKN\u001c\u0018mZ3\n\t\tu#qL\u0001\u0019\t\u0016dW\r^3U_BL7m\u001d*fgB|gn]3ECR\f'\u0002\u0002B-\u0003\u001bIAAa\u0019\u0003f\t!B)\u001a7fi\u0006\u0014G.\u001a+pa&\u001c'+Z:vYRTAA!\u0018\u0003`!9!\u0011N\u0013A\u0002\t-\u0014aB2p]R,\u0007\u0010\u001e\t\u0005\u0003;\u0011i'\u0003\u0003\u0003p\u0005}!\u0001G\"p]R\u0014x\u000e\u001c7feJ+\u0017/^3ti\u000e{g\u000e^3yi\"9\u0011q\\\u0013A\u0002\tM\u0004\u0003\u0002B;\u0005oj!Aa\u0018\n\t\te$q\f\u0002\u0018\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006DqA! &\u0001\u0004\u0011y(\u0001\u0006ba&4VM]:j_:\u00042a\u0012BA\u0013\r\u0011\u0019\t\u0013\u0002\u0004\u0013:$\bb\u0002BDK\u0001\u0007\u0011\u0011Z\u0001\u000fQ\u0006\u001c8\t\\;ti\u0016\u0014\u0018)\u001e;i\u0011\u001d\u0011Y)\na\u0001\u0005\u001b\u000bAcZ3u\t\u0016\u001c8M]5cC\ndW\rV8qS\u000e\u001c\bcB$\u0003\u0010\nM%\u0011V\u0005\u0004\u0005#C%!\u0003$v]\u000e$\u0018n\u001c82!\u0019\t\tG!&\u0003\u001a&!!qSA8\u0005!IE/\u001a:bE2,\u0007\u0003\u0002BN\u0005GsAA!(\u0003 B\u0011a\u000fS\u0005\u0004\u0005CC\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003&\n\u001d&AB*ue&twMC\u0002\u0003\"\"\u0003bAa'\u0003,\ne\u0015\u0002\u0002BW\u0005O\u00131aU3u\u0011\u001d\u0011\t,\na\u0001\u0005\u001b\u000b!cZ3u\t\u0016dW\r^1cY\u0016$v\u000e]5dg\u0006\u0011\u0002.\u00198eY\u0016\u001c%/Z1uKR{\u0007/[2t)\u0011\tiPa.\t\u000f\u0005}g\u00051\u0001\u0002b\u0006\u00113m\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019*fG>\u0014H-\u001a:G_J$BA!0\u0003bJ1!q\u0018Bb\u0005\u001f4aA!1(\u0001\tu&\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003\u0002Bc\u0005\u0017l!Aa2\u000b\t\t%'\u0011B\u0001\u0005Y\u0006tw-\u0003\u0003\u0003N\n\u001d'AB(cU\u0016\u001cG\u000f\u0005\u0004\u0003R\n]'1\\\u0007\u0003\u0005'TAA!6\u0003\u0006\u0005Aa-\u001e8di&|g.\u0003\u0003\u0003Z\nM'\u0001C\"p]N,X.\u001a:\u0011\t\t\u0015'Q\\\u0005\u0005\u0005?\u00149MA\u0004J]R,w-\u001a:\t\u000f\t\rx\u00051\u0001\u0003f\u000692m\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\t\u0004\u001b\n\u001d\u0018b\u0001Bu\u0001\n92i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/Y\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\r\u0005_\u00149P!?\u0004\u0002\r\r1q\u0001\t\u0007\u0003\u007f\u0014iA!=\u0011\t\tU$1_\u0005\u0005\u0005k\u0014yF\u0001\rDe\u0016\fG/\u001a+pa&\u001c7OU3ta>t7/\u001a#bi\u0006DqA!\u001b)\u0001\u0004\u0011Y\u0007C\u0004\u0002`\"\u0002\rAa?\u0011\t\tU$Q`\u0005\u0005\u0005\u007f\u0014yFA\fDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC\"9!q\u0011\u0015A\u0002\u0005%\u0007bBB\u0003Q\u0001\u0007!QR\u0001\u0013O\u0016$8I]3bi\u0006\u0014G.\u001a+pa&\u001c7\u000fC\u0004\u0003\f\"\u0002\rA!$\u00021!\fg\u000e\u001a7f\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002~\u000e5\u0001bBApS\u0001\u0007\u0011\u0011]\u0001\u0017CV$\bn\u001c:ju\u0016\fE\u000e^3s%\u0016\u001cx.\u001e:dKR111CB\u0010\u0007S\u0001Ba!\u0006\u0004\u001c5\u00111q\u0003\u0006\u0005\u00073\ti!\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019iba\u0006\u0003\u0011\u0005\u0003\u0018.\u0012:s_JDqa!\t+\u0001\u0004\u0019\u0019#\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\rU1QE\u0005\u0005\u0007O\u00199B\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\t\u000f\r-\"\u00061\u0001\u0004.\u0005A!/Z:pkJ\u001cW\r\u0005\u0003\u00040\rMRBAB\u0019\u0015\u0011\t\u0019%!\u0004\n\t\rU2\u0011\u0007\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0003aA\u0017M\u001c3mK2+w-Y2z\u00032$XM]\"p]\u001aLwm\u001d\u000b\u0005\u0003{\u001cY\u0004C\u0004\u0002`.\u0002\r!!9\u0002\u0015!\fg\u000e\u001a7f->$X\r\u0006\u0003\u0002~\u000e\u0005\u0003bBApY\u0001\u0007\u0011\u0011]\u0001\u0017Q\u0006tG\r\\3CK\u001eLg.U;peVlW\t]8dQR!\u0011Q`B$\u0011\u001d\ty.\fa\u0001\u0003C\fA\u0003[1oI2,WI\u001c3Rk>\u0014X/\\#q_\u000eDG\u0003BA\u007f\u0007\u001bBq!a8/\u0001\u0004\t\t/\u0001\u000biC:$G.\u001a#fg\u000e\u0014\u0018NY3Rk>\u0014X/\u001c\u000b\u0005\u0003{\u001c\u0019\u0006C\u0004\u0002`>\u0002\r!!9\u0002%!\fg\u000e\u001a7f\u000b2,7\r\u001e'fC\u0012,'o\u001d\u000b\u0005\u0003{\u001cI\u0006C\u0004\u0002`B\u0002\r!!9\u00027!\fg\u000e\u001a7f\u00032$XM\u001d)beRLG/[8o%\u0016\fX/Z:u)\u0011\tipa\u0018\t\u000f\u0005}\u0017\u00071\u0001\u0002b\u0006a\u0002.\u00198eY\u0016\u0014%o\\6fe\"+\u0017M\u001d;CK\u0006$(+Z9vKN$H\u0003BA\u007f\u0007KBq!a83\u0001\u0004\t\t/\u0001\fiC:$G.Z+oe\u0016<\u0017n\u001d;fe\n\u0013xn[3s)\u0011\tipa\u001b\t\u000f\u0005}7\u00071\u0001\u0002b\u0006A\u0002.\u00198eY\u0016\u0014%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8\u0015\t\u0005u8\u0011\u000f\u0005\b\u0003?$\u0004\u0019AAq\u0003EA\u0017M\u001c3mKJ\u000bg\r\u001e*fcV,7\u000f\u001e\u000b\u0007\u0003{\u001c9h!\u001f\t\u000f\u0005}W\u00071\u0001\u0002b\"911P\u001bA\u0002\ru\u0014!\u00042vS2$'+Z:q_:\u001cX\rE\u0004H\u0005\u001f\u001byha#\u0011\t\r\u00055qQ\u0007\u0003\u0007\u0007SAa!\"\u0002\u000e\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0004\n\u000e\r%AC!qS6+7o]1hKB!1QCBG\u0013\u0011\u0019yia\u0006\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017a\u00065b]\u0012dW-\u00117uKJ\u001cE.[3oiF+x\u000e^1t)\u0011\tip!&\t\u000f\u0005}g\u00071\u0001\u0002b\u0006i\u0002.\u00198eY\u0016Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000f\u0006\u0003\u0002~\u000em\u0005bBApo\u0001\u0007\u0011\u0011]\u0001\u0017Q\u0006tG\r\\3De\u0016\fG/\u001a)beRLG/[8ogR!\u0011Q`BQ\u0011\u001d\ty\u000e\u000fa\u0001\u0003C\f\u0001c\u0019:fCR,\u0007+\u0019:uSRLwN\\:\u0015\u0011\r\u001d6\u0011XB^\u0007\u0007\u0004b!a@\u0003\u000e\r%\u0006C\u0002B\u001e\u0005{\u0019Y\u000b\u0005\u0003\u0004.\u000eMf\u0002\u0002B#\u0007_KAa!-\u0003`\u0005a2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0017\u0002BB[\u0007o\u00131d\u0011:fCR,\u0007+\u0019:uSRLwN\\:U_BL7MU3tk2$(\u0002BBY\u0005?BqA!\u001b:\u0001\u0004\u0011Y\u0007C\u0004\u0002`f\u0002\ra!0\u0011\t\tU4qX\u0005\u0005\u0007\u0003\u0014yFA\u000eDe\u0016\fG/\u001a)beRLG/[8ogJ+\u0017/^3ti\u0012\u000bG/\u0019\u0005\b\u0007\u000bL\u0004\u0019\u0001BG\u0003a9W\r^!mi\u0016\u0014\u0018)\u001e;i_JL'0\u001a3U_BL7m]\u0001\"Q\u0006tG\r\\3BYR,'\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGo\u001d\u000b\u0005\u0003{\u001cY\rC\u0004\u0002`j\u0002\r!!9\u0002?!\fg\u000e\u001a7f\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7\u000f\u0006\u0003\u0002~\u000eE\u0007bBApw\u0001\u0007\u0011\u0011]\u0001!Q\u0006tG\r\\3MSN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$8\u000f\u0006\u0003\u0002~\u000e]\u0007bBApy\u0001\u0007\u0011\u0011]\u0001!Q\u0006tG\r\\3BY2|7-\u0019;f!J|G-^2fe&#7OU3rk\u0016\u001cH\u000f\u0006\u0003\u0002~\u000eu\u0007bBAp{\u0001\u0007\u0011\u0011]\u0001\u0015Q\u0006tG\r\\3Va\u0012\fG/\u001a$fCR,(/Z:\u0015\t\u0005u81\u001d\u0005\b\u0003?t\u0004\u0019AAq\u0001")
public class ControllerApis
implements ApiRequestHandler,
Logging {
    private final RequestChannel requestChannel;
    private final Option<Authorizer> authorizer;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;
    private final Controller controller;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final KafkaConfig config;
    private final MetaProperties metaProperties;
    private final Seq<Node> controllerNodes;
    private final ApiVersionManager apiVersionManager;
    private final AuthHelper authHelper;
    private final RequestHandlerHelper requestHelper;
    private final AclApis aclApis;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    public Time time() {
        return this.time;
    }

    public Controller controller() {
        return this.controller;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public Seq<Node> controllerNodes() {
        return this.controllerNodes;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public AuthHelper authHelper() {
        return this.authHelper;
    }

    public RequestHandlerHelper requestHelper() {
        return this.requestHelper;
    }

    private AclApis aclApis() {
        return this.aclApis;
    }

    public boolean isClosed() {
        return this.aclApis().isClosed();
    }

    public void close() {
        this.aclApis().close();
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        try {
            try {
                CompletableFuture<BoxedUnit> completableFuture;
                ApiKeys apiKeys = request.header().apiKey();
                if (ApiKeys.FETCH.equals(apiKeys)) {
                    completableFuture = this.handleFetch(request);
                } else if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                    completableFuture = this.handleFetchSnapshot(request);
                } else if (ApiKeys.CREATE_TOPICS.equals(apiKeys)) {
                    completableFuture = this.handleCreateTopics(request);
                } else if (ApiKeys.DELETE_TOPICS.equals(apiKeys)) {
                    completableFuture = this.handleDeleteTopics(request);
                } else if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                    completableFuture = this.handleApiVersionsRequest(request);
                } else if (ApiKeys.ALTER_CONFIGS.equals(apiKeys)) {
                    completableFuture = this.handleLegacyAlterConfigs(request);
                } else if (ApiKeys.VOTE.equals(apiKeys)) {
                    completableFuture = this.handleVote(request);
                } else if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                    completableFuture = this.handleBeginQuorumEpoch(request);
                } else if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                    completableFuture = this.handleEndQuorumEpoch(request);
                } else if (ApiKeys.DESCRIBE_QUORUM.equals(apiKeys)) {
                    completableFuture = this.handleDescribeQuorum(request);
                } else if (ApiKeys.ALTER_PARTITION.equals(apiKeys)) {
                    completableFuture = this.handleAlterPartitionRequest(request);
                } else if (ApiKeys.BROKER_REGISTRATION.equals(apiKeys)) {
                    completableFuture = this.handleBrokerRegistration(request);
                } else if (ApiKeys.BROKER_HEARTBEAT.equals(apiKeys)) {
                    completableFuture = this.handleBrokerHeartBeatRequest(request);
                } else if (ApiKeys.UNREGISTER_BROKER.equals(apiKeys)) {
                    completableFuture = this.handleUnregisterBroker(request);
                } else if (ApiKeys.ALTER_CLIENT_QUOTAS.equals(apiKeys)) {
                    completableFuture = this.handleAlterClientQuotas(request);
                } else if (ApiKeys.INCREMENTAL_ALTER_CONFIGS.equals(apiKeys)) {
                    completableFuture = this.handleIncrementalAlterConfigs(request);
                } else if (ApiKeys.ALTER_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    completableFuture = this.handleAlterPartitionReassignments(request);
                } else if (ApiKeys.LIST_PARTITION_REASSIGNMENTS.equals(apiKeys)) {
                    completableFuture = this.handleListPartitionReassignments(request);
                } else if (ApiKeys.ALTER_USER_SCRAM_CREDENTIALS.equals(apiKeys)) {
                    completableFuture = this.handleAlterUserScramCredentials(request);
                } else if (ApiKeys.ENVELOPE.equals(apiKeys)) {
                    completableFuture = this.handleEnvelopeRequest(request, requestLocal);
                } else if (ApiKeys.SASL_HANDSHAKE.equals(apiKeys)) {
                    completableFuture = this.handleSaslHandshakeRequest(request);
                } else if (ApiKeys.SASL_AUTHENTICATE.equals(apiKeys)) {
                    completableFuture = this.handleSaslAuthenticateRequest(request);
                } else if (ApiKeys.ALLOCATE_PRODUCER_IDS.equals(apiKeys)) {
                    completableFuture = this.handleAllocateProducerIdsRequest(request);
                } else if (ApiKeys.CREATE_PARTITIONS.equals(apiKeys)) {
                    completableFuture = this.handleCreatePartitions(request);
                } else if (ApiKeys.DESCRIBE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleDescribeAcls(request);
                } else if (ApiKeys.CREATE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleCreateAcls(request);
                } else if (ApiKeys.DELETE_ACLS.equals(apiKeys)) {
                    completableFuture = this.aclApis().handleDeleteAcls(request);
                } else if (ApiKeys.ELECT_LEADERS.equals(apiKeys)) {
                    completableFuture = this.handleElectLeaders(request);
                } else if (ApiKeys.UPDATE_FEATURES.equals(apiKeys)) {
                    completableFuture = this.handleUpdateFeatures(request);
                } else {
                    throw new ApiException(new StringBuilder(19).append("Unsupported ApiKey ").append(request.context().header.apiKey()).toString());
                }
                completableFuture.whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        this.requestHelper().handleError(request, (Throwable)exception);
                        return;
                    }
                });
            }
            catch (FatalExitError fatalExitError) {
                throw fatalExitError;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Unexpected error handling request ").append(request.requestDesc(true)).append(" ").append("with context ").append(request.context()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                this.requestHelper().handleError(request, t);
            }
        }
        finally {
            if (request.apiLocalCompleteTimeNanos() < 0L) {
                request.apiLocalCompleteTimeNanos_$eq(this.time().nanoseconds());
            }
        }
    }

    public CompletableFuture<BoxedUnit> handleEnvelopeRequest(RequestChannel.Request request, RequestLocal requestLocal) {
        if (!this.authHelper().authorize(request.context(), AclOperation.CLUSTER_ACTION, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
            this.requestHelper().sendErrorResponseMaybeThrottle(request, (Throwable)new ClusterAuthorizationException(new StringBuilder(61).append("Principal ").append(request.context().principal).append(" does not have required CLUSTER_ACTION for envelope").toString()));
        } else {
            EnvelopeUtils$.MODULE$.handleEnvelopeRequest(request, this.requestChannel().metrics(), (Function1<RequestChannel.Request, BoxedUnit>)(Function1 & Serializable)x$2 -> {
                this.handle(x$2, requestLocal);
                return BoxedUnit.UNIT;
            });
        }
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleSaslHandshakeRequest(RequestChannel.Request request) {
        SaslHandshakeResponseData responseData = new SaslHandshakeResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code());
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$3 -> ControllerApis.$anonfun$handleSaslHandshakeRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$3)));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleSaslAuthenticateRequest(RequestChannel.Request request) {
        SaslAuthenticateResponseData responseData = new SaslAuthenticateResponseData().setErrorCode(Errors.ILLEGAL_SASL_STATE.code()).setErrorMessage("SaslAuthenticate request received after successful authentication");
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)x$4 -> ControllerApis.$anonfun$handleSaslAuthenticateRequest$1(responseData, BoxesRunTime.unboxToInt((Object)x$4)));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleFetch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleFetchSnapshot(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleDeleteTopics(RequestChannel.Request request) {
        DeleteTopicsRequest deleteTopicsRequest = (DeleteTopicsRequest)request.body(ClassTag$.MODULE$.apply(DeleteTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerMutationQuota controllerMutationQuota = this.quotas().controllerMutation().newQuotaFor(request, (short)5);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)deleteTopicsRequest.data().timeoutMs()), (Consumer)new Consumer<Integer>(null, controllerMutationQuota){
            private final ControllerMutationQuota controllerMutationQuota$3;

            public Consumer<Integer> andThen(Consumer<? super Integer> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(Integer permits) {
                this.controllerMutationQuota$3.record(permits.doubleValue());
            }
            {
                this.controllerMutationQuota$3 = controllerMutationQuota$3;
            }
        });
        RequestContext x$1 = request.context();
        boolean x$6 = this.authHelper().authorize$default$5();
        int x$7 = this.authHelper().authorize$default$7();
        return this.deleteTopics(context, deleteTopicsRequest.data(), request.context().apiVersion(), this.authHelper().authorize(x$1, AclOperation.DELETE, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DESCRIBE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.DELETE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n)).handle((results, exception) -> {
            ControllerApis.$anonfun$handleDeleteTopics$5(this, controllerMutationQuota, request, deleteTopicsRequest, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<List<DeleteTopicsResponseData.DeletableTopicResult>> deleteTopics(ControllerRequestContext context, DeleteTopicsRequestData request, int apiVersion, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDeletableTopics) {
        if (!Predef$.MODULE$.Boolean2boolean(this.config().deleteTopicEnable())) {
            if (apiVersion < 3) {
                throw new InvalidRequestException("Topic deletion is disabled.");
            }
            throw new TopicDeletionDisabledException();
        }
        ArrayList responses = new ArrayList();
        HashSet providedNames = new HashSet();
        HashSet duplicateProvidedNames = new HashSet();
        HashSet providedIds = new HashSet();
        HashSet duplicateProvidedIds = new HashSet();
        request.topicNames().forEach(name -> ControllerApis.addProvidedName$1(name, duplicateProvidedNames, providedNames));
        request.topics().forEach(topic -> {
            if (topic.name() == null) {
                if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                    ControllerApis.appendResponse$1(null, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Neither topic name nor id were specified."), responses);
                    return;
                }
                if (duplicateProvidedIds.contains(topic.topicId()) || !providedIds.add(topic.topicId())) {
                    duplicateProvidedIds.add(topic.topicId());
                    providedIds.remove(topic.topicId());
                    return;
                }
                return;
            }
            if (topic.topicId().equals((Object)Uuid.ZERO_UUID)) {
                ControllerApis.addProvidedName$1(topic.name(), duplicateProvidedNames, providedNames);
                return;
            }
            ControllerApis.appendResponse$1(topic.name(), topic.topicId(), new ApiError(Errors.INVALID_REQUEST, "You may not specify both topic name and topic id."), responses);
        });
        duplicateProvidedNames.forEach(name -> ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic name."), responses));
        duplicateProvidedIds.forEach(id -> ControllerApis.appendResponse$1(null, id, new ApiError(Errors.INVALID_REQUEST, "Duplicate topic id."), responses));
        HashSet toAuthenticate = new HashSet();
        toAuthenticate.addAll(providedNames);
        HashMap idToName = new HashMap();
        return this.controller().findTopicNames(context, providedIds).thenCompose(topicNames -> {
            void var12_13;
            void var13_14;
            Object object;
            Object object2;
            topicNames.forEach((id, nameOrError) -> {
                if (nameOrError.isError()) {
                    ControllerApis.appendResponse$1(null, id, nameOrError.error(), responses);
                    return;
                }
                toAuthenticate.add(nameOrError.result());
                idToName.put(id, nameOrError.result());
            });
            scala.collection.mutable.Set topicsToAuthenticate = CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)toAuthenticate).asScala();
            if (hasClusterAuth) {
                object2 = topicsToAuthenticate.toSet();
                object = topicsToAuthenticate.toSet();
            } else {
                object2 = getDescribableTopics.apply((Object)topicsToAuthenticate);
                object = getDeletableTopics.apply((Object)topicsToAuthenticate);
            }
            scala.collection.immutable.Set set = object;
            Object describable = object2;
            scala.collection.immutable.Set deletable = set;
            Iterator iterator = idToName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Uuid id2 = (Uuid)entry.getKey();
                String name = (String)entry.getValue();
                if (var13_14.contains((Object)name)) continue;
                if (var12_13.contains((Object)name)) {
                    ControllerApis.appendResponse$1(name, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                } else {
                    ControllerApis.appendResponse$1(null, id2, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses);
                }
                iterator.remove();
            }
            return this.controller().findTopicIds(context, (Collection)providedNames).thenCompose(arg_0 -> ControllerApis.$anonfun$deleteTopics$7(this, (scala.collection.immutable.Set)var12_13, (scala.collection.immutable.Set)var13_14, duplicateProvidedIds, idToName, context, responses, arg_0));
        });
    }

    public CompletableFuture<BoxedUnit> handleCreateTopics(RequestChannel.Request request) {
        CreateTopicsRequest createTopicsRequest = (CreateTopicsRequest)request.body(ClassTag$.MODULE$.apply(CreateTopicsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerMutationQuota controllerMutationQuota = this.quotas().controllerMutation().newQuotaFor(request, (short)6);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)createTopicsRequest.data().timeoutMs()), (Consumer)new /* invalid duplicate definition of identical inner class */);
        RequestContext x$1 = request.context();
        boolean x$6 = this.authHelper().authorize$default$5();
        int x$7 = this.authHelper().authorize$default$7();
        return this.createTopics(context, createTopicsRequest.data(), this.authHelper().authorize(x$1, AclOperation.CREATE, ResourceType.CLUSTER, "kafka-cluster", x$6, false, x$7), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> this.authHelper().filterByAuthorized(request.context(), AclOperation.CREATE, ResourceType.TOPIC, names, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x)), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)names -> {
            RequestContext x$8 = request.context();
            boolean x$13 = this.authHelper().filterByAuthorized$default$5();
            Function1 & Serializable x$14 = (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
            return this.authHelper().filterByAuthorized(x$8, AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, names, x$13, false, x$14);
        }).handle((result, exception) -> {
            ControllerApis.$anonfun$handleCreateTopics$5(this, controllerMutationQuota, request, createTopicsRequest, result, exception);
            return BoxedUnit.UNIT;
        });
    }

    private Consumer<Integer> controllerMutationQuotaRecorderFor(ControllerMutationQuota controllerMutationQuota) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext context, CreateTopicsRequestData request, boolean hasClusterAuth, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getCreatableTopics, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getDescribableTopics) {
        HashSet topicNames = new HashSet();
        HashSet duplicateTopicNames = new HashSet();
        request.topics().forEach(topicData -> {
            if (!duplicateTopicNames.contains(topicData.name())) {
                if (!topicNames.add(topicData.name())) {
                    topicNames.remove(topicData.name());
                    duplicateTopicNames.add(topicData.name());
                    return;
                }
                return;
            }
        });
        if (topicNames.contains("__cluster_metadata")) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Rejecting creation of internal topic ").append("__cluster_metadata").toString());
        }
        scala.collection.mutable.Set allowedTopicNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala().diff((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"__cluster_metadata"})));
        scala.collection.mutable.Set authorizedTopicNames = hasClusterAuth ? allowedTopicNames : (Set)getCreatableTopics.apply((Object)allowedTopicNames);
        java.util.Set describableTopicNames = CollectionConverters$.MODULE$.SetHasAsJava((Set)getDescribableTopics.apply((Object)allowedTopicNames)).asJava();
        CreateTopicsRequestData effectiveRequest = request.duplicate();
        Iterator iterator = effectiveRequest.topics().iterator();
        while (iterator.hasNext()) {
            CreateTopicsRequestData.CreatableTopic creatableTopic = (CreateTopicsRequestData.CreatableTopic)iterator.next();
            if (!duplicateTopicNames.contains(creatableTopic.name()) && authorizedTopicNames.contains((Object)creatableTopic.name())) continue;
            iterator.remove();
        }
        return this.controller().createTopics(context, effectiveRequest, describableTopicNames).thenApply(arg_0 -> ControllerApis.$anonfun$createTopics$3(duplicateTopicNames, topicNames, (Set)authorizedTopicNames, arg_0));
    }

    public CompletableFuture<BoxedUnit> handleApiVersionsRequest(RequestChannel.Request request) {
        this.requestHelper().sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> this.createResponseCallback$1(BoxesRunTime.unboxToInt((Object)requestThrottleMs), request));
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public ApiError authorizeAlterResource(RequestContext requestContext, ConfigResource resource) {
        ConfigResource.Type type = resource.type();
        if (ConfigResource.Type.BROKER.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.CLUSTER, "kafka-cluster", this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.CLUSTER_AUTHORIZATION_FAILED);
        }
        if (ConfigResource.Type.TOPIC.equals(type)) {
            if (this.authHelper().authorize(requestContext, AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, resource.name(), this.authHelper().authorize$default$5(), this.authHelper().authorize$default$6(), this.authHelper().authorize$default$7())) {
                return new ApiError(Errors.NONE);
            }
            return new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED);
        }
        return new ApiError(Errors.INVALID_REQUEST, new StringBuilder(26).append("Unexpected resource type ").append(type).append(".").toString());
    }

    public CompletableFuture<BoxedUnit> handleLegacyAlterConfigs(RequestChannel.Request request) {
        AlterConfigsResponseData response = new AlterConfigsResponseData();
        AlterConfigsRequest alterConfigsRequest = (AlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(AlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap configs = new HashMap();
                resource.configs().forEach(config -> configs.put(config.name(), config.value()));
                if (configChanges.put(configResource, configs) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        return this.controller().legacyAlterConfigs(context, configChanges, alterConfigsRequest.data().validateOnly()).handle((controllerResults, exception) -> {
            ControllerApis.$anonfun$handleLegacyAlterConfigs$3(this, request, response, controllerResults, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleVote(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBeginQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleEndQuorumEpoch(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleDescribeQuorum(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        Function1 & Serializable handleRaftRequest_buildResponse = (Function1 & Serializable)response -> new DescribeQuorumResponse((DescribeQuorumResponseData)response);
        Object handleRaftRequest_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), handleRaftRequest_requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleElectLeaders(RequestChannel.Request request) {
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ElectLeadersRequest electLeadersRequest = (ElectLeadersRequest)request.body(ClassTag$.MODULE$.apply(ElectLeadersRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)electLeadersRequest.data().timeoutMs()));
        return this.controller().electLeaders(context, electLeadersRequest.data()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleElectLeaders$1(this, request, electLeadersRequest, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterPartitionRequest(RequestChannel.Request request) {
        AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        return this.controller().alterPartition(context, alterPartitionRequest.data()).handle((result, exception) -> {
            ControllerApis.$anonfun$handleAlterPartitionRequest$1(this, alterPartitionRequest, request, result, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBrokerHeartBeatRequest(RequestChannel.Request request) {
        BrokerHeartbeatRequest heartbeatRequest = (BrokerHeartbeatRequest)request.body(ClassTag$.MODULE$.apply(BrokerHeartbeatRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)(this.config().brokerHeartbeatIntervalMs() / 2)));
        return this.controller().processBrokerHeartbeat(context, heartbeatRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerHeartBeatRequest$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleUnregisterBroker(RequestChannel.Request request) {
        UnregisterBrokerRequest decommissionRequest = (UnregisterBrokerRequest)request.body(ClassTag$.MODULE$.apply(UnregisterBrokerRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().unregisterBroker(context, decommissionRequest.data().brokerId()).handle((x$6, e) -> {
            ControllerApis.$anonfun$handleUnregisterBroker$1(this, request, x$6, e);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleBrokerRegistration(RequestChannel.Request request) {
        BrokerRegistrationRequest registrationRequest = (BrokerRegistrationRequest)request.body(ClassTag$.MODULE$.apply(BrokerRegistrationRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().registerBroker(context, registrationRequest.data()).handle((reply, e) -> {
            ControllerApis.$anonfun$handleBrokerRegistration$1(this, request, reply, e);
            return BoxedUnit.UNIT;
        });
    }

    private CompletableFuture<BoxedUnit> handleRaftRequest(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return this.raftManager().handleRequest(request.header(), requestBody.data(), this.time().milliseconds()).handle((responseData, exception) -> {
            ControllerApis.$anonfun$handleRaftRequest$1(this, handleRaftRequest_requestBody, handleRaftRequest_buildResponse, request, responseData, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterClientQuotas(RequestChannel.Request request) {
        AlterClientQuotasRequest quotaRequest = (AlterClientQuotasRequest)request.body(ClassTag$.MODULE$.apply(AlterClientQuotasRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER_CONFIGS);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().alterClientQuotas(context, (Collection)quotaRequest.entries(), quotaRequest.validateOnly()).handle((results, exception) -> {
            ControllerApis.$anonfun$handleAlterClientQuotas$1(this, request, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleIncrementalAlterConfigs(RequestChannel.Request request) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        IncrementalAlterConfigsRequest alterConfigsRequest = (IncrementalAlterConfigsRequest)request.body(ClassTag$.MODULE$.apply(IncrementalAlterConfigsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        HashSet duplicateResources = new HashSet();
        HashMap configChanges = new HashMap();
        alterConfigsRequest.data().resources().forEach(resource -> {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)resource.resourceType()), resource.resourceName());
            if (configResource.type().equals((Object)ConfigResource.Type.UNKNOWN)) {
                response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage(new StringBuilder(23).append("Unknown resource type ").append(resource.resourceType()).append(".").toString()).setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                return;
            }
            if (!duplicateResources.contains(configResource)) {
                HashMap altersByName = new HashMap();
                resource.configs().forEach(config -> altersByName.put(config.name(), new AbstractMap.SimpleEntry<AlterConfigOp.OpType, String>(AlterConfigOp.OpType.forId((byte)config.configOperation()), config.value())));
                if (configChanges.put(configResource, altersByName) != null) {
                    duplicateResources.add(configResource);
                    configChanges.remove(configResource);
                    response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName(resource.resourceName()).setResourceType(resource.resourceType()));
                    return;
                }
                return;
            }
        });
        Iterator iterator = configChanges.keySet().iterator();
        while (iterator.hasNext()) {
            ConfigResource resource2 = (ConfigResource)iterator.next();
            ApiError apiError = this.authorizeAlterResource(request.context(), resource2);
            if (!apiError.isFailure()) continue;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setResourceName(resource2.name()).setResourceType(resource2.type().id()));
            iterator.remove();
        }
        return this.controller().incrementalAlterConfigs(context, configChanges, alterConfigsRequest.data().validateOnly()).handle((controllerResults, exception) -> {
            ControllerApis.$anonfun$handleIncrementalAlterConfigs$3(this, request, response, controllerResults, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleCreatePartitions(RequestChannel.Request request) {
        CreatePartitionsRequest createPartitionsRequest = (CreatePartitionsRequest)request.body(ClassTag$.MODULE$.apply(CreatePartitionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        ControllerMutationQuota controllerMutationQuota = this.quotas().controllerMutation().newQuotaFor(request, (short)3);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)createPartitionsRequest.data().timeoutMs()), (Consumer)new /* invalid duplicate definition of identical inner class */);
        return this.createPartitions(context, createPartitionsRequest.data(), (Function1<Iterable<String>, scala.collection.immutable.Set<String>>)(Function1 & Serializable)topics -> this.filterAlterAuthorizedTopics$1((Iterable)topics, request)).handle((responses, exception) -> {
            ControllerApis.$anonfun$handleCreatePartitions$3(this, request, controllerMutationQuota, responses, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext context, CreatePartitionsRequestData request, Function1<Iterable<String>, scala.collection.immutable.Set<String>> getAlterAuthorizedTopics) {
        ArrayList responses = new ArrayList();
        HashSet duplicateTopicNames = new HashSet();
        HashSet topicNames = new HashSet();
        request.topics().forEach(topic -> {
            if (!topicNames.add(topic.name())) {
                duplicateTopicNames.add(topic.name());
                return;
            }
        });
        duplicateTopicNames.forEach(topicName -> {
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."));
            topicNames.remove(topicName);
        });
        scala.collection.immutable.Set authorizedTopicNames = (scala.collection.immutable.Set)getAlterAuthorizedTopics.apply((Object)CollectionConverters$.MODULE$.SetHasAsScala(topicNames).asScala());
        ArrayList topics = new ArrayList();
        topicNames.forEach(topicName -> {
            if (authorizedTopicNames.contains(topicName)) {
                topics.add(request.topics().find(topicName));
                return;
            }
            responses.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topicName).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()));
        });
        return this.controller().createPartitions(context, topics, request.validateOnly()).thenApply(results -> {
            results.forEach(response -> responses.add(response));
            return responses;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterPartitionReassignments(RequestChannel.Request request) {
        AlterPartitionReassignmentsRequest alterRequest = (AlterPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(AlterPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, ControllerRequestContext.requestTimeoutMsToDeadlineNs((Time)this.time(), (int)alterRequest.data().timeoutMs()));
        return this.controller().alterPartitionReassignments(context, alterRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleAlterPartitionReassignments$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAlterUserScramCredentials(RequestChannel.Request request) {
        AlterUserScramCredentialsRequest alterRequest = (AlterUserScramCredentialsRequest)request.body(ClassTag$.MODULE$.apply(AlterUserScramCredentialsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().alterUserScramCredentials(context, alterRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleAlterUserScramCredentials$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleListPartitionReassignments(RequestChannel.Request request) {
        ListPartitionReassignmentsRequest listRequest = (ListPartitionReassignmentsRequest)request.body(ClassTag$.MODULE$.apply(ListPartitionReassignmentsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.DESCRIBE);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().listPartitionReassignments(context, listRequest.data()).thenApply(response -> {
            ControllerApis.$anonfun$handleListPartitionReassignments$1(this, request, response);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleAllocateProducerIdsRequest(RequestChannel.Request request) {
        AllocateProducerIdsRequest allocatedProducerIdsRequest = (AllocateProducerIdsRequest)request.body(ClassTag$.MODULE$.apply(AllocateProducerIdsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.CLUSTER_ACTION);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().allocateProducerIds(context, allocatedProducerIdsRequest.data()).handle((results, exception) -> {
            ControllerApis.$anonfun$handleAllocateProducerIdsRequest$1(this, request, results, exception);
            return BoxedUnit.UNIT;
        });
    }

    public CompletableFuture<BoxedUnit> handleUpdateFeatures(RequestChannel.Request request) {
        UpdateFeaturesRequest updateFeaturesRequest = (UpdateFeaturesRequest)request.body(ClassTag$.MODULE$.apply(UpdateFeaturesRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        this.authHelper().authorizeClusterOperation(request, AclOperation.ALTER);
        ControllerRequestContext context = new ControllerRequestContext(request.context().header.data(), request.context().principal, OptionalLong.empty());
        return this.controller().updateFeatures(context, updateFeaturesRequest.data()).handle((response, exception) -> {
            ControllerApis.$anonfun$handleUpdateFeatures$1(this, request, response, exception);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SaslHandshakeResponse $anonfun$handleSaslHandshakeRequest$1(SaslHandshakeResponseData responseData$1, int x$3) {
        return new SaslHandshakeResponse(responseData$1);
    }

    public static final /* synthetic */ SaslAuthenticateResponse $anonfun$handleSaslAuthenticateRequest$1(SaslAuthenticateResponseData responseData$2, int x$4) {
        return new SaslAuthenticateResponse(responseData$2);
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleDeleteTopics$6(Throwable exception$2, DeleteTopicsRequest deleteTopicsRequest$1, List results$1, int throttleTimeMs) {
        if (exception$2 != null) {
            return deleteTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$2);
        }
        DeleteTopicsResponseData responseData = new DeleteTopicsResponseData().setResponses(new DeleteTopicsResponseData.DeletableTopicResultCollection(results$1.iterator())).setThrottleTimeMs(throttleTimeMs);
        return new DeleteTopicsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$handleDeleteTopics$5(ControllerApis $this, ControllerMutationQuota controllerMutationQuota$1, RequestChannel.Request request$2, DeleteTopicsRequest deleteTopicsRequest$1, List results, Throwable exception) {
        $this.requestHelper().sendResponseMaybeThrottleWithControllerQuota(controllerMutationQuota$1, request$2, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleDeleteTopics$6(exception, deleteTopicsRequest$1, results, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    private static final void appendResponse$1(String name, Uuid id, ApiError error, ArrayList responses$1) {
        responses$1.add(new DeleteTopicsResponseData.DeletableTopicResult().setName(name).setTopicId(id).setErrorCode(error.error().code()).setErrorMessage(error.message()));
    }

    private static final void addProvidedName$1(String name, HashSet duplicateProvidedNames$1, HashSet providedNames$1) {
        if (duplicateProvidedNames$1.contains(name) || !providedNames$1.add(name)) {
            duplicateProvidedNames$1.add(name);
            providedNames$1.remove(name);
            return;
        }
    }

    public static final /* synthetic */ CompletableFuture $anonfun$deleteTopics$7(ControllerApis $this, scala.collection.immutable.Set describable$1, scala.collection.immutable.Set deletable$1, HashSet duplicateProvidedIds$1, HashMap idToName$1, ControllerRequestContext context$1, ArrayList responses$1, Map topicIds) {
        topicIds.forEach((name, idOrError) -> {
            if (!describable$1.contains(name)) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
                return;
            }
            if (idOrError.isError()) {
                ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, idOrError.error(), responses$1);
                return;
            }
            if (deletable$1.contains(name)) {
                Uuid id = (Uuid)idOrError.result();
                if (duplicateProvidedIds$1.contains(id) || idToName$1.put(id, name) != null) {
                    duplicateProvidedIds$1.add(id);
                    idToName$1.remove(id);
                    ControllerApis.appendResponse$1(name, id, new ApiError(Errors.INVALID_REQUEST, "The provided topic name maps to an ID that was already supplied."), responses$1);
                    return;
                }
                return;
            }
            ControllerApis.appendResponse$1(name, Uuid.ZERO_UUID, new ApiError(Errors.TOPIC_AUTHORIZATION_FAILED), responses$1);
        });
        return $this.controller().deleteTopics(context$1, idToName$1.keySet()).thenApply(idToError -> {
            idToError.forEach((id, error) -> ControllerApis.appendResponse$1((String)idToName$1.get(id), id, error, responses$1));
            Collections.shuffle(responses$1);
            return responses$1;
        });
    }

    public static final /* synthetic */ AbstractResponse $anonfun$handleCreateTopics$6(Throwable exception$3, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result$1, int throttleTimeMs) {
        if (exception$3 != null) {
            return createTopicsRequest$1.getErrorResponse(throttleTimeMs, exception$3);
        }
        result$1.setThrottleTimeMs(throttleTimeMs);
        return new CreateTopicsResponse(result$1);
    }

    public static final /* synthetic */ void $anonfun$handleCreateTopics$5(ControllerApis $this, ControllerMutationQuota controllerMutationQuota$2, RequestChannel.Request request$3, CreateTopicsRequest createTopicsRequest$1, CreateTopicsResponseData result, Throwable exception) {
        $this.requestHelper().sendResponseMaybeThrottleWithControllerQuota(controllerMutationQuota$2, request$3, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleTimeMs -> ControllerApis.$anonfun$handleCreateTopics$6(exception, createTopicsRequest$1, result, BoxesRunTime.unboxToInt((Object)throttleTimeMs)));
    }

    public static final /* synthetic */ CreateTopicsResponseData $anonfun$createTopics$3(HashSet duplicateTopicNames$1, HashSet topicNames$1, Set authorizedTopicNames$1, CreateTopicsResponseData response) {
        duplicateTopicNames$1.forEach(name -> response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name.")));
        topicNames$1.forEach(name -> {
            if (!authorizedTopicNames$1.contains(name)) {
                response.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(name).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage("Authorization failed."));
                return;
            }
        });
        return response;
    }

    private final ApiVersionsResponse createResponseCallback$1(int requestThrottleMs, RequestChannel.Request request$4) {
        ApiVersionsRequest apiVersionRequest = (ApiVersionsRequest)request$4.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        if (apiVersionRequest.hasUnsupportedRequestVersion()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.UNSUPPORTED_VERSION.exception());
        }
        if (!apiVersionRequest.isValid()) {
            return apiVersionRequest.getErrorResponse(requestThrottleMs, (Throwable)Errors.INVALID_REQUEST.exception());
        }
        return this.apiVersionManager().apiVersionResponse(requestThrottleMs);
    }

    public static final /* synthetic */ AlterConfigsResponse $anonfun$handleLegacyAlterConfigs$5(AlterConfigsResponseData response$2, int throttleMs) {
        return new AlterConfigsResponse(response$2.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleLegacyAlterConfigs$3(ControllerApis $this, RequestChannel.Request request$5, AlterConfigsResponseData response$2, Map controllerResults, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$5, exception);
            return;
        }
        controllerResults.entrySet().forEach(entry -> response$2.responses().add(new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
        $this.requestHelper().sendResponseMaybeThrottle(request$5, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleLegacyAlterConfigs$5(response$2, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    public static final /* synthetic */ ElectLeadersResponse $anonfun$handleElectLeaders$3(ElectLeadersResponseData responseData$3, int throttleMs) {
        return new ElectLeadersResponse(responseData$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleElectLeaders$1(ControllerApis $this, RequestChannel.Request request$6, ElectLeadersRequest electLeadersRequest$1, ElectLeadersResponseData responseData, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().sendResponseMaybeThrottle(request$6, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> electLeadersRequest$1.getErrorResponse(BoxesRunTime.unboxToInt((Object)throttleMs), exception));
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$6, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleElectLeaders$3(responseData, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionRequest$1(ControllerApis $this, AlterPartitionRequest alterPartitionRequest$1, RequestChannel.Request request$7, AlterPartitionResponseData result, Throwable exception) {
        AlterPartitionResponse response = exception != null ? alterPartitionRequest$1.getErrorResponse(exception) : new AlterPartitionResponse(result);
        $this.requestHelper().sendResponseExemptThrottle(request$7, (AbstractResponse)response, $this.requestHelper().sendResponseExemptThrottle$default$3());
    }

    private static final BrokerHeartbeatResponse createResponseCallback$2(int requestThrottleMs, BrokerHeartbeatReply reply, Throwable e) {
        if (e != null) {
            return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setIsCaughtUp(reply.isCaughtUp()).setIsFenced(reply.isFenced()).setShouldShutDown(reply.shouldShutDown()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerHeartBeatRequest$1(ControllerApis $this, RequestChannel.Request request$8, BrokerHeartbeatReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$8, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$2(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    private static final UnregisterBrokerResponse createResponseCallback$3(int requestThrottleMs, Throwable e) {
        if (e != null) {
            return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new UnregisterBrokerResponse(new UnregisterBrokerResponseData().setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUnregisterBroker$1(ControllerApis $this, RequestChannel.Request request$9, Void x$6, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$9, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$3(BoxesRunTime.unboxToInt((Object)requestThrottleMs), e));
    }

    private static final BrokerRegistrationResponse createResponseCallback$4(int requestThrottleMs, BrokerRegistrationReply reply, Throwable e) {
        if (e != null) {
            return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.forException((Throwable)e).code()));
        }
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(requestThrottleMs).setErrorCode(Errors.NONE.code()).setBrokerEpoch(reply.epoch()));
    }

    public static final /* synthetic */ void $anonfun$handleBrokerRegistration$1(ControllerApis $this, RequestChannel.Request request$10, BrokerRegistrationReply reply, Throwable e) {
        $this.requestHelper().sendResponseMaybeThrottle(request$10, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.createResponseCallback$4(BoxesRunTime.unboxToInt((Object)requestThrottleMs), reply, e));
    }

    public static final /* synthetic */ void $anonfun$handleRaftRequest$1(ControllerApis $this, AbstractRequest requestBody$1, Function1 buildResponse$1, RequestChannel.Request request$11, ApiMessage responseData, Throwable exception) {
        AbstractResponse response = exception != null ? requestBody$1.getErrorResponse(exception) : (AbstractResponse)buildResponse$1.apply((Object)responseData);
        $this.requestHelper().sendResponseExemptThrottle(request$11, response, $this.requestHelper().sendResponseExemptThrottle$default$3());
    }

    public static final /* synthetic */ AlterClientQuotasResponse $anonfun$handleAlterClientQuotas$2(Map results$2, int requestThrottleMs) {
        return AlterClientQuotasResponse.fromQuotaEntities((Map)results$2, (int)requestThrottleMs);
    }

    public static final /* synthetic */ void $anonfun$handleAlterClientQuotas$1(ControllerApis $this, RequestChannel.Request request$12, Map results, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$12, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$12, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterClientQuotas$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ IncrementalAlterConfigsResponse $anonfun$handleIncrementalAlterConfigs$5(IncrementalAlterConfigsResponseData response$3, int throttleMs) {
        return new IncrementalAlterConfigsResponse(response$3.setThrottleTimeMs(throttleMs));
    }

    public static final /* synthetic */ void $anonfun$handleIncrementalAlterConfigs$3(ControllerApis $this, RequestChannel.Request request$13, IncrementalAlterConfigsResponseData response$3, Map controllerResults, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$13, exception);
            return;
        }
        controllerResults.entrySet().forEach(entry -> response$3.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(((ApiError)entry.getValue()).error().code()).setErrorMessage(((ApiError)entry.getValue()).message()).setResourceName(((ConfigResource)entry.getKey()).name()).setResourceType(((ConfigResource)entry.getKey()).type().id())));
        $this.requestHelper().sendResponseMaybeThrottle(request$13, (Function1<Object, AbstractResponse>)(Function1 & Serializable)throttleMs -> ControllerApis.$anonfun$handleIncrementalAlterConfigs$5(response$3, BoxesRunTime.unboxToInt((Object)throttleMs)));
    }

    private final scala.collection.immutable.Set filterAlterAuthorizedTopics$1(Iterable topics, RequestChannel.Request request$14) {
        return this.authHelper().filterByAuthorized(request$14.context(), AclOperation.ALTER, ResourceType.TOPIC, topics, this.authHelper().filterByAuthorized$default$5(), this.authHelper().filterByAuthorized$default$6(), (Function1 & Serializable)n -> n);
    }

    public static final /* synthetic */ CreatePartitionsResponse $anonfun$handleCreatePartitions$4(List responses$2, int requestThrottleMs) {
        CreatePartitionsResponseData responseData = new CreatePartitionsResponseData().setResults(responses$2).setThrottleTimeMs(requestThrottleMs);
        return new CreatePartitionsResponse(responseData);
    }

    public static final /* synthetic */ void $anonfun$handleCreatePartitions$3(ControllerApis $this, RequestChannel.Request request$14, ControllerMutationQuota controllerMutationQuota$4, List responses, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$14, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottleWithControllerQuota(controllerMutationQuota$4, request$14, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleCreatePartitions$4(responses, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AlterPartitionReassignmentsResponse $anonfun$handleAlterPartitionReassignments$2(AlterPartitionReassignmentsResponseData response$4, int requestThrottleMs) {
        return new AlterPartitionReassignmentsResponse(response$4.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionReassignments$1(ControllerApis $this, RequestChannel.Request request$16, AlterPartitionReassignmentsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$16, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterPartitionReassignments$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AlterUserScramCredentialsResponse $anonfun$handleAlterUserScramCredentials$2(AlterUserScramCredentialsResponseData response$5, int requestThrottleMs) {
        return new AlterUserScramCredentialsResponse(response$5.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleAlterUserScramCredentials$1(ControllerApis $this, RequestChannel.Request request$17, AlterUserScramCredentialsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$17, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAlterUserScramCredentials$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ ListPartitionReassignmentsResponse $anonfun$handleListPartitionReassignments$2(ListPartitionReassignmentsResponseData response$6, int requestThrottleMs) {
        return new ListPartitionReassignmentsResponse(response$6.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleListPartitionReassignments$1(ControllerApis $this, RequestChannel.Request request$18, ListPartitionReassignmentsResponseData response) {
        $this.requestHelper().sendResponseMaybeThrottle(request$18, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleListPartitionReassignments$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ AllocateProducerIdsResponse $anonfun$handleAllocateProducerIdsRequest$2(AllocateProducerIdsResponseData results$3, int requestThrottleMs) {
        results$3.setThrottleTimeMs(requestThrottleMs);
        return new AllocateProducerIdsResponse(results$3);
    }

    public static final /* synthetic */ void $anonfun$handleAllocateProducerIdsRequest$1(ControllerApis $this, RequestChannel.Request request$19, AllocateProducerIdsResponseData results, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$19, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$19, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleAllocateProducerIdsRequest$2(results, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public static final /* synthetic */ UpdateFeaturesResponse $anonfun$handleUpdateFeatures$2(UpdateFeaturesResponseData response$7, int requestThrottleMs) {
        return new UpdateFeaturesResponse(response$7.setThrottleTimeMs(requestThrottleMs));
    }

    public static final /* synthetic */ void $anonfun$handleUpdateFeatures$1(ControllerApis $this, RequestChannel.Request request$20, UpdateFeaturesResponseData response, Throwable exception) {
        if (exception != null) {
            $this.requestHelper().handleError(request$20, exception);
            return;
        }
        $this.requestHelper().sendResponseMaybeThrottle(request$20, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> ControllerApis.$anonfun$handleUpdateFeatures$2(response, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
    }

    public ControllerApis(RequestChannel requestChannel, Option<Authorizer> authorizer, QuotaFactory.QuotaManagers quotas, Time time, Controller controller, RaftManager<ApiMessageAndVersion> raftManager, KafkaConfig config, MetaProperties metaProperties, Seq<Node> controllerNodes, ApiVersionManager apiVersionManager) {
        this.requestChannel = requestChannel;
        this.authorizer = authorizer;
        this.quotas = quotas;
        this.time = time;
        this.controller = controller;
        this.raftManager = raftManager;
        this.config = config;
        this.metaProperties = metaProperties;
        this.controllerNodes = controllerNodes;
        this.apiVersionManager = apiVersionManager;
        this.logIdent_$eq(new StringBuilder(25).append("[ControllerApis nodeId=").append(config.nodeId()).append("] ").toString());
        this.authHelper = new AuthHelper(authorizer);
        this.requestHelper = new RequestHandlerHelper(requestChannel, quotas, time);
        this.aclApis = new AclApis(this.authHelper(), authorizer, this.requestHelper(), "controller", config);
    }
}

