/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.UnifiedLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\ra\u0001\u0002\u001a4\u0005aB\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005'\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003u\u0011!Q\bA!A!\u0002\u0013Y\bBCA\u0002\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\ti\f\u0001C!\u0003\u007fCq!!1\u0001\t\u0003\n\u0019\rC\u0004\u0002H\u0002!\t%!3\t\u000f\u0005%\u0004\u0001\"\u0011\u0002R\"9\u00111\u001b\u0001\u0005B\u0005U\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003W\u0004A\u0011IAw\u0011\u001d\t\t\u0010\u0001C!\u0003gDq!!?\u0001\t\u0003\nI\rC\u0004\u0002|\u0002!\t%!@\t\u000f\u00055\u0002\u0001\"\u0011\u0003\u0004!9!Q\u0001\u0001\u0005B\t\u001d\u0001b\u0002B\b\u0001\u0011\u0005#\u0011\u0003\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011\u001d\u0011i\u0003\u0001C!\u0005_AqAa\u000f\u0001\t\u0003\u0012i\u0004C\u0004\u0003@\u0001!\tE!\u0011\t\u000f\t\u0015\u0003\u0001\"\u0011\u0003B!9!q\t\u0001\u0005B\t%\u0003b\u0002B'\u0001\u0011\u0005#q\n\u0005\b\u0005'\u0002A\u0011\u0002B+\u0011\u001d\u0011)\b\u0001C\u0005\u0005oBqA! \u0001\t\u0003\n\u0019\u000fC\u0004\u0003\u0000\u0001!IA!!\t\u000f\t5\u0005\u0001\"\u0003\u0002d\"9!q\u0012\u0001\u0005\n\u0005\r\bb\u0002BI\u0001\u0011%!1\u0013\u0005\b\u00053\u0003A\u0011\u0002BN\u0011\u001d\u0011\t\u000b\u0001C!\u0005GC\u0001B!*\u0001\t\u0003\u0019\u0014qX\u0004\b\u0005O\u001b\u0004\u0012\u0001BU\r\u0019\u00114\u0007#\u0001\u0003,\"9\u0011\u0011I\u0017\u0005\u0002\tM\u0006b\u0002B[[\u0011\u0005!q\u0017\u0005\b\u0005?lC\u0011\u0002Bq\u0011\u001d\u0011)/\fC\u0005\u0005O\u0014\u0001cS1gW\u0006lU\r^1eCR\fGj\\4\u000b\u0005Q*\u0014\u0001\u0002:bMRT\u0011AN\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011(Q&\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00027b]\u001eT\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002Aw\t1qJ\u00196fGR\u0004\"AQ%\u000e\u0003\rS!\u0001\u000e#\u000b\u0005Y*%B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001eL!AS\"\u0003\u001bI+\u0007\u000f\\5dCR,G\rT8h!\tau*D\u0001N\u0015\tqU'A\u0003vi&d7/\u0003\u0002Q\u001b\n9Aj\\4hS:<\u0017a\u00017pOV\t1\u000b\u0005\u0002U-6\tQK\u0003\u0002Rk%\u0011q+\u0016\u0002\u000b+:Lg-[3e\u0019><\u0017\u0001\u00027pO\u0002\n1B]3d_J$7+\u001a:eKB\u00121l\u001a\t\u00049\u000e,W\"A/\u000b\u0005y{\u0016!D:fe&\fG.\u001b>bi&|gN\u0003\u0002aC\u000611m\\7n_:T!A\u0019#\u0002\rM,'O^3s\u0013\t!WLA\u0006SK\u000e|'\u000fZ*fe\u0012,\u0007C\u00014h\u0019\u0001!\u0011\u0002[\u0002\u0002\u0002\u0003\u0005)\u0011A5\u0003\u0007}#\u0013'\u0005\u0002kaB\u00111N\\\u0007\u0002Y*\tQ.A\u0003tG\u0006d\u0017-\u0003\u0002pY\n9aj\u001c;iS:<\u0007CA6r\u0013\t\u0011HNA\u0002B]f\fA\u0001^5nKB\u0011Q\u000f_\u0007\u0002m*\u0011aj\u001e\u0006\u0003A\u0012K!!\u001f<\u0003\tQKW.Z\u0001\ng\u000eDW\rZ;mKJ\u0004\"\u0001`@\u000e\u0003uT!A`1\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0003i(!C*dQ\u0016$W\u000f\\3s\u0003%\u0019h.\u00199tQ>$8\u000f\u0005\u0005\u0002\b\u0005E\u0011QCA\u000e\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001fa\u0017AC2pY2,7\r^5p]&!\u00111CA\u0005\u0005\u001d!&/Z3NCB\u00042AQA\f\u0013\r\tIb\u0011\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i!\u0015Y\u0017QDA\u0011\u0013\r\ty\u0002\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\nE\u0003!\u0019h.\u00199tQ>$\u0018\u0002BA\u0016\u0003K\u0011QCR5mKJ\u000bwo\u00158baNDw\u000e\u001e*fC\u0012,'/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u00121G\u0007\u0002o&\u0019\u0011QG<\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u000611m\u001c8gS\u001e\u0004B!a\u000f\u0002>5\t1'C\u0002\u0002@M\u0012\u0011#T3uC\u0012\fG/\u0019'pO\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q\u0001\u0012QIA$\u0003\u0013\n\u0019&!\u0016\u0002X\u0005e\u00131\f\t\u0004\u0003w\u0001\u0001\"B)\n\u0001\u0004\u0019\u0006BB-\n\u0001\u0004\tY\u0005\r\u0003\u0002N\u0005E\u0003\u0003\u0002/d\u0003\u001f\u00022AZA)\t)A\u0017\u0011JA\u0001\u0002\u0003\u0015\t!\u001b\u0005\u0006g&\u0001\r\u0001\u001e\u0005\u0006u&\u0001\ra\u001f\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0011\u001d\ti#\u0003a\u0001\u0003_Aq!a\u000e\n\u0001\u0004\tI$\u0001\u0003sK\u0006$GCBA1\u0003O\n\t\bE\u0002C\u0003GJ1!!\u001aD\u00051aun\u001a$fi\u000eD\u0017J\u001c4p\u0011\u001d\tIG\u0003a\u0001\u0003W\n1b\u001d;beR|eMZ:fiB\u00191.!\u001c\n\u0007\u0005=DN\u0001\u0003M_:<\u0007bBA:\u0015\u0001\u0007\u0011QO\u0001\u000ee\u0016\fG-S:pY\u0006$\u0018n\u001c8\u0011\u0007\t\u000b9(C\u0002\u0002z\r\u0013\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u001d\u0005\u0004\b/\u001a8e\u0003NdU-\u00193feR1\u0011qPAC\u0003+\u00032AQAA\u0013\r\t\u0019i\u0011\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\u0005\u001d5\u00021\u0001\u0002\n\u00069!/Z2pe\u0012\u001c\b\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=u/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003'\u000biIA\u0004SK\u000e|'\u000fZ:\t\u000f\u0005]5\u00021\u0001\u0002\u001a\u0006)Q\r]8dQB\u00191.a'\n\u0007\u0005uENA\u0002J]R\f\u0001#\u00199qK:$\u0017i\u001d$pY2|w/\u001a:\u0015\t\u0005}\u00141\u0015\u0005\b\u0003\u000fc\u0001\u0019AAE\u0003uA\u0017M\u001c3mK\u0006sGmQ8om\u0016\u0014H\u000fT8h\u0003B\u0004XM\u001c3J]\u001a|G\u0003BA@\u0003SCq!a+\u000e\u0001\u0004\ti+\u0001\u0006baB,g\u000eZ%oM>\u0004B!a,\u0002<6\u0011\u0011\u0011\u0017\u0006\u0004#\u0006M&\u0002BA[\u0003o\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005eF)A\u0004ti>\u0014\u0018mZ3\n\t\u0005\r\u0015\u0011W\u0001\u0011Y\u0006\u001cHOR3uG\",G-\u00129pG\"$\"!!'\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u0002\u0016\u0005\u0015\u0007bBAL\u001f\u0001\u0007\u0011\u0011T\u0001\nK:$wJ\u001a4tKR$\"!a3\u0011\u0007\t\u000bi-C\u0002\u0002P\u000e\u0013\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\t\tY'\u0001\u0006ueVt7-\u0019;f)>$B!a6\u0002^B\u00191.!7\n\u0007\u0005mGN\u0001\u0003V]&$\bbBAp%\u0001\u0007\u00111N\u0001\u0007_\u001a47/\u001a;\u00021Q\u0014XO\\2bi\u0016$v\u000eT1uKN$8K\\1qg\"|G\u000f\u0006\u0002\u0002fB\u00191.a:\n\u0007\u0005%HNA\u0004C_>dW-\u00198\u0002+%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014X\t]8dQR!\u0011q[Ax\u0011\u001d\t9\n\u0006a\u0001\u00033\u000b1#\u001e9eCR,\u0007*[4i/\u0006$XM]7be.$B!a6\u0002v\"9\u0011q_\u000bA\u0002\u0005-\u0017AD8gMN,G/T3uC\u0012\fG/Y\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0002\u000b\u0019dWo\u001d5\u0015\t\u0005]\u0017q \u0005\b\u0005\u00039\u0002\u0019AAs\u0003]1wN]2f\r2,8\u000f[!di&4XmU3h[\u0016tG\u000f\u0006\u0002\u00020\u00059Ao\u001c9jG&#GC\u0001B\u0005!\u0011\t\tDa\u0003\n\u0007\t5qO\u0001\u0003Vk&$\u0017!E2sK\u0006$XMT3x':\f\u0007o\u001d5piR!!1\u0003B\u0012!\u0019\u0011)B!\u0007\u0003\u001e5\u0011!q\u0003\u0006\u0003}vJAAa\u0007\u0003\u0018\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002$\t}\u0011\u0002\u0002B\u0011\u0003K\u0011\u0011CU1x':\f\u0007o\u001d5pi^\u0013\u0018\u000e^3s\u0011\u001d\u0011)C\u0007a\u0001\u0003+\t!b\u001d8baNDw\u000e^%e\u00035\u0019Ho\u001c:f':\f\u0007o\u001d5piR!!1\u0003B\u0016\u0011\u001d\u0011)c\u0007a\u0001\u0003+\tAB]3bINs\u0017\r]:i_R$BA!\r\u0003:A1!Q\u0003B\r\u0005g\u0001B!a\t\u00036%!!qGA\u0013\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;SK\u0006$WM\u001d\u0005\b\u0005Ka\u0002\u0019AA\u000b\u00039a\u0017\r^3tiNs\u0017\r]:i_R$\"A!\r\u0002!1\fG/Z:u':\f\u0007o\u001d5pi&#GC\u0001B\"!\u0019\u0011)B!\u0007\u0002\u0016\u0005\u0011R-\u0019:mS\u0016\u001cHo\u00158baNDw\u000e^%e\u0003Aygn\u00158baNDw\u000e\u001e$s_j,g\u000e\u0006\u0003\u0002X\n-\u0003b\u0002B\u0013A\u0001\u0007\u0011QC\u0001\u0015I\u0016dW\r^3CK\u001a|'/Z*oCB\u001c\bn\u001c;\u0015\t\u0005\u0015(\u0011\u000b\u0005\b\u0005K\t\u0003\u0019AA\u000b\u0003Eaw.\u00193T]\u0006\u00048\u000f[8u'&TXm\u001d\u000b\u0003\u0005/\u0002bA!\u0017\u0003j\t=d\u0002\u0002B.\u0005KrAA!\u0018\u0003d5\u0011!q\f\u0006\u0004\u0005C:\u0014A\u0002\u001fs_>$h(C\u0001n\u0013\r\u00119\u0007\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YG!\u001c\u0003\u0007M+\u0017OC\u0002\u0003h1\u0004ra\u001bB9\u0003+\tY'C\u0002\u0003t1\u0014a\u0001V;qY\u0016\u0014\u0014!\u0006:fC\u0012\u001cf.\u00199tQ>$H+[7fgR\fW\u000e\u001d\u000b\u0005\u0005s\u0012Y\bE\u0003l\u0003;\tY\u0007C\u0004\u0003&\r\u0002\r!!\u0006\u0002\u00155\f\u0017PY3DY\u0016\fg.\u0001\bdY\u0016\fgn\u00158baNDw\u000e^:\u0015\t\u0005\u0015(1\u0011\u0005\b\u0005\u000b+\u0003\u0019\u0001BD\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0004l\u0005\u0013\u000b)\"!:\n\u0007\t-ENA\u0005Gk:\u001cG/[8oc\u0005I2\r\\3b]Ns\u0017\r]:i_R\u001c(+\u001a;f]RLwN\\'t\u0003m\u0019G.Z1o':\f\u0007o\u001d5piN\u0014V\r^3oi&|gnU5{K\u0006)bm\u001c:hKR\u001cf.\u00199tQ>$8OQ3g_J,G\u0003BA\u0003\u0005+CqAa&)\u0001\u0004\t)\"\u0001\nm_\u001e\u001cF/\u0019:u':\f\u0007o\u001d5pi&#\u0017a\u0004:f[>4Xm\u00158baNDw\u000e^:\u0015\t\u0005]'Q\u0014\u0005\b\u0005?K\u0003\u0019AA\u0003\u0003A)\u0007\u0010]5sK\u0012\u001cf.\u00199tQ>$8/A\u0003dY>\u001cX\r\u0006\u0002\u0002X\u0006i1O\\1qg\"|GoQ8v]R\f\u0001cS1gW\u0006lU\r^1eCR\fGj\\4\u0011\u0007\u0005mRf\u0005\u0003.\u0005[[\u0005cA6\u00030&\u0019!\u0011\u00177\u0003\r\u0005s\u0017PU3g)\t\u0011I+A\u0003baBd\u0017\u0010\u0006\t\u0002F\te&1\u0018B_\u0005\u001b\u0014INa7\u0003^\"9\u0011QF\u0018A\u0002\u0005=\u0002b\u0002B\u0003_\u0001\u0007!\u0011\u0002\u0005\b\u0005\u007f{\u0003\u0019\u0001Ba\u0003\u001d!\u0017\r^1ESJ\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0004\u0005\u000fl\u0014AA5p\u0013\u0011\u0011YM!2\u0003\t\u0019KG.\u001a\u0005\u00073>\u0002\rAa41\t\tE'Q\u001b\t\u00059\u000e\u0014\u0019\u000eE\u0002g\u0005+$1Ba6\u0003N\u0006\u0005\t\u0011!B\u0001S\n\u0019q\f\n\u001a\t\u000bM|\u0003\u0019\u0001;\t\u000bi|\u0003\u0019A>\t\u000f\u0005]r\u00061\u0001\u0002:\u0005\u0001\"/Z2pm\u0016\u00148K\\1qg\"|Go\u001d\u000b\u0005\u0003\u000b\u0011\u0019\u000fC\u0003Ra\u0001\u00071+A\neK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\u0006\u0005\u0002X\n%(Q B\u0000\u0011\u001d\u0011Y/\ra\u0001\u0005[\fa\u0001\\8h\t&\u0014\b\u0003\u0002Bx\u0005sl!A!=\u000b\t\tM(Q_\u0001\u0005M&dWMC\u0002\u0003xv\n1A\\5p\u0013\u0011\u0011YP!=\u0003\tA\u000bG\u000f\u001b\u0005\b\u0005?\u000b\u0004\u0019AA\u0003\u0011\u0019\u0019\t!\ra\u0001\u0017\u00069An\\4hS:<\u0007")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final RecordSerde<?> recordSerde;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, RecordSerde<?> recordSerde, Time time, Scheduler scheduler, MetadataLogConfig config) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, recordSerde, time, scheduler, config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, AppendOrigin.RAFT_LEADER, x$5, x$4));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset().isPresent()) {
            return new org.apache.kafka.raft.LogAppendInfo(((org.apache.kafka.storage.internals.log.LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset, appendInfo.lastOffset());
        }
        throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset)) {
            this.log().truncateFullyAndStartAt(snapshotId.offset());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
            return;
        }
        this.log().updateHighWatermark(offsetMetadata.offset);
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var6_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            var3_3 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var3_3).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                this.log().deleteOldSegments();
                v0 = true;
                v1 = this.forgetSnapshotsBefore(snapshotId);
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            }
            var6_5 = v1;
            var5_6 = v0;
        }
        this.removeSnapshots(var6_5);
        return var5_6;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).map((Function1 & Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(this, reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Object> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                    new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (snapshot != null && nextSnapshot != null) {
                            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot)) && this.deleteBeforeSnapshot(nextSnapshot)) {
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                            throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                        }
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$1(snapshotId));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot)) && this.deleteBeforeSnapshot(nextSnapshot)) {
                                    didClean$1.elem = true;
                                    return BoxedUnit.UNIT;
                                }
                                throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$2(snapshotId, snapshotSizes, snapshotTotalSize));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot)) && this.deleteBeforeSnapshot(nextSnapshot)) {
                                    didClean$1.elem = true;
                                    return BoxedUnit.UNIT;
                                }
                                throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$removeSnapshots$2(snapshotId);
                    Object var3_3 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(KafkaMetadataLog $this, RawSnapshotReader reader) {
        long l;
        try (RecordsSnapshotReader recordsSnapshotReader = RecordsSnapshotReader.of((RawSnapshotReader)reader, $this.recordSerde, (BufferSupplier)new BufferSupplier.GrowableBufferSupplier(), (int)0x800000, (boolean)true);){
            l = recordsSnapshotReader.lastContainedLogTimestamp();
        }
        return l;
    }

    private final boolean shouldClean$1(OffsetAndEpoch snapshotId) {
        long now = this.time.milliseconds();
        return this.readSnapshotTimestamp(snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)timestamp -> now - timestamp > $this.config.retentionMillis());
    }

    private final boolean shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable)snapshotSize -> {
            if (this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
                snapshotTotalSize$1.elem -= snapshotSize;
                return true;
            }
            return false;
        });
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(OffsetAndEpoch snapshotId$4) {
        return new StringBuilder(30).append("Marking snapshot ").append(snapshotId$4).append(" for deletion").toString();
    }

    public KafkaMetadataLog(UnifiedLog log, RecordSerde<?> recordSerde, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.recordSerde = recordSerde;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }
}

