/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001dcA\u00021b\u0003\u0003\u0019W\r\u0003\u0005x\u0001\t\u0015\r\u0011\"\u0001z\u0011!q\bA!A!\u0002\u0013Q\b\"C@\u0001\u0005\u000b\u0007I\u0011AA\u0001\u0011)\ty\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003#\u0001!\u00111A\u0005\u0002\u0005M\u0001BCA\u0011\u0001\t\u0005\r\u0011\"\u0001\u0002$!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006K!!\u0006\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002@\u0001\u0011)\u0019!C\u0001\u0003\u0003B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011Q\n\u0005\u000b\u0003K\u0002!\u0011!Q\u0001\n\u0005\u001d\u0004BCA7\u0001\t\u0005\t\u0015!\u0003\u0002p!Q\u0011Q\u000f\u0001\u0003\u0002\u0003\u0006I!a\u001e\t\u0015\u0005\u0005\u0005A!A!\u0002\u0013\t\u0019\t\u0003\u0006\u0002\u0010\u0002\u0011\t\u0011)A\u0005\u0003#C!\"a&\u0001\u0005\u0003\u0005\u000b\u0011BAM\u0011)\t)\u000b\u0001B\u0001B\u0003%\u0011q\u0015\u0005\b\u0003[\u0003A\u0011AAX\u0011%\ti\r\u0001b\u0001\n\u0013\ty\r\u0003\u0005\u0002^\u0002\u0001\u000b\u0011BAi\u0011%\ty\u000e\u0001b\u0001\n\u0003\t\t\u000f\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAr\u0011\u001d\tI\u0010\u0001D\u0001\u0003wDqAa\u0005\u0001\r\u0003\tY\u0010C\u0005\u0003\u0016\u0001\u0011\r\u0011\"\u0003\u0003\u0018!A!q\u0004\u0001!\u0002\u0013\u0011I\u0002C\u0005\u0003\"\u0001\u0011\r\u0011\"\u0003\u0003\u0018!A!1\u0005\u0001!\u0002\u0013\u0011I\u0002C\u0005\u0003&\u0001\u0011\r\u0011\"\u0003\u0003\u0018!A!q\u0005\u0001!\u0002\u0013\u0011I\u0002C\u0005\u0003*\u0001\u0011\r\u0011\"\u0003\u0003,!A!Q\b\u0001!\u0002\u0013\u0011i\u0003\u0003\u0007\u0003@\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0014\t\u0005\u0003\u0007\u0003J\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0014Y\u0005C\u0006\u0003P\u0001\u0001\r\u0011!Q!\n\t\r\u0003B\u0003B)\u0001\t\u0007I\u0011A1\u0003T!A!Q\u000b\u0001!\u0002\u0013\tI\u0004\u0003\u0006\u0003X\u0001\u0011\r\u0011\"\u0001b\u00053B\u0001B!\u001d\u0001A\u0003%!1\f\u0005\n\u0005g\u0002!\u0019!C\u0005\u0005kB\u0001B!$\u0001A\u0003%!q\u000f\u0005\n\u0005\u001f\u0003!\u0019!C\u0005\u0005#C\u0001B!'\u0001A\u0003%!1\u0013\u0005\n\u00057\u0003\u0001\u0019!C\u0005\u0005'B\u0011B!(\u0001\u0001\u0004%IAa(\t\u0011\t\r\u0006\u0001)Q\u0005\u0003sA!B!*\u0001\u0005\u0004%\t!\u0019BT\u0011!\u0019\u0019\u0007\u0001Q\u0001\n\t%\u0006\"CB3\u0001\u0001\u0007I\u0011BB4\u0011%\u0019I\u0007\u0001a\u0001\n\u0013\u0019Y\u0007\u0003\u0005\u0004p\u0001\u0001\u000b\u0015BA4\u0011)\u0019\t\b\u0001b\u0001\n\u0003\t71\u000f\u0005\t\u0007\u0007\u0003\u0001\u0015!\u0003\u0004v!I1Q\u0011\u0001C\u0002\u0013\u00051q\u0011\u0005\t\u0007\u001f\u0003\u0001\u0015!\u0003\u0004\n\"91\u0011\u0013\u0001\u0005\u0002\rMea\u0002BZ\u0001\u0001\u000b'Q\u0017\u0005\u000b\u00057T$Q3A\u0005\u0002\tu\u0007B\u0003Bsu\tE\t\u0015!\u0003\u0003`\"Q!q\u001d\u001e\u0003\u0016\u0004%\tA!;\t\u0015\tE(H!E!\u0002\u0013\u0011Y\u000fC\u0004\u0002.j\"\tAa=\t\u000f\te(\b\"\u0011\u0003|\"I1\u0011\u0001\u001e\u0002\u0002\u0013\u000511\u0001\u0005\n\u0007\u0013Q\u0014\u0013!C\u0001\u0007\u0017A\u0011b!\t;#\u0003%\taa\t\t\u0013\r\u001d\"(!A\u0005B\r%\u0002\"CB\u0018u\u0005\u0005I\u0011\u0001B*\u0011%\u0019\tDOA\u0001\n\u0003\u0019\u0019\u0004C\u0005\u0004>i\n\t\u0011\"\u0011\u0004@!I1\u0011\n\u001e\u0002\u0002\u0013\u000511\n\u0005\n\u0007\u001fR\u0014\u0011!C!\u0007#B\u0011b!\u0016;\u0003\u0003%\tea\u0016\t\u0013\re#(!A\u0005B\rm\u0003\"CB/u\u0005\u0005I\u0011IB0\u000f)\u0019)\nAA\u0001\u0012\u0003\t7q\u0013\u0004\u000b\u0005g\u0003\u0011\u0011!E\u0001C\u000ee\u0005bBAW\u001d\u0012\u00051\u0011\u0017\u0005\n\u00073r\u0015\u0011!C#\u00077B\u0011ba-O\u0003\u0003%\ti!.\t\u0013\rmf*!A\u0005\u0002\u000eu\u0006\u0002CBh\u0001\u0011\u0005\u0011m!5\t\u000f\r]\u0007\u0001\"\u0001\u0004\u0014\"91\u0011\u001c\u0001\u0005\u0002\rM\u0005bBBn\u0001\u0011\u000531\u0013\u0005\b\u0007;\u0004A\u0011BBp\u0011\u001d\u0019Y\u000f\u0001C\u0005\u0007'Cqa!<\u0001\t\u0013\u0019y\u000fC\u0004\u0004~\u0002!\tba@\t\u000f\u0011\u0015\u0001\u0001\"\u0003\u0004\u0014\"9Aq\u0001\u0001\u0005\n\u0011%\u0001b\u0002C\u000b\u0001\u0011\u000511\u0013\u0005\b\t/\u0001A\u0011\u0001C\r\u0011\u001d!y\u0002\u0001C\u0001\tC\u0011\u0001\"Q2dKB$xN\u001d\u0006\u0003E\u000e\fqA\\3uo>\u00148NC\u0001e\u0003\u0015Y\u0017MZ6b'\u0011\u0001aM\\9\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n1qJ\u00196fGR\u0004\"aZ8\n\u0005AD'\u0001\u0003*v]:\f'\r\\3\u0011\u0005I,X\"A:\u000b\u0005Q\u001c\u0017!B;uS2\u001c\u0018B\u0001<t\u0005\u001daunZ4j]\u001e\fAb]8dW\u0016$8+\u001a:wKJ\u001c\u0001!F\u0001{!\tYH0D\u0001b\u0013\ti\u0018M\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0007t_\u000e\\W\r^*feZ,'\u000fI\u0001\tK:$\u0007k\\5oiV\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B2\u0002\u000f\rdWo\u001d;fe&!\u0011QBA\u0004\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D2\u0002\rM,'O^3s\u0013\u0011\ty\"!\u0007\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\u0013\u0003c\u0001B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0003\u0003W\tQa]2bY\u0006LA!a\f\u0002*\t!QK\\5u\u0011%\t\u0019DBA\u0001\u0002\u0004\t)\"A\u0002yIE\nqaY8oM&<\u0007%\u0001\u0004o_\u0012,\u0017\n\u001a\t\u0005\u0003O\tY$\u0003\u0003\u0002>\u0005%\"aA%oi\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0003\u0003\u0007\u00022a_A#\u0013\r\t9%\u0019\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\f\u0011cY8o]\u0016\u001cG/[8o#V|G/Y:!\u0003\u0011!\u0018.\\3\u0011\t\u0005=\u0013\u0011M\u0007\u0003\u0003#R1\u0001^A*\u0015\u0011\t)&a\u0016\u0002\r\r|W.\\8o\u0015\r!\u0017\u0011\f\u0006\u0005\u00037\ni&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003?\n1a\u001c:h\u0013\u0011\t\u0019'!\u0015\u0003\tQKW.Z\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\u0011\t\u0005\u001d\u0012\u0011N\u0005\u0005\u0003W\nICA\u0004C_>dW-\u00198\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u001910!\u001d\n\u0007\u0005M\u0014M\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002\u000f5,GO]5dgB!\u0011\u0011PA?\u001b\t\tYH\u0003\u0003\u0002v\u0005M\u0013\u0002BA@\u0003w\u0012q!T3ue&\u001c7/\u0001\nde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%5-\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\ti)a\"\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u0001\u000bY><7i\u001c8uKb$\b\u0003BA(\u0003'KA!!&\u0002R\tQAj\\4D_:$X\r\u001f;\u0002\u00155,Wn\u001c:z!>|G\u000e\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\u0011\ty*a\u0015\u0002\r5,Wn\u001c:z\u0013\u0011\t\u0019+!(\u0003\u00155+Wn\u001c:z!>|G.A\tba&4VM]:j_:l\u0015M\\1hKJ\u0004B!a\u0006\u0002*&!\u00111VA\r\u0005E\t\u0005/\u001b,feNLwN\\'b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u00159\u0005E\u00161WA[\u0003o\u000bI,a/\u0002>\u0006}\u0016\u0011YAb\u0003\u000b\f9-!3\u0002LB\u00111\u0010\u0001\u0005\u0006oN\u0001\rA\u001f\u0005\u0007\u007fN\u0001\r!a\u0001\t\u000f\u0005E1\u00031\u0001\u0002\u0016!9\u0011qG\nA\u0002\u0005e\u0002bBA '\u0001\u0007\u00111\t\u0005\b\u0003\u0017\u001a\u0002\u0019AA'\u0011\u001d\t)g\u0005a\u0001\u0003OBq!!\u001c\u0014\u0001\u0004\ty\u0007C\u0004\u0002vM\u0001\r!a\u001e\t\u000f\u0005\u00055\u00031\u0001\u0002\u0004\"9\u0011qR\nA\u0002\u0005E\u0005bBAL'\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003K\u001b\u0002\u0019AAT\u00031iW\r\u001e:jGN<%o\\;q+\t\t\t\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\u0011\t)(a6\u000b\t\u0005m\u0011qK\u0005\u0005\u00037\f)NA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013!C:i_VdGMU;o+\t\t\u0019\u000f\u0005\u0003\u0002f\u0006MXBAAt\u0015\u0011\tI/a;\u0002\r\u0005$x.\\5d\u0015\u0011\ti/a<\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002r*\fA!\u001e;jY&!\u0011Q_At\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006Q1\u000f[8vY\u0012\u0014VO\u001c\u0011\u0002\u00195,GO]5d!J,g-\u001b=\u0015\u0005\u0005u\b\u0003BA\u0000\u0005\u001bqAA!\u0001\u0003\nA!!1AA\u0015\u001b\t\u0011)AC\u0002\u0003\ba\fa\u0001\u0010:p_Rt\u0014\u0002\u0002B\u0006\u0003S\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B\b\u0005#\u0011aa\u0015;sS:<'\u0002\u0002B\u0006\u0003S\tA\u0002\u001e5sK\u0006$\u0007K]3gSb\fab]3oI\n+hMZ3s'&TX-\u0006\u0002\u0003\u001aA\u0019qMa\u0007\n\u0007\tu\u0001NA\u0004J]R,w-\u001a:\u0002\u001fM,g\u000e\u001a\"vM\u001a,'oU5{K\u0002\naB]3dm\n+hMZ3s'&TX-A\bsK\u000e4()\u001e4gKJ\u001c\u0016N_3!\u0003Ea\u0017n\u001d;f]\n\u000b7m\u001b7pONK'0Z\u0001\u0013Y&\u001cH/\u001a8CC\u000e\\Gn\\4TSj,\u0007%A\u0006oS>\u001cV\r\\3di>\u0014XC\u0001B\u0017!\u0011\u0011yC!\u000f\u000e\u0005\tE\"\u0002\u0002B\u001a\u0005k\t\u0001b\u00195b]:,Gn\u001d\u0006\u0004\u0005oQ\u0017a\u00018j_&!!1\bB\u0019\u0005!\u0019V\r\\3di>\u0014\u0018\u0001\u00048j_N+G.Z2u_J\u0004\u0013!D:feZ,'o\u00115b]:,G.\u0006\u0002\u0003DA!!q\u0006B#\u0013\u0011\u00119E!\r\u0003'M+'O^3s'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002#M,'O^3s\u0007\"\fgN\\3m?\u0012*\u0017\u000f\u0006\u0003\u0002&\t5\u0003\"CA\u001aG\u0005\u0005\t\u0019\u0001B\"\u00039\u0019XM\u001d<fe\u000eC\u0017M\u001c8fY\u0002\n\u0011\u0002\\8dC2\u0004vN\u001d;\u0016\u0005\u0005e\u0012A\u00037pG\u0006d\u0007k\u001c:uA\u0005Q\u0001O]8dKN\u001cxN]:\u0016\u0005\tm\u0003C\u0002B/\u0005O\u0012Y'\u0004\u0002\u0003`)!!\u0011\rB2\u0003\u001diW\u000f^1cY\u0016TAA!\u001a\u0002*\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%$q\f\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002|\u0005[J1Aa\u001cb\u0005%\u0001&o\\2fgN|'/A\u0006qe>\u001cWm]:peN\u0004\u0013!\b2m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\t]\u0004\u0003\u0002B=\u0005\u0013k!Aa\u001f\u000b\t\tu$qP\u0001\u0005G>\u0014XM\u0003\u0003\u0002v\t\u0005%\u0002\u0002BB\u0005\u000b\u000ba!_1n[\u0016\u0014(B\u0001BD\u0003\r\u0019w.\\\u0005\u0005\u0005\u0017\u0013YH\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\faD\u00197pG.,G\rU3sG\u0016tG/T3uKJlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002'\tdwnY6fIB+'oY3oi6+G/\u001a:\u0016\u0005\tM\u0005\u0003\u0002B=\u0005+KAAa&\u0003|\t)Q*\u001a;fe\u0006!\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;fe\u0002\nQcY;se\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:J]\u0012,\u00070A\rdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=`I\u0015\fH\u0003BA\u0013\u0005CC\u0011\"a\r/\u0003\u0003\u0005\r!!\u000f\u0002-\r,(O]3oiB\u0013xnY3tg>\u0014\u0018J\u001c3fq\u0002\n\u0001\u0003\u001e5s_R$H.\u001a3T_\u000e\\W\r^:\u0016\u0005\t%\u0006C\u0002B/\u0005W\u0013y+\u0003\u0003\u0003.\n}#!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X\rE\u0002\u00032jj\u0011\u0001\u0001\u0002\u0013\t\u0016d\u0017-_3e\u00072|7/Z*pG.,GoE\u0005;\u0005o\u0013iLa4\u0003VB!\u0011q\u0005B]\u0013\u0011\u0011Y,!\u000b\u0003\r\u0005s\u0017PU3g!\u0019\u0011yL!3\u00030:!!\u0011\u0019Bc\u001d\u0011\u0011\u0019Aa1\n\u0005\u0005-\u0012\u0002\u0002Bd\u0003S\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003L\n5'aB(sI\u0016\u0014X\r\u001a\u0006\u0005\u0005\u000f\fI\u0003\u0005\u0003\u0002(\tE\u0017\u0002\u0002Bj\u0003S\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003@\n]\u0017\u0002\u0002Bm\u0005\u001b\u0014AbU3sS\u0006d\u0017N_1cY\u0016\faa]8dW\u0016$XC\u0001Bp!\u0011\u0011yC!9\n\t\t\r(\u0011\u0007\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0002\u000fM|7m[3uA\u0005\tRM\u001c3UQJ|G\u000f\u001e7f)&lW-T:\u0016\u0005\t-\b\u0003BA\u0014\u0005[LAAa<\u0002*\t!Aj\u001c8h\u0003I)g\u000e\u001a+ie>$H\u000f\\3US6,Wj\u001d\u0011\u0015\r\t=&Q\u001fB|\u0011\u001d\u0011Yn\u0010a\u0001\u0005?DqAa:@\u0001\u0004\u0011Y/A\u0004d_6\u0004\u0018M]3\u0015\t\u0005e\"Q \u0005\b\u0005\u007f\u0004\u0005\u0019\u0001BX\u0003\u0011!\b.\u0019;\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005_\u001b)aa\u0002\t\u0013\tm\u0017\t%AA\u0002\t}\u0007\"\u0003Bt\u0003B\u0005\t\u0019\u0001Bv\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0004+\t\t}7qB\u0016\u0003\u0007#\u0001Baa\u0005\u0004\u001e5\u00111Q\u0003\u0006\u0005\u0007/\u0019I\"A\u0005v]\u000eDWmY6fI*!11DA\u0015\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007?\u0019)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0004&)\"!1^B\b\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u001111\u0006\t\u0004O\u000e5\u0012b\u0001B\bQ\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB\u001b\u0007w\u0001B!a\n\u00048%!1\u0011HA\u0015\u0005\r\te.\u001f\u0005\n\u0003g1\u0015\u0011!a\u0001\u0003s\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u0003\u0002baa\u0011\u0004F\rURB\u0001B2\u0013\u0011\u00199Ea\u0019\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\u001ai\u0005C\u0005\u00024!\u000b\t\u00111\u0001\u00046\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019Yca\u0015\t\u0013\u0005M\u0012*!AA\u0002\u0005e\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005e\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r-\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002h\r\u0005\u0004\"CA\u001a\u0019\u0006\u0005\t\u0019AB\u001b\u0003E!\bN]8ui2,GmU8dW\u0016$8\u000fI\u0001\bgR\f'\u000f^3e+\t\t9'A\u0006ti\u0006\u0014H/\u001a3`I\u0015\fH\u0003BA\u0013\u0007[B\u0011\"a\r4\u0003\u0003\u0005\r!a\u001a\u0002\u0011M$\u0018M\u001d;fI\u0002\nQb\u001d;beR,GMR;ukJ,WCAB;!\u0019\u00199h!\u001f\u0004~5\u0011\u00111^\u0005\u0005\u0007w\nYOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042aZB@\u0013\r\u0019\t\t\u001b\u0002\u0005->LG-\u0001\bti\u0006\u0014H/\u001a3GkR,(/\u001a\u0011\u0002\rQD'/Z1e+\t\u0019I\t\u0005\u0003\u0002P\r-\u0015\u0002BBG\u0003#\u00121bS1gW\u0006$\u0006N]3bI\u00069A\u000f\u001b:fC\u0012\u0004\u0013!B:uCJ$HCAA\u0013\u0003I!U\r\\1zK\u0012\u001cEn\\:f'>\u001c7.\u001a;\u0011\u0007\tEfjE\u0003O\u00077\u001b9\u000b\u0005\u0006\u0004\u001e\u000e\r&q\u001cBv\u0005_k!aa(\u000b\t\r\u0005\u0016\u0011F\u0001\beVtG/[7f\u0013\u0011\u0019)ka(\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0004*\u000e=VBABV\u0015\r\u0019iK[\u0001\u0003S>LAA!7\u0004,R\u00111qS\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005_\u001b9l!/\t\u000f\tm\u0017\u000b1\u0001\u0003`\"9!q])A\u0002\t-\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u007f\u001bY\r\u0005\u0004\u0002(\r\u00057QY\u0005\u0005\u0007\u0007\fIC\u0001\u0004PaRLwN\u001c\t\t\u0003O\u00199Ma8\u0003l&!1\u0011ZA\u0015\u0005\u0019!V\u000f\u001d7fe!I1Q\u001a*\u0002\u0002\u0003\u0007!qV\u0001\u0004q\u0012\u0002\u0014\u0001\u0005:f[>4X\r\u0015:pG\u0016\u001c8o\u001c:t)\u0011\t)ca5\t\u000f\rU7\u000b1\u0001\u0002:\u0005Y!/Z7pm\u0016\u001cu.\u001e8u\u00035\u0011WmZ5o'\",H\u000fZ8x]\u0006)1\r\\8tK\u0006\u0019!/\u001e8\u0002!=\u0004XM\\*feZ,'oU8dW\u0016$H\u0003\u0003B\"\u0007C\u001c)o!;\t\u000f\r\rx\u000b1\u0001\u0002~\u0006!\u0001n\\:u\u0011\u001d\u00199o\u0016a\u0001\u0003s\tA\u0001]8si\"9!QE,A\u0002\u0005e\u0012\u0001F1dG\u0016\u0004HOT3x\u0007>tg.Z2uS>t7/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0007c\u001c\u0019\u0010\u0005\u0004\u0002(\r\u0005'q\u001c\u0005\b\u0007kL\u0006\u0019AB|\u0003\rYW-\u001f\t\u0005\u0005_\u0019I0\u0003\u0003\u0004|\nE\"\u0001D*fY\u0016\u001cG/[8o\u0017\u0016L\u0018AH2p]\u001aLw-\u001e:f\u0003\u000e\u001cW\r\u001d;fIN{7m[3u\u0007\"\fgN\\3m)\u0011\t)\u0003\"\u0001\t\u000f\u0011\r!\f1\u0001\u0003`\u0006i1o\\2lKR\u001c\u0005.\u00198oK2\f\u0011d\u00197pg\u0016$\u0006N]8ui2,GmQ8o]\u0016\u001cG/[8og\u0006\u0019\u0012m]:jO:tUm^\"p]:,7\r^5p]RA\u0011q\rC\u0006\t\u001b!\t\u0002C\u0004\u0005\u0004q\u0003\rAa8\t\u000f\u0011=A\f1\u0001\u0003l\u0005I\u0001O]8dKN\u001cxN\u001d\u0005\b\t'a\u0006\u0019AA4\u0003!i\u0017-\u001f\"m_\u000e\\\u0017AB<bW\u0016,\b/A\u0007bI\u0012\u0004&o\\2fgN|'o\u001d\u000b\u0005\u0003K!Y\u0002C\u0004\u0005\u001ey\u0003\r!!\u000f\u0002\u0011Q|7I]3bi\u0016\fAB\\3x!J|7-Z:t_J$\u0002Ba\u001b\u0005$\u0011\u001dBQ\u0007\u0005\b\tKy\u0006\u0019AA\u001d\u0003\tIG\rC\u0004\u0005*}\u0003\r\u0001b\u000b\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u00115B\u0011G\u0007\u0003\t_Q1AYA*\u0013\u0011!\u0019\u0004b\f\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u0011]r\f1\u0001\u0005:\u0005\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\t\u0005\tw!\u0019%\u0004\u0002\u0005>)!Aq\bC!\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005%\u00151K\u0005\u0005\t\u000b\"iD\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0002")
public abstract class Acceptor
implements Runnable,
Logging {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final SocketServer socketServer;
    private final EndPoint endPoint;
    private KafkaConfig config;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Time time;
    private final boolean isPrivilegedListener;
    private final RequestChannel requestChannel;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final LogContext logContext;
    private final MemoryPool memoryPool;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final AtomicBoolean shouldRun;
    private final Integer sendBufferSize;
    private final Integer recvBufferSize;
    private final Integer listenBacklogSize;
    private final Selector nioSelector;
    private ServerSocketChannel serverChannel;
    private final int localPort;
    private final ArrayBuffer<Processor> processors;
    private final MetricName blockedPercentMeterMetricName;
    private final Meter blockedPercentMeter;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private boolean started;
    private final CompletableFuture<Void> startedFuture;
    private final KafkaThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public AtomicBoolean shouldRun() {
        return this.shouldRun;
    }

    public abstract String metricPrefix();

    public abstract String threadPrefix();

    private Integer sendBufferSize() {
        return this.sendBufferSize;
    }

    private Integer recvBufferSize() {
        return this.recvBufferSize;
    }

    private Integer listenBacklogSize() {
        return this.listenBacklogSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    public void serverChannel_$eq(ServerSocketChannel x$1) {
        this.serverChannel = x$1;
    }

    public int localPort() {
        return this.localPort;
    }

    public ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private MetricName blockedPercentMeterMetricName() {
        return this.blockedPercentMeterMetricName;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public CompletableFuture<Void> startedFuture() {
        return this.startedFuture;
    }

    public KafkaThread thread() {
        return this.thread;
    }

    public void start() {
        synchronized (this) {
            this.liftedTree1$1();
            return;
        }
    }

    public synchronized void removeProcessors(int removeCount) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            this.requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    public void beginShutdown() {
        if (this.shouldRun().getAndSet(false)) {
            this.wakeup();
            synchronized (this) {
                this.processors().foreach((Function1 & Serializable)x$16 -> {
                    x$16.beginShutdown();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public void close() {
        this.beginShutdown();
        this.thread().join();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$17 -> {
                x$17.close();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        try {
            while (this.shouldRun().get()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable)throttledSocket -> {
                SocketServer$.MODULE$.closeSocket(throttledSocket.socket(), this);
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port, int listenBacklogSize) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (!BoxesRunTime.equalsNumObject((Number)this.recvBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            serverChannel.socket().setReceiveBufferSize(Predef$.MODULE$.Integer2int(this.recvBufferSize()));
        }
        try {
            serverChannel.socket().bind(socketAddress, listenBacklogSize);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.shouldRun().get()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            return;
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas().inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            this.configureAcceptedSocketChannel(socketChannel);
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
        catch (IOException e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Encountered an error while configuring the connection, closing it.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.connectionQuotas().closeChannel(this, this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    public void configureAcceptedSocketChannel(SocketChannel socketChannel) {
        socketChannel.configureBlocking(false);
        socketChannel.socket().setTcpNoDelay(true);
        socketChannel.socket().setKeepAlive(true);
        if (!BoxesRunTime.equalsNumObject((Number)this.sendBufferSize(), (Object)BoxesRunTime.boxToInteger((int)-1))) {
            socketChannel.socket().setSendBufferSize(Predef$.MODULE$.Integer2int(this.sendBufferSize()));
            return;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$18)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            SocketServer$.MODULE$.closeSocket(closingSocket.socket(), this);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public void addProcessors(int toCreate) {
        synchronized (this) {
            ListenerName listenerName = this.endPoint().listenerName();
            SecurityProtocol securityProtocol = this.endPoint().securityProtocol();
            ArrayBuffer listenerProcessors = new ArrayBuffer();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), toCreate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$19 -> {
                Processor processor = this.newProcessor(this.socketServer().nextProcessorId(), listenerName, securityProtocol);
                listenerProcessors.$plus$eq((Object)processor);
                $this.requestChannel.addProcessor(processor);
                if (this.started()) {
                    processor.start();
                    return;
                }
            });
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.processors().$plus$plus$eq((IterableOnce)listenerProcessors);
            return;
        }
    }

    public Processor newProcessor(int id, ListenerName listenerName, SecurityProtocol securityProtocol) {
        String name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-network-thread-").append(this.nodeId).append("-").append(this.endPoint().listenerName()).append("-").append(this.endPoint().securityProtocol()).append("-").append(id).toString();
        return new Processor(id, this.time, Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel, this.connectionQuotas(), Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), Predef$.MODULE$.Integer2int(this.config().failedAuthenticationDelayMs()), listenerName, securityProtocol, this.config(), this.metrics, this.credentialProvider, this.memoryPool, this.logContext, Processor$.MODULE$.ConnectionQueueSize(), this.isPrivilegedListener, this.apiVersionManager, name);
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    private final /* synthetic */ Object liftedTree1$1() {
        try {
            if (!this.shouldRun().get()) {
                throw new ClosedChannelException();
            }
            if (this.serverChannel() == null) {
                this.serverChannel_$eq(this.openServerSocket(this.endPoint().host(), this.endPoint().port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(17).append("Opened endpoint ").append(this.endPoint().host()).append(":").append(this.endPoint().port()).toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Starting processors for listener ").append(this.endPoint().listenerName()).toString());
            this.processors().foreach((Function1 & Serializable)x$14 -> {
                x$14.start();
                return BoxedUnit.UNIT;
            });
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Starting acceptor thread for listener ").append(this.endPoint().listenerName()).toString());
            this.thread().start();
            this.startedFuture().complete(null);
            this.started_$eq(true);
            return BoxedUnit.UNIT;
        }
        catch (ClosedChannelException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Refusing to start acceptor for ").append(this.endPoint().listenerName()).append(" since the acceptor has already been shut down.").toString());
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(e));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return BoxesRunTime.boxToBoolean((boolean)this.startedFuture().completeExceptionally(new RuntimeException(new StringBuilder(29).append("Unable to start acceptor for ").append(this.endPoint().listenerName()).toString(), t)));
        }
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                $this.currentProcessorIndex_$eq($this.currentProcessorIndex() % $this.processors().length());
                processor = (Processor)$this.processors().apply($this.currentProcessorIndex());
            }
            $this.currentProcessorIndex_$eq($this.currentProcessorIndex() + 1);
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$18) {
        return x$18.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(SocketServer socketServer, EndPoint endPoint, KafkaConfig config, int nodeId, ConnectionQuotas connectionQuotas, Time time, boolean isPrivilegedListener, RequestChannel requestChannel, Metrics metrics, CredentialProvider credentialProvider, LogContext logContext, MemoryPool memoryPool, ApiVersionManager apiVersionManager) {
        int n;
        this.socketServer = socketServer;
        this.endPoint = endPoint;
        this.config = config;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.time = time;
        this.isPrivilegedListener = isPrivilegedListener;
        this.requestChannel = requestChannel;
        this.metrics = metrics;
        this.credentialProvider = credentialProvider;
        this.logContext = logContext;
        this.memoryPool = memoryPool;
        this.apiVersionManager = apiVersionManager;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.shouldRun = new AtomicBoolean(true);
        this.sendBufferSize = this.config().socketSendBufferBytes();
        this.recvBufferSize = this.config().socketReceiveBufferBytes();
        this.listenBacklogSize = this.config().socketListenBacklogSize();
        this.nioSelector = Selector.open();
        if (endPoint.port() != 0) {
            n = endPoint.port();
        } else {
            this.serverChannel_$eq(this.openServerSocket(endPoint.host(), endPoint.port(), Predef$.MODULE$.Integer2int(this.listenBacklogSize())));
            int newPort = this.serverChannel().socket().getLocalPort();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Opened wildcard endpoint ").append(this.endPoint().host()).append(":").append(newPort).toString());
            n = newPort;
        }
        this.localPort = n;
        this.processors = new ArrayBuffer();
        this.blockedPercentMeterMetricName = KafkaMetricsGroup.explicitMetricName((String)"kafka.network", (String)"Acceptor", (String)new StringBuilder(22).append(this.metricPrefix()).append("AcceptorBlockedPercent").toString(), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))).asJava());
        this.blockedPercentMeter = this.metricsGroup().newMeter(this.blockedPercentMeterMetricName(), "blocked time", TimeUnit.NANOSECONDS);
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.started = false;
        this.startedFuture = new CompletableFuture();
        String nonDaemon_name = new StringBuilder(25).append(this.threadPrefix()).append("-kafka-socket-acceptor-").append(endPoint.listenerName()).append("-").append(endPoint.securityProtocol()).append("-").append(endPoint.port()).toString();
        this.thread = new KafkaThread(nonDaemon_name, (Runnable)this, false);
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "socket";
                }
                case 1: {
                    return "endThrottleTimeMs";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof DelayedCloseSocket && ((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() == this.kafka$network$Acceptor$DelayedCloseSocket$$$outer())) break block3;
                    DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
                    if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) break block3;
                    SocketChannel socketChannel = this.socket();
                    SocketChannel socketChannel2 = delayedCloseSocket.socket();
                    if ((socketChannel != null ? !socketChannel.equals(socketChannel2) : socketChannel2 != null) || !delayedCloseSocket.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

