/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.TestRaftServer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class TestRaftServer$
implements Logging {
    public static final TestRaftServer$ MODULE$ = new TestRaftServer$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        TestRaftServer.TestRaftServerOptions opts = new TestRaftServer.TestRaftServerOptions(args);
        try {
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "Standalone raft server for performance testing");
            String configFile = (String)opts.options().valueOf(opts.configOpt());
            if (configFile == null) {
                throw new InvalidConfigurationException("Missing configuration file. Should specify with '--config'");
            }
            Properties serverProps = Utils.loadProps((String)configFile, null);
            serverProps.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
            boolean fromProps_doLog = false;
            KafkaConfig config = new KafkaConfig(serverProps, fromProps_doLog);
            int throughput = BoxesRunTime.unboxToInt((Object)opts.options().valueOf(opts.throughputOpt()));
            int recordSize = BoxesRunTime.unboxToInt((Object)opts.options().valueOf(opts.recordSizeOpt()));
            TestRaftServer server = new TestRaftServer(config, throughput, recordSize);
            Exit.addShutdownHook((String)"raft-shutdown-hook", () -> Exit$.$anonfun$addShutdownHook$1((Function0)(JFunction0.mcV.sp & Serializable)() -> server.shutdown()));
            server.startup();
            server.awaitShutdown();
            throw Exit$.MODULE$.exit(0, (Option<String>)None$.MODULE$);
        }
        catch (OptionException e) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), e.getMessage());
        }
        catch (Throwable e) {
            if (this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
                String msgWithLogIdent_msg = "Exiting raft server due to fatal exception";
                Object var12_12 = null;
                this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), e);
            }
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    public static final /* synthetic */ String $anonfun$main$2() {
        return "Exiting raft server due to fatal exception";
    }

    public static final /* synthetic */ Throwable $anonfun$main$3(Throwable e$1) {
        return e$1;
    }

    private TestRaftServer$() {
    }
}

