/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-Bq!\b\u0001C\u0002\u0013%a\u0006\u0003\u0004;\u0001\u0001\u0006Ia\f\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006\u0005\u0002!Ia\u0011\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\ty\u0003\u0001C\u0001\u0003'Aq!a\r\u0001\t\u0003\t\u0019\u0002C\u0004\u00028\u0001!\t!a\u0005\t\u000f\u0005m\u0002\u0001\"\u0001\u0002\u0014!9\u0011q\b\u0001\u0005\u0002\u0005M\u0001bBA\"\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u000f\u0002A\u0011AA\n\u0011\u001d\tY\u0005\u0001C\u0001\u0003'Aq!a\u0014\u0001\t\u0003\t\u0019\u0002C\u0004\u0002T\u0001!\t!a\u0005\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\u0014!9\u00111\f\u0001\u0005\u0002\u0005M\u0001bBA0\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003G\u0002A\u0011AA\n\u0011\u001d\t9\u0007\u0001C\u0001\u0003'Aq!a\u001b\u0001\t\u0003\t\u0019\u0002C\u0004\u0002p\u0001!\t!a\u0005\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\u0014\ti!j]8o-\u0006dW/\u001a+fgRT!!\b\u0010\u0002\t)\u001cxN\u001c\u0006\u0003?\u0001\nQ!\u001e;jYNT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003q)\u0012a\f\t\u0003a]r!!M\u001b\u0011\u0005I2S\"A\u001a\u000b\u0005Q\u0012\u0013A\u0002\u001fs_>$h(\u0003\u00027M\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1d%A\u0003kg>t\u0007%A\u0003qCJ\u001cX\r\u0006\u0002>\u0001B\u0011QFP\u0005\u0003\u007fq\u0011\u0011BS:p]Z\u000bG.^3\t\u000b\u0005#\u0001\u0019A\u0018\u0002\u0003M\f\u0001\"Y:tKJ$Hk\\\u000b\u0003\tB#2!R-\\)\t1\u0015\n\u0005\u0002&\u000f&\u0011\u0001J\n\u0002\u0005+:LG\u000fC\u0004K\u000b\u0005\u0005\t9A&\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002.\u0019:K!!\u0014\u000f\u0003\u0015\u0011+7m\u001c3f\u0015N|g\u000e\u0005\u0002P!2\u0001A!B)\u0006\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006CA\u0013U\u0013\t)fEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015:\u0016B\u0001-'\u0005\r\te.\u001f\u0005\u00065\u0016\u0001\rAT\u0001\tKb\u0004Xm\u0019;fI\")A,\u0002a\u0001;\u0006I!n]8o-\u0006dW/\u001a\t\u0005Ky\u0003W(\u0003\u0002`M\tIa)\u001e8di&|g.\r\t\u0003[\u0005L!A\u0019\u000f\u0003\u0015)\u001bxN\\(cU\u0016\u001cG/A\u0007bgN,'\u000f\u001e+p\r\u0006LGn]\u000b\u0003K.$\"A\u001a7\u0015\u0005\u0019;\u0007b\u00025\u0007\u0003\u0003\u0005\u001d![\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA\u0017MUB\u0011qj\u001b\u0003\u0006#\u001a\u0011\rA\u0015\u0005\u00069\u001a\u0001\r!X\u0001\fCN\u001cXM\u001d;UQJ|w/\u0006\u0002poR\u0019\u0001/a\u0002\u0015\u0005\u0019\u000b\bb\u0002:\b\u0003\u0003\u0005\u001da]\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004c\u0001\u0019um&\u0011Q/\u000f\u0002\t\u001b\u0006t\u0017NZ3tiB\u0011qj\u001e\u0003\u0006q\u001e\u0011\r!\u001f\u0002\u0002\u000bF\u00111K\u001f\t\u0004w\u0006\u0005aB\u0001?\u007f\u001d\t\u0011T0C\u0001(\u0013\tyh%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\n)\"\u0014xn^1cY\u0016T!a \u0014\t\u0011\u0005%q\u0001\"a\u0001\u0003\u0017\tAAY8esB!Q%!\u0004G\u0013\r\tyA\n\u0002\ty\tLh.Y7f}\u0005\u0001B/Z:u\u0003NT5o\u001c8PE*,7\r\u001e\u000b\u0002\r\"\u001a\u0001\"a\u0006\u0011\t\u0005e\u00111F\u0007\u0003\u00037QA!!\b\u0002 \u0005\u0019\u0011\r]5\u000b\t\u0005\u0005\u00121E\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t)#a\n\u0002\u000b),h.\u001b;\u000b\u0005\u0005%\u0012aA8sO&!\u0011QFA\u000e\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f^!t\u0015N|gn\u00142kK\u000e$x\n\u001d;j_:D3!CA\f\u0003=!Xm\u001d;Bg*\u001bxN\\!se\u0006L\bf\u0001\u0006\u0002\u0018\u0005)B/Z:u\u0003NT5o\u001c8BeJ\f\u0017p\u00149uS>t\u0007fA\u0006\u0002\u0018\u0005\tB/Z:u\u0015N|gn\u00142kK\u000e$x)\u001a;)\u00071\t9\"A\nuKN$(j]8o\u001f\nTWm\u0019;BaBd\u0017\u0010K\u0002\u000e\u0003/\ta\u0003^3ti*\u001bxN\\(cU\u0016\u001cG/\u0013;fe\u0006$xN\u001d\u0015\u0004\u001d\u0005]\u0011!\u0006;fgRT5o\u001c8BeJ\f\u00170\u0013;fe\u0006$xN\u001d\u0015\u0004\u001f\u0005]\u0011a\u0005;fgRT5o\u001c8WC2,X-R9vC2\u001c\bf\u0001\t\u0002\u0018\u0005)B/Z:u\u0015N|gNV1mk\u0016D\u0015m\u001d5D_\u0012,\u0007fA\t\u0002\u0018\u0005)B/Z:u\u0015N|gNV1mk\u0016$vn\u0015;sS:<\u0007f\u0001\n\u0002\u0018\u0005\tB/Z:u\t\u0016\u001cw\u000eZ3C_>dW-\u00198)\u0007M\t9\"\u0001\tuKN$H)Z2pI\u0016\u001cFO]5oO\"\u001aA#a\u0006\u0002\u001bQ,7\u000f\u001e#fG>$W-\u00138uQ\r)\u0012qC\u0001\u000fi\u0016\u001cH\u000fR3d_\u0012,Gj\u001c8hQ\r1\u0012qC\u0001\u0011i\u0016\u001cH\u000fR3d_\u0012,Gi\\;cY\u0016D3aFA\f\u00035!Xm\u001d;EK\u000e|G-Z*fc\"\u001a\u0001$a\u0006\u0002\u001bQ,7\u000f\u001e#fG>$W-T1qQ\rI\u0012qC\u0001\u0011i\u0016\u001cH\u000fR3d_\u0012,w\n\u001d;j_:D3AGA\f\u0001")
public class JsonValueTest {
    private final String json = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n    |{\n    |  \"boolean\": false,\n    |  \"int\": 1234,\n    |  \"long\": 3000000000,\n    |  \"double\": 16.244355,\n    |  \"string\": \"string\",\n    |  \"number_as_string\": \"123\",\n    |  \"array\": [4.0, 11.1, 44.5],\n    |  \"object\": {\n    |    \"a\": true,\n    |    \"b\": false\n    |  },\n    |  \"null\": null\n    |}\n   "));

    private String json() {
        return this.json;
    }

    private JsonValue parse(String s) {
        return (JsonValue)Json$.MODULE$.parseFull(s).getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error(new StringBuilder(22).append("Failed to parse json: ").append(s).toString()));
    }

    private <T> void assertTo(T expected, Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$1) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply(expected), (Object)parsed.toEither(evidence$1));
        Assertions.assertEquals(expected, (Object)parsed.to(evidence$1));
    }

    private <T> void assertToFails(Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$2) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assertions.assertTrue((boolean)parsed.toEither(evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.to(evidence$2), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    public <E extends Throwable> void assertThrow(Function0<BoxedUnit> body, Manifest<E> evidence$3) {
        Class klass = Predef$.MODULE$.manifest(evidence$3).runtimeClass();
        Exception$.MODULE$.catchingPromiscuously((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{klass})).opt(body).foreach((Function1 & Serializable)x$1 -> (Nothing$)Assertions.fail((String)new StringBuilder(53).append("Expected `").append(klass).append("` to be thrown, but no exception was thrown").toString()));
    }

    @Test
    public void testAsJsonObject() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue obj = parsed.apply("object");
        Assertions.assertEquals((Object)obj, (Object)obj.asJsonObject());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.apply("array").asJsonObject(), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonObjectOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assertions.assertTrue((boolean)parsed.apply("object").asJsonObjectOption().isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("array").asJsonObjectOption());
    }

    @Test
    public void testAsJsonArray() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue array = parsed.apply("array");
        Assertions.assertEquals((Object)array, (Object)array.asJsonArray());
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.apply("object").asJsonArray(), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonArrayOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assertions.assertTrue((boolean)parsed.apply("array").asJsonArrayOption().isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("object").asJsonArrayOption());
    }

    @Test
    public void testJsonObjectGet() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assertions.assertEquals((Object)new Some((Object)this.parse("{\"a\":true,\"b\":false}")), (Object)parsed.get("object"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsed.get("aaaaa"));
    }

    @Test
    public void testJsonObjectApply() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assertions.assertEquals((Object)this.parse("{\"a\":true,\"b\":false}"), (Object)parsed.apply("object"));
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.apply("aaaaaaaa"), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testJsonObjectIterator() {
        Assertions.assertEquals((Object)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.parse("true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.parse("false"))})), (Object)this.parse(this.json()).asJsonObject().apply("object").asJsonObject().iterator().toVector());
    }

    @Test
    public void testJsonArrayIterator() {
        Assertions.assertEquals((Object)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"4.0", "11.1", "44.5"}))).map((Function1 & Serializable)s -> this.parse((String)s)), (Object)this.parse(this.json()).asJsonObject().apply("array").asJsonArray().iterator().toVector());
    }

    @Test
    public void testJsonValueEquals() {
        Assertions.assertEquals((Object)this.parse(this.json()), (Object)this.parse(this.json()));
        Assertions.assertEquals((Object)this.parse("{\"blue\": true, \"red\": false}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assertions.assertNotEquals((Object)this.parse("{\"blue\": true, \"red\": true}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assertions.assertEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[1, 2, 3]"));
        Assertions.assertNotEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[2, 1, 3]"));
        Assertions.assertEquals((Object)this.parse("1344"), (Object)this.parse("1344"));
        Assertions.assertNotEquals((Object)this.parse("1344"), (Object)this.parse("144"));
    }

    @Test
    public void testJsonValueHashCode() {
        Assertions.assertEquals((int)new ObjectMapper().readTree(this.json()).hashCode(), (int)this.parse(this.json()).hashCode());
    }

    @Test
    public void testJsonValueToString() {
        String js = "{\"boolean\":false,\"int\":1234,\"array\":[4.0,11.1,44.5],\"object\":{\"a\":true,\"b\":false}}";
        Assertions.assertEquals((Object)js, (Object)this.parse(js).toString());
    }

    @Test
    public void testDecodeBoolean() {
        DecodeJson.DecodeBoolean$ assertTo_evidence$1 = DecodeJson.DecodeBoolean$.MODULE$;
        Boolean assertTo_expected = BoxesRunTime.boxToBoolean((boolean)false);
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("boolean");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeBoolean$ assertToFails_evidence$2 = DecodeJson.DecodeBoolean$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeString() {
        void assertTo_evidence$1;
        DecodeJson.DecodeString$ assertTo_evidence$12 = DecodeJson.DecodeString$.MODULE$;
        String assertTo_expected = "string";
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$12));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$12));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeString$ decodeString$ = DecodeJson.DecodeString$.MODULE$;
        String assertTo_expected2 = "123";
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("number_as_string");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$1));
        Object var4_5 = null;
        decodeString$ = null;
        Object var6_6 = null;
        DecodeJson.DecodeString$ assertToFails_evidence$2 = DecodeJson.DecodeString$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
        Object var7_7 = null;
        Object var8_8 = null;
        DecodeJson.DecodeString$ assertToFails_evidence$22 = DecodeJson.DecodeString$.MODULE$;
        JsonValue assertToFails_parsed2 = this.parse(this.json()).asJsonObject().apply("array");
        Assertions.assertTrue((boolean)assertToFails_parsed2.toEither((DecodeJson)assertToFails_evidence$22).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed2, (DecodeJson)assertToFails_evidence$22)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testDecodeInt() {
        DecodeJson.DecodeInt$ assertTo_evidence$1 = DecodeJson.DecodeInt$.MODULE$;
        Integer assertTo_expected = BoxesRunTime.boxToInteger((int)1234);
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeInt$ assertToFails_evidence$2 = DecodeJson.DecodeInt$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("long");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeLong() {
        void assertTo_evidence$1;
        DecodeJson.DecodeLong$ assertTo_evidence$12 = DecodeJson.DecodeLong$.MODULE$;
        Long assertTo_expected = BoxesRunTime.boxToLong((long)3000000000L);
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("long");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$12));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$12));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeLong$ decodeLong$ = DecodeJson.DecodeLong$.MODULE$;
        Long assertTo_expected2 = BoxesRunTime.boxToLong((long)1234L);
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$1));
        Object var4_5 = null;
        decodeLong$ = null;
        Object var6_6 = null;
        DecodeJson.DecodeLong$ assertToFails_evidence$2 = DecodeJson.DecodeLong$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeDouble() {
        void assertTo_evidence$1;
        void assertTo_evidence$12;
        DecodeJson.DecodeDouble$ assertTo_evidence$13 = DecodeJson.DecodeDouble$.MODULE$;
        Double assertTo_expected = BoxesRunTime.boxToDouble((double)16.244355);
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("double");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$13));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$13));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeDouble$ decodeDouble$ = DecodeJson.DecodeDouble$.MODULE$;
        Double assertTo_expected2 = BoxesRunTime.boxToDouble((double)1234.0);
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$12));
        Assertions.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$12));
        Object var4_5 = null;
        decodeDouble$ = null;
        Object var6_6 = null;
        DecodeJson.DecodeDouble$ decodeDouble$2 = DecodeJson.DecodeDouble$.MODULE$;
        Double assertTo_expected3 = BoxesRunTime.boxToDouble((double)3.0E9);
        JsonValue assertTo_parsed3 = this.parse(this.json()).asJsonObject().apply("long");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected3), (Object)assertTo_parsed3.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected3, (Object)assertTo_parsed3.to((DecodeJson)assertTo_evidence$1));
        Object var7_8 = null;
        decodeDouble$2 = null;
        Object var9_9 = null;
        DecodeJson.DecodeDouble$ assertToFails_evidence$2 = DecodeJson.DecodeDouble$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeSeq() {
        void decodeSeq_factory;
        void decodeSeq_factory2;
        void decodeSeq_factory3;
        void decodeSeq_factory4;
        Factory factory = Seq$.MODULE$.iterableFactory();
        DecodeJson.DecodeDouble$ decodeSeq_decodeJson = DecodeJson.DecodeDouble$.MODULE$;
        Object var10_2 = null;
        factory = null;
        DecodeJson$.anonfun.decodeSeq.3 assertTo_evidence$1 = new /* Unavailable Anonymous Inner Class!! */;
        SeqOps assertTo_expected = Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{4.0, 11.1, 44.5}));
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("array");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var1_4 = null;
        Object var2_3 = null;
        Object var3_5 = null;
        Factory factory2 = Seq$.MODULE$.iterableFactory();
        DecodeJson.DecodeDouble$ decodeSeq_decodeJson2 = DecodeJson.DecodeDouble$.MODULE$;
        Object var12_7 = null;
        factory2 = null;
        DecodeJson$.anonfun.decodeSeq.3 assertToFails_evidence$2 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
        Object var4_8 = null;
        Object var5_9 = null;
        Factory factory3 = Seq$.MODULE$.iterableFactory();
        DecodeJson.DecodeDouble$ decodeSeq_decodeJson3 = DecodeJson.DecodeDouble$.MODULE$;
        Object var14_11 = null;
        factory3 = null;
        DecodeJson$.anonfun.decodeSeq.3 assertToFails_evidence$22 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed2 = this.parse(this.json()).asJsonObject().apply("object");
        Assertions.assertTrue((boolean)assertToFails_parsed2.toEither((DecodeJson)assertToFails_evidence$22).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed2, (DecodeJson)assertToFails_evidence$22)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
        Object var6_12 = null;
        Object var7_13 = null;
        Factory factory4 = Seq$.MODULE$.iterableFactory();
        DecodeJson.DecodeString$ decodeSeq_decodeJson4 = DecodeJson.DecodeString$.MODULE$;
        Object var16_15 = null;
        factory4 = null;
        DecodeJson$.anonfun.decodeSeq.3 assertToFails_evidence$23 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed3 = this.parse(this.json()).asJsonObject().apply("array");
        Assertions.assertTrue((boolean)assertToFails_parsed3.toEither((DecodeJson)assertToFails_evidence$23).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed3, (DecodeJson)assertToFails_evidence$23)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeMap() {
        void decodeMap_factory;
        void decodeMap_factory2;
        void decodeMap_factory3;
        void decodeMap_factory4;
        Factory factory = Map$.MODULE$.mapFactory();
        DecodeJson.DecodeBoolean$ decodeMap_decodeJson = DecodeJson.DecodeBoolean$.MODULE$;
        Object var10_2 = null;
        factory = null;
        DecodeJson$.anonfun.decodeMap.4 assertTo_evidence$1 = new /* Unavailable Anonymous Inner Class!! */;
        Object assertTo_expected = Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("object");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply(assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var1_4 = null;
        Object var2_3 = null;
        Object var3_5 = null;
        Factory factory2 = Map$.MODULE$.mapFactory();
        DecodeJson.DecodeInt$ decodeMap_decodeJson2 = DecodeJson.DecodeInt$.MODULE$;
        Object var12_7 = null;
        factory2 = null;
        DecodeJson$.anonfun.decodeMap.4 assertToFails_evidence$2 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("object");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
        Object var4_8 = null;
        Object var5_9 = null;
        Factory factory3 = Map$.MODULE$.mapFactory();
        DecodeJson.DecodeString$ decodeMap_decodeJson3 = DecodeJson.DecodeString$.MODULE$;
        Object var14_11 = null;
        factory3 = null;
        DecodeJson$.anonfun.decodeMap.4 assertToFails_evidence$22 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed2 = this.parse(this.json()).asJsonObject().apply("object");
        Assertions.assertTrue((boolean)assertToFails_parsed2.toEither((DecodeJson)assertToFails_evidence$22).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed2, (DecodeJson)assertToFails_evidence$22)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
        Object var6_12 = null;
        Object var7_13 = null;
        Factory factory4 = Map$.MODULE$.mapFactory();
        DecodeJson.DecodeDouble$ decodeMap_decodeJson4 = DecodeJson.DecodeDouble$.MODULE$;
        Object var16_15 = null;
        factory4 = null;
        DecodeJson$.anonfun.decodeMap.4 assertToFails_evidence$23 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed3 = this.parse(this.json()).asJsonObject().apply("array");
        Assertions.assertTrue((boolean)assertToFails_parsed3.toEither((DecodeJson)assertToFails_evidence$23).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed3, (DecodeJson)assertToFails_evidence$23)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeOption() {
        void assertTo_evidence$1;
        DecodeJson.DecodeInt$ decodeOption_decodeJson = DecodeJson.DecodeInt$.MODULE$;
        Object var9_1 = null;
        DecodeJson$.anonfun.decodeOption.3 assertTo_evidence$12 = new /* Unavailable Anonymous Inner Class!! */;
        None$ assertTo_expected = None$.MODULE$;
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("null");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$12));
        Assertions.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$12));
        Object var1_3 = null;
        Object var2_2 = null;
        Object var3_4 = null;
        DecodeJson.DecodeInt$ decodeOption_decodeJson2 = DecodeJson.DecodeInt$.MODULE$;
        Object var10_5 = null;
        DecodeJson$.anonfun.decodeOption.3 var5_6 = new /* Unavailable Anonymous Inner Class!! */;
        Some assertTo_expected2 = new Some((Object)BoxesRunTime.boxToInteger((int)1234));
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$1));
        Assertions.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$1));
        Object var4_7 = null;
        var5_6 = null;
        Object var6_8 = null;
        DecodeJson.DecodeString$ decodeOption_decodeJson3 = DecodeJson.DecodeString$.MODULE$;
        Object var11_9 = null;
        DecodeJson$.anonfun.decodeOption.3 assertToFails_evidence$2 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assertions.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeBoolean$1(JsonObject x$2) {
        return x$2.apply("boolean");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeBoolean$2(JsonObject x$3) {
        return x$3.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$1(JsonObject x$4) {
        return x$4.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$2(JsonObject x$5) {
        return x$5.apply("number_as_string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$3(JsonObject x$6) {
        return x$6.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$4(JsonObject x$7) {
        return x$7.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeInt$1(JsonObject x$8) {
        return x$8.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeInt$2(JsonObject x$9) {
        return x$9.apply("long");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeLong$1(JsonObject x$10) {
        return x$10.apply("long");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeLong$2(JsonObject x$11) {
        return x$11.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeLong$3(JsonObject x$12) {
        return x$12.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$1(JsonObject x$13) {
        return x$13.apply("double");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$2(JsonObject x$14) {
        return x$14.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$3(JsonObject x$15) {
        return x$15.apply("long");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$4(JsonObject x$16) {
        return x$16.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$1(JsonObject x$17) {
        return x$17.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$2(JsonObject x$18) {
        return x$18.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$3(JsonObject x$19) {
        return x$19.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$4(JsonObject x$20) {
        return x$20.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$1(JsonObject x$21) {
        return x$21.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$2(JsonObject x$22) {
        return x$22.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$3(JsonObject x$23) {
        return x$23.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$4(JsonObject x$24) {
        return x$24.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeOption$1(JsonObject x$25) {
        return x$25.apply("null");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeOption$2(JsonObject x$26) {
        return x$26.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeOption$3(JsonObject x$27) {
        return x$27.apply("int");
    }
}

