/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.BrokerFeatures$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.epoch.util.MockBlockingSender;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r]b\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004X\u0001\u0001\u0006I\u0001\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0003L\u0011\u0019I\u0006\u0001)A\u0005\u0019\"9!\f\u0001b\u0001\n\u0013Y\u0005BB.\u0001A\u0003%A\nC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011\u001d\u0011\u0007A1A\u0005\nuCaa\u0019\u0001!\u0002\u0013q\u0006b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007i\u0002\u0001\u000b\u0011\u00024\t\u000fU\u0004!\u0019!C\u0005m\"1Q\u0010\u0001Q\u0001\n]DqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\b\u0001\u0001\u000b\u0011BA\u0001\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0007\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u001a\u0011%\t\t\u0005\u0001a\u0001\n\u0013\t\u0019\u0005C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!A\u0011q\f\u0001!B\u0013\t)\u0005C\u0004\u0002b\u0001!I!a\u0019\t\u0013\u0005%\u0005!%A\u0005\n\u0005-\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003GCqA!\u0006\u0001\t\u0003\t\u0019\u000bC\u0004\u0003\u001a\u0001!\tAa\u0007\t\u000f\te\u0002\u0001\"\u0001\u0002$\"9!Q\b\u0001\u0005\u0002\u0005\r\u0006b\u0002B!\u0001\u0011\u0005\u00111\u0015\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011%\u0011i\u0006AI\u0001\n\u0013\tY\tC\u0004\u0003`\u0001!\t!a)\t\u000f\t\r\u0004\u0001\"\u0001\u0002$\"9!q\r\u0001\u0005\u0002\u0005\r\u0006b\u0002B6\u0001\u0011\u0005\u00111\u0015\u0005\b\u0005_\u0002A\u0011AAR\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0003GCqAa\u001e\u0001\t\u0003\t\u0019\u000bC\u0004\u0003|\u0001!\t!a)\t\u000f\t}\u0004\u0001\"\u0001\u0002$\"9!1\u0011\u0001\u0005\u0002\u0005\r\u0006b\u0002BD\u0001\u0011\u0005\u00111\u0015\u0005\b\u0005\u0017\u0003A\u0011AAR\u0011\u001d\u0011y\t\u0001C\u0001\u0003GCqAa%\u0001\t\u0003\t\u0019\u000bC\u0004\u0003\u0018\u0002!\tA!'\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\"9!1\u0019\u0001\u0005\n\tM\bbBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u0007'\u0001A\u0011AB\u000b\u0011\u001d\u0019\u0019\u0004\u0001C\u0005\u0007k\u0011\u0001DU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$G+Z:u\u0015\tYD(\u0001\u0004tKJ4XM\u001d\u0006\u0002{\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0013\t\u0003\u0013\u0002i\u0011AO\u0001\u0005iF\u0002\b'F\u0001M!\tiU+D\u0001O\u0015\ty\u0005+\u0001\u0004d_6lwN\u001c\u0006\u0003{ES!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO&\u0011aK\u0014\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0015!\u0018\u0007\u001d\u0019!\u0003\u0011!\u0018\u0007]\u0019\u0002\u000bQ\f\u0004/\r\u0011\u0002\tQ\u0014\u0004/M\u0001\u0006iJ\u0002\u0018\u0007I\u0001\ti>\u0004\u0018nY%ecU\ta\f\u0005\u0002N?&\u0011\u0001M\u0014\u0002\u0005+VLG-A\u0005u_BL7-\u001332A\u0005AAo\u001c9jG&#''A\u0005u_BL7-\u001333A\u0005AAo\u001c9jG&#7/F\u0001g!\u00119'\u000e\u001c0\u000e\u0003!T!!\u001b\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002lQ\n\u0019Q*\u00199\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00027b]\u001eT\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\n11\u000b\u001e:j]\u001e\f\u0011\u0002^8qS\u000eLEm\u001d\u0011\u0002\u001d\t\u0014xn[3s\u000b:$\u0007k\\5oiV\tq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{y\u000591\r\\;ti\u0016\u0014\u0018B\u0001?z\u00059\u0011%o\\6fe\u0016sG\rU8j]R\fqB\u0019:pW\u0016\u0014XI\u001c3Q_&tG\u000fI\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N,\"!!\u0001\u0011\u0007%\u000b\u0019!C\u0002\u0002\u0006i\u0012\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002#\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t+\t\ti\u0001\u0005\u0004\u0002\u0010\u0005U\u0011\u0011D\u0007\u0003\u0003#Q1!a\u0005q\u0003\u0011)H/\u001b7\n\t\u0005]\u0011\u0011\u0003\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u001c\u0005\u001db\u0002BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005b*A\u0004nKN\u001c\u0018mZ3\n\t\u0005\u0015\u0012qD\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0002*\u0005-\"\u0001H+qI\u0006$X-T3uC\u0012\fG/\u0019)beRLG/[8o'R\fG/\u001a\u0006\u0005\u0003K\ty\"\u0001\tqCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005)R\u000f\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$XCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d\u001d\u0006A!/Z9vKN$8/\u0003\u0003\u0002>\u0005]\"!F+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f^\u0001\u0017kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:uA\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\"!!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013;\u0003!iW\r^1eCR\f\u0017\u0002BA(\u0003\u0013\u0012qBW6NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u0012[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3`I\u0015\fH\u0003BA+\u00037\u00022!QA,\u0013\r\tIF\u0011\u0002\u0005+:LG\u000fC\u0005\u0002^]\t\t\u00111\u0001\u0002F\u0005\u0019\u0001\u0010J\u0019\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005\t\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3\u0015\u0011\u0005\u0015\u00141NA;\u0003\u007f\u00022!SA4\u0013\r\tIG\u000f\u0002\u0012\u0013:LG/[1m\r\u0016$8\r[*uCR,\u0007bBA73\u0001\u0007\u0011qN\u0001\bi>\u0004\u0018nY%e!\u0011\t\u0015\u0011\u000f0\n\u0007\u0005M$I\u0001\u0004PaRLwN\u001c\u0005\b\u0003oJ\u0002\u0019AA=\u0003-1W\r^2i\u001f\u001a47/\u001a;\u0011\u0007\u0005\u000bY(C\u0002\u0002~\t\u0013A\u0001T8oO\"I\u0011\u0011Q\r\u0011\u0002\u0003\u0007\u00111Q\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eE\u0002B\u0003\u000bK1!a\"C\u0005\rIe\u000e^\u0001\u001cS:LG/[1m\r\u0016$8\r[*uCR,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u00055%\u0006BAB\u0003\u001f[#!!%\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\u0013\u0015AC1o]>$\u0018\r^5p]&!\u0011qTAK\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\bG2,\u0017M\\;q)\t\t)\u0006K\u0002\u001c\u0003O\u0003B!!+\u000286\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+A\u0002ba&TA!!-\u00024\u00069!.\u001e9ji\u0016\u0014(bAA['\u0006)!.\u001e8ji&!\u0011\u0011XAV\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000ede\u0016\fG/\u001a*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0006\t\u0002@\u0006\u0015\u0017Q\\Aq\u0003W\fi/a>\u0003\u0002A\u0019\u0011*!1\n\u0007\u0005\r'H\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0003\u000fd\u0002\u0019AAe\u0003\u0011q\u0017-\\3\u0011\t\u0005-\u0017\u0011\u001c\b\u0005\u0003\u001b\f)\u000eE\u0002\u0002P\nk!!!5\u000b\u0007\u0005Mg(\u0001\u0004=e>|GOP\u0005\u0004\u0003/\u0014\u0015A\u0002)sK\u0012,g-C\u0002t\u00037T1!a6C\u0011\u001d\ty\u000e\ba\u0001\u0003\u0007\u000b\u0011BZ3uG\",'/\u00133\t\u000f\u0005\rH\u00041\u0001\u0002f\u0006a!M]8lKJ\u001cuN\u001c4jOB\u0019\u0011*a:\n\u0007\u0005%(HA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002@\u001d\u0001\u0004\t\t\u0001C\u0004\u0002pr\u0001\r!!=\u0002\u0015I,\u0007\u000f\\5dC6;'\u000fE\u0002J\u0003gL1!!>;\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!!?\u001d\u0001\u0004\tY0A\u0003rk>$\u0018\rE\u0002J\u0003{L1!a@;\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0011\u001d\u0011\u0019\u0001\ba\u0001\u0005\u000b\t!\u0004\\3bI\u0016\u0014XI\u001c3q_&tGO\u00117pG.LgnZ*f]\u0012\u00042!\u0013B\u0004\u0013\r\u0011IA\u000f\u0002\r\u00052|7m[5oON+g\u000eZ\u0001)g\"|W\u000f\u001c3TK:$G*\u0019;fgR\u0014V-];fgR4VM]:j_:\u001c()\u001f#fM\u0006,H\u000e\u001e\u0015\u0004;\t=\u0001\u0003BAU\u0005#IAAa\u0005\u0002,\n!A+Z:u\u0003y\"Xm\u001d;GKR\u001c\u0007\u000eT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti&3G*Y:u\u000bB|7\r\u001b#fM&tW\r\u001a$peN{W.\u001a)beRLG/[8og\"\u001aaDa\u0004\u0002+\u0005\u001c8/\u001a:u!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgRQ\u0011Q\u000bB\u000f\u0005O\u0011\tD!\u000e\t\u000f\t}q\u00041\u0001\u0003\"\u00059a-\u001a;dQ\u0016\u0014\bcA%\u0003$%\u0019!Q\u0005\u001e\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\"9!\u0011F\u0010A\u0002\t-\u0012!F:i_VdGMQ3SK\u0006$\u0017PR8s\r\u0016$8\r\u001b\t\u0004\u0003\n5\u0012b\u0001B\u0018\u0005\n9!i\\8mK\u0006t\u0007b\u0002B\u001a?\u0001\u0007!1F\u0001\u0016g\"|W\u000f\u001c3CKR\u0013XO\\2bi&tw\rT8h\u0011\u001d\u00119d\ba\u0001\u0005W\tqb\u001d5pk2$')\u001a#fY\u0006LX\rZ\u0001&g\"|W\u000f\u001c3IC:$G.Z#yG\u0016\u0004H/[8o\rJ|WN\u00117pG.LgnZ*f]\u0012D3\u0001\tB\b\u0003\r\u001b\bn\\;mI\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ>sG._%g\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00138po:$vNQ8uQ&\u0013\u0007O\r\u001c)\u0007\u0005\u0012y!\u0001\u001dtQ>,H\u000e\u001a(pi\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ^KG\u000f\u001b+sk:\u001c\u0017\r^3P]\u001a+Go\u00195)\u0007\t\u0012y!\u0001\u0012wKJLg-\u001f$fi\u000eDG*Z1eKJ,\u0005o\\2i\u001f:4\u0015N]:u\r\u0016$8\r\u001b\u000b\u0007\u0003+\u0012IE!\u0017\t\u000f\t-3\u00051\u0001\u0003N\u0005\u0019\u0011N\u00199\u0011\t\t=#QK\u0007\u0003\u0005#R1a\u0014B*\u0015\tY\u0004+\u0003\u0003\u0003X\tE#aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\t\u0013\tm3\u0005%AA\u0002\u0005\r\u0015aD3q_\u000eDg)\u001a;dQ\u000e{WO\u001c;\u0002YY,'/\u001b4z\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"|eNR5sgR4U\r^2iI\u0011,g-Y;mi\u0012\u0012\u0014\u0001N:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u001f\u001a47/\u001a;Ta\u0016\u001c\u0017NZ5fI&sW\t]8dQ>3gm]3u%\u0016\u001c\bo\u001c8tK\"\u001aQEa\u0004\u0002\u001bNDw.\u001e7e)J,hnY1uKR{wJ\u001a4tKR\u001c\u0006/Z2jM&,G-\u00138Fa>\u001c\u0007n\u00144gg\u0016$(+Z:q_:\u001cX-\u00134G_2dwn^3s\u0011\u0006\u001chj\\'pe\u0016,\u0005o\\2ig\"\u001aaEa\u0004\u0002\u0015NDw.\u001e7e\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"\u001cVmY8oIRKW.Z%g\u0019\u0016\fG-\u001a:SKBd\u0017.Z:XSRDW\t]8dQ:{Go\u00138po:$vNR8mY><XM\u001d\u0015\u0004O\t=\u0011!Q:i_VdG\r\u0016:v]\u000e\fG/Z%g\u0019\u0016\fG-\u001a:SKBd\u0017.Z:XSRDG)\u001b<fe\u001eLgnZ#q_\u000eDgj\u001c;L]><h\u000eV8G_2dwn^3sQ\rA#qB\u0001.i\u0016\u001cH\u000f\u0016:v]\u000e\fG/Z(o\r\u0016$8\r\u001b#pKNtu\u000e^+qI\u0006$X\rS5hQ^\u000bG/\u001a:nCJ\\\u0007fA\u0015\u0003\u0010\u0005\u00194\u000f[8vY\u0012,6/\u001a'fC\u0012,'/\u00128e\u001f\u001a47/\u001a;JM&sG/\u001a:Ce>\\WM\u001d,feNLwN\u001c\"fY><(\u0007\r\u0015\u0004U\t=\u0011\u0001Q:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u0013:LG/[1m\r\u0016$8\r[(gMN,G/\u00134MK\u0006$WM\u001d*fiV\u0014hn]+oI\u00164\u0017N\\3e\u001f\u001a47/\u001a;)\u0007-\u0012y!A\u0019tQ>,H\u000e\u001a)pY2Le\u000eZ3gS:LG/\u001a7z\u0013\u001adU-\u00193feJ+G/\u001e:og\u0006s\u00170\u0012=dKB$\u0018n\u001c8)\u00071\u0012y!A\u0016tQ>,H\u000eZ'pm\u0016\u0004\u0016M\u001d;ji&|gn](vi>3GK];oG\u0006$\u0018N\\4M_\u001e\u001cF/\u0019;fQ\ri#qB\u00019g\"|W\u000f\u001c3GS2$XM\u001d)beRLG/[8og6\u000bG-\u001a'fC\u0012,'\u000fR;sS:<G*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:uQ\rq#qB\u0001Ig\"|W\u000f\u001c3DCR\u001c\u0007.\u0012=dKB$\u0018n\u001c8Ge>l'\t\\8dW&twmU3oI^CWM\\*ikR$\u0018N\\4E_^t'+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D3a\fB\b\u0003\u0019\u001a\bn\\;mIV\u0003H-\u0019;f%\u0016\f7o]5h]6,g\u000e\u001e\"zi\u0016\u001c\u0018J\\'fiJL7m\u001d\u0015\u0004a\t=\u0011AR:i_VdGMT8u+B$\u0017\r^3SK\u0006\u001c8/[4o[\u0016tGOQ=uKNLe.T3ue&\u001c7o\u00165f]:{'+Z1tg&<g.\\3oiNLe\u000e\u0015:pOJ,7o\u001d\u0015\u0004c\t=\u0011A\u0004;fgR\u0014U/\u001b7e\r\u0016$8\r\u001b\u0015\u0004e\t=\u0011A\f;fgRdunY1m\r\u0016$8\r[\"p[BdW\r^5p]&3\u0007*[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012$B!!\u0016\u0003\u001c\"9!QT\u001aA\u0002\t-\u0012\u0001\u00065jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,G\rK\u00044\u0005C\u0013\tLa-\u0011\t\t\r&QV\u0007\u0003\u0005KSAAa*\u0003*\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0003,\u0006=\u0016A\u00029be\u0006l7/\u0003\u0003\u00030\n\u0015&a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0005k\u00139,G\u0001\u00023\u0005\u0001\u0001fA\u001a\u0003<B!!Q\u0018B`\u001b\t\u0011I+\u0003\u0003\u0003B\n%&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\tc.Z<PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u0014Vm];miRA!q\u0019Bu\u0005[\u0014y\u000f\u0005\u0003\u0003J\n\rh\u0002\u0002Bf\u0005?tAA!4\u0003^:!!q\u001aBn\u001d\u0011\u0011\tN!7\u000f\t\tM'q\u001b\b\u0005\u0003\u001f\u0014).C\u0001U\u0013\t\u00116+\u0003\u0002>#&\u0011q\nU\u0005\u0004\u0003Cq\u0015\u0002\u0002Bq\u0003?\t\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC&!!Q\u001dBt\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRTAA!9\u0002 !1!1\u001e\u001bA\u00021\u000b!\u0001\u001e9\t\u000f\u0005\u0005E\u00071\u0001\u0002\u0004\"9!\u0011\u001f\u001bA\u0002\u0005e\u0014!C3oI>3gm]3u))\u00119M!>\u0003x\u000e\u001d1\u0011\u0002\u0005\u0007\u0005W,\u0004\u0019\u0001'\t\u000f\teX\u00071\u0001\u0003|\u0006)QM\u001d:peB!!Q`B\u0002\u001b\t\u0011yPC\u0002\u0004\u00029\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0007\u000b\u0011yP\u0001\u0004FeJ|'o\u001d\u0005\b\u0003\u0003+\u0004\u0019AAB\u0011\u001d\u0011\t0\u000ea\u0001\u0003s\na$Y:tKJ$\bK]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006<\u0006.\u001a8\u0015\t\u0005U3q\u0002\u0005\b\u0007#1\u0004\u0019\u0001B\u0016\u00035I7OU3bgNLwM\\5oO\u0006!1\u000f^;c)!\t)fa\u0006\u0004\"\r\u0015\u0002bBB\ro\u0001\u000711D\u0001\na\u0006\u0014H/\u001b;j_:\u00042\u0001_B\u000f\u0013\r\u0019y\"\u001f\u0002\n!\u0006\u0014H/\u001b;j_:Dqaa\t8\u0001\u0004\t\t0\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\t\u000f\r\u001dr\u00071\u0001\u0004*\u0005\u0019An\\4\u0011\t\r-2qF\u0007\u0003\u0007[Q1aa\n=\u0013\u0011\u0019\td!\f\u0003\u0015Us\u0017NZ5fI2{w-\u0001\u000flC\u001a\\\u0017mQ8oM&<gj\u001c+sk:\u001c\u0017\r^3P]\u001a+Go\u00195\u0016\u0005\u0005\u0015\b")
public class ReplicaFetcherThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final Uuid topicId1 = Uuid.randomUuid();
    private final Uuid topicId2 = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)this.topicId2())}));
    private final BrokerEndPoint brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions = new FailedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic2").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), (List)Nil$.MODULE$))).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicIds()).asJava()).build();
    private ZkMetadataCache metadataCache = new ZkMetadataCache(0, MetadataVersion.latest(), BrokerFeatures$.MODULE$.createEmpty(), (Seq)Seq$.MODULE$.empty());

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    private Uuid topicId1() {
        return this.topicId1;
    }

    private Uuid topicId2() {
        return this.topicId2;
    }

    private Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    private BrokerEndPoint brokerEndPoint() {
        return this.brokerEndPoint;
    }

    public FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(ZkMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$3() {
        return 1;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private ReplicaFetcherThread createReplicaFetcherThread(String name, int fetcherId, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, BlockingSend leaderEndpointBlockingSend) {
        LogContext logContext = new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(brokerConfig.brokerId()).append(", leaderId=").append(leaderEndpointBlockingSend.brokerEndPoint().id()).append(", fetcherId=").append(fetcherId).append("] ").toString());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, leaderEndpointBlockingSend.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), leaderEndpointBlockingSend, fetchSessionHandler, brokerConfig, replicaMgr, quota, (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion());
        return new ReplicaFetcherThread(name, (LeaderEndPoint)leader, brokerConfig, failedPartitions, replicaMgr, quota, logContext.logPrefix(), (Function0 & Serializable)() -> brokerConfig.interBrokerProtocolVersion());
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Assertions.assertEquals((short)ApiKeys.FETCH.latestVersion(), (short)config.interBrokerProtocolVersion().fetchRequestVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)config.interBrokerProtocolVersion().offsetForLeaderEpochRequestVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)config.interBrokerProtocolVersion().listOffsetRequestVersion());
    }

    @Test
    public void testFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)3))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        new .colon.colon((Object)this.t1p0(), (List)new .colon.colon((Object)this.t1p1(), (List)new .colon.colon((Object)this.t2p1(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Map result = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, null, mockBlockingSend).leader().fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))), (Object)result, (String)"results from leader epoch request should have undefined offset");
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any());
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBothIbp26() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.IBP_2_6_IV0, 1);
    }

    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(MetadataVersion.latest(), 0);
    }

    private void verifyFetchLeaderEpochOnFirstFetch(MetadataVersion ibp, int epochFetchCount) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.metadataCache_$eq(new ZkMetadataCache(0, ibp, BrokerFeatures$.MODULE$.createEmpty(), (Seq)Seq$.MODULE$.empty()));
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
    }

    private int verifyFetchLeaderEpochOnFirstFetch$default$2() {
        return 1;
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 1L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpoch, 172L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)172)), (String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 3L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpochAtLeader)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpochAtLeader, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpochAtLeader, 202L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)), (String)new StringBuilder(55).append("Expected ").append(this.t2p1()).append(" to truncate to offset ").append(initialLEO).append(" (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 4, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 4, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.fetchCount());
        java.util.Map nextOffsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 3, 101L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 3, 102L))}))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertTrue((mockNetwork.lastUsedOffsetForLeaderEpochVersion() >= 3 ? 1 : 0) != 0, (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)102)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 102 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)101)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 101 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        ObjectRef latestLogEpoch = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)115L));
        Mockito.when((Object)log.latestEpoch()).thenAnswer(x$1 -> (Option)latestLogEpoch$1.elem);
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(129L, 2)));
        Mockito.when((Object)log.endOffsetForEpoch(2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(119L, 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), (Time)new SystemTime());
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, this.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, fetchSessionHandler, config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        ReplicaFetcherThread thread = new ReplicaFetcherThread(this, leader, config, replicaManager, quota, logContext){

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                return None$.MODULE$;
            }
        };
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1))})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1()}));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$3(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(141L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = new Some((Object)BoxesRunTime.boxToInteger((int)4));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)140)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 140 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)141)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 141 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(130L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(131L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)129)), (String)new StringBuilder(57).append("Expected to truncate to offset 129 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(120L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(121L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = None$.MODULE$;
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)4, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)6))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)119)), (String)new StringBuilder(57).append("Expected to truncate to offset 119 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(thread, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testTruncateOnFetchDoesNotUpdateHighWatermark() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int logEndOffset = 150;
        int highWatermark = 130;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWatermark)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(logEndOffset)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        MockBlockingSender mockNetwork = new MockBlockingSender(Collections.emptyMap(), this.brokerEndPoint(), (Time)new SystemTime());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), (BlockingSend)mockNetwork, new FetchSessionHandler(logContext, this.brokerEndPoint().id()), config, replicaManager, (ReplicaQuota)quota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("fetcher-thread", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, logContext.logPrefix(), (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), logEndOffset, 1))})));
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setHighWatermark(160L).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)1))).truncateTo(140L, false);
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)0))).maybeUpdateHighWatermark(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), -1, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), -1, 143L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsets, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.lastUsedOffsetForLeaderEpochVersion(), (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)155)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 155 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)143)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 143 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialFetchOffset)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialFetchOffset, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWaterMark = 100;
        int initialLeo = 300;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWaterMark)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLeo)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        offsetsReply.put(this.t1p0(), this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 156L));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 4;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$3 -> x$3.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$4 -> x$4.state()));
        thread.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$5 -> x$5.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$6 -> x$6.state()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(0L, false);
    }

    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(5)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 5, 52L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 5, 49L))}))).asJava();
        MockBlockingSender mockNetwork = new MockBlockingSender(offsetsReply, this.brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, (ReplicaQuota)quota, mockNetwork);
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        TopicPartition partitionThatBecameLeader = this.t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> thread.removePartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionThatBecameLeader}))));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        mockBlockingSend.initiateClose();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalArgumentException()});
        mockBlockingSend.close();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalStateException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, null, mockBlockingSend);
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).initiateClose();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).close();
    }

    @Test
    public void shouldUpdateReassignmentBytesInMetrics() {
        this.assertProcessPartitionDataWhen(true);
    }

    @Test
    public void shouldNotUpdateReassignmentBytesInMetricsWhenNoReassignmentsInProgress() {
        this.assertProcessPartitionDataWhen(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBuildFetch() {
        void var25_25;
        void var17_17;
        TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId1(), this.t1p0());
        TopicIdPartition tid1p1 = new TopicIdPartition(this.topicId1(), this.t1p1());
        TopicIdPartition tid2p1 = new TopicIdPartition(this.topicId2(), this.t2p1());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaQuota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        LogContext logContext = new LogContext(new StringBuilder(52).append("[ReplicaFetcher replicaId=").append(config.brokerId()).append(", leaderId=").append(this.brokerEndPoint().id()).append(", fetcherId=0] ").toString());
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, this.brokerEndPoint().id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), mockBlockingSend, fetchSessionHandler, config, replicaManager, replicaQuota, (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", (LeaderEndPoint)leader, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, logContext.logPrefix(), (Function0 & Serializable)() -> config.interBrokerProtocolVersion());
        int leaderEpoch = 1;
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId2()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.leader().buildFetch(partitionMap);
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Assertions.assertTrue((boolean)var17_17.isDefined());
        FetchRequest.Builder fetchRequestBuilder = ((AbstractFetcherThread.ReplicaFetch)var17_17.get()).fetchRequest();
        Map partitionDataMap = (Map)partitionMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                PartitionFetchState state = (PartitionFetchState)x0$1._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap).asJava(), (Object)fetchRequestBuilder.fetchData());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.replaced().size());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.removed().size());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        responseData.put(tid1p0, new FetchResponseData.PartitionData());
        responseData.put(tid1p1, new FetchResponseData.PartitionData());
        responseData.put(tid2p1, new FetchResponseData.PartitionData());
        FetchResponse fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, responseData);
        leader.fetchSessionHandler().handleResponse(fetchResponse, ApiKeys.FETCH.latestVersion());
        Uuid newTopicId = Uuid.randomUuid();
        Map partitionMap2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)newTopicId), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.leader().buildFetch(partitionMap2);
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt2 = (Option)resultWithPartitions2.result();
        Map partitionDataMap2 = (Map)((MapOps)partitionMap2.drop(1)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                PartitionFetchState state = (PartitionFetchState)x0$2._2();
                return new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            }
            throw new MatchError(null);
        });
        Assertions.assertTrue((boolean)var25_25.isDefined());
        FetchRequest.Builder fetchRequestBuilder2 = ((AbstractFetcherThread.ReplicaFetch)var25_25.get()).fetchRequest();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap2).asJava(), (Object)fetchRequestBuilder2.fetchData());
        Assertions.assertEquals(Collections.singletonList(tid2p1), (Object)fetchRequestBuilder2.replaced());
        Assertions.assertEquals(Collections.singletonList(tid1p0), (Object)fetchRequestBuilder2.removed());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLocalFetchCompletionIfHighWatermarkUpdated(boolean highWatermarkUpdated) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        long highWatermarkReceivedFromLeader = 100L;
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        None$ maybeNewHighWatermark = highWatermarkUpdated ? new Some((Object)BoxesRunTime.boxToLong((long)highWatermarkReceivedFromLeader)) : None$.MODULE$;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.maybeUpdateHighWatermark(highWatermarkReceivedFromLeader)).thenReturn((Object)maybeNewHighWatermark);
        Some appendInfo = new Some(Mockito.mock(LogAppendInfo.class));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica((MemoryRecords)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()))).thenReturn((Object)appendInfo);
        Buffer completeDelayedFetchRequestsArgument = (Buffer)Buffer$.MODULE$.empty();
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        replicaManager.completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> (Buffer)completeDelayedFetchRequestsArgument.$plus$plus$eq((IterableOnce)((scala.collection.immutable.Seq)invocation.getArguments()[0])));
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("replica-fetcher", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, mockBlockingSend);
        TopicPartition tp0 = new TopicPartition("testTopic", 0);
        TopicPartition tp1 = new TopicPartition("testTopic", 1);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var20_18 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setRecords((BaseRecords)records).setHighWatermark(highWatermarkReceivedFromLeader);
        thread.processPartitionData(tp0, 0L, partitionData.setPartitionIndex(0));
        thread.processPartitionData(tp1, 0L, partitionData.setPartitionIndex(1));
        ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        thread.doWork();
        if (highWatermarkUpdated) {
            Assertions.assertEquals((Object)new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$)), (Object)completeDelayedFetchRequestsArgument);
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)1))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        } else {
            ((ReplicaManager)Mockito.verify((Object)replicaManager, (VerificationMode)Mockito.times((int)0))).completeDelayedFetchRequests((Seq)ArgumentMatchers.any());
        }
        Assertions.assertEquals((Object)Buffer$.MODULE$.empty(), (Object)thread.partitionsWithNewHighWatermark());
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, int leaderEpoch, long endOffset) {
        return this.newOffsetForLeaderPartitionResult(tp, Errors.NONE, leaderEpoch, endOffset);
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void assertProcessPartitionDataWhen(boolean isReassigning) {
        void withRecords_records;
        void withRecords_timestampType;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.brokerEndPoint()).thenReturn((Object)this.brokerEndPoint());
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var13_7 = null;
        simpleRecordArray = null;
        MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Mockito.when((Object)log.maybeUpdateHighWatermark(0L)).thenReturn((Object)None$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isReassigning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isAddingLocalReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)partition.appendRecordsToFollowerOrFutureReplica(records, false)).thenReturn((Object)None$.MODULE$);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = this.createReplicaFetcherThread("bob", 0, config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, replicaQuota, mockBlockingSend);
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setRecords((BaseRecords)records);
        thread.processPartitionData(this.t1p0(), 0L, partitionData);
        if (isReassigning) {
            Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        } else {
            Assertions.assertEquals((long)0L, (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        }
        Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().replicationBytesInRate().get()).count());
    }

    public void stub(Partition partition, ReplicaManager replicaManager, UnifiedLog log) {
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t2p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t2p1())).thenReturn((Object)partition);
    }

    private KafkaConfig kafkaConfigNoTruncateOnFetch() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), MetadataVersion.IBP_2_6_IV0.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assertions.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeReadyForFetch$1 ? " NOT" : "")).append(" be ready for fetching").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeTruncatingLog$1 ? " NOT" : "")).append(" be truncating its log").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()), (String)new StringBuilder(28).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeDelayed$1 ? " NOT" : "")).append(" be delayed").toString());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$3(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    private static final FetchResponseData.PartitionData partitionData$1(int partition, FetchResponseData.EpochEndOffset divergingEpoch) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setLastStableOffset(0L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$6(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public ReplicaFetcherThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

