/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer;
import kafka.server.BrokerServer;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.testkit.BrokerNode;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t=h\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0001;\u0011\u0019)\u0005\u0001)A\u0005w!)a\t\u0001C\u0001\u000f\")a\u000b\u0001C\u0001\u000f\")\u0001\f\u0001C\u0001\u000f\")!\f\u0001C\u0001\u000f\")A\f\u0001C\u0001\u000f\")a\f\u0001C\u0001\u000f\")\u0001\r\u0001C\u0001\u000f\")!\r\u0001C\u0001\u000f\")A\r\u0001C\u0001\u000f\")a\r\u0001C\u0005O\"I\u0011\u0011\u0006\u0001\u0012\u0002\u0013%\u00111\u0006\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002<\u0002!I!!0\t\r\u00055\u0007\u0001\"\u0001H\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!1\f\u0001\u0005\n\tu\u0003\"\u0003B;\u0001E\u0005I\u0011\u0002B<\u0011\u0019\u0011Y\b\u0001C\u0001\u000f\"1!q\u0010\u0001\u0005\u0002\u001dCqAa!\u0001\t\u0003\u0011)\t\u0003\u0004\u0003\u0018\u0002!\ta\u0012\u0005\b\u00057\u0003A\u0011\u0002BO\u0011\u001d\u0011\t\f\u0001C\u0005\u0005gCqA!/\u0001\t\u0013\u0011Y\f\u0003\u0004\u0003B\u0002!\ta\u0012\u0005\b\u0005\u000b\u0004A\u0011\u0001Bd\u0011\u0019\u0011Y\r\u0001C\u0001\u000f\"1!q\u001a\u0001\u0005\u0002\u001dCaAa5\u0001\t\u00039%\u0001E&SC\u001a$8\t\\;ti\u0016\u0014H+Z:u\u0015\tQ3&\u0001\u0004tKJ4XM\u001d\u0006\u0002Y\u0005)1.\u00194lC\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000e\t\u0003q\u0001i\u0011!K\u0001\u0004Y><W#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014!B:mMRR'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002C{\t1Aj\\4hKJ\fA\u0001\\8hA\u0005!An\\43\u0003\u0015awn\u001a\u001a!\u0003e!Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000ecwn]3\u0015\u0003!\u0003\"\u0001M%\n\u0005)\u000b$\u0001B+oSRD#A\u0002'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016aA1qS*\u0011\u0011KU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019v(A\u0003kk:LG/\u0003\u0002V\u001d\n!A+Z:u\u0003}!Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oIJ+7\u000f^1si:{G-\u001a\u0015\u0003\u000f1\u000bq\u0006^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0003:$w+Y5u\r>\u0014(I]8lKJLeNU;o]&twm\u0015;bi\u0016D#\u0001\u0003'\u0002SQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e\u0007J,\u0017\r^3MSN$H)\u001a7fi\u0016$v\u000e]5dQ\tIA*A\u0014uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000eZ\"sK\u0006$X-\u00118e\u001b\u0006t\u0017\u0010V8qS\u000e\u001c\bF\u0001\u0006M\u0003A!Xm\u001d;DY&,g\u000e^)v_R\f7\u000f\u000b\u0002\f\u0019\u00069C/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:XSRD\u0017\t\u001a<feRL7/\u001a3Q_J$(,\u001a:pQ\taA*A\"uKN$8I]3bi\u0016\u001cE.^:uKJ<\u0016\u000e\u001e5BIZ,'\u000f^5tK\u0012Dun\u001d;B]\u0012\u0004vN\u001d;ES\u001a4WM]3oi\u001a\u0013x.\\*pG.,GoU3sm\u0016\u0014\bFA\u0007M\u0003\u001d\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]%om\u0006d\u0017\u000eZ'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u00059a\u0015a\u00063p\u001f:\u001cF/\u0019:uK\u0012\\\u0015MZ6b\u00072,8\u000f^3s)\u0011AG/_>\u0015\u0005!K\u0007\"\u00026\u0010\u0001\u0004Y\u0017AB1di&|g\u000e\u0005\u00031Y:D\u0015BA72\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002pe6\t\u0001O\u0003\u0002rW\u00059A/Z:uW&$\u0018BA:q\u0005MY\u0015MZ6b\u00072,8\u000f^3s)\u0016\u001cHoS5u\u0011\u001d)x\u0002%AA\u0002Y\f!C\\;n\u0007>tGO]8mY\u0016\u0014hj\u001c3fgB\u0011\u0001g^\u0005\u0003qF\u00121!\u00138u\u0011\u0015Qx\u00021\u0001w\u00039qW/\u001c\"s_.,'OT8eKNDQ\u0001`\bA\u0002u\fqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0011\u0011Ar\u0018\u0011AA\u0004\u0003\u001bI!a`\u0019\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA8\u0002\u0004%\u0019\u0011Q\u00019\u0003\u0019Q+7\u000f^&ji:{G-Z:\u0011\u0007=\fI!C\u0002\u0002\fA\u0014!B\u0011:pW\u0016\u0014hj\u001c3f!!\ty!!\b\u0002$\u0005\rb\u0002BA\t\u00033\u00012!a\u00052\u001b\t\t)BC\u0002\u0002\u00185\na\u0001\u0010:p_Rt\u0014bAA\u000ec\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t\u0019Q*\u00199\u000b\u0007\u0005m\u0011\u0007\u0005\u0003\u0002\u0010\u0005\u0015\u0012\u0002BA\u0014\u0003C\u0011aa\u0015;sS:<\u0017!\t3p\u001f:\u001cF/\u0019:uK\u0012\\\u0015MZ6b\u00072,8\u000f^3sI\u0011,g-Y;mi\u0012\nTCAA\u0017U\r1\u0018qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111H\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q4/\u001a8e\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3tiR{'i\\;oIB{'\u000f^+oi&d\u0017\t\u001c7Ce>\\WM]:Qe>\u0004\u0018mZ1uK\u0012$b!!\u0012\u0002b\u0005ED\u0003BA$\u0003;\u0002B!!\u0013\u0002Z5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\t\t&a\u0015\u0002\r\r|W.\\8o\u0015\ra\u0013Q\u000b\u0006\u0004\u0003/z\u0014AB1qC\u000eDW-\u0003\u0003\u0002\\\u0005-#a\u0006#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKN\u0004xN\\:f\u0011\u0019\ty&\u0005a\u0002]\u000691\r\\;ti\u0016\u0014\bbBA2#\u0001\u0007\u0011QM\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003O\ni'\u0004\u0002\u0002j)!\u00111NA(\u0003\u001dqW\r^<pe.LA!a\u001c\u0002j\taA*[:uK:,'OT1nK\"9\u00111O\tA\u0002\u0005U\u0014\u0001C<bSR$\u0016.\\3\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005AA-\u001e:bi&|gNC\u0002\u0002\u0000E\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019)!\u001f\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006)r/Y5u\r>\u0014(+\u001e8oS:<'I]8lKJ\u001cHCBAE\u0003K\u000bI\u000b\u0006\u0003\u0002\f\u0006\r\u0006CBAG\u0003/\u000biJ\u0004\u0003\u0002\u0010\u0006Me\u0002BA\n\u0003#K\u0011AM\u0005\u0004\u0003+\u000b\u0014a\u00029bG.\fw-Z\u0005\u0005\u00033\u000bYJA\u0002TKFT1!!&2!\rA\u0014qT\u0005\u0004\u0003CK#\u0001\u0004\"s_.,'oU3sm\u0016\u0014\bBBA0%\u0001\u000fa\u000e\u0003\u0004\u0002(J\u0001\rA^\u0001\u0006G>,h\u000e\u001e\u0005\b\u0003g\u0012\u0002\u0019AA;\u0003m\u001aXM\u001c3EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:u)>\u0014u.\u001e8e!>\u0014H/\u00168uS2\u0014%o\\6feN\u0004&o\u001c9bO\u0006$X\r\u001a\u000b\u000b\u0003\u000f\ny+a-\u00026\u0006e\u0006bBAY'\u0001\u0007\u0011QT\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000eC\u0004\u0002dM\u0001\r!!\u001a\t\r\u0005]6\u00031\u0001w\u0003M)\u0007\u0010]3di\u0016$'I]8lKJ\u001cu.\u001e8u\u0011\u001d\t\u0019h\u0005a\u0001\u0003k\nQe]3oI\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$vNQ8v]\u0012\u0004vN\u001d;\u0015\r\u0005\u001d\u0013qXAf\u0011\u001d\t\t\f\u0006a\u0001\u0003\u0003\u0004B!a1\u0002H6\u0011\u0011Q\u0019\u0006\u0004\u0003WZ\u0013\u0002BAe\u0003\u000b\u0014AbU8dW\u0016$8+\u001a:wKJDq!a\u0019\u0015\u0001\u0004\t)'A\u0014uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000e\u001a)fe\u001a|'/\u001c*fCN\u001c\u0018n\u001a8nK:$\bFA\u000bM\u0003M\u0019\u0007.Z2l%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\u0015A\u0015Q[Al\u0011\u0019\tyF\u0006a\u0001]\"9\u0011\u0011\u001c\fA\u0002\u0005m\u0017aD3ya\u0016\u001cG/\u001a3I_N$\u0018N\\4\u0011\r\u00055\u0015Q\\Aq\u0013\u0011\ty.a'\u0003\t1K7\u000f\u001e\t\u0007a\u0005\rh/a:\n\u0007\u0005\u0015\u0018G\u0001\u0004UkBdWM\r\t\u0007\u0003\u001b\u000bi.!;\u0011\u0007A\nY/C\u0002\u0002nF\u0012qAQ8pY\u0016\fg.A\u000eue\u0006t7\u000f\\1uKB\u000b'\u000f^5uS>t\u0017J\u001c4p)>\u001cV-\u001d\u000b\u0005\u0003g\f9\u0010\u0005\u0004\u0002\u000e\u0006]\u0015Q\u001f\t\u0006\u0003\u001b\u000b9J\u001e\u0005\b\u0003s<\u0002\u0019AA~\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0003{\u00149A!\u0003\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0005\u0007\tA!\u001e;jY*\u0011!QA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002`\u0006}\b\u0003\u0002B\u0006\u0005\u001bi!!a\u0014\n\t\t=\u0011q\n\u0002\u0013)>\u0004\u0018n\u0019)beRLG/[8o\u0013:4w.A\nxC&$hi\u001c:U_BL7\rT5ti&tw\rF\u0004I\u0005+\u00119C!\f\t\u000f\t]\u0001\u00041\u0001\u0003\u001a\u0005)\u0011\rZ7j]B!!1\u0004B\u0012\u001b\t\u0011iB\u0003\u0003\u0003\u0018\t}!\u0002\u0002B\u0011\u0003'\nqa\u00197jK:$8/\u0003\u0003\u0003&\tu!!B!e[&t\u0007b\u0002B\u00151\u0001\u0007!1F\u0001\u0010Kb\u0004Xm\u0019;fIB\u0013Xm]3oiB1\u0011QRAL\u0003GAqAa\f\u0019\u0001\u0004\u0011Y#\u0001\bfqB,7\r^3e\u0003\n\u001cXM\u001c;\u0002!%t7M]3nK:$\u0018\r\\!mi\u0016\u0014HC\u0002B\u001b\u0005{\u0011y\u0004\u0005\u0004\u0002\u000e\u0006]%q\u0007\t\u0005\u0003\u0013\u0012I$\u0003\u0003\u0003<\u0005-#\u0001C!qS\u0016\u0013(o\u001c:\t\u000f\t]\u0011\u00041\u0001\u0003\u001a!9!\u0011I\rA\u0002\t\r\u0013aB2iC:<Wm\u001d\t\u0007\u0003\u001b\u000b9J!\u0012\u0011\u000fA\n\u0019Oa\u0012\u0003TA!!\u0011\nB(\u001b\t\u0011YE\u0003\u0003\u0003N\u0005=\u0013AB2p]\u001aLw-\u0003\u0003\u0003R\t-#AD\"p]\u001aLwMU3t_V\u00148-\u001a\t\u0007\u0003\u001b\u000b9J!\u0016\u0011\t\tm!qK\u0005\u0005\u00053\u0012iBA\u0007BYR,'oQ8oM&<w\n]\u0001\u0010m\u0006d\u0017\u000eZ1uK\u000e{gNZ5hgRA!q\fB3\u0005O\u0012\t\b\u0005\u0005\u0002\u0010\u0005u!q\tB1!!\tiPa\u0019\u0002$\u0005\r\u0012\u0002BA\u0010\u0003\u007fDqAa\u0006\u001b\u0001\u0004\u0011I\u0002C\u0004\u0003ji\u0001\rAa\u001b\u0002\u0011\u0015D\b/Z2uK\u0012\u0004\u0002\"a\u0004\u0002\u001e\t\u001d#Q\u000e\t\u0007\u0003\u001b\u000b9Ja\u001c\u0011\u000fA\n\u0019/a\t\u0002$!I!1\u000f\u000e\u0011\u0002\u0003\u0007\u0011\u0011^\u0001\u000bKbD\u0017-^:uSZ,\u0017!\u0007<bY&$\u0017\r^3D_:4\u0017nZ:%I\u00164\u0017-\u001e7uIM*\"A!\u001f+\t\u0005%\u0018qF\u0001\u001ci\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:)\u0005qa\u0015A\u0007;fgR\u001cV\r\u001e'pORR7i\u001c8gS\u001e,(/\u0019;j_:\u001c\bFA\u000fM\u0003-aWmZ1ds\u0006cG/\u001a:\u0015\r\tU\"q\u0011BE\u0011\u001d\u00119B\ba\u0001\u00053AqAa#\u001f\u0001\u0004\u0011i)A\u0005sKN|WO]2fgBA\u0011qBA\u000f\u0005\u000f\u0012y\t\u0005\u0004\u0002\u000e\u0006]%\u0011\u0013\t\u0005\u00057\u0011\u0019*\u0003\u0003\u0003\u0016\nu!aC\"p]\u001aLw-\u00128uef\fa\u0003^3ti2+w-Y2z\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0003?1\u000bAb\u00197vgR,'/S7bO\u0016$bAa(\u0003,\n5\u0006\u0003\u0002BQ\u0005Ok!Aa)\u000b\t\t\u0015\u00161K\u0001\u0006S6\fw-Z\u0005\u0005\u0005S\u0013\u0019K\u0001\u0007DYV\u001cH/\u001a:J[\u0006<W\r\u0003\u0004\u0002`\u0001\u0002\rA\u001c\u0005\u0007\u0005_\u0003\u0003\u0019\u0001<\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0001C\u0019:pW\u0016\u0014\u0018j]+oM\u0016t7-\u001a3\u0015\r\u0005%(Q\u0017B\\\u0011\u001d\u0011)+\ta\u0001\u0005?CaAa,\"\u0001\u00041\u0018A\u00042s_.,'/S:BEN,g\u000e\u001e\u000b\u0007\u0003S\u0014iLa0\t\u000f\t\u0015&\u00051\u0001\u0003 \"1!q\u0016\u0012A\u0002Y\fA\u0003^3tiVs'/Z4jgR,'O\u0011:pW\u0016\u0014\bFA\u0012M\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0005\u00053\u0011I\r\u0003\u0004\u0002`\u0011\u0002\rA\\\u0001#i\u0016\u001cH\u000fR3tGJL'-Z)v_J,XNU3rk\u0016\u001cH\u000fV8Ce>\\WM]:)\u0005\u0015b\u0015!\u0007;fgR,\u0006\u000fZ1uK6+G/\u00193bi\u00064VM]:j_:D#A\n'\u0002#Q,7\u000f^*oCB\u001c\bn\u001c;D_VtG\u000f\u000b\u0002(\u0019\":\u0001A!7\u0003`\n\u0005\bcA'\u0003\\&\u0019!Q\u001c(\u0003\u0007Q\u000bw-A\u0003wC2,X-\t\u0002\u0003d\u0006Y\u0011N\u001c;fOJ\fG/[8oQ\u001d\u0001!q\u001dBp\u0005[\u00042!\u0014Bu\u0013\r\u0011YO\u0014\u0002\b)&lWm\\;u=\u0005A\b")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)new StringBuilder(1).append(KRaftClusterTest.class.getCanonicalName()).append("2").toString());

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testCreateClusterAndRestartNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            broker.shutdown();
            broker.startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$))), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var19_19;
                Tuple2 tuple2;
                ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit")}))).asJava());
                ClientQuotaFilter clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                java.util.Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0)), (List)Nil$.MODULE$))), clientQuotaFilter, 3, admin);
                Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", null), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", null), (List)Nil$.MODULE$))), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", null), (List)Nil$.MODULE$), clientQuotaFilter, 0, admin);
                describeResult = null;
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                ClientQuotaEntity entity2 = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"some-client")}))).asJava());
                clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client"), (List)Nil$.MODULE$))).asJava());
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (scala.collection.immutable.Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                clientQuotaFilter = ClientQuotaFilter.contains((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                long l2 = 100L;
                long tryUntilNoAssertionError_waitTime = 15000L;
                long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void tryUntilNoAssertionError_pause;
                    Right right;
                    try {
                        java.util.Map $anonfun$testClientQuotas$5_results = (java.util.Map)admin.describeClientQuotas(clientQuotaFilter).entities().get();
                        Assertions.assertEquals((int)2, (int)$anonfun$testClientQuotas$5_results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)$anonfun$testClientQuotas$5_results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                        Object var25_17 = null;
                        BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                        right = scala.package$.MODULE$.Left().apply((Object)$anonfun$tryUntilNoAssertionError$1_res);
                    }
                    catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                        right = scala.package$.MODULE$.Right().apply((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                    }
                    Object var23_14 = null;
                    Object var24_15 = null;
                    Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                    if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
                }
                Object var22_13 = null;
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Either tryUntilNoAssertionError_either = (Either)tuple22._1();
                tuple22._2$mcZ$sp();
                if (!(var19_19 instanceof Left)) {
                    if (var19_19 instanceof Right) {
                        throw (AssertionError)((Right)var19_19).value();
                    }
                    throw new MatchError((Object)var19_19);
                }
                ((Left)var19_19).value();
                tuple22 = null;
                var19_19 = null;
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, x$2) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString())}));
        int x$3 = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        Function2 & Serializable brokerPropertyOverrides = (Function2 & Serializable)(nodes, broker) -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.ListenersProp(), (Object)new StringBuilder(14).append(nodes.externalListenerName().value()).append("://localhost:0").toString()), new Tuple2((Object)KafkaConfig$.MODULE$.AdvertisedListenersProp(), (Object)new StringBuilder(20).append(nodes.externalListenerName().value()).append("://advertised-host-").append(broker.id()).append(":").append(broker.id() + 100).toString())}));
        int x$3 = 1;
        Function1 & Serializable x$4 = (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, cluster);
            return BoxedUnit.UNIT;
        };
        this.doOnStartedKafkaCluster(x$3, 3, (Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>>)brokerPropertyOverrides, (Function1<KafkaClusterTestKit, BoxedUnit>)x$4);
    }

    @Test
    public void testCreateClusterInvalidMetadataVersion() {
        Assertions.assertEquals((Object)"Bootstrap metadata versions before 3.3-IV0 are not supported. Can't load metadata from testkit", (Object)Assertions.assertThrows(RuntimeException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_2_7_IV0).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build()).getMessage());
    }

    private void doOnStartedKafkaCluster(int numControllerNodes, int numBrokerNodes, Function2<TestKitNodes, BrokerNode, scala.collection.immutable.Map<String, String>> brokerPropertyOverrides, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(numControllerNodes).setNumBrokerNodes(numBrokerNodes).build();
        nodes.brokerNodes().values().forEach(broker -> broker.propertyOverrides().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)brokerPropertyOverrides.apply((Object)nodes, broker)).asJava()));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private int doOnStartedKafkaCluster$default$1() {
        return 1;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        scala.collection.immutable.Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            scala.collection.immutable.Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Seq runningBrokerServers = (scala.collection.immutable.Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(82).append("After ").append(waitTime.toMillis()).append(" ms at least ").append(count).append(" broker(s) should be in RUNNING state, ").append("but only ").append(var5_9.size()).append(" broker(s) are.").toString());
        return var5_9;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_10;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(62).append("After ").append(waitTime.toMillis()).append(" ms Broker is only aware of ").append(var6_10.nodes().size()).append(" brokers, ").append("but ").append(expectedBrokerCount).append(" are expected.").toString());
        return var6_10;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Integer>> assignments = new HashMap<Integer, java.util.List<Integer>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
                assignments.put(Predef$.MODULE$.int2Integer(1), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)));
                assignments.put(Predef$.MODULE$.int2Integer(2), Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)));
                assignments.put(Predef$.MODULE$.int2Integer(3), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)));
                admin.createTopics(Collections.singletonList(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (scala.collection.immutable.Seq<String>)Nil$.MODULE$);
                Assertions.assertEquals(Collections.emptyMap(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"The reassignment never completed.");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> seq = Nil$.MODULE$;
                .colon.colon expectedMapping = new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 0}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), (List)new .colon.colon((Object)((scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))), (List)Nil$.MODULE$))));
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void waitUntilTrue_pause;
                    boolean bl;
                    java.util.Map $anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap;
                    if (($anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap = (java.util.Map)admin.describeTopics(Collections.singleton("foo")).allTopicNames().get()).containsKey("foo")) {
                        seq = this.translatePartitionInfoToSeq(((TopicDescription)$anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap.get("foo")).partitions());
                        bl = expectedMapping.equals(seq);
                    } else {
                        bl = false;
                    }
                    Object var27_13 = null;
                    if (bl) break;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping).append(". Got: ").append(seq).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
                long l3 = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                long l4 = 1L;
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true}))), (List)Nil$.MODULE$)))));
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l4).append(", and then retrying.").toString();
                            Object var26_20 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(l4);
                        l4 += package$.MODULE$.min(l4, 1000L);
                        continue;
                    }
                    break;
                }
                Object var20_15 = null;
                Object var25_19 = null;
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$7 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Seq<scala.collection.immutable.Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().map((Function1 & Serializable)partition -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()))).toSeq())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTopicListing(Admin admin, scala.collection.immutable.Seq<String> expectedPresent, scala.collection.immutable.Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        expectedPresent.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$1)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ((Iterable)admin.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$9)));
            if (topicsNotFound.isEmpty() && set.isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala(topicsNotFound).asScala()).append(" and NOT find topic(s): ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Seq<ApiError> incrementalAlter(Admin admin, scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq ops = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ops).asJava());
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.incrementalAlterConfigs(configs).values();
        return (scala.collection.immutable.Seq)changes.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var11_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var10_10 = null;
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "6"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"6"), (List)Nil$.MODULE$)))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "7"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"7"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                new .colon.colon((Object)this.log(), (List)new .colon.colon((Object)this.log2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x$10 -> {
                    x$10.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), (Object)"TRACE"), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), (Object)"TRACE"), (List)Nil$.MODULE$)))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (scala.collection.immutable.Seq<Tuple2<ConfigResource, scala.collection.immutable.Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log().getName())), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log2().getName())), (List)Nil$.MODULE$)))}))), false);
            }
        }
    }

    public scala.collection.immutable.Seq<ApiError> legacyAlter(Admin admin, scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>> resources) {
        HashMap configs = new HashMap();
        resources.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                scala.collection.immutable.Seq entries = (scala.collection.immutable.Seq)x0$1._2();
                return configs.put(resource, new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries).asJava()));
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.alterConfigs(configs).values();
        return ((IterableOnceOps)resources.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        })).toSeq();
    }

    @Test
    public void testLegacyAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ConfigResource defaultBroker = new ConfigResource(ConfigResource.Type.BROKER, "");
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)new .colon.colon((Object)new ConfigEntry("max.connections.per.ip", "6"), (List)Nil$.MODULE$)))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"6"), (List)Nil$.MODULE$)))}))), true);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)Nil$.MODULE$))}))), true);
                admin.createTopics(Arrays.asList(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "345"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)new .colon.colon((Object)new ConfigEntry("not.a.real.topic.config", "789"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "678"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, scala.collection.immutable.Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    private ClusterImage clusterImage(KafkaClusterTestKit cluster, int brokerId) {
        return cluster.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)).metadataCache().currentImage().cluster();
    }

    private boolean brokerIsUnfenced(ClusterImage image, int brokerId) {
        Option option = Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return !((BrokerRegistration)((Some)option).value()).fenced();
        }
        throw new MatchError((Object)option);
    }

    private boolean brokerIsAbsent(ClusterImage image, int brokerId) {
        return Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnregisterBroker() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.brokerIsUnfenced(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be unfenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            cluster.brokers().get(BoxesRunTime.boxToInteger((int)0)).shutdown();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUnregisterBroker$3(this, cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.unregisterBroker(0);
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!this.brokerIsAbsent(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
    }

    public Admin createAdminClient(KafkaClusterTestKit cluster) {
        Properties props = cluster.clientProperties();
        props.put("client.id", this.getClass().getName());
        return Admin.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuorumRequestToBrokers() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$2(cluster, i)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Broker Never started up");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            });
            try (Admin admin = this.createAdminClient(cluster);){
                void var7_15;
                Tuple2 tuple2;
                void var5_9;
                Tuple2 tuple22;
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)new StringBuilder(35).append("Leader ID ").append(quorumInfo.leaderId()).append(" was not a controller ID.").toString());
                long l = 100L;
                long computeUntilTrue_waitTime = 15000L;
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$5(admin))) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Object var16_7 = null;
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                java.util.List voters = (java.util.List)tuple23._1();
                Assertions.assertTrue((boolean)tuple23._2$mcZ$sp(), (String)new StringBuilder(111).append("At least one voter did not return the expected state within timeout.").append("The responses gathered for all the voters: ").append(var5_9.toString()).toString());
                long l2 = 100L;
                long computeUntilTrue_waitTime2 = 15000L;
                long computeUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster, computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$8(admin))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
                }
                Object var23_13 = null;
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError(null);
                }
                java.util.List observers = (java.util.List)tuple24._1();
                Assertions.assertTrue((boolean)tuple24._2$mcZ$sp(), (String)new StringBuilder(117).append("At least one observer did not return the expected state within timeout.").append("The responses gathered for all the observers: ").append(var7_15.toString()).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.updateFeatures(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(MetadataVersion.latest().featureLevel(), FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions());
            }
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUpdateMetadataVersion$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for metadata version update.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotCount() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", "500").setConfigProp("metadata.max.idle.interval.ms", "50").build();){
            cluster.format();
            cluster.startup();
            Path metaLog = FileSystems.getDefault().getPath(cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000)).config().metadataLogDir(), "__cluster_metadata-0");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$2(metaLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to see at least one snapshot");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Thread.sleep(5000L);
            long countAfterTenIntervals = KRaftClusterTest.snapshotCounter$1(metaLog);
            Assertions.assertTrue((countAfterTenIntervals > 1L ? 1 : 0) != 0, (String)new StringBuilder(48).append("Expected to see at least one more snapshot, saw ").append(countAfterTenIntervals).toString());
            Assertions.assertTrue((countAfterTenIntervals < 20L ? 1 : 0) != 0, (String)new StringBuilder(83).append("Did not expect to see more than twice as many snapshots as snapshot intervals, saw ").append(countAfterTenIntervals).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$1) {
        BrokerState brokerState = cluster$1.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$1) {
        return cluster$1.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$2) {
        return cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$3) {
        return cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final java.util.Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (java.util.Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (java.util.Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$testClientQuotas$3(ClientQuotaFilter filter$1, Admin admin$1) {
        return KRaftClusterTest.describeOrFail$1(filter$1, admin$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return results.getOrDefault(entity$1, Collections.emptyMap()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final java.util.Map alterThenDescribe$1(ClientQuotaEntity entity, scala.collection.immutable.Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_11;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)quotas).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            java.util.Map computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result = KRaftClusterTest.describeOrFail$1(filter, admin$1))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        java.util.Map describeResult = (java.util.Map)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Broker never saw new client quotas");
        return var7_11;
    }

    public static final /* synthetic */ void $anonfun$testClientQuotas$5(Admin admin$1, ObjectRef filter$2, ClientQuotaEntity entity$2, ClientQuotaEntity entity2$1) {
        java.util.Map results = (java.util.Map)admin$1.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity$2)).get("producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity2$1)).get("producer_byte_rate")), (double)1.0E-6);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id())).socketServer().boundPort(cluster.nodes().externalListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)new StringBuilder(16).append("advertised-host-").append(broker.id()).toString(), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final scala.collection.immutable.Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$6) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$6.brokers().values()).asScala().toSeq().filter((Function1 & Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$waitForRunningBrokers$2(KafkaClusterTestKit cluster$6) {
        return KRaftClusterTest.getRunningBrokerServers$1(cluster$6);
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$2) {
        return ((java.util.Map)admin$2.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$2, ObjectRef currentMapping$1, scala.collection.immutable.Seq expectedMapping$1) {
        java.util.Map topicInfoMap = (java.util.Map)admin$2.describeTopics(Collections.singleton("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((scala.collection.immutable.Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(scala.collection.immutable.Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping$1).append(". Got: ").append((scala.collection.immutable.Seq)currentMapping$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$6) {
        if (x$6 != null) {
            boolean isHosted = x$6._1$mcZ$sp();
            int partitionId = x$6._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$8, Tuple2 x$7) {
        if (x$7 != null) {
            int brokerId = x$7._1$mcI$sp();
            List partitionsIsHosted = (List)x$7._2();
            BrokerServer broker = cluster$8.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((IterableOps)partitionsIsHosted.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$6);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$3, HashSet topicsNotFound$1, ObjectRef extraTopics$1, scala.collection.immutable.Seq expectedAbsent$1) {
        ((Iterable)admin$3.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin$3.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$9)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)topicsNotFound$1).asScala()).append(" and NOT find topic(s): ").append((scala.collection.mutable.Set)extraTopics$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$4, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$1, boolean exhaustive$1) {
        try {
            java.util.Map values = admin$4.describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).values();
            results$1.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ConfigResource resource = (ConfigResource)x0$1._1();
                    scala.collection.immutable.Seq pairs = (scala.collection.immutable.Seq)x0$1._2();
                    Config config = (Config)((KafkaFuture)values.get(resource)).get();
                    TreeMap actual = new TreeMap();
                    TreeMap expected = new TreeMap();
                    config.entries().forEach(x0$2 -> {
                        actual.put(x0$2.name(), x0$2.value());
                        if (!exhaustive$1) {
                            expected.put(x0$2.name(), x0$2.value());
                            return;
                        }
                    });
                    pairs.foreach((Function1 & Serializable)x0$3 -> {
                        if (x0$3 != null) {
                            String k = (String)x0$3._1();
                            String v = (String)x0$3._2();
                            return expected.put(k, v);
                        }
                        throw new MatchError(null);
                    });
                    Assertions.assertEquals(expected, actual);
                    return results$1.put((Object)resource, actual);
                }
                throw new MatchError(null);
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn(new StringBuilder(27).append("Unable to describeConfigs(").append(CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).append(")").toString(), t);
            throw t;
        }
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$2() {
        return "Timed out waiting for broker 0 to be unfenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testUnregisterBroker$3(KRaftClusterTest $this, KafkaClusterTestKit cluster$9) {
        return !$this.brokerIsUnfenced($this.clusterImage(cluster$9, 1), 0);
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$4() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$6() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$2(KafkaClusterTestKit cluster$10, int i$1) {
        BrokerState brokerState = cluster$10.brokers().get(BoxesRunTime.boxToInteger((int)i$1)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$5(Admin admin$5) {
        return ((QuorumInfo)admin$5.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).voters();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$6(java.util.List voters) {
        return voters.stream().allMatch(voter -> {
            if (voter.logEndOffset() > 0L) {
                OptionalLong optionalLong = voter.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = voter.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$8(Admin admin$5) {
        return ((QuorumInfo)admin$5.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).observers();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$9(KafkaClusterTestKit cluster$10, java.util.List observers) {
        Set set = CollectionConverters$.MODULE$.MapHasAsScala(cluster$10.brokers()).asScala().keySet();
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(observers).asScala().map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.replicaId()))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null) && observers.stream().allMatch(observer -> {
            if (observer.logEndOffset() > 0L) {
                OptionalLong optionalLong = observer.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = observer.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataVersion$1(KafkaClusterTestKit cluster$11) {
        return cluster$11.brokers().get(BoxesRunTime.boxToInteger((int)1)).metadataCache().currentImage().features().metadataVersion().equals((Object)MetadataVersion.latest());
    }

    public static final /* synthetic */ String $anonfun$testUpdateMetadataVersion$2() {
        return "Timed out waiting for metadata version update.";
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$15, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$2(Path metaLog$1) {
        return KRaftClusterTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(scala.collection.immutable.Seq x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$6$adapted(java.util.List voters) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(voters));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$9$adapted(KafkaClusterTestKit cluster$10, java.util.List observers) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster$10, observers));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

