/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.BrokerToControllerChannelManagerImpl;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.KafkaConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@Tag(value="integration")
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\u0005\n\u0001AAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0005\u0002qAQa\u000b\u0001\u0005\u00021BQ!\u0011\u0001\u0005\u0002\tCQ\u0001\u001d\u0001\u0005\u0002EDq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002J\u0001!\t!a\u0013\u0003;\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\u001c*fcV,7\u000f\u001e+fgRT!AC\u0006\u0002\rM,'O^3s\u0015\taQ\"A\u0003lC\u001a\\\u0017MC\u0001\u000f\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005I\u0011\u0001\t2s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ$\"!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0005)\u0001#\"\u0001\u0007\n\u0005\tz\"\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJDQ\u0001\n\u0002A\u0002\u0015\nqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003M%j\u0011a\n\u0006\u0003Q\u0001\nA\u0001^3ti&\u0011!f\n\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u0006q1/\u001a8e\u0003:$'+Z2jKZ,GcA\u0017;yA\u0011a\u0006O\u0007\u0002_)\u0011\u0001'M\u0001\b[\u0016\u001c8/Y4f\u0015\t\u00114'\u0001\u0004d_6lwN\u001c\u0006\u0003\u0019QR!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO&\u0011\u0011h\f\u0002\u001f\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|gNU3ta>t7/\u001a#bi\u0006DQaO\u0002A\u0002u\tab\u00195b]:,G.T1oC\u001e,'\u000fC\u0003>\u0007\u0001\u0007a(A\u0002sKF\u0004\"AL \n\u0005\u0001{#!\b\"s_.,'OU3hSN$(/\u0019;j_:\u0014V-];fgR$\u0015\r^1\u0002\u001dI,w-[:uKJ\u0014%o\\6feR11)\u0013&X9\u0012\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u0019\u0002\u0011A\u0014x\u000e^8d_2L!\u0001S#\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015YD\u00011\u0001\u001e\u0011\u0015YE\u00011\u0001M\u0003%\u0019G.^:uKJLE\r\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fNi\u0011\u0001\u0015\u0006\u0003#>\ta\u0001\u0010:p_Rt\u0014BA*\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u001b\u0002\"\u0002-\u0005\u0001\u0004I\u0016\u0001\u00032s_.,'/\u00133\u0011\u0005IQ\u0016BA.\u0014\u0005\rIe\u000e\u001e\u0005\u0006;\u0012\u0001\rAX\u0001\bu.,\u0005o\\2i!\r\u0011r,Y\u0005\u0003AN\u0011aa\u00149uS>t\u0007C\u0001\nc\u0013\t\u00197C\u0001\u0003M_:<\u0007\"B3\u0005\u0001\u00041\u0017!C5caR{7+\u001a8e!\r\u0011rl\u001a\t\u0005%!T'.\u0003\u0002j'\t1A+\u001e9mKJ\u0002\"a\u001b8\u000e\u00031T!AM7\u000b\u0005)\u0019\u0014BA8m\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001\u000b;fgR\u0014VmZ5ti\u0016\u0014(l[,ji\"\\%+\u00194u\u001b&<'/\u0019;j_:$\u0015n]1cY\u0016$GC\u0001:v!\t\u00112/\u0003\u0002u'\t!QK\\5u\u0011\u0015!S\u00011\u0001&QQ)q/ @\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0007\u0002\u001eA\u0011\u0001p_\u0007\u0002s*\u0011!pJ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001?z\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002\u007f&!\u0011\u0011AA\u0002\u0003\u0015Y%+\u0011$U\u0015\r\t)!_\u0001\u0005)f\u0004X-A\u0004ce>\\WM]:\u001e\u0003\u0001\t1bY8oiJ|G\u000e\\3sgv\t\u0011!A\bnKR\fG-\u0019;b-\u0016\u00148/[8oI\t\t\u0019\"\u0003\u0003\u0002\u0016\u0005]\u0011aC%C!~\u001bt\fN0J-BR1!!\u0007m\u0003=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001E:feZ,'\u000f\u0015:pa\u0016\u0014H/[3tY\t\tyb\u000b\u0006\u0002\"\u0005\u001d\u0012\u0011FA\u0017\u0003_\u00012\u0001_A\u0012\u0013\r\t)#\u001f\u0002\u0016\u00072,8\u000f^3s\u0007>tg-[4Qe>\u0004XM\u001d;z\u0003\rYW-_\u0011\u0003\u0003W\t1E_8pW\u0016,\u0007/\u001a:/[\u0016$\u0018\rZ1uC:j\u0017n\u001a:bi&|gNL3oC\ndW-A\u0003wC2,X-\t\u0002\u00022\u0005)a-\u00197tK\u0006IC/Z:u%\u0016<\u0017n\u001d;fej[w+\u001b;i\u0017J\u000bg\r^(mI6+G/\u00193bi\u00064VM]:j_:$2A]A\u001c\u0011\u0015!c\u00011\u0001&QQ1q/ @\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\tY$a\u0007\u0002B\u0011\u0012\u0011QH\u0005\u0005\u0003\u007f\t9\"A\u0006J\u0005B{6gX\u001a`\u0013Z\u001bDFAA\"W)\t\t#a\n\u0002*\u00055\u0012QI\u0011\u0003\u0003\u000f\nA\u0001\u001e:vK\u00069C/Z:u%\u0016<\u0017n\u001d;fej[w+\u001b;i\u0017J\u000bg\r^'jOJ\fG/[8o\u000b:\f'\r\\3e)\r\u0011\u0018Q\n\u0005\u0006I\u001d\u0001\r!\n\u0015\u0015\u000f]lh0a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\tY\"!\u0015-\u0005\u0005\r\u0003f\u0002\u0001\u0002V\u00055\u0012Q\u000e\t\u0005\u0003/\nI'\u0004\u0002\u0002Z)!\u00111LA/\u0003%)\u0007\u0010^3og&|gN\u0003\u0003\u0002`\u0005\u0005\u0014aA1qS*!\u00111MA3\u0003\u001dQW\u000f]5uKJT1!a\u001a7\u0003\u0015QWO\\5u\u0013\u0011\tY'!\u0017\u0003\u0015\u0015CH/\u001a8e/&$\b\u000e\f\u0002\u0002p\r\u0012\u0011\u0011\u000f\t\u0005\u0003g\n9(\u0004\u0002\u0002v)\u0019\u0011qM\u0014\n\t\u0005e\u0014Q\u000f\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8tQ\u001d\u0001\u0011QPA\u0017\u0003\u000b\u0003B!a \u0002\u00026\u0011\u0011QL\u0005\u0005\u0003\u0007\u000biFA\u0002UC\u001e\f#!a\"\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\b\u0001\u0005-\u0015QFAI!\u0011\ty(!$\n\t\u0005=\u0015Q\f\u0002\b)&lWm\\;u=\u0005A\b")
public class BrokerRegistrationRequestTest {
    /*
     * WARNING - void declaration
     */
    public BrokerToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        void apply_retryTimeoutMs;
        void apply_threadNamePrefix;
        void apply_channelName;
        void apply_config;
        void apply_metrics;
        long l = 10000L;
        Some some = new Some((Object)"heartbeat");
        String string = "heartbeat";
        KafkaConfig kafkaConfig = clusterInstance.anyControllerSocketServer().config();
        Metrics metrics = new Metrics();
        Time apply_time = Time.SYSTEM;
        ControllerNodeProvider apply_controllerNodeProvider = new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort(this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            private boolean isZkController() {
                return !this.clusterInstance$1.isKRaftTest();
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism(), this.isZkController());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        };
        return new BrokerToControllerChannelManagerImpl(apply_controllerNodeProvider, apply_time, (Metrics)apply_metrics, (KafkaConfig)apply_config, (String)apply_channelName, (Option)apply_threadNamePrefix, (long)apply_retryTimeoutMs);
    }

    public BrokerRegistrationResponseData sendAndRecieve(BrokerToControllerChannelManager channelManager, BrokerRegistrationRequestData req) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest((AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(((BrokerRegistrationResponse)response.responseBody()).data());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (BrokerRegistrationResponseData)responseFuture.get(30L, TimeUnit.SECONDS);
    }

    public Errors registerBroker(BrokerToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<MetadataVersion, MetadataVersion>> ibpToSend) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ibpToSend.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(features, x0$1)));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features);
        return Errors.forCode((short)this.sendAndRecieve(channelManager, req).errorCode());
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWithKRaftMigrationDisabled(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftOldMetadataVersion(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabled(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        BrokerToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataVersion min = (MetadataVersion)x0$1._1();
            MetadataVersion max = (MetadataVersion)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min.featureLevel()).setMaxSupportedVersion(max.featureLevel()));
        }
        throw new MatchError(null);
    }
}

