/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\u0002!BQ!\u000f\u0001\u0005\u0002!BQa\u000f\u0001\u0005\u0002!BQ!\u0010\u0001\u0005\u0002!BQa\u0010\u0001\u0005\u0002!BQ!\u0011\u0001\u0005\u0002!BQa\u0011\u0001\u0005\u0002!BQ!\u0012\u0001\u0005\u0002!BQa\u0012\u0001\u0005\u0002!BQ!\u0013\u0001\u0005\n)CQ!\u001b\u0001\u0005\n)DQa \u0001\u0005\u0002!Ba!a\u0001\u0001\t\u0003A\u0003BBA\u0004\u0001\u0011\u0005\u0001\u0006\u0003\u0004\u0002\f\u0001!\t\u0001\u000b\u0005\u0007\u0003\u001f\u0001A\u0011\u0001\u0015\t\r\u0005M\u0001\u0001\"\u0001)\u0011\u0019\t9\u0002\u0001C\u0001Q!1\u00111\u0004\u0001\u0005\u0002!Ba!a\b\u0001\t\u0003A#a\u0006#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<G+Z:u\u0015\tA\u0012$\u0001\u0004tKJ4XM\u001d\u0006\u00025\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011aF\u0001\u0011i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016$\u0012!\u000b\t\u0003=)J!aK\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00055\u0002\"AL\u001c\u000e\u0003=R!\u0001M\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u00023g\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001b6\u0003\u0015QWO\\5u\u0015\u00051\u0014aA8sO&\u0011\u0001h\f\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$XI\\1cY\u0016$UMZ1vYR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:D#aA\u0017\u00027Q,7\u000f^+qI\u0006$X\rR=oC6L7\r\u00165sK\u0006$\u0007k\\8mQ\t!Q&\u0001\u0014uKN$8i\u001c8gS\u001e,\u0006\u000fZ1uK^KG\u000f[*p[\u0016LeN^1mS\u0012\u001cuN\u001c4jOND#!B\u0017\u0002gQ,7\u000f^\"p]\u001aLw-\u00169eCR,w+\u001b;i%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f-\u0006d\u0017\u000eZ1uS>tg)Y5mkJ,\u0007F\u0001\u0004.\u0003q!Xm\u001d;SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:D#aB\u0017\u0002'Q,7\u000f^*fGV\u0014\u0018\u000e^=D_:4\u0017nZ:)\u0005!i\u0013a\u0005;fgR\u001cuN\u001c8fGRLwN\\)v_R\f\u0007FA\u0005.\u0003]!Xm\u001d;D_:tWm\u0019;j_:\u0014\u0016\r^3Rk>$\u0018\r\u000b\u0002\u000b[\u0005\u0011b/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f)\u0015I3\n\u00172h\u0011\u0015a5\u00021\u0001N\u0003\u0011q\u0017-\\3\u0011\u00059+fBA(T!\t\u0001v$D\u0001R\u0015\t\u00116$\u0001\u0004=e>|GOP\u0005\u0003)~\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011Ak\b\u0005\u00063.\u0001\rAW\u0001\u0006m\u0006dW/\u001a\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bA\u0001\\1oO*\tq,\u0001\u0003kCZ\f\u0017BA1]\u0005\u0019y%M[3di\")1m\u0003a\u0001I\u0006y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\r\u0005\u0002\u001fK&\u0011am\b\u0002\b\u0005>|G.Z1o\u0011\u0015A7\u00021\u0001e\u00035)\u0007\u0010]3di\u001a\u000b\u0017\u000e\\;sK\u0006\u0019c/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\b.\u00138wC2LGmQ8oM&<G#B\u0015labl\b\"\u00027\r\u0001\u0004i\u0017AB2p]\u001aLw\r\u0005\u0002']&\u0011qn\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003r\u0019\u0001\u0007!/A\u0005pe&<\u0007K]8qgB\u00111O^\u0007\u0002i*\u0011QOX\u0001\u0005kRLG.\u0003\u0002xi\nQ\u0001K]8qKJ$\u0018.Z:\t\u000bed\u0001\u0019\u0001>\u0002\u0015Y\fG.\u001b3Qe>\u00048\u000f\u0005\u0003Ow6k\u0015B\u0001?X\u0005\ri\u0015\r\u001d\u0005\u0006}2\u0001\rA_\u0001\rS:4\u0018\r\\5e!J|\u0007o]\u0001\u001di\u0016\u001cH\u000fU1tg^|'\u000fZ\"p]\u001aLw-\u00128def\u0004H/[8oQ\tiQ&A\u0013uKN$\b+Y:to>\u0014HmQ8oM&<WI\\2pI\u0016\u00148+Z2sKR\u001c\u0005.\u00198hK\"\u0012a\"L\u0001\u001ai\u0016\u001cH\u000fR=oC6L7\rT5ti\u0016tWM]\"p]\u001aLw\r\u000b\u0002\u0010[\u0005!B/Z:u\u0003V$\bn\u001c:ju\u0016\u00148i\u001c8gS\u001eD#\u0001E\u0017\u0002\u0019Q,7\u000f^*z]>t\u00170\\:)\u0005Ei\u0013!\r;fgR$\u0015P\\1nS\u000e\u001cuN\u001c4jO&s\u0017\u000e^5bY&T\u0018\r^5p]^KG\u000f[8vi\u000e{gNZ5hg&s'l\u0013\u0015\u0003%5\nQ\u0004^3ti&k\u0007O]8qKJ\u001cuN\u001c4jON\f%/\u001a*f[>4X\r\u001a\u0015\u0003'5\n\u0011\u0004^3tiV\u0003H-\u0019;f\u001b\u0016$(/[2SKB|'\u000f^3sg\"\u0012A#L\u0001'i\u0016\u001cH/\u00169eCR,W*\u001a;sS\u000e\u0014V\r]8si\u0016\u00148OT8K[b\u0014V\r]8si\u0016\u0014\bFA\u000b.\u0001")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn(package$.MODULE$.Iterable().empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(LogConfig$.MODULE$.apply());
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var32_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var33_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var34_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("ssl.keystore.type", "JKS");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        scala.collection.immutable.Map excludedTopicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var27_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var28_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var29_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(new Reconfigurable(null, invalidReconfigurableProps){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        }));
        config.dynamicConfig().addReconfigurable(new /* invalid duplicate definition of identical inner class */);
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(new BrokerReconfigurable(null, invalidReconfigurableProps){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        }));
        config.dynamicConfig().addBrokerReconfigurable(new /* invalid duplicate definition of identical inner class */);
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var31_19 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)configProps, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig configWithoutSecret = new KafkaConfig((java.util.Map)props, apply_doLog);
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean apply_doLog2 = true;
        KafkaConfig configWithSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var31_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var32_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var33_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        boolean apply_doLog2 = true;
        KafkaConfig newConfigWithSameSecret = new KafkaConfig((java.util.Map)props, apply_doLog2);
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        boolean apply_doLog3 = true;
        KafkaConfig newConfigWithNewAndOldSecret = new KafkaConfig((java.util.Map)props, apply_doLog3);
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        boolean apply_doLog4 = true;
        KafkaConfig newConfigWithNewSecret = new KafkaConfig((java.util.Map)props, apply_doLog4);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var25_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var26_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var27_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        boolean apply_doLog = true;
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean apply_doLog = true;
            dynamicListenerConfig.validateReconfiguration(new KafkaConfig((java.util.Map)props, apply_doLog));
        });
    }

    @Test
    public void testAuthorizerConfig() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_9 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_12 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_15 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;

            public int aclCount() {
                return super.aclCount();
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
                return super.authorizeByResourceType(x$1, x$2, x$3);
            }

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
            }

            public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return CollectionConverters$.MODULE$.SetHasAsJava((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(null);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        Assertions.assertThrows(Throwable.class, () -> kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer));
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var24_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var25_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var26_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, 9092, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient));
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)props, apply_doLog);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)Defaults$.MODULE$.MessageMaxBytes(), (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var28_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var29_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var30_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, x$4, x$5, 8181, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(KafkaConfig$.MODULE$.AutoIncludeJmxReporterProp(), "false");
        boolean apply_doLog = true;
        KafkaConfig config = new KafkaConfig((java.util.Map)origProps, apply_doLog);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove(KafkaConfig$.MODULE$.MetricReporterClassesProp());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString()));
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1), config$3.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1, config$3.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }
}

