/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMf\u0001B\u001d;\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004P\u0001\u0001\u0006I\u0001\u0014\u0005\n!\u0002\u0001\r\u00111A\u0005\nEC\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0002,\t\u0013q\u0003\u0001\u0019!A!B\u0013\u0011\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B0\t\u000f\r\u0004!\u0019!C\u0005I\"1\u0001\u000e\u0001Q\u0001\n\u0015Dq!\u001b\u0001C\u0002\u0013%!\u000e\u0003\u0004o\u0001\u0001\u0006Ia\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u00191\b\u0001)A\u0005c\"9q\u000f\u0001b\u0001\n\u0013A\bbBA\u0002\u0001\u0001\u0006I!\u001f\u0005\n\u0003\u000b\u0001!\u0019!C\u0005\u0003\u000fA\u0001\"!\u0006\u0001A\u0003%\u0011\u0011\u0002\u0005\f\u0003/\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0002C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0002bCA\u0014\u0001\u0001\u0007\t\u0011)Q\u0005\u00037A\u0001\"!\u000b\u0001\u0005\u0004%Ia\u0013\u0005\b\u0003W\u0001\u0001\u0015!\u0003M\u0011%\ti\u0003\u0001b\u0001\n\u0013\ty\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0019\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0016\u0001\t\u0003\tY\u0004C\u0004\u0002b\u0001!\t!a\u000f\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002<!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004\"CAM\u0001E\u0005I\u0011BAN\u0011%\t\t\fAI\u0001\n\u0013\t\u0019\fC\u0004\u00028\u0002!\t!a\u000f\t\u000f\u0005m\u0006\u0001\"\u0001\u0002<!9\u0011q\u0018\u0001\u0005\u0002\u0005m\u0002bBAb\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000f\u0004A\u0011AA\u001e\u0011\u001d\tY\r\u0001C\u0001\u0003wAq!a4\u0001\t\u0003\tY\u0004C\u0004\u0002T\u0002!\t!a\u000f\t\u000f\u0005]\u0007\u0001\"\u0001\u0002<!9\u00111\u001c\u0001\u0005\u0002\u0005m\u0002bBAp\u0001\u0011\u0005\u00111\b\u0005\b\u0003G\u0004A\u0011AA\u001e\u0011\u001d\t9\u000f\u0001C\u0001\u0003wAq!a;\u0001\t\u0003\tY\u0004C\u0004\u0002p\u0002!\t!a\u000f\t\u000f\u0005M\b\u0001\"\u0001\u0002<!9\u0011q\u001f\u0001\u0005\n\u0005e\bb\u0002B!\u0001\u0011%!1\t\u0005\n\u0005G\u0002\u0011\u0013!C\u0005\u0005KBqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0005\u0003z\u0001\t\n\u0011\"\u0003\u0003|!9!q\u0010\u0001\u0005\n\t\u0005\u0005\"\u0003BX\u0001E\u0005I\u0011BAN\u0011%\u0011\t\fAI\u0001\n\u0013\t\u0019L\u0001\u000fBkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005mb\u0014AB:feZ,'OC\u0001>\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\t!(\u0001\bsKF,Xm\u001d;US6,w.\u001e;\u0016\u00031\u0003\"!Q'\n\u00059\u0013%aA%oi\u0006y!/Z9vKN$H+[7f_V$\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002%B\u0011\u0011jU\u0005\u0003)j\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005]S\u0006CA!Y\u0013\tI&I\u0001\u0003V]&$\bbB.\u0006\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003}\u0003\"!\u00131\n\u0005\u0005T$!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002%\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM]\u000b\u0002KB\u0011\u0011JZ\u0005\u0003Oj\u0012\u0001E\u0011:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006\u0019\"M]8lKJ$vnQ8oiJ|G\u000e\\3sA\u0005a\u0011\rZ7j]6\u000bg.Y4feV\t1\u000e\u0005\u0002JY&\u0011QN\u000f\u0002\u000f5.\fE-\\5o\u001b\u0006t\u0017mZ3s\u00035\tG-\\5o\u001b\u0006t\u0017mZ3sA\u0005Q1m\u001c8ue>dG.\u001a:\u0016\u0003E\u0004\"A\u001d;\u000e\u0003MT!a\u001c\u001f\n\u0005U\u001c(aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J,\u0012!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fQa\u001a:pkBT!A \u001f\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0004\u0003\u0003Y(\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u0003E9'o\\;q\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u0017iJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;peV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB?\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003'\tiA\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0003]!(/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\b%\u0001\rbkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ,\"!a\u0007\u0011\u0007%\u000bi\"C\u0002\u0002 i\u0012\u0001$Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s\u0003q\tW\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM]0%KF$2aVA\u0013\u0011!YF#!AA\u0002\u0005m\u0011!G1vi>$v\u000e]5d\u0007J,\u0017\r^5p]6\u000bg.Y4fe\u0002\nq#\u001b8uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\:\u00021%tG/\u001a:oC2$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0010j]R,'O\\1m)>\u0004\u0018n\u0019*fa2L7-\u0019;j_:4\u0015m\u0019;peV\u0011\u0011\u0011\u0007\t\u0004\u0003\u0006M\u0012bAA\u001b\u0005\n)1\u000b[8si\u0006y\u0012N\u001c;fe:\fG\u000eV8qS\u000e\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003]C3AGA !\u0011\t\t%a\u0015\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n1!\u00199j\u0015\u0011\tI%a\u0013\u0002\u000f),\b/\u001b;fe*!\u0011QJA(\u0003\u0015QWO\\5u\u0015\t\t\t&A\u0002pe\u001eLA!!\u0016\u0002D\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f^\"sK\u0006$Xm\u00144gg\u0016$Hk\u001c9jG\"\u001a1$a\u0017\u0011\t\u0005\u0005\u0013QL\u0005\u0005\u0003?\n\u0019E\u0001\u0003UKN$\u0018A\u0005;fgR\u001c%/Z1uKRCh\u000eV8qS\u000eD3\u0001HA.\u0003i!Xm\u001d;De\u0016\fG/\u001a(p]&sG/\u001a:oC2$v\u000e]5dQ\ri\u00121L\u0001\u0010i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGRIq+!\u001c\u0002\b\u0006E\u0015Q\u0013\u0005\b\u0003_r\u0002\u0019AA9\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0002t\u0005\u0005e\u0002BA;\u0003{\u00022!a\u001eC\u001b\t\tIHC\u0002\u0002|y\na\u0001\u0010:p_Rt\u0014bAA@\u0005\u00061\u0001K]3eK\u001aLA!a!\u0002\u0006\n11\u000b\u001e:j]\u001eT1!a C\u0011\u001d\tII\ba\u0001\u0003\u0017\u000b!\"[:J]R,'O\\1m!\r\t\u0015QR\u0005\u0004\u0003\u001f\u0013%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003's\u0002\u0013!a\u0001\u0019\u0006ia.^7QCJ$\u0018\u000e^5p]ND\u0011\"a&\u001f!\u0003\u0005\r!!\r\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'/A\ruKN$8I]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\u001aTCAAOU\ra\u0015qT\u0016\u0003\u0003C\u0003B!a)\u0002.6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0016\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0006\u0015&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006IB/Z:u\u0007J,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t)L\u000b\u0003\u00022\u0005}\u0015A\n;fgR\u001c%/Z1uKR{\u0007/[2t/&$\bNR8so\u0006\u0014H-\u001b8h\t&\u001c\u0018M\u00197fI\"\u001a\u0011%a\u0017\u0002aQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u001a{'OT8o\u0013:$XM\u001d8bYR{\u0007/[2tQ\r\u0011\u00131L\u00014i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\r>\u00148i\u001c8tk6,'o\u00144gg\u0016$8\u000fV8qS\u000eD3aIA.\u00035\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_J4uN\u001d+y]>3gm]3u)>\u0004\u0018n\u0019\u0015\u0004I\u0005m\u0013\u0001\f;fgR$v\u000e]5d\u000bbL7\u000f^:FeJ|'oU<ba\u001a{'OT8o\u0013:$XM\u001d8bYR{\u0007/[2tQ\r)\u00131L\u00010i\u0016\u001cH\u000fV8qS\u000e,\u00050[:ug\u0016\u0013(o\u001c:To\u0006\u0004hi\u001c:D_:\u001cX/\\3s\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019\u0015\u0004M\u0005m\u0013!\u000b;fgR$v\u000e]5d\u000bbL7\u000f^:FeJ|'oU<ba\u001a{'\u000f\u0016=o\u001f\u001a47/\u001a;U_BL7\rK\u0002(\u00037\nq\u0006^3tiJ+\u0017/^3tiRKW.Z8vi\u0016\u0013(o\u001c:To\u0006\u0004hi\u001c:O_:Le\u000e^3s]\u0006dGk\u001c9jGND3\u0001KA.\u0003E\"Xm\u001d;SKF,Xm\u001d;US6,w.\u001e;FeJ|'oU<ba\u001a{'oQ8ogVlWM](gMN,G\u000fV8qS\u000eD3!KA.\u00031\"Xm\u001d;SKF,Xm\u001d;US6,w.\u001e;FeJ|'oU<ba\u001a{'\u000f\u0016=o\u001f\u001a47/\u001a;U_BL7\rK\u0002+\u00037\nA\u0006^3tiVs7N\\8x]R{\u0007/[2QCJ$\u0018\u000e^5p]\u001a{'OT8o\u0013:$XM\u001d<bYR{\u0007/[2)\u0007-\nY&A\u0018uKN$XK\\6o_^tGk\u001c9jGB\u000b'\u000f^5uS>tgi\u001c:D_:\u001cX/\\3s\u001f\u001a47/\u001a;U_BL7\rK\u0002-\u00037\n!\u0006^3tiVs7N\\8x]R{\u0007/[2QCJ$\u0018\u000e^5p]\u001a{'\u000f\u0016=o\u001f\u001a47/\u001a;U_BL7\rK\u0002.\u00037\n\u0011\u0007^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.T3uC\u0012\fG/Y\"p]R,\u0007\u0010\u001e)bgN\u0004&/\u001b8dSB\fG\u000eK\u0002/\u00037\n\u0001\t^3tiR{\u0007/[2De\u0016\fG/[8o/&$\b.T3uC\u0012\fG/Y\"p]R,\u0007\u0010^,iK:\u0004&/\u001b8dSB\fGnU3sI\u0016tu\u000e\u001e#fM&tW\r\u001a\u0015\u0004_\u0005m\u0013!\u0011;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f['fi\u0006$\u0017\r^1D_:$X\r\u001f;O_J+GO]=Va>tWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ\r\u0001\u00141L\u0001\u0019S:LG/[1mSj,'+Z9vKN$8i\u001c8uKb$H\u0003CA~\u0005#\u0011\u0019Ba\n\u0011\t\u0005u(QB\u0007\u0003\u0003\u007fTAA!\u0001\u0003\u0004\u0005A!/Z9vKN$8O\u0003\u0003\u0003\u0006\t\u001d\u0011AB2p[6|gNC\u0002>\u0005\u0013QAAa\u0003\u0002P\u00051\u0011\r]1dQ\u0016LAAa\u0004\u0002\u0000\nq!+Z9vKN$8i\u001c8uKb$\bbBA8c\u0001\u0007\u0011\u0011\u000f\u0005\b\u0005+\t\u0004\u0019\u0001B\f\u00039Y\u0017MZ6b!JLgnY5qC2\u0004BA!\u0007\u0003$5\u0011!1\u0004\u0006\u0005\u0005;\u0011y\"\u0001\u0003bkRD'\u0002\u0002B\u0011\u0005\u0007\t\u0001b]3dkJLG/_\u0005\u0005\u0005K\u0011YB\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u000f\t%\u0012\u00071\u0001\u0003,\u0005q\u0001O]5oG&\u0004\u0018\r\\*fe\u0012,\u0007C\u0002B\u0017\u0005o\u0011Y$\u0004\u0002\u00030)!!\u0011\u0007B\u001a\u0003\u0011)H/\u001b7\u000b\u0005\tU\u0012\u0001\u00026bm\u0006LAA!\u000f\u00030\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0003\u001a\tu\u0012\u0002\u0002B \u00057\u00111cS1gW\u0006\u0004&/\u001b8dSB\fGnU3sI\u0016\f\u0011\u0004^3ti\u0016\u0013(o\u001c:XSRD7I]3bi&|g.\u00138[WRIqK!\u0012\u0003V\t]#\u0011\f\u0005\b\u0005\u000f\u0012\u0004\u0019\u0001B%\u0003\u0015)'O]8s!\u0011\u0011YE!\u0015\u000e\u0005\t5#\u0002\u0002B(\u0005\u0007\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005'\u0012iE\u0001\u0004FeJ|'o\u001d\u0005\b\u0003_\u0012\u0004\u0019AA9\u0011\u001d\tII\ra\u0001\u0003\u0017C\u0011Ba\u00173!\u0003\u0005\rA!\u0018\u0002\u001b\u0015D\b/Z2uK\u0012,%O]8s!\u0015\t%q\fB%\u0013\r\u0011\tG\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002GQ,7\u000f^#se>\u0014x+\u001b;i\u0007J,\u0017\r^5p]&s'l\u001b\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\r\u0016\u0005\u0005;\ny*\u0001\u000ede\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3WKJLg-\u001f*fgVdG\u000fF\u0005X\u0005[\u0012yG!\u001d\u0003t!9!q\t\u001bA\u0002\t%\u0003bBA8i\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003\u0013#\u0004\u0019AAF\u0011%\u0011)\b\u000eI\u0001\u0002\u0004\u00119(A\bnKR\fG-\u0019;b\u0007>tG/\u001a=u!\u0015\t%qLA~\u0003\u0011\u001a'/Z1uKR{\u0007/[2B]\u00124VM]5gsJ+7/\u001e7uI\u0011,g-Y;mi\u0012\"TC\u0001B?U\u0011\u00119(a(\u0002\u0017\u001d,GOT3x)>\u0004\u0018n\u0019\u000b\t\u0005\u0007\u0013IKa+\u0003.B!!Q\u0011BR\u001d\u0011\u00119I!(\u000f\t\t%%\u0011\u0014\b\u0005\u0005\u0017\u00139J\u0004\u0003\u0003\u000e\nUe\u0002\u0002BH\u0005'sA!a\u001e\u0003\u0012&\u0011\u0011\u0011K\u0005\u0005\u0005\u0017\ty%C\u0002>\u0005\u0013IAA!\u0002\u0003\b%!!1\u0014B\u0002\u0003\u001diWm]:bO\u0016LAAa(\u0003\"\u000692I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u00057\u0013\u0019!\u0003\u0003\u0003&\n\u001d&AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u0005?\u0013\t\u000bC\u0004\u0002pY\u0002\r!!\u001d\t\u0011\u0005Me\u0007%AA\u00021C\u0011\"a&7!\u0003\u0005\r!!\r\u0002+\u001d,GOT3x)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%e\u0005)r-\u001a;OK^$v\u000e]5dI\u0011,g-Y;mi\u0012\u001a\u0004")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ZkAdminManager adminManager() {
        return this.adminManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), Integer.toString(this.requestTimeout()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Short.toString(this.internalTopicReplicationFactor()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        .colon.colon aliveBrokers = new .colon.colon((Object)new Node(0, "host0", 0), (List)new .colon.colon((Object)new Node(1, "host1", 1), (List)Nil$.MODULE$));
        Mockito.reset((Object[])new Object[]{this.metadataCache(), this.controller(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator()});
        Mockito.when((Object)this.metadataCache().getAliveBrokerNodes((ListenerName)ArgumentMatchers.any(ListenerName.class))).thenReturn((Object)aliveBrokers);
    }

    @Test
    public void testCreateOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateTxnTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, 1, (short)1);
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    @Test
    public void testCreateTopicsWithForwardingDisabled() {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        String topicName = "topic";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, false, (Option<RequestContext>)None$.MODULE$);
        ((ZkAdminManager)Mockito.verify((Object)this.adminManager())).createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)this.getNewTopic(topicName, 1, (short)1))}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
    }

    @Test
    public void testInvalidReplicationFactorForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicExistsErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testUnknownTopicPartitionForNonIntervalTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicCreationWithMetadataContextPassPrincipal() {
        String topicName = "topic";
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        AtomicBoolean serializeIsCalled = new AtomicBoolean(false);
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null, userPrincipal, serializeIsCalled){
            private final KafkaPrincipal userPrincipal$1;
            private final AtomicBoolean serializeIsCalled$1;

            public byte[] serialize(KafkaPrincipal principal) {
                Assertions.assertEquals((Object)principal, (Object)this.userPrincipal$1);
                this.serializeIsCalled$1.set(true);
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
            {
                this.userPrincipal$1 = userPrincipal$1;
                this.serializeIsCalled$1 = serializeIsCalled$1;
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, userPrincipal, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        Assertions.assertTrue((boolean)serializeIsCalled.get());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        byte[] utf8_bytes = capturedRequest.requestPrincipal();
        Object var8_8 = null;
        Assertions.assertEquals((Object)userPrincipal, (Object)SecurityUtils.parseKafkaPrincipal((String)new String(utf8_bytes, StandardCharsets.UTF_8)));
    }

    @Test
    public void testTopicCreationWithMetadataContextWhenPrincipalSerdeNotDefined() {
        String topicName = "topic";
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext)));
    }

    @Test
    public void testTopicCreationWithMetadataContextNoRetryUponUnsupportedVersion() {
        String topicName = "topic";
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
        };
        RequestContext requestContext = this.initializeRequestContext(topicName, KafkaPrincipal.ANONYMOUS, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, 0, "client", 1);
        EnvelopeResponse response = new EnvelopeResponse(ByteBuffer.allocate(0), Errors.UNSUPPORTED_VERSION);
        ClientResponse clientResponse = new ClientResponse(header, null, null, 0L, 0L, false, null, null, (AbstractResponse)response);
        ((RequestCompletionHandler)argumentCaptor.getValue()).onComplete(clientResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
    }

    private RequestContext initializeRequestContext(String topicName, KafkaPrincipal kafkaPrincipal, Optional<KafkaPrincipalSerde> principalSerde) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        new CreateTopicsRequestData.CreatableTopicCollection().add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, 1, (short)1));
        ApiVersionsResponseData.ApiVersion createTopicApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.CREATE_TOPICS.id).setMinVersion((short)0).setMaxVersion((short)0);
        Mockito.when((Object)this.brokerToController().controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create(Collections.singleton(createTopicApiVersion))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 0);
        return new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), kafkaPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false, principalSerde);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void testErrorWithCreationInZk(Errors error, String topicName, boolean isInternal, Option<Errors> expectedError) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        block5: {
            block4: {
                this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
                if (!isInternal) break block4;
                switch (topicName == null ? 0 : topicName.hashCode()) {
                    case -970371369: {
                        if (!"__consumer_offsets".equals(topicName)) break;
                        creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()));
                        break block5;
                    }
                    case -253293552: {
                        if (!"__transaction_state".equals(topicName)) break;
                        creatableTopic = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().transactionTopicPartitions()), Predef$.MODULE$.Short2short(this.config().transactionTopicReplicationFactor()));
                        break block5;
                    }
                }
                throw new MatchError((Object)topicName);
            }
            creatableTopic = this.getNewTopic(topicName, 1, (short)1);
        }
        CreateTopicsRequestData.CreatableTopic newTopic = creatableTopic;
        Errors errors = error;
        Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        Map topicErrors = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? null : (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)new ApiError(error))}));
        this.adminManager().createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)newTopic)}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            AutoTopicCreationManagerTest.$anonfun$testErrorWithCreationInZk$1(topicErrors, invocation);
            return BoxedUnit.UNIT;
        });
        this.createTopicAndVerifyResult((Errors)expectedError.getOrElse((Function0 & Serializable)() -> error), topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
    }

    private Option<Errors> testErrorWithCreationInZk$default$4() {
        return None$.MODULE$;
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal, Option<RequestContext> metadataContext) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, metadataContext);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private Option<RequestContext> createTopicAndVerifyResult$default$4() {
        return None$.MODULE$;
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor);
    }

    private int getNewTopic$default$2() {
        return 1;
    }

    private short getNewTopic$default$3() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testErrorWithCreationInZk$1(Map topicErrors$1, InvocationOnMock invocation) {
        ((Function1)invocation.getArgument(5)).apply((Object)topicErrors$1);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

